<?php
defined( 'ABSPATH' ) or exit;

$panel_page = isset( $_REQUEST['panel_page'] ) ? $_REQUEST['panel_page'] : '';
if ( $panel_page == 'searches' ) {
    include YITH_WCCH_TEMPLATE_PATH . '/backend/stats-searches.php';
    die();
} else if ( $panel_page == 'pages' ) {
    include YITH_WCCH_TEMPLATE_PATH . '/backend/stats-pages.php';
    die();
} else if ( $panel_page == 'spent' ) {
    include YITH_WCCH_TEMPLATE_PATH . '/backend/stats-spent.php';
    die();
}

/*
 *  Statistics
 */

global $wpdb;
add_thickbox();

$page = isset( $_GET['p'] ) && $_GET['p'] > 1 ? $_GET['p'] : 1;
$results_per_page = get_option( 'yith-wcch-results_per_page' ) > 0 ? get_option( 'yith-wcch-results_per_page' ) : 50;
$offset = ( $page - 1 ) * $results_per_page;

$rows = $wpdb->get_results( "SELECT COUNT(id) as qta, url FROM {$wpdb->prefix}yith_wcch_sessions WHERE del='0' AND url NOT LIKE '%::%' GROUP BY url" );
$num_rows = $wpdb->num_rows;
$max_pages = ceil( $num_rows / $results_per_page );

?>

<div id="yith-woocommerce-customer-history">
    <div id="statistics" class="wrap">

        <div class="tablenav top">
            <ul class="subsubsub" style="margin-top: 4px;">
                <li class="dashboard"><a href="admin.php?page=yith_wcch_panel&tab=stats" class="current"><?php echo __( 'Dashboard', 'yith-woocommerce-customer-history' ); ?></a> |</li>
                <li class="stats"><a href="admin.php?page=yith_wcch_panel&tab=stats&panel_page=pages"><?php echo __( 'Pages', 'yith-woocommerce-customer-history' ); ?></a> |</li>
                <li class="searches"><a href="admin.php?page=yith_wcch_panel&tab=stats&panel_page=searches"><?php echo __( 'Searches', 'yith-woocommerce-customer-history' ); ?></a> |</li>
                <li class="spent"><a href="admin.php?page=yith_wcch_panel&tab=stats&panel_page=spent"><?php echo __( 'Total spent by user', 'yith-woocommerce-customer-history' ); ?></a></li>
            </ul>
        </div>

        <div id="dashboard">

            <div class="box box-pages">
                <a href="admin.php?page=yith_wcch_panel&tab=stats&panel_page=pages"><h3>Top Pages</h3></a>
                <?php
                $query = "SELECT COUNT(id) as qta, url FROM {$wpdb->prefix}yith_wcch_sessions WHERE del='0' AND url NOT LIKE '%::%' GROUP BY url ORDER BY qta DESC LIMIT 0, 5";
                $rows = $wpdb->get_results( $query );
                if ( count( $rows ) > 0 ) :
                    foreach ( $rows as $key => $value ) :
                        $url = get_site_url() . '/' . $value->url; ?>
                        <div class="row">
                            <strong><?php echo $value->qta; ?></strong>
                            <?php echo $url; ?>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
                <a href="admin.php?page=yith_wcch_panel&tab=stats&panel_page=pages" class="viewall">View all ></a>
            </div>

            <div class="box box-searches">
                <a href="admin.php?page=yith_wcch_panel&tab=stats&panel_page=searches"><h3>Top Searches</h3></a>
                <?php
                $query = "SELECT COUNT(id) as qta, url FROM {$wpdb->prefix}yith_wcch_sessions WHERE del='0' AND url LIKE '%::search::%' GROUP BY url ORDER BY qta DESC LIMIT 0,5";
                $rows = $wpdb->get_results( $query );
                if ( count( $rows ) > 0 ) :
                    foreach ( $rows as $key => $value ) :
                        $url_array = explode( '::', $value->url );
                        if ( $url_array['1'] == 'search' ) :
                            $url = $url_array['2']; ?>
                            <div class="row">
                                <strong><?php echo $value->qta; ?></strong>
                                <?php echo $url; ?></a></td>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                <?php endif; ?>
                <a href="admin.php?page=yith_wcch_panel&tab=stats&panel_page=searches" class="viewall">View all ></a>
            </div>

            <div class="box box-spent">
                <a href="admin.php?page=yith_wcch_panel&tab=stats&panel_page=spent"><h3>Top Customers</h3></a>
                <?php
                $users = get_users();
                $spent = array();
                foreach ( $users as $key => $user) {
                    $order_count = count( get_posts( array(
                        'numberposts' => -1,
                        'meta_key'    => '_customer_user',
                        'meta_value'  => $user->ID,
                        'post_type'   => 'shop_order',
                        'post_status' =>  'any',
                        'post_parent' => '0',
                    ) ) );
                    if ( $order_count > 0 ) {
                        $spent[$user->ID] = yith_ch_get_customer_total_spent( $user->ID );
                    }
                }
                arsort( $spent );
                ?>
                <?php $limit = 1; foreach ( $spent as $key => $value ) : $user = get_user_by( 'id', $key ); ?>
                <div class="row">
                    <strong><?php echo wc_price( $value ); ?></strong>
                    <?php echo esc_html( $user->display_name ); ?>
                </div>
                <?php if ( $limit == 5 ) { return; } else { $limit++; } endforeach; ?>
                <a href="admin.php?page=yith_wcch_panel&tab=stats&panel_page=spent" class="viewall">View all ></a>
            </div>

            <div class="clear"></div>

        </div>

    </div>
</div>
