<?php
/**
 * Affiliate Dashboard Settings
 *
 * @author Your Inspiration Themes
 * @package YITH WooCommerce Affiliates
 * @version 1.0.5
 */

/*
 * This file belongs to the YIT Framework.
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 */

if ( ! defined( 'YITH_WCAF' ) ) {
	exit;
} // Exit if accessed directly
?>

<div class="yith-wcaf yith-wcaf-settings woocommerce">

	<?php
	if( function_exists( 'wc_print_notices' ) ){
		wc_print_notices();
	}
	?>

	<?php do_action( 'yith_wcaf_before_dashboard_section', 'settings' ) ?>

	<div class="left-column <?php echo ( ! $show_right_column ) ? 'full-width' : '' ?>">

		<form method="post">

			<?php do_action( 'yith_wcaf_settings_form_start' ) ?>
	
			<?php if( apply_filters( 'yith_wcaf_payment_email_required', true ) ): ?>
			<p class="form form-row">
				<label for="payment_email"><?php _e( 'Payment email', 'yith-woocommerce-affiliates' ) ?></label>
				<input type="email" name="payment_email" id="payment_email" value="<?php echo $payment_email ?>" />
				<small><?php _e( '(Email address where you want to receive PayPal payments for commissions)', 'yith-woocommerce-affiliates' ) ?></small>
			</p>
			<?php endif; ?>
	
			<?php do_action( 'yith_wcaf_settings_form_after_payment_email' ) ?>
	
			<p class="form form-row">
				<label for="notify_pending_commissions">
					<input type="checkbox" name="notify_pending_commissions" id="notify_pending_commissions" value="yes" <?php checked( $notify_pending_commissions, 'yes' ) ?> />
					<?php _e( 'Notify on new commissions', 'yith-woocommerce-affiliates' ) ?>
				</label>
				<small><?php _e( '(Select this option if you want to be emailed each time a commission status switches to pending)', 'yith-woocommerce-affiliates' ) ?></small>
			</p>
	
			<p class="form form-row">
				<label for="notify_paid_commissions">
					<input type="checkbox" name="notify_paid_commissions" id="notify_paid_commissions" value="yes" <?php checked( $notify_paid_commissions, 'yes' ) ?> />
					<?php _e( 'Notify on commission paid', 'yith-woocommerce-affiliates' ) ?>
				</label>
				<small><?php _e( '(Select this option if you want to be emailed each time a commission is paid)', 'yith-woocommerce-affiliates' ) ?></small>
			</p>
	
			<?php do_action( 'yith_wcaf_settings_form' ) ?>
	
			<input type="submit" name="settings_submit" value="<?php _e( 'Submit', 'yith-woocommerce-affiliates' ) ?>" />
	
		</form>
		
	</div>

	<!--NAVIGATION MENU-->
	<?php
	$atts = array(
		'show_right_column' => $show_right_column,
		'show_left_column' => true,
		'show_dashboard_links' => $show_dashboard_links,
		'dashboard_links' => $dashboard_links
	);
	yith_wcaf_get_template( 'navigation-menu.php', $atts, 'shortcodes' )
	?>

	<?php do_action( 'yith_wcaf_after_dashboard_section', 'settings' ) ?>

</div>