<?php
/**
 * Shortcode Premium class
 *
 * @author Your Inspiration Themes
 * @package YITH WooCommerce Affiliates
 * @version 1.0.0
 */

/*
 * This file belongs to the YIT Framework.
 *
 * This source file is subject to the GNU GENERAL PUBLIC LICENSE (GPL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.txt
 */

if ( ! defined( 'YITH_WCAF' ) ) {
	exit;
} // Exit if accessed directly

if ( ! class_exists( 'YITH_WCAF_Shortcode_Premium' ) ) {
	/**
	 * WooCommerce Affiliate Shortcode Premium
	 *
	 * @since 1.0.0
	 */
	class YITH_WCAF_Shortcode_Premium extends YITH_WCAF_Shortcode {

		/**
		 * Performs all required add_shortcode
		 *
		 * @return void
		 * @since 1.0.0
		 */
		public static function init() {
			parent::init();

			add_shortcode( 'yith_wcaf_set_referrer', array( 'YITH_WCAF_Shortcode_Premium', 'set_referrer' ) );
		}

		/**
		 * Returns output for affiliate code input form
		 *
		 * @param $atts mixed Array of shortcodes attributes
		 *
		 * @return string Shortcode content
		 * @since 1.0.0
		 */
		public static function set_referrer( $atts = array() ) {
			$defaults = array(
				'affiliate_token' => false
			);

			$atts = shortcode_atts( $defaults, $atts );
			extract( $atts );

			if( ! $affiliate_token && $stored_token = YITH_WCAF_Affiliate_Premium()->get_token() ){
				$affiliate_token = $stored_token;
			}

			$permanent_token = ( get_option( 'yith_wcaf_commission_persistent_calculation' ) == 'yes' ) && ( get_option( 'yith_wcaf_avoid_referral_change' ) == 'yes' );

			$atts = array_merge(
				$atts,
				array(
					'enabled' => 'checkout' === get_option( 'yith_wcaf_general_referral_cod', 'query_string' ),
					'affiliate' => $affiliate_token,
					'permanent_token' => $permanent_token
				)
			);

			$template_name = 'form-referrer.php';

			ob_start();

			yith_wcaf_get_template( $template_name, $atts, 'shortcodes' );

			return ob_get_clean();
		}
	}
}