<?php
if( !defined( 'ABSPATH')){
	exit;
}
if(!class_exists('YITH_FUNDS_MultiVendor')){

	class YITH_FUNDS_MultiVendor{

		public function __construct() {

			add_filter( 'ywf_is_available_fund_gateway', array($this, 'check_is_available'), 99, 1 );
			add_filter( 'yith_account_funds_show_recharge_message', array($this, 'check_is_available'), 99, 1 );
			add_filter( 'yith_account_funds_show_discount_message', array($this, 'check_is_available'), 99, 1 );
		}



		/**
		 * @param bool $is_available
		 * @return bool
		 */
		public function check_is_available( $is_available ){

			if( $is_available ){

				if( isset( WC()->cart) && !WC()->cart->is_empty() ){

					foreach( WC()->cart->get_cart_contents() as $cart_item_key => $cart_item ){
						$product = $cart_item['data'];

						$vendor = yith_get_vendor( $product, 'product' );

						if( $vendor->is_valid() ){
							return false;
						}
					}
				}
			}
			return $is_available;
		}

	}
}

new YITH_FUNDS_MultiVendor();