<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<div class="make_a_deposit_checkout">
	<?php

	/**
	 * @Hooks
	 * display_available_user_funds - 10
	 */
	do_action( 'before_make_a_deposit_form' );

	if ( $user_profile_complete ) {

		$hide_form = ( isset( $amount ) && $amount !== '' );
		$min       = ywf_get_min_fund_rechargeable();
		$max       = ywf_get_max_fund_rechargeable();
		$step      = get_option( 'yith_funds_step', 1 );
		$currency  = get_woocommerce_currency();

		$product_id = get_option( '_ywf_deposit_id' );
		$product    = wc_get_product( $product_id );
		$amount     = apply_filters( 'yith_amount_to_deposit', $amount, $currency );
		$hide_form  = $hide_form && ( $amount >= $min && ( $max === '' || $amount <= $max ) );

		$message = sprintf( '<p>%s <strong>%s</strong><a href="" class="ywf_show_form">%s</a></p>', __( 'You are loading', 'yith-woocommerce-account-funds' ), wc_price( $amount ), __( 'Enter a different amount', 'yith-woocommerce-account-funds' ) );
		?>
        <div class="ywf_message_amount <?php echo $hide_form ? 'ywf_show' : ''; ?>">
			<?php echo $message; ?>
        </div>
        <div class="ywf_make_a_deposit_container">
            <div class="ywf_product_image">
				<?php echo $product->get_image( 'woocommerce_single'); ?>
            </div>
            <div class="ywf_summary">
                <h3><?php echo $product->get_title(); ?></h3>

				<?php
				$price_format = get_woocommerce_price_format();
				$currency     = get_woocommerce_currency_symbol();
				$input_number = sprintf( '<input type="number" name="amount_deposit" placeholder="%s" class="ywf_deposit" min="%s"  max="%s" value="%s" step="%s">', __( 'Enter amount', 'yith-woocommerce-account-funds' ), $min, $max, $amount, $step );
				?>
                <form id="make-a-deposit" class="checkout woocommerce-checkout" name="make_a_deposit" method="post">
                    <p class="ywf_amount_input_container <?php echo $hide_form ? 'ywf_hide' : ''; ?>">
                        <label for="amount_deposit"><?php _e( 'Amount', 'yith-woocommerce-account-funds' ); ?></label>
						<?php
						$price_format = get_woocommerce_price_format();
						$currency     = '<span class="ywf_currency_symbol">' . get_woocommerce_currency_symbol() . '</span>';
						echo '<span class="ywf_deposit_content">' . sprintf( $price_format, $currency, $input_number ) . '</span>';
						?>

                    </p>
                    <input type="hidden" name="deposit_nonce" value="<?php echo wp_create_nonce('add_deposit');?>">
                    <input type="submit" class="add_a_deposit_button button" value="<?php echo $product->single_add_to_cart_text();?>">
                </form>
            </div>
        </div>
		<?php
	} else {

		$url                   = wc_get_page_permalink( 'myaccount' );
		$make_deposit_endpoint = apply_filters( 'ywf_make_deposit_slug', 'make-a-deposit' );
		$endpoint_url          = esc_url( add_query_arg( array( 'return_to' => $make_deposit_endpoint ), wc_get_endpoint_url( 'edit-address/billing/', '', $url ) ) );
		$button                = sprintf( '<a href="%s" class="button wc-foward">%s</a>', $endpoint_url, __( 'Complete your profile', 'yith-woocommerce-account-funds' ) );
		$message               = sprintf( '%s %s ', $button, __( 'In order to make a new deposit, you must have completed your user profile. Complete it now!', 'yith-woocommerce-account-funds' ) );
		$messages              = array( $message );
		$messages['messages']  = $messages;
		wc_get_template( 'notices/error.php', $messages );
	}
	do_action( 'after_make_a_deposit_form' );
	?>

</div>