<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'yith_wcds_locate_template' ) ) {
	/**
	 * Locate the templates and return the path of the file found
	 *
	 * @param string $path
	 * @param array $var
	 *
	 * @return void
	 * @since 1.0.0
	 */
	function yith_wcds_locate_template( $path, $var = null ) {
		global $woocommerce;

		if ( function_exists( 'WC' ) ) {
			$woocommerce_base = WC()->template_path();
		} elseif ( defined( 'WC_TEMPLATE_PATH' ) ) {
			$woocommerce_base = WC_TEMPLATE_PATH;
		} else {
			$woocommerce_base = $woocommerce->plugin_path() . '/templates/';
		}

		$template_woocommerce_path = $woocommerce_base . $path;
		$template_path             = '/' . $path;
		$plugin_path               = YWCDS_TEMPLATE_PATH . '/' . $path;

		$located = locate_template( array(
			$template_woocommerce_path, // Search in <theme>/woocommerce/
			$template_path,             // Search in <theme>/
		) );

		if ( ! $located && file_exists( $plugin_path ) ) {
			return apply_filters( 'yith_wcds_locate_template', $plugin_path, $path );
		}

		return apply_filters( 'yith_wcds_locate_template', $located, $path );
	}
}

if ( ! function_exists( 'yith_wcds_get_template' ) ) {
	/**
	 * Retrieve a template file.
	 *
	 * @param string $path
	 * @param mixed $var
	 * @param bool $return
	 *
	 * @return void
	 * @since 1.0.0
	 */
	function yith_wcds_get_template( $path, $var = null, $return = false ) {
		$located = yith_wcds_locate_template( $path, $var );


		if ( $var && is_array( $var ) ) {
			extract( $var );
		}

		if ( $return ) {
			ob_start();
		}

		// include file located
		include( $located );

		if ( $return ) {
			return ob_get_clean();
		}
	}
}

if ( ! function_exists( 'ywcds_format_number' ) ) {

	function ywcds_format_number( $number ) {

		$number = str_replace( get_option( 'woocommerce_price_thousand_sep' ), '', $number );

		return wc_format_decimal( $number );
	}
}

if ( ! function_exists( 'ywcds_get_product_donation_title' ) ) {

	/**
	 * @param WC_Product $product
	 */
	function ywcds_get_product_donation_title( $product ) {

		$donation_name = sprintf( __( 'Donation ( %s )', 'yith-donations-for-woocommerce' ), $product->get_title() );

		return apply_filters( 'ywcds_get_product_donation_title', $donation_name, $product );
	}
}

if ( ! function_exists( 'ywcds_synchronize_product' ) ) {
	function ywcds_synchronize_product() {

		$synchronized = get_option( 'ywcds_sychronized_product', false );
		global $sitepress;

		if ( ! $synchronized && ! is_null( $sitepress ) ) {
			$paged = 1;
			$args  = array(
				'post_type'       => 'product',
				'post_status'     => 'publish',
				'posts_per_page'  => 15,
				'paged'           => $paged,
				'fields'          => 'ids',
				'meta_query'      => array(
					array(
						'key'     => '_ywcds_donation_associate',
						'compare' => 'EXISTS'
					)
				),
				'suppress_filter' => true,
			);

			$product_ids = get_posts( $args );

			while ( count( $product_ids ) > 0 ) {

				foreach ( $product_ids as $product_id ) {


					$associate  = get_post_meta( $product_id, '_ywcds_donation_associate', true );
					$compulsive = get_post_meta( $product_id, '_ywcds_donation_obligatory', true );
					$translation_ids = $sitepress->get_element_translations( $product_id, 'product' );

					foreach( $translation_ids as $translation ){
						$translated_id = $translation->element_id;
						update_post_meta( $translated_id, '_ywcds_donation_associate', $associate );
						update_post_meta( $translated_id, '_ywcds_donation_obligatory', $compulsive );
					}


				}

				$paged ++;

				$args['paged'] = $paged;

				$product_ids = get_posts( $args );
			}
		}

		update_option( 'ywcds_sychronized_product', true );

	}
}

add_action( 'admin_init', 'ywcds_synchronize_product' );