<?php $product_price = apply_filters('yith_wcbpg_product_price', yit_get_display_price($best_price->product), $best_price->customer_currency, 'admin'); ?>

<?php $shop_currency = get_option ( 'woocommerce_currency' ); ?>


<div class="ywcbpg-email-notification admin">
    <table>
        <thead>
        <tr>
            <th class="product-name" colspan="2"><?php esc_html_e('Product','yith-best-price-guaranteed-for-woocommerce');?></th>
            <th><?php esc_html_e('Price','yith-best-price-guaranteed-for-woocommerce'); ?></th>
        </tr>
        </thead>
        <tbody>
        <tr>
            <td>
                <img src="<?php echo $best_price->product->get_image_id() ? esc_attr( current( wp_get_attachment_image_src( $best_price->product->get_image_id(), 'thumbnail' ) ) ) : wc_placeholder_img_src() // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped?>" alt="<?php esc_html_e ( 'Product image', 'woocommerce' ) ;?>">
            </td>
            <td>
                <?php echo esc_html( $best_price->get_product_title() ); ?>
            </td>
            <td>
                <span><?php echo $product_price . ' ' . get_woocommerce_currency_symbol($shop_currency); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></span>
            </td>
        </tr>
        </tbody>
    </table>
    <div class="user-info">
        <?php if( email_exists( $best_price->user_email ) ): ?>
            <?php $user = get_user_by( 'email',$best_price->user_email ); ?>
        <?php endif; ?>
        <h3>
            <?php esc_html_e( 'Message details','yith-best-price-guaranteed-for-woocommerce' ); ?>
        </h3>
        <ul>
            <li>
                <?php
                $user_display_name = '';
                if( isset($user) ){
                    $user_display_name = $user->user_login;
                }else{
                    $user_display_name = ($best_price->user_name != '') ? $best_price->user_name :  __( 'Unregistered', 'yith-best-price-guaranteed-for-woocommerce' );
                }
                ?>
                <b><?php esc_html_e( 'User','yith-best-price-guaranteed-for-woocommerce' );?></b>: <?php echo esc_html( $user_display_name ); ?>
            </li>
            <li>
                <b><?php esc_html_e('Email address','yith-best-price-guaranteed-for-woocommerce');?></b>: <?php echo esc_html( $best_price->user_email ); ?>
            </li>
            <li>
                <b><?php esc_html_e('Suggested price','yith-best-price-guaranteed-for-woocommerce');?></b>: <?php echo $best_price->suggested_price . get_woocommerce_currency_symbol($shop_currency); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
            </li>
            <li>
                <b><?php esc_html_e('Qualifying competitor website','yith-best-price-guaranteed-for-woocommerce');?></b>: <a href="<?php echo esc_url( $best_price->get_site_url(true) ); ?>" target="_blank"><?php echo esc_url( $best_price->get_site_url() ); ?></a>
            </li>
            <li>
                <?php if( isset( $best_price->note )): ?>
                    <b><?php esc_html_e('Notes','yith-best-price-guaranteed-for-woocommerce');?></b>: <?php echo esc_html( $best_price->note ); ?>
                <?php endif; ?>
            </li>           
        </ul>
    </div>
    <a href="<?php echo esc_url( $link_to_post );?>"><?php esc_html_e( 'View request details','yith-best-price-guaranteed-for-woocommerce' ); ?></a>
</div>


