<?php
	
	
	
	//add_filter('wpvr_filter_videos_found' , 'wpvr_add_extra_videos' , 100 , 3 );
	function wpvr_add_extra_videos( $videosFound , $options , $api_response ){
		
		
		$data         = wpvr_json_decode( $api_response['data'] );
		
		//d( $data );
		if( $videosFound['oldest_video_date'] === false ){
			$oldest_video_date = new Datetime('now');
		}else {
			//Getting the oldest Video among all the last 19 recalls results
			$oldest_video_date = DateTime::createFromFormat( 'U', $videosFound['oldest_video_date'] );
		}
		
		
		//Debug Only
		if ( $videosFound['recalls'] >= 19 ) {
			
			wpvr__d( array(
				'oldest_video_date' => $oldest_video_date->format( 'Y-m-d H:i:s' ),
				'totalResults' => $data->pageInfo->totalResults,
				'hasNextPage' => isset( $data->nextPageToken ) ? 'HAS NEXT' : 'DOES NOT HAVE NEXT',
				'recalls' => $videosFound['recalls'],
				'real_count' => $videosFound['real_count'],
				'get_videos_older_than' => $videosFound['get_videos_older_than'],
				'nextPageToken' => $videosFound['nextPageToken'],
				'args_pageToken' => isset( $api_response['caller']['args']['pageToken'] ) ? $api_response['caller']['args']['pageToken'] : '#NONE',
				'args_publishedBefore' => isset( $api_response['caller']['args']['publishedBefore'] ) ? $api_response['caller']['args']['publishedBefore'] : '#NONE',
				'dupCount' => $videosFound['dupCount'],
				// 'items' => $data->items
			) );
		}
		
		if (
			$videosFound['recalls'] !== 0
			&& $videosFound['recalls'] % 19 === 0
		
		) {
			
			//Restart the query from 0
			$videosFound['nextPageToken'] = 1;
			//Getting videos older that that oldest video
			$videosFound['get_videos_older_than'] = $oldest_video_date->format( 'Y-m-d\Th:i:s\Z' );
		}
		
		
		if (
			$videosFound['nextPageToken'] == 'end'
			&& $videosFound['get_videos_older_than'] !== false
			&& $videosFound['get_videos_older_than'] !== $oldest_video_date->format( 'Y-m-d\Th:i:s\Z' )
		) {
			// $oldestVideo = DateTime::createFromFormat( 'U', $videosFound['oldest_video_date'] );
			
			//Restart the query from 0
			$videosFound['nextPageToken'] = 1;
			//Getting videos older that that oldest video
			$videosFound['get_videos_older_than'] = $oldest_video_date->format( 'Y-m-d\Th:i:s\Z' );
		}
		
		
		return $videosFound;
	}