<?php
	
	
	/* Validate Token  */
	$vs['validate_token'] = function () use ( $vs, $pid_suffix ) {
		// return false;
		
		global $wpvr_tokens;
		if ( ! isset( $wpvr_tokens[ $vs['id'] ]['access_token'] ) ) {
			return false;
		}
		$access_token = $wpvr_tokens[ $vs['id'] ]['access_token'];
		if ( $access_token == '' ) {
			return false;
		}
		
		$now = new DateTime( 'now', new DateTimeZone( 'UTC' ) );
		if ( isset( $wpvr_tokens[ $vs['id'] ]['expiration'] ) ) {
			//We have an expiration, no need to validate
			return $wpvr_tokens[ $vs['id'] ]['expiration'] > $now->format( 'U' );
		}
		
		$api_url  = 'https://www.googleapis.com/oauth2/v1/tokeninfo';
		$api_args = array(
			'access_token' => $access_token,
		);
		
		$api_response = wpvr_make_curl_request( $api_url, $api_args );
		
		// d( $api_response );
		if ( $api_response['status'] != 200 ) {
			return false;
		}
		if ( isset( $api_response['json']['error'] ) && $api_response['json']['error'] == 'invalid_token' ) {
			return false;
		} else {
			return true;
		}
	};
	
	/* REnew Token  */
	$vs['renew_token'] = function () use ( $vs, $pid_suffix ) {
		global $wpvr_tokens;
		$service = $vs['id'];
		if (
			! isset( $wpvr_tokens[ $service ]['access_token'] )
			|| ! isset( $wpvr_tokens[ $service ]['refresh_token'] )
		) {
			return false;
		}
		
		
		$api_response = wpvr_make_curl_request( WPVR_AUTH_URL, array(
			'refresh'       => 1,
			'key'           => WPVR_AUTH_KEY,
			'service'       => $service,
			'access_token'  => $wpvr_tokens[ $service ]['access_token'],
			'refresh_token' => $wpvr_tokens[ $service ]['refresh_token'],
		) );
		// echo $api_response['data'];
		// d( $api_response );
		//return false;
		
		if ( $api_response['status'] != 200 ) {
			return false;
		}
		$response_body = wpvr_object_to_array( wpvr_json_decode( $api_response['data'] ) );
		$data          = $response_body['data'];
		if ( ! isset( $data['access_token'] ) ) {
			return false;
		}
		
		if ( $data['access_token'] === false ) {
			return false;
		}
		
		$now = new DateTime( 'now', new DateTimeZone( 'UTC' ) );
		
		$wpvr_tokens[ $service ]['access_token'] = $data['access_token'];
		$wpvr_tokens[ $service ]['expiration']   = 0;
		
		if ( isset( $data['expires_in'] ) ) {
			$wpvr_tokens[ $service ]['expiration'] = intval( $now->format( 'U' ) ) + intval( $data['expires_in'] );
		}
		
		wpvr_update_option( 'wpvr_tokens', $wpvr_tokens );
		
		return $data['access_token'];
		
	};
	
	/* Auth Access to API service  */
	$vs['api_connect'] = function () use ( $vs, $pid_suffix ) {
		global $wpvr_tokens, $wpvr_options;
		$service    = $vs['id'];
		$api_access = array(
			'service' => $service,
			'type'    => '',
			'value'   => '',
		);
		
		if ( WPVR_FORCE_CREDENTIALS_API_CONNECT === true ) {
			$conn_type = 'advanced';
		} elseif ( $wpvr_options['apiConnect'] == 'wizzard' || $wpvr_options['apiConnect'] == 'wizard' ) {
			$conn_type = 'wizard';
		} elseif ( $wpvr_options['apiConnect'] == 'advanced' ) {
			$conn_type = 'advanced';
		} else {
			$conn_type = 'none';
		}
		
		if ( $conn_type == 'wizard' ) {
			
			// Using the api wizzard to connect to the service API
			if (
				isset( $wpvr_tokens[ $service ]['access_token'] )
				&& (
					$wpvr_tokens[ $service ]['access_token'] == ''
					|| $wpvr_tokens[ $service ]['access_token'] === false
				)
			) {
				// There is no acces token for this service : Ask for one ! 
				$api_access['type']  = 'manual_access_grant';
				$api_access['value'] = false;
				
			} elseif ( $vs['validate_token']() === false ) {
				// access token renewed
				$api_access['type']  = 'access_token';
				$api_access['value'] = $vs['renew_token']();
			} else {
				// The API Service token is still valid 
				//echo "SERVICE TOKEN IS VALID";
				$api_access['type']  = 'access_token';
				$api_access['value'] = $wpvr_tokens[ $service ]['access_token'];
			}
		} elseif ( $conn_type == 'advanced' ) {
			if ( $vs['api_key_name'] == '' ) {
				// No API Key DEfined 
				if ( WPVR_ALLOW_DEFAULT_API_CREDENTIALS ) {
					// Using DEfault API KEY 
					$api_access['type']  = 'credentials';
					$api_access['value'] = WPVR_DEFAULT_YOUTUBE_API_KEY;
				} else {
					// REfusing access since no api credentials is used 
					$api_access['type']  = 'no_credentials';
					$api_access['value'] = false;
				}
			} else {
				// Using User defined Youtube API Key 
				$api_access['type']  = 'credentials';
				$api_access['value'] = $vs['api_key_name'];
			}
		}
		
		return $api_access;
	};
	
	/* Auth Access to API service  */
	$vs['api_auth_'] = function () use ( $vs, $pid_suffix ) {
		return false;
	};
	
	/* api auth FUNCTION of youtbe */
	$vs['api_auth'] = function ( $show_messages = true ) use ( $vs, $pid_suffix ) {
		
		$api_access = $vs['api_connect']();
		
		if ( $api_access['type'] == 'manual_access_grant' ) {
			
			// There is no acces token for this service : Ask for one !
			if ( $show_messages === true ) {
				wpvr_render_error_notice( $vs['msgs']['authentication_error'] );
			}
			
			return false;
			
		} elseif ( $api_access['type'] == 'manual_access_refresh' ) {
			
			// Refresh Token Access
			if ( $show_messages === true ) {
				wpvr_render_error_notice( $vs['msgs']['obsolete_access'] );
			}
			
			return false;
			
		} elseif ( $api_access['type'] == 'no_credentials' ) {
			
			// REfuse access since no api credentials is used
			if ( $show_messages === true ) {
				wpvr_render_error_notice( $vs['msgs']['authentication_error'] );
			}
			
			return false;
			
		} elseif ( $api_access['type'] == 'credentials' ) {
			// Connecting to Youtube using CREDENTIALS
			return array(
				'method' => 'key',
				'value'  => $api_access['value'],
			);
		} elseif ( $api_access['type'] == 'access_token' ) {
			// Connecting to Youtube Using Access Token
			return array(
				'method' => 'access_token',
				'value'  => $api_access['value'],
			);
		}
		
		return false;
	};