<?php
	
	class WPVR_Meta_Videos {
		public $version;
		public $use_class;
		public $local_version;
		public $post_type;
		public $cache_meta;
		public $debug_mode;
		public $use_default_tables;
		
		function __construct( $current_version ) {
			
			$this->version        = $current_version;
			$this->local_version  = get_option( 'wpvr_meta_migration_done' );
			$this->post_type      = wpvr_cpt_get_handled_types( 'all' );
			$this->debug_mode     = true;
			$this->cache_meta     = true;
			$this->use_default_tables = get_option( 'wpvr_meta_migration_use_default_tables' ) === '1' ? true : false;
			
			//Show Migration message?
			if ( $this->use_default_tables === true ) {
				//Use default is TRUE or force is false
				$this->use_class = false;
				wpvr_remove_notice( 'wpvr_ask_for_migration' );
			} else {
				if (
					$this->local_version === ''
					|| $this->local_version === false
					|| version_compare( $this->local_version , $this->version , '<' )
				) {
					//Need to do Migration
					$this->use_class = false;
					wpvr_show_metadata_upgrade_message( 'wpvr_ask_for_migration' );
				} else {
					//Migration Done
					$this->use_class = true;
					wpvr_remove_notice( 'wpvr_ask_for_migration' );
				}
			}
			
			//Hook new table to WP PostMeta
			add_filter( 'plugins_loaded' , array( &$this , 'register_meta_table' ) , 10 );
			
			do_action( 'wpvr_event_meta_construct' , $this->post_type );
			
			if ( $this->use_class === true ) {
				//Hook to WP PostMeta Add and Update
				add_filter( 'update_post_metadata' , array( &$this , 'hook_custom_meta_update' ) , 0 , 4 );
				add_filter( 'add_post_metadata' , array( &$this , 'hook_custom_meta_update' ) , 0 , 4 );
				
				//Hook to WP PostMeta Delete
				add_filter( 'delete_post_metadata' , array( &$this , 'hook_custom_meta_delete' ) , 0 , 3 );
				
				//Hook to WP PostMeta Get
				add_filter( 'get_post_metadata' , array( &$this , 'hook_custom_meta_get' ) , 0 , 4 );
				
				//Hook into WPVR Get Videos
				add_filter( 'wpvr_extend_video_meta_table' , array( &$this , 'hook_video_meta_table' ) , 0 , 1 );
				
				//Hook into WPVR Get Videos Query
				add_filter( 'pre_get_posts' , array( &$this , 'hook_video_meta_query' ) , 100000 , 1 );
			}
		}
		
		public function hook_video_meta_query( $query ) {
			
			$query_post_type = $query->get( 'post_type' );
			if ( ! is_array( $query_post_type ) ) {
				$query_post_type = array( $query_post_type );
			}
			
			$intersection = (array) array_intersect( $query_post_type , $this->post_type );
			if ( count( $intersection ) == 0 ) {
				return $query;
			}
			
			add_filter( 'posts_join_request' , array( $this , 'hook_video_meta_query_replacements' ) , 100 , 2 );
			add_filter( 'posts_where_request' , array( $this , 'hook_video_meta_query_replacements' ) , 100 , 2 );
			add_filter( 'posts_orderby_request' , array( $this , 'hook_video_meta_query_replacements' ) , 100 , 2 );
			add_filter( 'posts_groupby_request' , array( $this , 'hook_video_meta_query_replacements' ) , 100 , 2 );
			
			
			return $query;
		}
		
		public function hook_video_meta_query_replacements( $sql , $query ) {
			global $wpdb;
			
			$query_post_type = $query->get( 'post_type' );
			if ( ! is_array( $query_post_type ) ) {
				$query_post_type = array( $query_post_type );
			}
			
			$intersection = (array) array_intersect( $query_post_type , $this->post_type );
			if ( count( $intersection ) == 0 ) {
				return $sql;
			}
			
			$video_meta_table = apply_filters( 'wpvr_extend_video_meta_table' , array(
				'name' => $wpdb->postmeta ,
				'id'   => 'post_id' ,
			) );
			
			$replaced_sql = str_replace( array(
				$wpdb->postmeta ,
				'post_id' ,
			) , array(
				$video_meta_table[ 'name' ] ,
				$video_meta_table[ 'id' ] ,
			) , $sql );
			
			return $replaced_sql;
		}
		
		public function hook_video_meta_table( $meta_table ) {
			global $wpdb;
			
			
			return array(
				'name' => $wpdb->videometa ,
				'id'   => 'video_id' ,
			);
			
		}
		
		public function register_meta_table() {
			global $wpdb;
			$wpdb->videometa = $wpdb->prefix . 'wpvr_video_meta';
		}
		
		public function install_meta_table() {
			
			if ( get_option( $this->indicator ) != $this->version ) {
				$msg = array();
				
				
				$this->construct_meta_table();
				$msg[] = 'Created/Updated new custom meta table for videos.';
				
				if ( $this->check_old_meta_rows() != 0 ) {
					
					$msg[] = 'Found existing meta rows that need to be moved to the new created table.';
					
					//Construct the new custom meta table
					$done  = $this->move_old_meta_rows();
					$msg[] = sprintf(
						'Inserted %s meta rows to the new table and deleted %s meta rows from the WP postmeta table.' ,
						$done[ 'created' ] ,
						$done[ 'deleted' ]
					);
				}
				
				//Update Indicator
				update_option( $this->indicator , $this->version );
				
				if ( $this->debug_mode ) {
					wpvr_add_notice( array(
						'slug'      => 'meta_framework' ,
						'title'     => 'WP Video Robot Meta Framework (v' . $this->version . '):' ,
						'class'     => 'error' , //updated or warning or error
						'content'   => implode( '<br/>' , $msg ) ,
						'hidable'   => false ,
						'is_dialog' => false ,
						'show_once' => true ,
					) );
				}
				
			}
		}
		
		static function construct_meta_table() {
			global $wpdb;
			
			require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
			
			//Create Custom Table if it does not exist
			$done = @dbDelta( "CREATE TABLE {$wpdb->prefix}wpvr_video_meta (
				`meta_id` INT(9) unsigned NOT NULL AUTO_INCREMENT,
				`video_id` INT(9) unsigned NOT NULL DEFAULT '0',
				`key_id` bigint(20) unsigned NOT NULL DEFAULT '0',
				`meta_key` varchar(100)  COLLATE utf8mb4_unicode_ci NOT NULL,
				`meta_value` longtext COLLATE utf8mb4_unicode_ci,
				PRIMARY KEY (`video_id` , `meta_key` , `meta_id`),
				INDEX meta_id_index_meta (`meta_id`),
				INDEX `meta_key_index_meta` (`meta_key`)
			) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci" );
			
		}
		
		public function check_old_meta_rows( $post_type = null ) {
			global $wpdb;
			
			$post_type_array = $post_type !== null ? array( $post_type ) : $this->post_type;
			
			$sql
				= "
			select
				count( meta_id ) as count
			from
				{$wpdb->prefix}postmeta M
				LEFT JOIN {$wpdb->prefix}posts P on P.ID = M.post_id
            where
            	P.post_type IN ('" . implode( "','" , $post_type_array ) . "')
			";
			
			return (int) $wpdb->get_var( $sql );
		}
		
		public function move_old_meta_rows( $post_type = null ) {
			global $wpdb;
			
			$post_type_array = $post_type !== null ? array( $post_type ) : $this->post_type;
			
			$sql_add
				= "
			INSERT into {$wpdb->videometa} (video_id , meta_key , meta_value )
			select
				post_id,meta_key,meta_value
			from
				{$wpdb->prefix}postmeta M
				LEFT JOIN {$wpdb->prefix}posts P on P.ID = M.post_id
            where
            	P.post_type IN ('" . implode( "','" , $post_type_array ) . "')
			";
			
			$created_rows = $wpdb->query( $sql_add );
			
			return $created_rows;
		}
		
		public function clean_old_meta_rows( $post_type = null ) {
			global $wpdb;
			
			$post_type_array = $post_type !== null ? array( $post_type ) : $this->post_type;
			
			$sql_delete
				= "
				DELETE from {$wpdb->prefix}postmeta where post_id IN (
					select
						P.ID
					from
						{$wpdb->prefix}posts P
					where
		                P.post_type IN ('" . implode( "','" , $post_type_array ) . "')
				)
			";
			
			$deleted_rows = $wpdb->query( $sql_delete );
			
			return $deleted_rows;
		}
		
		public function move_old_selection_meta_rows( $post_ids ) {
			global $wpdb;
			
			$sql_add
				= "
			INSERT into {$wpdb->videometa} (video_id , meta_key , meta_value )
			select
				post_id,meta_key,meta_value
			from
				{$wpdb->prefix}postmeta M
				LEFT JOIN {$wpdb->prefix}posts P on P.ID = M.post_id
            where
            	P.ID IN ('" . implode( "','" , $post_ids ) . "')
			";
			
			$created_rows = $wpdb->query( $sql_add );
			
			return $created_rows;
		}
		
		public function clean_old_selection_meta_rows( $post_ids ) {
			global $wpdb;
			
			$sql_delete
				= "
				DELETE from {$wpdb->prefix}postmeta where post_id IN (
					select
						P.ID
					from
						{$wpdb->prefix}posts P
					where
		                P.ID IN ('" . implode( "','" , $post_ids ) . "')
				)
			";
			
			$deleted_rows = $wpdb->query( $sql_delete );
			
			return $deleted_rows;
		}
		
		public function hook_custom_meta_delete( $check , $object_id , $meta_key ) {
			
			if ( ! wpvr_cpt_is_handled_type( get_post_type( $object_id ) , true ) ) {
				return $check;
			}
			
			return delete_metadata( 'video' , $object_id , $meta_key );
		}
		
		public function hook_custom_meta_get( $check , $object_id , $meta_key , $single ) {
			
			
			if ( ! wpvr_cpt_is_handled_type( get_post_type( $object_id ) , true ) ) {
				return $check;
			}
			
			if ( $meta_key == '' && $single ) {
				return null;
			}
			
			$meta_value = get_metadata( 'video' , $object_id , $meta_key , $single );
			
			return $single ? array( $meta_value ) : $meta_value;
		}
		
		public function hook_custom_meta_update( $check , $object_id , $meta_key , $meta_value ) {
			if ( ! wpvr_cpt_is_handled_type( get_post_type( $object_id ) , true ) ) {
				return $check;
			}
			
			return update_metadata( 'video' , $object_id , $meta_key , $meta_value );
		}
	}
	
	new WPVR_Meta_Videos( WPVR_META_MIGRATION_VERSION );
	