<?php
	
	class WPVR_Meta_Sources {
		public $version;
		public $use_class;
		public $local_version;
		public $post_type;
		public $debug_mode;
		public $use_default_tables;
		
		function __construct( $current_version ) {
			
			
			
			$this->version            = $current_version;
			$this->local_version      = get_option( 'wpvr_meta_migration_done' );
			$this->post_type          = WPVR_SOURCE_TYPE;
			$this->debug_mode         = true;
			$this->use_default_tables = get_option( 'wpvr_meta_migration_use_default_tables' ) === '1' ? true : false;
			
			
			//Show Migration message?
			if ( $this->use_default_tables === true ) {
				//Use default is TRUE or force is false
				$this->use_class = false;
				wpvr_remove_notice( 'wpvr_ask_for_migration' );
			} else {
				if (
					$this->local_version === ''
					|| $this->local_version === false
					|| version_compare( $this->local_version , $this->version , '<' )
				) {
					//Need to do Migration
					$this->use_class = false;
					wpvr_show_metadata_upgrade_message( 'wpvr_ask_for_migration' );
				} else {
					//Migration Done
					$this->use_class = true;
					wpvr_remove_notice( 'wpvr_ask_for_migration' );
				}
			}
			
			
			//Hook new table to WP PostMeta
			add_filter( 'plugins_loaded' , array( &$this , 'register_meta_table' ) , 10 );
			
			do_action( 'wpvr_event_meta_construct' , $this->post_type );
			// d( $this->use_class );
			if ( $this->use_class === true ) {
				
				//Hook to WP PostMeta Add and Update
				add_filter( 'update_post_metadata' , array( &$this , 'hook_custom_meta_update' ) , 0 , 4 );
				add_filter( 'add_post_metadata' , array( &$this , 'hook_custom_meta_update' ) , 0 , 4 );
				
				//Hook to WP PostMeta Delete
				add_filter( 'delete_post_metadata' , array( &$this , 'hook_custom_meta_delete' ) , 0 , 3 );
				
				//Hook to WP PostMeta Get
				add_filter( 'get_post_metadata' , array( &$this , 'hook_custom_meta_get' ) , 0 , 4 );
				
				//Hook into WPVR Get Sources
				add_filter( 'wpvr_extend_source_meta_table' , array( &$this , 'hook_source_meta_table' ) , 0 , 1 );
				
				//Hook into WPVR Get Sources Query
				add_filter( 'pre_get_posts' , array( &$this , 'hook_source_meta_query' ) , 11 , 1 );
			}
		}
		
		public function hook_source_meta_query( $query ) {
			
			
			if ( $query->get( 'post_type' ) !== $this->post_type ) {
				return $query;
			}
			
			if ( $query->get( 'meta_query' ) === array() ) {
				return $query;
			}
			
			$query->set( 'update_post_meta_cache' , false );
			$query->set( 'update_post_term_cache' , false );
			
			add_filter( 'posts_join_request' , array( $this , 'hook_source_meta_query_replacements' ) , 10000 , 2 );
			add_filter( 'posts_where_request' , array( $this , 'hook_source_meta_query_replacements' ) , 10000 , 2 );
			
			return $query;
		}
		
		public function hook_source_meta_query_replacements( $sql , $query ) {
			global $wpdb;
			
			if ( $query->get( 'post_type' ) !== $this->post_type ) {
				return $sql;
			}
			
			if ( $query->get( 'meta_query' ) === array() ) {
				return $sql;
			}
			
			$source_meta_table = apply_filters( 'wpvr_extend_source_meta_table' , array(
				'name' => $wpdb->postmeta ,
				'id'   => 'post_id' ,
			) );
			
			$replaced_sql = str_replace( array(
				$wpdb->postmeta ,
				'post_id' ,
			) , array(
				$source_meta_table[ 'name' ] ,
				$source_meta_table[ 'id' ] ,
			) , $sql );
			
			//d( $replaced_sql, $sql );
			
			return $replaced_sql;
		}
		
		public function hook_source_meta_table( $meta_table ) {
			global $wpdb;
			
			return array(
				'name' => $wpdb->sourcemeta ,
				'id'   => 'source_id' ,
			);
		}
		
		public function register_meta_table() {
			global $wpdb;
			$wpdb->sourcemeta = $wpdb->prefix . 'wpvr_source_meta';
		}
		
		static function construct_meta_table() {
			global $wpdb;
			
			require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
			
			//Create Custom Table if it does not exist
			$done = @dbDelta( "CREATE TABLE {$wpdb->prefix}wpvr_source_meta (
				`meta_id` INT(9) unsigned NOT NULL AUTO_INCREMENT,
				`source_id` INT(9) unsigned NOT NULL DEFAULT '0',
				`key_id` bigint(20) unsigned NOT NULL DEFAULT '0',
				`meta_key` varchar(100)  COLLATE utf8mb4_unicode_ci NOT NULL,
				`meta_value` longtext COLLATE utf8mb4_unicode_ci,
				PRIMARY KEY (`source_id` , `meta_key` , `meta_id`),
				INDEX meta_id_index_meta (`meta_id`),
				INDEX `meta_key_index_meta` (`meta_key`)
			) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci" );
			
		}
		
		public function check_old_meta_rows() {
			global $wpdb;
			
			$sql
				= "
			select
				count( meta_id ) as count
			from
				{$wpdb->prefix}postmeta M
				LEFT JOIN {$wpdb->prefix}posts P on P.ID = M.post_id
            where
            	P.post_type = '{$this->post_type}'
			";
			
			return (int) $wpdb->get_var( $sql );
		}
		
		public function move_old_meta_rows() {
			global $wpdb;
			
			
			$sql_add
				= "
			INSERT into {$wpdb->sourcemeta} (source_id , meta_key , meta_value )
			select
				post_id,meta_key,meta_value
			from
				{$wpdb->prefix}postmeta M
				LEFT JOIN {$wpdb->prefix}posts P on P.ID = M.post_id
            where
            	P.post_type = '{$this->post_type}'
			";
			
			$created_rows = $wpdb->query( $sql_add );
			
			return $created_rows;
		}
		
		public function clean_old_meta_rows() {
			global $wpdb;
			
			$sql_delete
				= "
				DELETE from {$wpdb->prefix}postmeta where post_id IN (
					select
						P.ID
					from
						{$wpdb->prefix}posts P
					where
		                P.post_type = '{$this->post_type}'
				)
			";
			
			$deleted_rows = $wpdb->query( $sql_delete );
			
			return $deleted_rows;
		}
		
		public function hook_custom_meta_delete( $check , $object_id , $meta_key ) {
			
			if ( get_post_type( $object_id ) !== WPVR_SOURCE_TYPE ) {
				return $check;
			}
			
			return delete_metadata( 'source' , $object_id , $meta_key );
		}
		
		public function hook_custom_meta_get( $check , $object_id , $meta_key , $single ) {
			
			if ( get_post_type( $object_id ) !== WPVR_SOURCE_TYPE ) {
				return $check;
			}
			
			if ( $meta_key == '' && $single ) {
				return null;
			}
			
			$meta_value = get_metadata( 'source' , $object_id , $meta_key , $single );
			
			return $single ? array( $meta_value ) : $meta_value;
		}
		
		public function hook_custom_meta_update( $check , $object_id , $meta_key , $meta_value ) {
			if ( get_post_type( $object_id ) !== WPVR_SOURCE_TYPE ) {
				return $check;
			}
			
			$done = update_metadata( 'source' , $object_id , $meta_key , $meta_value );
			
			return $done;
		}
	}
	
	new WPVR_Meta_Sources( WPVR_META_MIGRATION_VERSION );