<?php
	global $wpvr_pages;
	$wpvr_pages = true;
	
	if ( WPVR_IS_DEMO ) {
		wpvr_refuse_access();
		
		return false;
	}

?>

<div class="wrap wpvr_wrap " style="<?php wpvr_echo_display_none(); ?>">
<?php wpvr_show_logo(); ?>
    <h2 class="wpvr_title">
        <i class="wpvr_title_icon fa fa-info"></i>
		<?php echo __( 'System Information', WPVR_LANG ); ?>
    </h2>
<?php
	
	$system_info = wpvr_get_system_info();
	
	$left_columns = $right_columns = '';
	$i            = 0;
	foreach ( (array) $system_info['sys'] as $sys ) {
		
		$i ++;
		
		if ( ! is_bool( $sys['value'] ) ) {
			$value = $sys['value'];
		} elseif ( $sys['value'] ) {
			$value = "TRUE";
		} else {
			$value = "FALSE";
		}
		
		if ( $sys['status'] == 'good' ) {
			$icon = 'check';
		} elseif ( $sys['status'] == 'bad' ) {
			$icon = 'ban';
		} else {
			$icon = 'cog';
		}
		
		$line
			= '
                <div class="wpvr_syst_info ' . $sys['status'] . '">
                    <i class="fa fa-' . $icon . '"></i>
                    <strong>' . $sys['label'] . '</strong> : ' . $sys['value'] . '
                </div>
            ';
		
		if ( $i <= ( count( $system_info['sys']  ) / 2 ) ) {
			$left_columns .= $line;
		} else {
			$right_columns .= $line;
		}
		
	}

?>
    <div class="wpvr_standalone_system_info">
        <div class="wpvr_standalone_system_info_header">
            <button class="pull-left wpvr_button wpvr_black_button wpvr_standalone_system_info_export">
                <i class="fa fa-download"></i>
                <?php echo __('Export System Info' , WPVR_LANG ); ?>
            </button>
            <div class="wpvr_clearfix"></div>
        </div>
        <table class="wpvr_sys_info_table">
            <tr>
                <td><?php echo $left_columns; ?></td>
                <td><?php echo $right_columns; ?></td>
            </tr>
        </table>
        <div id="wpvr_export" style="display:none;visibility:hidden;"></div>
        
    </div>