<?php
	
	
	class WPVR_Notices {
		
		public $count;
		public $options;
		public $local_version;
		public $notices = array();
		public $user_dismissed = array();
		
		function __construct( $options = array() ) {
			
			$this->local_version = get_option( 'wpvr_notices_install_version' );
			
			$this->options = wp_parse_args( $options , array(
				'user_id'    => null ,
				'stack_mode' => null ,
				'version'    => null ,
			) );
			
			//Install WPVR Notices
			$this->install();
			
		}
		
		public function install() {
			
			//WPVR Notices already installed
			if ( $this->local_version !== '' && $this->local_version !== false && version_compare( $this->local_version , $this->options[ 'version' ] , '>=' ) ) {
				return false;
			}
			global $wpdb;
			require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
			
			//Create Custom Table if it does not exist
			$done = @dbDelta( "CREATE TABLE {$wpdb->prefix}wpvr_notices (
				`id` INT(9) unsigned NOT NULL AUTO_INCREMENT,
				`slug` varchar(255)  COLLATE utf8mb4_unicode_ci NOT NULL,
				`type` varchar(255)  COLLATE utf8mb4_unicode_ci NOT NULL,
				`date` datetime ,
				`expire` datetime ,
				`notice` text utf8mb4_unicode_ci,
				PRIMARY KEY (`id`),
				INDEX notice_id_index (`id`)
			) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci" );
			
			update_option( 'wpvr_notices_install_version' , $this->options[ 'version' ] );
		}
		
		public function add( $notice = null ) {
			global $wpdb;
			
			$notice = $this->parse_defaults( $notice );
			
			
			$notice_json = json_encode( $notice );
			
			$expiration_date = null;
			
			if ( $notice[ 'expiration_date' ] !== null ) {
				$expiration_date = date( "Y-m-d H:i:s" , strtotime( $notice[ 'expiration_date' ] ) );
			}
			
			if ( $notice[ 'lifespan' ] !== null ) {
				$expiration_date = date( "Y-m-d H:i:s" , strtotime( '+' . intval( $notice[ 'lifespan' ] ) . ' hours' ) );
			}
			
			// Check if the slug already exist, if its true we delete it.
			if ( $this->notice_exists( $notice[ 'slug' ] ) ) {
				$this->remove( $notice[ 'slug' ] );
			}
			
			// Add notice to DB
			$sql_add
				= "
				  INSERT into {$wpdb->prefix}wpvr_notices (slug,type,date,expire,notice)
				  VALUES ('{$notice['slug']}','{$notice['type']}','{$notice['date']}','{$expiration_date}','{$notice_json}')";
			
			$created_row = $wpdb->query( $sql_add );
			
			return $created_row;
		}
		
		public function parse_defaults( $notice ) {
			
			$nowObj = new Datetime();
			
			$notice = wp_parse_args( $notice , array(
				'slug'            => null ,
				'date'            => $nowObj->format( 'Y-m-d H:i:s' ) ,
				'expiration_date' => null , //Y-m-d
				'lifespan'        => null , // by hours
				'type'            => 'regular' , //regular|dialog|popover|tour
				'status'          => 'Update' , //Update|Warning|Info|Error
				'color'           => '#27A1CA' ,//(#HEX)
				'title'           => 'WPVR Video Robot' ,
				'icon'            => 'fa-thumbs-up' ,
				'content'         => null ,//HTML
				'html_class'      => null ,
				'html_id'         => null ,
				'dismissable'     => true ,
				'closeable'       => true ,
				'init_only'       => false ,
				'buttons'         => array() ,
			) );
			
			//Parse DEfault
			$notice[ 'buttons' ] = $this->parse_defaults_buttons( $notice[ 'buttons' ] );
			
			if ( $notice[ 'type' ] == 'popover' ) {
				$notice = wp_parse_args( $notice , array(
					'popover_target'    => null ,
					'popover_placement' => 'bottom' ,
					'popover_delay'     => 0 ,
				) );
			}
			
			if ( $notice[ 'type' ] == 'tour' ) {
				$notice = wp_parse_args( $notice , array(
					'tour_steps'      => array() ,
					'tour_start_step' => 0 ,
				) );
			}
			
			if ( $notice[ 'type' ] == 'dialog' ) {
				$notice = wp_parse_args( $notice , array(
					'dialog_cancel_button'      => 'CANCEL HTML' ,
					'dialog_cancel_js_function' => 'some_other_function' ,
					'dialog_pause_button'       => 'CONTINUE HTML' ,
					'dialog_pause_js_function'  => 'some_function' ,
					'dialog_width'              => '40%' ,
					'dialog_box_class'          => '' ,
					'dialog_mask_class'         => '' ,
					'dialog_delay'              => 500 ,
					'dialog_is_modal'           => false ,
				) );
			}
			
			return $notice;
		}
		
		public function parse_defaults_buttons( $buttons ) {
			foreach ( (array) $buttons as $button_position => $button ) {
				$buttons[ $button_position ] = $this->parse_defaults_button( $button );
			}
			
			return $buttons;
		}
		
		public function parse_defaults_button( $button ) {
			return wp_parse_args( $button , array(
				'label'           => 'Button' ,
				'color'           => '#27A1CA' ,
				'icon'            => 'fa-heart' ,
				'html_class'      => '' ,
				'html_id'         => '' ,
				'url'             => null ,
				'type'            => 'link' , // link, button
				'reverse'         => false ,
				'order'           => 0 ,
				'position'        => 'left' , // left, right
				'jquery'          => array() ,
				'data_attributes' => array() ,
			) );
		}
		
		public function notice_exists( $notice_slug ) {
			$count = $this->get( array(
				'slugs'      => array( $notice_slug ) ,
				'count_only' => true ,
			) );
			
			return $count > 0 ? true : false;
		}
		
		public function get( $args = array() ) {
			global $wpdb;
			
			$args = wp_parse_args( $args , array(
				'slugs'      => array() ,
				'types'      => array() ,
				'valid_only' => false ,
				'count_only' => false ,
			) );
			
			$conditions = array(
				'slugs'  => '' ,
				'types'  => '' ,
				'expire' => '' ,
			);
			
			if ( count( $args[ 'slugs' ] ) != 0 ) {
				$conditions[ 'slugs' ] = " AND slug IN ('" . implode( ',' , $args[ 'slugs' ] ) . "') ";
			}
			if ( count( $args[ 'types' ] ) != 0 ) {
				$conditions[ 'types' ] = " AND type IN ('" . implode( ',' , $args[ 'types' ] ) . "') ";
			}
			if ( $args[ 'valid_only' ] === true ) {
				$conditions[ 'expire' ] = " AND ( expire = '0000-00-00 00:00:00' OR expire < NOW() )";
			}
			
			$sql
				= "
			select
				notice
			from
				{$wpdb->prefix}wpvr_notices
            where
            	1
            	" . implode( "\n" , $conditions ) . "
			";
			
			$results = $wpdb->get_results( $sql , ARRAY_A );
			
			$notices = array();
			foreach ( (array) $results as $result ) {
				$notice    = json_decode( $result[ 'notice' ] , true );
				$notices[] = apply_filters( 'wpvr_notices_extend_found_notice' , $notice );
			}
			
			$notices = apply_filters( 'wpvr_notices_extend_found_notices' , $notices , $args );
			
			if ( $args[ 'count_only' ] === true ) {
				return count( $notices );
			}
			
			return $notices;
		}
		
		public function remove( $notice_slug ) {
			global $wpdb;
			
			$sql_delete = "DELETE from {$wpdb->prefix}wpvr_notices where slug LIKE '%{$notice_slug}%'";
			
			$deleted_row = $wpdb->query( $sql_delete );
			
			return $deleted_row > 0 ? true : false;
		}
		
		public function render( $notice ) {
			
			$notice = $this->parse_defaults( $notice );
			
			$user_id = get_current_user_id();
			if ( in_array( $notice[ 'slug' ] , (array) $this->get_dismissed_notices( $user_id ) ) ) {
				return '';
			}
			
			if ( $notice[ 'type' ] == 'dialog' ) {
				return $this->render_dialog( $notice );
			}
			
			if ( $notice[ 'type' ] == 'regular' ) {
				return $this->render_regular( $notice );
			}
			
			if ( $notice[ 'type' ] == 'popover' ) {
				return $this->render_popover( $notice );
			}
			
			if ( $notice[ 'type' ] == 'tour' ) {
				return $this->render_tour( $notice );
			}
			
			return '';
		}
		
		public function get_dismissed_notices( $user_id ) {
			$dismissed = get_user_meta( $user_id , 'wpvr_dismissed_notices' , true );
			if ( $dismissed == '' ) {
				$dismissed = array();
			}
			
			return $dismissed;
		}
		
		public function render_dialog( $notice ) {
			ob_start();
			
			$dialog_body = '';
			$dialog_body .= $notice[ 'content' ];
			
			if ( count( $notice[ 'buttons' ] ) != 0 ) {
				$dialog_body .= '<br/><br/>' . $this->render_buttons( $notice );
			}
			
			?>
			
			<div class = "<?php echo $notice[ 'html_class' ]; ?> wpvr_notices wpvr_notices_dialog"
			     id = "<?php echo $notice[ 'html_id' ]; ?>"
			     style = "display:none;"
			     data-dialog_title = "<?php echo $notice[ 'title' ]; ?>"
			     data-dialog_text = "<?php echo base64_encode( $dialog_body ); ?>"
			     data-dialog_isModal = "<?php echo $notice[ 'dialog_is_modal' ] ? 'true' : 'false'; ?>"
			     data-dialog_maskClass = "<?php echo $notice[ 'dialog_mask_class' ]; ?>"
			     data-dialog_boxClass = "<?php echo $notice[ 'dialog_box_class' ]; ?>"
			     data-dialog_delay = "<?php echo $notice[ 'dialog_delay' ]; ?>"
			>
			</div>
			
			<?php
			$output_string = ob_get_contents();
			ob_end_clean();
			
			return $output_string;
		}
		
		public function render_buttons( $notice ) {
			
			ob_start();
			
			$buttons = wpvr_reorder_items( $notice[ 'buttons' ] , 'order' );
			
			?>
			<div class = "wpvr_notices_buttons_<?php echo $notice[ 'type' ]; ?>">
				<?php
					foreach ( (array) $buttons as $button ) {
						echo $this->render_single_button( $button );
					}
				?>
			</div>
			<?php
			
			$output_string = ob_get_contents();
			ob_end_clean();
			
			return $output_string;
		}
		
		public function render_single_button( $button ) {
			
			$button_jquery = wp_parse_args( $button[ 'jquery' ] , array(
				'click' => 0 ,
				'hover' => 0 ,
			) );
			
			$button_token = 'wpvr_notices_button_' . bin2hex( openssl_random_pseudo_bytes( 16 ) );
			$button_href  = $button[ 'url' ] === '' || $button[ 'url' ] === null ? 'javascript:;' : $button[ 'url' ];
			$button_type  = $button[ 'type' ] == 'button' ? ' wpvr_notices_button ' : ' wpvr_notices_link ';
			
			$position = $button[ 'position' ] == 'left' ? ' pull-left ' : ' pull-right ';
			
			$background_color = $button[ 'type' ] == 'button' ? 'background-color:' . $button[ 'color' ] . ';' : '';
			
			$data_attributes = array();
			foreach ( (array) $button[ 'data_attributes' ] as $key => $value ) {
				$data_attributes[] = ' data-' . $key . ' = "' . $value . '" ';
			}
			
			ob_start();
			?>
			<a
					style = "<?php echo $background_color ?> display:inline-block;"
					id = "<?php echo $button[ 'html_id' ]; ?>"
					class = "<?php echo $button_type . ' ' . $button[ 'html_class' ] . ' ' . $position; ?>"
					href = "<?php echo $button_href; ?>"
					data-token = "<?php echo $button_token; ?>"
				<?php echo implode( " " , $data_attributes ); ?>
			>
				
				<!-- Icon on the left -->
				<?php if ( ! $button[ 'reverse' ] ) { ?>
					<i class = "fa <?php echo $button[ 'icon' ] ?>"></i>
				<?php } ?>
				
				<!-- Button Label -->
				<?php echo $button[ 'label' ] ?>
				
				<!-- Icon on the right -->
				<?php if ( $button[ 'reverse' ] ) { ?>
					<i class = "fa <?php echo $button[ 'icon' ] ?>"></i>
				<?php } ?>
			
			</a>
			
			<script>
                jQuery(document).ready(function () {
                    if (typeof window.wpvr_notices_js_functions === 'undefined') {
                        window.wpvr_notices_js_functions = [];
                    }
                    window.wpvr_notices_js_functions['<?php echo $button_token; ?>'] = {
                        click: <?php echo $button_jquery[ 'click' ]; ?>,
                        hover: <?php echo $button_jquery[ 'hover' ]; ?>,
                    };
                });
			</script>
			
			<?php
			$output_string = ob_get_contents();
			ob_end_clean();
			
			return $output_string;
		}
		
		public function render_regular( $notice ) {
			
			if ( $notice[ 'dismissable' ] && ! isset( $notice[ 'buttons' ][ 'dismiss' ] ) ) {
				$notice[ 'buttons' ][ 'dismiss' ] = $this->parse_defaults_button( array(
					'label'      => __( 'Hide this notice' , WPVR_LANG ) ,
					'color'      => '#212121' ,
					'icon'       => 'fa-times' ,
					'html_class' => 'wpvr_notices_dismiss' ,
					'html_id'    => null ,
					'url'        => null ,
					'type'       => 'link' , // link, button
					'position'   => 'right' , // left, right
					'reverse'    => false ,
					'order'      => 0 ,
					'jquery'     => array(
						'click' => "function(e){
							var notice_slug = 'mehdi';
							jQuery.ajax({
                                    type: 'POST',
                                    url: wpvr_globals.ajax_url,
                                    data: {
                                        action: 'dismiss_notice',
                                        notice_slug: notice_slug,
                                    },
						}" ,
					) ,
				) );
			}
			
			if ( $notice[ 'closeable' ] && ! $notice[ 'dismissable' ] && ! isset( $notice[ 'buttons' ][ 'close' ] ) ) {
				$notice[ 'buttons' ][ 'close' ] = $this->parse_defaults_button( array(
					'label'      => __( 'Close this notice' , WPVR_LANG ) ,
					'color'      => '#212121' ,
					'icon'       => 'fa-times' ,
					'html_class' => 'wpvr_notices_close' ,
					'html_id'    => null ,
					'url'        => null ,
					'type'       => 'link' , // link, button
					'position'   => 'right' , // left, right
					'reverse'    => false ,
					'order'      => 0 ,
					'jquery'     => array() ,
				) );
			}
			
			if ( isset( $notice[ 'buttons' ][ 'dismiss' ] ) ) {
				$notice[ 'buttons' ][ 'dismiss' ][ 'html_class' ] = 'wpvr_notices_dismiss';
			}
			
			ob_start();
			?>
			
			<div class = "<?php echo $notice[ 'html_class' ]; ?> wpvr_notices wpvr_notices_regular"
			     style = "display:block; border-color:<?php echo $notice[ 'color' ]; ?>;"
			     id = "<?php echo $notice[ 'html_id' ]; ?>"
			>
				<div class = "wpvr_notices_title">
					<strong><?php echo $notice[ 'title' ]; ?></strong>
				</div>
				
				<?php if ( $notice[ 'icon' ] !== false ) { ?>
					<div class = "pull-left wpvr_notices_icon" style = "color:<?php echo $notice[ 'color' ]; ?>">
						<i class = "fa <?php echo $notice[ 'icon' ]; ?>"></i>
					</div>
				<?php } ?>
				
				<div class = "wpvr_notices_body <?php echo $notice[ 'icon' ] === false ? 'no_icon' : ''; ?>">
					<div class = "wpvr_notices_content">
						<?php echo $notice[ 'content' ]; ?>
					</div>
					<div class = "wrap wpvr_notices_button_wrap">
						<?php echo $this->render_buttons( $notice ); ?>
						<div class = "wpvr_clearfix"></div>
					</div>
					<div class = "wpvr_clearfix"></div>
				</div>
			</div>
			
			<?php
			$output_string = ob_get_contents();
			ob_end_clean();
			
			return $output_string;
		}
		
		public function render_popover( $notice ) {
			
			
			if ( $notice[ 'dismissable' ] && ! isset( $notice[ 'buttons' ][ 'dismiss' ] ) ) {
				$notice[ 'buttons' ][ 'dismiss' ] = $this->parse_defaults_button( array(
					'label'      => __( 'Hide this notice' , WPVR_LANG ) ,
					'color'      => '#CCC' ,
					'icon'       => 'fa-times' ,
					'html_class' => 'wpvr_notices_dismiss' ,
					'html_id'    => null ,
					'url'        => null ,
					'type'       => 'link' , // link, button
					'position'   => 'right' , // left, right
				) );
			}
			
			if ( $notice[ 'closeable' ] && ! $notice[ 'dismissable' ] && ! isset( $notice[ 'buttons' ][ 'close' ] ) ) {
				$notice[ 'buttons' ][ 'close' ] = $this->parse_defaults_button( array(
					'label'      => __( 'Close this notice' , WPVR_LANG ) ,
					'color'      => '#CCC' ,
					'icon'       => 'fa-times' ,
					'html_class' => 'wpvr_notices_dismiss' ,
					'html_id'    => null ,
					'url'        => null ,
					'type'       => 'link' , // link, button
					'position'   => 'right' , // left, right
				) );
			}
			
			if ( isset( $notice[ 'buttons' ][ 'dismiss' ] ) ) {
				$notice[ 'buttons' ][ 'dismiss' ][ 'html_class' ] = 'wpvr_notices_dismiss';
			}
			
			$notice[ 'buttons' ] = wpvr_reorder_items( $notice[ 'buttons' ] );
			
			ob_start();
			
			?>
			<div
					class = "wpvr_notices_popover_wrap"
					style = "display:none;  border-color:<?php echo $notice[ 'color' ]; ?>;"
			>
				<div class = "<?php echo $notice[ 'html_class' ]; ?> wpvr_notices wpvr_notices_popover"
				     id = "<?php echo $notice[ 'html_id' ]; ?>"
				     data-popover_delay = "<?php echo $notice[ 'popover_delay' ]; ?>"
				     data-popover_target = "<?php echo $notice[ 'popover_target' ]; ?>"
				     data-popover_placement = "<?php echo $notice[ 'popover_placement' ]; ?>"
				     data-init_only = "<?php echo $notice[ 'init_only' ] ? '1' : '0'; ?>"
				>
					<div class = "wpvr_notices_title">
						<strong><?php echo $notice[ 'title' ]; ?></strong>
					</div>
					
					<?php if ( $notice[ 'icon' ] !== false ) { ?>
						<div class = "pull-left wpvr_notices_icon" style = "color:<?php echo $notice[ 'color' ]; ?>">
							<i class = "fa <?php echo $notice[ 'icon' ]; ?>"></i>
						</div>
					<?php } ?>
					
					<div class = "wpvr_notices_body <?php echo $notice[ 'icon' ] === false ? 'no_icon' : ''; ?>">
						<div class = "wpvr_notices_content">
							<?php echo $notice[ 'content' ]; ?>
						</div>
						<div class = "wrap wpvr_notices_button_wrap">
							<?php echo $this->render_buttons( $notice ); ?>
							<div class = "wpvr_clearfix"></div>
						</div>
						<div class = "wpvr_clearfix"></div>
					</div>
				</div>
			</div>
			
			<?php
			$output_string = ob_get_contents();
			ob_end_clean();
			
			return $output_string;
		}
		
		public function render_tour( $tour ) {
			ob_start();
			$popovers = wpvr_reorder_items( $tour[ 'tour_steps' ] );
			
			foreach ( (array) $popovers as $k => $popover ) {
				
				$popover = $this->parse_defaults( $popover );
				
				
				$popover[ 'previous' ] = isset( $popovers[ $k - 1 ] ) ? $popovers[ $k - 1 ][ 'popover_target' ] : false;
				$popover[ 'next' ]     = isset( $popovers[ $k + 1 ] ) ? $popovers[ $k + 1 ][ 'popover_target' ] : false;
				
				
				if ( $popover[ 'previous' ] !== false ) {
					$popover[ 'buttons' ][] = array(
						'label'           => 'Prev' ,
						'color'           => '#212121' ,
						'icon'            => 'fa-arrow-left' ,
						'html_class'      => 'wpvr_notices_tour_nav' ,
						'type'            => 'button' , // link, button
						'position'        => 'left' , // body, float
						'reverse'         => false , // body, float
						'order'           => - 1 ,
						'data_attributes' => array(
							'tour_target' => $popover[ 'previous' ] ,
							'tour_source' => $popover[ 'popover_target' ] ,
						) ,
					);
				}
				
				if ( $popover[ 'next' ] !== false ) {
					$popover[ 'buttons' ][] = array(
						'label'           => 'Next' ,
						'color'           => '#212121' ,
						'icon'            => 'fa-arrow-right' ,
						'html_class'      => 'wpvr_notices_tour_nav' ,
						'type'            => 'button' , // link, button
						'position'        => 'right' , // body, float
						'reverse'         => true , // body, float
						'order'           => - 1 ,
						'data_attributes' => array(
							'tour_target' => $popover[ 'next' ] ,
							'tour_source' => $popover[ 'popover_target' ] ,
						) ,
					);
				}
				$popover[ 'init_only' ] = true;
				$popover[ 'buttons' ]   = $this->parse_defaults_buttons( $popover[ 'buttons' ] );
				
				//Avoid rendering steps except for step #0
				if ( $k == $tour[ 'tour_start_step' ] ) {
					$popover[ 'init_only' ]     = false;
					$popover[ 'popover_delay' ] = $tour[ 'tour_delay' ];
				}
				
				echo $this->render_popover( $popover );
				
			}
			$output_string = ob_get_contents();
			ob_end_clean();
			
			return $output_string;
		}
		
		public function dismiss( $notice_slug , $user_id ) {
			$dismissed   = $this->get_dismissed_notices( $user_id );
			$dismissed[] = $notice_slug;
			
			return true;
		}
	}
	
	new WPVR_Notices( array( 'version' => '1.0.1' ) );
	
	//function WPVR_Notices() {
	//	global $notices_class;
	//	if ( ! isset( $notices_class ) ) {
	//		$notices_class = new WPVR_Notices();
	//	}
	//
	//	return $notices_class;
	//}