<?php
	function wpvr_debug_update_actions( $msg ) {
		// echo "<br/> - " . $msg ." ...";
	}
	
	//Store Old Config on wp_options before starting the update
	add_action( 'upgrader_package_options' , 'wpvr_update_store_old_config' , 100 , 1 );
	function wpvr_update_store_old_config( $options ) {
		
		//Store Old Config on wp_options
		$old_config = wpvr_parse_config_file( WPVR_PATH . 'wpvr.config.php' );
		wpvr_debug_update_actions( "Storing Old Config File (" . count( $old_config ) . ")" );
		update_option( 'wpvr_config_before_update' , $old_config , false );
		
		return $options;
	}
	
	//Extend and replace Config File
	add_action( 'upgrader_process_complete' , 'wpvr_update_extend_replace_config' , 10 , 2 );
	function wpvr_update_extend_replace_config( $upgrader_object , $options ) {
		
		if (
			$options[ 'action' ] !== 'update'
			|| $options[ 'type' ] !== 'plugin'
			|| ! isset( $options[ 'plugins' ] )
		) {
			return;
		}
		
		foreach ( (array) $options[ 'plugins' ] as $plugin ) {
			
			if ( $plugin !== WPVR_SLUG ) {
				do_action( 'wpvr_event_plugin_updated' , $plugin );
				continue;
			}
			
			$new_version = get_option( 'wpvr_new_version_before_update' );
			wpvr_debug_update_actions( "Adapting Config File for version {$new_version}" );
			wpvr_override_config_file( $new_version );
			
			wpvr_debug_update_actions( "Deleteing TMP options update entries" );
			delete_option( 'wpvr_new_version_before_update' );
			delete_option( 'wpvr_config_before_update' );
			
			do_action( 'wpvr_event_core_plugin_updated' , 'wpvr' , $new_version );
		}
	}
	
	add_action( 'wpvr_event_core_plugin_updated' , 'wpvr_add_thanks_for_updating_notice' , 100 , 2 );
	function wpvr_add_thanks_for_updating_notice( $slug , $version ) {
		
		if ( $slug !== 'wpvr' ) {
			return false;
		}
		
		//Actions to be executed after a successfully update of WP Video Robot
		wpvr_debug_update_actions( "Reloading WPVR Add-ons List" );
		wpvr_get_addons( array() , true );
		
		// Clear all WPVR Notices
		wpvr_debug_update_actions( "Clear all WPVR Notices" );
		wpvr_update_option( 'wpvr_notices' , array() );
		
		//Add NEw optimizations to DB
		wpvr_debug_update_actions( "Optimizing WPVR DB" );
		wpvr_optimize_db();
		
		//Adding Thanks for updating notice
		wpvr_debug_update_actions( "Adding WPVR update notice" );
		wpvr_add_notice( array(
			'title'     => "Updated to version {$version}!" ,
			'class'     => 'warning' , //updated or warning or error
			'content'   => 'Thanks for updating the WP Video Robot to the latest version.' ,
			'hidable'   => false ,
			'is_dialog' => false ,
			'show_once' => true ,
			'icon'      => 'fa-thumbs-up' ,
		) );
	}
	
	add_action( 'wpvr_event_core_plugin_updated' , 'wpvr_adapt_install_after_update' , 100 , 2 );
	function wpvr_adapt_install_after_update( $slug , $version ) {
		if ( $slug !== 'wpvr' ) {
			return false;
		}
		do_action( 'wpvr_adapt_install_after_update' , $version );
	}