<?php
	
	/* Function to redirect download request to permalink structure */
	add_action( 'template_include', 'wpvr_download_export_file' );
	function wpvr_download_export_file( $template ) {
		
		$export_filenames = array(
			'sources'     => 'wpvr_export_sources.json',
			'videos'      => 'wpvr_export_videos.json',
			'options'     => 'wpvr_export_options.json',
			'system_info' => 'wpvr_export_system_info.txt',
			'data'        => 'wpvr_export_data.json',
		);
		
		$request_uri = $_SERVER['REQUEST_URI'];
		
		if ( strpos( $request_uri, '/wpvr_export/' ) === FALSE ) {
			return $template;
		}
		
		$array = explode( '/wpvr_export/', $request_uri );
		
		
		if ( ! isset( $array[1] ) || empty( $array[1] ) ) {
			return $template;
		}
		
		$file = $array[1];
		
		if ( ! file_exists( WPVR_TMP_PATH . $file ) ) {
			echo "Could not find the tmp file.";
			
			return $template;
		}
		
		
		if ( strpos( $file, '__sources__' ) !== FALSE ) {
			$filename = $export_filenames['sources'];
		} elseif ( strpos( $file, '__videos__' ) !== FALSE ) {
			$filename = $export_filenames['videos'];
		} elseif ( strpos( $file, '__options__' ) !== FALSE ) {
			$filename = $export_filenames['options'];
		} elseif ( strpos( $file, '__system_info__' ) !== FALSE ) {
			$filename = $export_filenames['system_info'];
		} elseif ( strpos( $file, '__data__' ) !== FALSE ) {
			$filename = $export_filenames['data'];
		} else {
			return $template;
		}
		
		
		header( "Content-type: application/x-msdownload", TRUE, 200 );
		header( "Content-Disposition: attachment; filename=" . $filename );
		header( "Pragma: no-cache" );
		header( "Expires: 0" );
		readfile( WPVR_TMP_PATH . $file );
		exit();
	}
	
	//@Deprecated
	// add_action( 'init', 'wpvr_do_rewrite_permalinks', 2000 );
	// function wpvr_do_rewrite_permalinks() {
	// 	global $wp_rewrite, $wpvr_options;
	//
	// 	if ( $wpvr_options['enableRewriteRule'] === false ) {
	// 		return false;
	// 	}
	//
	// 	if ( $wpvr_options['permalinkBase'] === 'none' ) {
	// 		$base = '';
	// 	} elseif ( $wpvr_options['permalinkBase'] === 'category' ) {
	// 		$base = '/%category%';
	// 	} elseif ( $wpvr_options['permalinkBase'] === 'custom' ) {
	// 		$base = $wpvr_options['customPermalinkBase'] == '' ? '' : '/' . $wpvr_options['customPermalinkBase'] . '';
	// 	}
	//
	// 	$wp_rewrite->set_permalink_structure( $base . '/%postname%/' );
	//
	// 	if ( get_option( 'wpvr_permalink_base' ) != $base ) {
	// 		flush_rewrite_rules();
	// 		wpvr_update_option( 'wpvr_permalink_base', $base );
	// 	}
	// }
		
	//@Deprecated
	// add_filter( 'post_type_link', 'wpvr_do_rewrite_links', 10, 3 );
	// function wpvr_do_rewrite_links( $post_link, $post, $leavename ) {
	// 	global $wpvr_options;
	//
	// 	if ( ! wpvr_cpt_has_handled_type( $post->ID ) || 'publish' != $post->post_status ) {
	// 		return $post_link;
	// 	}
	// 	//Rewrite is OFF
	// 	if ( $wpvr_options['enableRewriteRule'] !== true ) {
	// 		return wpvr_render_video_permalink( $post, null, $post_link );
	// 	}
	//
	// 	//Category Permalink Base
	// 	if ( $wpvr_options['permalinkBase'] === 'category' ) {
	// 		return wpvr_render_video_permalink( $post, "/%category%/%postname%/" );
	// 	}
	//
	// 	//No Permalink Base
	// 	if ( $wpvr_options['permalinkBase'] === 'none' ) {
	// 		return wpvr_render_video_permalink( $post, "/%postname%/" );
	// 	}
	//
	// 	//Custom Permalink Base
	// 	if ( $wpvr_options['permalinkBase'] === 'custom' ) {
	// 		return wpvr_render_video_permalink( $post, "/{$wpvr_options['customPermalinkBase']}/%postname%/" );
	// 	}
	//
	// 	return $post_link;
	// }
	
	add_action( 'init', 'wpvr_add_cron_endpoint' );
	function wpvr_add_cron_endpoint() {
		add_rewrite_tag( '%wpvr_cron%', '([^&]+)' );
		add_rewrite_rule( WPVR_CRON_ENDPOINT . '/([^&]+)/?', 'index.php?wpvr_cron=$matches[1]', 'top' );
		
		if ( get_option( 'wpvr_automation_cron_endpoint' ) != WPVR_CRON_ENDPOINT ) {
			flush_rewrite_rules();
			wpvr_update_option( 'wpvr_automation_cron_endpoint', WPVR_CRON_ENDPOINT );
		}
		
	}
	
	add_action( 'template_redirect', 'wpvr_process_cron_call', 1000 );
	function wpvr_process_cron_call() {
		global $wp_query, $cron_data_file;
		$token = $wp_query->get( 'wpvr_cron' );
		if ( ! $token ) {
			return;
		}
		
		$_GET['token'] = $token;
		
		define( 'WPVR_DOING_CRON', TRUE );
		
		if ( ! is_multisite() ) {
			$cron_data_file = WPVR_PATH . "assets/php/cron.txt";
		} else {
			$site_id        = get_current_blog_id();
			$cron_data_file = WPVR_PATH . "assets/php/cron_" . $site_id . ".txt";
		}
		include( WPVR_PATH . 'wpvr.cron.php' );
		exit;
	}
	
	
	add_action( 'init', 'wpvr_add_async_endpoint' );
	function wpvr_add_async_endpoint() {
		
		add_rewrite_tag( '%wpvr_async_action%', '([^&]+)' );
		add_rewrite_rule( WPVR_ASYNC_ENDPOINT . '/([^&]+)/?', 'index.php?wpvr_async_action=$matches[1]', 'top' );
		
		if ( get_option( 'wpvr_async_endpoint' ) != WPVR_ASYNC_ENDPOINT ) {
			flush_rewrite_rules();
			wpvr_update_option( 'wpvr_async_endpoint', WPVR_ASYNC_ENDPOINT );
		}
		
	}
	
	add_action( 'template_redirect', 'wpvr_process_async_call', 1000 );
	function wpvr_process_async_call() {
		global $wp_query;
		$action = $wp_query->get( 'wpvr_async_action' );
		if ( ! $action ) {
			return;
		}
		$_GET[ $action ] = 1;
		
		include( WPVR_PATH . 'includes/wpvr.actions.php' );
		exit;
	}
	
	
	add_filter( 'post_type_link', 'wpvr_customize_videos_permalinks', 10, 3 );
	function wpvr_customize_videos_permalinks( $post_link, $post, $leavename ) {
		global $wpvr_options, $wp_rewrite;
		
		if ( $wpvr_options['enableRewriteRule'] !== TRUE ) {
			return $post_link;
		}
		
		if ( ! $wp_rewrite->permalink_structure ) {
			return $post_link;
		}
		
		$draft_or_pending = isset( $post->post_status ) && in_array( $post->post_status, array(
				'draft',
				'pending',
				'auto-draft',
			), TRUE );
		
		if ( $draft_or_pending && ! $leavename ) {
			return $post_link;
		}
		
		$post_type = $post->post_type;
		$pt_object = get_post_type_object( $post_type );
		
		if ( FALSE === $pt_object->rewrite ) {
			return $post_link;
		}
		
		if ( ! wpvr_cpt_is_handled_type( $post_type, TRUE ) ) {
			return $post_link;
		}
		
		
		$permalink_structure = null;
		
		//Category Permalink Base
		if ( $wpvr_options['permalinkBase'] === 'category' ) {
			return wpvr_render_video_permalink( $post, "/%category%/%postname%/", $post_link );
		}
		
		//Author Permalink Base
		if ( $wpvr_options['permalinkBase'] === 'author' ) {
			return wpvr_render_video_permalink( $post, "/%author%/%postname%/", $post_link );
		}
		
		//No Permalink Base
		if ( $wpvr_options['permalinkBase'] === 'none' ) {
			return wpvr_render_video_permalink( $post, "/%postname%/", $post_link );
		}
		
		//Custom Permalink Base
		if ( $wpvr_options['permalinkBase'] === 'custom' ) {
			return wpvr_render_video_permalink( $post, "/{$wpvr_options['customPermalinkBase']}/%postname%/", $post_link );
		}
		
		return $post_link;
		
	}
	
	
	add_action( 'registered_post_type', 'wpvr_customize_videos_rewrite_rules', 100, 2 );
	function wpvr_customize_videos_rewrite_rules( $post_type, $args ) {
		
		global $wp_rewrite, $wpvr_options;
		
		if ( $wpvr_options['enableRewriteRule'] !== TRUE ) {
			return;
		}
		
		if ( $args->_builtin || ! $args->publicly_queryable ) {
			return;
		}
		
		if ( FALSE === $args->rewrite ) {
			return;
		}
		
		if ( ! wpvr_cpt_is_handled_type( $post_type, TRUE ) ) {
			return;
		}
		
		$args->rewrite['slug'] = '';
		
		if ( $wpvr_options['permalinkBase'] === 'category' ) {
			
			$permalink = '/%category%/%postname%/';
			$wp_rewrite->add_rewrite_tag( "%category%", '([^/]+)', "category=" );
			
			
		} elseif ( $wpvr_options['permalinkBase'] === 'author' ) {
			
			$permalink = '/%category%/%postname%/';
			$wp_rewrite->add_rewrite_tag( "%author%", '([^/]+)', "author=" );
			
		} elseif ( $wpvr_options['permalinkBase'] === 'custom' ) {
			
			$permalink = '/' . $wpvr_options['customPermalinkBase'] . '/%postname%/';
			
		} else {
			
			$permalink = '/%postname%/';
			
		}
		
		
		$permalink    = str_replace( '%postname%', '%' . $post_type . '%', $permalink );
		$rewrite_args = $args->rewrite;
		
		if ( ! is_array( $rewrite_args ) ) {
			$rewrite_args = array(
				'with_front' => $args->rewrite,
			);
		}
		
		$rewrite_args['walk_dirs'] = FALSE;
		// d( $rewrite_args , $permalink );
		$wp_rewrite->add_permastruct( $post_type, $permalink, $rewrite_args );
		
	}
	
	
	