<?php
	
	/* Function to declare PHP is too old ! */
	add_action( 'admin_notices', 'wpvr_show_php_too_old' );
	function wpvr_show_php_too_old() {
		
		$allow_wpvr_notices = apply_filters( 'wpvr_extend_allow_wpvr_notices' , true , $_GET );
		if( $allow_wpvr_notices === false ){
			return false;
		}
	 
		if ( version_compare( PHP_VERSION, WPVR_REQUIRED_PHP_VERSION, '<' ) ) {
			$php_version = explode( '+', PHP_VERSION );
			?>
            <div class="error">
                <p>
                    <strong>WP Video Robot ERROR</strong><br/>
					<?php echo __( 'You are using PHP version ', WPVR_LANG ) . $php_version[0]; ?>.<br/>
					<?php printf( __( 'WP Video Robot needs version %s at least to work properly.', WPVR_LANG ), WPVR_REQUIRED_PHP_VERSION ); ?>
                    <br/>
					<?php echo __( 'Please upgrade PHP.', WPVR_LANG ); ?>
                </p>
            </div>
			<?php
		}
	}
	
	/* Function to show error message if cron not writable */
	add_action( 'admin_notices', 'wpvr_cron_file_permission_issue' );
	function wpvr_cron_file_permission_issue() {
		
		$allow_wpvr_notices = apply_filters( 'wpvr_extend_allow_wpvr_notices' , true , $_GET );
		if( $allow_wpvr_notices === false ){
			return false;
		}
	 
		$f = WPVR_PATH . 'assets/php/cron.txt';
		if ( is_writable( $f ) === false ) {
			?>
            <div class="error">
                <p>
                    <strong>WP Video Robot ERROR</strong><br/>
					<?php echo __( 'The plugin cannot work automatically.', WPVR_LANG ); ?>
					<?php echo __( 'Please, make sure this file is writable :', WPVR_LANG ); ?>
                    <strong><?php echo $f; ?></strong><br/>
					<?php echo __( 'If you cannot do that, contact your host.', WPVR_LANG ); ?>

                </p>
            </div>
			<?php
		}
	}
	
	add_filter('wpvr_extend_allow_wpvr_notices' , 'wpvr_extend_allow_wpvr_notices_function' , 100 , 2 );
	function wpvr_extend_allow_wpvr_notices_function( $allow , $get ){
		$private_params = apply_filters( 'wpvr_extend_notices_private_params', array(
			'migrate_meta_data' => true,
			'action'            => 'do-plugin-upgrade',
			'page'              => array( 'wpvr-welcome', 'wpvr-sandbox', ),
			// 'page'              => 'wpvr-welcome',
		) );
		foreach ( (array) $private_params as $private_param => $private_param_value ) {
			if ( ! isset( $get[ $private_param ] ) ) {
				continue;
			}
			
			if ( $private_param_value === true ) {
				return false;
			}
			
			if ( $private_param_value == $get[ $private_param ] ) {
				return false;
			}
			
			if ( is_array( $private_param_value ) && in_array( $get[ $private_param ], $private_param_value ) ) {
				return false;
			}
		}
		return $allow;
    }
	
	/* Function to show WPVR NOtices */
	add_action( 'admin_notices', 'wpvr_show_notices', 10 );
	function wpvr_show_notices() {
	
	    $allow_wpvr_notices = apply_filters( 'wpvr_extend_allow_wpvr_notices' , true , $_GET );
	    if( $allow_wpvr_notices === false ){
	        return false;
        }
				
		$wpvr_notices = get_option( 'wpvr_notices' );
		
		if ( $wpvr_notices == '' ) {
			return false;
		}
		
		if ( ! is_array( $wpvr_notices ) || count( $wpvr_notices ) == 0 ) {
			return false;
		}
		
		foreach ( (array) $wpvr_notices as $k => $notice ) {
			if ( ! isset( $notice['is_manual'] ) || $notice['is_manual'] === false ) {
				wpvr_render_notice( $notice, $k );
			}
		}
	}
	
	/* Function to show WPVR NOtices */
	add_action( 'admin_notices', 'wpvr_show_multisite_notices' );
	function wpvr_show_multisite_notices() {
		
		$allow_wpvr_notices = apply_filters( 'wpvr_extend_allow_wpvr_notices' , true , $_GET );
		if( $allow_wpvr_notices === false ){
			return false;
		}
	    
	    if ( ! is_multisite() ) {
			return false;
		}
		$wpvr_notices = get_site_option( 'wpvr_notices' );
		if ( isset( $_GET['action'] ) && $_GET['action'] == 'do-plugin-upgrade' ) {
			return false;
		}
		if ( $wpvr_notices == '' ) {
			return false;
		}
		//d( $wpvr_notices );
		foreach ( (array) $wpvr_notices as $notice ) {
			if ( ! isset( $notice['is_manual'] ) || $notice['is_manual'] === false ) {
				wpvr_render_notice( $notice );
			}
		}
	}
	
	
	/* Function to show demo message */
	add_action( 'admin_notices', 'wpvr_show_demo_message', 11 );
	function wpvr_show_demo_message() {
		$notice_slug = 'wpvr_demo_notice';
		
		if ( ! is_admin() ) {
			return false;
		}
		
		$allow_wpvr_notices = apply_filters( 'wpvr_extend_allow_wpvr_notices' , true , $_GET );
		if( $allow_wpvr_notices === false ){
			return false;
		}
		
		if ( ! WPVR_IS_DEMO ) {
			wpvr_remove_notice( $notice_slug );
			
			return false;
		}
		
		ob_start();
		?>
        Feel free to play around with the plugin sources and videos to get a feel of how things work.
        <br/>
        Don't forget to check this <a class="" style="font-weight:bold;" href="<?php echo WPVR_SITE_URL; ?>">demo
            front-end</a>
        to see how your imported videos are rendering with the
        <a style="font-weight:bold;"
           href="https://themeforest.net/item/sahifa-responsive-wordpress-news-magazine-newspaper-theme/2819356/?ref=pressaholic">Sahifa
            Premium Theme</a>.
        <br/><br/>
        You can also check out our
        <a class="" style="font-weight:bold;" href="<?php echo WPVR_DEMOS_URL; ?>" title="Plugin Integrations">integration
            demos</a>
        with several popular video themes. The contents of this demo site is reset once a week.
		
		<?php
		$output_string = ob_get_contents();
		ob_end_clean();
		
		wpvr_add_notice( array(
			'title'     => 'Welcome to the live demo of WP Video Robot v' . WPVR_VERSION,
			'class'     => 'warning ',
			'slug'      => $notice_slug,
			'content'   => $output_string,
			'is_dialog' => false,
			'is_manual' => true,
			'color'     => '#27A1CA',
			'icon'      => '',
		) );
		wpvr_render_notice( $notice_slug );
		wpvr_remove_notice( $notice_slug );
	}
	
	