<?php
	
	// Hook WP Admin Migration Page
	add_action( 'wpvr_actions_page_hook' , 'wpvr_mm_define_migration_page' );
	function wpvr_mm_define_migration_page() {
		
		if ( ! isset( $_GET[ 'migrate_meta_data' ] ) ) {
			return false;
		}
		
		// Define Source Steps Array
		$steps = array(
			
			array(//Construct New Source Meta Table
			      'title'     => 'Construct New source meta table' ,
			      'action'    => 'construct_source_meta_table' ,
			      'post_type' => 'wpvr_source' ,
			) ,
			
			array(//Count Source Old Rows
			      'title'     => 'Counting old source meta entries' ,
			      'action'    => 'count_source_meta' ,
			      'post_type' => 'wpvr_source' ,
			) ,
			
			array(//Move Source Old Rows
			      'title'     => 'Move old source meta entries' ,
			      'action'    => 'move_old_source_meta' ,
			      'post_type' => 'wpvr_source' ,
			) ,
			array(//Clean Source Old Rows
			      'title'     => 'Clean old source meta entries from post meta table' ,
			      'action'    => 'clean_old_source_meta' ,
			      'post_type' => 'wpvr_source' ,
			) ,
		);
		
		// Define Video Steps Array
		$cpts = wpvr_cpt_get_handled_types( 'all' );
		foreach ( $cpts as $cpt ) {
			$steps = array_merge( $steps , array(
				array(//Construct New video Meta Table
				      'title'     => 'Constructing new meta table for the <strong>' . $cpt . '</strong> CPT' ,
				      'action'    => 'construct_video_meta_table' ,
				      'post_type' => $cpt ,
				) ,
				
				array(//Count Video Old Rows
				      'title'     => 'Counting old meta entries for the <strong>' . $cpt . '</strong> CPT' ,
				      'action'    => 'count_video_meta' ,
				      'post_type' => $cpt ,
				) ,
				
				array(//Move video Old Rows
				      'title'     => 'Moving the old meta entries for the <strong>' . $cpt . '</strong> CPT' ,
				      'action'    => 'move_old_video_meta' ,
				      'post_type' => $cpt ,
				) ,
				array(//Clean video Old Rows
				      'title'     => 'Cleaning old meta entries for the <strong>' . $cpt . '</strong> CPT' ,
				      'action'    => 'clean_old_video_meta' ,
				      'post_type' => $cpt ,
				) ,
			) );
		}
		
		$steps[] = array(
			'title'     => 'Updating meta structure version' ,
			'action'    => 'update_meta_structure_version' ,
			'post_type' => 'none' ,
		)
		
		?>
		<h2>WP Video Robot <?php echo __( 'Meta Data Migration' , WPVR_LANG ); ?></h2>
		<div class = "wpvr_mm_wrap">
			<div id = "wpvr_mm_screen"></div>
		</div>
		
		<style>
			.wpvr_mm_log {
				list-style: none;
			}
			
            .wpvr_mm_log_icon{
                margin-right:5px;
            }
            
			div#wpvr_mm_screen {
				background: #FFF;
				padding: 2em;
				width: 80%;
				border-radius: 3px;
				font-size: 13px;
				line-height: 14px;
			}
		</style>
		
		<script>
            jQuery(document).ready(function ($) {
                var redirect_url = '<?php echo admin_url( 'admin.php?page=wpvr&section=content' ); ?>';
                var ajax_url = ' <?php echo admin_url( 'admin-ajax.php' ); ?>';
                var steps = JSON.parse('<?php echo json_encode( $steps ); ?>');
                window.current = 0;
                window.skipping = false;
                window.post_type = 'wpvr_source';
                window.steps = steps;

                function wpvr_mm_get_json(response) {
                    response_array = response.split('<?php echo WPVR_JS; ?>');
                    if (typeof response_array[1] == 'undefined') {
                        console.log('WPVR : Impossible to parse JSON !');
                        return response;
                    }
                    return JSON.parse(response_array[1]);
                }

                function wpvr_mm_print(msg , icon ) {
                    var loading_icon ;
                    if( !icon || icon !== true ){
                        loading_icon = '';
                    }else if( icon === 0 ) {
                        loading_icon = '<i class="wpvr_mm_log_icon fa fa-ban"></i>';
                    }else{
                        loading_icon = '<i class="wpvr_mm_log_icon fa fa-spin fa-cog"></i>';
                    }
                    var entry = $('<li class="wpvr_mm_log">' + loading_icon + msg + '</li>');
                    $('#wpvr_mm_screen').append(entry).fadeIn();
                    return entry;
                }
                
                function wpvr_mm_complete( item ){
                    $('.wpvr_mm_log_icon' , item)
                        .removeClass('fa-spin')
                        .removeClass('fa-cog')
                        .addClass('fa-check');
                }

                function wpvr_mm_proceed() {
                    if (window.current >= window.steps.length) {
                        wpvr_mm_print('<br/>');
                        var finished = wpvr_mm_print('Migration finished.' , true);
                        wpvr_mm_complete( finished );
                        wpvr_mm_print('Redirecting to the WPVR Dashboard ...' , true );
                        setTimeout(function () {
                            window.location.href = redirect_url;
                        }, 5000 );
                        return false;
                    }

                    var step = window.steps[window.current];

                    if (window.skipping === true && step.post_type === window.post_type) {
                        // wpvr_mm_print(step.title + '... SKipped!');
                        window.current = window.current + 1;
                        wpvr_mm_proceed();
                        return false;
                    } else {
                        window.post_type = step.post_type;
                        window.skipping = false;
                        if (window.current > 0) {
                            wpvr_mm_print('<br/>');
                        }
                    }

                    var step_line = wpvr_mm_print(step.title + ' ...' , true );

                    $.ajax({
                        type: 'POST',
                        url: ajax_url,
                        data: {
                            action: step.action,
                            post_type: step.post_type,
                        },
                        success: function (response) {
                            var $json = wpvr_mm_get_json(response);
                            
                            wpvr_mm_complete(step_line);
                            
                            if ($json.status === 1) {
                                wpvr_mm_print(' --- ' + $json.msg);
                            }

                            if ($json.data === 0) {
                                window.skipping = true;
                                wpvr_mm_print(' --- Nothing to do!' , 0);
                                // wpvr_mm_print('Skipping to next post type migration...');
                            }

                            window.current = window.current + 1;
                            //return false;
                            wpvr_mm_proceed();
                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            wpvr_mm_print(' --- ERROR: <br/> ' + thrownError);

                            window.current = window.current + 1;
                            wpvr_mm_proceed();
                        }
                    });
                }

                wpvr_mm_print('<h4>Migrating WPVR Meta Structure (v<?php echo WPVR_META_MIGRATION_VERSION; ?>)</h4>');

                //Init Recursive Process
                wpvr_mm_proceed();
            });
		</script>
		<?php
		
		wpvr_die();
	}
	
	// Source Actions
	add_action( 'wp_ajax_nopriv_count_source_meta' , 'wpvr_count_source_meta_ajax_function' );
	add_action( 'wp_ajax_count_source_meta' , 'wpvr_count_source_meta_ajax_function' );
	function wpvr_count_source_meta_ajax_function() {
		
		$continue       = 1;
		$wm             = new WPVR_Meta_Sources( WPVR_META_MIGRATION_VERSION );
		$old_rows_count = $wm->check_old_meta_rows();
		
		if ( $old_rows_count === 0 ) {
			$message  = "No entry found.";
			$continue = 0;
		} else {
			$message = "<strong>{$old_rows_count}</strong> old source meta entries found.";
		}
		
		echo wpvr_get_json_response( $continue , 1 , $message );
		wpvr_die();
	}
	
	add_action( 'wp_ajax_nopriv_construct_source_meta_table' , 'wpvr_construct_source_meta_table_ajax_function' );
	add_action( 'wp_ajax_construct_source_meta_table' , 'wpvr_construct_source_meta_table_ajax_function' );
	function wpvr_construct_source_meta_table_ajax_function() {
		
		$wm = new WPVR_Meta_Sources( WPVR_META_MIGRATION_VERSION );
		$wm->construct_meta_table();
		
		$message = "Created new custom meta table for sources.";
		
		echo wpvr_get_json_response( 1 , 1 , $message );
		wpvr_die();
	}
	
	add_action( 'wp_ajax_nopriv_move_old_source_meta' , 'wpvr_move_old_source_meta_ajax_function' );
	add_action( 'wp_ajax_move_old_source_meta' , 'wpvr_move_old_source_meta_ajax_function' );
	function wpvr_move_old_source_meta_ajax_function() {
		
		$continue       = 1;
		$wm             = new WPVR_Meta_Sources( WPVR_META_MIGRATION_VERSION );
		$old_rows_moved = $wm->move_old_meta_rows();
		
		if ( $old_rows_moved === 0 ) {
			$message  = "No entry moved.";
			$continue = 0;
		} else {
			$message = "<strong>{$old_rows_moved}</strong> source meta entries moved to the meta table.";
		}
		
		echo wpvr_get_json_response( $continue , 1 , $message );
		wpvr_die();
	}
	
	add_action( 'wp_ajax_nopriv_clean_old_source_meta' , 'wpvr_clean_old_source_meta_ajax_function' );
	add_action( 'wp_ajax_clean_old_source_meta' , 'wpvr_clean_old_source_meta_ajax_function' );
	function wpvr_clean_old_source_meta_ajax_function() {
		$wm               = new WPVR_Meta_Sources( WPVR_META_MIGRATION_VERSION );
		$old_rows_cleaned = $wm->clean_old_meta_rows();
		
		if ( $old_rows_cleaned === 0 ) {
			$message = "No entry cleaned.";
		} else {
			$message = "<strong>{$old_rows_cleaned}</strong> source meta entries cleaned.";
		}
		
		echo wpvr_get_json_response( 1 , 1 , $message );
		wpvr_die();
	}
	
	// Video Actions
	add_action( 'wp_ajax_nopriv_count_video_meta' , 'wpvr_count_video_meta_ajax_function' );
	add_action( 'wp_ajax_count_video_meta' , 'wpvr_count_video_meta_ajax_function' );
	function wpvr_count_video_meta_ajax_function() {
		$post_type      = $_POST[ 'post_type' ];
		$continue       = 1;
		$wm             = new WPVR_Meta_Videos( WPVR_META_MIGRATION_VERSION );
		$old_rows_count = $wm->check_old_meta_rows( $post_type );
		
		if ( $old_rows_count === 0 ) {
			$message  = "No entry found.";
			$continue = 0;
		} else {
			$message = "<strong>{$old_rows_count}</strong> meta entries found.";
		}
		
		echo wpvr_get_json_response( $continue , 1 , $message );
		wpvr_die();
	}
	
	add_action( 'wp_ajax_nopriv_construct_video_meta_table' , 'wpvr_construct_video_meta_table_ajax_function' );
	add_action( 'wp_ajax_construct_video_meta_table' , 'wpvr_construct_video_meta_table_ajax_function' );
	function wpvr_construct_video_meta_table_ajax_function() {
		
		$wm = new WPVR_Meta_Videos( WPVR_META_MIGRATION_VERSION );
		$wm->construct_meta_table();
		
		$message = "Created new custom meta table for videos.";
		
		echo wpvr_get_json_response( null , 1 , $message );
		wpvr_die();
	}
	
	add_action( 'wp_ajax_nopriv_move_old_video_meta' , 'wpvr_move_old_video_meta_ajax_function' );
	add_action( 'wp_ajax_move_old_video_meta' , 'wpvr_move_old_video_meta_ajax_function' );
	function wpvr_move_old_video_meta_ajax_function() {
		$post_type      = $_POST[ 'post_type' ];
		$continue       = 1;
		$wm             = new WPVR_Meta_Videos( WPVR_META_MIGRATION_VERSION );
		$old_rows_moved = $wm->move_old_meta_rows( $post_type );
		
		if ( $old_rows_moved === 0 ) {
			$message  = "No entry moved.";
			$continue = 0;
		} else {
			$message = "<strong>{$old_rows_moved}</strong> video meta entries moved to the meta table.";
		}
		
		echo wpvr_get_json_response( $continue , 1 , $message );
		wpvr_die();
	}
	
	add_action( 'wp_ajax_nopriv_clean_old_video_meta' , 'wpvr_clean_old_video_meta_ajax_function' );
	add_action( 'wp_ajax_clean_old_video_meta' , 'wpvr_clean_old_video_meta_ajax_function' );
	function wpvr_clean_old_video_meta_ajax_function() {
		$post_type = $_POST[ 'post_type' ];
		
		$wm               = new WPVR_Meta_videos( WPVR_META_MIGRATION_VERSION );
		$old_rows_cleaned = $wm->clean_old_meta_rows( $post_type );
		
		if ( $old_rows_cleaned === 0 ) {
			$message = "No entry cleaned.";
		} else {
			$message = "<strong>{$old_rows_cleaned}</strong> video meta entries cleaned.";
		}
		
		echo wpvr_get_json_response( 1 , 1 , $message );
		wpvr_die();
	}
	
	// Update Meta Migrate Version
	add_action( 'wp_ajax_nopriv_update_meta_structure_version' , 'wpvr_update_meta_structure_version_ajax_function' );
	add_action( 'wp_ajax_update_meta_structure_version' , 'wpvr_update_meta_structure_version_ajax_function' );
	function wpvr_update_meta_structure_version_ajax_function() {
		
		update_option( 'wpvr_meta_migration_done' , WPVR_META_MIGRATION_VERSION );
		wpvr_remove_notice( 'wpvr_ask_for_migration' );
		
		echo wpvr_get_json_response( 1 , 1 , 'Version Updated!' );
		wpvr_die();
	}