<?php
	
	
	/* Load JS scripts(minified or normal) in admin area only */
	add_action( 'wp_head', 'wpvr_load_scripts' );
	add_action( 'admin_head', 'wpvr_load_scripts' );
	function wpvr_load_scripts( $force_load = false ) {
		
		
		if ( $force_load !== true && ! wpvr_is_plugin_screen() ) {
			return;
		}
		
		global $wpvr_options, $js_localize_array;
		if ( WPVR_DEV_MODE === false && WPVR_USE_MIN_JS === true ) {
			$js_functions_file = WPVR_URL . 'assets/js/wpvr.functions.min.js';
		} else {
			$js_functions_file = WPVR_URL . 'assets/js/wpvr.functions.js';
		}
		
		//wpvr_globals.ajax_url
		$js_globals_array = array(
			'functions_js' => $js_functions_file,
			'api_auth_url' => WPVR_AUTH_URL,
			'wpvr_js'      => WPVR_JS,
			'ajax_url'     => admin_url( 'admin-ajax.php' ),
			'locale'       => get_locale(),
		
		);
		
		wp_enqueue_script( 'jquery' );
		
		if ( WPVR_DEV_MODE === false && WPVR_USE_MIN_JS === true ) {
			$js_file = WPVR_URL . 'assets/js/wpvr.scripts.min.js';
			
			wp_register_script( 'wpvr_scripts', $js_file . '?version=' . WPVR_VERSION, array( 'jquery' ) );
			wp_localize_script( 'wpvr_scripts', 'wpvr_localize', $js_localize_array );
			wp_localize_script( 'wpvr_scripts', 'wpvr_globals', $js_globals_array );
			wp_localize_script( 'wpvr_scripts', 'wpvr_options', $wpvr_options );
			wp_enqueue_script( 'wpvr_scripts' );
			
			wp_enqueue_script( 'wpvr_scripts_loaded', WPVR_URL . 'assets/js/wpvr.scripts.loaded.min.js' );
			
		} else {
			$js_file = WPVR_URL . 'assets/js/wpvr.scripts.js';
			
			wp_register_script( 'wpvr_scripts_assets', WPVR_URL . 'assets/js/wpvr.assets.min.js' );
			wp_enqueue_script( 'wpvr_scripts_assets' );
			
			wp_register_script( 'wpvr_scripts', $js_file . '?version=' . WPVR_VERSION );
			wp_localize_script( 'wpvr_scripts', 'wpvr_localize', $js_localize_array );
			wp_localize_script( 'wpvr_scripts', 'wpvr_globals', $js_globals_array );
			wp_localize_script( 'wpvr_scripts', 'wpvr_options', $wpvr_options );
			wp_enqueue_script( 'wpvr_scripts' );
			
			wp_enqueue_script( 'wpvr_scripts_loaded', WPVR_URL . 'assets/js/wpvr.scripts.loaded.min.js' );
			
			//wp_register_script( 'wpvr_notices_script' , WPVR_URL . 'assets/js/wpvr.notices.scripts.js' , array(
			//	'jquery' ,
			//	'wpvr_scripts' ,
			//) );
			//wp_enqueue_script( 'wpvr_notices_script' );
		}
	}
	
	/* Load CSS files (minified or normal version) in admin area only */
	add_action( 'wp_head', 'wpvr_load_styles' );
	add_action( 'admin_head', 'wpvr_load_styles' );
	function wpvr_load_styles( $force_load = false ) {
		
		if ( $force_load !== true && ! wpvr_is_plugin_screen() ) {
			return;
		}
		
		if ( is_admin() ) {
			if ( WPVR_USE_LOCAL_FONTAWESOME ) {
				wp_register_style( 'wpvr_icons', WPVR_URL . 'assets/css/font-awesome.min.css' );
				wp_enqueue_style( 'wpvr_icons' );
			} else {
				wp_register_style( 'wpvr_icons', WPVR_FONTAWESOME_CSS_URL );
				wp_enqueue_style( 'wpvr_icons' );
			}
		}
		
		if ( WPVR_DEV_MODE === false && WPVR_USE_MIN_CSS === true ) {
			
			$css_file = WPVR_URL . 'assets/css/wpvr.styles.min.css';
			wp_register_style( 'wpvr_styles', $css_file . '?version=' . WPVR_VERSION );
			wp_enqueue_style( 'wpvr_styles' );
			
		} else {
			
			$css_file = WPVR_URL . 'assets/css/wpvr.styles.css';
			wp_register_style( 'wpvr_assets_styles', WPVR_URL . 'assets/css/wpvr.assets.min.css' );
			wp_enqueue_style( 'wpvr_assets_styles' );
			
			wp_register_style( 'wpvr_styles', $css_file . '?version=' . WPVR_VERSION );
			wp_enqueue_style( 'wpvr_styles' );
			
			//wp_register_style( 'wpvr_notices_styles' , WPVR_URL . 'assets/css/wpvr.notices.styles.css?version=' . WPVR_VERSION );
			//wp_enqueue_style( 'wpvr_notices_styles' );
		}
		
		if ( is_rtl() ) {
			wp_enqueue_style( 'wpvr_styles_rtl', WPVR_URL . 'assets/css/wpvr.styles.rtl.css' );
		}
	}
	
	/* Load CSS fix for embedding youtube player */
	add_action( 'wp_head', 'wpvr_load_services_css_styles', 120 );
	add_action( 'admin_head', 'wpvr_load_services_css_styles', 120 );
	function wpvr_load_services_css_styles() {
		global $wpvr_vs;
		
		if ( ! wpvr_is_plugin_screen() ) {
			return;
		}
		
		$css = '';
		$css .= '.is_small.wpvr_external_thumbnail{margin:-33px 0 -41px !important;}';
		$css .= '#adminmenu .menu-icon-video div.wp-menu-image:before {content: "\f126";}';
		$css .= '#adminmenu .menu-icon-source div.wp-menu-image:before {content: "\f179";}';
		
		if ( count( $wpvr_vs ) != 0 ) {
			foreach ( (array) $wpvr_vs as $vs ) {
				if ( WPVR_DEV_MODE === true ) {
					$css .= "/*WPVR DEV MODE */\n";
					$css .= "#adminmenuback{display:none;}\n";
					$css .= "/*WPVR DEV MODE */\n";
				}
				$css .= "/*WPVR VIDEO SERVICE STYLES ( " . $vs['label'] . " ) */\n";
				//$css .= "/* START */\n";
				// $css .= trim( preg_replace( '/\t+/', '', $vs['get_styles']() ) );
				$css .= trim( preg_replace( '/\t+/', '', wpvr_render_vs_styles( $vs ) ) );
				//$css .= "<!-- END -->\n";
				$css .= "/* WPVR VIDEO SERVICE STYLES ( " . $vs['label'] . " ) */\n\n";
			}
		}
		echo "<style>\n $css\n </style>\n";
	}
	
	/* Load CSS fix for embedding youtube player */
	add_action( 'wp_head', 'wpvr_load_dynamic_css', 100 );
	add_action( 'admin_head', 'wpvr_load_dynamic_css', 100 );
	function wpvr_load_dynamic_css() {
		global $wpvr_status, $wpvr_services;
		
		if ( ! wpvr_is_plugin_screen() ) {
			return;
		}
		
		$css = '';
		$css .= '.wpvr_embed .fluid-width-video-wrapper{ padding-top:56% !important; }';
		$css .= '.ad-container.ad-container-single-media-element-annotations.ad-overlay{ background:red !important; }';
		/*
		$css .= '.wpvr_button{ background : '.WPVR_BUTTON_BGCOLOR.' !important; color : '.WPVR_BUTTON_COLOR.' !important; }';
		$css .= '.wpvr_button:hover{ background : '.WPVR_BUTTON_HOVER_BGCOLOR.' !important; color : '.WPVR_BUTTON_HOVER_COLOR.' !important; }';
		*/
		foreach ( (array) $wpvr_status as $value => $data ) {
			$css .= '.wpvr_video_status.' . $value . '{ background:' . $data['color'] . ' ;} ';
		}
		?>
        <style><?php echo $css; ?></style><?php
	}
	
	/* Load CSS fix for embedding youtube player */
	add_action( 'wp_footer', 'wpvr_load_css_fix' );
	function wpvr_load_css_fix() {
		global $wpvr_status, $wpvr_services;
		
		$css = '';
		
		foreach ( (array) $wpvr_status as $value => $data ) {
			$css .= '.wpvr_video_status.' . $value . '{ background-color:red;}';
		}
		
		
		?>
        <style>
            <?php echo $css; ?>
            .wpvr_embed {
                position: relative !important;
                padding-bottom: 56.25% !important;
                height: 0 !important;
                overflow: hidden !important;
            }

            .wpvr_embed.wpvr_vst_embed {
                padding-top: 0px !important;
            }

            .wpvr_embed iframe, .wpvr_embed object, .wpvr_embed embed {
                position: absolute !important;
                top: 0 !important;
                left: 0 !important;
                width: 100% !important;
                height: 100% !important;
            }
        </style>
		<?php
	}
	
	add_filter( 'wp_head', 'wpvr_watermark', 10000 );
	function wpvr_watermark() {
		$act = wpvr_get_activation( 'wpvr' );
		if ( $act['act_status'] == 1 ) {
			$licensed = " - License activated by " . $act['buy_user'] . ".";
		} else {
			$licensed = " - Not Activated. ";
		}
		echo "\n <!-- ##WPVR : WP Video Robot version " . $act["act_version"] . " " . $licensed . "--> \n";
	}
	