<?php
	
	define( 'WPVR_AUTOUPDATE_BYPASS_CACHE', false );
	
	class wpvr_autoupdate_product {
		public $current_version;
		public $new_version;
		public $plugin_slug;
		public $slug;
		public $update_zip_url;
		
		function __construct( $current_version, $plugin_slug, $update_zip_url ) {
			
			$this->current_version = $current_version;
			$this->update_zip_url  = $update_zip_url;
			$this->plugin_slug     = $plugin_slug;
			
			list ( $t1, $t2 ) = explode( '/', $plugin_slug );
			$this->slug = str_replace( '.php', '', $t2 );
			
			// define the alternative API for updating checking
			add_filter( 'pre_set_site_transient_update_plugins', array( &$this, 'check_update' ) );
			add_filter( 'upgrader_post_install', array( &$this, 'remove_update_notification' ), 10, 3 );
			
			
			add_filter( 'pre_set_site_transient_update_plugins', function ( $transient ) {
				
				//d( $transient );
				
				return $transient;
			}, 1000 );
			
			// Define the alternative response for information checking
			add_filter( 'plugins_api_result', array( &$this, 'check_info' ), 1000, 3 );
			
			//d( $this );
			
		}
		
		public function remove_update_notification( $true, $hook_extra, $result ) {
			global $current_user;
			
			if ( isset( $result['destination_name'] ) && $result['destination_name'] !== $this->slug ) {
				return $true;
			}
			
			$plugin_slug = $this->plugin_slug;
			$v           = $this->get_remote_version();
			if ( $v === false || ! property_exists( $v, 'version' ) ) {
				$new_version = $this->current_version;
			} else {
				$new_version = $v->version;
			}
			$notice_slug = '_wpvr_update_' . $this->slug . '_' . $new_version;
			//d( $notice_slug );
			
			wpvr_remove_notice( $notice_slug, true );
			wpvr_remove_notice( $notice_slug, false );
			
			if ( isset( $hook_extra ) ) {
				if ( isset( $hook_extra['plugin'] ) && $hook_extra['plugin'] == $plugin_slug ) {
					add_user_meta( $current_user->ID, $notice_slug, 'true', true );
				}
			}
			
			return $result;
		}
		
		public function get_remote_version() {
			
			
			global $autoupdate_debuggable_products;
			
			if ( WPVR_ENABLE_AUTOUPDATE_DEBUG ) {
				$beta = in_array( $this->slug, $autoupdate_debuggable_products ) ? true : false;
			} else {
				$beta = false;
			}
			$api = wpvr_capi_release_get_full_version( $this->slug, $beta );
			
			//if( $this->slug === 'wpvr-ci') {
			//	d( $this->plugin_slug , $this->slug , $api , $beta );
			//}
			
			if ( $api['status'] != '1' ) {
				return false;
			}
			
			if ( ! isset( $api['data'][ $this->slug ] ) ) {
				return false;
			}
			
			// d( $api['data'][ $this->slug ] );
			return $api['data'][ $this->slug ];
			
		}
		
		public function check_update( $transient ) {
			global $wpvr_new_version_available, $updates_notices;
			
			if ( $this->plugin_slug !== 'wpvr-vst' ) {
				return false;
			}
			
			if ( empty( $transient->checked ) ) {
				//echo "empty transient";
				//return $transient;
			}
			//d( $this->slug );
			if ( ! is_plugin_active( $this->plugin_slug ) ) {
				return $transient;
			}
			
			
			$this->find_expired_licenses();
			
			$v = $this->get_remote_version();
			
			
			if ( $v === false ) {
				return $transient;
			}
			
			if ( ! property_exists( $v, 'version' ) ) {
				return $transient;
			}
			
			$remote_version = $v->version;
			
			//Remove any previous update notice of the current product
			wpvr_remove_notice( '_wpvr_update_' . $this->slug . '_', is_multisite(), true );
			
			
			if ( version_compare( $this->current_version, $remote_version, '>=' ) ) {
				// Remove any previous update notice of the current product
				// wpvr_remove_notice( '_wpvr_update_' . $this->slug . '_' , is_multisite() , true );
				
				return $transient;
			}
			
			
			$act = is_multisite() ? wpvr_get_multisite_activation( $this->slug, null, true ) : wpvr_get_activation( $this->slug );
			
			$download_url = $act['act_status'] === 1 ? $this->get_remote_download( $remote_version ) : '#';
			
			
			$obj              = new stdClass();
			$obj->id          = $this->slug;
			$obj->slug        = $this->slug;
			$obj->plugin      = $this->plugin_slug;
			$obj->new_version = $remote_version;
			$obj->url         = WPVR_API_REQ_URL;
			$obj->package     = $download_url;
			
			$obj->icons = array(
				'1x'      => $this->slug === 'wpvr' ? WPVR_AUTOUPDATE_ICON_CORE : WPVR_AUTOUPDATE_ICON_ADDON,
				'2x'      => $this->slug === 'wpvr' ? WPVR_AUTOUPDATE_ICON_CORE : WPVR_AUTOUPDATE_ICON_ADDON,
				'default' => $this->slug === 'wpvr' ? WPVR_AUTOUPDATE_ICON_CORE : WPVR_AUTOUPDATE_ICON_ADDON,
			);
			
			
			//d( $obj );
			$transient->response[ $this->plugin_slug ] = $obj;
			
			$wpvr_new_version_available = $remote_version;
			if ( ! isset( $_GET['action'] ) || $_GET['action'] != 'do-plugin-upgrade' ) {
				// d( 'Added new notice for ' . $this->slug );
				
				
				// d( $this->current_version , $remote_version,  version_compare( $this->current_version, $remote_version, '<' ) );
				
				wpvr_capi_show_update_message( array(
					'name'          => $v->name,
					'slug'          => $v->wp_slug,
					'version'       => $v->version,
					'date'          => $v->date,
					'local_version' => $this->current_version,
					'act'           => $act['act_status'],
				) );
				
				update_option( 'wpvr_new_version_before_update', $v->version, false );
				
			}
			
			return $transient;
		}
		
		public function find_expired_licenses() {
			
			if ( is_multisite() ) {
				$act = wpvr_get_multisite_activation( $this->slug, null, true );
			} else {
				$act = wpvr_get_activation( $this->slug );
			}
			
			d( $act );
			
			if ( ! isset( $act['act_id'] ) ) {
				return false;
			}
			$act_id = $act['act_id'];
			$api    = wpvr_capi_check_expiration( $this->slug, $act_id );
			d( $api );
			
			
			return false;
			if ( ! isset( $api['status'] ) || $api['status'] != 1 ) {
				return false;
			}
			
			//d( $api );
			
			//d( $this->slug . ' : '. $act['buy_expires'] );
			$new_act            = $api['data'];
			$act['buy_expires'] = $new_act['buy_expires'];
			//d( $this->slug . ' : '. $act['buy_expires'] );
			if ( $act['buy_expires'] == '' ) {
				return false;
			}
			$now      = new Datetime();
			$expired  = new Datetime( $act['buy_expires'] );
			$interval = $now->diff( $expired, true );
			
			//d( $now > $expired, $now->format( 'Y-m-d H:i:s' ), $expired->format( 'Y-m-d H:i:s' ), $interval->format( '%a days' ) );
			
			if ( $now > $expired ) {
				wpvr_capi_show_expiration_message( array(
					'slug'    => $this->slug,
					'since'   => $interval->format( '%a days' ),
					'license' => $act['act_code'],
				) );
			}
			
			wpvr_set_activation( $this->slug, $act );
			
			
		}
		
		public function get_remote_download( $version ) {
			global $wpvr_new_version_msg;
			$wpvr_new_version_msg = '';
			
			if ( is_multisite() ) {
				$act = wpvr_get_multisite_activation( $this->slug, null, true );
			} else {
				$act = wpvr_get_activation( $this->slug );
			}
			
			//d( $act );
			if ( $act['act_status'] != '1' || $act['act_code'] == '' ) {
				return false;
			}
			$api = wpvr_capi_get_download(
				$this->slug,
				$act['act_code'],
				$version
			);
			
			//d( $api );
			
			if ( $api['status'] == '1' ) {
				return $api['data'];
			} else {
				//echo $api[ 'msg' ];
				return false;
			}
		}
		
		public function check_info( $res, $action, $arg ) {
			//return false;
			
			if ( property_exists( $arg, 'slug' ) && $arg->slug === $this->slug ) {
				$res = $this->get_remote_information();
				
				return $res;
			}
			
			return $res;
		}
		
		public function get_remote_information() {
			
			global $autoupdate_debuggable_products;
			
			if ( WPVR_ENABLE_AUTOUPDATE_DEBUG ) {
				$beta = in_array( $this->slug, $autoupdate_debuggable_products ) ? true : false;
			} else {
				$beta = false;
			}
			
			
			$cache_hash = md5( json_encode( array(
				$beta,
				$this->slug,
			) ) );
			
			if ( WPVR_AUTOUPDATE_BYPASS_CACHE !== true ) {
				$cached_data = wpvr_cache_get( $cache_hash );
				if ( $cached_data !== false ) {
					return ( ( $cached_data ) );
				}
			}
			
			//d( 'Loaded new version ...' );
			$api = wpvr_capi_release_get_info( $this->slug, $beta );
			
			// if( $this->slug == 'wpvr-fbvs' ){
			// 	d( $api , $beta );
			// }
			
			if ( $api['status'] != '1' ) {
				return false;
			}
			
			
			$capi_update_info = unserialize( $api['data'][ $this->slug ] );
			if ( ! is_object( $capi_update_info ) ) {
				return false;
			}
			
			
			$product_ratings = wpvr_autoupdate_get_fake_ratings();
			//d( $product_ratings);
			//d( $capi_update_info );
			
			$description_section_prefix = '';
			$description_section_suffix = '';
			global $wpvr_addons;
			
			if ( isset( $wpvr_addons[ $this->slug ] ) ) {
				$description_section_prefix = '<img src="' . $wpvr_addons[ $this->slug ]['infos']['thumbnail_url'] . '" /> <br/><br/> ';
				
				$description_section_suffix .= '<br/><br/><br/> ';
				$description_section_suffix .= '<a target="_blank" href="' . $wpvr_addons[ $this->slug ]['infos']['addon_url'] . '" > Learn more about this addon</a> | ';
				$description_section_suffix .= '<a target="_blank" href="' . $wpvr_addons[ $this->slug ]['infos']['doc'] . '" > Check this addon tutorial </a>';
				
			}
			
			
			$product_name = str_replace( array( 'Wpvr ', 'Wp ' ), array(
				'WPVR ',
				'WP ',
			), ucwords( strtolower( $capi_update_info->name ) ) );
			
			$update_info = array(
				'name'                     => $product_name,
				'slug'                     => $capi_update_info->slug,
				'version'                  => $capi_update_info->new_version,
				'author'                   => '<a href="http://pressaholic.com">pressaholic</a>',
				'author_profile'           => 'http://pressaholic.com',
				'requires'                 => $capi_update_info->requires,
				'tested'                   => $capi_update_info->tested,
				'requires_php'             => false,
				'compatibility'            => array(),
				'rating'                   => $product_ratings['rating'],
				'ratings'                  => $product_ratings['ratings'],
				'num_ratings'              => $product_ratings['num_ratings'],
				'support_threads'          => 0,
				'support_threads_resolved' => 0,
				'active_installs'          => 5000,
				'last_updated'             => $capi_update_info->last_updated,
				'added'                    => '2014-08-15',
				'homepage'                 => WPVR_MAIN_URL,
				'external'                 => WPVR_MAIN_URL,
				'sections'                 => array(
					'description' => $description_section_prefix .
					                 $capi_update_info->sections['description'] .
					                 $description_section_suffix,
					'support'     => 'If you\'re facing any issue with the plugin or need help for this update, you can : <br/><br/>' .
					                 '<strong><a href="' . WPVR_DOC_URL . '" target="_blank"> Read the documentation</a></strong><br/>' .
					                 '<strong><a href="' . WPVR_SUPPORT_URL . '/tutorials/" target="_blank"> Check out the tutorials</a></strong><br/>' .
					                 '<strong><a href="' . WPVR_SUPPORT_URL . '/new-ticket/" target="_blank"> Create a support ticket </a></strong><br/>',
					'changelog'   => $capi_update_info->sections['changelog'],
				),
				'download_link'            => WPVR_CC_PAGE_URL,
				'screenshots'              => array(),
				'tags'                     => array(
					'video robot',
					'import',
					'youtube',
				),
				'versions'                 => array(),
				'donate_link'              => '',
				'banners'                  => array(
					'low'  => $this->slug === 'wpvr' ? WPVR_AUTOUPDATE_BANNER_CORE : WPVR_AUTOUPDATE_BANNER_ADDON,
					'high' => $this->slug === 'wpvr' ? WPVR_AUTOUPDATE_BANNER_CORE : WPVR_AUTOUPDATE_BANNER_ADDON,
				),
				'contributors'             => array(),
			);
			
			$update_info = (object) $update_info;
			// d( $update_info );
			wpvr_cache_set( $update_info, $cache_hash );
			
			return $update_info;
		}
		
		public function get_remote_license() {
			
			$api = wpvr_capi_release_get_full_version( $this->slug );
			if ( $api['status'] == '1' ) {
				return $api['data'][ $this->slug ]['wp_license'];
			} else {
				//echo $api[ 'msg' ];
				return false;
			}
		}
		
	}
	
	function wpvr_extend_config_file( $old_config, $new_config, $new_version ) {
		foreach ( (array) $new_config as $key => $value ) {
			if ( isset( $old_config[ $key ] ) ) {
				$new_config[ $key ] = $old_config[ $key ];
			}
			if ( $key == 'WPVR_AUTH_CUSTOM_LIST' ) {
				$new_config['WPVR_AUTH_CUSTOM_LIST'] = 'WPVR_USERS_' . WPVR_VERSION;
			}
		}
		
		$now                = new DateTime( 'now' );
		$new_config['info'] = array(
			'version' => $new_version,
			'date'    => $now->format( 'Y-m-d H:i:s' ),
		);
		
		return $new_config;
	}
	
	function wpvr_render_config_file( $config ) {
		
		$txt = "<?php \n";
		
		if ( isset( $config['info'] ) ) {
			$txt .= "\n/***************    WPVR CONFIG FILE    ***************/";
			$txt .= "\n/***************    Generated for version {$config['info']['version']} ***************/";
			$txt .= "\n/***************    On {$config['info']['date']} ***************/";
			$txt .= "\n/***************    More Info about the advanced configuration on https://support.wpvideorobot.com/tutorials/advanced-configuration/ ***************/";
			$txt .= "\n\n";
		}
		
		foreach ( (array) $config as $key => $value ) {
			
			if ( $key === 'info' ) {
				continue;
			}
			
			if ( is_int( $value ) || ctype_digit( $value ) ) {
				$real_value = $value;
			} elseif ( is_bool( $value ) ) {
				$real_value = $value === true ? 'TRUE' : 'FALSE';
				// d( $real_value );
			} elseif ( strtolower( $value ) === 'true' ) {
				$real_value = 'TRUE';
			} elseif ( strtolower( $value ) === 'false' ) {
				$real_value = 'FALSE';
			} else {
				$real_value = "'" . $value . "'";
			}
			
			$txt .= "\n\n\tdefine( '{$key}' , {$real_value} );";
			
		}
		
		return $txt;
	}
	
	function wpvr_override_config_file( $version ) {
		
		//Get Old configuration from wp_options
		$wpvr_config_before_update = get_option( 'wpvr_config_before_update' );
		
		//Get new Config from the fresh installed update
		$new_config = wpvr_parse_config_file( WPVR_PATH . 'wpvr.config.php' );
		
		//Extend new Config with old one
		// echo "<br/> Extending New Config File (" . count( $wpvr_config_before_update ) . ")... ";
		$updated_config = wpvr_extend_config_file( $wpvr_config_before_update, $new_config, $version );
		
		//Write the new config file as the sample config
		// file_put_contents( WPVR_PATH . 'wpvr.config.sample.php', file_get_contents( WPVR_PATH . 'wpvr.config.php' ) );
		
		//Generate Extended Config File Data
		$updated_config_data = wpvr_render_config_file( $updated_config );
		
		//Write down the extended config file
		// echo "<br/> Updating New Config File (" . count( $updated_config_data ) . ")... ";
		file_put_contents( WPVR_PATH . 'wpvr.config.php', $updated_config_data );
		
		return true;
	}