<?php
	
	// CAPI REMOTE GET REQUEST
	if ( ! function_exists( 'wpvr_capi_remote_get' ) ) {
		function wpvr_capi_remote_get( $url , $json = false ) {
			
			$oUrl = parse_url( $url );
			if ( isset( $oUrl[ 'query' ] ) ) {
				parse_str( $oUrl[ 'query' ] , $args );
			} else {
				$args = array();
			}
			
			$curl_object = curl_init();
			curl_setopt( $curl_object , CURLOPT_URL , $url );
			curl_setopt( $curl_object , CURLOPT_SSL_VERIFYPEER , false );
			curl_setopt( $curl_object , CURLOPT_SSL_VERIFYHOST , false );
			curl_setopt( $curl_object , CURLOPT_IPRESOLVE , CURL_IPRESOLVE_V4 );
			curl_setopt( $curl_object , CURLOPT_FOLLOWLOCATION , 1 );
			curl_setopt( $curl_object , CURLOPT_RETURNTRANSFER , true );
			curl_setopt( $curl_object , CURLOPT_HEADER , false );
			curl_setopt( $curl_object , CURLOPT_USERAGENT , 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13' );
			$data = curl_exec( $curl_object );
			
			return array(
				'url'    => $url ,
				'args'   => $args ,
				'status' => curl_getinfo( $curl_object , CURLINFO_HTTP_CODE ) ,
				'data'   => $json ? (array) wpvr_json_decode( $data ) : $data ,
				'body'   => $data ,
			);
		}
	}
	
	if ( ! function_exists( 'wpvr_capi_remote_post' ) ) {
		function wpvr_capi_remote_post( $url , $fields , $json = false ) {
			
			$oUrl = parse_url( $url );
			$args = array();
			if ( isset( $oUrl[ 'query' ] ) ) {
				parse_str( $oUrl[ 'query' ] , $args );
			}
			
			$json_fields = array(
				'fields' => json_encode( $fields ) ,
			);
			
			$curl_object = curl_init();
			curl_setopt( $curl_object , CURLOPT_URL , $url );
			curl_setopt( $curl_object , CURLOPT_SSL_VERIFYPEER , false );
			curl_setopt( $curl_object , CURLOPT_RETURNTRANSFER , true );
			curl_setopt( $curl_object , CURLOPT_HEADER , false );
			curl_setopt( $curl_object , CURLOPT_USERAGENT , 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13' );
			curl_setopt( $curl_object , CURLOPT_POST , count( $fields ) );
			curl_setopt( $curl_object , CURLOPT_POSTFIELDS , http_build_query( $json_fields , '' , '&' ) );
			
			$data = curl_exec( $curl_object );
			
			return array(
				'url'    => $url ,
				'args'   => $args ,
				'fields' => $fields ,
				'status' => curl_getinfo( $curl_object , CURLINFO_HTTP_CODE ) ,
				'data'   => $json ? (array) wpvr_json_decode( $data ) : $data ,
				'body'   => $data ,
			);
		}
	}
	
	// CAPI BUILD QUERY FROM URL AND ARGS ARRAY
	if ( ! function_exists( 'wpvr_capi_build_query' ) ) {
		function wpvr_capi_build_query( $url = null , $args ) {
			if ( $url == null ) {
				$url      = "$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
				$protocol = stripos( $_SERVER[ 'SERVER_PROTOCOL' ] , 'https' ) === true ? 'https://' : 'http://';
			} else {
				$protocol = '';
			}
			
			$oUrl = parse_url( $url );
			
			if ( isset( $oUrl[ 'query' ] ) ) {
				parse_str( $oUrl[ 'query' ] , $new_args );
			} else {
				$new_args = array();
			}
			if ( $args != array() && count( $args ) > 0 ) {
				foreach ( (array) $args as $key => $val ) {
					if ( $val === false ) {
						unset( $new_args[ $key ] );
					} else {
						$new_args[ $key ] = $val;
					}
				}
			}
			
			if ( $protocol == '' && isset( $oUrl[ 'path' ] ) ) {
				return $oUrl[ 'scheme' ] . '://' . $oUrl[ 'host' ] . $oUrl[ 'path' ] . '?' . http_build_query( $new_args );
			}
			if ( ! isset( $oUrl[ 'path' ] ) ) {
				return $oUrl[ 'scheme' ] . '://' . $oUrl[ 'host' ] . '?' . http_build_query( $new_args );
			}
			
			if ( $url == 0 ) {
				return '?' . http_build_query( $new_args );
			}
			
			return $protocol . $oUrl[ 'path' ] . '?' . http_build_query( $new_args );
		}
	}
	
	// GET FULL RELEASE INFOS
	if ( ! function_exists( 'wpvr_capi_release_get_full_version' ) ) {
		function wpvr_capi_release_get_full_version( $product_slug , $beta = false ) {
			
			$act = is_multisite() ? wpvr_get_multisite_activation( $product_slug , null , true ) : wpvr_get_activation( $product_slug );
			
			if( !isset( $act['act_id'] ) ){
				return array(
					'status' => false ,
					'msg'    => 'Product not licensed.' ,
					'data'   => null ,
				);
			}
			
			// d( $product_slug , $act );
			
			$capi_args = array(
				'api_key'         => WPVR_API_REQ_KEY ,
				'action'          => 'get_version' ,
				'products_slugs'  => $product_slug ,
				'encrypt_results' => 1 ,
				'activation'      => array(
					'domain'  => $act[ 'act_domain' ] ,
					'url'     => $act[ 'act_url' ] ,
					'version' => $act[ 'act_version' ] ,
					'code'    => $act[ 'act_code' ] ,
					'id'      => $act[ 'act_id' ] ,
					'slug'    => $product_slug ,
				) ,
			);
			
			if ( $beta === true ) {
				$capi_args[ 'get_beta_version' ] = 1;
			}
			
			$url = wpvr_capi_build_query( WPVR_API_REQ_URL , $capi_args );
			$response = wpvr_capi_remote_get( $url , false );
			
			if ( $response[ 'status' ] != 200 ) {
				return array(
					'status' => false ,
					'msg'    => 'CAPI unreachable.' ,
					'data'   => null ,
				);
			}
			
			$data = (array) wpvr_json_decode( $response[ 'data' ] );
			
			if ( $data == array() ) {
				return false;
			}
			
			$data[ 'data' ] = (array) wpvr_json_decode( base64_decode( $data[ 'data' ] ) );
			
			return (array ) $data;
		}
	}
	
	// GET VERSION FROM comma separated products slugs
	if ( ! function_exists( 'wpvr_capi_release_get_version' ) ) {
		function wpvr_capi_release_get_version( $product_slug ) {
			$url      = wpvr_capi_build_query( WPVR_API_REQ_URL , array(
				'api_key'         => WPVR_API_REQ_KEY ,
				'action'          => 'get_version' ,
				'products_slugs'  => $product_slug ,
				'encrypt_results' => 1 ,
				'only_version'    => 1 ,
			) );
			$response = wpvr_capi_remote_get( $url , false );
			
			if ( $response[ 'status' ] != 200 ) {
				return array(
					'status' => false ,
					'msg'    => 'CAPI unreachable.' ,
					'data'   => null ,
				);
			}
			$data = (array) wpvr_json_decode( $response[ 'data' ] );
			
			$data[ 'data' ] = (array) wpvr_json_decode( base64_decode( $data[ 'data' ] ) );
			
			return (array ) $data;
		}
	}
	
	if ( ! function_exists( 'wpvr_capi_activate' ) ) {
		function wpvr_capi_activate( $product_slug , $purchase_code , $code_type , $new_email = '' , $new_domain = '' , $new_url = '' , $new_ip = '' , $new_cinfos = '' , $new_version = '' ) {
			global $WPVR_SERVER;
			$url = wpvr_capi_build_query( WPVR_API_REQ_URL , array(
				'api_key'        => WPVR_API_REQ_KEY ,
				'action'         => 'activate' ,
				'products_slugs' => $product_slug ,
				'new_domain'     => $new_domain ,
				'purchase_code'  => $purchase_code ,
				'new_email'      => $new_email ,
				'new_url'        => $new_url ,
				'new_ip'         => $new_ip ,
				'new_cinfos'     => $new_cinfos ,
				'new_version'    => $new_version ,
				'code_type'      => $code_type ,
				'only_results'   => 1 ,
				
				'origin' => $WPVR_SERVER[ 'HTTP_HOST' ] ,
			) );
			
			$response = wpvr_capi_remote_get( $url , false );
			
			if ( $response[ 'status' ] != 200 ) {
				return array(
					'status' => false ,
					'msg'    => 'CAPI unreachable.' ,
					'data'   => null ,
				);
			}
			$dresp = (array) wpvr_json_decode( base64_decode( $response[ 'data' ] ) );
			if ( $dresp == array() ) {
				$dresp = (array) wpvr_json_decode( $response[ 'data' ] );
			}
			
			if ( ! isset( $dresp[ 'status' ] ) ) {
				return array(
					'status' => false ,
					'msg'    => 'CAPI error or unreachable.' ,
					'data'   => null ,
				);
			}
			
			if ( is_bool( $dresp[ 'status' ] ) ) {
				$status = ( $dresp[ 'status' ] === true ) ? 1 : 0;
			} else {
				$status = $dresp[ 'status' ];
			}
			
			return array(
				'status' => $status ,
				'msg'    => $dresp[ 'msg' ] ,
				'data'   => $dresp[ 'data' ] ,
			);
		}
	}
	
	if ( ! function_exists( 'wpvr_capi_get_download' ) ) {
		function wpvr_capi_get_download( $product_slugs , $purchase_code , $download_version = '' ) {
			global $WPVR_SERVER;
			$url = wpvr_capi_build_query( WPVR_API_REQ_URL , array(
				'api_key'          => WPVR_API_REQ_KEY ,
				'action'           => 'get_download' ,
				'products_slugs'   => $product_slugs ,
				'encrypt_results'  => 1 ,
				'purchase_code'    => $purchase_code ,
				'download_version' => $download_version ,
				'origin'           => $WPVR_SERVER[ 'HTTP_HOST' ] ,
				'only_results'     => 1 ,
			) );
			
			$response = wpvr_capi_remote_get( $url , false );
			
			if ( $response[ 'status' ] != 200 ) {
				return array(
					'status' => false ,
					'msg'    => 'CAPI unreachable.' ,
					'data'   => null ,
				);
			}
			$dresp = (array) wpvr_json_decode( base64_decode( $response[ 'data' ] ) );
			if ( $dresp == array() ) {
				$dresp = (array) wpvr_json_decode( $response[ 'data' ] );
			}
			
			return array(
				'status' => ( $dresp[ 'status' ] === true ) ? 1 : 0 ,
				'msg'    => $dresp[ 'msg' ] ,
				'data'   => $dresp[ 'data' ] ,
			);
		}
	}
	
	if ( ! function_exists( 'wpvr_capi_verify_code' ) ) {
		function wpvr_capi_verify_code( $product_slug , $purchase_code , $code_type , $new_domain = '' , $get_details = false ) {
			$args = array(
				'api_key'         => WPVR_API_REQ_KEY ,
				'action'          => 'verify' ,
				'encrypt_results' => 1 ,
				'only_results'    => 1 ,
				'products_slugs'  => $product_slug ,
				'purchase_code'   => $purchase_code ,
				'code_type'       => $code_type ,
				'new_domain'      => $new_domain ,
			);
			if ( $get_details != false ) {
				$args[ 'get_license_details' ] = 1;
			}
			
			$url = wpvr_capi_build_query( WPVR_API_REQ_URL , $args );
			
			$response = wpvr_capi_remote_get( $url , false );
			
			if ( $response[ 'status' ] != 200 ) {
				return array(
					'status' => false ,
					'msg'    => 'CAPI unreachable.' ,
					'data'   => null ,
				);
			}
			
			$dresp = (array) wpvr_json_decode( base64_decode( $response[ 'data' ] ) );
			
			return array(
				'status' => ( $dresp[ 'valid' ] === true ) ? 1 : 0 ,
				'msg'    => $dresp[ 'msg' ] ,
				'data'   => $dresp[ 'data' ] ,
			);
		}
	}
	
	if ( ! function_exists( 'wpvr_capi_get_addons' ) ) {
		function wpvr_capi_get_addons( $parent_slug ) {
			global $WPVR_SERVER;
			$url = wpvr_capi_build_query( WPVR_API_REQ_URL , array(
				'api_key'         => WPVR_API_REQ_KEY ,
				'action'          => 'get' ,
				'encrypt_results' => 1 ,
				'get_addons'      => 1 ,
				'addon_of'        => $parent_slug ,
				'origin'          => $WPVR_SERVER[ 'HTTP_HOST' ] ,
			) );
			
			$response = wpvr_capi_remote_get( $url , false );
			
			if ( $response[ 'status' ] != 200 ) {
				return array(
					'status' => false ,
					'msg'    => 'CAPI unreachable.' ,
					'data'   => null ,
				);
			}
			$data = (array) wpvr_json_decode( $response[ 'data' ] );
			
			$data[ 'data' ] = (array) wpvr_json_decode( base64_decode( $data[ 'data' ] ) );
			
			return (array ) $data;
		}
	}
	
	if ( ! function_exists( 'wpvr_capi_release_get_info' ) ) {
		function wpvr_capi_release_get_info( $product_slug , $beta = false ) {
			
			$capi_args = array(
				'api_key'         => WPVR_API_REQ_KEY ,
				'action'          => 'get_version' ,
				'products_slugs'  => $product_slug ,
				'encrypt_results' => 1 ,
				'render_wp_info'  => 1 ,
			);
			
			if ( $beta === true ) {
				$capi_args[ 'get_beta_version' ] = 1;
			}
			
			$url      = wpvr_capi_build_query( WPVR_API_REQ_URL , $capi_args );
			$response = wpvr_capi_remote_get( $url , false );
			
			if ( $response[ 'status' ] != 200 ) {
				return array(
					'status' => false ,
					'msg'    => 'CAPI unreachable.' ,
					'data'   => null ,
				);
			}
			$data = (array) wpvr_json_decode( $response[ 'data' ] );
			
			$data[ 'data' ] = (array) wpvr_json_decode( base64_decode( $data[ 'data' ] ) );
			
			return (array ) $data;
		}
	}
	
	if ( ! function_exists( 'wpvr_capi_alert' ) ) {
		function wpvr_capi_alert( $product_slug , $domain , $url , $ip , $version , $code = '' ) {
			global $WPVR_SERVER;
			$url      = wpvr_capi_build_query( WPVR_API_REQ_URL , array(
				'api_key'        => WPVR_API_REQ_KEY ,
				'action'         => 'alert' ,
				'products_slugs' => $product_slug ,
				'alert_domain'   => $domain ,
				'alert_code'     => $code ,
				'alert_url'      => $url ,
				'alert_ip'       => $ip ,
				'alert_version'  => $version ,
				'origin'         => $WPVR_SERVER[ 'HTTP_HOST' ] ,
				'only_results'   => 1 ,
			) );
			$response = wpvr_capi_remote_get( $url , false );
			
			if ( $response[ 'status' ] != 200 ) {
				return array(
					'status' => false ,
					'msg'    => 'CAPI unreachable.' ,
					'data'   => null ,
				);
			}
			
			$dresp = (array) wpvr_json_decode( base64_decode( $response[ 'data' ] ) );
			if ( $dresp == array() ) {
				$dresp = (array) wpvr_json_decode( $response[ 'data' ] );
			}
			
			return array(
				'status' => ( $dresp[ 'status' ] === true ) ? 1 : 0 ,
				'msg'    => $dresp[ 'msg' ] ,
				'data'   => $dresp[ 'data' ] ,
			);
		}
	}
	
	if ( ! function_exists( 'wpvr_capi_show_update_message' ) ) {
		function wpvr_capi_show_update_message( $p = array() ) {
			
			$slug = '_wpvr_update_' . $p[ 'slug' ] . '_' . $p[ 'version' ];
			
			$link = WPVR_SITE_URL . '/wp-admin/plugin-install.php?tab=plugin-information&plugin=' . $p[ 'slug' ] . '&section=changelog&TB_iframe=true&width=772&height=709';
			
			$msg
				= 'There is a new update available for <strong>' . $p[ 'name' ] . '</strong>. <br/> ' .
				  'Your version : <strong>' . $p[ 'local_version' ] . '</strong>' .
				  ' / Latest version :<strong>' . $p[ 'version' ] . '</strong> ( ' . $p[ 'date' ] . ' ). ';
			
			if ( $p[ 'act' ] == 1 ) {
				$activate_license_button = '';
			} else {
				$activation_link = admin_url( 'admin.php?page=wpvr-licenses' );
				$activate_license_button
				                 = '
				<a style="display:inline-block;" class="wpvr_notice_button" href="' . $activation_link . '">
							<strong style="color:#FFF">Please activate your license to update.</strong>
						</a>
				';
			}
			
			$msg
				.= '
	                <p class="wrap wpvr_notice_button_wrap">
	                    <a style="display:inline-block;margin-right:5px;" class="thickbox open-plugin-details-modal wpvr_notice_button " href="' . $link . '" title="Click to update">
	                        ' . __( 'View this new version details' , WPVR_LANG ) . '
	                    </a>
	                	' . $activate_license_button . '
					</p>
				';
			
			wpvr_add_notice( array(
				'slug'      => $slug ,
				'title'     => 'WPVR : Update Available' ,
				'class'     => 'warning' , //updated or warning or error
				'content'   => $msg ,
				'hidable'   => true ,
				'is_dialog' => false ,
				'color'     => '#45B6AF' ,
				'icon'      => 'fa-refresh' ,
			) , true , is_multisite() );
		}
	}
	
	if ( ! function_exists( 'wpvr_capi_show_expiration_message' ) ) {
		function wpvr_capi_show_expiration_message( $args = array() ) {
			global $wpvr_addons;
			$args = wpvr_extend( $args , array(
				'slug'    => '' ,
				'license' => '' ,
				'since'   => '' ,
			) );
			
			if ( $args[ 'slug' ] == '' || $args[ 'slug' ] == 'wpvr' ) {
				return false;
			}
			
			$addon = $wpvr_addons[ $args[ 'slug' ] ];
			
			$slug = '_wpvr_expiration_' . $args[ 'slug' ] . '_' . $args[ 'license' ];
			$link = $addon[ 'infos' ][ 'addon_url' ];
			$msg
			      = 'Your license of <strong>' . $addon[ 'infos' ][ 'title' ] . '</strong> has expired
			        <strong>' . $args[ 'since' ] . '</strong> ago.<br/>
			        <a class="wpvr_notice_button" href="' . $addon[ 'infos' ][ 'addon_url' ] . '">
			            Renew your yearly license with a 40% discount.
			        </a> 
			        ';
			
			wpvr_add_notice( array(
				'slug'      => $slug ,
				'title'     => 'WP Video Robot : License Expiration' ,
				'class'     => 'warning' , //updated or warning or error
				'content'   => $msg ,
				'hidable'   => true ,
				'is_dialog' => false ,
				'color'     => '#45B6AF' ,
				'icon'      => 'fa-hand-peace-o' ,
			) );
		}
	}
	
	if ( ! function_exists( 'wpvr_capi_cancel_activation' ) ) {
		function wpvr_capi_cancel_activation( $code ) {
			global $WPVR_SERVER;
			$url = wpvr_capi_build_query( WPVR_API_REQ_URL , array(
				'api_key'        => WPVR_API_REQ_KEY ,
				'action'         => 'cancel_license' ,
				'products_slugs' => 'wpvr' ,
				'purchase_code'  => $code ,
				'only_results'   => 1 ,
				'origin'         => $WPVR_SERVER[ 'HTTP_HOST' ] ,
			) );
			
			$response = wpvr_capi_remote_get( $url , false );
			
			if ( $response[ 'status' ] != 200 ) {
				return array(
					'status' => false ,
					'msg'    => 'CAPI unreachable.' ,
					'data'   => nul//l ,
				);
			}
			$dresp = (array) wpvr_json_decode( base64_decode( $response[ 'data' ] ) );
			if ( $dresp == array() ) {
				$dresp = (array) wpvr_json_decode( $response[ 'data' ] );
			}
			
			if ( ! isset( $dresp[ 'status' ] ) ) {
				return array(
					'status' => false ,
					'msg'    => 'CAPI error or unreachable.' ,
					'data'   => null ,
				);
			}
			
			if ( is_bool( $dresp[ 'status' ] ) ) {
				$status = ( $dresp[ 'status' ] === true ) ? 1 : 0;
			} else {
				$status = $dresp[ 'status' ];
			}
			
			return array(
				'status' => $status ,
				'msg'    => $dresp[ 'msg' ] ,
				'data'   => $dresp[ 'data' ] ,
			);
		}
	}
	
	if ( ! function_exists( 'wpvr_capi_check_expiration' ) ) {
		function wpvr_capi_check_expiration( $slug , $act_id = null ) {
			if ( $act_id == null ) {
				$act = wpvr_get_activation( $slug );
				if ( ! isset( $act[ 'act_id' ] ) ) {
					return false;
				}
				$act_id = $act[ 'act_id' ];
			}
			if ( $act_id == '' ) {
				return false;
			}
			$url      = wpvr_capi_build_query( WPVR_API_REQ_URL , array(
				'api_key'         => WPVR_API_REQ_KEY ,
				'action'          => 'check_license' ,
				'products_slugs'  => $slug ,
				'encrypt_results' => 1 ,
				'act_id'          => $act_id ,
			) );
			$response = wpvr_capi_remote_get( $url , false );
			
			if ( $response[ 'status' ] != 200 ) {
				return array(
					'status' => false ,
					'msg'    => 'CAPI unreachable.' ,
					'data'   => null ,
				);
			}
			$data = (array) wpvr_json_decode( $response[ 'data' ] );
			if ( ! isset( $data[ 'data' ] ) ) {
				return false;
			}
			$data[ 'data' ] = (array) wpvr_json_decode( base64_decode( $data[ 'data' ] ) );
			
			return (array ) $data;
		}
	}