<?php
	
	require_once( WPVR_PATH . '/assets/php/randomColor.php' );
	
	use Colors\RandomColor;
	
	function wpvr_render_animated_check_icon( $message = '', $size = 80, $color = '#27A1CA', $stroke = '6' ) {
		
		ob_start();
		?>

        <!--[if lte IE 9]>
        <style>
            .path {
                stroke-dasharray: 0 !important;
            }
        </style>
        <![endif]-->
        <div class="wpvr_svg_wrap">
            <svg
                    class="wpvr_svg"
                    style="width:<?php echo intval( $size ); ?>px;"
                    version="1.1"
                    xmlns="http://www.w3.org/2000/svg"
                    viewBox="0 0 130.2 130.2"
            >
                <circle
                        class="path circle"
                        fill="none"
                        stroke="<?php echo $color; ?>"
                        stroke-width="<?php echo $stroke; ?>"
                        stroke-miterlimit="10" cx="65.1"
                        cy="65.1"
                        r="62.1"
                />
                <polyline
                        class="path check"
                        fill="none"
                        stroke="<?php echo $color; ?>"
                        stroke-width="<?php echo $stroke; ?>"
                        stroke-linecap="round"
                        stroke-miterlimit="10"
                        points="100.2,40.2 51.5,88.8 29.8,67.5 "
                />

            </svg>
            <div class="wpvr_svg_message" style="color:<?php echo ''; ?>">
				<?php echo $message; ?>
            </div>
        </div>
		<?php
		$output_string = ob_get_contents();
		ob_end_clean();
		
		return $output_string;
		
	}
	
	function wpvr_echo_display_none() {
		echo WPVR_DISABLE_JQUERY_ON_SCREENS === true ? '' : 'display:none;';
	}
	
	function wpvr_echo_visibility_hidden() {
		echo WPVR_DISABLE_JQUERY_ON_SCREENS === true ? '' : 'visibility:hidden;';
	}
	
	function wpvr_get_tax_data( $taxonomy, $ids, $bypass_cache = false ) {
		global $wpdb;
		
		$cache_hash   = md5( json_encode( $taxonomy ) . json_encode( $ids ) );
		$bypass_cache = apply_filters( 'wpvr_extend_bypass_cache/' . 'wpvr_get_tax_data', $bypass_cache );
		if ( $bypass_cache !== true ) {
			$cached_data = wpvr_cache_get( $cache_hash );
			if ( $cached_data !== false ) {
				return (( $cached_data ) );
			}
		}
		
		if ( ! is_array( $ids ) ) {
			return array();
		}
		$ids    = "'" . implode( "','", $ids ) . "'";
		$sql
		        = "
			select
				T.term_id as id,
				T.slug,
				T.name
			from
				$wpdb->terms T
				INNER JOIN $wpdb->term_taxonomy TT ON T.term_id  = TT.term_taxonomy_id
			where
				T.term_id IN ( $ids )
				AND TT.taxonomy = '$taxonomy'
		";
		$terms  = $wpdb->get_results( $sql );
		$return = array();
		foreach ( (array) $terms as $term ) {
			$return[ $term->id ] = array(
				'id'   => $term->id,
				'slug' => $term->slug,
				'name' => $term->name,
			);
		}
		wpvr_cache_set( $return, $cache_hash );
		
		return $return;
	}
	
	function wpvr_get_folders_simple( $bypass_cache = false ) {
		
		$cache_hash   = md5( 'wpvr_get_folders_simple' );
		$bypass_cache = apply_filters( 'wpvr_extend_bypass_cache/' . 'wpvr_get_folders_simple', $bypass_cache );
		
		if ( $bypass_cache !== true ) {
			$cached_data = wpvr_cache_get( $cache_hash );
			if ( $cached_data !== false ) {
				return ( ( $cached_data ) );
			}
		}
		
		$terms   = get_terms( WPVR_SFOLDER_TYPE, array( 'hide_empty' => false, ) );
		$folders = array();
		foreach ( (array) $terms as $term ) {
			$folders[ $term->term_id ] = $term->name . ' (' . $term->count . ') ';
		}
		wpvr_cache_set( $folders, $cache_hash );
		
		return $folders;
	}
	
	function wpvr_render_multiselect( $option, $value = null, $echo = true ) {
		if ( $echo === false ) {
			ob_start();
		}
		
		
		if ( is_string( $value ) ) {
			$option_value = stripslashes( $value );
		} else {
			$option_value = $value;
		}
		
		if ( isset( $option['tab_class'] ) ) {
			$tab_class = $option['tab_class'];
		} else {
			$tab_class = '';
		}
		
		$option_name = $option['id'];
		
		//new dBug( $option );
		
		if ( ! isset( $option['masterOf'] ) || ! is_array( $option['masterOf'] ) || count( $option['masterOf'] ) == 0 ) {
			$masterOf = '';
			$isMaster = '';
		} else {
			$masterOf = ' masterOf = "' . implode( ',', $option['masterOf'] ) . '" ';
			$isMaster = 'isMaster';
		}
		
		if ( ! isset( $option['masterValue'] ) ) {
			$masterValue = '';
		} else {
			$masterValue = ' masterValue = "' . $option['masterValue'] . '" ';
		}
		
		if ( ! isset( $option['hasMasterValue'] ) ) {
			$hasMasterValue = '';
		} else {
			$hasMasterValue = ' hasMasterValue = "' . $option['hasMasterValue'] . '" ';
		}
		
		if ( ! isset( $option['class'] ) ) {
			$option_class = '';
		} else {
			$option_class = $option['class'];
		}
		
		if ( ! isset( $option['values'] ) || ! is_array( $option['values'] ) ) {
			// echo "NO OPTION DEFINED FOR THIS SELECT";
		} else {
			
			if ( isset( $option['source'] ) && $option['source'] == 'categories' ) {
				
				// GET ALL CATEGORIES
				$cats = wpvr_get_categories_count();
				foreach ( (array) $cats as $cat ) {
					$option['values'][ $cat['value'] ] = $cat['label'] . ' (' . $cat['count'] . ')';
				}
				
			} elseif ( isset( $option['source'] ) && $option['source'] == 'all_categories' ) {
				
				// GET ALL CATEGORIES
				$cats = wpvr_get_categories_count( false, true );
				foreach ( (array) $cats as $cat ) {
					$option['values'][ $cat['value'] ] = $cat['label'] . ' (' . $cat['count'] . ')';
				}
				
			} elseif ( isset( $option['source'] ) && $option['source'] == 'post_types' ) {
				
				// GET ALL POST TYPES
				$post_types = get_post_types( array(
					'public' => true,
				) );
				foreach ( (array) $post_types as $cpt ) {
					$option['values'][ $cpt ] = $cpt;
				}
				
				
			} elseif ( isset( $option['source'] ) && $option['source'] == 'taxonomies' ) {
				
				// GET ALL TAXONOMIES
				$taxonomies = get_taxonomies( array(
					'_builtin' => false,
				), 'objects' );
				
				
				$private_taxonomies = apply_filters( 'wpvr_extend_private_taxonomies', array(
					WPVR_SFOLDER_TYPE,
					'wpvr_rule_folder',
				) );
				
				// d( $private_taxonomies );
				// d( $taxonomies );
				
				foreach ( (array) $taxonomies as $tax ) {
					if ( in_array( $tax->name, $private_taxonomies ) ) {
						continue;
					}
					$option['values'][ $tax->name ] = $tax->label;
				}
				
				
			} elseif ( isset( $option['source'] ) && $option['source'] == 'post_types_ext' ) {
				$internal_cpts = array(
					//'page' ,
					'post',
					//WPVR_VIDEO_TYPE,
					'attachment',
					'revision',
					WPVR_SOURCE_TYPE,
					'nav_menu_item',
				);
				// GET ALL POST TYPES
				$post_types = get_post_types( array(//'public' => true ,
				) );
				foreach ( (array) $post_types as $cpt ) {
					if ( ! in_array( $cpt, $internal_cpts ) ) {
						$option['values'][ $cpt ] = $cpt;
					}
				}
				
			} elseif ( isset( $option['source'] ) && $option['source'] == 'tags' ) {
				
				// GET ALL TAGS
				$tags = get_tags();
				foreach ( (array) $tags as $tag ) {
					$option['values'][ $tag->term_id ] = $tag->slug;
				}
				
			} elseif ( isset( $option['source'] ) && $option['source'] == 'authors' ) {
				
				// GET ALL AUTHORS
				$all_users = get_users( 'orderby=post_count&order=DESC' );
				foreach ( (array) $all_users as $user ) {
					if ( ! in_array( 'subscriber', $user->roles ) ) {
						$option['values'][ $user->data->ID ] = $user->data->user_nicename;
					}
				}
				
			} elseif ( isset( $option['source'] ) && $option['source'] == 'services' ) {
				
				// GET ALL AUTHORS
				global $wpvr_vs;
				foreach ( (array) $wpvr_vs as $vs ) {
					$option['values'][ $vs['id'] ] = $vs['label'];
				}
				
			}
		}
		
		if ( ! isset( $option['maxItems'] ) || $option['maxItems'] == 1 ) {
			$mv = "1";
		} elseif ( $option['maxItems'] === false ) {
			$mv = '255';
		} else {
			$mv = $option['maxItems'];
		}
		
		if ( ! isset( $option['placeholder'] ) || $option['placeholder'] == '' ) {
			$option['placeholder'] = 'Pick one or more values';
		}
		?>
        <div class="wpvr_select_wrap">
            <input type="hidden" value="0" name="<?php echo $option_name; ?>[]"/>
            <select
                    class="wpvr_field_selectize "
                    name="<?php echo $option_name; ?>[]"
                    id="<?php echo $option_name; ?>"
                    maxItems="<?php echo $mv; ?>"
                    placeholder="<?php echo $option['placeholder']; ?>"
            >
                <option value=""> <?php echo $option['placeholder']; ?> </option>
				<?php foreach ( (array) $option['values'] as $oValue => $oLabel ) { ?>
					<?php
					
					if ( is_array( $option_value ) && in_array( $oValue, $option_value ) ) {
						$checked  = ' selected="selected" ';
						$oChecked = ' c="1" ';
						
					} elseif ( ! is_array( $option_value ) && $oValue == $option_value ) {
						$checked  = ' selected="selected" ';
						$oChecked = ' c="1" ';
					} else {
						$checked  = '';
						$oChecked = ' c="0" ';
					}
					?>
                    <option value="<?php echo $oValue; ?>" <?php echo $checked; ?> <?php echo $oChecked; ?> >
						<?php echo $oLabel; ?>
                    </option>
				<?php } ?>
            </select>
        </div>
		<?php
		
		if ( $echo === false ) {
			$rendered_option = ob_get_contents();
			ob_get_clean();
			
			return $rendered_option;
		}
		
	}
	
	function wpvr_show_available_update_message() {
		global $wpvr_new_version_available, $wpvr_new_version_msg;
		?>
        <div class="updated">
            <p>
                <strong>WP Video Robot</strong><br/>
				<?php _e( 'There is a new update available !', WPVR_LANG ); ?> (<strong>
                    Version <?php echo $wpvr_new_version_available; ?></strong>)
				
				<?php if ( ! empty( $wpvr_new_version_msg ) ) { ?>
                    <br/><br/><?php echo $wpvr_new_version_msg; ?>
				<?php } ?>
				
				<?php
					$link = WPVR_SITE_URL . "/wp-admin/plugin-install.php?tab=plugin-information&plugin=" . WPVR_LANG . "&section=changelog&TB_iframe=true&width=640&height=662";
					echo '<br/><br/><a href="' . $link . '" > UPDATE NOW </a>';
				?>

            </p>
        </div>
		<?php
	}
	
	function wpvr_is_theme( $name ) {
		$theme = wp_get_theme();
		
		$possible_names = array(
			strtolower( $theme->stylesheet ),
			strtolower( $theme->template ),
			strtolower( $theme->parent ),
			strtolower( $theme->get( 'Name' ) ),
		);
		
		return in_array( strtolower( $name ), $possible_names );
	}
	
	function wpvr_generate_flat_colors( $count = 0, $shuffle = false, $good_colors_only = false ) {
		
		$returned_colors = array();
		$flat_colors     = explode( ",", "#AAB69B,#9E906E,#9684A3,#8870FF,#888888,#897FBA,#8870FF,#2C82C9,#2CC990,#EEE657,#FCB941,#FC6042,#3E4651,#F1654C,#00B5B5,#D4D4D4,#D98B3A,#D6523C,#BB3658,#7E3661,#43353D,#E3C39D,#E26E67,#E01931,#8A2D3C,#344146,#EFE0B1,#DBCB8E,#9E9D9B,#847858,#9E8E5A,#1D2247,#B0DACC,#D6CA8B,#E22211,#249991,#E76B6B,#FEFEFE,#42729B,#F6F7F2,#E0E4CC,#D6DAC2,#7BB0A6,#92F22A,#64DDBB,#7CEECE,#8F6F40,#6F532A,#523D1F,#A0B58D,#A19C69,#FD5B03,#63393E,#3C3741,#8C7E51,#54573A,#F04903,#FF7416,#F29B34,#D33257,#3D8EB9,#71BA51,#FEC606,#E75926,#EB6361,#EBBD63,#6C8784,#45362E,#87766C,#25373D,#CF000F,#E3000E,#E6DCDB,#D2D7D3,#E7E7E7,#282830,#BADA55,#1DABB8,#C82647,#FF6766,#60646D,#FFFFF7,#83D6DE,#97CE68,#EB9532,#EE543A,#D8335B,#953163,#422E39,#FACA9B,#FDD09F,#F3D89F,#E7DF86,#C0BA78,#AAB69B,#9E906E,#9684A3,#8870FF,#888888,#897FBA,#8870FF,#2C82C9,#2CC990,#EEE657,#FCB941,#FC6042,#3E4651,#F1654C,#00B5B5,#D4D4D4,#D98B3A,#D6523C,#BB3658,#7E3661,#43353D,#E3C39D,#E26E67,#E01931,#8A2D3C,#344146,#EFE0B1,#DBCB8E,#9E9D9B,#847858,#9E8E5A,#1D2247,#B0DACC,#D6CA8B,#E22211,#249991,#E76B6B,#FEFEFE,#42729B,#F6F7F2,#E0E4CC,#D6DAC2,#7BB0A6,#92F22A,#64DDBB,#7CEECE,#8F6F40,#6F532A,#523D1F,#A0B58D,#A19C69,#FD5B03,#63393E,#3C3741,#8C7E51,#54573A,#F04903,#FF7416,#F29B34,#D33257,#3D8EB9,#71BA51,#FEC606,#E75926,#EB6361,#EBBD63,#6C8784,#45362E,#87766C,#25373D,#CF000F,#E3000E,#E6DCDB,#D2D7D3,#E7E7E7,#282830,#BADA55,#1DABB8,#C82647,#FF6766,#60646D,#FFFFF7,#83D6DE,#97CE68,#EB9532,#EE543A,#D8335B,#953163,#422E39,#FACA9B,#FDD09F,#F3D89F,#E7DF86,#C0BA78,#59A9C2,#65878F,#6E5D4B,#6A5A15,#61381B,#4CD4B0,#FFFCE6,#EDD834,#F24D16,#7D1424,#E7E7DE,#CDCBA6,#008891,#00587A,#0F3057,#EFF4E4,#ACA46F,#7574A7,#5659C9,#D4DBC8,#DBD880,#F9AE74,#CD6B97,#557780,#444B54,#8199A3,#B5AFA2,#E1B493,#F7D6B5,#FF9F55,#FF8B55,#FF7E55,#FADAA3,#FF7055,#5C9F97,#DED7E6,#D4AF61,#5B2314,#97B088,#1F9EA3,#F8BD97,#3B0102,#9E5428,#BFB992,#F0F1F5,#112233,#66CC99,#44BBFF,#FC575E,#34495E,#2980B9,#27AE60,#E67E22,#ECF0F1,#E6567A,#BF4A67,#3B3C3D,#47C9AF,#44B39D,#462446,#B05F6D,#EB6B56,#FFC153,#47B39D,#F7E999,#D3EBB2,#5B4B27,#A42A15,#D3E9BA,#F2F8EA,#6797A1,#FABFA1,#E3E7B1,#ECEFA9,#D1CD8E,#BE8B5C,#B86A54,#BA5445,#9E3E25,#BADEB2,#87E8C6,#8BCBDE,#8FA8F6,#B0A4BE,#203040,#E7F76D,#D1D6A9,#EAF2BB,#F7BC05,#53DF83,#47D2E9,#EEEEEE,#3F3F3F,#D1D5D8,#3498DB,#F1C40F,#E74C3C,#1ABC9C,#6D4B11,#563D28,#3F303F,#282256,#11156D,#F4EDF6,#F8D9D5,#D8E2EC,#F2E4F9,#FDE1F7,#1BBC9B,#16A086,#1BA39C,#0B8389,#0F6177,#FCEBB6,#5E412F,#F07818,#F0A830,#78C0A8,#776F70,#E36937,#BBA900,#005057,#E91818,#B8B89F,#DC9855,#FF770B,#816432,#025159,#59AE7F,#64C4AF,#91CED7,#CCEBC0,#D9F5BE,#E3EEFF,#E8FFFF,#E1FAFC,#EDF9FF,#785EDD,#8657DB,#453E4A,#9E58DC,#AE44C8,#9DA5A6,#7FA66C,#48AD01,#C9C1FE,#82B9AD,#7A922D,#722809,#360528,#EE7469,#FFF0D6,#B8959B,#836D6F,#383732,#54ACD2,#5991B1,#5F7187,#48569E,#8B4D93,#4A4E4D,#0E9AA7,#3DA4AB,#F6CD61,#FE8A71,#6BB18C,#ECDAAF,#EBCB94,#EF9688,#DC626F,#FE6860,#FE8A71,#F3C9BF,#D9BBAE,#0C545C,#88F159,#B7EF9C,#F4FFE0,#C9C7AF,#4387B5,#7D7870,#6157D4,#A14C10,#10D2E5,#81E2E6,#93BFB6,#977BAB,#6F2480,#42787A,#409C97,#F8E8B5,#F0340F,#331B17,#34495E,#4F8677,#6B9B61,#8F934D,#B17E22,#413333,#48393C,#744C40,#98583F,#FF7B2C,#4D545E,#586474,#72CCCA,#E2D6BE,#BD3C4E,#CA6769,#F4998A,#F0B799,#F4D6A0,#CDC99F,#528CCB,#F31D2F,#FF8600,#00D717,#BF4ACC,#B3005A,#710301,#8F6910,#F1C40F,#E67E22,#E74C3C,#ECF0F1,#95A5A6,#043D5D,#032E46,#0F595E,#23B684,#FFFFF7,#73B1D6,#4589B0,#1D628B,#444444,#5A5A5A,#F8F8F8,#D6D6D6,#72BAAC,#EE7546,#EE5F5B,#F89406,#FFF457,#62C462,#5BC0DE,#ECF0F1,#1ABC9C,#16A085,#2C3E50,#E74C3C,#7CA39C,#7F8E8B,#4D4D4D,#B27257,#FF5D19,#455869,#3B7E87,#9EA97F,#D1AA7F,#F8BC86,#11132F,#263D4E,#4A6B4E,#918E45,#D9983E,#726680,#FF520F,#0FBAB7,#B8B6A6,#75536C,#181303,#158B93,#031316,#534830,#FD8F04,#BBB7A4,#FFDE49,#FF8F17,#FFFCF5,#FF3209,#1C2236,#08AAC7,#85E2FF,#EEFF6B,#B30802,#02135C,#B7B4B6,#0C1024,#FEDB1D,#E66A39,#D04E33,#353C3E,#1C2021,#EEEEEE,#2C3E50,#34495E,#16A085,#1ABC9C,#BFE6EC,#55C34D,#074354,#053542,#02222B,#22202B,#383745,#7D6962,#CA8D6E,#F9AE74,#1ABC9C,#16A085,#ECF0F1,#E74C3C,#C0392B,#1D1D29,#6C1827,#9E373B,#EF5C54,#FFE3D0,#199EC7,#40BC86,#EC555C,#FCB410,#28A9BC,#36C4D0,#92DBC7,#C6F0DA,#FFE7C1,#292E40,#F7A3A2,#F8CAC1,#BED9DE,#82BBC2,#706F77,#AA8C91,#F1A49F,#E2999F,#E69896,#BFB0A3,#A86E3A,#C4A956,#02000D,#635D4D,#F4F5D6,#E0D5B2,#A38F84,#A38F84,#75706B,#C4C4C4,#706051,#FF7300,#A69688,#84CCD1,#95E7ED,#CC4949,#E35252,#F75959,#9DABA2,#79857E,#27332C,#294543,#2C5957,#131A1E,#1136C7,#1C57E1,#597DF7,#779BF0,#D4C6C6,#9E1616,#37767A,#254F51,#091414,#1E272B,#523838,#D14841,#DA8254,#F2BE7B,#216379,#9FAB5F,#F9F8E4,#B58D2B,#0F090A,#799412,#432522,#396A90,#39B4FF,#6D0005,#EC3013,#200D07,#467E8F,#B0A297,#FFE1AE,#F9B32A,#FD7150,#FA4228,#336E7B,#E6C3AF,#E9BDA4,#AE9181,#603838,#82595D,#223549,#B52300,#575C56,#C97131,#CD9C64,#85763F,#D28E81,#E3D2B8,#806C53,#3A2C21,#702A87,#AEDD46,#D71A75,#FFDA0C,#2FE2D9,#0EBB9F,#F5C700,#F69C00,#EF4836,#C43829,#004C79,#005F97,#3C8AB8,#E8F4FA,#849FBB,#323A45,#00AFD1,#1FBBA6,#F27935,#D64541,#A0F601,#ECF0F1,#768A92,#687E87,#5E7078,#D3CED8,#C2B6D6,#AA99BA,#867198,#67537A,#557780,#D95058,#ED939D,#F0C2C2,#EBE1E2,#37465D,#6AB0AA,#EBF680,#FCA65F,#DD6F47,#FE5A05,#D55B06,#985004,#54483A,#464A53,#6B2623,#E60501,#F84902,#FDA006,#F7D00D,#C0B38D,#F3D06A,#8D8276,#5A999A,#8DC0B2,#178CA6,#D9D7CC,#F2BB13,#D99F7E,#F24130,#EFBDA0,#FCAB7B,#DB9971,#383942,#232C3D,#CC9194,#F7A5A7,#F8C0C0,#89B2BB,#6C9299,#FFAB78,#FFD380,#B6FF75,#72F274,#2C544D,#D3E6BE,#CBE092,#E7F1CF,#EFF7E0,#DDE6D6,#B4C248,#6B5636,#DB8D17,#F0A703,#F3D646,#F6FAE8,#C71313,#F2F3ED,#EAEBD9,#CACEAD,#AC6A5A,#23221E,#2E8A9C,#E2AE80,#688D9B,#804829,#8B8B8B,#BFCC5A,#9DC24E,#7B806B,#DEB48A,#FFC8A6,#FEFCFF,#B5B09C,#CF352B,#0A2037,#072527,#3F3067,#BB1F5C,#E2A743,#B43024,#A72154,#3BA8A5,#E27E1C,#A2C648,#853870,#F0F0F0,#C8CDD2,#B4B9C3,#647387,#AF7F4B,#40A7A0,#4ECDC4,#C7F464,#FF6B6E,#9C410A,#CE8948,#735E67,#90A5BA,#4B5942,#0A0A0A,#0F0F0F,#1A1A1A,#A0A0A0,#F0F0F0,#A15E5E,#F85066,#FFCA0C,#C61357,#E0C3A5,#010035,#47263B,#B66E1E,#F58F4B,#B79471,#D6BFA5,#09557A,#592339,#981066,#C25396,#B1DCC8,#B73B7A,#EED0B8,#DDB68B,#CF6991,#2DCC70,#27AE61,#33A828,#349935,#41A35B,#3897D9,#59BCFB,#F2F1EF,#64D98A,#5ECA7F,#BE90D4,#F0856F,#F9BF3B,#F7D93B,#5AD4BC,#3F3F3F,#F2F2F2,#FFD91E,#AA61CE,#ED5784,#EBECE7,#52645E,#639C89,#96D4BF,#F57979,#0C555C,#2E928A,#CCDFCC,#FF6861,#EB524A,#27D0B9,#F5F5F5,#CCCCCC,#432E41,#3BC391,#2F79C3,#374047,#EB4549,#F8F2E2,#FF7F5F,#FFA75E,#B7FF5E,#92D690,#708C7F,#2C214D,#DAE9BD,#E32F6C,#B63165,#9C215F,#4193A6,#84B4BF,#F2EBC9,#D9CB84,#8C7F3F,#FA7535,#494D4B,#45B739,#04DDAC,#D4CD9D,#153E63,#A9D3AA,#D1E0A6,#CEEB43,#D4BF21,#10806E,#F1ECC8,#F6A011,#E76037,#AB3F3F,#F59500,#FFB836,#F4D35D,#6090A8,#424D53,#1C252E,#3D2A2A,#302823,#332A17,#273325,#3A6E7A,#C7C398,#CE7D16,#573A4C,#393B4E,#0F0012,#21040F,#2B0B0B,#331D12,#382E1B,#A38149,#D9BE93,#7E9E92,#1C2924,#291D1C,#8EB89F,#7A7A16,#6CC0BF,#B3BB19,#D8B133,#CA5F71,#786048,#C0A878,#F0D8A8,#909060,#484830,#F10E29,#0A710A,#E51A31,#E8253D,#097109,#FF5A1E,#401457,#3F4259,#166670,#7A9FBF,#4F4F4F,#0A7379,#5BA38B,#DDF075,#F8D474,#DFB7AD,#8A97C4,#C878AB,#EEC3D6,#D6C0CE,#919188,#919140,#9E6C36,#AB6147,#65888C,#FBCF76,#BC8657,#615A4A,#29251C,#3D3020,#F5CD3C,#DACDB6,#BFB095,#E8BF79,#F3A929,#D2BAA2,#AEA294,#98A2A4,#E6C3C1,#988C8E,#00A49A,#9F0088,#BEAE00,#E6EBB8,#00101C,#A29679,#D5C190,#E3B445,#CE9D27,#BA870E,#48493B,#646152,#CEBCA8,#CEABA5,#92787B,#74A6CC,#A5CAE6,#E3D081,#8BB7D9,#5692BF,#112885,#3A5194,#8194BF,#F7E5BD,#FBFDF2,#FFC175,#DB8114,#9E2F72,#542485,#593106,#501C07,#703F17,#C46E55,#9B5148,#FDCAC7,#444444,#5C584B,#968D6C,#FCF7D1,#FFFEF5,#7D370B,#7D6707,#C1D459,#F7F7E9,#4A8784,#F6EFDF,#F2D1BE,#F0C0AC,#E38B73,#C6826B,#492363,#FF8286,#FF9696,#FFADAD,#DE633A,#E0C3B5,#DEBAAC,#DCB4A8,#D8A9A1,#D1A79B,#D7C6AB,#C4A16B,#8D744D,#27331A,#E4C831,#581620,#FFD6D0,#CD3E52,#421E20,#684644,#F6E0D3,#FFE4D5,#EBCEBE,#CEBCB2,#B29B8E,#332F29,#AEDDE5,#9FFF97,#F9FADD,#F2BDB8,#EF5252,#090908,#323232,#292929,#353535,#302F2F,#BB4D3E,#414040,#449BB5,#EB5055,#25A278,#2C2C2C,#FFFCF5,#F1C40F,#E67E22,#E74C3C,#ECF0F1,#95A5A6,#6A888C,#5F7174,#A5E65A,#00A6C0,#32D9CB,#FA6367,#78C9EC,#FEEAA8,#17B090,#F89538,#F4EBC1,#EF9F38,#A0A08B,#777673,#2D3E50,#01C26E,#F3C40F,#E24C3F,#8F44AB,#050F15,#1A4C6D,#3498DB,#85C1E9,#C2E0F4,#FFA549,#587DA7,#A3B3C0,#D8E1E8,#ABABAB,#73A8AF,#A0CAB5,#CCDFCC,#ECEEF1,#F38A8A,#FFF3D4,#FCBDB4,#E26688,#805562,#904A3B,#E26868,#E9CEAC,#AAB0B2,#7FC7E6,#404A60,#C0392B,#E74C3C,#ECF0F1,#1ABC9C,#16A085,#3B3F4C,#414755,#5E626C,#D8D9DE,#FFD074,#C9CCA9,#FEFFD1,#FFEFD8,#FFD4BE,#C7F2FF,#929292,#F5F5F5,#DF554F,#53D769,#167EFB,#BBA900,#005057,#E91818,#E36937,#776F70,#FCECC9,#7CBCB5,#F79885,#D6E2CE,#825D27,#297C74,#30D7BB,#27BCA0,#23B1AD,#6E9996,#11303F,#D9DD5F,#FD1254,#88ABB2,#FBD6CC,#1F253D,#394264,#11A8AB,#E64C65,#E95933,#B6C8D1,#DCE3C9,#F3EECC,#3F4C46,#FF5D19,#FFAE8C,#F0F3F3,#7AC974,#174C4F,#696770,#C7C2B5,#DBDBE8,#004774,#002E5A,#F7BA92,#F6EDA2,#C2ED6C,#31D6CE,#343557,#CC9766,#D6976B,#BF8069,#D6786B,#CC666E,#E5FFF2,#D0E5D5,#F5FEF4,#DAE7D0,#F9FFE5,#C3C2A5,#F6F186,#908E88,#6D829D,#A5BAC3,#8E95B1,#6A5250,#708580,#AB9752,#EBC313,#F73E2D,#BA4E34,#632D48,#560F47,#3E033F,#1B242B,#009085,#4EBE9F,#EAFF99,#8D8F6F,#3F4D58,#CAD26D,#FEF0D6,#3D414D,#3EB097,#425C57,#506468,#616E7D,#717790,#8482A7,#F0EDD5,#584932,#E2BCCF,#B1CFD6,#523D1E,#CCBFBE,#D4BEBC,#DEBBB8,#E8BBB7,#EDBAB7,#D6FFE8,#ABE0CD,#86D9CB,#4B6946,#5E593F,#FF4545,#C96614,#D96200,#61475E,#913D88,#401F0E,#061B1C,#785436,#D15406,#671A2E,#B7767A,#E3B9B6,#D9C46A,#354B48,#FFEE29,#2B1E18,#C52606,#974B17,#DBAA16,#A0AB5C,#687036,#41452B,#313324,#2A2B1F,#FE3F2D,#40034D,#8A9E70,#FFFCD6,#9DC400,#CACCA9,#CCBB87,#D19254,#C26451,#9E3A52,#0A0A0A,#243038,#505D66,#5A778C,#638EAD,#FAA5AD,#52070C,#F2B20F,#68A9B3,#63234F,#0918EC,#EDE0FB,#0615F2,#3E49F2,#070D15,#181D21,#E63054,#181D21,#E63054,#181D21,#5C4B38,#EBDAB2,#65AD9E,#298773,#C2004E,#FC6A1F,#3C68B1,#16171B,#C79C7A,#A08675,#CDAE80,#766A6A,#B29671,#A29D39,#5E6C31,#8F9742,#475138,#6E6915,#40032C,#E0378A,#EAC4BB,#B1AF58,#2F2331,#1F2B37,#F0D1B4,#2F343A,#7C3C23,#492E25,#2D221C,#7B513B,#FCD8C2,#BAD5F0,#6DA0CD,#FFAF5A,#CD1A38,#5F0F12,#98091B,#F32C33,#A6B87A,#7C7654,#7A8879,#A1EA99,#65C6BB,#9258CB,#3DB0BF,#FE0089,#280B52,#857441,#E6DC29,#FF9E17,#E66229,#E0B05D,#F9EDD7,#E2DBBC,#F4F1E1,#CBC9BB,#973939,#7D9FA0,#62524C,#EAE3C5,#C9C4AF,#332522,#D9C6B5,#A8BED3,#424E5A,#313840,#E63E6D,#E65C9E,#FF789E,#F7E3BA,#FFCEB5,#5696D4,#FCCF26,#7BCAA5,#EB7565,#A260AA,#6A6A6A,#1BA1E6,#EBC7CA,#5CCCC8,#CCCCCC,#16A085,#1ABC9C,#BDC3C7,#2ECC71,#27AE60,#FC6264,#FCAB54,#B9B753,#609EC1,#6C8FB6,#306097,#BCD4AC,#F3F4EA,#D06619,#BE7764,#EDE8D4,#70A8AF,#AEB176,#658999,#AF7AC4,#8E44AD,#3B3C3D,#47C9AF,#44B39D,#FF0D90,#C9FFA9,#0047FD,#CEBEFF,#F2F9FF,#FAB335,#5C5C5C,#F5F5F5,#EDEDED,#31D0D6,#FEBEA8,#C34B4B,#2ECD71,#313B4B,#969DA7,#1ABC9C,#17A98C,#14967C,#12836D,#0F705D,#EC5B5B,#F4E4D1,#2C2C2C,#5DD973,#27AE60,#34495E,#3E4651,#ECF0F1,#2E2E2E,#628E93,#AC544E,#EBE7E4,#2F2F2F,#3498DB,#ECF0F1,#E67E22,#7F8C8D,#40486D,#7585B6,#D5D1D2,#C2C0CD,#B7B4C5,#FFF899,#475152,#697E80,#46ADB3,#9BDBDE,#F9F9F9,#E4E4E4,#2F2F2F,#292929,#E74C3C,#F1654C,#00B5B5,#F0F0F0,#3E4651,#5C6D7E,#FFBFBF,#B1A08E,#B7A460,#FFFFD6,#F8CCA7,#4EDEC2,#EFECE7,#FF7878,#334657,#F1C40F,#E98B39,#E74C3C,#ECF0F1,#95A5A6,#290B03,#682E2D,#9A514A,#B68B84,#DED1FC,#2A2C45,#5F4B92,#8598A7,#A5ABCB,#FFB5A6,#363B4E,#4F3B78,#7566A9,#927FBF,#C4BBF0,#84E1B1,#61A582,#EDF2F3,#324245,#B76358,#432E41,#2EDFC7,#FF4C43,#FFC23C,#CCCCCC,#009999,#006666,#004D4D,#F2BE55,#F9E5C2,#721544,#962543,#B43C45,#CE4847,#F67A47,#6DB18D,#F76863,#DED8D3,#2F2D2C,#466A80,#FF6B7E,#343738,#5BBAE3,#183153,#A1ACA0,#C3C3B7,#EDB70D,#A6A501,#1DAE8B,#FDD000,#EC6625,#E83D38,#A0C2C1,#DBCCAD,#FD9643,#B5DD6F,#FCEB53,#B73672,#3068B6,#43B73F,#A0DA42,#DD9949,#0099FF,#002952,#297AA3,#333333,#567E22,#B0D31F,#0694EA,#333333,#FD8943,#FFD73C,#4C86CC,#F0EEE7,#556270,#88B2B4,#DBD880,#F18260,#C1654D,#838EA2,#9BACBC,#B2C8D6,#DBC2A4,#F59B69,#252928,#B72E09,#E5E0B7,#656850,#B5B192,#A59897,#FAF6E3,#F6A186,#85D8C8,#FB9399,#DE8D3C,#ED9E4E,#FFB366,#FFCC99,#FFE6CC,#3C99EA,#FF6565,#AAEC53,#ECE653,#ECB053,#FFD08D,#0B0C07,#001630,#2481B2,#FF6249,#97C573,#EA5B4D,#6E9BD5,#9A7BC2,#C087C5,#61433B,#8A6B4C,#CB8B33,#D79535,#6D918A,#484F59,#FFEED2,#4DC9A5,#F5AE22,#A3310F,#17696D,#097B73,#2E8C80,#619A82,#B0BC96,#2C3E50,#18BC9C,#3498DB,#F39C12,#E74C3C,#DC6B7C,#F8B7B1,#6AB1BB,#292E40,#F67E7D,#F0F871,#52907B,#478079,#424242,#DD5317,#FA4F1D,#F7A327,#E6F644,#AAD8A3,#212B40,#116C53,#00AC65,#DCDCD4,#F38360,#635A51,#2A2927,#017163,#A99A01,#FFAD00,#1ABC9C,#34495E,#D6DBDF,#392541,#F66256,#B491E3,#E6F0ED,#1B052C,#B1215E,#D95062,#468081,#AEAFA1,#375B54,#C4F4EB,#76A79F,#FF8758,#A78476,#218A9E,#23A899,#259166,#23A84D,#219E25,#373746,#8E44AD,#3498DB,#2ECC71,#1ABC9C,#2980B9,#27AE60,#E74C3C,#E67E22,#16A085,#1D2A34,#3F4F59,#6D808C,#CCBF35,#C61C15,#499642,#AFA32D,#CD844D,#C74E3E,#922F4C,#AB2A2F,#E9E9E9,#C8D8D8,#B8CCCA,#819DA1,#F5F5F5,#D0CFCF,#CCCCCC,#AAAAAA,#0A3542,#E84B3C,#F39C15,#34B297,#2980BA,#34495D,#8C4248,#7790A6,#BFBC8F,#A68933,#A55B4A,#FFE09C,#DEE1BD,#BDE3DE,#61707D,#9CE4FF,#5D574D,#4F7076,#6C918E,#FFE9DC,#FDC26E,#BDE6F8,#76D1EC,#F67B7E,#4F576C,#292F4F,#0E212C,#8FB1B4,#F0EFE8,#E13B39,#435869,#729176,#A4CF57,#D3CA52,#FEC34E,#262606,#42420A,#B8BD20,#DBD820,#FFFC52,#5E5B19,#F8F483,#EEF9FF,#5CD5E6,#E6ECEC,#C6AED8,#CEC6CF,#DB78AC,#80573C,#E9DBC2,#464030,#B7E20C,#B7C09B,#635F45,#E2F224,#FCFCFF,#F8EEEE,#600000,#C07800,#E8DB52,#F7EE84,#F3F2F0,#ABE41B,#959CA0,#677D8A,#3F5A69,#0C1216,#181818,#303030,#301818,#304860,#F0F0C0,#2398C2,#23B1C2,#23BBB2,#239FC2,#2393C2,#00F000,#0000F0,#F03000,#F0F0F0,#603018,#7A7C46,#1CA1AD,#F2B6BF,#1A1238,#BBFFC6,#FAF7E9,#F8F1CF,#DAF9FF,#03A2FD,#ADE1FF,#F3707B,#D10B0B,#FA9749,#ABDD55,#867DA5,#FD2323,#FD5823,#FD7223,#B995E9,#AC6DFF,#AAA1EB,#1B001E,#F04830,#D81830,#73BA57,#5787BA,#DED410,#B32D2E,#E8383B,#F76539,#4D4933,#FFC629,#FCE49B,#DE9331,#8F4E11,#CC5094,#DCC5E8,#EFDB0D,#C9ECF8,#ABEE4D,#74B5AA,#1BB568,#5CB4F7,#DEA32C,#C5DBCA,#D9CACF,#CECCDE,#71B1BB,#4D740D,#F72040,#8CF2FF,#FFE4D9,#ECF2C7,#D67424,#19262C,#4C515C,#E87D4F,#95C4E8,#E6F4FA,#203A4F,#969C6B,#D1CE97,#9E8E6A,#4F2020,#FF6A00,#FFC800,#FFD591,#FFF1DB,#48B500,#453632,#D1894D,#E0AF87,#FFD073,#A88E54,#636E06,#DAA1AD,#B583D8,#1912FE,#9C7A83,#331517,#5B1A14,#C15A2D,#FFF172,#C18B4D,#CF6548,#779A92,#20B08C,#A64CCE,#084886,#1F0303,#7A0000,#D9940B,#BFC429,#AFFCA2,#59D490,#ABD158,#B5AA4A,#967648,#969356,#F5EDED,#BBBBBD,#D9CEC7,#E6E8E1,#DCDDE0,#6C4689,#592D80,#532A79,#4E2772,#49246B,#050002,#BA9200,#718500,#C200BB,#8D00D4,#925F2F,#373F16,#6D9329,#A5AF4E,#D3D1AD,#413C5E,#342F52,#292447,#CCCCCC,#A2A2A2,#800149,#1693A5,#E8E8E8,#5C5C5C,#111111,#DEC89E,#336B5A,#BA9C61,#8C3B3B,#94773D,#CC9A70,#BF8658,#916540,#F5F1ED,#9E9A96,#6CC0BF,#B3BB19,#D8B133,#CA5F71,#A3685F,#B8B82A,#F7B881,#416294,#EF632C,#82886E,#747468,#6D6966,#685D61,#62525C,#AEE588,#9CCA82,#8DA778,#859372,#80866C,#0A5008,#FFB300,#001700,#4BAD08,#2F3491,#23FADC,#2A6E9E,#C3CFA6,#11C7A8,#65F511,#16C42D,#188F67,#1F4D5E,#2A2B42,#297372,#24422E,#13AB45,#2D7344,#146967,#D69942,#FFB64F,#A1A09F,#C7C6C5,#C7852A,#136151,#4633FE,#654323,#320644,#F1C210,#0C3A3B,#F0638B,#FF5900,#25042A,#3C2130,#4B3743,#A0939A,#F7F5F6,#664816,#234291,#811DBF,#D41568,#CFA561,#E72C28,#FE8C19,#040200,#EDAD20,#DF4E0F,#A9A5B6,#0295E2,#7ED2F7,#FFEDDF,#436266,#293240,#1D1E1F,#5C4A36,#6B230B,#161D29,#414A52,#4C5D6C,#595E66,#07090E,#462A43,#F1D611,#D9CF7E,#D9B17E,#6B5336,#F7E8D3,#A4492E,#261B23,#8B726B,#A18989,#131011,#198F31,#E4B6A6,#93734C,#8D6B45,#64413F,#291709,#3B592A,#89D55F,#3F2110,#E5100B,#502A29,#FFF5D5,#AE9E8F,#A39951,#73A5BE,#E0E7A4,#131F49,#9E8C02,#FEFFFF,#1E160B,#631515,#F896A6,#F8A8B5,#FDC5CE,#FFE0E5,#FFF0F2,#B9D907,#DB15BA,#C90053,#E5FE03,#777F34,#EBDBD0,#B3C5C5,#A2B2B1,#ACABA0,#5D5D3E,#383D2C,#3B482E,#6F7F54,#313632,#49969B,#AA1F03,#FFD699,#90828F,#7F7083,#315C6D,#A26D67,#867182,#EE163B,#D01132,#C12A1D,#B51921,#F4E6E8,#C69F90,#9AB1BF,#5A6E91,#F1AA74,#E6DDB4,#CFF1D1,#D4908F,#A9C5FF,#BAAD7B,#91DFF4,#9EA36B,#E2EEA4,#F0FFD6,#A6CD8E,#96BD86,#C2C671,#A8B273,#D1E7B9,#D6B387,#AFD896,#9A30DD,#F4BB10,#8D8B0C,#4AB7BF,#DD5F91,#A0DB9B,#61C181,#3E9471,#D44A59,#C4304A,#0C486C,#EB9605,#FE4E50,#3C81B5,#24273A,#A0DB9B,#61C181,#3D9472,#D44658,#C4304A,#FA9090,#E63E6D,#E65C9E,#FF80BD,#F7E3BA,#FFC642,#1B6574,#E84E11,#ABB2B5,#F7FF0C,#54BAA9,#0FA7D2,#EE3A43,#FFCF00,#FF6B66,#FFB866,#16204D,#E3E8FA,#80C4B7,#93EBDD,#EAEAEA,#AEB0B0,#636464,#202020,#E8CF57,#7D4A81,#D76E93,#41BDBD,#E47361,#F8F9FB,#E1F2F9,#C3EAF1,#A4D4E8,#7BBBD6,#DECEA3,#EAE7D7,#92899F,#60B0B7,#AFC87D,#DAC897,#E15951,#7DB06D,#A4C16C,#788188,#150605,#C0392B,#D96659,#F6D9D5,#2BB0BF,#DEF4E4,#E4F4BD,#F4D4BD,#B48B8B,#3E6787,#3498DB,#9B59B6,#2ECC71,#F1C40F,#E74C3C,#35474E,#60D2FF,#E5E5E5,#53DF83,#D0402F,#4387F5,#12A563,#F8C63C,#67686B,#333333,#705A54,#546A70,#FFF899,#99A0FF,#3498DB,#F1C40F,#E74C3C,#2ECC71,#ECF0F1,#5BC6BC,#83D8B6,#7AB2B9,#2B838E,#98AD79,#F1F0B3,#CBE32D,#A8CD1B,#84A113,#326876,#FB6868,#2A2A2A,#080808,#ECECEC,#F5F5F5,#00AA85,#44CD94,#F1EDEE,#F9FDFF,#595959,#2D2D2D,#F4A236,#E2E2E2,#FF592F,#222222,#393939,#4D4D4D,#BDBFAC,#20A286,#83AF9B,#C8C8A9,#FC9D9A,#FE4365,#52883D,#D2580F,#8D5E66,#642C1D,#300600,#52883D,#D2580F,#B2AC94,#DE2E38,#767D30,#52883D,#D2580F,#B2AC94,#8D5E66,#8D8676,#FFBFBF,#B1A08E,#FFFFD6,#B7A460,#B9A175,#C0925E,#B1A08E,#B7A460,#FFFFD6,#B9A175,#C0925E,#B1A08E,#B7A460,#FFFFD6,#876235,#F8F3EB,#F5C16D,#DB9C38,#9A835A,#D9D4CB,#DB0304,#080808,#909090,#7C7C7C,#EE1C25,#6DCFF6,#591516,#E1BDBD,#FDFDFD,#E4DFDF,#C0BB89,#CCA486,#E6868E,#E56996,#F6FFDE,#E1FFB0,#FFF9A3,#FFCE8F,#A9B38F,#422E39,#61475E,#D96200,#F87A00,#16A085,#1ABC9C,#BDC3C7,#E74C3C,#C0392B,#77ABD6,#4FC671,#588189,#6AD898,#004F78,#6687AA,#E08267,#E2E770,#90D2AD,#2A3542,#6CCAC9,#57C8F2,#F8D347,#FF6C60,#ECF0F1,#F39C12,#E67E22,#C0392B,#2ECC71,#E74C3C,#C0392B,#ECF0F1,#2C3E50,#34495E,#ECECEC,#BCBCBC,#62C4FF,#FF6E6E,#CF6FD0,#72FC82,#DFE4E8,#353E43,#34CBFD,#00C7AB,#F06050,#EF9033,#F7CD1F,#415C71,#4E4660,#3F3B47,#2F2C35,#D0D0D0,#ECECEC,#D6F7FC,#DBFCD6,#FCF9D6,#FCD7D6,#FCD6F7,#9374F5,#84CCEF,#7FA453,#FFD893,#F08D9A,#FA6767,#F9FA67,#79FA67,#678EFA,#FA67F1,#1ABC9C,#9B59B6,#34495E,#E67E22,#95A5A6,#0694EA,#B0D31F,#333333,#E67E22,#0099FF,#5CFF00,#FFDD00,#FF0024,#444444,#8F3FB0,#217FBC,#5BABE6,#1FCF6D,#E87E04,#B6E78B,#42AFFF,#EE6B48,#FFFBCC,#DF82AC,#ECD2E1,#ECE1D2,#DDECD2,#D2E8EC,#D9D2EC,#7A858B,#1E2938,#1F2E3F,#223242,#C93746,#E36363,#E3B863,#6ED4D8,#4DBDC2,#DBE5E6,#DE3C3C,#ED4E4E,#FF6666,#FF9999,#FFCCCC,#FF574F,#34495E,#00B1BE,#FFB133,#C1C1C1,#1C9987,#21BAA6,#F8A52F,#3498DB,#2980B9,#E67E22,#78D7E8,#C9D1B1,#FFB4A5,#85838A,#5B5B4D,#637B82,#748384,#848B85,#949286,#A49A87,#ECF0F1,#26C281,#37575C,#17D6F5,#E87E04,#161616,#F54F37,#4DAC94,#E0CE64,#666666,#757A94,#8CC7C2,#D0D168,#DFDFD0,#E9624F,#E4DFDC,#009B83,#E7CB50,#4D5596,#D46B5B,#DCCE5F,#E7E7E7,#81D1C4,#3BAFBE,#2C3E50,#34495E,#7F8C8D,#FFCC00,#ECF0F1,#6DDF79,#BCFF7C,#D8FFC2,#FAFFE6,#B9FFA1,#363636,#44B9FF,#FF4444,#FFEECA,#363636,#313A42,#96281B,#D35400,#FDE3A7,#D2D7D3,#F05430,#FAD203,#35C187,#40ABD9,#2C4055,#F8FCFF,#53BAF9,#FFFAA6,#FF7676,#CECECE,#E3E3E3,#F9F9F9,#DADADA,#EBEBEB,#7A9A75,#535D52,#30474D,#B05155,#F54F53,#7186A3,#B3D5DE,#E1E0B2,#C9CF31,#F89A29,#8502D1,#00DC8F,#CC0099,#00CCC7,#F9D71D,#2C3E50,#1F3A93,#9A12B3,#F62459,#F7CA18,#557D97,#C452A0,#721128,#A26829,#D49B74,#665555,#777788,#778888,#AAAAAA,#887777,#F5C0B5,#F3E6E6,#F0F5F0,#B30700,#FCCEC9,#B49B05,#501239,#99005C,#C34978,#EA4581,#B9B9B9,#82D4FA,#C3E7F8,#303030,#181830,#604830,#484830,#786060,#4890C0,#2A95DB,#3CA2E6,#FAAE2B,#F1943D,#770002,#E29521,#517209,#004185,#EBE6E0,#EE671B,#CCEE1B,#1B56EE,#1B1BEE,#561BEE,#4E0F0F,#FF0000,#FF0070,#034D50,#3C9194,#B3898B,#BD7E7F,#BF9798,#D4C1C2,#D0C9D1,#5C0500,#360300,#1F0000,#6F7880,#97A3AD,#962929,#BEFF10,#FF1158,#FFABC6,#343832,#EBBDA9,#CC967E,#BF3F08,#94350C,#361304,#383232,#FF7373,#67C774,#E957FF,#294866,#F707AB,#2707F7,#F7DF07,#00CF45,#C09048,#C07818,#A86018,#606030,#181818,#172145,#C9830A,#445200,#7A8739,#324532,#783131,#6D7831,#317871,#421C3E,#332531,#4A3400,#909078,#606048,#0060A8,#60A8D8,#A82A2A,#DE2F2F,#224A10,#418C1D,#52B325,#FFFD4D,#60EB9E,#8BC418,#AFFF0F,#FDFF0E,#2C627D,#324C66,#2E4D4D,#326B6B,#A7C4C4,#FFADAD,#97B379,#92A7B3,#124966,#D92792,#40293C,#534F54,#F7F294,#D6D16F,#4D4841,#FF6A00,#FFB44A,#0B427A,#288521,#FF6A00,#1A1824,#1A1A1A,#292929,#261616,#FFCC54,#F0D390,#CC7956,#6A6D99,#CBCBD1,#A89090,#D8D8F0,#D8C078,#A8A8A8,#909078,#F56464,#F59564,#E1EB06,#C2F564,#75F564,#ABE3FF,#ABCEFF,#ABB9FF,#B1ABFF,#C6ABFF,#211200,#001A10,#002829,#898F3D,#00151C,#FC6203,#F21818,#0384FC,#EBC626,#6FFC03,#608F8E,#4C8584,#387877,#1C5C5B,#094746,#0091FF,#E3F3FF,#A81414,#A0B9BD,#253328,#B26D62,#B55C3F,#D7424E,#D54859,#A37E72,#083545,#C9C4FF,#AFE9ED,#B1EDAF,#C0EDAF,#DD5A00,#FBEE8B,#D6AE3E,#A6C944,#B37439,#2B0A0A,#664141,#A89D56,#C7CC35,#E1E817,#0B1414,#FAEA5C,#2B0802,#240109,#2955E6,#D2F716,#182829,#1890A8,#A8D8D8,#C7201A,#ECEDCE,#6E826D,#2E4745,#0B1A59,#F59802,#C002F5,#F50202,#020BF5,#188011,#333333,#63634B,#5C2828,#A6A4A4,#DEDEDE,#1DCC94,#BCC02D,#E8A44A,#B88D56,#A344CF,#F8B8AF,#F79B9E,#F98999,#52A3B6,#1C84A7,#EBEBF7,#D3D3DE,#BEBEEB,#A0A0E8,#8789C9,#C29657,#232D24,#5C1900,#2B4C5D,#FFE8C1,#96D964,#BAD964,#D5D964,#D9CD64,#D9B664,#121700,#9EA5BA,#949466,#9EBAB3,#947266,#C76810,#3D3D70,#B05805,#1E2252,#807A09,#A8B78E,#251F61,#5E271C,#A8B78E,#CF1515,#FA9405,#FABD05,#0F6B17,#479E4E,#748783,#C40316,#E97588,#F0EBCD,#4D4D65,#490278,#60018F,#780278,#610261,#470247,#B59C8D,#857C77,#6E5B50,#A72154,#3BA8A5,#E27E1C,#A2C648,#853870,#F57D45,#CBC5BF,#E7E7E7,#8DB392,#B9D181,#5E91F6,#D48806,#B143C4,#43C4B5,#EEF26B,#0C0B35,#0D0D3F,#0F0E4A,#4CD9A5,#0C0C28,#895063,#326848,#EAC96A,#0AB3AE,#0E1B50,#1FAA2E,#230EEC,#B51311,#F6ED0E,#6B7377,#222127,#534D5A,#F4E4C1,#E46550,#A0B220,#BC8D61,#FCF396,#FCF429,#D94100,#225D23,#253F36,#47451E,#A40060,#8CB300,#1B0A38,#B3ECFF,#E0E1DB,#ABAFA0,#9FA48E,#222627,#C3A6AB,#CEBCB0,#F9EFDE,#EDF4FC,#BAA488,#5E492C,#C8A92E,#F5FC73,#3677C4,#352D80,#1E1E1E,#332314,#0099CC,#634022,#50381E,#9C4623,#B78957,#897A4F,#EBE4A2,#3B769D,#E29510,#786D3C,#B7AA44,#16131A,#433244,#6D556F,#4C6E77,#9DBFC8,#4687BC,#CCBFB6,#A8693E,#948375,#D3F8FF,#94596B,#A8A6A9,#3D3F4B,#10121F,#CA8602,#D7C8AA,#F94D69,#69D2E7,#488F9D,#C08B61,#F76E64,#37E5C5,#2CB59C,#597E50,#F67178,#F83E3E,#27D695,#309D74,#BD6E3A,#4E4C40,#585141,#47392E,#D19863,#CC7A30,#FC1C06,#688D78,#687A8D,#74688D,#8D6878,#7FA99F,#7C9077,#9ABAAF,#7C8980,#6E6754,#FFE19C,#80B9B2,#A24927,#91ADAE,#9CA346,#1E4149,#63470E,#9A968C,#968665,#908061,#807158,#706446,#A99270,#E6EBE4,#1C201F,#6E5C5A,#C7B02C,#F9EFC9,#E4C880,#CEAA55,#EFE2A8,#F5ECC2,#F5DFDF,#D7D4D4,#FE9810,#E3D125,#4C8830,#173955,#063137,#DFD5D6,#BCB0B0,#6F6669,#517897,#255D8C,#FFE5C9,#E39C68,#DEBABC,#59503F,#BB5950,#BDBA92,#68675E,#232003,#57533E,#114244,#CBD590,#3A415B,#6E3A50,#59AD7B,#DDC6FF,#807AC2,#792600,#451600,#5A0005,#243391,#4D5691,#E6B055,#DE521F,#8F3C3C,#6000CC,#422400,#FFB09E,#00352D,#423100,#6B4B1F,#2A3E54,#09001D,#1A3300,#597A36,#F7E9B0,#F7E495,#F8DD70,#FAD53D,#FECD04,#FF8252,#CDCEFF,#34E5E2,#CBFF9C,#E9FF9C,#9B8B8B,#817F84,#41535F,#42647F,#556A7B,#16432C,#226A44,#298C5E,#1F6526,#205426,#2A0B00,#79543A,#F5B086,#F78CB8,#9F363B,#2A0B00,#79543A,#F5B086,#B44B59,#4CBBC6,#FFFBCB,#F28BA8,#39BAA6,#F4A886,#EFE39B,#333F4F,#111E26,#B2AC9E,#5B6F66,#649BB9,#FF4545,#FFB1EC,#FFEAEA,#124275,#D7DE87,#8000BB,#D05900,#B5008C,#BA003C,#AF0B00,#B77738,#675C62,#695A41,#050505,#9A4E41,#B5675A,#FCE5B1,#C38228,#554434,#BD5B71,#59839E,#748F67,#E8D69B,#D48C72,#F5FBD7,#EBF8CC,#E0F2B4,#A2A161,#79815A,#C111DF,#2E5FC6,#AFA9A8,#89867D,#878282,#979797,#D1CFCF,#D7D7CB,#BEBEB6,#787876,#494947,#252523,#D97428,#28D5D9,#A8C744,#D9D9D9,#A96243,#15661E,#46340E,#31460E,#FFE243,#EDA92A,#D34836,#4B8EFA,#1D6BB9,#4BB448,#F7F7F7,#49BF68,#9268E2,#4394EE,#FAA12E,#F44334,#16A085,#27AE60,#2980B9,#8E44AD,#2C3E50,#715736,#FFEDB4,#D10E0C,#533D25,#D7C99E,#694F74,#B49A01,#5E5137,#842739,#F5D5A9,#593E31,#FA7135,#632004,#0074D8,#00ABCE,#9234C2,#00F2B0,#FF2E3D,#EF6EA3,#C15984,#690953,#E5005E,#FF5FA3,#1ABC9C,#2ECC71,#3498DB,#9B59B6,#34495E,#16A085,#27AE60,#2980B9,#8E44AD,#2C3E50,#FF825D,#BB6047,#E6E6E6,#282D3B,#2B0995,#429DC9,#228B4B,#A06922,#FDF7D3,#3F3B3B,#575757,#BEBEBE,#D7D7D7,#4DB0EB,#FC6F5D,#7DD773,#A5A5A5,#F5F38D,#F7CA18,#F9690E,#049372,#DB3979,#1F3A93,#34495E,#F8C85C,#1ABC9C,#71B7E6,#EE8075,#2D9E81,#EEE5EB,#7D8189,#5A301C,#712043,#3498DB,#F6B517,#E74C3C,#2ECC71,#34495E,#42AFFF,#68E287,#EE6B48,#343B4C,#E7F04C,#EEEEEE,#343434,#50D6A2,#FFAB00,#E7DFCA,#4CD9FF,#FFFE79,#FF5540,#FF9265,#4FB2C8,#474E56,#909090,#313034,#FEFEFE,#F7EBC5,#C8F7C5,#C5EFF7,#F7C5C5,#FF9494,#2D3E50,#6F91B4,#E24C3F,#E2867E,#222222,#2C3E50,#34495E,#95A5A6,#BDC3C7,#ECF0F1,#91BD09,#0E59AE,#660099,#CC0000,#FF1178,#11FFC7,#27AE60,#3CB66F,#52BE7F,#67C68F,#7DCE9F,#0C79FC,#F7F7F7,#FF3B2F,#9ACC76,#E1E28C,#7AC5E2,#C599E5,#E599A0,#73B4DD,#79D79E,#EE6363,#FFC48C,#EFFAB4,#5080DD,#55CC91,#B53846,#FFCC00,#FF9900,#46BEAD,#38C2DC,#462345,#F37A48,#FF3550,#F3471A,#2DE7BB,#1EA654,#E3B33B,#FCFAD7,#A93736,#5CAECB,#FDFEAB,#FBC953,#F59140,#F2F2F2,#435A6B,#0E83CD,#F19F0F,#3FA46A,#607681,#59A2F9,#36C9D3,#F54352,#ADADAD,#895F83,#DBC820,#F0F0F0,#78A300,#FDD22E,#358FB2,#614149,#9A5D6D,#47D3A9,#143C30,#A3E1E7,#01C2D6,#F3FEFF,#17DD83,#F8F8F8,#228DD8,#92664B,#305775,#567287,#B0C7D9,#635E4F,#4A453A,#323A45,#5E6D81,#9EA7B3,#DBE1E8,#296297,#044C62,#0A99C3,#D5EDF7,#A0A0A0,#0B2F47,#224E6B,#318CB8,#F2F3F7,#00A7E3,#4FFFD3,#BEFF7D,#1D2026,#1ABC9C,#16A085,#3A9AC4,#4BAAD3,#F9F9F9,#26AE90,#FF675B,#52A4AC,#4792D2,#E6766B,#343B3D,#3E474A,#EFEBEE,#867970,#D2AE99,#816358,#1B0E11,#FBFCFC,#635B54,#14100E,#51463C,#483930,#00B671,#061830,#FF6853,#BE3418,#0E0E0E,#1C1C1C,#2E2E2E,#A5A198,#009CC7,#292929,#CF0455,#765826,#E6FFB0,#877D71,#FDE2C5,#9A5C47,#302F71,#D3CEFF,#341D0B,#FDE2C5,#C0DDEB,#852A00,#D3CEFF,#341D0B,#FDE2C5,#B2834F,#6A1700,#852A00,#341D0B,#FDE2C5,#B2834F,#6A1700,#852A00,#341D0B,#FDE2C5,#312122,#080614,#ECEAEF,#2E2EB2,#C915FD,#331C38,#244E80,#7AAFD7,#2D5682,#407237,#819B5C,#0E7AC4,#3EA9F5,#56BE8E,#ECEEF1,#F27398,#56CFC6,#EF3C59,#334657,#CCDFCC,#FCFAF4,#FF685D,#7CC2E6,#5A8645,#F5C69A,#FD4700,#2EE29F,#289960,#EF6A6C,#EDEEEF,#4C5666,#242A34,#1ABC9C,#2ECC71,#3498DB,#9B59B6,#34495E,#16A085,#27AE60,#2980B9,#8E44AD,#2C3E50,#290B03,#682E2D,#654C48,#B68B84,#FFB5A6,#585252,#DEDDDB,#E99743,#615190,#EDB79B,#01052B,#01265D,#0293A6,#5E5E5E,#C8C8C8,#9FC9E1,#74B2D7,#3D3E3E,#4688AE,#1E648C,#BAA48F,#D5BBA3,#E4E4E4,#C7D694,#ACBD73,#191D6D,#E13220,#3F4045,#777881,#10B092,#8CD8D8,#EB537A,#56C7FF,#FF809E,#7582A3,#E74C3C,#1ABC9C,#9B59B6,#2ECC71,#F41F4D,#39C48D,#5D6DC5,#D8C429,#33ADEA,#0FC19F,#2ACE6D,#3497DA,#A35DB6,#35405C,#00B98D,#FF7A6E,#EBF2F1,#323333,#005B47,#ECF0F1,#16A085,#E67E22,#2980B9,#2C3E50,#1ABC9C,#2ECC71,#3498DB,#9B59B6,#34495E,#FF7F7F,#7FFF7F,#7F7FFF,#7F7F7F,#FFD852,#452179,#0087C6,#58C7E5,#E9003A,#F2693D,#0E92A1,#0B4E5E,#FFC416,#4F7C39,#D0D0D0,#2D2D2D,#0F1621,#131B26,#39475B,#77869D,#C6C5F9,#F9D0C5,#C5F4F9,#F9F6C5,#C9F9C5,#1786A3,#B2E1F4,#C3D4DB,#00C4BA,#94B8BA,#747E7D,#93A681,#80736C,#746467,#A3C5B1,#BCCF02,#5BB12F,#9B539C,#EB65A0,#73C5E1,#847562,#918066,#9C8E74,#917E60,#83755B,#F1FFEF,#FFDDBE,#FFCDD2,#D0F1FF,#92C6F4,#F5F5F9,#0ACDC7,#63D3E9,#00B1E1,#F18161,#E3D6FF,#F7F2C9,#C9F7C9,#F7C9F0,#F7D1C9,#EEE691,#8BBED4,#927C99,#EF9778,#EDEDED,#CF3D50,#FED344,#5AB9EA,#C7BEB6,#58C456,#DFDEFF,#43385C,#EE9A6C,#E7F9F8,#6DDBD8,#D62F2F,#E7E415,#77BF2A,#D9D9D9,#2FD1D6,#33373B,#EEEFF3,#F8F8F8,#25B9FD,#7EAFA4,#E0BAAC,#CE9FB4,#A09ABA,#DAD597,#332A2D,#E20341,#33A7DF,#F0AC29,#29DF4A,#06AEE9,#FDF152,#414141,#E9F0EE,#7FBBC9,#BBF2E2,#D96A6A,#212538,#2E2D40,#FF4E44,#5366FF,#D0D3EA,#F9D9CB,#F1F9CB,#E0FCD6,#CBE6F9,#EACBF9,#70FBB7,#86F7F5,#D77F7D,#5D6766,#C9CED1,#F76D05,#B93D30,#3039B9,#30A9B9,#3FDBF0,#F2751D,#2ECC71,#3498DB,#2980B9,#2ECC73,#3290BE,#FFA338,#FF6339,#46A5E5,#2F6F99,#A1C436,#FFAC43,#FE943E,#FDFAC3,#C8FA7D,#3A69F7,#FF6C7B,#435851,#AFD8D4,#A09867,#F1E9A8,#EBD57F,#1A1A40,#443F5F,#655D99,#798CAD,#18E0C4,#CCCD24,#DEE516,#FCD39F,#C5D0DF,#EEE3EC,#AACCA4,#CAB0DE,#16A085,#1ABC9C,#ECF0F1,#2C3E50,#2980B9,#2D2440,#85FBBC,#0DCC98,#F3E086,#2D2440,#F1C40F,#E67E22,#E74C3C,#ECF0F1,#95A5A6,#F39C12,#D35400,#C0392B,#BDC3C7,#7F8C8D,#161616,#454545,#F54930,#F54F37,#F17841,#355468,#273E4D,#A6B1B8,#283E56,#0775AB,#3FB0E7,#9CDEFF,#222222,#7B8A8B,#95A5A6,#B4BCC2,#ECF0F1,#FFA700,#E7E6C2,#F1F1F0,#303030,#1671AA,#B34444,#6497A6,#D4C651,#837498,#64A796,#FECD57,#F7BB40,#F4A238,#EF7C2D,#ED5E25,#A5FCF2,#8BDAFC,#D280F0,#FF9AD7,#FF75C9,#EDEDDD,#A19A8B,#474643,#E9E8E3,#F9F8F4,#2ECC71,#3498DB,#F1C40F,#E67E22,#EA6153,#18AAF1,#16D8C8,#18E57E,#F7CA11,#E67E22,#F33C18,#CD56D8,#9155F2,#4C4944,#C0BDB7,#1386C0,#11A599,#13B262,#F4AF14,#D35400,#F9F9EF,#937089,#97D3D3,#E8B9C3,#A7D396,#1D3E91,#1D916B,#1D912D,#7A911D,#91441D,#DE854C,#783755,#508AB9,#27AE60,#232323,#4D8CBB,#F6180D,#15223D,#33AF97,#4E77B9,#8AB2E5,#E8EBF0,#373746,#8E44AD,#3498DB,#2ECC71,#1ABC9C,#E25189,#9D4969,#8F6877,#CC4B6F,#D1ADB7,#4375EF,#35B0E8,#5BF048,#F5B141,#F53E3B,#8DFFF4,#00EBCB,#EB0021,#002D2B,#134745,#E6935F,#CCC688,#ADCC95,#75C78F,#4B6473,#7A1414,#AF272B,#CF3239,#182129,#208190,#3FC4E0,#F36B24,#FBA828,#2A2742,#FF3951,#FEFEFF,#1B161C,#77635A,#FC5721,#C49A6C,#C89755,#3A383A,#5F6062,#F8F8F8,#0D0D0D,#7B9EA6,#F2F1EB,#BFB7AE,#59544D,#F3840E,#A7353F,#40C495,#EDE3AF,#269FBA,#E57102,#FFA901,#DFE3E3,#BAEAF9,#55BDE9,#5CACDE,#545F66,#F7F8F9,#ADD991,#F3817A,#869687,#757679,#35A3C5,#3661CE,#CD3790,#7B6148,#5B4F3D,#F3F3F3,#84AD6E,#423E39,#ED4F2B,#ED7459,#3A4494,#486194,#2D2D32,#004B8A,#FF9933,#EEEEEE,#6AABD8,#575756,#F7F7F7,#FFB62D,#F35715,#65D2D3,#5DB1AF,#F5F2EF,#524B4B,#1F1D1D,#FFFA6D,#FF8B07,#DDDEE0,#5FA7CD,#57636F,#CA776F,#5CC2C0,#A8E79B,#E4E4E6,#C1C4CD,#B5F3E5,#84FFD6,#5CCCFA,#808080,#18BC9C,#2C3E50,#F39C12,#E74C3C,#3498DB,#ECF0F1,#E74C3C,#C0392B,#2F4052,#404040,#DDD9E7,#000330,#282722,#63461A,#0F0F0D,#87A473,#7396A4,#A47373,#A4A473,#7F73A4,#46A6F0,#4D6980,#3A4247,#363463,#EA3B10,#FF9F00,#34495E,#4EBDD9,#2ECC71,#2C3E50,#336E7B,#C0392B,#DFD7A9,#1B0635,#1D2B49,#587052,#7A785F,#9C9666,#9C574E,#AB985E,#94AF84,#619EBA,#853E13,#B36B3E,#D95402,#51D902,#211D6B,#962929,#A9C9EB,#EBE4A9,#9AC48D,#343832,#658BA0,#6D6E4F,#B7DAD6,#6B6981,#909382,#45A9B0,#45A9B0,#45A9B0,#B045A0,#B045A0,#FFDCB3,#FFDCB3,#FFDCB3,#FFDCB3,#FFDCB3,#14161A,#131821,#808080,#A6A7AB,#BAC4D9,#00FF37,#B6AABD,#A6EDAF,#B6AABD,#A6EDAF,#22A602,#0726A6,#EBEBEB,#004691,#008C2A,#82644F,#8F7461,#9C8A7E,#ADA199,#54783D,#567046,#5E6659,#665F57,#6E5D4B,#1C1826,#25222B,#1E3745,#02729C,#92C2D4,#691E4F,#744664,#F7F4E3,#541102,#B5DC10,#5C5038,#B5A179,#B3D1FF,#87B7FF,#2A2445,#391B00,#A36A11,#EFDF87,#AE470C,#82F27E,#31D92B,#429611,#7C9611,#AAB509,#F2BF6D,#FC9C00,#8F5E10,#694409,#0A0600,#307890,#78C0D8,#F0A8F0,#C0D848,#C06018,#511D0F,#620F09,#BE800F,#585E1F,#323614,#C1054A,#040404,#666153,#9C9583,#484089,#2D541B,#33870C,#5BC928,#870C0C,#1F1D1B,#1D6EAF,#AC683B,#D7CE59,#942D31,#A7DA98,#F1F1F1,#569570,#8A1A42,#945400,#4A4D00,#422C00,#004094,#009454,#518568,#268572,#005C57,#218085,#307185,#D7E610,#A3B087,#B3B000,#BF8454,#774DF7,#74D72B,#F3FF94,#493407,#290108,#22420E,#4C9E3E,#205217,#1F5216,#57B846,#114D06,#2F3336,#6569A6,#9FAB93,#688454,#AF8B67,#DBD4BF,#DEADFB,#71A9A7,#AA70CC,#9149BA,#E8A527,#FFE5A3,#63889B,#768358,#CBBD90,#55EEF6,#FBFEFE,#E8F1F1,#CFDDDE,#FE0557,#A86E31,#5AB1A3,#43847A,#9D2F49,#B4C044,#98C9E9,#87A7B2,#9E8E75,#737B7D,#A8BAC6,#DCD100,#D12010,#691912,#696412,#AAA31B,#DDD380,#98AEB9,#5D6C89,#599669,#B3DD99,#DA8846,#FADFD0,#717CAB,#404B68,#C15A3A,#2A54AA,#C2DCFF,#DD8351,#79605B,#FBDDC1,#36260F,#55493B,#A76B2D,#5F5E1D,#957161,#AEA085,#2A640D,#41221F,#222D1C,#7D8450,#774662,#E2D116,#2B0551,#4F000F,#447036,#AB9482,#54544C,#4B1219,#61687A,#5C2E2E,#B02558,#EBE7D5,#F0D800,#153B4D,#648C3E,#141F5E,#2D3373,#FFC032,#4B0A00,#2B0600,#D7DF4A,#787D2E,#C8A270,#619644,#B35CA2,#3DE028,#065BB2,#B81813,#DF8B1A,#0B0D0B,#00155C,#005C3C,#5C0059,#5C4500,#5C0000,#B726BF,#D829C1,#D179C1,#79B6D1,#54F2A8,#F2F2F2,#266570,#2F1A59,#264170,#3E2B63,#2F8994,#D1B502,#A5B2B4,#F9E540,#F9AA4E,#CF8B3B,#A0AC2F,#E78754,#C4DCA9,#F5E531,#59B2A8,#A8402C,#662F63,#606BC4,#D088AE,#808186,#C8596C,#29BDD7,#514F47,#B86158,#E2DCC5,#E2DCC5,#BAD5D8,#1ABC9C,#2ECC71,#3498DB,#9B59B6,#34495E,#F39C12,#D35400,#C0392B,#BDC3C7,#7F8C8D,#79552E,#D9A228,#E4D1A8,#EDE7BD,#857250,#664872,#F6DCAF,#6E6555,#5E5139,#603D5C,#5E4A2F,#46214A,#E8D3A2,#645B46,#FF0000,#541E62,#E8CFA7,#544328,#5D4D38,#FF6600,#5C4E37,#E7D1AB,#4E225D,#5E5139,#FCFCFC,#5C4F3D,#CBAF15,#F3E6BB,#5F166E,#4C1774,#333333,#65A100,#EF6EA3,#D90000,#F39C12,#D35400,#C0392B,#BDC3C7,#7F8C8D,#A8A696,#E7C478,#A8A38E,#718670,#B56243,#EDF0F9,#656C88,#C16666,#7CB47A,#56425B,#C28C8C,#FFFFCC,#839E83,#FFEDA4,#E5D596,#FDB53F,#FE635F,#804D76,#1ABC9C,#39A3E2,#BF4B36,#FFAC55,#9364BB,#ADFF9D,#E17A69,#AB8A3A,#D62D0C,#167B18,#EEC00C,#3E2E09,#00A8A9,#006DC9,#F6952A,#BB2C24,#635346,#ECD450,#63BCCD,#4771AD,#64733A,#E24833,#51BDCB,#052A48,#96CC54,#FC5508,#EC008C,#2E3A86,#192742,#8890BF,#E69E18,#F0ECC6,#2284A3,#333333,#919191,#373F54,#50CBF3,#EC4E9C,#F5B9D4,#D2E0E5,#1578B1,#F6664E,#2FBAB5,#9E69E8,#B4CE2B,#2ECC71,#42D17F,#57D68D,#6CDB9B,#81E0A9,#96E5B8,#ABEAC6,#C0EFD4,#D5F4E2,#EAF9F0,#27AE60,#239C56,#1F8B4C,#1B7943,#176839,#135730,#0F4526,#0B341C,#072213,#031109,#5A87C5,#C0392B,#8E44AD,#27AE60,#F39C12,#5A87C5,#C0392B,#8E44AD,#27AE60,#F1C40F,#00A096,#D2552E,#474542,#E4E2DF,#F9F8F7,#2980B9,#CE5144,#525B66,#239D58,#E8DA0A,#83FFC3,#82FFE2,#82DEFF,#829FFF,#8482FF,#E46343,#28BDA7,#CDDC41,#FAFAFA,#646464,#8CB116,#F9D273,#CA3B33,#BCDCFF,#0A58E0,#223730,#25344B,#001129,#E97D35,#CC6928,#00547A,#185186,#ECBD27,#DBCC00,#990002,#2E2B23,#787A5C,#5E543F,#BA943A,#7A6D52,#B0D894,#9496D8,#867E91,#D09765,#91877E,#DCDCDC,#408EEA,#4CDB3C,#E59D37,#E06962,#57C76A,#DADE61,#E0B162,#57A5C7,#52A8C5,#F9C41E,#F9F91F,#18C418,#37ADEA,#0090C7,#D12D35,#52C72C,#21917A,#FF6830,#F6A3FF,#800075,#5B6270,#333333,#FFF899,#99A0FF,#003BE1,#5B6270,#333333,#FFF899,#8CD0AE,#B7E7D1,#F0FCF6,#C4E8FB,#FFCCB6,#EC5041,#CD562C,#527092,#1ABAB2,#67B34F,#96281B,#2C4764,#1E2D58,#806C54,#ECC311,#DE5E3E,#1C1A21,#DEDAD4,#DFF3ED,#1C492F,#262626,#21262E,#448ACF,#009B67,#FF7C51,#218EAD,#1C1C1C,#585858,#1A404D,#0096BE,#0D0D0D,#272727,#888888,#D6D6D6,#0F292D,#193339,#0B0B0B,#131313,#3D3A3B,#F2A500,#DE501B,#6D14A8,#009154,#004EF2,#AAAA46,#171717,#272727,#333333,#707070,#7BF77E,#111111,#1F1F1F,#3F3F3F,#5F5F5F,#CB7123,#A1221C,#8D5E66,#642C1D,#300600,#9B8F79,#A1221C,#8D5E66,#642C1D,#300600,#AEB991,#A1221C,#8D5E66,#642C1D,#300600,#BDD3E8,#A1221C,#8D5E66,#642C1D,#300600,#CDB6A4,#D2580F,#8D5E66,#642C1D,#300600,#8D8676,#D2580F,#B2AC94,#642C1D,#300600,#52883D,#D2580F,#B2AC94,#642C1D,#300600,#715E02,#D2580F,#B2AC94,#8D5E66,#C80F17,#7E775D,#B1A08E,#715E02,#8D5E66,#C80F17,#345B26,#B1A08E,#715E02,#8D5E66,#C80F17,#31170A,#B1A08E,#715E02,#8D5E66,#C80F17,#23447A,#B1A08E,#715E02,#8D5E66,#C80F17,#23447A,#B1A08E,#FFFFD6,#B7A460,#345B26,#FFBFBF,#B1A08E,#FFFFD6,#B7A460,#845344,#FFBFBF,#B1A08E,#B7A460,#FFFFD6,#F8CCA7,#EED8B3,#B1A08E,#B7A460,#FFFFD6,#F8CCA7,#C0925E,#B1A08E,#B7A460,#FFFFD6,#F8CCA7,#616044,#B1A08E,#715E02,#FFFFD6,#876235,#C80F17,#B1A08E,#715E02,#FFFFD6,#876235,#C80F17,#B1A08E,#715E02,#FFFFD6,#345B26,#A90915,#B1A08E,#715E02,#FFFFD6,#345B26,#A90915,#B1A08E,#715E02,#FFFFD6,#CB5E0C,#7B473A,#B1A08E,#715E02,#FFFFD6,#CB5E0C,#345B26,#B1A08E,#715E02,#FFFFD6,#CB5E0C,#90A86A,#B1A08E,#715E02,#FFFFD6,#CB5E0C,#876235,#B1A08E,#715E02,#FFFFD6,#CB5E0C,#876235,#B1A08E,#715E02,#FFFFD6,#1E468B,#845344,#B1A08E,#715E02,#FFFFD6,#1E468B,#E28037,#B1A08E,#715E02,#FFFFD6,#1E468B,#69551A,#B1A08E,#715E02,#FFFFD6,#1E468B,#69551A,#B1A08E,#715E02,#FFFFD6,#F58927,#FFBFBF,#B1A08E,#A78152,#FFFFD6,#F58927,#B7A460,#B1A08E,#A78152,#FFFFD6,#F58927,#90A86A,#B1A08E,#A78152,#FFFFD6,#F58927,#90A86A,#B1A08E,#A78152,#FFFFD6,#91673D,#90A86A,#B1A08E,#A78152,#FFFFD6,#6F6657,#90A86A,#B1A08E,#A78152,#FFFFD6,#660607,#845344,#B1A08E,#A78152,#FFFFD6,#F58927,#845344,#B1A08E,#A78152,#FFFFD6,#466A22,#425B58,#B1A08E,#A78152,#FFFFD6,#466A22,#425B58,#B1A08E,#374F53,#FFFFD6,#5E7A92,#968969,#EBD0BF,#2D2F17,#681507,#43452F,#968969,#EBD0BF,#2D2F17,#681507,#AD5203,#AD5203,#EBD0BF,#425B58,#681507,#400400,#AABEF0,#EBD0BF,#425B58,#FFBFBF,#AD717D,#809076,#EBD0BF,#D7B59C,#FFBFBF,#BBAF95,#515435,#EBD0BF,#7F3B2E,#FFBFBF,#681507,#515435,#809076,#7F3B2E,#FFBFBF,#681507,#515435,#809076,#7F3B2E,#FFBFBF,#383627,#425B58,#809076,#7F3B2E,#FFBFBF,#383627,#5E643E,#809076,#7F3B2E,#EBD0BF,#AD5203,#5E643E,#809076,#7F3B2E,#EBD0BF,#9A8E78,#2F5522,#809076,#1A3709,#EBD0BF,#867C70,#2F5522,#F8CCA7,#681507,#EBD0BF,#5E643E,#474127,#F8CCA7,#681507,#EBD0BF,#7F7A40,#9A8E78,#F8CCA7,#681507,#EBD0BF,#7F7A40,#852A00,#8E6F2E,#681507,#EBD0BF,#E58618,#2DA819,#FFF0D5,#681507,#EBD0BF,#B7302A,#2DA819,#FFF0D5,#A8A544,#D3CEFF,#B7302A,#2DA819,#FFF0D5,#A8A544,#D3CEFF,#9A0000,#9A0000,#FFF0D5,#2C2010,#D3CEFF,#312122,#852A00,#FFF0D5,#2C2010,#D3CEFF,#312122,#180B05,#FFF0D5,#2C2010,#D3CEFF,#312122,#180B05,#FFF0D5,#2C2010,#AF9DD7,#6C825E,#180B05,#FFF0D5,#E58618,#DBBE96,#6C825E,#180B05,#FFF0D5,#E58618,#DBBE96,#B2834F,#180B05,#FFF0D5,#B14B00,#DBBE96,#6A1700,#180B05,#FFF0D5,#B14B00,#DBBE96,#2C2010,#180B05,#FFC77D,#B14B00,#302F71,#A8A544,#180B05,#FFC77D,#B14B00,#182803,#A8A544,#180B05,#E6FFB0,#B14B00,#182803,#9A0000,#180B05,#E6FFB0,#A8A544,#182803,#9A0000,#180B05,#E6FFB0,#A8A544,#9A0000,#312122,#180B05,#E6FFB0,#A8A544,#9A0000,#877D71,#180B05,#E6FFB0,#BAA377,#CD6504,#9A5C47,#180B05,#E6FFB0,#BAA377,#CD6504,#F9E6C6,#180B05,#DBBE96,#A8A544,#FFC77D,#F9E6C6,#180B05,#302F71,#6C825E,#FFC77D,#AF9DD7,#180B05,#302F71,#6C825E,#D3CEFF,#AF9DD7,#180B05,#302F71,#6C825E,#D3CEFF,#B14B00,#6A1700,#302F71,#6C825E,#D3CEFF,#B14B00,#9A0000,#2DA819,#DBBE96,#765826,#B2834F,#9A5C47,#2DA819,#DBBE96,#FDE2C5,#B2834F,#B7302A,#9A5C47,#DBBE96,#FDE2C5,#B2834F,#6C825E,#9A5C47,#DBBE96,#FDE2C5,#918B75,#6C825E,#A8A544,#B2834F,#FDE2C5,#A99A7D,#6C825E,#A8A544,#E58618,#FDE2C5,#A99A7D,#6C825E,#E6FFB0,#918B75,#FDE2C5,#A99A7D,#FF5555,#3BB281,#4CB0D5,#F2A266,#5F7CEA,#F39C12,#D35400,#C0392B,#BDC3C7,#7F8C8D,#290B03,#682E2D,#654C48,#B68B84,#DED1FC,#825447,#682E2D,#9A514A,#FFB5A6,#DED1FC,#682E2D,#825447,#9A514A,#FFB5A6,#BAAA6F,#682E2D,#783F24,#9A514A,#FFB5A6,#BAAA6F,#442513,#783F24,#9A514A,#FFB5A6,#F3D2C3,#2A2C45,#5F4B92,#8598A7,#A5ABCB,#F3D2C3,#152A17,#1E3813,#355E24,#59763C,#BAAA6F,#152A17,#1E3813,#355E24,#59763C,#F8CBC5,#152A17,#1E3813,#355E24,#59763C,#DFAFAF,#41E678,#24B66E,#780F9E,#9EADAB,#434AB3,#F0534A,#4CBC5C,#3283C3,#545355,#F7F6F5,#957236,#DC543A,#B06142,#EE9433,#B0702B,#783710,#927358,#D33815,#3E8E41,#8E4B3E,#66A1D5,#67D5C6,#67D578,#CFD567,#D56767,#DE1B63,#277DC7,#007B44,#8FC31F,#E67E22,#E74C3C,#27AE60,#F39C12,#D4F1FF,#FFF99D,#C0392B,#219452,#E57E22,#5FCCFF,#F1C40F,#B04121,#BDC3C7,#34495E,#FFFAF4,#9795A2,#FFFFB1,#5D8C92,#B33D23,#DB6832,#7A7C7B,#CB6139,#C29473,#494947,#3A6587,#890713,#D3D028,#45AD43,#5E717F,#A74A3A,#414A46,#41735C,#2D9267,#8D7BF5,#2B5669,#538898,#32586B,#2F5268,#32586B,#525C75,#414168,#025D8C,#187453,#AD234B,#BAB486,#80887F,#BAA786,#A1A574,#A3967F,#C7FAAA,#92EBBE,#94C8E7,#FFB69E,#9DA8B0,#59858F,#96A795,#C0C3A6,#EFEEDB,#222222,#7C421D,#289944,#21549E,#CFCFCF,#1ABC9C,#2ECC71,#3498DB,#9B59B6,#34495E,#16A085,#27AE60,#2980B9,#8E44AD,#2C3E50,#F35423,#FF6A2A,#FF9535,#003250,#768289,#EDEDED,#498190,#464F4E,#AE262C,#D22E35,#E8353D,#F83942,#ED4B51,#FFC044,#FAA840,#D86F27,#FF5A40,#32A68E,#4D4D4D,#F8BE7D,#FBFAF7,#FAF9F6,#CB3214,#9D42A5,#7343BF,#272523,#807E7A,#DBDBDB,#DBDBDA,#95D324,#FF3200,#F1F1F0,#69551A,#B1A08E,#715E02,#FFFFD6,#1E468B,#69551A,#B1A08E,#715E02,#FFFFD6,#F58927,#FFBFBF,#B1A08E,#A78152,#FFFFD6,#F58927,#B7A460,#B1A08E,#A78152,#FFFFD6,#F58927,#90A86A,#B1A08E,#A78152,#FFFFD6,#F58927,#90A86A,#B1A08E,#A78152,#FFFFD6,#91673D,#90A86A,#B1A08E,#A78152,#FFFFD6,#6F6657,#90A86A,#B1A08E,#A78152,#FFFFD6,#660607,#845344,#B1A08E,#A78152,#FFFFD6,#F58927,#845344,#B1A08E,#A78152,#FFFFD6,#466A22,#425B58,#B1A08E,#A78152,#FFFFD6,#466A22,#425B58,#B1A08E,#374F53,#FFFFD6,#5E7A92,#968969,#EBD0BF,#2D2F17,#681507,#43452F,#968969,#EBD0BF,#2D2F17,#681507,#AD5203,#AD5203,#EBD0BF,#425B58,#681507,#400400,#AABEF0,#EBD0BF,#425B58,#FFBFBF,#AD717D,#809076,#EBD0BF,#D7B59C,#FFBFBF,#BBAF95,#515435,#EBD0BF,#7F3B2E,#FFBFBF,#681507,#515435,#809076,#7F3B2E,#FFBFBF,#681507,#515435,#809076,#7F3B2E,#FFBFBF,#383627,#425B58,#809076,#7F3B2E,#FFBFBF,#383627,#5E643E,#809076,#7F3B2E,#EBD0BF,#AD5203,#5E643E,#809076,#7F3B2E,#EBD0BF,#9A8E78,#2F5522,#809076,#1A3709,#EBD0BF,#867C70,#2F5522,#F8CCA7,#681507,#EBD0BF,#5E643E,#474127,#F8CCA7,#681507,#EBD0BF,#7F7A40,#9A8E78,#F8CCA7,#681507,#EBD0BF,#7F7A40,#852A00,#8E6F2E,#681507,#EBD0BF,#E58618,#2DA819,#FFF0D5,#681507,#EBD0BF,#B7302A,#2DA819,#FFF0D5,#A8A544,#D3CEFF,#B7302A,#2DA819,#FFF0D5,#A8A544,#D3CEFF,#9A0000,#9A0000,#FFF0D5,#2C2010,#D3CEFF,#312122,#852A00,#FFF0D5,#2C2010,#D3CEFF,#312122,#180B05,#FFF0D5,#2C2010,#D3CEFF,#312122,#180B05,#FFF0D5,#2C2010,#AF9DD7,#6C825E,#180B05,#FFF0D5,#E58618,#DBBE96,#6C825E,#180B05,#FFF0D5,#E58618,#DBBE96,#B2834F,#180B05,#FFF0D5,#B14B00,#DBBE96,#6A1700,#180B05,#FFF0D5,#B14B00,#DBBE96,#2C2010,#180B05,#FFC77D,#B14B00,#302F71,#A8A544,#180B05,#FFC77D,#B14B00,#182803,#A8A544,#180B05,#E6FFB0,#B14B00,#182803,#9A0000,#180B05,#E6FFB0,#A8A544,#182803,#9A0000,#180B05,#E6FFB0,#A8A544,#9A0000,#312122,#180B05,#E6FFB0,#A8A544,#9A0000,#877D71,#180B05,#E6FFB0,#BAA377,#CD6504,#9A5C47,#180B05,#E6FFB0,#BAA377,#CD6504,#F9E6C6,#180B05,#DBBE96,#A8A544,#FFC77D,#F9E6C6,#180B05,#302F71,#6C825E,#FFC77D,#AF9DD7,#180B05,#302F71,#6C825E,#D3CEFF,#AF9DD7,#180B05,#302F71,#6C825E,#D3CEFF,#B14B00,#6A1700,#302F71,#6C825E,#D3CEFF,#B14B00,#9A0000,#2DA819,#DBBE96,#765826,#B2834F,#9A5C47,#2DA819,#DBBE96,#FDE2C5,#B2834F,#B7302A,#9A5C47,#DBBE96,#FDE2C5,#B2834F,#6C825E,#9A5C47,#DBBE96,#FDE2C5,#918B75,#6C825E,#A8A544,#B2834F,#FDE2C5,#A99A7D,#6C825E,#A8A544,#E58618,#FDE2C5,#A99A7D,#6C825E,#E6FFB0,#918B75,#FDE2C5,#A99A7D,#FF5555,#3BB281,#4CB0D5,#F2A266,#5F7CEA,#F39C12,#D35400,#C0392B,#BDC3C7,#7F8C8D,#290B03,#682E2D,#654C48,#B68B84,#DED1FC,#825447,#682E2D,#9A514A,#FFB5A6,#DED1FC,#682E2D,#825447,#9A514A,#FFB5A6,#BAAA6F,#682E2D,#783F24,#9A514A,#FFB5A6,#BAAA6F,#442513,#783F24,#9A514A,#FFB5A6,#F3D2C3,#2A2C45,#5F4B92,#8598A7,#A5ABCB,#F3D2C3,#152A17,#1E3813,#355E24,#59763C,#BAAA6F,#152A17,#1E3813,#355E24,#59763C,#F8CBC5,#152A17,#1E3813,#355E24,#59763C,#DFAFAF,#41E678,#24B66E,#780F9E,#9EADAB,#434AB3,#F0534A,#4CBC5C,#3283C3,#545355,#F7F6F5,#957236,#DC543A,#B06142,#EE9433,#B0702B,#783710,#927358,#D33815,#3E8E41,#8E4B3E,#66A1D5,#67D5C6,#67D578,#CFD567,#D56767,#DE1B63,#277DC7,#007B44,#8FC31F,#E67E22,#E74C3C,#27AE60,#F39C12,#D4F1FF,#FFF99D,#C0392B,#219452,#E57E22,#5FCCFF,#F1C40F,#B04121,#BDC3C7,#34495E,#FFFAF4,#9795A2,#FFFFB1,#5D8C92,#B33D23,#DB6832,#7A7C7B,#CB6139,#C29473,#494947,#3A6587,#890713,#D3D028,#45AD43,#5E717F,#A74A3A,#414A46,#41735C,#2D9267,#8D7BF5,#2B5669,#538898,#32586B,#2F5268,#32586B,#525C75,#414168,#025D8C,#187453,#AD234B,#BAB486,#80887F,#BAA786,#A1A574,#A3967F,#C7FAAA,#92EBBE,#94C8E7,#FFB69E,#9DA8B0,#59858F,#96A795,#C0C3A6,#EFEEDB,#222222,#7C421D,#289944,#21549E,#CFCFCF,#1ABC9C,#2ECC71,#3498DB,#9B59B6,#34495E,#16A085,#27AE60,#2980B9,#8E44AD,#2C3E50,#F35423,#FF6A2A,#FF9535,#003250,#768289,#EDEDED,#498190,#464F4E,#AE262C,#D22E35,#E8353D,#F83942,#ED4B51,#FFC044,#FAA840,#D86F27,#FF5A40,#32A68E,#4D4D4D,#F8BE7D,#FBFAF7,#FAF9F6,#CB3214,#9D42A5,#7343BF,#272523,#807E7A,#DBDBDB,#DBDBDA,#95D324,#FF3200,#F1F1F0,#666666,#ABDB25,#999999,#CCCCCC,#574D4F,#969091,#FFE999,#FFD952,#FF548F,#9061C2,#BE80FF,#63D3FF,#02779E,#F75E11,#97B8B6,#CCDEDD,#FFF69A,#F5A630,#D65B22,#2E0E1D,#A1DEBE,#C5BCAB,#EBEBE0,#63B4C9,#4C3639,#17A768,#F1601D,#F1AD1D,#E7E0D2,#BBAE93,#F9FFFF,#F00C01,#AE212A,#693237,#45403C,#2F304C,#F1BC9E,#6F7677,#E57881,#B14671,#797470,#F1F1EC,#CECDC6,#BB3900,#222222,#2B0615,#B6CB6D,#0B8993,#165570,#8AB688,#413F42,#FBF2DA,#96E0E7,#51A6C2,#CAD3DF,#A41832,#F6BE29,#A2DC16,#02808F,#453540,#D56827,#999F3B,#6BBEC4,#404040,#E1CD6A,#C15D6E,#6E1134,#480117,#100114,#1A1613,#5D2C0A,#AB8C3C,#EBE5DB,#264B58,#FBF3C6,#F3D4AA,#8B7D7B,#484C57,#0E1A30,#2C4001,#465902,#758C20,#F2F1E9,#403A2F,#FA6900,#F8ECC2,#CDDFCD,#6B6969,#3E4851,#125560,#939938,#CFBA3D,#DBD38B,#121726,#0D344A,#236050,#668E1A,#B3A261,#B9722B,#AF435C,#E5CBB5,#C2AE2F,#096D74,#0E1626,#778D8E,#333234,#968F93,#CAD7B0,#F3F3E7,#FBA534,#683A1E,#333333,#CFDFD4,#ECF5DE,#B4A53E,#8F9A34,#006736,#243807,#010000,#C2E83C,#97CE44,#D8DECE,#313131,#C4C3C3,#ABABAB,#368C94,#156273,#0C171F,#1D1B31,#8F2C68,#FF91B7,#FFC8BF,#788680,#534741,#736357,#787868,#8EBD62,#62B7BD,#2B1A1C,#333436,#B59F76,#EFE7D0,#8B9AA1,#DBCB90,#A3A275,#807659,#3C3A36,#E5D0CF,#34353C,#5D5F78,#958198,#A9B5AA,#C8CFC3,#DFCAA8,#DD9956,#868A63,#26575D,#241D1D,#171717,#1D2C43,#486972,#3E968A,#42CBAD,#8E890F,#DCE1E4,#ECF0EF,#E8E6E7,#2A2033,#735A6C,#A18986,#BBB6A4,#868B6B,#575757,#20B4E2,#29C3F4,#00CCFF,#007AA6,#76F4CA,#FEFA99,#001307,#320826,#0E505F,#2CB6BA,#030202,#7C8934,#AAAD81,#34235B,#FF9900,#1DB36B,#8F047A,#D23C59,#5F8A31,#A3BA46,#272B2E,#FFCFAE,#E92404,#AD2520,#18C4C0,#D5EEDD,#F0EDE2,#D9AF15,#DCF9BC,#967A23,#ADE7AA,#E3F1BA,#C3B470,#850061,#EBEBEB,#EEF8B5,#E4FF49,#BAC200,#D0D900,#DAE400,#F4FF00,#303030,#AE9B97,#5D5871,#141218,#452F4F,#D1CAAC,#37273F,#70282C,#846028,#D89F77,#070611,#433A3C,#CF6646,#DFCD7E,#E6E0C8,#888451,#F46A4F,#273D4C,#EDE1BF,#9FB258,#1C81B0,#4A4E4D,#0E9AA7,#3DA4AB,#F6CD61,#FE8A71,#EFEFEA,#5F6062,#4ABCE1,#D5E04D,#636363,#61717D,#5F7F96,#9FB17F,#DFE368,#BE394C,#383838,#FF99A8,#FFD6DC,#DAE3E0,#EA3556,#DD577A,#61D2D6,#9BF0E9,#FFF0CF,#A6292F,#F0DBBC,#C0C257,#3C3B39,#A12432,#0E77D0,#5CA7E6,#C7DDEF,#F1F5F9,#E64A26,#282A2B,#91BEC4,#A2D2D8,#AEE3EA,#055D85,#05C4E1,#E9EDEC,#FCC302,#E19702,#D3D69D,#C7BC59,#9D9D58,#6B6358,#302D32,#5E5558,#FF7F33,#1E2218,#EDC880,#5D0D0D,#BBA47B,#ECDCA8,#E28389,#740040,#31C79D,#34495E,#4F8677,#6B9B61,#8F934D,#B17E22,#DBF339,#E2C51F,#D19A02,#003C70,#041656,#2C2D2D,#C54138,#E44C41,#D0B6A5,#8F969C,#A7A798,#D2ECB5,#A2AC36,#4F4A34,#636967,#B1D0BF,#EBE9D1,#A71D2A,#2D2D2D,#EAAE4E,#FC7C3D,#CE0027,#740025,#5E0525,#292929,#4D4D51,#B4B17E,#E2DDA4,#903F38,#DEACA1,#F3CDC0,#9B857A,#925D27,#5C3111,#F8065A,#FEFEFE,#BDE8EE,#0E82A0,#05556A,#8B7F73,#656D59,#53554E,#282622,#BBB683,#314D5C,#41525E,#826C69,#FDA26D,#FDF7E4,#BFE9EF,#795439,#ECE7DF,#D348A1,#D1F2F7,#785075,#240026,#7C958B,#D0CEA5,#FFFDD4,#E7E4D3,#F28E98,#FF9985,#DECFB8,#E1CBA6,#004A80,#92D3D9,#FAF3D9,#D5EF6B,#669E07,#FFD1DC,#FF8CA8,#FF668B,#70E8CB,#FFE9C7,#FF5B5B,#545454,#2D2D2F,#422525,#D44108,#D48908,#D4D108,#F8F8DB,#04346B,#205CA0,#D0D9E2,#FF5400,#EEEEEF,#7C7C7C,#38373E,#16141B,#2F8E70,#31AF7D,#EEE9CF,#4F453A,#252525,#FF5B5C,#F53E54,#FFE3BA,#F36C3F,#F8E96A,#2A3D4C,#415C57,#547C57,#85A856,#BED06A,#3B0006,#A70213,#999999,#FFFF99,#FFFFD4,#F0F0F0,#D8D8D8,#D8F0F0,#90F0F0,#30D8D8,#3C2833,#C84940,#819D49,#FAA93D,#291E18,#163C85,#275FB4,#5D99D7,#EDEEF2,#DEDBD4,#5A514C,#7F7A74,#F5EEE8,#C3C1B4,#FFAF40,#55564A,#A6A626,#5F5A36,#E9DFA3,#91CB8A,#F2E5B5,#E95730,#FAF6E5,#BAAE9A,#7D6B62,#F0EDE0,#FFD56B,#E45F5F,#305878,#16B5E4,#355537,#7C907C,#D8E6D8,#E9E8E6,#B0B6AB,#D9CCA0,#427D92,#1C4959,#28252D,#4C2F51,#7C567E,#B4A180,#DDBCA6,#1F0316,#611B3C,#C0345E,#C39754,#CAB194,#F1DCBF,#2280A6,#E3A776,#178B82,#614350,#C5EECA,#A9E78A,#0B0915,#D0CD55,#D7DAB7,#585858,#5F767F,#959393,#1E2738,#363F48,#2D839E,#65CCA9,#FFD602,#F26E21,#77B31E,#DDF2BB,#F5F5F5,#222222,#0F0F0F,#A0F601,#ECF0F1,#768A92,#687E87,#5E7078,#2C0E19,#864842,#D94B3F,#D07A6A,#70CBB3,#C4BBA0,#A3967E,#716653,#EBF00F,#EAECCE,#3F85A9,#92C5E0,#75B6D6,#CFCFCF,#FCFFF6,#F1F3EC,#777784,#36384E,#A80400,#EBEBE9,#DBDDE9,#C2C3EF,#ABAAF6,#7575F1,#CEECEF,#FF2200,#D5E469,#98BF17,#235A89,#238944,#1E1E1E,#C1C1C1,#F4F4F4,#78663E,#241B16,#3158A7,#6388D6,#8AB3E9,#336699,#669933,#DDDDDD,#993333,#BA365B,#E05566,#FFDBC7,#49939C,#1C181F,#4F7278,#314249,#219CB8,#DBDBD3,#FF4805,#122E32,#1E6555,#F2F2F4,#FFA13A,#575B8B,#30020F,#A6403B,#C15B13,#D99A3B,#FFEBB8,#291218,#A3594C,#AB998F,#DBBB88,#FCEED3,#E62F5F,#9F3F5B,#F9BCA0,#E4F5C8,#4D3447,#F46553,#3D4352,#4C5365,#F1F1F1,#1D3C42,#67BFAD,#F2EC99,#F2C48D,#F25050,#E5D7D4,#D44220,#2F2320,#211512,#5E240A,#B43B06,#EEE4E1,#433F3E,#292220,#D45001,#E0D8D3,#0080AC,#005C7D,#00455D,#D01116,#FF151B,#F7EBEC,#E8DADB,#DBCDCD,#EBEBEB,#F4F4F4,#FDFCF8,#FDFBE5,#FAF5BD,#F64750,#F6F5F5,#E9E4E4,#D8CCCD,#456AA6,#3CA6E8,#C2E83C,#EDEDED,#182E35,#58D5FE,#D9ECF2,#C1D4DA,#9AA9AD,#D7D204,#E5F2BF,#EAFDF9,#D3FCF3,#79DEC9,#F4D004,#E5A512,#C95400,#606B3E,#232716,#5C060F,#C45634,#7E9553,#D8AB72,#16314F,#D4D890,#8F9D64,#4F6E66,#7C2334,#2C0E1A,#0C3635,#DECA93,#B8BA7C,#536A73,#AF7D7F,#E9E0A4,#D9722B,#0B2B3E,#59ADC3,#8E286D,#5B7B3E,#D0CD4D,#A5B919,#853660,#50335D,#6B777D,#C6BD8A,#958F74,#7D605F,#2C4433,#D0DADD,#97BBC6,#16748E,#1A2F44,#2CA4A5,#9EC51A,#7CAD16,#B6BC9A,#D9E5CD,#44B3C7,#152123,#737B7E,#392623,#94A42C,#E2E8AF,#E7E7E7,#FF0099,#BAB1B1,#B1B3BA,#B3BAB1,#272B2B,#5E5E5E,#E3E3E3,#64A7C5,#EF037F,#009FC7,#F8F7F5,#CFEC9A,#B3D51F,#F28D20,#F1EBB6,#4DA2C7,#DEF1F7,#F8E71A,#2386BF,#A40E31,#E4B22D,#FEFEFE,#DEC0A8,#63B7E6,#248BC5" );
		
		if ( $shuffle === true ) {
			shuffle( $flat_colors );
		}
		
		$k = 0;
		foreach ( (array) $flat_colors as $flat_color ) {
			if ( $k > $count ) {
				return $returned_colors;
			}
			if ( $good_colors_only === false ) {
				$returned_colors[] = $flat_color;
				$k ++;
			} else {
				if ( ! wpvr_color_is_good_color( $flat_color ) ) {
					$returned_colors[] = $flat_color;
					$k ++;
				}
			}
		}
		
		return $returned_colors;
	}
	
	function wpvr_color_is_good_color( $hex ) {
		
		$r = hexdec( $hex[0] . $hex[1] );
		$g = hexdec( $hex[2] . $hex[3] );
		$b = hexdec( $hex[4] . $hex[5] );
		
		$lightness = ( max( $r, $g, $b ) + min( $r, $g, $b ) ) / 510.0;
		//d( $lightness );
		// return true;
		return $lightness >= 0.35 && $lightness < 0.9;
		
		
	}
	
	function wpvr_generate_colors( $count = 0, $hue = false, $luminosity = 'bright' ) {
		
		if ( $count === false ) {
			return '#27A1CA';
		}
		
		if ( $hue === false ) {
			// $hue = 'random';
			$hue = array(
				'red',
				// 'yellow',
				'orange',
				'blue',
				'green',
			);
		}
		
		if ( $count === 0 ) {
			return RandomColor::one( array(
				'luminosity' => $luminosity,
				'hue'        => $hue,
				'format'     => 'hex',
			) );
		}
		
		return RandomColor::many( $count, array(
			'luminosity' => $luminosity,
			'hue'        => $hue,
			'format'     => 'hex',
		) );
	}
	
	function wpvr_render_notice( $notice = array(), $k = 0 ) {
		global $current_user, $default_notice, $rendered_notices;
		global $notice_style_loaded;
		$user_id = $current_user->ID;
		
		if ( ! is_array( $notice ) ) {
			$notices = get_option( 'wpvr_notices' );
			$notice  = $notices[ $notice ];
		}
		
		$notice = wpvr_extend( $notice, $default_notice );
		
		
		if ( isset( $rendered_notices[ $notice['slug'] ] ) ) {
			return false;
		} else {
			$rendered_notices[ $notice['slug'] ] = 1;
		}
		
		if ( $notice['title'] === false ) {
			$notice['title'] = '';
		} elseif ( $notice['title'] == '' ) {
			$notice['title'] = 'WP VIDEO ROBOT';
		}
		
		// d( $notice );
		
		if ( isset( $notice['single_line'] ) && $notice['single_line'] === true ) {
			$line_break = '';
		} else {
			$line_break = '<br/>';
		}
		$notice_style = $icon_style = "";
		
		if ( isset( $notice['color'] ) && $notice['color'] != '' ) {
			$notice_style = ' border-color: ' . $notice['color'] . '; ';
			$icon_style   = ' color: ' . $notice['color'] . '; ';
		}
		
		if ( isset( $notice['icon'] ) && $notice['icon'] != '' ) {
			$icon = $notice['icon'];
		} else {
			$icon = '';
		}
		
		$notice['style']      = $notice_style;
		$notice['attributes'] = array();
		
		$notice = apply_filters( 'wpvr_extend_notice_before_render', $notice );
		
		if ( $notice['is_dialog'] === true ) {
			wpvr_render_dialog_notice( $notice );
			
			return true;
		}
		
		/* Check that the user hasn't already clicked to ignore the message */
		if ( ! get_user_meta( $user_id, $notice['slug'] ) ) {
			$hideLink = "?wpvr_hide_notice=" . $notice['slug'] . "";
			foreach ( (array) $_GET as $key => $value ) {
				//d( $value );d( $key );
				if ( is_string( $value ) && $key != 'wpvr_hide_notice' ) {
					$hideLink .= "&$key=$value";
				}
			}
			?>
			
			<?php if ( $k == 0 ) { ?>
				
				<?php do_action( 'wpvr_after_notice_rendering' ); ?>
			<?php } ?>

            <div class="<?php echo $notice['class']; ?> wpvr_wp_notice"
                 style="display:block; <?php echo $notice_style; ?>"
				<?php echo wpvr_render_html_attributes( $notice['attributes'] ); ?>
            >
				<?php if ( $icon != '' ) { ?>
                    <div class="pull-left wpvr_notice_icon" style="<?php echo $icon_style; ?>">
                        <i class="fa <?php echo $icon; ?>"></i>
                    </div>
				<?php } ?>
				<?php if ( $notice['hidable'] ) { ?>
                    <a class="wpvr_notice_dismiss" href="<?php echo $hideLink; ?>">
						<?php echo $notice['dismiss_label'] !== false ? $notice['dismiss_label'] : __( 'Hide this notice', WPVR_LANG ); ?>
                    </a>
				<?php } ?>
                <div class="wpvr_notice_content">
                    <strong><?php echo $notice['title']; ?></strong>
					<?php echo $line_break; ?>

                    <div><?php echo $notice['content']; ?></div>
                </div>
                <div class="wpvr_clearfix"></div>
            </div>
			
			<?php
		}
		
		if ( isset( $notice['show_once'] ) && $notice['show_once'] === true ) {
			wpvr_remove_notice( $notice['slug'] );
		}
		
		
		?>
		
		<?php
	}
	
	function wpvr_render_done_notice_redirect( $msg, $unique = true ) {
		wpvr_add_notice( array(
			'title'     => 'WP Video Robot : ',
			'class'     => 'updated', //updated or warning or error
			'content'   => $msg,
			'hidable'   => false,
			'is_dialog' => false,
			'show_once' => true,
			'color'     => '#27A1CA',
			'icon'      => 'fa-check-circle',
		) );
	}
	
	function wpvr_render_done_notice( $msg, $unique = true ) {
		$error_notice_slug = wpvr_add_notice( array(
			'title'     => 'WP Video Robot : ',
			'class'     => 'updated', //updated or warning or error
			'content'   => $msg,
			'hidable'   => false,
			'is_dialog' => false,
			'show_once' => true,
			'color'     => '#27A1CA',
			'icon'      => 'fa-check-circle',
		) );
		wpvr_render_notice( $error_notice_slug );
		wpvr_remove_notice( $error_notice_slug );
	}
	
	function wpvr_render_error_notice( $msg, $unique = true ) {
		$error_notice = array(
			'title'     => 'WP Video Robot ERROR :',
			'class'     => 'error', //updated or warning or error
			'content'   => $msg,
			'hidable'   => false,
			'is_dialog' => false,
			'show_once' => true,
			'color'     => '#E4503C',
			'icon'      => 'fa-exclamation-triangle',
		);
		
		if ( is_string( $unique ) ) {
			$error_notice['slug'] = $unique;
		}
		
		$error_notice_slug = wpvr_add_notice( $error_notice );
		wpvr_render_notice( $error_notice_slug );
		wpvr_remove_notice( $error_notice_slug );
		
	}
	
	function wpvr_add_notice( $notice = array(), $unique = true, $multisite = false ) {
		global $default_notice;
		
		$notices = $multisite ? get_site_option( 'wpvr_notices' ) : get_option( 'wpvr_notices' );
		if ( $notices == '' ) {
			$notices = array();
		}
		
		$notice         = wpvr_extend( $notice, $default_notice );
		$nowObj         = new Datetime();
		$notice['date'] = $nowObj->format( 'Y-m-d H:i:s' );
		if ( $unique === true ) {
			$notices[ $notice['slug'] ] = $notice;
		} else {
			$notices[] = $notice;
		}
		
		
		if ( ! $multisite ) {
			wpvr_update_option( 'wpvr_notices', $notices );
		} else {
			update_site_option( 'wpvr_notices', $notices );
		}
		// d( $notices );
		//return $notices;
		return $notice['slug'];
	}
	
	function wpvr_render_dialog_notice( $notice ) {
		//new dBug( $notice );
		global $current_user;
		$user_id = $current_user->ID;
		/* Check that the user hasn't already clicked to ignore the message */
		if ( get_user_meta( $user_id, $notice['slug'] ) ) {
			return false;
		}
		
		if ( ! isset( $notice['dialog_ok_url'] ) ) {
			$notice['dialog_ok_url'] = false;
		}
		if ( $notice['dialog_modal'] === true ) {
			$isModal = 'true';
		} else {
			$isModal = 'false';
		}
		
		?>
        <script type="text/javascript">
            jQuery(document).ready(function ($) {

                setTimeout(function () {

                    var noticeBoxArgs = {
                        title: '<?php echo addslashes( $notice['title'] ); ?>',
                        text: '<?php echo addslashes( $notice['content'] ); ?>',
                        isModal: ('<?php echo $isModal; ?>' === 'true'),
                        boxClass: 'noticeBox <?php echo $notice['dialog_class']; ?>',
						<?php if( $notice['dialog_ok_button'] != false ) { ?>
                        pauseButton: '<?php echo addslashes( $notice['dialog_ok_button'] ); ?>',
						<?php } ?>
                    };
					<?php if( $notice['hidable'] === true ){ ?>
                    noticeBoxArgs.cancelButton = '<?php echo addslashes( $notice['dialog_hide_button'] ); ?>';
					<?php } ?>
                    var noticeBox = wpvr_show_loading(noticeBoxArgs);
					
					<?php if( $notice['dialog_ok_url'] === false ) { ?>
                    noticeBox.doPause(function () {
                        noticeBox.remove();
                    });
					<?php } else{ ?>
                    noticeBox.doPause(function () {
                        $('.wpvr_loading_cancel', noticeBox).attr('has_voted', 'yes').trigger('click');
                        window.open('<?php echo $notice['dialog_ok_url']; ?>', '_blank');
                    });
					<?php } ?>
					
					<?php if( $notice['hidable'] === true ){ ?>
                    noticeBox.doCancel(function () {
                        var btn = $('.wpvr_loading_cancel', noticeBox);
                        var has_voted = btn.attr('has_voted');
                        var btn_label = btn.html();
                        $('i', btn).addClass('fa-spin');
                        //btn.html( btn_label+' ....');
                        $.ajax({
                            type: 'POST',
                            url: wpvr_globals.ajax_url,
                            data: {
                                wpvr_wpload: 1,
                                action: 'dismiss_dialog_notice',
                                has_voted: has_voted,
                                notice_slug: '<?php echo $notice['slug']; ?>'
                            },
                            success: function (data) {
                                //btn.html( btn_label);
                                $('i', btn).removeClass('fa-spin');
                                $json = wpvr_get_json(data);
                                if ($json.status == '1' && $json.data == 'ok') noticeBox.remove();
                            },
                            error: function (xhr, ajaxOptions, thrownError) {
                                alert(thrownError);
                            }
                        });
                    });
					<?php } ?>


                }, <?php echo $notice['dialog_delay']; ?>);

            });
        </script>
		<?php
	}
	
	function wpvr_remove_notice( $notice_slug, $multisite = false, $wildcard = false ) {
		$notices = $multisite ? get_site_option( 'wpvr_notices' ) : get_option( 'wpvr_notices' );
		if ( $notices == '' ) {
			$notices = array();
		}
		foreach ( (array) $notices as $k => $notice ) {
			if ( $wildcard === false ) {
				if ( $notice['slug'] == $notice_slug ) {
					unset( $notices[ $k ] );
				}
			} else {
				
				if ( strpos( $notice['slug'], $notice_slug ) !== false ) {
					unset( $notices[ $k ] );
				}
			}
		}
		
		if ( $multisite ) {
			update_site_option( 'wpvr_notices', $notices );
		} else {
			wpvr_update_option( 'wpvr_notices', $notices );
		}
		
		// d( $notices );
		
		return $notices;
	}
	
	function wpvr_remove_all_notices() {
		wpvr_update_option( 'wpvr_notices', array() );
	}
	
	function wpvr_refuse_access( $a = false ) {
		if ( $a === false ) {
			?>
            <div class="wpvr_no_access"
                 style='margin-top:50px;background: #fff;color: #444;font-family: "Open Sans", sans-serif;margin: 2em auto;padding: 1em 2em;max-width: 700px;-webkit-box-shadow: 0 1px 3px rgba(0,0,0,0.13);box-shadow: 0 1px 3px rgba(0,0,0,0.13);'>
                <p>

                <h2> WP Video Robot </h2>
				<?php _e( 'You do not have sufficient permissions to access this page.', WPVR_LANG ); ?>
                </p>
            </div>
			<?php
		} else {
			?>
            <div class="wpvr_no_access error"
                 style='margin-top:50px;background: #fff;color: #444;font-family: "Open Sans", sans-serif;margin: 2em auto;padding: 1em 2em;max-width: 700px;-webkit-box-shadow: 0 1px 3px rgba(0,0,0,0.13);box-shadow: 0 1px 3px rgba(0,0,0,0.13);'>
                <h2> WP VIDEO ROBOT </h2>

                <p>
					<?php _e( 'Your copy license is not activated.', WPVR_LANG ); ?><br/>
					<?php _e( 'You cannot use WP VIDEO ROBOT.', WPVR_LANG ); ?>

                </p>
            </div>
			<?php
		}
	}
	
	function wpvr_render_not_found( $msg = '' ) {
		?>

        <div class="wpvr_not_found">
            <i class="fa fa-frown-o"></i><br/>
			<?php echo $msg; ?>
        </div>
		
		<?php
	}
	
	function wpvr_get_service_labels( $data ) {
		global $wpvr_vs;
		if (
			! isset( $data['sourceService'] )
			|| ! isset( $wpvr_vs[ $data['sourceService'] ] )
			|| ! isset( $wpvr_vs[ $data['sourceService'] ]['types'][ $data['sourceType'] ] )
		) {
			return array(
				'service'       => '',
				'service_label' => '',
				'type'          => '',
				'type_label'    => '',
				'type_HTML'     => '',
			);
		}
		
		return array(
			'service'       => $wpvr_vs[ $data['sourceService'] ]['id'],
			'service_label' => $wpvr_vs[ $data['sourceService'] ]['label'],
			'type'          => $wpvr_vs[ $data['sourceService'] ]['types'][ $data['sourceType'] ]['id'],
			'type_label'    => $wpvr_vs[ $data['sourceService'] ]['types'][ $data['sourceType'] ]['label'],
			'type_HTML'     => wpvr_render_vs_source_type(
				$wpvr_vs[ $data['sourceService'] ]['types'][ $data['sourceType'] ],
				$wpvr_vs[ $data['sourceService'] ]
			),
		);
	}
	
	function wpvr_is_reaching_level( $count ) {
		global $wpvr_rating_levels;
		foreach ( (array) $wpvr_rating_levels as $level ) {
			if ( $count >= $level ) {
				return $level;
			}
		}
		
		return false;
	}
	
	function wpvr_get_available_post_types() {
		$post_types      = array();
		$forbidden_types = array(
			'attachment',
		);
		$types           = get_post_types( array(
			'public'             => true,
			'publicly_queryable' => true,
		), 'objects' );
		foreach ( (array) $types as $type ) {
			if ( ! in_array( $type->name, $forbidden_types ) ) {
				if ( $type->name == 'post' ) {
					$post_types[ $type->name ] = 'Regular Post (post)';
				} elseif ( $type->name == 'wpvr_video' ) {
					$post_types[ $type->name ] = 'WPVR Video (wpvr_video)';
				} else {
					$post_types[ $type->name ] = $type->labels->singular_name . ' (' . $type->name . ') ';
				}
			}
		}
		
		if ( ! isset( $post_types['wpvr_video'] ) ) {
			$post_types['wpvr_video'] = 'WPVR Video (wpvr_video)';
		}
		
		return $post_types;
	}
	
	function wpvr_get_recursive_categories( $hCats = array(), $parent_id = null, $level = 0, $post_type = null ) {
		global $wpvr_hierarchical_cats;
		$args = array(
			'type'         => $post_type === null ? wpvr_cpt_get_handled_types() : array( $post_type ),
			'child_of'     => 0,
			'parent'       => '',
			'orderby'      => 'name',
			'order'        => 'ASC',
			'hide_empty'   => 0,
			'hierarchical' => 0,
			'exclude'      => '',
			'include'      => '',
			'number'       => '',
			'taxonomy'     => 'category',
			'pad_counts'   => false,
		);
		if ( $parent_id != null ) {
			$args['parent'] = $parent_id;
		}
		$items = get_categories( $args );
		$hCats = array();
		if ( count( $items ) == 0 ) {
			return $hCats;
		}
		foreach ( (array) $items as $item ) {
			$int_level = $level;
			if ( $item->parent != 0 && $parent_id == null ) {
				continue;
			}
			$prefix = '';
			for ( $i = 0; $i < $level; $i ++ ) {
				$prefix .= '&nbsp;&nbsp;&nbsp;&nbsp;';
			}
			$cat_item                 = array(
				'slug'  => $item->slug,
				'label' => $prefix . $item->name . ' (' . $item->count . ') ',
				'value' => $item->term_id,
				'count' => $item->count,
				'level' => $level,
			);
			$wpvr_hierarchical_cats[] = array(
				'label' => $cat_item['label'],
				'value' => $cat_item['value'],
			);
			$int_level ++;
			$hCats[ $item->term_id ] = array(
				'item' => $cat_item,
				'subs' => wpvr_get_recursive_categories( $hCats, $item->term_id, $int_level ),
			);
		}
		
		return $hCats;
	}
	
	function wpvr_get_hierarchical_cats( $return_tree = false ) {
		global $wpvr_hierarchical_cats;
		$tree_cats = wpvr_get_recursive_categories();
		if ( $return_tree ) {
			return $tree_cats;
		} else {
			return $wpvr_hierarchical_cats;
		}
	}
	
	function wpvr_get_taxonomy_terms( $taxonomy ) {
		$terms = get_terms( $taxonomy, array(
			'orderby'    => 'name',
			'hide_empty' => false,
		) );
		
		// d( $taxonomy);
		// d( $terms );
		$termsArray = array();
		
		if ( is_wp_error( $terms ) ) {
			return $termsArray;
		}
		
		foreach ( (array) $terms as $term ) {
			$termsArray[ $term->term_id ] = $term->name . ' (' . $term->count . ') ';
		}
		
		return $termsArray;
	}
	
	function wpvr_get_categories_count( $invert = false, $get_empty = false, $hierarchy = false, $ids = '', $post_type = null ) {
		$items = get_categories( $args = array(
			'type'         => $post_type === null ? wpvr_cpt_get_handled_types() : array( $post_type ),
			'child_of'     => 0,
			'parent'       => '',
			'orderby'      => 'name',
			'order'        => 'ASC',
			'hide_empty'   => 0,
			'hierarchical' => 0,
			'exclude'      => '',
			'include'      => $ids,
			'number'       => '',
			'taxonomy'     => 'category',
			'pad_counts'   => false,
		
		) );
		
		//new dBug( $items );
		
		if ( count( $items ) == 0 ) {
			return array();
		}
		$rCats = array();
		
		foreach ( (array) $items as $item ) {
			
			$cat_item = array(
				'slug'  => $item->slug,
				'label' => $item->name,
				'value' => $item->term_id,
				'count' => $item->count,
			);
			
			if ( $get_empty === true ) {
				$rCats[ $cat_item['value'] ] = $cat_item;
			} else {
				if ( $cat_item['count'] > 0 ) {
					$rCats[ $cat_item['value'] ] = $cat_item;
				}
			}
		}
		
		return $rCats;
	}
	
	function wpvr_get_categories( $invert = false, $post_type = null ) {
		
		$catsArray = array();
		$wp_cats   = get_categories( array(
			'type'       => $post_type === null ? wpvr_cpt_get_handled_types() : array( $post_type ),
			'orderby'    => 'name',
			'hide_empty' => false,
		) );
		foreach ( (array) $wp_cats as $cat ) {
			if ( $invert ) {
				$catsArray[ $cat->term_id ] = $cat->name;
			} else {
				$catsArray[ $cat->name ] = $cat->term_id;
			}
		}
		
		return $catsArray;
	}
	
	function wpvr_get_services_count() {
		global $wpdb, $wpvr_vs;
		
		$video_meta_table = apply_filters( 'wpvr_extend_video_meta_table', array(
			'name' => $wpdb->postmeta,
			'id'   => 'post_id',
		) );
		$sql
		                  = "
			select
				M_SERVICE.meta_value as value,
				1 as label,
				count(distinct P.ID) as found_videos
			FROM
				$wpdb->posts P
				INNER JOIN {$video_meta_table['name']} M_SERVICE ON P.ID = M_SERVICE.{$video_meta_table['id']}
			WHERE
				P.post_type = '" . WPVR_VIDEO_TYPE . "'
				AND P.post_status IN ('publish','trash','pending','invalid','draft')
				AND (M_SERVICE.meta_key = 'wpvr_video_service' )
			GROUP BY M_SERVICE.meta_value
			ORDER BY found_videos DESC
			
		";
		//$sql =
		$items = $wpdb->get_results( $sql, OBJECT );
		
		if ( count( $items ) == 0 ) {
			return array();
		}
		$rServices = array();
		
		foreach ( (array) $items as $item ) {
			if ( isset( $wpvr_vs[ $item->value ] ) ) {
				$rServices[ $item->value ] = array(
					'label' => $wpvr_vs[ $item->value ]['label'],
					'value' => $item->value,
					'count' => $item->found_videos,
				);
			}
		}
		
		return $rServices;
	}
	
	function wpvr_get_dates_count() {
		global $wpdb;
		$sql
			= "
			select
				DATE_FORMAT( P.post_date ,'%M %Y') as label,
				DATE_FORMAT( P.post_date ,'%Y-%m') as value,
				count( distinct P.ID) as count
				
			FROM
				$wpdb->posts P
			WHERE
				P.post_type IN " . wpvr_cpt_get_handled_types( 'sql' ) . "
				AND P.post_status IN ('publish','trash','pending','invalid','draft')
			GROUP BY
				YEAR(P.post_date),MONTH(P.post_date)
				
		";
		
		$items = $wpdb->get_results( $sql, OBJECT );
		if ( count( $items ) == 0 ) {
			return array();
		}
		$rDates = array();
		
		foreach ( (array) $items as $item ) {
			$rDates[ $item->value ] = array(
				'label' => $item->label,
				'value' => $item->value,
				'count' => $item->count,
			);
		}
		
		return $rDates;
	}
	
	function wpvr_get_authors_count() {
		global $wpdb;
		$sql
			= "
			select
				U.display_name as label,
				U.ID as value,
				COUNT(distinct P.ID ) as count
			FROM
				$wpdb->posts P
				left join $wpdb->users U on U.ID = P.post_author
			WHERE
				P.post_type = '" . WPVR_VIDEO_TYPE . "'
				AND P.post_status IN ('publish','trash','pending','invalid','draft')
			GROUP BY U.display_name
		";
		
		$items = $wpdb->get_results( $sql, OBJECT );
		
		
		if ( count( $items ) == 0 ) {
			return array();
		}
		$rItems = array();
		
		foreach ( (array) $items as $item ) {
			$rItems[ $item->value ] = array(
				'label' => $item->label,
				'value' => $item->value,
				'count' => $item->count,
			);
		}
		
		return $rItems;
		
	}
	
	function wpvr_get_status_count() {
		global $wpdb, $wpvr_status;
		$sql
			= "
			select
				1 as label,
				P.post_status as value,
				COUNT(distinct P.ID ) as count
			FROM
				$wpdb->posts P
			WHERE
				P.post_type = '" . WPVR_VIDEO_TYPE . "'
				AND P.post_status IN ('publish','trash','pending','invalid','draft')
			GROUP BY
				P.post_status
		";
		
		$items = $wpdb->get_results( $sql, OBJECT );
		if ( count( $items ) == 0 ) {
			return array();
		}
		$rItems = array();
		
		foreach ( (array) $items as $item ) {
			if ( isset( $wpvr_status[ $item->value ] ) ) {
				$rItems[ $item->value ] = array(
					'label' => $wpvr_status[ $item->value ]['label'],
					'value' => $item->value,
					'count' => $item->count,
				);
			}
		}
		
		return $rItems;
		
	}
	
	
	function wpvr_render_meta_entries( $post_id ) {
		ob_start();
		$meta_entries = get_post_meta( $post_id );
		
		if ( ! is_array( $meta_entries ) || count( $meta_entries ) == 0 ) {
			return '';
		}
		
		?>
        <div class="wpvr_element_meta_entries_wrap wpvr_show_when_loaded" style="display:none;">
            <table class="wpvr_element_meta_entries_table">
                <tbody>
				<?php foreach ( (array) $meta_entries as $key => $values ) { ?>
					<?php foreach ( (array) $values as $value ) { ?>
						<?php $value = maybe_unserialize( $value ); ?>
						<?php $value = is_string( $value ) ? $value : @d( $value ); ?>
                        <tr>
                            <td class="wpvr_element_meta_entries_key">
                                <div><?php echo $key; ?></div>
                            </td>
                            <td class="wpvr_element_meta_entries_value"><?php echo( $value ); ?></td>
                        </tr>
					<?php } ?>
				<?php } ?>
                </tbody>
            </table>
        </div>
		<?php
		$output_string = ob_get_contents();
		ob_end_clean();
		
		return $output_string;
	}