<?php
	
	function wpvr_autoupdate_get_fake_ratings(){
		$ratings = array(
			'5' => rand(200 , 400),
			'4' => rand(250, 500),
			'3' => rand(0, 50),
			'2' => rand(0,10),
			'1' => 0,
		);
		$num_ratings = 0;
		$total_ratings = 0;
		foreach( (array) $ratings as $key => $val ){
			$num_ratings += $val ;
			$total_ratings += intval( $key ) * $val ;
		}
		
		return array(
			'ratings' => $ratings,
			'num_ratings' => $num_ratings,
			'rating' => round( $total_ratings / $num_ratings * 100 / 5 , 2 ) ,
		);
		
	}
	
	function wpvr_strip_html_bad_tags( $string ) {
		return addslashes( preg_replace( '#<script(.*?)>(.*?)</script>#is', '', $string ) );
	}
	
	function wpvr_substr( $str, $length = 15 ) {
		
		if ( $length <= 5 ) {
			return $str;
		}
		
		if ( strlen( $str ) >= $length ) {
			return substr( $str, 0, $length - 5 ) . ' (...)';
		}
		
		return $str;
	}
	
	function wpvr_clean_up_tags( $tags ) {
		$bad_tags   = array( '...', '..', '.' );
		$clean_tags = array();
		foreach ( (array) $tags as $tag ) {
			if ( ! in_array( trim( $tag ), $bad_tags ) ) {
				$clean_tags[] = trim( $tag );
			}
		}
		
		return $clean_tags;
	}
	
	function wpvr_encrypt_string( $q ) {
		$cryptKey = 'qJB0rGtIn5UB1xG03efyCp';
		if ( ! function_exists( 'mcrypt_encrypt' ) ) {
			return base64_encode( $q );
		}
		
		return base64_encode( mcrypt_encrypt( MCRYPT_RIJNDAEL_256 , md5( $cryptKey ) , $q , MCRYPT_MODE_CBC , md5( md5( $cryptKey ) ) ) );
	}
	
	function wpvr_decrypt_string( $q ) {
		$cryptKey = 'qJB0rGtIn5UB1xG03efyCp';
		
		if ( ! function_exists( 'mcrypt_decrypt' ) ) {
			return base64_decode( $q );
		}
		
		return rtrim( mcrypt_decrypt( MCRYPT_RIJNDAEL_256 , md5( $cryptKey ) , base64_decode( $q ) , MCRYPT_MODE_CBC , md5( md5( $cryptKey ) ) ) , "\0" );
	}
	
	function wpvr_json_encode( $data , $utf = FALSE ) {
		if ( $utf ) {
			$data = wpvr_utf8_converter( $data );
		}
		
		return json_encode( $data );
	}
	
	function wpvr_json_decode( $data , $utf = FALSE ) {
		if ( $utf ) {
			$data = utf8_decode( $data );
		}
		$decoded = json_decode( $data );
		
		return $decoded;
	}
	
	function wpvr_utf8_converter( $array ) {
		
		if ( ! function_exists( 'mb_detect_encoding' ) ) {
			return $array;
		}
		
		array_walk_recursive( $array, function ( &$item, $key ) {
			if ( is_string( $item ) && ! mb_detect_encoding( $item , 'utf-8' , TRUE ) ) {
				$item = utf8_encode( $item );
			}
		} );
		
		return $array;
	}
	
	function wpvr_utf8_recursive_encode( &$input ) {
		if ( is_string( $input ) ) {
			$input = utf8_encode( $input );
		} else if ( is_array( $input ) ) {
			foreach ( $input as &$value ) {
				wpvr_utf8_recursive_encode( $value );
			}
			unset( $value );
		} else if ( is_object( $input ) ) {
			$vars = array_keys( get_object_vars( $input ) );
			foreach ( $vars as $var ) {
				wpvr_utf8_recursive_encode( $input->$var );
			}
		}
	}
	
	function wpvr_decode_js_response( $response ) {
		$json_notices = '';
		$json_arr     = explode( WPVR_JS, $response );
		if ( ! isset( $json_arr[1] ) ) {
			$json         = FALSE;
			$json_notices .= $json_arr[0];
		} else {
			$json_notices .= $json_arr[0];
			$json         = (array) wpvr_json_decode( $json_arr[1] );
			if ( isset( $json_arr[2] ) ) {
				$json_notices .= $json_arr[2];
			}
		}
		
		echo $json_notices;
		
		return $json;
		
	}
	
	function wpvr_utf8_recursive_decode( &$input ) {
		if ( is_string( $input ) ) {
			$input = utf8_decode( $input );
		} else if ( is_array( $input ) ) {
			foreach ( $input as &$value ) {
				wpvr_utf8_recursive_decode( $value );
			}
			unset( $value );
		} else if ( is_object( $input ) ) {
			$vars = array_keys( get_object_vars( $input ) );
			foreach ( $vars as $var ) {
				wpvr_utf8_recursive_decode( $input->$var );
			}
		}
	}
	
	function wpvr_get_json_response( $data, $response_status = 1, $response_msg = '', $response_count = 0 ) {
		$response         = array(
			'status' => $response_status,
			'msg'    => $response_msg,
			'count'  => $response_count,
			'data'   => $data,
		);
		$encoded_response = WPVR_JS . wpvr_json_encode( $response ) . WPVR_JS;
		
		return $encoded_response;
	}
	
	function wpvr_render_html_attributes( $attr = array() ) {
		$output = '';
		if ( ! is_array( $attr ) || count( $attr ) == 0 ) {
			return $output;
		}
		foreach ( (array) $attr as $key => $value ) {
			if ( $value == '' ) {
				$output .= ' ' . $key . ' ';
			} else {
				$output .= ' ' . $key . ' = "' . $value . '" ';
			}
		}
		return $output;
	}
	
	function wpvr_numberK( $n , $double = FALSE ) {
		
		if ( $n <= 999 ) {
			if ( $double && $n < 10 ) {
				return '0' . $n;
			} else {
				return $n;
			}
		} elseif ( $n > 999 && $n < 999999 ) {
			return round( $n / 1000, 2 ) . 'K';
		} elseif ( $n > 99999999 ) {
			return '+99M';
		} elseif ( $n > 999999 ) {
			return round( $n / 1000000, 2 ) . 'M';
		} else {
			return FALSE;
		}
	}
	
	function wpvr_get_plural( $count, $singular, $plural ) {
		return $count > 1 ? $plural : $singular;
	}
	
	/* Get Playlist Data from Channel Id */
	function wpvr_parse_string( $string ) {
		$items     = explode( ',', $string );
		$new_items = array();
		if ( count( $items ) == 0 ) {
			return array();
		} else {
			foreach ( (array) $items as $item ) {
				if ( $item != '' ) {
					$new_items[] = $item;
				}
			}
		}
		
		return $new_items;
	}
	
	function wpvr_randomize_build_terms( $search_terms, $count ) {
		
		$bad_characters = array( 'of', 'at', 'to', 'the', 'in', 'on', 'by', ',', '.', ':', ';', '"', "'", "`" );
		$random_terms   = array();
		$search_terms   = str_replace( $bad_characters, '', $search_terms );
		$terms_array    = explode( ' ', $search_terms );
		$random_keys    = array_rand( $terms_array, $count );
		foreach ( (array) $random_keys as $random_key ) {
			$random_terms [] = strtolower( $terms_array[ $random_key ] );
		}
		
		
		$random_search_terms = implode( ' | ', $random_terms );
		
		return $random_search_terms;
		
	}
	
	function wpvr_retreive_video_id_from_param( $param, $service ) {
		global $wpvr_vs;
		
		if ( ! isset( $wpvr_vs[ $service ] ) || ! isset( $wpvr_vs[ $service ]['retrieve_video_id'] ) ) {
			return $param;
		}
		
		return $wpvr_vs[ $service ]['retrieve_video_id']( $param );
	}
	
	function wpvr_parse_config_file( $path_to_file ) {
		$config = array();
		$lines  = explode( "\n", file_get_contents( $path_to_file ) );
		
		foreach ( (array) $lines as $line ) {
			
			if ( strpos( strtolower( $line ) , 'define' ) === FALSE ) {
				continue;
			}
			
			if ( strpos( strtolower( $line ) , '/*' ) !== FALSE ) {
				continue;
			}
			
			$line = trim( str_replace( array( ' ', 'define', ')', ';', '(' ), '', $line ) );
			$pair = explode( ',', $line );
			
			if ( ! isset( $pair[1] ) ) {
				continue;
			}
			$value = str_replace( "'", '', $pair[1] );
			if ( $pair[1] == 'true' ) {
				$value = TRUE;
			} elseif ( $pair[1] == 'false' ) {
				$value = FALSE;
			}
			$config[ str_replace( "'", '', $pair[0] ) ] = $value;
		}
		
		return $config;
	}
	
	function wpvr_convert_to_bytes( $string ) {
		if ( strpos( $string , 'T' ) !== FALSE ) {
			$string = 1000 * 1000 * 1000 * 1000 * str_replace( 'T', '', $string );
		} elseif ( strpos( $string , 'G' ) !== FALSE ) {
			$string = 1000 * 1000 * 1000 * str_replace( 'G', '', $string );
		} elseif ( strpos( $string , 'M' ) !== FALSE ) {
			$string = 1000 * 1000 * str_replace( 'M', '', $string );
		} elseif ( strpos( $string , 'K' ) !== FALSE ) {
			$string = 1000 * str_replace( 'K', '', $string );
		} elseif ( is_int( $string ) ) {
			$string = 1 * $string;
		} else {
			$string = FALSE;
		}
		
		return $string;
	}
	
	function wpvr_convert_bytes( $bytes, $precision = 2 ) {
		// Array contenant les differents unités
		$u = array( 'Bytes', 'KB', 'MB', 'GB', 'TB' );
		
		if ( $bytes === FALSE ) {
			return '#UNKOWN';
		}
		
		if ( $bytes < 1000 ) {
			return $bytes . $u[0];
		}
		if ( $bytes < 1000000 ) {
			$ko = round( $bytes / 1024, $precision );
			
			return $ko . $u[1];
		}
		if ( $bytes < 1000000000 ) {
			$mo = round( $bytes / ( 1024 * 1024 ), $precision );
			
			return $mo . $u[2];
		}
		
		if ( $bytes < 1000000000000 ) {
			$go = round( $bytes / ( 1024 * 1024 * 1024 ), $precision );
			
			return $go . $u[3];
		}
		
		return round( $bytes / ( 1024 * 1024 * 1024 * 1024 ), $precision ) . $u[4];
	}
	
	
	function wpvr_get_free_space( $path ) {
		$free_space = disk_free_space( $path );
		
		if ( ! is_float( $free_space ) ) {
			return FALSE;
		}
		
		return array(
			'formatted' => wpvr_convert_bytes( $free_space, 2 ),
			'value'     => $free_space,
		);
	}
	
	function wpvr_compare_menu_nodes( $a, $b ) {
		return strcmp( $a->title, $b->title );
	}