jQuery(function ($) {

    //Toggle Shown/Hide when page is loaded
    $('.wpvr_wrap_loading').hide();
    $('.wpvr_wrap').fadeIn();
    $('.wpvr_super_wrap').css('visibility', 'visible').hide().fadeIn();
    $('.wpvr_show_when_loaded').fadeIn().css('opacity', 1).css('visibility', 'visible');
    $('.wpvr_show_inline_when_loaded').fadeIn().css('opacity', 1).css('visibility', 'visible').css('display','inline-block');
    $('.wpvr_hide_when_loaded').hide();


    //Shopw up WPVR Notices
    var nCount = 0;
    var nStart = 100;
    var nStep = 400;
    $('.wpvr_wp_notice').each(function () {
        if ($(this).hasClass('disable_autoshow')) {
            return;
        }
        nCount++;
        var nDelay = nStart + (nStep * nCount);
        //console.log(nDelay);
        var notice = $(this);
        setTimeout(function () {
            notice.fadeIn();
        }, nDelay);
    });

    // Init LazyLoad on images
    function wpvr_init_lazy_load(context) {
        $('.wpvr_lazy_loaded', context).lazy({
            effect: "fadeIn",
            effectTime: 500,
            threshold: 0,
        });
    }

    wpvr_init_lazy_load($('body'));

    // Throw Message when JS error on the page ( Bad Crash )
    window.onerror = function () {
        $('.wpvr_wp_notice.wpvr_js_conflict_error').fadeIn();
    }


    //Throw Message when JS error on Scripts ( Soft Crash )
    if (typeof window.wpvr_script_loaded === 'undefined' || window.wpvr_script_loaded !== true) {
        $('.wpvr_wp_notice.wpvr_js_conflict_error').fadeIn();
    }


});