jQuery(document).ready(function ($) {
    $.getScript(wpvr_globals.functions_js).done(function () {


        function wpvr_init_source_unwanted_videos_grid(context) {
            $('.wpvr_source_unwanted', context).each(function () {
                var wrap = $(this);

                $('.wpvr_source_unwanted_remove', wrap).click(function (e) {
                    var btn = $(this);

                    var count = parseInt(btn.attr('initial_count'));

                    e.preventDefault();
                    // $('.wpvr_video', wrap ).trigger('click');

                    var videos = [];
                    $('.wpvr_video_cb', wrap).each(function () {
                        var input = $(this);
                        if (input.prop('checked')) videos.push(input.attr('name'));
                    });
                    if (videos.length == 0) {
                        btn.shake();
                        return false;
                    }

                    wpvr_confirm(
                        wpvr_localize.delete_selected_source_unwanted,
                        function () {

                            wpvr_btn_loading(btn, true);

                            $.ajax({
                                type: 'POST',
                                url: wpvr_globals.ajax_url,
                                data: {
                                    action: 'wpvr_remove_source_unwanted_videos',
                                    source_id: btn.attr('source_id'),
                                    video_ids: videos,
                                },
                                success: function (data) {
                                    var $json = wpvr_get_json(data);
                                    wpvr_btn_loading(btn, false);


                                    $.each(videos, function (index, video_id) {
                                        $('#video_' + video_id, wrap).fadeOut().remove();
                                    });

                                    var new_count = count - videos.length;

                                    btn.attr('initial_count', new_count);
                                    $('.source_unwanted_videos_count').html(new_count);
                                    $('.wpvr_count_checked', btn).html(' ');


                                    // console.log($json);
                                    var box2 = wpvr_show_loading({
                                        title: wpvr_localize.work_completed + '...',
                                        text: $json.data,
                                        pauseButton: wpvr_localize.ok_button,
                                    });

                                    box2.doPause(function () {
                                        box2.doClose();
                                    });


                                },
                                error: function (xhr, ajaxOptions, thrownError) {
                                    console.log('' + thrownError);
                                }
                            });

                        }, wpvr_localize.continue_only,
                        function () {

                        }, wpvr_localize.cancel
                    );

                });

            });
        }

        wpvr_init_source_unwanted_videos_grid($('body'));


        $(function () {
            $('.wpvr_lazy_loaded_element').lazy({
                //Lazy inits the popover
                wpvrLoadPopOver: function (element) {
                    wpvr_init_video_popover(element);
                },
            });
        });

        function wpvr_correct_scrolling() {
            var y = $(window).scrollTop();  //your current y position on the page
            $(window).scrollTop(y + 1).scrollTop(y - 1);
            return true;
        }

        //Service Demo Source Button
        $('.wpvr_import_demo_sources_service').click(function (e) {
            e.preventDefault();
            var btn = $(this);
            var service = btn.data('service');
            wpvr_btn_loading(btn, true);

            var boxWait = wpvr_show_loading({
                title: wpvr_localize.work_in_progress + '...',
                text: wpvr_localize.please_wait_animated,
                isModal: true,
            });

            $.ajax({
                type: 'POST',
                url: wpvr_globals.ajax_url,
                data: {
                    action: 'import_demo_sources',
                    services: [service],
                },
                success: function (data) {
                    var $json = wpvr_get_json(data);
                    wpvr_btn_loading(btn, false);
                    boxWait.doClose();
                    var box2 = wpvr_show_loading({
                        title: wpvr_localize.work_completed + '...',
                        text: $json.msg,
                        pauseButton: wpvr_localize.ok_button,
                    });

                    box2.doPause(function () {
                        box2.doClose();
                    });


                },
                error: function (xhr, ajaxOptions, thrownError) {
                    console.log('' + thrownError);
                }
            });


        });

        //All Services Demo Source Buttons
        $('.wpvr_import_demo_sources').click(function (e) {
            e.preventDefault();
            var btn = $(this);
            var service = btn.data('service');
            wpvr_btn_loading(btn, true);
            $.ajax({
                type: 'POST',
                url: wpvr_globals.ajax_url,
                data: {
                    action: 'get_demo_sources_form',
                    service: service,
                },
                success: function (data) {
                    var $json = wpvr_get_json(data);
                    wpvr_btn_loading(btn, false);
                    var box = wpvr_show_loading_new({
                        title: wpvr_localize.import_demo_sources,
                        text: $json.data,
                        width: '50%',
                        cancelButton: wpvr_localize.close_button,
                        pauseButton: wpvr_localize.continue_only,
                    });


                    $('.wpvr_wizzard_service', box).click(function () {
                        if ($(this).hasClass('active')) {
                            $(this).removeClass('active');
                            $('.wpvr_wizzard_service_check', $(this)).prop('checked', false);
                        } else {
                            $(this).addClass('active');
                            $('.wpvr_wizzard_service_check', $(this)).prop('checked', true);
                        }
                    });

                    box.doCancel(function () {
                        box.doClose();
                    });

                    box.doPause(function () {
                        var selected_services = [];
                        $('.wpvr_wizzard_service_check:checked', box).each(function () {
                            selected_services.push($(this).attr('value'));
                        });
                        box.doClose();
                        var boxWait = wpvr_show_loading({
                            title: wpvr_localize.work_in_progress + '...',
                            text: wpvr_localize.please_wait_animated,
                            isModal: true,
                        });


                        $.ajax({
                            type: 'POST',
                            url: wpvr_globals.ajax_url,
                            data: {
                                action: 'import_demo_sources',
                                services: selected_services,
                            },
                            success: function (data) {
                                var $json = wpvr_get_json(data);
                                wpvr_btn_loading(btn, false);
                                boxWait.doClose();
                                var box2 = wpvr_show_loading({
                                    title: wpvr_localize.work_completed + '...',
                                    text: $json.msg,
                                    pauseButton: wpvr_localize.ok_button,
                                });

                                box2.doPause(function () {
                                    box2.doClose();
                                });


                            },
                            error: function (xhr, ajaxOptions, thrownError) {
                                console.log('' + thrownError);
                            }
                        });
                    });
                    return false;


                },
                error: function (xhr, ajaxOptions, thrownError) {
                    console.log('' + thrownError);
                }
            });


        });

        /* Update Filler */
        function wpvr_filler_update() {
            $.ajax({
                type: 'POST',
                url: wpvr_globals.ajax_url,
                data: {
                    action: 'show_fillers',
                },
                success: function (data) {
                    var $data = wpvr_get_json(data);
                    $('#wpvr_filler_list').html($data.data);
                    wpvr_bulk_process_init('#wpvr_filler_list');
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    console.log('' + thrownError);
                }
            });
        }

        //Execute dataFillers Counter Rendering
        window['wpvr_render_dataFiller_execution_counters'] = function (args) {
            var unchanged_fields = args.count.delete;
            var created_fields = parseInt(args.count.insert) - parseInt(args.count.delete);
            var exec = '<br/>Executed in <strong>' + args.total_exec_time.toFixed(2) + '</strong> seconds.';
            return '<br/> <strong>' + unchanged_fields + '</strong> unchanged and <strong>' + created_fields + '</strong> created custom fields created.' + exec;
        };

        function wpvr_bulk_process_single(k, items, box, args) {

            if (box.attr('work') !== '1') {
                return false;
            }

            if (k >= items.length) {
                //Processing Finished
                box.stopHighlight();
                box.doClose();


                var finish_message = args.finish_message.replace('%s', '<strong>' + args.processed + '</strong>');
                if (typeof window[args.counter_callback] !== 'undefined') {
                    finish_message += window[args.counter_callback](args);
                }

                var box2 = wpvr_show_loading({
                    // title: wpvr_localize.work_completed,
                    title: args.finish_title,
                    text: finish_message,
                    pauseButton: wpvr_localize.ok_button,
                });

                $('.wpvr_loading_mask').click(function () {
                    if (args.refresh_onfinish === 'true') {
                        window.location.reload();
                    }
                });

                box2.doPause(function () {
                    if (args.refresh_onfinish === 'true') {
                        window.location.reload();
                    }
                    box2.doClose();
                });
                return false;
            }

            var dataPost = {
                args: args,
                action: args.single_action,
                items: items[k],
            };

            $.ajax({
                type: 'POST',
                url: wpvr_globals.ajax_url,
                data: dataPost,
                success: function (response) {
                    var $json = wpvr_get_json(response);

                    if ($json.status == 0) {
                        wpvr_alert('Something went wrong on single processing. Check the Console Log.');
                        return false;
                    }
                    var new_args = $json.data.args;
                    new_args.processed = parseInt(new_args.processed);
                    // + parseInt(new_args.count.total)
                    var percent = 100;
                    if (new_args.total !== 0) {
                        percent = parseFloat(100 * new_args.processed / new_args.total).toFixed(2);
                    }

                    var progress_text;
                    if (new_args.percentage === "true") {
                        progress_text = percent + '%';
                    } else {
                        progress_text = new_args.processed + ' / ' + new_args.total;
                    }

                    box.doProgress({
                        pct: percent,
                        text: progress_text,
                    });
                    k++;

                    wpvr_bulk_process_single(k, items, box, new_args);

                },
                error: function (xhr, ajaxOptions, thrownError) {
                    console.log('AjaxError: ' + thrownError);
                }
            });
        }

        function wpvr_bulk_process_init(selector) {
            var wrap = $(selector);
            $('.wpvr_bulk_process_btn', wrap).each(function () {
                var btn = $(this);
                var args = {
                    work: true,
                    count: {},
                    total: 0,
                    processed: 0,
                    total_exec_time: 0,
                    exec_time: 0,
                    refresh_onfinish: btn.data('refresh_onfinish'),
                    items: '',
                    init_action: btn.data('init_action'),
                    single_action: btn.data('single_action'),
                    single_args: btn.data('single_args'),
                    buffer: btn.data('buffer'),
                    confirm_message: btn.data('confirm_message'),
                    finish_message: btn.data('finish_message'),
                    finish_title: btn.data('finish_title'),
                    confirm_title: btn.data('confirm_title'),
                    counter_callback: btn.data('counter_callback'),
                };

                if (btn.data('progress_message') === 'percentage') {
                    args.percentage = true;
                } else {
                    args.percentage = false;
                }

                btn.click(function (e) {
                    e.preventDefault();

                    var boxWait = wpvr_show_loading({
                        // title: wpvr_localize.update_existing_videos,
                        title: args.confirm_title,
                        text: args.confirm_message,
                        cancelButton: wpvr_localize.cancel_button,
                        pauseButton: wpvr_localize.continue_only,
                    });

                    boxWait.doRemove(function () {
                        $('#doaction').removeClass('isClicked');
                        $('#doaction2').removeClass('isClicked');
                    });
                    boxWait.doCancel(function () {
                        boxWait.doClose();
                        $('#doaction').removeClass('isClicked');
                        $('#doaction2').removeClass('isClicked');
                    });

                    var dataInitPost = {
                        action: args.init_action,
                        buffer: args.buffer,
                    };

                    if (btn.data('items') !== '') {
                        dataInitPost.items = btn.data('items');
                    }

                    boxWait.doPause(function () {
                        $('.wpvr_loading_msg_text', boxWait).html(wpvr_localize.loading);
                        $('.wpvr_loading_cancel', boxWait).hide();
                        $('.wpvr_loading_pause', boxWait).hide();

                        $.ajax({
                            type: 'POST',
                            url: wpvr_globals.ajax_url,
                            data: dataInitPost,
                            success: function (data) {
                                var $json = wpvr_get_json(data);
                                var balanced_items = $json.data.items;
                                args.total = $json.data.total;
                                args.count.total = $json.data.total;
                                args.total_exec_time = parseFloat(args.total_exec_time) + parseFloat($json.data.exec_time);
                                boxWait.doClose();

                                var box = wpvr_show_loading({
                                    title: wpvr_localize.work_in_progress + '...',
                                    text: '<br/><div class="wpvr_current_title"></div>',
                                    progressBar: true,
                                    cancelButton: wpvr_localize.cancel_button,
                                    isModal: true,
                                });

                                box.doProgress({pct: '0.5', text: wpvr_localize.loading_raw + ''});
                                box.doHighlight();
                                box.attr('work', 1);

                                box.doCancel(function () {
                                    box.doHide();
                                    wpvr_confirm(
                                        wpvr_localize.really_want_cancel,
                                        function () {
                                            //Cancelled STOP action
                                            box.doShow();
                                        },
                                        wpvr_localize.continue_button,

                                        function () {
                                            //Confirmed STOP Action
                                            box.attr('work', 0);
                                        },
                                        wpvr_localize.cancel_anyway
                                    );
                                });

                                wpvr_bulk_process_single(0, balanced_items, box, args);

                            },
                            error: function (xhr, ajaxOptions, thrownError) {
                                console.log('AjaxError: ' + thrownError);
                            }
                        });

                    });

                });
            });
        }

        wpvr_bulk_process_init('body');

        // Flush Video Tables

        $('.wpvr_flush_button').click(function (e) {
            e.preventDefault();
            var btn = $(this);
            if (btn.hasClass('wpvr_isLoading')) return false;

            wpvr_btn_loading(btn, true);
            $.ajax({
                type: 'POST',
                url: wpvr_globals.ajax_url,
                data: {
                    action: 'reset_video_tables',
                    post_type: btn.attr('post_type'),
                    post_type_label: btn.attr('post_type_label'),
                },
                success: function (response) {
                    var $json = wpvr_get_json(response);
                    wpvr_btn_loading(btn, false);

                    var box = wpvr_show_loading({
                        title: wpvr_localize.wp_video_robot,
                        text: $json.data,
                        pauseButton: wpvr_localize.ok_button,
                    });
                    box.doPause(function () {
                        box.remove();
                    });
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    alert(thrownError);
                }
            });
        });

        function wpvr_init_video_popover_on_zone(zone) {
            $('.wpvr_video', zone).each(function () {
                wpvr_init_video_popover($(this));
            });
        }

        function wpvr_init_video_popover(wrap) {

            wrap.webuiPopover('destroy');
            if (!wrap.hasClass('wpvr_has_video_info')) {
                return false;
            }
            var video_info_id = wrap.attr('id').replace('video', 'video_info');
            var video_info = $('#' + video_info_id).html();

            if ($.trim(video_info).length === 0) {
                return false;
            }

            if (wrap.hasClass('added')) {
                return false;
            }

            wrap.webuiPopover({
                content: video_info,
                trigger: 'hover',
                closeable: true,
                delay: {//show and hide delay time of the popover, works only when trigger is 'hover',the value can be number or object
                    show: 0,
                    hide: 0
                },
                placement: 'horizontal',
                animation: 'fade',
                width: 430,
                onShow: function ($el) {
                    wrap.addClass('hovered');
                },
                onHide: function ($el) {
                    wrap.removeClass('hovered');
                },
            });
        }

        $('.wpvr_has_video_info:not(.wpvr_lazy_loaded_element)').each(function () {
            var wrap = $(this);
            wpvr_init_video_popover(wrap);
        });


        //Sync Switch Buttons with hidden Selects
        $('.wpvr_cmb_is_switch').each(function () {
            var wrap = $(this);
            var sync = wrap.attr('sync');
            wrap.delegate('.wpvr_backend_switch_button', 'lcs-statuschange', function () {
                if (typeof sync !== 'undefined') {
                    if ($(this).is(':checked')) {
                        $('#' + sync).val('on').trigger('change');
                    } else {
                        $('#' + sync).val('off').trigger('change');
                    }
                }
            });
        });

        // Define Master/Slave interactions
        function wpvr_cmb_targets_listeners(targets, value, global_triggers, master) {
            $.each(targets, function (index, target_id) {

                var target = $('.cmb_id_' + target_id);
                var triggers_str = target.attr('triggers');
                var state;

                if (typeof triggers_str === 'undefined') {
                    state = $.inArray(value, global_triggers);
                } else {
                    var triggers = triggers_str.split(',');
                    state = $.inArray(value, triggers);
                }
                if (state !== -1) {
                    target.fadeIn();
                    wpvr_cmb_init_master(target, state);
                } else {
                    target.hide();
                }
            });
        }

        //Init Master Slave Interactions
        function wpvr_cmb_init_master(wrap, force_state) {

            if (wrap.hasClass('wpvr_cmb_is_switch')) {
                return false;
            }

            var targets_str = wrap.attr('targets');
            var global_triggers = wrap.attr('targets_trigger');
            var targets_input = wrap.attr('targets_input');

            if (typeof  targets_str === 'undefined') {
                return;
            }

            if (typeof  global_triggers === 'undefined') {
                global_triggers = ['on'];
            }
            if (typeof  targets_input === 'undefined') {
                targets_input = 'select.cmb_select';
            }
            var targets = targets_str.split(',');
            $(targets_input, wrap).change(function () {
                wpvr_cmb_targets_listeners(targets, $(this).val(), global_triggers, wrap);
            }).trigger('change');
        }

        $('.wpvr_cmb_is_master').each(function () {
            var wrap = $(this);
            wpvr_cmb_init_master(wrap);
        });


        $('.wp-list-table .check-column').each(function () {
            var wrap = $(this);
            var cb = $('input[type=checkbox]', wrap);

            cb.change(function () {
                if (cb.prop('checked')) {
                    wrap.addClass('wpvr_checked');
                } else {
                    wrap.removeClass('wpvr_checked');
                }
            });
        });


        $('.wpvr_navtabs_carousel').each(function () {
            var wrap = $(this);
            setTimeout(function () {
                var max_width = parseInt(wrap.width());
                var total_width = 0;

                $('.wpvr_navtabs_tab', wrap).each(function () {
                    total_width = 2 + parseInt(total_width) + parseInt($(this).outerWidth());
                });

                if (total_width <= max_width) {
                    wrap.on('init', function (event, slick) {
                        slick.$nextArrow.hide();
                    });
                }

                if (total_width > max_width) {
                    wrap.slick({
                        arrows: true,
                        appendArrows: '.wpvr_navtabs_nav',
                        slidesToScroll: 4,
                        variableWidth: true,
                        draggable: true,
                        infinite: false,
                        adaptiveHeight: false,
                        easing: 'swing',
                        speed: 500,
                        cssEase: 'ease',
                    });
                }

            }, 200);


        });

        function wpvr_fix_fitlers_wrap_height() {
            var default_margin_bottom = 4;
            if ($('.wpvr_filters_wrap').length === 0) {
                return;
            }
            var filters_height = $('.wpvr_filters_wrap').height();

            $('.tablenav').each(function () {
                if ($(this).hasClass('on')) {
                    $(this).css('margin-bottom', filters_height + 20);
                } else {
                    $(this).css('margin-bottom', default_margin_bottom);
                }
            });

        }

        setInterval(function () {
            wpvr_fix_fitlers_wrap_height();
        }, 100);

        $('body').on('click', '.wpvr_log_details_btn', function (e) {
            e.preventDefault();
            var btn = $(this);
            $('.wpvr_logs_row#' + btn.data('token')).removeClass('closed').addClass('open');
            btn.hide().remove();
        });

        $('.wpvr_view_source_metrics').click(function (e) {
            e.preventDefault();

            var target = $('#wpvr_source_chart_metabox').offset().top - 100;
            $('html, body').animate({scrollTop: target}, 'slow');


        });
        $('body').on('click', '.wpvr_source_metrics_btn', function (e) {

            e.preventDefault();

            var btn = $(this);
            var spinner = wpvr_add_loading_spinner(btn, 'pull-right');

            $.ajax({
                type: 'POST',
                url: wpvr_globals.ajax_url,
                data: {
                    action: 'load_source_metrics',
                    source_id: btn.data('source'),
                },
                success: function (response) {
                    var $json = wpvr_get_json(response);
                    var box2 = wpvr_show_loading_new({
                        title: wpvr_localize.source_metrics + ': ' + $json.data.name,
                        text: $json.data.charts,
                        width: '70%',
                        pauseButton: wpvr_localize.close_button
                    });

                    wpvr_remove_loading_spinner(spinner);
                    $('.wpvr_show_when_loaded', box2).fadeIn();
                    $('.wpvr_chart_tab.active', box2).trigger('click');
                    $(window).scrollTop($(window).scrollTop() + 1);


                    box2.doPause(function () {
                        box2.doClose();
                    });
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    alert(thrownError);
                }
            });

        });

        $('body').on('click', '.wpvr_chart_tab', function (e) {
            e.preventDefault();
            if ($(this).data('target') == '0') {
                window.open($(this).attr('href'));
                return true;
            }

            $('.wpvr_chart_tab').removeClass('active');
            $(this).addClass('active');

            $('.wpvr_chart_content').hide();
            $('#' + $(this).data('target')).css('visibility', 'visible').fadeIn();
        });

        $('.wpvr_chart_tab.active').trigger('click');


        $('.wpvr_reset_source_stats').click(function (e) {
            e.preventDefault();
            var btn = $(this);

            var spinner = wpvr_add_loading_spinner(btn, 'pull-right');


            $.ajax({
                type: 'POST',
                url: wpvr_globals.ajax_url,
                data: {
                    action: 'reset_source_stats',
                    source_id: btn.attr('source_id'),
                },
                success: function (response) {
                    var $json = wpvr_get_json(response);
                    var box2 = wpvr_show_loading_new({
                        title: wpvr_localize.wp_video_robot,
                        text: $json.data.msg,
                    });
                    wpvr_remove_loading_spinner(spinner);
                    setTimeout(function () {
                        location.reload();
                    }, 1500);

                },
                error: function (xhr, ajaxOptions, thrownError) {
                    alert(thrownError);
                }
            });
        });


        $('.wpvr_date_field').each(function () {
            $(this).wpvrdatepicker({
                format: 'yyyy-mm-dd',
                language: wpvr_globals.locale,
                autoHide: true,
            });
        });

        $('.cmb_datepicker').each(function () {
            $(this).wpvrdatepicker({
                format: 'mm/dd/yyyy',
                language: wpvr_globals.locale,
                autoHide: true,
            });
        });

        $('.wpvr_tipso').each(function () {
            if (!$(this).hasClass('definedContent')) {
                $(this).tipso({
                    background: 'rgba(0,0,0,0.8)',
                    color: '#FFF',
                    useTitle: true,
                    width: 'auto',
                    maxWidth: 200,
                });
            } else {
                $(this).tipso({
                    background: 'rgba(0,0,0,0.8)',
                    color: '#FFF',
                    content: $('.wpvr_tipso_content', $(this)).html(),
                    width: 'auto',
                    maxWidth: 200,
                });
            }
        });

        function wpvr_js_generate_token() {
            var text = "";
            var possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
            for (var i = 0; i < 10; i++)
                text += possible.charAt(Math.floor(Math.random() * possible.length));
            return text;
        }

        function wpvr_init_dropdown(wrap) {

            var maxItems = wrap.attr('maxItems');
            var selectized = $('.wpvr_dropdown_select', wrap);
            var handler = $('.wpvr_dropdown_input', wrap);
            var $string = handler.val();
            var selected_items;
            var token;
            if (typeof wrap.attr('token') === 'undefined') {
                token = wpvr_js_generate_token();
            } else {
                token = wrap.attr('token');
            }

            if (typeof $string !== 'undefined' && $string != '') selected_items = JSON.parse($string);
            else selected_items = false;

            var selectize_args = {
                maxItems: null,
                selectOnTab: true,
                closeAfterSelect: false,

                delimiter: ',',
            };

            if (maxItems !== null) {
                selectize_args.maxItems = maxItems;
            }

            if (selected_items !== false && selected_items != []) {
                selectize_args.items = selected_items;
            }

            var $selectized = selectized.selectize(selectize_args);


            function selectize_handler(obj) {

                var selectedItems = [];
                $('option', obj.currentTarget).each(function () {
                    selectedItems.push($(this).attr('value'));
                });
                var str = JSON.stringify(selectedItems, null, 2);
                var cs_string = selectedItems.join(',');
                handler.attr('value', str);
            }

            $selectized.on('change', selectize_handler);
            $selectized.on('initialize', selectize_handler);

            if (typeof wpvr_dropdown_fields === 'undefined') {
                wpvr_dropdown_fields = [];
            }

            wpvr_dropdown_fields[token] = $selectized;
            wrap.attr('token', token);
            wrap.data('selectize', $selectized);
            wrap.data('selectize_args', selectize_args);

        }

        $('.wpvr_dropdown').each(function () {
            wpvr_init_dropdown($(this));
        });


        $(document).bind('scroll', function () {
            $('.wpvr_loading_msg').center();
        });

        $(window).bind('resize', function () {
            $('.wpvr_loading_msg').center();
        });

        $('.wpvr_option_inside').each(function () {
            var wrap = $(this);
            var btn = $('.wpvr_api_get_from_default', wrap).click(function (e) {
                var data = btn.data();
                $('#' + data.key_target, wrap).val(data.key);
                $('#' + data.client_target, wrap).val(data.client);
                $('#' + data.secret_target, wrap).val(data.secret);
            });
        });

        // Async Single Item Processing
        function wpvr_process_update_thumbs(k, items, box) {

            if (k >= items.length) {
                console.log('All items async processed !');
                box.stopHighlight();
                box.doClose();

                var box2 = wpvr_show_loading_new({
                    title: wpvr_localize.work_completed,
                    text: items.length + ' thumbnails redownloaded.',
                    pauseButton: wpvr_localize.ok_button,
                });
                box2.doPause(function () {
                    box2.doClose();
                });
                return false;
            }

            $('.wpvr_current_title', box).html(items[k].post_title);


            $.ajax({
                type: 'POST',
                url: wpvr_globals.ajax_url,
                data: {
                    action: 'update_single_thumbnail',
                    post: items[k],
                },
                success: function (response) {
                    var $json = wpvr_get_json(response);

                    if ($json.status == 0) {
                        wpvr_alert('Something went wrong on the single processing...');
                        return false;
                    }

                    var p = Math.round((parseInt(k) + 1) / items.length * 100);
                    box.doProgress({
                        pct: p,
                        text: (k + 1) + ' / ' + items.length,
                    });
                    k++;
                    wpvr_process_update_thumbs(k, items, box);


                },
                error: function (xhr, ajaxOptions, thrownError) {
                    alert(thrownError);
                }
            });
        }

        $('.wpvr_setter_button[action=update_all_thumbnails]').click(function (e) {
            e.preventDefault();
            var btn = $(this);
            wpvr_btn_loading(btn);
            $.ajax({
                type: 'POST',
                url: wpvr_globals.ajax_url,
                data: {
                    action: 'update_all_thumbnails_prepare',
                },
                success: function (response) {
                    var $json = wpvr_get_json(response);
                    wpvr_btn_loading(btn, false);

                    if ($json.status != 1) {
                        wpvr_alert('Something went wrong.');
                        return false;
                    }
                    wpvr_confirm(
                        $json.msg,
                        function () {
                            var box = wpvr_show_loading({
                                title: wpvr_localize.work_in_progress + '...',
                                text: '<br/><div class="wpvr_current_title"></div>',
                                progressBar: true,
                                cancelButton: wpvr_localize.cancel_button, // OR window
                                isModal: true,
                            });

                            box.doProgress({pct: 1, text: wpvr_localize.loading_raw + ''});
                            box.doHighlight();
                            box.data('work', 1);

                            box.doCancel(function () {
                                box.doHide();
                                wpvr_confirm(
                                    wpvr_localize.really_want_cancel,
                                    function () {
                                        box.doShow();
                                    },
                                    wpvr_localize.continue_button,
                                    function () { //IF yes
                                        box.data('work', 0);
                                    },
                                    wpvr_localize.cancel_anyway
                                );
                            });
                            wpvr_process_update_thumbs(0, $json.data.items, box);


                        }, 'Update all thumbnails',
                        function () {
                        }, 'Cancel'
                    );
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    wpvr_alert(thrownError);
                }
            });


        });

        $('.wp-admin.post-type-wpvr_source').each(function () {
            var wrap = $(this);
            var fixedbar = $('#wpvr_source_status_metabox', wrap);

            if ($('#wpvr_source_status_metabox', wrap).length === 0) {
                return;
            }

            $(window).scroll(function () {

                if (typeof $('.wpvr_view_source_metrics').offset() === 'undefined') {
                    return false;
                }

                var current_scroll = parseInt($(window).scrollTop()) + 30;
                var max_scroll = parseInt($('.wpvr_view_source_metrics').offset().top);

                if (current_scroll >= max_scroll) {
                    fixedbar.addClass('fixed');
                } else {
                    fixedbar.removeClass('fixed')
                }
            });
        });

        $('.wp-admin').each(function () {
            var wrap = $(this);
            var fixedbar = $('#wpvr_video_actions_metabox', wrap);
            $(window).scroll(function () {
                if ($(window).scrollTop() > 280) {
                    fixedbar.addClass('fixed')
                } else {
                    fixedbar.removeClass('fixed')
                }
            });
        });

        $('#widget-list .widget').each(function () {
            if ($(this).attr('id').indexOf('wpvr') != -1) {
                $('h3', $(this)).addClass('wpvr_widget_holder');
            }
        });

        $('#plugin_update_from_iframe').click(function (e) {
            var slug = $(this).attr('data-slug');
            if (slug.indexOf('wpvr') > -1) {
                e.preventDefault();
                window.open($(this).attr('href'));
            }
        });

        $('.wpvr_merge_selected_duplicates').click(function (e) {
            e.preventDefault();
            var btn = $(this);
            var merge_url = btn.attr('url');
            var is_merging_all = btn.attr('is_merging_all');

            var items = [];
            var master_items = [];
            if (is_merging_all != '1') {
                var confirm_msg = wpvr_localize.confirm_merge_items;
                $('.wpvr_video', $('.wpvr_manage_bulk_form')).each(function () {
                    var video = $(this);
                    if ($('.wpvr_video_cb', video).prop('checked')) {
                        var ids = $('.wpvr_video_merge', video).attr('ids').split(',');
                        master_items.push(ids[0]);
                        items.push.apply(items, ids);
                    }
                });
                if (items.length == 0 && !bulk_action) return false;
            } else {
                master_items = 'all';
                var confirm_msg = wpvr_localize.confirm_merge_all_items;
            }

            wpvr_confirm(
                confirm_msg,
                function () { //YES FCT
                    wpvr_btn_loading(btn, true);
                    var boxWaiting = wpvr_show_loading({
                        title: 'WP Video Robot',
                        text: wpvr_localize.loadingCenter,
                    });

                    $.ajax({
                        type: 'POST',
                        url: wpvr_globals.ajax_url,
                        data: {
                            action: 'merge_items',
                            items: master_items,
                        },
                        success: function (r) {
                            wpvr_btn_loading(btn, false);
                            boxWaiting.remove();
                            var $json = wpvr_get_json(r);
                            if ($json.status != 0) {

                                var exec_time = $json.data.exec_time;
                                var count_videos = $json.data.count.videos;
                                var count_dups = $json.data.count.duplicates;

                                var merge_msg =
                                    count_videos + ' ' + wpvr_localize.videos_processed_successfully + '.<br/>' +
                                    count_dups + ' ' + wpvr_localize.duplicates_removed_in + ' ' +
                                    exec_time + ' ' + wpvr_localize.seconds + '.'
                                ;

                                var boxNEW = wpvr_show_loading_new({
                                    title: wpvr_localize.wp_video_robot,
                                    text: merge_msg,
                                    isModal: false,
                                    pauseButton: wpvr_localize.ok_button,
                                });
                                boxNEW.doPause(function () {
                                    wpvr_manage_refresh(false, true);
                                    $('.wpvr_manage_bulk_actions_select').fadeOut();
                                    $('.wpvr_manage_checkAll').attr('state', 'off');
                                    $('.wpvr_manage_bulk_actions_select .wpvr_count_checked').html('');
                                    boxNEW.remove();
                                });


                            }
                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            alert(thrownError);
                        }
                    });
                },
                wpvr_localize.yes,
                function () {
                },
                wpvr_localize.cancel_button
            );
            return false;
        });

        $('#wpvr_video_metabox').hide();
        $('.wpvr_toggle_advanced_adding').click(function (e) {
            e.preventDefault();
            if ($(this).hasClass('is_advanced')) {
                $(this).removeClass('is_advanced');
                $('#wpvr_video_metabox').fadeOut();
            } else {
                $(this).addClass('is_advanced');
                $('#wpvr_video_metabox').fadeIn();
                var y = $('#wpvr_video_metabox').offset().top - 50;
                $('html, body').animate({scrollTop: y,}, 'slow');


            }
        });

        $('.wpvr_import_wizzard').each(function () {
            var btn = $(this);

            btn.click(function (e) {
                e.preventDefault();
                var spinner = wpvr_add_loading_spinner(btn, 'pull-right');

                function wpvr_init_wizard() {
                    wpvr_remove_loading_spinner(spinner);

                    var video_service = btn.attr('video_service');
                    var video_id = btn.attr('video_id');

                    var boxWiz = wpvr_show_loading_new({
                        title: wpvr_localize.import_video_manually,
                        width: '50%',
                        boxClass: 'wpvr_wizzard_wrap',
                        text: $('#wpvr_wizzard_content').html(),
                        isModal: false,
                        cancelButton: '<i class="fa fa-times"></i> ' + wpvr_localize.close_wizard,
                    });


                    var step = 1;
                    boxWiz.attr('step', step);
                    boxWiz.attr('far_step', step);
                    $('.wpvr_loading_msg', boxWiz).center();
                    boxWiz.doCancel(function () {
                        boxWiz.doClose();
                    });

                    $('.wpvr_wizzard_service', boxWiz).click(function () {
                        $('.wpvr_wizzard_service', boxWiz).removeClass('active');
                        $(this).addClass('active');
                        $('#wpvr_wizzard_service', boxWiz).attr('value', $(this).attr('service'));
                        $('#wpvr_wizzard_pid', boxWiz).attr('value', $(this).attr('pid'));
                        $('.wpvr_wizzard_next_step', boxWiz).removeClass('disabled');
                    });

                    $('.wpvr_wizzard_choice', boxWiz).click(function () {
                        if ($(this).hasClass('active')) {
                            $(this).removeClass('active');
                            $(this).addClass('inactive');
                            $('.wpvr_wizzard_choice_value', $(this)).attr('value', 'off');
                        } else {
                            $(this).addClass('active');
                            $(this).removeClass('inactive');
                            $('.wpvr_wizzard_choice_value', $(this)).attr('value', 'on');
                        }
                        var chosen = 0;
                        $('.wpvr_wizzard_choice_value', boxWiz).each(function () {
                            if ($(this).attr('value') == 'on') chosen++;
                        });
                        if (chosen == 0) {
                            $('.wpvr_wizzard_run', boxWiz).addClass('disabled');
                        } else {
                            $('.wpvr_wizzard_run', boxWiz).removeClass('disabled');
                        }

                    });

                    function wpvr_check_wizzard_param() {
                        if ($(this).attr('value') == '') {
                            $('.wpvr_wizzard_next_step', boxWiz).addClass('disabled');
                        } else {
                            $('.wpvr_wizzard_next_step', boxWiz).removeClass('disabled');
                        }
                    }

                    $('.wpvr_wizzard_next_step', boxWiz).click(function (e) {
                        e.preventDefault();
                        $('.wpvr_loading_msg', boxWiz).center();
                        wpvr_correct_scrolling();
                        if ($(this).hasClass('disabled')) return;
                        var step = parseInt(boxWiz.attr('step'));
                        step++;
                        $('.wpvr_wizzard_form', boxWiz)
                            .removeClass('step_1')
                            .removeClass('step_2')
                            .removeClass('step_3')
                            .removeClass('step_4')
                            .addClass('step_' + step);
                        boxWiz.attr('step', step);
                        if (step >= boxWiz.attr('far_step')) {
                            $('.wpvr_wizzard_next_step', boxWiz).addClass('disabled');
                            boxWiz.attr('far_step', step);
                        }
                        if (step == 2) {
                            $('.wpvr_wizzard_form_param', boxWiz).focus();
                        }
                        $('.wpvr_wizzard_form_param', boxWiz).each(wpvr_check_wizzard_param);
                    });


                    $('.wpvr_wizzard_form_param', boxWiz).each(wpvr_check_wizzard_param);
                    $('.wpvr_wizzard_form_param', boxWiz).keyup(wpvr_check_wizzard_param);
                    $('.wpvr_wizzard_form_param', boxWiz).change(wpvr_check_wizzard_param);
                    $('.wpvr_wizzard_form_param', boxWiz).focusout(wpvr_check_wizzard_param);
                    $('.wpvr_wizzard_form_param', boxWiz).bind('paste', function () {
                        setTimeout(function () {
                            wpvr_check_wizzard_param();
                        }, 100);
                    });


                    $('.wpvr_wizzard_prev_step', boxWiz).click(function (e) {
                        e.preventDefault();
                        var step = parseInt(boxWiz.attr('step'));
                        step--;
                        $('.wpvr_wizzard_form', boxWiz)
                            .removeClass('step_1')
                            .removeClass('step_2')
                            .removeClass('step_3')
                            .removeClass('step_4')
                            .addClass('step_' + step);
                        boxWiz.attr('step', step);
                        if (step < boxWiz.attr('far_step')) {
                            $('.wpvr_wizzard_next_step', boxWiz).removeClass('disabled');
                        }
                        if (step == 1) {
                            if ($('#wpvr_wizzard_service').attr('value') == '') {
                                $('.wpvr_wizzard_next_step', boxWiz).addClass('disabled');
                            }
                            else {
                                $('.wpvr_wizzard_next_step', boxWiz).removeClass('disabled');
                            }
                        } else {
                            $('.wpvr_wizzard_form_param', boxWiz).each(wpvr_check_wizzard_param);
                        }

                    });

                    if (video_service != '') {
                        $('.wpvr_wizzard_service[service=' + video_service + ']', boxWiz).trigger('click');
                    }

                    if (video_id != '') {
                        $('#wpvr_wizzard_param').attr('value', video_id);
                    }

                    $('.wpvr_wizzard_run', boxWiz).click(function (e) {
                        e.preventDefault();
                        if ($(this).hasClass('disabled')) return false;

                        var pid = $('#wpvr_wizzard_pid', boxWiz).attr('value');
                        var service = $('#wpvr_wizzard_service', boxWiz).attr('value');
                        var param = $('#wpvr_wizzard_param', boxWiz).attr('value');

                        $('.cmb_id_wpvr_video_service .cmb_option[value=' + service + ']').prop('checked', true);
                        $('#wpvr_video_' + pid + 'Id').attr('value', param);
                        $('#wpvr_video_enableManualAdding').val('on');
                        $('.wpvr_wizzard_choice_value', boxWiz).each(function () {
                            if ($(this).attr('value') == 'on') {
                                $('#' + $(this).attr('target_id')).val('on');
                            } else {
                                $('#' + $(this).attr('target_id')).val('off');
                            }
                        });

                        boxWiz.doClose();
                        $('.wpvr_wizzard_overlay').fadeIn();
                        $('.wpvr_manual_import_trigger').trigger('click');
                    });

                    boxWiz.doPause(function () {
                        step++;
                        $('.wpvr_wizzard_form', boxWiz)
                            .removeClass('step_1')
                            .removeClass('step_2')
                            .removeClass('step_3')
                            .removeClass('step_4')
                            .addClass('step_' + step);

                    });


                }

                wpvr_init_wizard();

                // $.ajax({
                //     type: 'POST',
                //     url: wpvr_globals.ajax_url,
                //     data: {
                //         action: 'get_video_wizzard_form',
                //     },
                //     success: function (data) {
                //         wpvr_remove_loading_spinner(spinner);
                //
                //         var $json = wpvr_get_json(data);
                //         var video_service = btn.attr('video_service');
                //         var video_id = btn.attr('video_id');
                //
                //         var boxWiz = wpvr_show_loading_new({
                //             title: wpvr_localize.import_video_manually,
                //             width: '50%',
                //             boxClass: 'wpvr_wizzard_wrap',
                //             text: $json,
                //             isModal: false,
                //             //pauseButton: 'Next Step <i class="fa fa-arrow-right"></i>',
                //             cancelButton: '<i class="fa fa-times"></i> ' + wpvr_localize.close_wizard,
                //         });
                //
                //
                //         var step = 1;
                //         boxWiz.attr('step', step);
                //         boxWiz.attr('far_step', step);
                //         $('.wpvr_loading_msg', boxWiz).center();
                //         boxWiz.doCancel(function () {
                //             boxWiz.doClose();
                //         });
                //
                //         $('.wpvr_wizzard_service', boxWiz).click(function () {
                //             $('.wpvr_wizzard_service', boxWiz).removeClass('active');
                //             $(this).addClass('active');
                //             $('#wpvr_wizzard_service').attr('value', $(this).attr('service'));
                //             $('#wpvr_wizzard_pid').attr('value', $(this).attr('pid'));
                //             $('.wpvr_wizzard_next_step', boxWiz).removeClass('disabled');
                //             // $('.wpvr_wizzard_next_step', boxWiz).delay(1000).trigger('click');
                //         });
                //
                //         $('.wpvr_wizzard_choice', boxWiz).click(function () {
                //             if ($(this).hasClass('active')) {
                //                 $(this).removeClass('active');
                //                 $(this).addClass('inactive');
                //                 $('.wpvr_wizzard_choice_value', $(this)).attr('value', 'off');
                //             } else {
                //                 $(this).addClass('active');
                //                 $(this).removeClass('inactive');
                //                 $('.wpvr_wizzard_choice_value', $(this)).attr('value', 'on');
                //             }
                //             var chosen = 0;
                //             $('.wpvr_wizzard_choice_value', boxWiz).each(function () {
                //                 if ($(this).attr('value') == 'on') chosen++;
                //             })
                //             if (chosen == 0) {
                //                 $('.wpvr_wizzard_run', boxWiz).addClass('disabled');
                //             } else {
                //                 $('.wpvr_wizzard_run', boxWiz).removeClass('disabled');
                //             }
                //
                //         });
                //
                //         function wpvr_check_wizzard_param() {
                //             if ($(this).attr('value') == '') {
                //                 $('.wpvr_wizzard_next_step', boxWiz).addClass('disabled');
                //             } else {
                //                 $('.wpvr_wizzard_next_step', boxWiz).removeClass('disabled');
                //             }
                //         }
                //
                //         $('.wpvr_wizzard_next_step', boxWiz).click(function (e) {
                //             e.preventDefault();
                //             if ($(this).hasClass('disabled')) return;
                //             var step = parseInt(boxWiz.attr('step'));
                //             step++;
                //             $('.wpvr_wizzard_form', boxWiz)
                //                 .removeClass('step_1')
                //                 .removeClass('step_2')
                //                 .removeClass('step_3')
                //                 .removeClass('step_4')
                //                 .addClass('step_' + step);
                //             boxWiz.attr('step', step);
                //             if (step >= boxWiz.attr('far_step')) {
                //                 $('.wpvr_wizzard_next_step', boxWiz).addClass('disabled');
                //                 boxWiz.attr('far_step', step);
                //             }
                //             if (step == 2) {
                //                 $('.wpvr_wizzard_form_param', boxWiz).focus();
                //             }
                //             $('.wpvr_wizzard_form_param', boxWiz).each(wpvr_check_wizzard_param);
                //         });
                //
                //
                //         $('.wpvr_wizzard_form_param', boxWiz).each(wpvr_check_wizzard_param);
                //         $('.wpvr_wizzard_form_param', boxWiz).keyup(wpvr_check_wizzard_param);
                //         $('.wpvr_wizzard_form_param', boxWiz).change(wpvr_check_wizzard_param);
                //         $('.wpvr_wizzard_form_param', boxWiz).focusout(wpvr_check_wizzard_param);
                //         $('.wpvr_wizzard_form_param', boxWiz).bind('paste', function () {
                //             setTimeout(function () {
                //                 wpvr_check_wizzard_param();
                //             }, 100);
                //         });
                //
                //
                //         $('.wpvr_wizzard_prev_step', boxWiz).click(function (e) {
                //             e.preventDefault();
                //             var step = parseInt(boxWiz.attr('step'));
                //             step--;
                //             $('.wpvr_wizzard_form', boxWiz)
                //                 .removeClass('step_1')
                //                 .removeClass('step_2')
                //                 .removeClass('step_3')
                //                 .removeClass('step_4')
                //                 .addClass('step_' + step);
                //             boxWiz.attr('step', step);
                //             if (step < boxWiz.attr('far_step')) {
                //                 $('.wpvr_wizzard_next_step', boxWiz).removeClass('disabled');
                //             }
                //             if (step == 1) {
                //                 if ($('#wpvr_wizzard_service').attr('value') == '') {
                //                     $('.wpvr_wizzard_next_step', boxWiz).addClass('disabled');
                //                 }
                //                 else {
                //                     $('.wpvr_wizzard_next_step', boxWiz).removeClass('disabled');
                //                 }
                //             } else {
                //                 $('.wpvr_wizzard_form_param', boxWiz).each(wpvr_check_wizzard_param);
                //             }
                //
                //         });
                //
                //         if (video_service != '') {
                //             $('.wpvr_wizzard_service[service=' + video_service + ']', boxWiz).trigger('click');
                //         }
                //
                //         if (video_id != '') {
                //             $('#wpvr_wizzard_param').attr('value', video_id);
                //         }
                //
                //         $('.wpvr_wizzard_run', boxWiz).click(function (e) {
                //             e.preventDefault();
                //             if ($(this).hasClass('disabled')) return false;
                //
                //             var pid = $('#wpvr_wizzard_pid', boxWiz).attr('value');
                //             var service = $('#wpvr_wizzard_service', boxWiz).attr('value');
                //             var param = $('#wpvr_wizzard_param', boxWiz).attr('value');
                //
                //             $('.cmb_id_wpvr_video_service .cmb_option[value=' + service + ']').prop('checked', true);
                //             $('#wpvr_video_' + pid + 'Id').attr('value', param);
                //             $('#wpvr_video_enableManualAdding').val('on');
                //             $('.wpvr_wizzard_choice_value', boxWiz).each(function () {
                //                 if ($(this).attr('value') == 'on') {
                //                     $('#' + $(this).attr('target_id')).val('on');
                //                 } else {
                //                     $('#' + $(this).attr('target_id')).val('off');
                //                 }
                //             });
                //
                //             boxWiz.doClose();
                //             $('.wpvr_wizzard_overlay').fadeIn();
                //             $('.wpvr_manual_import_trigger').trigger('click');
                //         });
                //
                //         boxWiz.doPause(function () {
                //             step++;
                //             $('.wpvr_wizzard_form', boxWiz)
                //                 .removeClass('step_1')
                //                 .removeClass('step_2')
                //                 .removeClass('step_3')
                //                 .removeClass('step_4')
                //                 .addClass('step_' + step);
                //
                //         });
                //
                //
                //     },
                // });


            })
            ;


        });

        $('.wpvr_imageselect_wrap').each(function () {
            var wrap = $(this);
            var input = $('.wpvr_imageselect_input', wrap);
            $('.wpvr_imageselect_item[data-value=' + input.val() + ']', wrap).addClass('active');
            $('.wpvr_imageselect_item', wrap).click(function (e) {
                e.preventDefault();
                $('.wpvr_imageselect_item', wrap).removeClass('active');
                $(this).addClass('active');
                input.attr('value', $(this).data('value'));
            });
        });

        $('.wpvr_popup_info').each(function () {
            var btn = $(this);
            var popup_content_id = btn.attr('popup_content_id');
            var popup_content = $('#' + popup_content_id).html();
            var popup_title = btn.attr('popup_title');

            btn.click(function (e) {
                e.preventDefault();
                if (typeof popup_title == 'undefined') {
                    popup_title = 'WP Video Robot';
                }

                if (typeof popup_content == 'undefined') {
                    popup_content = '';
                }

                var boxPopup = wpvr_show_loading_new({
                    title: popup_title,
                    text: '<div class="wpvr_selectable">' + wpvr_nl2br(popup_content) + '</div>',
                    pauseButton: wpvr_localize.close_button,
                });
                $('.wpvr_loading_msg', boxPopup).center();

                boxPopup.doPause(function () {
                    boxPopup.doClose();
                });
            });


        });

        $('.wpvrArgs td').each(function () {
            var td = $(this);
            var span = $('.wpvr_wanted_param', td);
            var inputs = $('input, textarea', td);
            span.click(function (e) {
                e.preventDefault();
                //inputs.val(span.html());
                inputs.each(function () {
                    var input = $(this);
                    if (!input.hasClass('wpvr_helper_input')) {
                        input.val(span.html());
                    }
                });
            });
        });

        function wpvr_nl2br(str, is_xhtml) {
            var breakTag = (is_xhtml || typeof is_xhtml === 'undefined') ? '<br />' : '<br>';
            return (str + '').replace(/([^>\r\n]?)(\r\n|\n\r|\r|\n)/g, '$1' + breakTag + '$2');
        }

        $('.wpvr_read_changelog').click(function (e) {
            var url = $(this).attr('changelog_url');
            var title = $(this).attr('changelog_title');
            $.ajax({
                type: 'GET',
                url: url,
                success: function (data) {
                    var boxChangeLog = wpvr_show_loading_new({
                        height: '80%',
                        width: '70%',
                        title: title,
                        boxClass: 'wpvr_changelog_dialog',
                        text: wpvr_nl2br(data),
                        pauseButton: wpvr_localize.close_button,
                    });
                    $('.wpvr_loading_msg', boxChangeLog).center();

                    boxChangeLog.doPause(function () {
                        boxChangeLog.doClose();
                    });
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    alert(thrownError);
                },
            });
        });

        $('.wpvr_import_sample_sources').click(function (e) {
            e.preventDefault();
            var btn = $(this);
            var url = btn.attr('url');
            var spinner = wpvr_add_loading_spinner(btn, 'pull-right');
            wpvr_confirm(
                wpvr_localize.confirm_import_sample_sources,
                function () {
                    $.ajax({
                        type: 'POST',
                        url: wpvr_globals.ajax_url,
                        data: {
                            action: 'import_sample_sources',
                        },
                        success: function (data) {
                            var $json = wpvr_get_json(data);
                            wpvr_remove_loading_spinner(spinner);
                            wpvr_alert($json.msg);
                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            alert(thrownError);
                        },
                    });
                },
                wpvr_localize.cancelButton,
                function () {
                    wpvr_remove_loading_spinner(spinner);
                }
            );
        });

        $('body.post-type-wpvr_source form#post').each(function () {
            var form = $(this);
            var make_test_btn_not_ready = function () {
                $('#wpvr_metabox_test').attr('ready', 0);
            };

            $('input', form).change(make_test_btn_not_ready);
            $('select[name!=wpvr_source_rules_selection]', form).change(make_test_btn_not_ready);
        });

        function wpvr_refresh_manual_import_trigger(s) {
            var btn = $('.wpvr_manual_adding_btns');
            if (s.val() == 'off') btn.hide();
            else btn.fadeIn();
        }

        function wpvr_adapt_fixed_bottom_buttons() {
            if ($('body').hasClass('folded')) $('.wpvr_test_form_buttons.bottom').addClass('folded');
            else $('.wpvr_test_form_buttons.bottom').removeClass('folded');
        }

        wpvr_adapt_fixed_bottom_buttons();

        $('#collapse-menu').click(function (e) {
            wpvr_adapt_fixed_bottom_buttons();
        });

        $('.wpvr_test_screen_wrap').each(function () {
            var wrap = $(this);
            var videos_wrap_y = $('.wpvr_videos', wrap).offset().top;
            var buttons_bottom = $('.wpvr_test_form_buttons.bottom', wrap);
            $(window).scroll(function () {
                var y = $(window).scrollTop() - videos_wrap_y;
                if ($(window).scrollTop() + $(window).height() > $(document).height() - 100) {
                    if (buttons_bottom.hasClass('fixed')) {
                        buttons_bottom.hide().removeClass('fixed').fadeIn();
                    }
                } else {
                    if (y > 50) {
                        if (!buttons_bottom.hasClass('fixed')) {
                            buttons_bottom.hide().addClass('fixed').fadeIn();
                        }
                    } else {
                        buttons_bottom.hide().removeClass('fixed').show();
                    }
                }
            });
        });

        $('.wpvr_source_tabs').each(function () {
            var wrap = $(this);
            var active_section = wrap.data('active_section');
            var board = $('#normal-sortables');
            $('.wpvr_source_tab', wrap).click(function (e) {
                e.preventDefault();
                var tab = $(this);
                $('.wpvr_source_tab', wrap).removeClass('active');
                tab.addClass('active');
                var target = tab.data('target');

                $('.postbox', board).hide().removeClass('open').addClass('closed');
                $('.postbox#' + target, board).fadeIn().removeClass('closed').addClass('open');

            });

            $('.wpvr_view_source_metrics').click(function (e) {
                e.preventDefault();
                $('.wpvr_source_tab[data-tab_id=metrics]').trigger('click');
            });

            $('.wpvr_source_tab.active', wrap).trigger('click');
            // $('.wpvr_source_tab[data-tab_id='+active_section+']', wrap).trigger('click');

        });

        $('.wpvr_options_page').each(function () {
            var wrap = $(this);
            var videos_wrap_y = $('#wpvr_options', wrap).offset().top;
            var buttons_bottom = $('.wpvr_options_bottom_actions', wrap);
            $(window).scroll(function () {
                var y = $(window).scrollTop() - videos_wrap_y;
                if ($(window).scrollTop() + $(window).height() > $(document).height() - 50) {
                    if (buttons_bottom.hasClass('fixed')) {
                        buttons_bottom.hide().removeClass('fixed').fadeIn();
                    }
                } else {
                    if (y > 50) {
                        if (!buttons_bottom.hasClass('fixed')) {
                            buttons_bottom.hide().addClass('fixed').fadeIn();
                        }
                    } else {
                        buttons_bottom.hide().removeClass('fixed').show();
                    }
                }
            });
        });

        $('#wpvr_video_enableManualAdding').each(function () {
            var select = $(this);
            wpvr_refresh_manual_import_trigger(select);
            select.change(function () {
                wpvr_refresh_manual_import_trigger(select);
            });
        });

        $('.wpvr_embed_video_btn').click(function (e) {
            e.preventDefault();
            var title = $(this).attr('dialog_title');
            var msg = $(this).attr('msg');
            var code = $(this).attr('code');
            var box2 = wpvr_show_loading_new({
                title: title,
                text: ' ' + msg + ' <br/> <br/><div class="wpvr_embed_code_wrapper">' + code + '</div>',
                pauseButton: wpvr_localize.ok_button,
            });
            box2.doPause(function () {
                box2.doClose();
            });
        });

        function wpvr_refresh_theme_screenshot(s) {
            var target = $('.wpvr_theme_screenshot');
            var folder = target.attr('folder');
            var theme = s.attr('value');
            if (theme == 'seven' || theme == '') theme = 'default';
            var img_src = folder + theme + '.jpg';

            target.hide().html('<img class="wpvr_theme_screenshot_img" src="' + img_src + '" />').fadeIn();
        }

        $('#player_theme').each(function () {
            var select = $(this);
            wpvr_refresh_theme_screenshot(select);
            select.change(function () {
                wpvr_refresh_theme_screenshot(select);
            });
        });

        $('.wpvr_option_slider_input_text').each(function () {
            var text = $(this);
            var slider = $('#' + text.attr('slider_id'));
            var min = parseInt(slider.attr('slider_min'));
            var max = parseInt(slider.attr('slider_max'));
            text.on('change', function () {
                var val = $(this).val();
                if (val < min) val = min;
                if (val > max) val = max;
                slider.val(parseInt(val));
                text.attr('value', val);

            });


        });

        $('.wpvr_option_slider_range').each(function () {
            var slider = $(this);
            var slider_input_id = slider.attr('slider_input');
            var slider_min = slider.attr('slider_min');
            var slider_max = slider.attr('slider_max');
            var slider_value = slider.attr('slider_value');
            var slider_step = slider.attr('slider_step');
            var input = $('.wpvr_option_slider_input #' + slider_input_id);
            var slider_elt = slider.get(0);
            noUiSlider.create(slider_elt, {

                start: parseInt(slider_value),
                step: parseInt(slider_step),
                connect: [true, false],
                range: {
                    'min': parseInt(slider_min),
                    'max': parseInt(slider_max)
                }
            });

            slider_elt.noUiSlider.on('slide', function () {
                input.val(parseInt(slider_elt.noUiSlider.get()));
            });
        });

        $('.wpvr_wuh_wrap').each(function () {
            var wrap = $(this);
            var slider = $('.wpvr_wuh_slider', wrap);
            var input_a = $('.wpvr_wuh_input.a', wrap);
            var input_b = $('.wpvr_wuh_input.b', wrap);

            var slider_elt = slider.get(0);
            noUiSlider.create(slider_elt, {
                start: [
                    parseInt(input_a.val()),
                    parseInt(input_b.val())
                ],
                connect: [false, true, false],
                step: parseInt(slider.data('step')),
                tooltips: [
                    wNumb({decimals: 0, postfix: 'H'}),
                    wNumb({decimals: 0, postfix: 'H'})
                ],
                range: {
                    'min': parseInt(slider.data('min')),
                    'max': parseInt(slider.data('max'))
                }
            });
            slider_elt.noUiSlider.on('slide', function () {
                var v = parseInt(slider.val());
                var values = slider_elt.noUiSlider.get();
                input_a.val(parseInt(values[0]));
                input_b.val(parseInt(values[1]));
            });
        });

        $('.wpvr_video_view_ext').click(function (e) {
            e.preventDefault();
            var btn = $(this);
            var win = window.open(btn.attr('href'), btn.attr('target'));
            win.focus();
        });

        $('.wpvr_option_value_wrap').each(function () {
            var wrap = $(this);
            var slider = $('.wpvr_option_value_slider', wrap);
            var input = $('.wpvr_option_value_input.a', wrap);

            var slider_elt = slider.get(0);


            var postfix = slider.data('tooltip-suffix');

            noUiSlider.create(slider_elt, {
                start: input.val(),
                connect: [true, false],
                step: parseInt(slider.data('step')),
                tooltips: wNumb({decimals: 0, postfix: postfix}),
                range: {
                    'min': parseInt(slider.data('min')),
                    'max': parseInt(slider.data('max'))
                }
            });
            slider_elt.noUiSlider.on('slide', function () {
                var values = slider_elt.noUiSlider.get();
                input.val(parseInt(values));

            });
        });

        $('.wpvr_option_image_wrap').each(function () {
            var _wrap = $(this);
            var _default = _wrap.attr('default');
            var _button = $('.wpvr_option_image_thumb_button', _wrap);
            var _thumb = $('.wpvr_option_image_thumb', _wrap);
            var _field = $('.wpvr_option_image_thumb_input', _wrap);
            var _fieldid = $('.wpvr_option_image_thumb_input__id', _wrap);

            $('body').on('click', '.wpvr_option_image_remove', function (e) {
                _thumb
                    .hide()
                    .html('<img class="wpvr_option_thumb_img" src="' + _default + '" />')
                    .fadeIn();
                _field.val('');

            });

            _button.click(function (e) {
                e.preventDefault();
                var image = wp.media({
                    title: 'Upload Image',
                    multiple: false
                }).open()
                    .on('select', function (e) {
                        var uploaded_image = image.state().get('selection').first();
                        var image_url = uploaded_image.toJSON().url;
                        _field.val(image_url);
                        _fieldid.val(uploaded_image.toJSON().id);
                        var thumb = '';
                        thumb += '<img class="wpvr_option_thumb_img" src="' + image_url + '" />';
                        thumb += '<button class="wpvr_option_image_remove"><i class="fa fa-remove"></i></button>';
                        _thumb.html(thumb);
                    });
            });

        });

        $('#wpvr_get_mb_close').click(function (e) {
            e.preventDefault();
            window.close();
        });

        $('#wpvr_get_metaboxes').click(function (e) {
            e.preventDefault();
            window.open($(this).attr('url'));
        });

        $('.wpvr_test_form_info').click(function (e) {
            var btn = $(this);
            var msg = $('#wpvr_grouped_info').html();
            e.preventDefault();
            var box2 = wpvr_show_loading_new({
                title: wpvr_localize.group_info,
                text: ' ' + msg + '',
                pauseButton: wpvr_localize.ok_button,
            });
            box2.doPause(function () {
                box2.doClose();
            });
        });

        // Async Start Processing
        function wpvr_async_process_start(btn, items) {

            var start_url = btn.attr('async_start_url');
            var single_url = btn.attr('async_single_url');
            var confirm_msg = btn.attr('async_confirm_msg');
            var processed_msg = btn.attr('async_processed_msg');
            var box = wpvr_show_loading({
                title: wpvr_localize.please_wait,
                text: wpvr_localize.work_in_progress + "...",
                progressBar: true, // OR window
                cancelButton: wpvr_localize.cancel_button, // OR window
                isModal: true,
            });

            box.doProgress({pct: 1, text: wpvr_localize.loading_raw + ''});
            box.doHighlight();
            box.attr('work', 1);
            box.attr('processed_msg', processed_msg);
            box.attr('confirm_msg', confirm_msg);
            box.attr('single_url', single_url);
            box.attr('start_url', start_url);


            box.doCancel(function () {
                box.doHide();
                wpvr_confirm(
                    wpvr_localize.really_want_cancel,
                    function () {
                        box.doShow();
                    },
                    wpvr_localize.continue_button,
                    function () { //IF yes
                        box.attr('work', 0);
                        var k = box.attr('k');
                    },
                    wpvr_localize.cancel_anyway
                );
            });
            wpvr_async_process_single(0, items, box);
        }

        // Async Single Item Processing
        function wpvr_async_process_single(k, items, box) {

            box.attr('k', k);
            var url = box.attr('url');
            var processed_msg = box.attr('processed_msg');
            var single_url = box.attr('single_url');

            if (k >= items.length) {
                console.log('All items async processed !');
                box.stopHighlight();
                box.doClose();

                var box2 = wpvr_show_loading_new({
                    title: wpvr_localize.work_completed,
                    text: items.length + ' ' + processed_msg + '.',
                    pauseButton: wpvr_localize.ok_button,
                });
                box2.doPause(function () {
                    box2.doClose();
                });
                return false;
            }

            $.ajax({
                type: 'GET',
                url: single_url,
                data: {k: k,},
                success: function (r) {
                    $json = wpvr_get_json(r);
                    if (r != 'error') {
                        var progress = (parseInt((k + 1) / items.length) * 100) + '%';
                        var p = Math.round((parseInt(k) + 1) / items.length * 100);

                        box.doProgress({
                            pct: p,
                            text: (k + 1) + ' / ' + items.length,
                        });
                        k++;
                        wpvr_async_process_single(k, items, box)
                    } else {
                        console.log('OUPS! There has been an error !');
                    }

                },
                error: function (xhr, ajaxOptions, thrownError) {
                    alert(thrownError);
                }
            });
        }

        $('.wpvr_async_btn_').each(function () {
            var btn = $(this);
            var start_url = btn.attr('async_start_url');
            var single_url = btn.attr('async_single_url');
            var confirm_msg = btn.attr('async_confirm_msg');
            var processed_msg = btn.attr('async_processed_msg');

            //CLicking the buton
            btn.click(function (e) {
                e.preventDefault();

                $.ajax({
                    type: 'GET',
                    url: start_url,
                    success: function (data) {
                        $json = wpvr_get_json(data);

                        if (confirm_msg == '0') {
                            wpvr_async_process_start(btn, $json.data);
                        } else {
                            var new_confirm_msg = confirm_msg.replace('%c%', $json.count);
                            wpvr_confirm(
                                new_confirm_msg,
                                function () { //YES FCT
                                    wpvr_async_process_start(btn, $json.data);
                                },
                                wpvr_localize.yes,
                                function () {
                                },
                                wpvr_localize.cancel_button
                            );
                        }
                    },
                    error: function (xhr, ajaxOptions, thrownError) {
                        alert(thrownError);
                    }
                });

            });

        });

        $('.wpvr_ajax_deferred_load').each(function () {
            var wrap = $(this);
            var action = wrap.data('action');
            var delay = wrap.data('delay');
            if (typeof delay === 'undefined') {
                delay = 200;
            }
            setTimeout(function () {
                $.ajax({
                    type: 'POST',
                    url: wpvr_globals.ajax_url,
                    data: {
                        action: action,
                    },
                    success: function (data) {
                        var $json = wpvr_get_json(data);

                        if ($json.status != 1) return false;
                        wrap.html($json.data.html).fadeIn();
                        $('.wpvr_show_when_loaded', wrap).fadeIn();
                        wrap.addClass('async_loaded');
                    },
                    error: function (xhr, ajaxOptions, thrownError) {
                        console.log(thrownError);
                    }
                });
            }, delay);

        });

        jQuery.extend({
            getQueryParameters: function (str) {
                return (str || document.location.search).replace(/(^\?)/, '').split("&").map(function (n) {
                    return n = n.split("="), this[n[0]] = n[1], this
                }.bind({}))[0];
            }
        });

        $('.wpvr_async_graph').each(function () {
            var wrap = $(this);
            var day = wrap.attr('day');
            var daylabel = wrap.attr('daylabel');
            var daytime = wrap.attr('daytime');
            var hex_color = wrap.attr('hex_color');
            var chart_id = wrap.attr('chart_id');
            var body = $('.inside', wrap);
            $('.wpvr_nav_tab#b').click(function (e) {
                if (!wrap.hasClass('async_loaded')) {
                    setTimeout(function () {
                        $.ajax({
                            type: 'POST',
                            url: wpvr_globals.ajax_url,
                            data: {
                                action: 'wpvr_render_async_stress_graph',
                                daytime: daytime,
                                day: day,
                            },
                            success: function (data) {
                                var $json = wpvr_get_json(data);

                                if ($json.status != 1) return false;

                                $('.wpvr_insite_loading', body).hide();
                                $('.wpvr_graph_wrapper', wrap).html($json.data.html).fadeIn();
                                wrap.addClass('async_loaded');
                            },
                            error: function (xhr, ajaxOptions, thrownError) {
                                console.log(thrownError);
                            }
                        });
                    }, 200 * parseInt(wrap.attr('chart_n')));
                }
            });


        });

        $('.wpvr_has_master').each(function () {
            var slave = $(this);
            var master = $('#' + slave.attr('master_id'));
            var m_values = slave.attr('master_value').split(',');

            if (m_values.indexOf(master.val()) != -1) slave.fadeIn();
            else slave.hide();
            master.each(function () {

                if ($(this).val() == 'customBefore' || $(this).val() == 'customAfter') {
                    $('.cmb_id_wpvr_source_appendCustomText').show();
                } else $('.cmb_id_wpvr_source_appendCustomText').hide();
            });
            master.bind('change', function () {
                if (m_values.indexOf(master.val()) != -1) slave.fadeIn();
                else slave.hide();
            });


        });

        $('.wpvr_countup').each(function () {
            var target = $(this);
            var start = target.attr('count-start');
            var end = target.attr('count-end');
            var numAnim = new CountUp(target.attr('id'), start, end, 0, 2);
            numAnim.start();

        });

        /* Showing Notices ONe after the other */

        $('#wpvr_save_source_btn').click(function (e) {
            e.preventDefault();
            var spinner = wpvr_add_loading_spinner($(this), 'pull-right');
            $('#publishing-action #publish').trigger('click');
            $('#original_post_status').attr('value', 'publish');
            $('#hidden_post_status').attr('value', 'publish');
        });

        $('.wpvr_manual_import_trigger').click(function (e) {
            e.preventDefault();
            $('#publishing-action #publish').trigger('click');
            $('#original_post_status').attr('value', 'publish');
            $('#hidden_post_status').attr('value', 'publish');

        });

        $('.wpvr_clear_logs').click(function (e) {
            e.preventDefault();
            var btn = $(this);
            wpvr_confirm(
                wpvr_localize.confirm_clear_logs,
                function () { //YES FCT
                    wpvr_btn_loading(btn, true);
                    $.ajax({
                        url: wpvr_globals.ajax_url,
                        type: 'POST',
                        data: {
                            action: 'wpvr_clear_logs',
                        },
                        success: function (data) {
                            wpvr_btn_loading(btn, false);
                            location.reload();
                        }
                    });
                },
                wpvr_localize.continue_only,
                function () {
                },
                wpvr_localize.cancel_button
            );
        });

        //Recursive Single Add Video
        function wpvr_single_add_video(k, videos, form_url, box, isPaused) {
            if (box.attr('work') != 1) {
                box.doClose();
                return false;
            }
            if (box.attr('pause') != 'false') {
                return false;
            }

            var spinner_id = box.attr('spinner_id');


            box.attr('k', k);
            if (k >= videos.length) {

                var execution_time = (performance.now() - box.attr('start_timestamp')) / 1000;
                execution_time = parseFloat(execution_time.toFixed(3));

                var msg = '<strong>' + videos.length + '</strong> ' + wpvr_localize.videos_processed + ' in ' + execution_time + ' sec.';
                msg += '<br/> ' + box.attr('count_added') + ' ' + wpvr_localize.videos_added + '';
                msg += ' and ' + box.attr('count_skipped') + ' ' + wpvr_localize.videos_skipped + '.';
                msg += '<br/>' + wpvr_localize.videos_added_successfully_additional;

                box.stopHighlight();
                box.doClose();
                var box2 = wpvr_show_loading_new({
                    title: wpvr_localize.work_completed,
                    text: msg,
                    pauseButton: wpvr_localize.ok_button,
                });

                box2.doPause(function () {
                    box2.doClose();
                    wpvr_remove_loading_spinner($('#' + spinner_id));
                });

                box2.doRemove(function () {
                    wpvr_remove_loading_spinner($('#' + spinner_id));
                });

                return false;
            }
            var video = videos[k];

            if (box.attr('is_deferred') == "1") var is_deferred_get = '1';
            else var is_deferred_get = '0';

            $('.wpvr_video#video_' + video.div_id).addClass('adding');
            var session = box.attr('session');
            var vid = video.video_id;
            $.ajax({
                type: 'POST',
                url: wpvr_globals.ajax_url,
                data: {
                    action: 'test_add_single_video',
                    video_id: video.video_id,
                    session: session,
                    is_deferred: is_deferred_get,
                },
                success: function (response) {
                    response = wpvr_get_json(response);

                    if (response.status == 0) {
                        box.stopHighlight();
                        box.doClose();
                        $('.wpvr_video[video_id=' + vid + ']').removeClass('adding');

                        var box2 = wpvr_show_loading_new({
                            title: 'WP Video Robot - ERROR',
                            text: response.msg,
                            pauseButton: wpvr_localize.ok_button,
                        });
                        box2.doPause(function () {
                            box2.doClose();
                            wpvr_remove_loading_spinner($('#' + spinner_id));
                        });
                        box2.doRemove(function () {
                            wpvr_remove_loading_spinner($('#' + spinner_id));
                        });
                        return false;
                    }
                    data = response.data;

                    var new_text = wpvr_localize.work_in_progress + "... <br/><br/> <strong>" + data.title + '</strong>';
                    box.doText(new_text);

                    if (response.status == 1) {

                        var p = Math.round((parseInt(k) + 1) / videos.length * 100);

                        box.doProgress({
                            pct: p,
                            text: (k + 1) + ' / ' + videos.length,
                        });


                        var added_video = $('.wpvr_video#video_' + video.div_id);
                        added_video.removeClass('adding').addClass('added');
                        added_video.webuiPopover('destroy');
                        $('.wpvr_video_edit_btn', added_video).attr('href', data.edit_link.replace('&amp;', '&'));
                        $('.wpvr_video_view_btn', added_video).attr('href', data.view_link.replace('&amp;', '&'));
                        $('.wpvr_video_edit_wrap', added_video).fadeIn();
                        $('.wpvr_video_cb', added_video).remove();
                        k++;

                        var count_added = box.attr('count_added');
                        count_added++;
                        box.attr('count_added', count_added);

                        wpvr_single_add_video(k, videos, form_url, box, is_deferred);

                    } else if (response.status == -1) {
                        var p = Math.round((parseInt(k) + 1) / videos.length * 100);
                        box.doProgress({
                            pct: p,
                            text: (k + 1) + ' / ' + videos.length,
                        });


                        var skipped_video = $('.wpvr_video#video_' + video.div_id);
                        skipped_video.removeClass('adding').removeClass('checked').addClass('skipped');
                        $('.wpvr_video_cb', skipped_video).remove();
                        var count_skipped = box.attr('count_skipped');
                        count_skipped++;
                        box.attr('count_skipped', count_skipped);
                        k++;
                        wpvr_single_add_video(k, videos, form_url, box, is_deferred);

                    } else {
                        $('.wpvr_video[video_id=' + vid + ']').removeClass('adding');
                        var boxError = wpvr_show_loading_new({
                            title: 'WP Video Robot - ERROR',
                            text: wpvr_localize.errorJSON + '<br/>' + response.msg,
                        });
                    }

                    $('.wpvr_count_checked').html(' ');
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    $('.wpvr_video[video_id=' + vid + ']').removeClass('adding');
                    var boxError = wpvr_show_loading_new({
                        title: 'WP Video Robot - ERROR',
                        text: wpvr_localize.errorJSON + '<br/>' + thrownError,
                    });

                }
            });
        }

        function wpvr_single_add_unwanted_video(k, videos, form_url, box, isPaused) {

            if (box.attr('work') != 1) {
                box.doClose();
                return false;
            }
            if (box.attr('pause') != 'false') {
                return false;
            }

            var spinner_id = box.attr('spinner_id');

            box.attr('k', k);
            if (k >= videos.length) {
                box.stopHighlight();
                box.doClose();

                var msg;
                if (box.attr('scope') == 'global') {
                    msg = videos.length + ' ' + wpvr_localize.videos_global_unwanted_successfully + '.';
                } else {
                    msg = videos.length + ' ' + wpvr_localize.videos_source_unwanted_successfully + '.';
                }
                var box2 = wpvr_show_loading_new({
                    title: wpvr_localize.work_completed,
                    text: msg,
                    pauseButton: wpvr_localize.ok_button,
                });

                box2.doPause(function () {
                    box2.doClose();
                    wpvr_remove_loading_spinner($('#' + spinner_id));
                });

                box2.doRemove(function () {
                    wpvr_remove_loading_spinner($('#' + spinner_id));
                });

                return false;
            }
            var video = videos[k];

            $('.wpvr_video#video_' + video.div_id).addClass('adding');
            var session = box.attr('session');
            $.ajax({
                type: 'POST',
                url: wpvr_globals.ajax_url,
                data: {
                    action: 'test_add_unwanted_single_video',
                    video_id: video.video_id,
                    session: session,
                    scope: box.attr('scope'),
                    source_id: video.source_id,
                },
                success: function (response) {
                    response = wpvr_get_json(response);
                    data = response.data;
                    var new_text = wpvr_localize.work_in_progress + "... <br/><br/> <strong>" + data.title + '</strong>';
                    box.doText(new_text);

                    if (response.status == 1) {
                        var p = Math.round((parseInt(k) + 1) / videos.length * 100);
                        box.doProgress({
                            pct: p,
                            text: (k + 1) + ' / ' + videos.length,
                        });


                        var added_video = $('.wpvr_video#video_' + video.div_id);
                        added_video.removeClass('adding').addClass('unwanted');
                        $('.wpvr_video_cb', added_video).remove();
                        k++;
                        wpvr_single_add_unwanted_video(k, videos, form_url, box);

                    } else {
                        var boxError = wpvr_show_loading_new({
                            title: 'WP Video Robot - ERROR',
                            text: wpvr_localize.errorJSON + '<br/>' + response.msg,
                        });
                    }

                    $('.wpvr_count_checked').html(' ');
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    var boxError = wpvr_show_loading_new({
                        title: 'WP Video Robot - ERROR',
                        text: wpvr_localize.errorJSON + '<br/>' + thrownError,
                    });

                }
            });
        }

        function wpvr_show_loading_new(args) {
            var box;
            var token = wpvr_random_token(20);

            if (args.hasOwnProperty('isModal') && args.isModal === true) {
                var isModal = true;
                var is_modal_class = 'is_modal';
            } else {
                var isModal = false;
                var is_modal_class = '';
            }

            if (args.hasOwnProperty('progressBar') && args.progressBar === true) {
                var progressBar =
                    '<div class="wpvr_loading_progress">' +
                    '<div class="wpvr_loading_progress_text"></div>' +
                    '<div class="wpvr_loading_progress_p"></div>' +
                    '</div>';
            } else {
                var progressBar = '';
            }

            if (args.hasOwnProperty('cancelButton')) {
                var cancelButton = '<div class="wpvr_button wpvr_loading_cancel">' + args.cancelButton + '</div>';
            } else {
                var cancelButton = '';
            }

            if (args.hasOwnProperty('title')) var title = args.title;
            else var title = '';

            if (args.hasOwnProperty('boxClass')) var boxClass = args.boxClass;
            else var boxClass = '';

            if (args.hasOwnProperty('width')) var width = args.width;
            else var width = '30%';

            if (args.hasOwnProperty('height')) var height = args.height;
            else var height = 'auto';

            if (args.hasOwnProperty('maskClass')) var maskClass = args.maskClass;
            else var maskClass = '';

            if (args.hasOwnProperty('text')) var text = args.text;
            else var text = '';

            if (args.hasOwnProperty('pauseButton')) {
                var pauseButton = '<div class="wpvr_button wpvr_loading_pause">' + args.pauseButton + '</div>';
            } else {
                var pauseButton = '';
            }

            var string =
                '<div class = "wpvr_loading_box ' + boxClass + ' ' + is_modal_class + ' " id="' + token + '" >' +
                '<div class="wpvr_loading_msg">' +
                '<div class="wpvr_loading_msg_title">' + title + '</div>' +
                '<div class="wpvr_loading_close"></div>' +
                '<div class="wpvr_loading_msg_text">' + text + '</div>' +
                '<div class="wpvr_loading_footer">' +
                progressBar +
                cancelButton +
                pauseButton +
                '</div>' +
                '</div>' +
                '</div>' +
                '<div class="wpvr_loading_mask ' + maskClass + '"></div>'
            ;
            box = $(string);
            box.css('display', 'none');
            $('.wpvr_loading_msg', box).css('width', width);
            if (height != 'auto') {
                $('.wpvr_loading_msg', box).css('height', height);
                $('.wpvr_loading_msg_text', box).css('height', '86%').css('overflow-y', 'scroll').css('padding', '0 10px 0 0');
                $('.wpvr_loading_pause', box).css('margin-top', '1em').css('float', 'right');
                $('.wpvr_loading_cancel', box).css('margin-top', '1em').css('margin-left', '0').css('float', 'left');
                $('.wpvr_loading_msg_title', box).css('margin-bottom', '1em');
            }
            $('#adminmenuwrap').css('z-index', 100);
            $('body').append(box);
            box.fadeIn('fast', 'swing');

            $('.wpvr_loading_msg', box).center();
            wpvr_correct_scrolling();

            //Closing Dialog
            $.fn.doClose = function (e) {
                var boxin = this;
                var msg = $('.wpvr_loading_msg', boxin);
                var mask = $('.wpvr_loading_mask');
                msg.fadeOut('fast', "swing", function () {
                    mask.fadeOut('fast', function () {
                        boxin.remove();
                    })
                });
            };

            //Hiding Dialog
            $.fn.doHide = function (e) {
                var boxin = this;
                var msg = $('.wpvr_loading_msg', boxin);
                var mask = $('.wpvr_loading_mask');
                msg.fadeOut('fast', "swing", function () {
                    mask.fadeOut('fast', function () {
                    })
                });
            };

            //Showing Dialog
            $.fn.doShow = function (e) {
                var boxin = this;
                var msg = $('.wpvr_loading_msg', boxin);
                var mask = $('.wpvr_loading_mask');
                msg.fadeIn('fast', "swing", function () {
                    mask.fadeIn('fast', function () {
                    })
                });
            };
            //Highlighiting Progress Bar
            $.fn.doHighlight = function (data) {
                var progress = $('.wpvr_loading_progress_p', this);
                var highlight_interval = setInterval(function () {
                    progress.toggleClass('highlight');
                }, 300);
                this.attr('hInt', highlight_interval);
                return highlight_interval;
            };
            //Stop Highlighiting Progress Bar
            $.fn.stopHighlight = function (h) {
                var h = this.attr('hInt');
                clearInterval(h);
                $('.wpvr_loading_progress_p', this).removeClass('highlight');
            };
            //Make a progress
            $.fn.doProgress = function (data) {
                var progressBack = $('.wpvr_loading_progress_text', this);
                var progress = $('.wpvr_loading_progress_p', this);
                if (data.hasOwnProperty('pct')) progress.css({'width': data.pct + '%'});
                if (data.hasOwnProperty('text')) progressBack.html(data.text);
            };
            //Write a text
            $.fn.doText = function (text) {
                $('.wpvr_loading_msg_text', this).html(text);
            };
            //Cancel Function
            $.fn.doCancel = function (fct) {
                $('.wpvr_loading_cancel', this).bind('click', fct);
            };
            //Pause Function
            $.fn.doPause = function (fct) {
                $('.wpvr_loading_pause', this).bind('click', fct);
            };

            $.fn.doRemove = function (fct) {
                this.on("remove", fct);
            };

            //Default closing button action
            $('.wpvr_loading_close', box).bind('click', function () {
                if (args.hasOwnProperty('cancelButton')) $('.wpvr_loading_cancel', box).trigger('click');
                else box.remove();
            });

            $(document).keyup(function (e) {
                if (e.keyCode == 27) {
                    $('.wpvr_loading_close', box).trigger('click');
                }
            });

            //Defining Modal Property
            if (isModal === false) {
                var mask = $('.wpvr_loading_mask');
                mask.click(function (e) {
                    e.preventDefault();
                    box.doClose();
                });
            }

            var return_box = box;
            $('.wpvr_wrap').attr('box_id', token);

            if (typeof box !== 'undefined') return box;
            else return token;

        }

        //Handle Manage Videos Refreshing
        function wpvr_manage_refresh(newPages, updatePages, filter_page) {

            updatePages = typeof updatePages !== 'undefined' ? updatePages : false;
            newPages = typeof newPages !== 'undefined' ? newPages : false;
            filter_page = typeof filter_page !== 'undefined' ? filter_page : 1;

            var form = $('form.wpvr_manage_main_form');
            var formData = form.serializeArray();

            formData.push({
                name: 'action',
                value: 'refresh_manage_videos',
            });
            formData.push({
                name: 'get_filter_page',
                value: filter_page,
            });

            var msgBox = $('.wpvr_manage_page_message');
            var pageBox = $('.wpvr_manage_page_select');

            var boxWaiting = wpvr_show_loading_new({
                title: 'WP Video Robot',
                text: wpvr_localize.loadingCenter,
            });

            $.ajax({
                type: 'POST',
                url: wpvr_globals.ajax_url,
                data: formData,

                success: function (data) {
                    boxWaiting.remove();
                    $json = wpvr_get_json(data);
                    $data = $json.data;

                    $('html, body').animate({scrollTop: 0}, 'slow');

                    if ($('.wpvr_manage_content').attr('is_fresh') == '1')
                        $('.wpvr_manage_content').attr('is_fresh', '0');


                    //Generates the msg
                    if ($data.total_results == 0) {
                        msgBox.html('');
                        pageBox.html('');
                        $('.wpvr_manage_content').html($data.no_results_msg);
                        return false;
                    }

                    msgBox.html(
                        wpvr_localize.showing + ' <b> ' +
                        $data.show_start + '-' +
                        $data.show_end + ' </b> ' +
                        wpvr_localize.on + ' <b> ' +
                        $data.total_results + ' </b> ' +
                        wpvr_localize.items + '.'
                    );

                    //Genrates Pages Select
                    if (newPages) wpvr_manage_render_pages('1', $data.last_page, pageBox);
                    if (updatePages) wpvr_manage_render_pages($data.actual_page, $data.last_page, pageBox);

                    $('.wpvr_manage_content').html($data.html);
                    if ($data.debug) console.log($data.debug);
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    boxWaiting.remove();
                    var boxError = wpvr_show_loading_new({
                        title: 'WP Video Robot - ERROR',
                        text: wpvr_localize.errorJSON + '<br/>' + thrownError,
                    });

                }
            });
        }

        //Recursive Merging Items
        function wpvr_merge_items(k, items, box) {

            box.attr('k', k);
            var url = box.attr('url');
            var buffer = 1;

            if (k >= items.length) {
                box.stopHighlight();
                box.doClose();

                var box2 = wpvr_show_loading_new({
                    title: wpvr_localize.work_completed,
                    text: items.length + ' ' + wpvr_localize.videos_processed_successfully + '.',
                    pauseButton: wpvr_localize.ok_button,
                });
                box2.doPause(function () {
                    box2.doClose();
                    wpvr_manage_refresh(false, true);
                });
                return false;
            }

            var video = items[k];
            var videos = {};
            for (var i = 0; i < Math.min(items.length, buffer); i++) {
                videos[i] = (items[k + i]);
            }

            $.ajax({
                type: 'POST',
                url: url + '?wpvr_wpload&merge_items',
                data: {
                    'items': items,
                },
                success: function (r) {
                    r = wpvr_get_json(r);
                    if (r.data.status != 'error') {
                        var kPlus = Math.min(items.length, parseInt(parseInt(k) + parseInt(buffer)));
                        var progress = (parseInt(kPlus / items.length) * 100) + '%';
                        var p = Math.round(kPlus + 1 / items.length * 100);
                        box.doProgress({
                            pct: p,
                            text: (kPlus) + ' / ' + items.length,
                        });

                        wpvr_merge_items(kPlus, items, box)
                    } else {
                        alert('OUPS! There has been an error merging duplicates.');
                    }
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    alert(thrownError);
                }
            });
        }

        //Recursive Import Videos
        function wpvr_single_import_video(k, items, box) {
            box.attr('k', k);
            var url = box.attr('url');
            var buffer = parseInt(box.attr('buffer'));

            if (k >= items.length) {
                box.stopHighlight();
                box.doClose();

                var box2 = wpvr_show_loading_new({
                    title: wpvr_localize.work_completed,
                    text: items.length + ' ' + wpvr_localize.videos_processed_successfully + '.',
                    pauseButton: wpvr_localize.ok_button,
                });
                box2.doPause(function () {
                    box2.doClose();
                    wpvr_manage_refresh(false, true);
                });
                return false;
            }

            var video = items[k];
            var videos = {};
            for (var i = 0; i < Math.min(items.length, buffer); i++) {
                videos[i] = (items[k + i]);
            }

            $.ajax({
                type: 'POST',
                url: url + '?wpvr_wpload&import_single_video',
                data: {
                    'items': videos,
                },
                success: function (r) {
                    r = wpvr_get_json(r);
                    if (r.status != 'error') {
                        var kPlus = Math.min(items.length, parseInt(parseInt(k) + parseInt(buffer)));
                        var progress = (parseInt(kPlus / items.length) * 100) + '%';
                        var p = Math.round(kPlus + 1 / items.length * 100);

                        box.doProgress({
                            pct: p,
                            text: (kPlus) + ' / ' + items.length,
                        });

                        wpvr_single_import_video(kPlus, items, box)
                    } else {
                        alert('OUPS! There has been an error !');
                    }
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    alert(thrownError);
                }
            });
        }

        //Recursive single Bulk Video Action
        function wpvr_single_bulk_action(k, items, box) {
            box.attr('k', k);
            var url = box.attr('url');
            var action = box.attr('action');

            if (k >= items.length) {
                box.stopHighlight();
                box.doClose();

                var box2 = wpvr_show_loading_new({
                    title: wpvr_localize.work_completed,
                    text: items.length + ' ' + wpvr_localize.videos_processed_successfully + '.',
                    pauseButton: wpvr_localize.ok_button,
                });
                box2.doPause(function () {
                    box2.doClose();
                    wpvr_manage_refresh(false, true);
                });
                return false;
            }

            var video_id = items[k];

            $('.wpvr_video#video_' + video_id).addClass('adding');

            $.ajax({
                type: 'POST',
                url: wpvr_globals.ajax_url,
                data: {
                    video_id: video_id,
                    action: 'bulk_single_action',
                    bulk_action: action,
                },
                success: function (data) {
                    var $json = wpvr_get_json(data);
                    if ($json.status == 1) {
                        var progress = (parseInt((k + 1) / items.length) * 100) + '%';
                        var p = Math.round((parseInt(k) + 1) / items.length * 100);

                        box.doProgress({
                            pct: p,
                            text: (k + 1) + ' / ' + items.length,
                        });

                        $('.wpvr_video#video_' + video_id).removeClass('adding').addClass('added');
                        $('.wpvr_video_cb[name=' + video_id + ']').remove();
                        k++;
                        wpvr_single_bulk_action(k, items, box)
                    } else {
                        alert('OUPS! There has been an error !');
                    }

                },
                error: function (xhr, ajaxOptions, thrownError) {
                    alert(thrownError);
                }
            });
        }

        $('.wpvr_do_dialog').click(function (e) {
            e.preventDefault();
            var btn = $(this);
            var title = btn.attr('dialog_title');
            var content = btn.attr('dialog_content');
            var button = btn.attr('dialog_button');
            var isModal = btn.attr('dialog_modal');

            if (title == '' || title == undefined) title = wpvr_localize.wp_video_robot;
            if (button == '' || button == undefined) button = wpvr_localize.ok_button;
            if (content == undefined) content == 'Empty message.';
            if (isModal == undefined || isModal != 1) isModal = false;
            else isModal = true;

            var boxDialog = wpvr_show_loading({
                title: title,
                text: content,
                pauseButton: button,
                isModal: isModal,
            });
            boxDialog.doPause(function () {
                boxDialog.remove();
            });


        });

        $('.isMaster').each(function () {
            var wrap = $(this);
            var slaves = [];
            if (typeof wrap.attr('masterOf') !== 'undefined') {
                slaves = wrap.attr('masterOf').split(',');
            }

            var mval = wrap.attr('masterValue');
            var type = wrap.attr('option_type');
            if (typeof wrap.attr('tabMasterOf') !== 'undefined') var tabSlaves = wrap.attr('tabMasterOf').split(',');
            else var tabSlaves = [];

            if (wrap.css('display') == 'none') var masterVisible = false;
            else var masterVisible = true;


            if (type == 'switch') {

                wrap.delegate('.wpvr_switch_btn', 'lcs-statuschange', function () {
                    if ($(this).is(':checked')) {
                        if (masterVisible) var is_on = true;
                        else var is_on = false;
                    } else var is_on = false;
                    wrap.removeClass('on').removeClass('off');
                    if (is_on) {
                        wrap.addClass('on');
                    } else {
                        wrap.addClass('off');
                    }

                    wpvr_control_slaves(slaves, is_on);
                    wpvr_control_tab_slaves(tabSlaves, is_on);
                });
                $('.wpvr_switch_btn', wrap).each(function () {
                    if ($(this).prop('checked')) var is_on = true;
                    else var is_on = false;
                    wrap.removeClass('on').removeClass('off');
                    if (is_on) {
                        wrap.addClass('on');
                    } else {
                        wrap.addClass('off');
                    }
                    wpvr_control_slaves(slaves, is_on);
                    wpvr_control_tab_slaves(tabSlaves, is_on);
                });


                $('.wpvr-onoffswitch', wrap).trigger('click').trigger('click');
                $('.wpvr-onoffswitch', wrap).bind('changeClass', function () {
                    if ($(this).hasClass('wpvr-onoffswitch-checked')) {
                        if (masterVisible) var is_on = true;
                        else var is_on = false;
                    } else var is_on = false;
                    wpvr_control_slaves(slaves, is_on);
                    wpvr_control_tab_slaves(tabSlaves, is_on);
                });

                $('.wpvr_option_button>.wpvr-onoffswitch', wrap).each(function () {
                    if ($(this).hasClass('wpvr-onoffswitch-checked')) var is_on = true;
                    else var is_on = false;
                    wpvr_control_slaves(slaves, is_on);
                    wpvr_control_tab_slaves(tabSlaves, is_on);
                });


            }

            if (type == 'select') {

                $('.wpvr_option_select', wrap).bind('change', function () {
                    if ($(this).attr('value') == mval) var is_on = true;
                    else var is_on = false;
                    wpvr_control_slaves(slaves, is_on, $(this).attr('value'));
                });

                $('.wpvr_option_select', wrap).each(function () {
                    if ($(this).attr('value') == mval) var is_on = true;
                    else var is_on = false;
                    wpvr_control_slaves(slaves, is_on, $(this).attr('value'));
                });


            }
        });

        $('.wpvr_load_asyncr').each(function () {
            var wrap = $(this);
            var url = wrap.attr('url');
            var method = wrap.attr('method');
            if (method == undefined) method = 'timeout';

            if (method == 'timeout') {
                setTimeout(function () {
                    var boxWaiting = wpvr_show_loading({
                        title: 'WP Video Robot',
                        text: wpvr_localize.loadingCenter,
                    });
                    $.ajax({
                        type: 'GET',
                        url: url + '',
                        success: function (data) {
                            //$data = wpvr_get_json( data );
                            boxWaiting.remove();
                            wrap.html(data);
                            $('.wpvr_nav_tab#a', wrap).trigger('click');
                            wrap.fadeIn();
                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            alert(thrownError);
                        }
                    });
                }, 1000);
            } else {
                wrap.click(function (e) {
                    e.preventDefault();
                    var boxWaiting = wpvr_show_loading({
                        title: 'WP Video Robot',
                        text: wpvr_localize.loadingCenter,
                    });
                    $.ajax({
                        type: 'GET',
                        url: url + '',
                        success: function (data) {
                            var response = wpvr_get_json(data);

                            boxWaiting.remove();
                            var boxResult = wpvr_show_loading({
                                title: 'WP Video Robot',
                                text: response.msg.msg,
                                pauseButton: 'OK',
                                isModal: false,
                            });
                            boxResult.doPause(function () {
                                boxResult.remove();
                            });
                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            alert(thrownError);
                        }
                    });
                });
            }
        });

        $('.wpvr_load_asyncr_ajax').each(function () {
            var wrap = $(this);
            var _wrap = this;
            var action = wrap.attr('action');
            var method = wrap.attr('method');
            var json = wrap.attr('json');
            if (method == undefined) method = 'timeout';
            if (json == undefined) json = false;
            else json = json == 1 ? true : false;


            var params = [];
            params.push({name: 'action', value: wrap.attr('action'),});
            params.push({name: 'json', value: json,});
            $.each(_wrap.attributes, function (index, attr) {
                if (attr.name.substr(0, 5) == 'data-') {
                    params.push({
                        name: attr.name.replace('data-', ''),
                        value: attr.value,
                    });
                }
            });
            if (method == 'timeout') {
                setTimeout(function () {
                    var boxWaiting = wpvr_show_loading({
                        title: 'WP Video Robot',
                        text: wpvr_localize.loadingCenter,
                    });
                    $.ajax({
                        type: 'POST',
                        data: params,
                        url: wpvr_globals.ajax_url,
                        success: function (data) {
                            if (json) {
                                var $json = wpvr_get_json(data);
                                var output = $json.msg;
                            } else {
                                var output = data;
                            }
                            boxWaiting.remove();
                            wrap.html(output);
                            $('.wpvr_nav_tab#a', wrap).trigger('click');
                            wrap.fadeIn();
                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            alert(thrownError);
                        }
                    });
                }, 1000);
            } else {
                wrap.click(function (e) {

                    e.preventDefault();
                    var boxWaiting = wpvr_show_loading({
                        title: 'WP Video Robot',
                        text: wpvr_localize.loadingCenter,
                    });
                    $.ajax({
                        type: 'POST',
                        data: params,
                        url: wpvr_globals.ajax_url,
                        success: function (data) {
                            if (json) {
                                var $json = wpvr_get_json(data);
                                var output = $json.msg;
                            } else {
                                var output = data;
                            }
                            boxWaiting.remove();
                            var boxResult = wpvr_show_loading({
                                title: 'WP Video Robot',
                                text: output,
                                pauseButton: 'OK',
                                isModal: false,
                            });
                            boxResult.doPause(function () {
                                boxResult.remove();
                            });
                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            alert(thrownError);
                        }
                    });
                });
            }
        });

        $('.wpvr_metabox_button').each(function () {
            var btn = $(this);
            var url = btn.attr('url');

            btn.click(function (e) {
                e.preventDefault();

                if (btn.hasClass('wpvr_isLoading')) {
                    return false;
                }
                var spinner = wpvr_add_loading_spinner(btn, 'pull-right');

                if (btn.hasClass('run')) {
                    wpvr_confirm(
                        wpvr_localize.confirm_run_sources,
                        function () { //YES FCT
                            wpvr_remove_loading_spinner(spinner);
                            if (btn.hasClass('sameWindow')) window.location.href = url;
                            else window.open(url);
                        },
                        wpvr_localize.yes,
                        function () {
                            wpvr_remove_loading_spinner(spinner);
                        },
                        wpvr_localize.cancel_button
                    );
                } else {
                    wpvr_remove_loading_spinner(spinner);
                    if (btn.hasClass('test') && btn.attr('ready') != '1') {
                        var box2 = wpvr_show_loading_new({
                            title: wpvr_localize.wp_video_robot,
                            text: wpvr_localize.save_source_first,
                            pauseButton: wpvr_localize.save_source,
                            cancelButton: wpvr_localize.cancel_button,
                        });
                        box2.doPause(function () {
                            box2.doClose();
                            $('#wpvr_save_source_btn').trigger('click');
                        });
                        box2.doCancel(function () {
                            box2.doClose();
                        });
                    } else {
                        if (btn.hasClass('sameWindow')) window.location.href = url;
                        else window.open(url);
                    }
                }
            });
        });

        $('select[name=filler_from]').each(function () {
            var select = $(this);
            select.change(function () {
                var s = select.attr('value');
                if (s == 'custom_data') $('#filler_from_custom').fadeIn();
                else $('#filler_from_custom').hide();
            });
        });

        $('.wpvr_selectize_list').each(function () {
            var field = $(this);
            var maxItems = field.attr('maxItems');
            var verifyEmail = field.hasClass('verifyEmail');
            var selectized = field;
            var $selectized = selectized.selectize({
                delimiter: ',',
                maxItems: maxItems,
                persist: false,
                create: function (input) {
                    if (verifyEmail) {
                        if (wpvr_validate_email(input)) return {value: input, text: input};
                        else {
                            var boxError = wpvr_show_loading({
                                title: wpvr_localize.wp_video_robot,
                                text: 'Please enter a valid email address.',
                                pauseButton: wpvr_localize.ok_button,
                                isModal: false,
                            });
                            boxError.doPause(function () {
                                boxError.remove();
                            });
                            return {};
                        }

                    } else {
                        return {value: input, text: input};
                    }
                }
            });
        });

        $('.wpvr_cmb_selectize').each(function () {
            var field = $(this);
            var maxItems = field.attr('maxItems');
            var selectized = $('.cmb_select', field);
            var handler_id = field.attr('service');

            if (field.hasClass('createItems')) var createItems = true;
            else var createItems = false;

            if (handler_id == '') {
                if (!createItems) var handler = $('#wpvr_source_postCats');
                else var handler = $('#wpvr_source_postTags');
            } else {
                var handler = $('#' + handler_id);
            }

            var field_id = field.attr('service');
            if (field_id) var handler = $('#' + field_id);

            var $string = handler.attr('value').trim();

            // Correction for old sources
            if ($string.indexOf('"') == '-1') {
                $string = '["' + $string + '"]';
            }

            if ($string != undefined && $string.length != 0) var selected_items = JSON.parse($string);
            else selected_items = false;

            if (field.hasClass('createItems')) var createItems = true;
            else var createItems = false;

            if (maxItems != '') {
                if (!createItems) {
                    var $selectized = selectized.selectize({
                        maxItems: maxItems,
                        items: selected_items,
                    });
                } else {
                    var $selectized = selectized.selectize({
                        items: selected_items,
                        delimiter: ',',
                        maxItems: maxItems,
                        persist: false,
                        create: function (input) {
                            return {value: input, text: input};
                        },
                    });
                }
            } else {
                if (selected_items != false) {
                    $selectized = selectized.selectize({
                        maxItems: null,
                        items: selected_items,
                    });
                } else {
                    $selectized = selectized.selectize({
                        maxItems: null,
                        items: [],
                    });
                }
            }


            function selectize_handler(obj) {

                var selectedItems = [];
                $('option', obj.currentTarget).each(function () {
                    selectedItems.push($(this).attr('value'));
                });
                var str = JSON.stringify(selectedItems, null, 2);

                handler.attr('value', str);
            }

            if (field.hasClass('setDefault')) {
                $selectized.selectize.setValue('default');
            }
            $selectized.on('change', selectize_handler);
            $selectized.on('initialize', selectize_handler);
        });

        $('#wpvr_test_form').fadeIn();

        $('.wpvr_show_after_load').fadeIn();

        $('#wpvr_options').each(function () {
            var wrap = $(this);
            $('.wpvr_nav_tab ').click(function (e) {
                e.preventDefault();
                var navtab = $(this);

                $('.wpvr_nav_tab').removeClass('active');
                navtab.addClass('active');

                $('.wpvr_options_section').hide();
                $('.wpvr_options_section[section=' + navtab.attr('id') + ']').fadeIn();

            })
        });

        $('#wpvr_options_permalinkBase').change(function () {
            var c = $(this).attr('value');
            var content = $('#wpvr_options_customPermalinkBase');
            if (c == 'custom') content.fadeIn();
            else content.fadeOut();
        });
        $('#wpvr_options_enableRewriteRule').change(function () {
            var c = $(this).prop('checked');
            var content = $('.wpvr_options_enableRewriteRule_helper');
            if (c) content.fadeIn();
            else content.fadeOut();
        });
        $('#wpvr_options_enableContentPrefix').change(function () {
            var c = $(this).prop('checked');
            var content = $('#wpvr_options_contentPrefix');
            if (c) content.fadeIn();
            else content.fadeOut();
        });
        $('#wpvr_options_enableContentSuffix').change(function () {
            var c = $(this).prop('checked');
            var content = $('#wpvr_options_contentSuffix');
            if (c) content.fadeIn();
            else content.fadeOut();
        });

        $('.__wp-switch-editor').click(function (e) {
            var btn = $(this);
            return false;


            var x = btn.attr('id').split('-')[0];
            var wrap = $('#wp-' + x + '-wrap');
            wrap.removeClass('html-active').removeClass('tmce-active');
            if (btn.hasClass('switch-tmce')) {
                wrap.addClass('tmce-active');
            } else if (btn.hasClass('switch-html')) {
                wrap.addClass('html-active');
            }

        });

        $('#wpvr_filler_list').each(function () {
            wpvr_filler_update();
        });

        $('body').on('click', '.wpvr_filler_remove', function (e) {
            e.preventDefault();
            var k = $(this).attr('k');
            var url = $(this).attr('url');

            wpvr_confirm(
                wpvr_localize.confirm_remove_filler,
                function () { //YES FCT
                    $.ajax({
                        type: 'POST',
                        url: wpvr_globals.ajax_url,
                        data: {
                            action: 'remove_filler',
                            k: k,
                        },
                        success: function (data) {
                            $('.filler[k=' + k + ']').fadeOut().remove();
                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            alert(thrownError);
                        }
                    });
                },
                wpvr_localize.yes,
                function () {
                },
                wpvr_localize.cancel_button
            );

        });

        $('.wpvr_field_selectize').each(function () {
            var select = $(this);
            if (select.attr('maxItems') != '') {
                var selected_items = [];
                $('option', select).each(function () {
                    if ($(this).attr('c') == '1')
                        selected_items.push($(this).attr('value'));
                });
                var $select = select.selectize({
                    maxItems: select.attr('maxItems'),
                    items: selected_items,
                });
            } else {
                select.selectize();
            }
        });

        $('.wpvr_filters_toggle').each(function () {
            var btn = $(this);
            var wrap = $('.wpvr_filters_wrap');
            var superwrap = $('.tablenav.top');
            var count = 0;
            btn.click(function (e) {
                e.preventDefault();
                btn.toggleClass('on');
                superwrap.toggleClass('on');
            });

            $('.wpvr_filter_dropdown', wrap).each(function () {
                if ($(this).hasClass('active')) {
                    count++;
                }
            });

            $('.wpvr_filter_input', wrap).each(function () {
                if ($(this).hasClass('active')) {
                    count++;
                }
            });

            if (count > 0) {
                $('.wpvr_filters_count', btn).html('(' + count + ')');
                $('.wpvr_filters_toggle').trigger('click');
            }
        });

        $('.wpvr_filters_wrap').each(function () {
            var wrap = $(this);

            $('.wpvr_admin_filters_button.refine', wrap).click(function (e) {
                e.preventDefault();
                var spinner = wpvr_add_loading_spinner($(this));
                $('#post-query-submit').trigger('click');
            });

            $('.wpvr_admin_filters_button.clear', wrap).click(function (e) {
                e.preventDefault();
                $('.wpvr_filter_dropdown_input ', wrap).attr('value', '');
                $('.wpvr_filter_dropdown_wrap ', wrap).each(function () {
                    var $select = wpvr_dropdown_fields[$(this).attr('token')][0].selectize;
                    $select.clear();
                    $('.wpvr_admin_filters_input').attr('value', '');
                    $('#cat.postform').val('0');
                    $('#filter-by-date').val('0');
                });
            });
        });

        $('body').on('click', '#wpvr_filler_delete_all', function (e) {
            e.preventDefault();
            var btn = $(this);
            var url = btn.attr('url');

            if (btn.hasClass('wpvr_loading')) {
                return false;
            }

            var spinner = wpvr_add_loading_spinner(btn, 'pull-right');
            var is_demo = $(this).attr('is_demo');

            if (is_demo == '1') {
                var boxDemo = wpvr_show_loading({
                    title: wpvr_localize.wp_video_robot,
                    text: 'This is a demo version of WP Video Robot.<br/>For security reasons, you cannot change the options.<br/> Hope you understand.',
                    pauseButton: wpvr_localize.ok_button,
                    isModal: false,
                });
                boxDemo.doPause(function () {
                    boxDemo.remove();
                });
                boxDemo.doRemove(function () {
                    wpvr_remove_loading_spinner(spinner);
                });
                return false;
            }

            wpvr_confirm(
                wpvr_localize.confirm_delete_fillers,
                function () { //YES FCT
                    var boxWaiting = wpvr_show_loading({
                        title: 'WP Video Robot',
                        text: wpvr_localize.loadingCenter,
                    });


                    $.ajax({
                        type: 'POST',
                        url: wpvr_globals.ajax_url,
                        data: {
                            action: 'delete_all_fillers',
                        },
                        success: function (data) {

                            boxWaiting.remove();
                            var boxResult = wpvr_show_loading({
                                title: 'WP Video Robot',
                                text: wpvr_localize.fillers_deleted,
                                cancelButton: wpvr_localize.ok_button,
                                isModal: false,
                            });
                            wpvr_filler_update();
                            boxResult.doCancel(function () {
                                boxResult.remove();
                                wpvr_remove_loading_spinner(spinner);
                            });
                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            alert(thrownError);
                        }
                    });
                },
                wpvr_localize.yes,
                function () {
                    wpvr_remove_loading_spinner(spinner);
                },
                wpvr_localize.cancel_button
            );

        });

        //Deprecated since v1.9.17
        $('body').on('click', '#wpvr_filler_add_from_preset', function (e) {
            e.preventDefault();
            var btn = $(this);
            var url = $(this).attr('url');
            var preset = $('#filler_preset').attr('value');

            if (preset == '') {
                boxError = wpvr_show_loading({
                    title: wpvr_localize.wp_video_robot,
                    text: wpvr_localize.select_preset,
                    pauseButton: wpvr_localize.ok_button,
                    isModal: false,
                });
                boxError.doPause(function () {
                    boxError.remove();
                });
                return false;
            }

            var spinner = wpvr_add_loading_spinner(btn, 'pull-right');

            wpvr_confirm(
                wpvr_localize.confirm_add_from_preset,
                function () { //YES FCT
                    var boxWaiting = wpvr_show_loading({
                        title: 'WP Video Robot',
                        text: wpvr_localize.loadingCenter,
                    });


                    $.ajax({
                        type: 'POST',
                        url: wpvr_globals.ajax_url,
                        data: {
                            action: 'add_fillers_from_preset',
                            preset: preset,
                        },
                        success: function (data) {
                            wpvr_filler_update();
                            boxWaiting.remove();
                            wpvr_remove_loading_spinner(spinner);
                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            alert(thrownError);
                        }
                    });
                },
                wpvr_localize.yes,
                function () {
                    wpvr_remove_loading_spinner(spinner);
                },
                wpvr_localize.cancel_button
            );

        });

        $('.wpvr_addons_by_cats').each(function () {
            var wrap = $(this);
            var cats = $('.wpvr_addons_categories', wrap);
            var grid = $('.wpvr_addons_grid', wrap);

            $('button', cats).click(function (e) {
                e.preventDefault();
                var btn = $(this);
                $('button', cats).removeClass('wpvr_white_button');
                btn.addClass('wpvr_white_button');
                var current_cat = btn.attr('cat');
                $('.wpvr_addon_box', grid).each(function () {
                    var box = $(this);
                    // var c = box.attr('categories').split(',');
                    box.hide();
                    var x = $.inArray(current_cat, box.attr('categories').split(','));
                    if (x == -1) {
                        box.hide();
                    } else {
                        box.fadeIn();
                    }
                });


            });
        });
        $('body').on('click', '#wpvr_filler_run', function (e) {

            e.preventDefault();
            var btn = $(this);
            var url = btn.attr('url');
            if (!btn.hasClass('wpvr_themefix_updater')) {
                var message = wpvr_localize.confirm_run_fillers;
            } else {
                var message = wpvr_localize.confirm_run_fillers + '<br/>' + wpvr_localize.make_sure_you_saved_options;
            }
            wpvr_confirm(
                message,
                function () { //YES FCT
                    var boxWaiting = wpvr_show_loading({
                        title: 'WP Video Robot',
                        text: wpvr_localize.loadingCenter,
                    });

                    var spinner = wpvr_add_loading_spinner(btn, 'pull-right');
                    $.ajax({
                        type: 'POST',
                        url: wpvr_globals.ajax_url,
                        data: {
                            action: 'run_fillers',
                        },
                        success: function (json) {
                            $json = wpvr_get_json(json);
                            $data = $json.data;
                            boxWaiting.remove();
                            var boxResult = wpvr_show_loading({
                                title: 'WP Video Robot',
                                text: $json.msg,
                                isModal: false,
                                pauseButton: wpvr_localize.ok_button,
                            });
                            boxResult.doPause(function () {
                                boxResult.remove();
                                wpvr_remove_loading_spinner(spinner);
                            });
                            boxResult.doRemove(function () {
                                wpvr_remove_loading_spinner(spinner);
                            });

                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            alert(thrownError);
                        }
                    });
                },
                wpvr_localize.yes,
                function () {
                },
                wpvr_localize.cancel_button
            );

        });

        var clipboard = new Clipboard('.wpvr_copy_btn');
        $('.wpvr_copy_btn').click(function (e) {
            e.preventDefault();
        });
        clipboard.on('success', function (e) {
            var btn = $(e.trigger);

            btn.addClass('wpvr_green_button').addClass('done');
            setTimeout(function () {
                btn.removeClass('wpvr_green_button').removeClass('done');
            }, 500);
        });
        clipboard.on('error', function (e) {
            console.log(e);
        });

        $('.wpvr_execute_dataFillers').click(function (e) {
            e.preventDefault();
            var btn = $(this);
        });

        $('#wpvr_filler_add').click(function (e) {
            e.preventDefault();
            var btn = $(this);
            var url = btn.attr('url');
            var form = $('.' + btn.attr('form'));
            var formData = form.serialize();
            var fromInput = $('.wpvr_filler_input[name=filler_from]', form);
            var toInput = $('.wpvr_filler_input[name=filler_to]', form);
            var spinner = wpvr_add_loading_spinner(btn, 'pull-right');

            if (fromInput.attr('value') == '' || toInput.attr('value') == '') {
                var boxError = wpvr_show_loading({
                    title: 'WP Video Robot',
                    pauseButton: wpvr_localize.ok_button,
                    isModal: false,
                    text: wpvr_localize.correct_entry,
                });
                boxError.doPause(function () {
                    boxError.remove();
                    wpvr_remove_loading_spinner(spinner);
                });
                boxError.doRemove(function () {
                    wpvr_remove_loading_spinner(spinner);
                });
                return false;
            }

            $('.wpvr_filler_loading').fadeIn();

            $.ajax({
                type: 'POST',
                url: wpvr_globals.ajax_url,
                data: formData,
                success: function () {
                    wpvr_remove_loading_spinner(spinner);
                    fromInput.attr('value', '');
                    toInput.attr('value', '');
                    $('#filler_from_custom').attr('value', '').hide();
                    wpvr_filler_update();
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    alert(thrownError);
                }
            });


        });

        $('.wpvr_track_dups').click(function (e) {
            e.preventDefault();
            window.open($(this).attr('url'), '_blank');
        });

        function wpvr_apiConnect_update_options(val, deact) {
            if (deact) return false;
            if (val == 'advanced') {
                $('.wizard_wrap').hide();
                $('.advanced_wrap').fadeIn();
            } else {
                $('.wizard_wrap').fadeIn();
                $('.advanced_wrap').hide();
            }
        }

        $('#wpvr_options_apiConnect').change(function () {
            wpvr_apiConnect_update_options($(this).val());
        });
        $('#wpvr_options_apiConnect').trigger('change');
        $('#wpvr_options_apiConnect').each(function () {
            wpvr_apiConnect_update_options($(this).attr('value'));
        });

        $('.wpvr_single_unwanted').click(function (e) {
            e.preventDefault();
            var btn = $(this);
            var icon = $('i', btn);
            var url = btn.attr('url');
            var post_id = btn.attr('post_id');
            var action = btn.attr('action');
            wpvr_startLoading(icon);
            $.ajax({
                url: wpvr_globals.ajax_url,
                type: 'POST',
                data: {
                    action: 'add_remove_unwanted',
                    post_id: post_id,
                    wpvr_action: action,
                },
                success: function (data) {
                    $json = wpvr_get_json(data);

                    wpvr_stopLoading(icon);
                    if ($json.status == 1) {

                        if (action == 'remove') {
                            icon.removeClass('fa-undo').addClass('fa-ban');
                            $('span', btn).html(wpvr_localize.add_to_unwanted);
                            btn.attr('action', 'add');
                            btn.removeClass('wpvr_black_button').addClass('wpvr_red_button');

                        }

                        if (action == 'add') {
                            icon.removeClass('fa-ban').addClass('fa-undo');
                            $('span', btn).html(wpvr_localize.remove_from_unwanted);
                            btn.attr('action', 'remove');
                            btn.addClass('wpvr_black_button').removeClass('wpvr_red_button');
                        }
                    }

                }
            });

        });
        $('.wpvr_sidebar_toggle').click(function (e) {
            e.preventDefault();
            if ($(this).hasClass('on')) {
                $(this).removeClass('on');
                $('.wpvr_manage_box').removeClass('open');
            } else {
                $(this).addClass('on');
                $('.wpvr_manage_box').addClass('open');
            }
        });

        $('.wpvr_get_token').click(function (e) {
            e.preventDefault();
            var opt = $(this).closest('.wpvr_option');
            var url = $(this).attr('auth_url');
            var local = $(this).attr('local');
            var service = $(this).attr('service');
            var token_input_id = $(this).attr('token_input_id');
            var win = window.open(
                url,
                "grant_window",
                "width=730,height=550"
            );

            var pollTimer = window.setInterval(function () {
                try {

                    var q = $.getQueryParameters(win.document.URL);

                    // Custom API access token
                    if (typeof q.register_token !== 'undefined' && typeof q.access_token !== 'undefined' && q.access_token != '') {
                        window.clearInterval(pollTimer);
                        box = wpvr_show_loading({
                            title: wpvr_localize.wp_video_robot,
                            text: service.toUpperCase() + ' ' + wpvr_localize.is_now_connected,
                            pauseButton: wpvr_localize.ok_button,
                            isModal: false,
                            boxClass: 'wpvr_api_grant',
                        });
                        box.doPause(function () {
                            // alert('Closing the Box');
                            box.remove();
                            $('#' + token_input_id).attr('value', q.access_token);
                            $('.wpvr_expire')
                                .removeClass('red')
                                .removeClass('yellow')
                                .removeClass('green')
                                .removeClass('orange')
                                .addClass('green')
                            ;
                            $('.wpvr_expire span').html('TOKEN RENEWED');
                        });
                        $('.wpvr_loading_mask').on('click', function () {
                            alert('Clicking on Mask');
                            $('.wpvr_loading_pause', box).trigger('click');
                        });
                    }
                    //Regular API Wizard Elements
                    if (win.document.URL.indexOf('wpvr.actions.php') != -1) {
                        window.clearInterval(pollTimer);
                        var box = wpvr_show_loading({
                            title: wpvr_localize.wp_video_robot,
                            text: service.toUpperCase() + ' ' + wpvr_localize.is_now_connected,
                            pauseButton: wpvr_localize.ok_button,
                            isModal: false,
                        });
                        box.doPause(function () {
                            box.remove();
                            $('.wpvr_token_state[service=' + service + ']').removeClass('off').addClass('on');
                            $('.wpvr_grid_option[service=' + service + ']').removeClass('off').addClass('on');
                        });

                        $('.wpvr_loading_mask').on('click', function () {
                            $('.wpvr_loading_pause', box).trigger('click');
                        });
                    }
                } catch (e) {
                }
            }, 100);


        });

        $('.wpvr_remove_token').click(function (e) {
            e.preventDefault();
            var service = $(this).attr('service');
            var url = $(this).attr('url');
            var opt = $(this).closest('.wpvr_option');

            wpvr_confirm(
                wpvr_localize.confirm_cancel_access,
                function () { //YES FCT
                    $.ajax({
                        url: wpvr_globals.ajax_url,
                        type: 'POST',
                        data: {
                            service: service,
                            action: 'wpvr_clear_token',
                        },
                        success: function (data) {
                            $('.wpvr_token_state[service=' + service + ']').removeClass('on').addClass('off');
                            $('.wpvr_grid_option[service=' + service + ']').removeClass('on').addClass('off');
                        }
                    });
                },
                wpvr_localize.yes,
                function () {
                },
                wpvr_localize.cancel_button
            );


        });

        $('.wpvr_addon_options_wrapper').each(function () {
            var wrap = $(this);
            var addon_id = $(this).attr('addon_id');
            var form = $('.wpvr_addons_options_form', wrap);

            $('.wpvr_save_addon_options', wrap).each(function () {
                var btn = $(this);
                var url = btn.attr('url');
                var tab = btn.attr('tab');

                btn.click(function (e) {
                    e.preventDefault();

                    //Saving the tinyMCE contents
                    if (typeof(tinyMCE) != "undefined") {
                        for (var i = 0; i < tinymce.editors.length; i++) {
                            tinymce.editors[i].save();
                        }
                    }

                    if (btn.hasClass('wpvr_isLoading')) return false;

                    if ($('.wpvr_save_addon_options.wpvr_isLoading').length > 0) {
                        return false;
                    }

                    var data = form.serializeArray();
                    data.push({
                        name: 'action',
                        value: 'save_addon_options',
                    }, {
                        name: 'tab',
                        value: tab,
                    }, {
                        name: 'id',
                        value: addon_id,
                    });
                    var spinner = wpvr_add_loading_spinner(btn, 'pull-right');
                    $.ajax({
                        type: 'POST',
                        data: data,
                        url: wpvr_globals.ajax_url,
                        success: function (data) {
                            var $data = wpvr_get_json(data);
                            var $done = $data.data;

                            if ($data.status == 1) {
                                var box_ok = wpvr_show_loading({
                                    title: 'WP VIDEO ROBOT',
                                    text: wpvr_localize.addon_options_saved_animated,
                                    cancelButton: wpvr_localize.ok_button,
                                    isModal: false,
                                });
                                box_ok.doCancel(function () {
                                    box_ok.remove();
                                    wpvr_remove_loading_spinner(spinner);
                                    btn.removeClass('wpvr_isLoading');
                                });
                                box_ok.doRemove(function () {
                                    wpvr_remove_loading_spinner(spinner);
                                    $('#addon_update_existing_videos').addClass('wpvr_green_button').fullShake();
                                });
                            }
                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            alert(thrownError);
                        }
                    });
                });
            });

            $('#addon_update_existing_videos', wrap).each(function () {
                var btn = $(this);


                btn.click(function (e) {
                    btn.removeClass('wpvr_green_button');

                    clearInterval(btn.data('anim'));
                    e.preventDefault();
                    var spinner = wpvr_add_loading_spinner(btn, 'pull-left');
                    $.ajax({
                        type: 'POST',
                        data: {
                            action: 'update_existing_videos',
                        },
                        url: wpvr_globals.ajax_url,
                        success: function (data) {
                            var $json = wpvr_get_json(data);
                            wpvr_remove_loading_spinner(spinner);
                            var box_ok = wpvr_show_loading({
                                title: 'WP VIDEO ROBOT',
                                text: wpvr_localize.existing_videos_updated + '<br/><br/>' +
                                wpvr_localize.details + ' : ' +
                                '<div class="job_details">' +
                                $json.data.details +
                                '</divclass>'
                                ,
                                cancelButton: wpvr_localize.ok_button,
                                isModal: false,
                            });
                            box_ok.doCancel(function () {
                                box_ok.remove();
                                location.reload();
                            });
                            box_ok.doRemove(function () {
                                wpvr_remove_loading_spinner(spinner);
                            });
                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            alert(thrownError);
                        }
                    });
                })
            });


            $('.wpvr_reset_addon_options', wrap).each(function () {
                var btn = $(this);
                var url = btn.attr('url');

                var confirm_msg = '';
                confirm_msg += wpvr_localize.addon_options_reset_confirm;
                confirm_msg += ' (' + btn.data('addon') + '). <br/>';
                confirm_msg += wpvr_localize.addon_options_reset_confirm_continue;

                btn.click(function (e) {
                    e.preventDefault();
                    wpvr_confirm(
                        confirm_msg,
                        function () {
                            var spinner = wpvr_add_loading_spinner(btn, 'pull-left');
                            $.ajax({
                                type: 'POST',
                                data: {
                                    action: 'reset_addon_options',
                                    id: addon_id,
                                },
                                url: wpvr_globals.ajax_url,
                                success: function () {
                                    wpvr_remove_loading_spinner(spinner);
                                    var box_ok = wpvr_show_loading({
                                        title: 'WP VIDEO ROBOT',
                                        text: wpvr_localize.addon_options_reset_done,
                                        cancelButton: wpvr_localize.ok_button,
                                        isModal: false,
                                    });
                                    box_ok.doCancel(function () {
                                        box_ok.remove();
                                        location.reload();
                                    });
                                    box_ok.doRemove(function () {
                                        wpvr_remove_loading_spinner(spinner);
                                    });
                                },
                                error: function (xhr, ajaxOptions, thrownError) {
                                    alert(thrownError);
                                }
                            });
                        },
                        wpvr_localize.reset_yes,
                        function () {
                        },
                        wpvr_localize.reset_no
                    );
                });
            });
        });

        $('.wpvr_manage_import').bind('click', function (e) {
            e.preventDefault();
            var form_url = $(this).attr('url');
            var bulk_url = $(this).attr('bulk_url');
            var buffer = $(this).attr('buffer');

            var iForm = '';
            iForm += '<form id="form_import_videos" enctype="multipart/form-data">';
            iForm += '<input type="hidden" name="action" value="wpvr_import_videos">';
            iForm += '<label for="upload">Choose a file </label>';
            iForm += '<input type="file" id="upload" name="uploadedfile" size="25">';
            iForm += '<br/>';
            iForm += '<label>Publish</label> ';
            iForm += '<select name="publishDate">';
            iForm += '	<option value="original">Keep original</option>';
            iForm += '	<option value="now" selected="selected">Publish Now</option>';
            iForm += '</select>';
            iForm += '<br/>';

            iForm += '<label> Reset Views </label>';
            iForm += '<select name="resetViews">';
            iForm += '	<option value="yes">' + wpvr_localize.yes + '</option>';
            iForm += '	<option value="no" selected="selected">' + wpvr_localize.yes + '</option>';
            iForm += '</select>';
            iForm += '<br/>';
            iForm += '<label>Skip Duplicates </label>';
            iForm += '<select name="skipDup">';
            iForm += '	<option value="yes">yes</option>';
            iForm += '	<option value="no" selected="selected">No</option>';
            iForm += '</select>';
            iForm += '</form>';

            var box = wpvr_show_loading({
                title: wpvr_localize.import_videos,
                text: iForm,
                pauseButton: wpvr_localize.import_btn,
                cancelButton: wpvr_localize.cancel_button,
                isModal: false,
            });
            box.doCancel(function () {
                box.remove();

            });
            box.doPause(function () {
                var file = $('#upload').attr('value');
                if (file == '') return false;
                var form = $('#form_import_videos');
                var btn = $('.wpvr_loading_pause');
                var spinner = wpvr_add_loading_spinner(btn);
                var form_data = new FormData(document.getElementById("form_import_videos"));

                return false;
                $.ajax({
                    url: wpvr_globals.ajax_url,
                    type: 'POST',
                    data: form_data,
                    async: false,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function (data) {
                        $data = wpvr_get_json(data);

                        wpvr_remove_loading_spinner(spinner);
                        if ($data.status != 'ok') {
                            if ($data.status == 'invalid') {
                                alert('Invalid File');
                                box.remove();
                                return false;
                            }
                        } else {
                            if ($data.countDup != '0') {
                                // FOUND DUPS
                                if ($data.countDup != $data.count) {
                                    // Found Dups and NEw Videos

                                    wpvr_confirm(
                                        'FOUND ' + $data.countDup + ' Duplicates. CONTINUE ?',
                                        function () { //YES FCT
                                            boxDup.remove();
                                            wpvr_apply_bulk_import($data.items, bulk_url, buffer);
                                            box.remove();
                                        },
                                        wpvr_localize.yes,
                                        function () {
                                            box.remove();
                                        },
                                        wpvr_localize.cancel_button
                                    );


                                } else {
                                    //Found dups and no new items
                                    box.remove();
                                    boxDup = wpvr_show_loading({
                                        title: wpvr_localize.wp_video_robot,
                                        text: 'There is no new video ! Only dups',
                                        pauseButton: wpvr_localize.ok_button,
                                        isModal: false,
                                    });
                                    boxDup.doPause(function () {
                                        boxDup.remove();
                                        //wpvr_apply_bulk_import( data.items , bulk_url , buffer)
                                        box.remove();

                                    });
                                }


                            } else {
                                // NODUPS
                                wpvr_apply_bulk_import($data.items, bulk_url, buffer);
                                box.remove();
                            }
                        }


                    }
                });
            });


        });

        $('.cmb_option[name=wpvr_video_service] , .cmb_option[name=wpvr_source_service]').change(function () {

            $('.cmb_id_wpvr_pick_a_service').fadeOut(150);
            $('.cmb_id_wpvr_video_enableManualAdding').fadeIn(150);
            $('.cmb_id_wpvr_video_disableAutoEmbed ').fadeIn(150);
            $('.cmb_id_wpvr_source_type').fadeIn(150);
        });

        $('[id=publish]').each(function () {
            $(this).click(function (e) {
                var obj = $('.cmb_id_wpvr_source_service');
                var btn = $(this);
                var k = 0;
                var noSelect = true;

                if (obj.hasClass('canBeEmpty')) var canBeEmpty = true;
                else var canBeEmpty = false;

                e.preventDefault();

                var service_selected = 'none';
                $('.cmb_option[name=wpvr_source_service]').each(function () {
                    if ($(this).prop('checked')) service_selected = $(this).val();
                });


                var name = $('#wpvr_source_name').attr('value');
                var max_wanted = obj.attr('service');
                var wanted = $('#wpvr_source_wantedVideos').attr('value');

                $('.cmb_option[name=wpvr_source_type]').each(function () {
                    k++;


                    if ($(this).prop('checked')) {
                        if (service_selected == $(this).attr('service')) noSelect = false;
                    }
                });

                if (k != 0 && noSelect) {
                    var box = wpvr_show_loading({
                        title: wpvr_localize.wp_video_robot,
                        text: wpvr_localize.source_with_no_type,
                        pauseButton: wpvr_localize.ok_button,
                        isModal: false,
                    });
                    box.doPause(function () {
                        box.remove();
                    });
                    wpvr_remove_loading_spinner($('#wpvr_save_source_btn'));
                    return false;
                } else {
                    if (max_wanted != '' && parseInt(wanted) > parseInt(max_wanted)) {
                        var box = wpvr_show_loading({
                            title: wpvr_localize.wp_video_robot,
                            text: wpvr_localize.source_with_big_wanted,
                            pauseButton: wpvr_localize.ok_button,
                            isModal: false,
                        });
                        box.doPause(function () {
                            box.remove();
                        });
                        wpvr_remove_loading_spinner($('#wpvr_save_source_btn'));
                        return false;
                    }


                    if (!canBeEmpty && name == '') {
                        wpvr_confirm(
                            wpvr_localize.source_with_no_name,
                            function () { //YES FCT
                                btn.unbind('click').click();
                            },
                            wpvr_localize.yes,
                            function () {
                            },
                            wpvr_localize.cancel_button
                        );
                        wpvr_remove_loading_spinner($('#wpvr_save_source_btn'));
                    } else {
                        btn.unbind('click').click();
                    }
                }

            });
        });

        setTimeout(function () {

            $('.wpvr_manage_content').each(function () {
                if ($(this).attr('refresh_once') != '1') return false;
                if ($(this).attr('is_fresh') == '1') {
                    $(this).attr('is_fresh', '0');
                    wpvr_manage_refresh(false, true, 1);

                }

            });

        }, 200);

        $('body').on('click', '.wpvr_manage_exportAll', function (e) {
            e.preventDefault();
            var url = $(this).attr('url');
            var boxWaiting = wpvr_show_loading({
                title: 'WP Video Robot',
                text: wpvr_localize.loadingCenter,
            });
            $.ajax({
                type: 'POST',
                url: wpvr_globals.ajax_url,
                data: {
                    action: 'export_all_videos',
                },
                success: function (data) {
                    boxWaiting.remove();
                    var $json = wpvr_get_json(data);
                    if ($json.status == 1) {
                        $('.wpvr_manage_message').html('<iframe id="wpvr_iframe" src="" style="display:none; visibility:hidden;"></iframe>');
                        $('#wpvr_iframe').attr('src', $json.data);
                    }
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    alert(thrownError);
                }
            });

        });

        $('.wpvr_select_page').on('change', function () {

            if ($(this).hasClass('unwanted')) {
                $('.wpvr_unwanted_refine').trigger('click');
                return;
            }

            var p = $(this).attr('value');
            var url = $(this).attr('url');
            window.location.href = url + '&p=' + p;
        });

        $('.wpvr_select_service').on('change', function () {
            var p = $(this).attr('value');
            var url = $(this).attr('url');
            window.location.href = url + '&service=' + p;
        });

        $('.wpvr_search_within').on('keyup', function (e) {
            if (e.keyCode == 13) {
                var url = $(this).attr('url');
                var value = $(this).attr('value');
                window.location.href = url + '&p=1&searchterm=' + value;
            }
        });

        $('body').on('click', '.wpvr_manage_pageButton', function () {
            var aPage = $(this).attr('page');
            $('#wpvr_page').val(aPage);
            wpvr_manage_refresh(false, true, aPage);
        });

        function wpvr_apply_bulk_import(items, bulk_url, buffer) {

            var msgBox = $('.wpvr_import_message');

            if (items.length == 0) return false;

            var box = wpvr_show_loading({
                title: wpvr_localize.please_wait,
                text: wpvr_localize.work_in_progress + "...",
                progressBar: true, // OR window
                cancelButton: wpvr_localize.cancel_button, // OR window
                isModal: true,
            });

            box.doProgress({pct: 1, text: wpvr_localize.loading_raw + ''});
            box.doHighlight();
            box.attr('work', 1);
            box.attr('url', bulk_url);
            box.attr('buffer', buffer);


            box.doCancel(function () {
                box.doHide();
                wpvr_confirm(
                    wpvr_localize.really_want_cancel,
                    function () {
                        box.doShow();
                    },
                    wpvr_localize.continue_button,
                    function () { //IF yes
                        box.attr('work', 0);
                        var k = box.attr('k');
                    },
                    wpvr_localize.cancel_anyway
                );
            });
            wpvr_single_import_video(0, items, box);
        }

        function wpvr_apply_bulk_action(bulk_action, ids, views) {
            var wrapper = $('#wpvr_manage_videos');
            var bulk_url = wpvr_globals.ajax_url;
            if (!bulk_action) {
                var bulk_action = $('.wpvr_manage_bulk_actions_select').attr('value');
                isManual = true;
            } else isManual = false;


            if (bulk_action == '') return false;
            var msgBox = $('.wpvr_manage_message');


            var items = [];
            $('.wpvr_video_cb', wrapper).each(function () {
                if ($(this).prop('checked')) items.push($(this).attr('value'));
            });
            if (items.length == 0) return false;
            var box = wpvr_show_loading({
                title: wpvr_localize.please_wait,
                text: wpvr_localize.work_in_progress + "...",
                progressBar: true, // OR window
                cancelButton: wpvr_localize.cancel_button, // OR window
                isModal: true,
            });

            box.doProgress({pct: 1, text: wpvr_localize.loading_raw + ''});
            box.doHighlight();
            box.attr('work', 1);
            box.attr('action', bulk_action);
            box.attr('url', bulk_url);


            box.doCancel(function () {
                box.doHide();
                wpvr_confirm(
                    wpvr_localize.really_want_cancel,
                    function () {
                        box.doShow();
                    },
                    wpvr_localize.continue_button,
                    function () { //IF yes
                        box.attr('work', 0);
                        var k = box.attr('k');
                    },
                    wpvr_localize.cancel_anyway
                );
            });
            wpvr_single_bulk_action(0, items, box);
        }

        $('.wpvr_manage_bulkApply').click(function (e) {
            e.preventDefault();
            var bulk_action = $('.wpvr_manage_bulk_actions_select').attr('value');
            if (bulk_action == 'export') {


                var form = $('form.wpvr_manage_main_form');
                var formUrl = form.attr('url') + '?wpvr_wpload&export_videos';
                var formData = form.serializeArray();
                formData.push({
                    name: 'action',
                    value: 'export_videos',
                });

                var boxWaiting = wpvr_show_loading({
                    title: 'WP Video Robot',
                    text: wpvr_localize.loadingCenter,
                });

                $.ajax({
                    type: 'POST',
                    url: wpvr_globals.ajax_url,
                    data: formData,

                    success: function (data) {
                        boxWaiting.remove();
                        var $json = wpvr_get_json(data);
                        if ($json.status == 1) {
                            $('.wpvr_manage_message').html('<iframe id="wpvr_iframe" src="" style="display:none; visibility:hidden;"></iframe>');
                            $('#wpvr_iframe').attr('src', $json.data);
                        }
                    },
                    error: function (xhr, ajaxOptions, thrownError) {
                        alert(thrownError);
                    }
                });

            } else if (bulk_action == 'delete') {
                wpvr_confirm(
                    wpvr_localize.want_remove_items,
                    function () {
                        wpvr_apply_bulk_action();
                    },
                    wpvr_localize.yes
                    ,
                    function () {
                    },
                    wpvr_localize.cancel_button
                );
            } else {
                wpvr_apply_bulk_action();
            }

        });

        //Check All sections
        $('.wpvr_manage_checkAll').each(function () {

            $(this).bind('click', function (e) {
                e.preventDefault();
                var zone = $('#wpvr_manage_videos');
                if ($(this).attr('state') == 'off') {
                    $('.wpvr_video_cb', zone).prop('checked', true);
                    $('.wpvr_video', zone).addClass('checked');
                    $('.wpvr_manage_checkAll').attr('state', 'on');
                } else {
                    $('.wpvr_video_cb', zone).prop('checked', false);
                    $('.wpvr_video', zone).removeClass('checked');
                    $('.wpvr_manage_checkAll').attr('state', 'off');
                }
                wpvr_count_checked();
            });

        });

        /* Manage Sidebar Boxes */
        $('.wpvr_manage_box').each(function () {
            var box = $(this);
            var head = $('.wpvr_manage_box_head ', box);
            head.click(function (e) {
                e.preventDefault();
                box.toggleClass('open');
            });

        });

        $('body').on('click', '.wpvr_page', function () {
            wpvr_manage_refresh(false, true);
        });

        $('body').on('click', '.wpvr_manage_refresh', function (e) {
            e.preventDefault();
            wpvr_manage_refresh(false, true);
        });

        $('body').on('click', '.wpvr_manage_search_button', function (e) {
            e.preventDefault();
            wpvr_manage_refresh(false, true);
        });

        $('.wpvr_manage_check_ul li').each(function () {
            var li = $(this);
            var cb = $('input[type=checkbox]', li);
            cb.change(function () {
                if (cb.prop('checked')) li.addClass('checked');
                else li.removeClass('checked');
                var n = 0;
                $('.wpvr_manage_check_ul li input[type=checkbox]').each(function () {
                    if ($(this).prop('checked')) n++;
                });

                if (n >= 1) $('.wpvr_manage_is_filtering').attr('value', '1');
                else $('.wpvr_manage_is_filtering').attr('value', '0');

            });


        });

        /* CLICKS the manage_layout btns */
        $('.wpvr_layout_btn').bind('click', function (e) {
            e.preventDefault();
            var layout = $(this).attr('layout');
            $('.wpvr_layout_btn').removeClass('active');
            $(this).addClass('active');

            $('#wpvr_manage_videos').removeClass('bgrid').removeClass('sgrid').removeClass('grid').removeClass('list');
            $('#wpvr_manage_videos').addClass(layout);

            $('.wpvr_manage_layout_hidden').attr('value', layout);

        });

        /* GLOBAL FUNCTION  *************************************************************************************/

        // Count video ids entered
        $('.wpvr_wh_updater').each(function () {
            $(this).bind('change', function () {
                var start = $('#wpvr_options_wakeUpHoursA').attr('value');
                var end = $('#wpvr_options_wakeUpHoursB').attr('value');
                var rBox = $('#wpvr_options_wakeUpHours_graph');
                $.ajax({
                    url: wpvr_globals.ajax_url,
                    type: 'POST',
                    data: {
                        action: 'wpvr_update_wakeUpHours',
                        start: start,
                        end: end
                    },
                    success: function (data) {
                        rBox.html(data);
                    },
                    error: function (xhr, ajaxOptions, thrownError) {
                        alert(thrownError);
                    }
                });


            });
        });

        // Count items inside
        $('.countMyItems').each(function () {
            var wrap = $(this);
            var listener_id = wrap.attr('prefix') + wrap.attr('listener');
            var listener = $('#' + listener_id);
            var counter = $('.wpvr_count_items', wrap);

            wpvr_update_count(listener, counter);
            listener.bind('keyup', function () {
                wpvr_update_count(listener, counter);
            });
            listener.bind('change', function () {
                wpvr_update_count(listener, counter);
            });
        });

        // Count video ids entered
        $('#wpvr_source_videoIds').each(function () {
            wpvr_update_count($(this), $('.wpvr_count_videos'));
            $(this).bind('keyup', function () {
                wpvr_update_count($(this), $('.wpvr_count_videos'));
            });
        });

        // Count video ids entered
        $('#wpvr_source_groupIds').each(function () {
            wpvr_update_count($(this), $('.wpvr_count_groups'));
            $(this).bind('keyup', function () {
                wpvr_update_count($(this), $('.wpvr_count_groups'));
            });
        });

        // Count playlist ids entered
        $('#wpvr_source_playlistIds').each(function () {
            wpvr_update_count($(this), $('.wpvr_count_playlists'));
            $(this).bind('keyup', function () {
                wpvr_update_count($(this), $('.wpvr_count_playlists'));
            });
        });

        // Count channnel ids entered
        $('#wpvr_source_channelIds').each(function () {
            wpvr_update_count($(this), $('.wpvr_count_channels'));
            $(this).bind('keyup', function () {
                wpvr_update_count($(this), $('.wpvr_count_channels'));
            });
        });

        // Count channnel2 ids entered
        $('#wpvr_source_videoIds_dm').each(function () {
            wpvr_update_count($(this), $('.wpvr_count_videos_dm'));
            $(this).bind('keyup', function () {
                wpvr_update_count($(this), $('.wpvr_count_videos_dm'));
            });
        });

        //Make Switch Function
        $('.wpvr_make_switch').each(function () {
            var cb = $(this);
            var cbId = cb.attr('id');
            var cbClass = cb.attr('class');
            var cbName = cb.attr('name');
            if (cb.prop('checked')) var cbChecked = ' checked = "checked" ';
            else var cbChecked = '';
            var str =
                '<div class="wpvr-onoffswitch">' +
                '<input type="checkbox" name="' + cbName + '" class="wpvr-onoffswitch-checkbox ' + cbClass + '" id="' + cbId + '" ' + cbChecked + ' />' +
                '<label class="wpvr-onoffswitch-label" for="' + cbId + '">' +
                '<span class="wpvr-onoffswitch-inner">' +
                '<span class="wpvr-onoffswitch-active"><span class="wpvr-onoffswitch-switch">ON</span></span>' +
                '<span class="wpvr-onoffswitch-inactive"><span class="wpvr-onoffswitch-switch">OFF</span></span>' +
                '</span>' +
                '</label>' +
                '</div>'
            ;
            cb.after($(str));
            cb.remove();
        });

        $('body').on('click', '.wpvr-onoffswitch-label', function (e) {
            var label = $(this);
            var parent = label.parent();
            var input = $('.wpvr-onoffswitch-checkbox', parent).get(0);
            parent.toggleClass('wpvr-onoffswitch-checked').trigger('changeClass');
        });

        //JS single add video

        /*******************************************************************************************************/

        /* OPTIONS  *************************************************************************************/

        //Standalone System Info
        $('.wpvr_standalone_system_info_export').click(function () {
            var exportBtn = $(this);
            var spinnerExport = wpvr_add_loading_spinner(exportBtn, 'pull-left');
            $.ajax({
                type: 'POST',
                data: {
                    action: 'wpvr_system_info',
                    do_export: '1',
                },
                url: wpvr_globals.ajax_url,
                success: function (data) {
                    wpvr_remove_loading_spinner(spinnerExport);
                    var $json = wpvr_get_json(data);
                    if ($json.status == 1) {
                        $('#wpvr_export').html('<iframe id="wpvr_iframe" src="" style="display:none; visibility:hidden;"></iframe>');
                        $('#wpvr_iframe').attr('src', $json.data);
                    }

                },
                error: function (xhr, ajaxOptions, thrownError) {
                    alert(thrownError);
                }
            });
        });

        //Show System Infos
        $('body').on('click', '#wpvr_system_infos', function (e) {
            e.preventDefault();
            var btn = $(this);
            if (btn.hasClass('wpvr_isLoading')) return false;

            var spinner = wpvr_add_loading_spinner(btn, 'pull-left');


            $.ajax({
                type: 'POST',
                data: {
                    action: 'wpvr_system_info',
                },
                url: wpvr_globals.ajax_url,
                success: function (data) {
                    var $data = wpvr_get_json(data);
                    wpvr_remove_loading_spinner(spinner);
                    var box2 = wpvr_show_loading({
                        title: wpvr_localize.system_infos,
                        width: '55%',
                        text: $data.data,
                        cancelButton: wpvr_localize.close_button,
                        pauseButton: wpvr_localize.export_button,
                    });
                    var exportBtn = $('.wpvr_loading_pause', box2);
                    box2.doPause(function () {
                        var spinnerExport = wpvr_add_loading_spinner(exportBtn, 'pull-left');
                        $.ajax({
                            type: 'POST',
                            data: {
                                action: 'wpvr_system_info',
                                do_export: '1',
                            },
                            url: wpvr_globals.ajax_url,
                            success: function (data) {
                                wpvr_remove_loading_spinner(spinnerExport);
                                var $json = wpvr_get_json(data);

                                if ($json.status == 1) {
                                    $('#wpvr_export').html('<iframe id="wpvr_iframe" src="" style="display:none; visibility:hidden;"></iframe>');
                                    $('#wpvr_iframe').attr('src', $json.data);
                                }

                            },
                            error: function (xhr, ajaxOptions, thrownError) {
                                alert(thrownError);
                            }
                        });

                    });

                    box2.doCancel(function () {
                        box2.doClose();
                        wpvr_remove_loading_spinner(spinner);
                    });

                    box2.doRemove(function () {
                        wpvr_remove_loading_spinner(spinner);
                    });

                },
                error: function (xhr, ajaxOptions, thrownError) {
                    alert(thrownError);
                }
            });
        });

        //Select Images in Addon Options
        $('.wpvr_addon_option_select_image').each(function () {
            var w = $(this);
            var destSelect = $('#' + w.attr('destSelect'));
            $('li', w).click(function (e) {
                e.preventDefault();
                var btn = $(this);
                $('.wpvr_addon_option_select_image li').removeClass('active');
                btn.addClass('active');
                destSelect.val(btn.attr('v'));

            });
        });
        $('#post_template').change(function () {
            option_select_image_update($(this));
        });
        option_select_image_update($('#post_template'));

        function option_select_image_update(select) {
            var s = select.attr('value');
            var id = select.attr('id');
            $('.wpvr_addon_option_select_image[destSelect=' + id + '] li').removeClass('active');
            if (s != '') $('.wpvr_addon_option_select_image[destSelect=' + id + '] li[v=' + s + ']').addClass('active');

        }

        $('body').on('click', '.wpvr_nav_tab', function (e) {
            e.preventDefault();
            var id = $(this).attr('id');
            var destid = $(this).attr('destid');
            if ($(this).hasClass('isLink')) {
                window.open($(this).attr('href'), '_blank');
                return false;
            }
            if ($(this).hasClass('noTab')) return false;
            $('.wpvr_nav_tab').removeClass('active');
            $(this).addClass('active');

            if (typeof destid !== 'undefined') {

                $('#' + destid + ' .wpvr_nav_tab_content').hide();
                $('#' + destid + ' .wpvr_nav_tab_content.tab_' + id).fadeIn();
            } else {
                $('.wpvr_nav_tab_content').hide();
                $('.wpvr_nav_tab_content.tab_' + id).fadeIn();
            }

            $('.wpvr_wrap').css('visibility', 'visible');
        });

        //Tab options
        $('body').on('click', '.wpvr_nav_link', function (e) {
            e.preventDefault();
            var url = $(this).attr('href');
            window.open(url);

            $('.wpvr_nav_tab#b').trigger('click');

            return false;
        });

        $('.wpvr_nav_tab.active').trigger('click');
        $('.wpvr_addons_wrapper').fadeIn();

        //Tab options
        $('body').on('click', '.wpvr_addons_tab', function (e) {
            e.preventDefault();
            var id = $(this).attr('addon_id');

            $('.wpvr_addons_tab').removeClass('active');
            $(this).addClass('active');
            $('.wpvr_addon_content').hide();
            $('.wpvr_addon_content#' + id).fadeIn();
            $('.wpvr_addons_wrapper').css('visibility', 'visible');
        });

        $('.wpvr_addons_tab.active').trigger('click');

        //Schedule Source
        $('body').on('click', '.wpvr_add_schedule', function (e) {

            e.preventDefault();
            var btn = $(this);
            if (btn.hasClass('wpvr_isLoading')) return false;
            var sf = '';
            sf += '<form class="wpvr_schedule_add_form">';
            sf += '<label>Pick a source :</label><br/>';
            sf += '';
            sf += '</form>';


            box = wpvr_show_loading({
                title: wpvr_localize.wp_video_robot,
                text: sf,
                pauseButton: wpvr_localize.ok_button,
                cancelButton: wpvr_localize.cancel_button,
                isModal: false,
            });
            box.doPause(function () {
                box.remove();
            });

        });

        //Save options
        $('body').on('click', '.wpvr_save_options', function (e) {

            e.preventDefault();
            var btn = $(this);
            if (btn.hasClass('wpvr_isLoading')) return false;

            if ($('.wpvr_save_options.wpvr_isLoading').length > 0) {
                return false;
            }

            var max_wanted = $('#wpvr_options_wantedVideos').attr('max_value');
            var wanted = $('#wpvr_options_wantedVideos').attr('value');

            if (max_wanted != '' && parseInt(wanted) > parseInt(max_wanted)) {
                var box = wpvr_show_loading({
                    title: wpvr_localize.wp_video_robot,
                    text: wpvr_localize.source_with_big_wanted,
                    pauseButton: wpvr_localize.ok_button,
                    isModal: false,
                });
                box.doPause(function () {
                    box.remove();
                });
                return false;
            }


            var form = $('#wpvr_options');
            var formData = form.serialize();
            var spinner = wpvr_add_loading_spinner(btn, 'pull-right');
            var formUrl = form.attr('action');
            var is_demo = form.attr('is_demo');


            if (is_demo == '1') {
                boxDemo = wpvr_show_loading({
                    title: wpvr_localize.wp_video_robot,
                    text: 'This is a demo version of WP Video Robot.<br/>For security reasons, you cannot change the options.<br/> Hope you understand.',
                    pauseButton: wpvr_localize.ok_button,
                    isModal: false,
                });
                boxDemo.doPause(function () {
                    boxDemo.remove();
                });
                boxDemo.doRemove(function () {
                    wpvr_remove_loading_spinner(spinner);
                });
                return false;
            }


            btn.addClass('isLoading');

            $.ajax({
                type: 'POST',
                url: wpvr_globals.ajax_url,
                data: formData,
                success: function (data) {
                    $data = wpvr_get_json(data);
                    if ($data.status == 1) {

                        var box2 = wpvr_show_loading({
                            title: wpvr_localize.options_saved,
                            text: wpvr_localize.options_saved_icon,
                            pauseButton: wpvr_localize.ok_button,
                        });
                        box2.doPause(function () {
                            box2.remove();
                            wpvr_remove_loading_spinner(spinner);
                        });
                        box2.doRemove(function () {
                            wpvr_remove_loading_spinner(spinner);
                            if ($data.data.refresh) {
                                if ($data.data.param == '') {
                                    location.reload();
                                } else {
                                    var url = window.location.href;
                                    if (url.indexOf('?') > -1) {
                                        url += '&' + $data.data.param + '=1';
                                    } else {
                                        url += '?' + $data.data.param + '=1';
                                    }
                                    window.location.href = url;
                                }
                            }
                        });
                    } else {
                        wpvr_alert('Something went wrong while saving options. Check the JS console.');
                        console.log(data);
                    }

                },
                error: function (xhr, ajaxOptions, thrownError) {
                    alert(thrownError);
                }
            });
        });

        //Reset Addon Licenses
        $('body').on('click', '.wpvr_setter_button', function (e) {
            var btn = $(this);
            if (btn.hasClass('wpvr_flush_button')) {
                return false;
            }
            e.preventDefault();

            var action = btn.attr('action');
            var is_demo = btn.attr('is_demo');
            var show_result = btn.attr('show_result');

            if (btn.hasClass('wpvr_isLoading')) return false;

            var spinner = wpvr_add_loading_spinner(btn, 'pull-right');

            $.ajax({
                type: 'POST',
                url: wpvr_globals.ajax_url,
                data: {
                    action: action,
                },
                success: function (response) {
                    response = wpvr_get_json(response);
                    data = response.data;

                    if (show_result === 1) {
                        var box = wpvr_show_loading({
                            title: wpvr_localize.wp_video_robot,
                            text: data,
                            pauseButton: wpvr_localize.ok_button,
                        });
                        box.doPause(function () {
                            box.remove();
                            wpvr_remove_loading_spinner(spinner);
                        });
                        box.doRemove(function () {
                            wpvr_remove_loading_spinner(spinner);
                        });
                    } else {
                        if (data === 'ok') {
                            var box = wpvr_show_loading({
                                title: wpvr_localize.wp_video_robot,
                                text: wpvr_localize.action_done,
                                pauseButton: wpvr_localize.ok_button,
                            });
                            box.doPause(function () {
                                box.remove();
                                wpvr_remove_loading_spinner(spinner);
                            });
                            box.doRemove(function () {
                                wpvr_remove_loading_spinner(spinner);
                            });
                        }
                    }
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    alert(thrownError);
                }
            });
        });

        //Reset Single Addon Licence
        $('body').on('click', '.wpvr_reset_single_addon_license', function (e) {
            e.preventDefault();
            var btn = $(this);
            var slug = btn.attr('slug');
            if (btn.hasClass('wpvr_isLoading')) return false;

            $('i', btn).addClass('fa-spin');
            wpvr_confirm(
                wpvr_localize.license_reset_confirm,
                function () {

                    btn.addClass('isLoading');
                    $.ajax({
                        type: 'POST',
                        url: wpvr_globals.ajax_url,
                        data: {
                            action: 'reset_single_addon_license',
                            slug: slug,
                        },
                        success: function (data) {
                            $('i', btn).removeClass('fa-spin');

                            $json = wpvr_get_json(data);
                            if ($json.status == 0) {
                                var $msg = 'Reset Error : <br/>'.$json.msg;
                            } else {
                                var $msg = $json.msg;
                                $('#wpvr_addon_license_' + $json.data).removeClass('fail').removeClass('success').html('');
                                $('#license_' + $json.data).attr('value', '').attr('is_activated', '0');
                            }

                            var box = wpvr_show_loading({
                                title: wpvr_localize.wp_video_robot,
                                text: $msg,
                                pauseButton: wpvr_localize.ok_button,
                            });
                            box.doPause(function () {
                                box.remove();
                            });
                            box.doRemove(function () {

                            });
                            btn.removeClass('isLoading');
                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            alert(thrownError);
                        }
                    });
                },
                wpvr_localize.reset_yes,
                function () {
                    $('i', btn).removeClass('fa-spin');
                },
                wpvr_localize.reset_no
            );
        });

        //Reset Addon Licenses
        $('body').on('click', '#wpvr_reset_addon_licenses', function (e) {
            e.preventDefault();
            var btn = $(this);
            if (btn.hasClass('wpvr_isLoading')) return false;
            var spinner = wpvr_add_loading_spinner(btn, 'pull-right');
            wpvr_confirm(
                wpvr_localize.options_reset_confirm,
                function () {

                    btn.addClass('isLoading');
                    $.ajax({
                        type: 'POST',
                        url: wpvr_globals.ajax_url,
                        data: {
                            action: 'reset_addon_licenses',
                        },
                        success: function (data) {
                            $json = wpvr_get_json(data);
                            if ($json.status == '1') {
                                var box = wpvr_show_loading({
                                    title: wpvr_localize.wp_video_robot,
                                    text: $json.msg,
                                    pauseButton: wpvr_localize.ok_button,
                                });
                                box.doPause(function () {
                                    box.remove();
                                    wpvr_remove_loading_spinner(spinner);
                                    location.reload();
                                });
                                box.doRemove(function () {
                                    wpvr_remove_loading_spinner(spinner);
                                });

                            }
                            btn.removeClass('isLoading');
                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            alert(thrownError);
                        }
                    });
                },
                wpvr_localize.reset_yes,
                function () {
                    wpvr_remove_loading_spinner(spinner);
                },
                wpvr_localize.reset_no
            );
        });

        //Reset Activation
        $('body').on('click', '#wpvr_reset_activation', function (e) {
            e.preventDefault();
            var btn = $(this);
            if (btn.hasClass('wpvr_isLoading')) return false;
            var is_demo = btn.attr('is_demo');
            if (is_demo == '1') {
                boxDemo = wpvr_show_loading({
                    title: wpvr_localize.wp_video_robot,
                    text: 'This is a demo version of WP Video Robot.<br/>For security reasons, you cannot change the options.<br/> Hope you understand.',
                    pauseButton: wpvr_localize.ok_button,
                    isModal: false,
                });
                boxDemo.doPause(function () {
                    boxDemo.remove();
                });
                return false;
            }
            var spinner = wpvr_add_loading_spinner(btn, 'pull-right');
            wpvr_confirm(
                wpvr_localize.options_reset_confirm,
                function () {

                    btn.addClass('isLoading');
                    $.ajax({
                        type: 'POST',
                        data: {
                            action: 'reset_activation',
                        },
                        url: wpvr_globals.ajax_url,
                        success: function (data) {
                            $data = wpvr_get_json(data);
                            if ($data.status == 1) {
                                var box = wpvr_show_loading({
                                    title: wpvr_localize.wp_video_robot,
                                    text: wpvr_localize.license_reset,
                                    pauseButton: wpvr_localize.ok_button,
                                });
                                box.doPause(function () {
                                    box.remove();
                                    location.reload();
                                });
                                box.doRemove(function () {
                                    wpvr_remove_loading_spinner(spinner);
                                });

                            }
                            wpvr_remove_loading_spinner(spinner);
                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            alert(thrownError);
                        }
                    });
                },
                wpvr_localize.reset_yes,
                function () {
                    wpvr_remove_loading_spinner(spinner);
                },
                wpvr_localize.reset_no
            );
        });


        //Cancel Activation
        $('body').on('click', '#wpvr_cancel_activation', function (e) {
            e.preventDefault();
            var btn = $(this);
            if (btn.hasClass('wpvr_isLoading')) return false;
            var is_demo = btn.attr('is_demo');
            if (is_demo == '1') {
                boxDemo = wpvr_show_loading({
                    title: wpvr_localize.wp_video_robot,
                    text: 'This is a demo version of WP Video Robot.<br/>For security reasons, you cannot change the options.<br/> Hope you understand.',
                    pauseButton: wpvr_localize.ok_button,
                    isModal: false,
                });
                boxDemo.doPause(function () {
                    boxDemo.remove();
                });
                return false;
            }
            var spinner = wpvr_add_loading_spinner(btn, 'pull-right');
            wpvr_confirm(
                wpvr_localize.activation_cancel_confirm,
                function () {

                    btn.addClass('isLoading');
                    $.ajax({
                        type: 'POST',
                        data: {
                            action: 'cancel_activation',
                        },
                        url: wpvr_globals.ajax_url,
                        success: function (data) {
                            $data = wpvr_get_json(data);
                            if ($data.status == 1) {
                                var box = wpvr_show_loading({
                                    title: wpvr_localize.wp_video_robot,
                                    text: wpvr_localize.license_cancelled,
                                    pauseButton: wpvr_localize.ok_button,
                                });
                                box.doPause(function () {
                                    box.remove();
                                    location.reload();
                                });
                                box.doRemove(function () {
                                    wpvr_remove_loading_spinner(spinner);
                                });

                            }
                            wpvr_remove_loading_spinner(spinner);
                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            alert(thrownError);
                        }
                    });
                },
                wpvr_localize.reset_yes,
                function () {
                    wpvr_remove_loading_spinner(spinner);
                },
                wpvr_localize.reset_no
            );
        });

        $('.wpvr_log_canvas').each(function () {
            var canvas = $(this);
            var init_data = [
                {
                    type: 'link',
                    date: canvas.data('now'),
                    local_date: canvas.data('localnow'),
                    title: canvas.data('timezone'),
                },
            ];
            var timeline = new Timeline($('.wpvr_log_canvas_timeline', canvas), init_data);
            timeline.setOptions({
                animation: true,
                lightbox: false,
                first_separator: true,
                separator: 'month_year',
                columnMode: 'dual',
                order: 'desc',
                dateFormat: 'YYYY-MM-DD HH:mm:ss',
                responsive_width: 700,
            });
            timeline.display();

            canvas.on('click', '.wpvr_logs_details_button', function (e) {
                e.preventDefault();
                var btn = $(this);

                if (btn.hasClass('closed')) {
                    $('.wpvr_logs_details_button').removeClass('open').addClass('closed');
                    btn.removeClass('closed').addClass('open');
                    $('.wpvr_logs_details_content').hide();
                    $('.wpvr_logs_details_content[data-log=' + btn.data('id') + ']').fadeIn();
                } else {
                    btn.removeClass('open').addClass('closed');
                    $('.wpvr_logs_details_content').hide();
                    $('.wpvr_logs_details_content[data-log=' + btn.data('id') + ']').hide();
                }


            });

            $('.wpvr_log_load_more', canvas).click(function (e) {
                e.preventDefault();
                var btn = $(this);
                if (btn.hasClass('wpvr_loading')) {
                    return;
                }
                wpvr_btn_loading(btn);
                $('span', btn).html( wpvr_localize.loading_raw );
                $.ajax(
                    wpvr_globals.ajax_url, {
                        type: 'POST',
                        data: {
                            action: 'load_activity_logs',
                            page: btn.data('page'),
                            period: btn.data('period'),
                            type: btn.data('type'),
                            sources: btn.data('sources'),
                        },
                        success: function (data) {
                            var $json = wpvr_get_json(data);
                            wpvr_btn_loading(btn, false);
                            $('span', btn).html( btn.data('label') );
                            if ($json.data.items.length === 0) {
                                $('.wpvr_log_canvas_statement', canvas).html('Nothing happened.').fadeIn();
                            } else {
                                $('.wpvr_log_canvas_statement', canvas).html('').hide();
                            }

                            timeline.appendData($json.data.items);

                            if ($json.data.page == 'end') {
                                btn.hide();
                            } else {
                                btn.data('page', $json.data.page);

                            }
                        }
                    });

            });

            $('.wpvr_log_load_more', canvas).trigger('click');

        });


        //Register Addon Licenses
        $('body').on('click', '#wpvr_register_addon_licenses', function (e) {
            e.preventDefault();
            var items = [];
            var btn = $(this);
            // if (btn.hasClass('wpvr_isLoading'))    return false;
            var form = $('#wpvr_register_addons_licenses_form');
            var formData = form.serialize();
            var spinner = wpvr_add_loading_spinner(btn, 'pull-right');
            var formUrl = form.attr('action');

            $('.wpvr_license_input', form).each(function () {
                var item = $(this);

                if (item.attr('value') != '' && item.attr('is_activated') == '0') {
                    items.push({
                        slug: item.attr('slug'),
                        version: item.attr('version'),
                        code: item.attr('value'),
                    })
                } else {
                    $('#wpvr_addon_license_' + item.attr('slug')).removeClass('fail').removeClass('success').html('');
                }
            });
            var json_items = JSON.stringify(items);
            if (json_items == '[]') {
                wpvr_remove_loading_spinner(spinner);
                var box2 = wpvr_show_loading({
                    title: 'WP Video Robot',
                    text: 'There is no new purchase code to activate.',
                    pauseButton: wpvr_localize.ok_button,
                });
                box2.doPause(function () {
                    box2.remove();
                    wpvr_remove_loading_spinner(spinner);
                });
                box2.doRemove(function () {
                    wpvr_remove_loading_spinner(spinner);
                });
                return false;
            }
            $.ajax({
                type: 'POST',
                url: wpvr_globals.ajax_url,
                data: {
                    action: 'register_addon_licenses',
                    email: $('#act_email', form).attr('value'),
                    domain: $('#act_domain', form).attr('value'),
                    url: $('#act_url', form).attr('value'),
                    ip: $('#act_ip', form).attr('value'),
                    items: json_items,
                },
                success: function (data) {
                    var count_ok = 0;
                    var count_ko = 0;
                    var count_zero = 0;
                    $json = wpvr_get_json(data);
                    var details = '';
                    $.each($json.data, function (i, item) {
                        var span = $('#wpvr_addon_license_' + i);
                        span.hide().removeClass('fail').removeClass('success');
                        details += '<li><strong>' + item.product + '</strong> : <br/>' + item.msg + '</li>';
                        if (item.status == 1) {
                            $('#license_' + i).attr('is_activated', '1');
                            span.addClass('success').html(item.msg).fadeIn();
                            count_ok++;
                        }
                        else if (item.status == 0) {
                            $('#license_' + i).attr('is_activated', '0');
                            span.addClass('fail').html(item.msg).fadeIn();
                            count_ko++;
                        } else {
                            count_zero++;
                            span.addClass('success').fadeIn();
                        }
                    });

                    var msg = 'Licenses saved. ' +
                        '<a class="wpvr_show_registration_details" href="#">Show Details.</a>' +
                        '<br/><br/>' +
                        '<div class="wpvr_register_results">' +
                        '<span> ' + count_ok + ' </span>NEW ACTIVATIONS' +
                        '</div>' +
                        '<div class="wpvr_register_results wpvr_errors">' +
                        '<span> ' + count_ko + ' </span>ERRORS' +
                        '</div>' +
                        '<div class="wpvr_clearfix"></div><br/>' +
                        '<div class="wpvr_registration_details" style="display:none;">' + details + '</div>' +
                        '</div>';

                    if ($json.status == 1) {
                        wpvr_remove_loading_spinner(spinner);
                        var box2 = wpvr_show_loading({
                            title: 'WP Video Robot',
                            text: msg,
                            pauseButton: wpvr_localize.ok_button,
                        });
                        $('.wpvr_show_registration_details').click(function (e) {
                            e.preventDefault();
                            $('.wpvr_registration_details').toggle();
                        });
                        box2.doPause(function () {
                            box2.remove();
                            wpvr_remove_loading_spinner(spinner);
                        });
                        box2.doRemove(function () {
                            wpvr_remove_loading_spinner(spinner);
                        });
                    } else console.log(data);

                },
                error: function (xhr, ajaxOptions, thrownError) {
                    alert(thrownError);
                }
            });
        });
        //Verify purchase code
        $('body').on('click', '#wpvr_verify_purchase_code', function (e) {
            e.preventDefault();
            var btn = $(this);
            var purchaseCode = $('#wpvr_options_purchaseCode').attr('value');
            var url = btn.attr('url');

            if (purchaseCode == '') return false;
            var spinner = wpvr_add_loading_spinner(btn, 'pull-right');
            btn.addClass('isLoading');


            $.ajax({
                type: 'POST',
                url: url + '?wpvr_wpload&verify_purchase_code',
                data: {purchaseCode: purchaseCode},
                success: function (data) {
                    wpvr_remove_loading_spinner(spinner);
                    $('#wpvr_verify_purchase_code_result').html(data);
                    btn.removeClass('isLoading');

                },
                error: function (xhr, ajaxOptions, thrownError) {
                    alert(thrownError);
                }
            });
        });

        //Export options
        $('body').on('click', '#wpvr_export_options', function (e) {
            e.preventDefault();
            var btn = $(this);
            if (btn.hasClass('wpvr_isLoading')) return false;
            var url = btn.attr('url');
            btn.addClass('isLoading');
            var spinner = wpvr_add_loading_spinner(btn, 'pull-left');

            $.ajax({
                type: 'POST',
                url: wpvr_globals.ajax_url,
                data: {
                    action: 'wpvr_export_options',
                },
                success: function (data) {
                    $('#wpvr_export').html(data);
                    wpvr_remove_loading_spinner(spinner);
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    alert(thrownError);
                }
            });
        });
        //Back Button
        $('body').on('click', '#backBtn', function (e) {
            e.preventDefault();
            window.history.go(-1);
            return false;
        });

        //Reset Options
        $('body').on('click', '#wpvr_reset_options', function (e) {
            e.preventDefault();
            var btn = $(this);
            if (btn.hasClass('wpvr_isLoading')) return false;
            var url = $(this).attr('url');
            var is_demo = $('#wpvr_options').attr('is_demo');

            var spinner = wpvr_add_loading_spinner(btn, 'pull-left');

            if (is_demo == '1') {
                boxDemo = wpvr_show_loading({
                    title: wpvr_localize.wp_video_robot,
                    text: 'This is a demo version of WP Video Robot.<br/>For security reasons, you cannot change the options.<br/> Hope you understand.',
                    pauseButton: wpvr_localize.ok_button,
                    isModal: false,
                });
                boxDemo.doPause(function () {
                    boxDemo.remove();
                    wpvr_remove_loading_spinner(spinner);
                });
                boxDemo.doRemove(function () {
                    wpvr_remove_loading_spinner(spinner);
                });
                return false;
            }

            wpvr_confirm(
                wpvr_localize.options_reset_confirm,
                function () {
                    var form = $('#wpvr_options');
                    $.ajax({
                        type: 'POST',
                        url: wpvr_globals.ajax_url,
                        data: {
                            action: 'wpvr_reset_options',
                        },
                        success: function (data) {
                            $data = wpvr_get_json(data);
                            if ($data.status == 1) {
                                var box = wpvr_show_loading({
                                    title: wpvr_localize.wp_video_robot,
                                    text: wpvr_localize.options_set_to_default,
                                    pauseButton: wpvr_localize.ok_button,
                                });
                                box.doPause(function () {
                                    box.remove();
                                    wpvr_remove_loading_spinner(spinner);
                                    location.reload();
                                });
                            }
                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            alert(thrownError);
                        }
                    });
                },
                wpvr_localize.reset_yes,
                function () {
                    wpvr_remove_loading_spinner(spinner);
                },
                wpvr_localize.reset_no
            );
        });

        $('.wpvr_option').each(function () {
            var option = $(this);
            option.delegate('.wpvr_switch_btn ', 'lcs-statuschange', function () {

                if ($(this).is(':checked')) {
                    option.removeClass('off').addClass('on');
                    $('.wpvr_switch_input', option).val('@true');
                } else {
                    option.removeClass('on').addClass('off');
                    $('.wpvr_switch_input', option).val('@false');
                }
            });
        });


        $('.wpvr_api_connection').change(function () {
            var option = $('#wpvr_api_connection_target');
            option.removeClass('advanced').removeClass('wizzard');
            option.addClass($(this).val());
        });

        $('#permalinkBase').change(function () {
            if ($(this).val() == 'custom') {
                $('#customPermalinkBase').fadeIn();
            } else {
                $('#customPermalinkBase').hide();
            }
        });
        //OnClick Option event
        $('body').on('click', '.wpvr_option:not(.texteditor)', function (e) {

            var option = $(this);
            var btn = $('input[type=checkbox]', option);
            var x = btn.attr('name');

            if (x === undefined) return false;
            var t = x.split('wpvr_options_');
            var toBeEnabled = $('.enabledBy_' + t[1]);

            btn.change(function () {

                if (btn.hasClass('wpvr_switch_btn')) return;
                option.removeClass('on').removeClass('off');
                if (!$(this).prop('checked')) {
                    option.addClass('off');
                    toBeEnabled.attr('readonly', '').attr('disabled', '');

                } else {
                    option.addClass('on');
                    toBeEnabled.removeAttr('readonly', '').removeAttr('disabled', '');

                }
            });
        });

        $('body').on('click', '.wpvr_option a.link', function (e) {
            window.open($(this).attr('href'), '_blank');

        });

        /**************************************************************************************/

        /* LOGS ************************************************************************************/
        //Change Log page
        // $('.wpvr_log_page_select').bind('change', function () {
        //     var page_url = $(this).attr('page_url');
        //     var period = $(this).attr('period');
        //     var page_num = $(this).attr('value');
        //     var url = page_url + '&page_num=' + page_num + '&period=' + period;
        //     window.location.href = url;
        // });
        //
        // //Change Log Period
        // $('.wpvr_log_period_select').bind('change', function () {
        //     var page_url = $(this).attr('page_url');
        //     var period = $(this).attr('value');
        //     var url = page_url + '&period=' + period;
        //     window.location.href = url;
        // });
        $('.wpvr_log_type_select').change(function () {
            if ($(this).val() == 'source') {
                $('.wpvr_logs_sources_filter').fadeIn();
            } else {
                $('.wpvr_logs_sources_filter').hide();
            }
        });
        $('.wpvr_logs_refine').click(function (e) {
            e.preventDefault();
            var btn = $(this);
            var url = btn.data('url');
            var period = $('.wpvr_log_period_select').val();
            var type = $('.wpvr_log_type_select').val();
            var sources = $('.wpvr_field_selectize#sources').val();

            wpvr_btn_loading(btn, true);

            if (period != 'all') {
                url += '&period=' + period;
            }
            if (type != 'all') {
                url += '&type=' + type;
            }

            if (sources != 'all') {
                url += '&sources=' + sources;
            }
            window.location.href = url;
        });
        //Refresh Log
        $('body').on('click', '.wpvr_refresh_log', function (e) {
            window.location.reload();
        });

        //Refresh Log
        $('body').on('click', '.wpvr_refresh_page', function (e) {
            e.preventDefault();
            window.location.reload();
        });

        // Go To Top
        $('body').on('click', '.wpvr_goToTop', function (e) {
            e.preventDefault();
            $('html, body').animate({scrollTop: 0}, 'slow');
        });

        // Clear Log
        $('body').on('click', '.wpvr_clear_log', function (e) {

            var reset_url = $(this).attr('reset_url');
            wpvr_confirm(
                wpvr_localize.want_clear_log,
                function () {
                    window.location.href = reset_url;
                },
                wpvr_localize.yes,
                function () {
                },
                wpvr_localize.cancel_button
            );


        });

        /* ************************************************************************************/

        /* SOURCES ************************************************************************************/
        //Toggling sources
        $('body').delegate('.wpvr_switch_btn', 'lcs-statuschange', function () {
            var status = ($(this).is(':checked')) ? 'checked' : 'unchecked';
        });
        $('#the-list .type-wpvr_source').each(function () {
            var source = $(this);
            var toggle = $('.wpvr_source_toggle', source);
            var source_id = toggle.attr('id');
            var loading = $('.wpvr_toggle_loading', source);
            var done = $('.wpvr_toggle_done', source);

            source.delegate('.wpvr_source_toggle', 'lcs-statuschange', function () {
                var source_status = (toggle.is(':checked')) ? 'on' : 'off';
                loading.fadeIn();

                $.ajax({
                    type: 'POST',
                    url: wpvr_globals.ajax_url,
                    data: {
                        action: 'wpvr_source_toggle_state',
                        ids: source_id,
                        status: source_status
                    },
                    success: function (data) {
                        loading.hide();
                        done.fadeIn();
                        setTimeout(function () {
                            done.fadeOut('slow');
                        }, 1000);

                    },
                    error: function (xhr, ajaxOptions, thrownError) {
                        alert(thrownError);
                    }
                });

            });


        });


        $('.wpvr_source_toggle').bind('change', function () {
            var source_id = $(this).attr('id');
            var wpvr_source_status = $('#toggle_' + source_id);
            var source_status = wpvr_source_status.attr('status');

            if (source_status == "off") source_status = "on";
            else source_status = "off";
            var toggleUrl = wpvr_source_status.attr('url');
            var toggleLoading = $('#toggle_loading_' + source_id);


            return false;
            toggleLoading.fadeIn();

            $.ajax({
                type: 'POST',
                url: toggleUrl,
                data: {
                    'ids': source_id,
                    'status': source_status
                },
                success: function (data) {
                    toggleLoading.hide();
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    alert(thrownError);
                }
            });


        });


        //Init show Hide function
        wpvr_relatedShowHide();
        /**************************************************************************************/

        /* ACTIONS *************************************************************************************/
        //Bulk Confirmation
        $('#doaction').on('click', function (e) {
            e.preventDefault();
            var btn = $(this);

            if (btn.hasClass('isClicked')) {
                return false;
            }

            btn.addClass('isClicked');

            var action = $('#bulk-action-selector-top').attr('value');
            if (action === 'delete') {
                wpvr_confirm(
                    wpvr_localize.confirm_delete_permanently,
                    function () {
                        btn.removeClass('isClicked');
                        btn.unbind('click').click();
                    },
                    wpvr_localize.yes
                    ,
                    function () {
                        btn.removeClass('isClicked');
                    },
                    wpvr_localize.cancel_button
                );
            } else if (action === 'export') {
                btn.removeClass('isClicked');
                btn.unbind('click').click();
            } else if (action === 'update_thumbs') {
                var selection = [];
                $('#the-list .check-column input[type=checkbox]').each(function () {
                    if ($(this).prop('checked')) {
                        selection.push($(this).attr('value'));
                    }
                });

                if (selection.length === 0) {
                    wpvr_alert('Please select at least one item.');
                    setTimeout(function () {
                        btn.removeClass('isClicked');
                    }, 200);

                    return false;
                }
                $('#redownload_video_thumbnails_ids').attr('data-items', selection.join(',')).trigger('click');

                return false;
            } else if (action === 'edit') {

                return false;

            } else {
                btn.removeClass('isClicked');
                btn.unbind('click').click();
            }

            setTimeout(function () {
                btn.removeClass('isClicked');
            }, 200);

            return false;
        });
        $('#doaction2').bind('click', function (e) {
            e.preventDefault();
            var action = $('#bulk-action-selector-bottom').attr('value');
            var btn = $(this);
            if (action === 'delete') {
                wpvr_confirm(
                    wpvr_localize.confirm_delete_permanently,
                    function () {
                        btn.unbind('click').click();
                    },
                    wpvr_localize.yes
                    ,
                    function () {
                    },
                    wpvr_localize.cancel_button
                );
            } else if (action === 'export') {
                $(this).unbind('click').click();
            } else if (action === 'update_thumbs') {
                var selection = [];
                $('#the-list .check-column input[type=checkbox]').each(function () {
                    if ($(this).prop('checked')) {
                        selection.push($(this).attr('value'));
                    }
                });

                $('#redownload_video_thumbnails_ids').attr('data-items', selection.join(',')).trigger('click');


                return false;
            } else if (action === 'edit') {

                return false;

            } else {
                $(this).unbind('click').click();
            }
        });

        //Copy/Add Channel IDS
        $('#wpvr_channel_add_id').bind('click', function () {
            var target = $('#' + $(this).attr('target'));
            var id = $('#wpvr_channel_id').attr('value');
            var ids = target.val();

            if (ids != '') {
                ids = ids.split(',');
                ids.push(id);
                ids = ids.join(',');
            } else {
                ids = id;
            }
            target.val(ids);
            $('#wpvr_channel_id').val('');
        });

        // Reset Retrieving Channel ID
        $('#wpvr_channel_button_reset').bind('click', function () {
            $('#wpvr_channel_id').attr('value', '');
            $('#wpvr_channel_username').attr('value', '');
            $('#wpvr_channel_error').html('').hide();
            $('#wpvr_channel_zone').hide();
        });

        //Retreive Channel ID
        $('#wpvr_channel_retreive').bind('click', function () {
            var btn = $(this);
            var channel_user = $('#wpvr_channel_username').attr('value');
            var service = $('#wpvr_channel_username').attr('service');
            var form_url = btn.attr('url');


            if (channel_user == '') return false;
            var spinner = wpvr_add_loading_spinner(btn, 'pull-right');

            $.ajax({
                type: 'POST',
                url: form_url + '?wpvr_wpload&retrieve_channel',
                data: {
                    'username': channel_user,
                    'service': service,
                },
                success: function (data) {
                    var $json = wpvr_get_json(data);
                    if ($json.status != 0) {
                        $('#wpvr_channel_id').attr('value', $json.data.trim());
                        $('#wpvr_channel_zone').show();
                    } else {

                        var box_error = wpvr_show_loading({
                            title: wpvr_localize.error,
                            text: $json.msg,
                            pauseButton: wpvr_localize.ok_button,
                            isModal: false,
                        });
                        box_error.doPause(function () {
                            box_error.remove();
                        });
                    }
                    wpvr_remove_loading_spinner(spinner);
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    alert(thrownError);
                }
            });

        });

        //Batch Add Selected videos on test result screen
        $('.wpvr_test_form_add').bind('click', function () {
            var btn = $(this);
            var session = btn.attr('session');
            var form = $('#wpvr_test_form');
            var form_url = form.attr('url');

            var selected = [];
            $('.wpvr_video_cb', form).each(function () {
                var input = $(this);
                if (input.prop('checked'))
                    selected.push(input.attr('name'));
            });
            if (selected.length == 0) return false;
            var spinner = wpvr_add_loading_spinner(btn, 'pull-right');
            //Show Loading ...
            var box_loading = wpvr_show_loading({
                title: wpvr_localize.work_in_progress,
                text: wpvr_localize.please_wait + '...',
                isModal: true,
            });
            var toAdd = selected.length;

            $.ajax({
                type: 'POST',
                url: form_url + '?wpvr_wpload&test_add_videos',
                data: {
                    'videos': selected,
                    'session': session,
                },
                success: function (data) {
                    var msg_completed = data + ' / ' + toAdd + ' ' + wpvr_localize.videos_added_successfully + '.';
                    box_loading.remove();
                    var box_ok = wpvr_show_loading({
                        title: wpvr_localize.work_completed,
                        text: msg_completed,
                        pauseButton: wpvr_localize.ok_button,
                        isModal: false,
                    });
                    box_ok.doPause(function () {
                        box_ok.remove();
                    });
                    wpvr_remove_loading_spinner(spinner);
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    alert(thrownError);
                }
            });
        });

        $('.wpvr_unwanted_scope').change(function () {
            $('.wpvr_unwanted_filters').removeClass('global').removeClass('source');
            $('.wpvr_unwanted_filters').addClass($(this).val());
        });

        $('.wpvr_unwanted_refine').click(function (e) {
            e.preventDefault();


            var params = {}, hash;
            var urlArray = document.URL.split('?');
            var urlBase = urlArray [0];
            var q = urlArray [1];

            if (q != undefined) {
                q = q.split('&');
                for (var i = 0; i < q.length; i++) {
                    hash = q[i].split('=');
                }
            }

            params['page'] = 'wpvr-unwanted';

            var page = $('.wpvr_select_page').val();
            var scope = $('.wpvr_unwanted_scope').val();
            if (page > 1) {
                params['xpage'] = $('.wpvr_select_page').val();
            }

            if (scope != 'global') {
                params['scope'] = $('.wpvr_unwanted_scope').val();
            }


            var input_value = $('.wpvr_unwanted_filter .wpvr_dropdown_input[name=service]').val();
            if (input_value != '' && input_value != '[]') {
                params['service'] = input_value;
            }

            var input_value = $('.wpvr_unwanted_filter .wpvr_dropdown_input[name=posttype]').val();
            if (input_value != '' && input_value != '[]') {
                params['posttype'] = input_value;
            }

            var input_value = $('.wpvr_unwanted_filter  .wpvr_dropdown_input[name=source]').val();
            if (input_value != '' && input_value != '[]') {
                params['source'] = input_value;
            }

            var input_value = $('.wpvr_unwanted_filter  .wpvr_unwanted_search').val();
            if (input_value != '' && input_value != '[]') {
                params['se'] = input_value;
            }

            window.location.href = urlBase + '?' + $.param(params);


        });

        //Remove selected deferred videos
        $('.wpvr_test_form_remove').bind('click', function (e) {
            e.preventDefault();
            var btn = $(this);

            if (btn.hasClass('unwanted')) {
                return false;
            }

            if (btn.hasClass('wpvr_isLoading')) return false;
            var form = $('#wpvr_test_form');
            var form_url = form.attr('url');
            var form_action = form.attr('action');
            var selected = [];
            $('.wpvr_video_cb', form).each(function () {
                var input = $(this);
                if (input.prop('checked')) selected.push(input.attr('name'));
            });
            if (selected.length == 0) return false;
            var spinner = wpvr_add_loading_spinner(btn, 'pull-right');
            wpvr_confirm(
                wpvr_localize.want_remove_items,
                function () {

                    var box_loading = wpvr_show_loading({
                        title: wpvr_localize.work_in_progress,
                        text: wpvr_localize.please_wait + '...',
                        isModal: true,
                    });
                    var toAdd = selected.length;

                    $.ajax({
                        type: 'POST',
                        url: wpvr_globals.ajax_url,
                        data: {
                            action: form_action,
                            videos: selected
                        },
                        success: function (data) {
                            $data = wpvr_get_json(data);
                            box_loading.remove();
                            var box_ok = wpvr_show_loading({
                                title: wpvr_localize.work_completed,
                                text: $data.msg,
                                cancelButton: wpvr_localize.ok_button,
                                isModal: false,
                            });
                            box_ok.doCancel(function () {
                                box_ok.remove();
                                wpvr_remove_loading_spinner(spinner);
                                //$('#wpvr_test_form_refresh').trigger('click');
                            });
                            wpvr_remove_loading_spinner(spinner);

                            var countDef = parseInt($('.wpvr_count_deferred').html()) - parseInt(data);

                            $('.wpvr_count_deferred').html(countDef);
                            if (countDef == 0) {
                                $('.wpvr_deferred_videos').fadeOut('slow').remove();
                                $('.wpvr_nothing').fadeIn();
                                $('.wpvr_test_form_buttons').hide();
                            }
                            $('.wpvr_video.checked', form).remove();


                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            alert(thrownError);
                        }
                    });
                },
                wpvr_localize.yes,
                function () {
                    wpvr_remove_loading_spinner(spinner);
                },
                wpvr_localize.cancel_button
            );
        });

        //Remove selected unwanted videos
        $('.wpvr_test_form_remove.unwanted').bind('click', function (e) {
            e.preventDefault();
            var btn = $(this);
            if (btn.hasClass('wpvr_isLoading')) return false;
            var form = $('#wpvr_test_form');
            var form_url = form.attr('url');
            var form_action = form.attr('action');
            var selected = [];
            $('.wpvr_video_cb', form).each(function () {
                var input = $(this);
                if (input.prop('checked')) selected.push({
                    scope: input.attr('scope'),
                    video_id: input.attr('name'),
                    source_id: input.attr('source_id'),
                });
            });

            if (selected.length == 0) return false;
            var spinner = wpvr_add_loading_spinner(btn, 'pull-right');
            wpvr_confirm(
                wpvr_localize.want_remove_items,
                function () {

                    var box_loading = wpvr_show_loading({
                        title: wpvr_localize.work_in_progress,
                        text: wpvr_localize.please_wait + '...',
                        isModal: true,
                    });
                    var toAdd = selected.length;

                    $.ajax({
                        type: 'POST',
                        url: wpvr_globals.ajax_url,
                        data: {
                            action: form_action,
                            videos: selected
                        },
                        success: function (data) {
                            $data = wpvr_get_json(data);
                            box_loading.remove();
                            var box_ok = wpvr_show_loading({
                                title: wpvr_localize.work_completed,
                                text: $data.msg,
                                cancelButton: wpvr_localize.ok_button,
                                isModal: false,
                            });
                            box_ok.doCancel(function () {
                                box_ok.remove();
                                wpvr_remove_loading_spinner(spinner);
                            });
                            wpvr_remove_loading_spinner(spinner);

                            var countDef = parseInt($('.wpvr_count_deferred').html()) - parseInt(data);

                            $('.wpvr_count_deferred').html(countDef);
                            if (countDef == 0) {
                                $('.wpvr_deferred_videos').fadeOut('slow').remove();
                                $('.wpvr_nothing').fadeIn();
                                $('.wpvr_test_form_buttons').hide();
                            }
                            $('.wpvr_video.checked', form).remove();


                        },
                        error: function (xhr, ajaxOptions, thrownError) {
                            alert(thrownError);
                        }
                    });
                },
                wpvr_localize.yes,
                function () {
                    wpvr_remove_loading_spinner(spinner);
                },
                wpvr_localize.cancel_button
            );
        });

        //Add Videos to unwanted from test screen
        $('.wpvr_test_form_unwanted').bind('click', function (e) {
            e.preventDefault();
            var btn = $(this);
            var session = btn.attr('session');

            if (btn.hasClass('wpvr_isLoading')) return false;
            var form = $('#wpvr_test_form');
            var form_url = form.attr('url');

            var videos = [];
            $('.wpvr_video_cb', form).each(function () {
                var input = $(this);
                var video = {
                    'video_id': input.attr('name'),
                    'div_id': input.attr('div_id'),
                    'source_id': input.attr('source_id'),
                };
                if (input.prop('checked')) videos.push(video);
            });
            if (videos.length == 0) {
                btn.shake();
                return false;
            }

            var boxUnwant = wpvr_show_loading({
                title: wpvr_localize.add_to_unwanted,
                text: wpvr_localize.add_to_unwanted_msg,
                cancelButton: wpvr_localize.source_unwanted,
                pauseButton: wpvr_localize.global_unwanted,
                isModal: false,
                unliked_close_button: true,
            });
            boxUnwant.find('.wpvr_loading_close').click(function (e) {
                e.preventDefault();

                return false;
            });
            boxUnwant.doCancel(function () {
                //Source Unwant
                boxUnwant.remove();

                var spinner = wpvr_add_loading_spinner(btn, 'pull-right');
                var box = wpvr_show_loading({
                    title: wpvr_localize.adding_selected_videos,
                    text: wpvr_localize.work_in_progress + "...",
                    progressBar: true, // OR window
                    cancelButton: wpvr_localize.cancel_button, // OR window
                    pauseButton: wpvr_localize.pause_button, // OR window
                    isModal: true,
                });
                box.attr('scope', 'source');
                box.doProgress({pct: 1, text: wpvr_localize.loading_raw + ''});
                box.doHighlight();
                box.attr('work', 1);
                box.attr('pause', 'false');
                box.attr('spinner_id', spinner.attr('id'));
                box.attr('session', session);
                pause_function = function () {
                    var pauseButton = $('.wpvr_loading_pause', box);
                    var k = box.attr('k');
                    var pause = box.attr('pause');


                    if (pause != 'false') {
                        box.doHighlight();
                        box.attr('pause', 'false');
                        pauseButton.html(wpvr_localize.pause_button);
                        box.doText(wpvr_localize.work_in_porogress + '...');

                        wpvr_single_add_unwanted_video(parseInt(k) + 1, videos, form_url, box);
                    } else {
                        box.stopHighlight();
                        box.attr('pause', 123);
                        pauseButton.html(wpvr_localize.continue_button);
                        box.doText(wpvr_localize.work_paused);
                    }


                };
                box.doCancel(function () {
                    box.attr('pause', 'false');
                    pause_function();
                    box.doHide();
                    wpvr_confirm(
                        wpvr_localize.really_want_cancel,

                        function () {
                            box.doShow();
                            pause_function();
                        },
                        wpvr_localize.continue_button,
                        function () { //IF yes
                            box.attr('work', 0);
                            var k = box.attr('k');
                            wpvr_single_add_unwanted_video(parseInt(k), videos, form_url, box);
                            wpvr_remove_loading_spinner(spinner);
                        },
                        wpvr_localize.cancel_anyway
                    );
                });
                box.doPause(pause_function);
                wpvr_single_add_unwanted_video(0, videos, form_url, box);
            });

            boxUnwant.doPause(function () {
                //Global Unwant
                boxUnwant.remove();
                var spinner = wpvr_add_loading_spinner(btn, 'pull-right');
                var box = wpvr_show_loading({
                    title: wpvr_localize.adding_selected_videos,
                    text: wpvr_localize.work_in_progress + "...",
                    progressBar: true, // OR window
                    cancelButton: wpvr_localize.cancel_button, // OR window
                    pauseButton: wpvr_localize.pause_button, // OR window
                    isModal: true,
                });
                box.attr('scope', 'global');
                box.doProgress({pct: 1, text: wpvr_localize.loading_raw + ''});
                box.doHighlight();
                box.attr('work', 1);
                box.attr('pause', 'false');
                box.attr('spinner_id', spinner.attr('id'));
                box.attr('session', session);
                pause_function = function () {
                    var pauseButton = $('.wpvr_loading_pause', box);
                    var k = box.attr('k');
                    var pause = box.attr('pause');


                    if (pause != 'false') {
                        box.doHighlight();
                        box.attr('pause', 'false');
                        pauseButton.html(wpvr_localize.pause_button);
                        box.doText(wpvr_localize.work_in_porogress + '...');

                        wpvr_single_add_unwanted_video(parseInt(k) + 1, videos, form_url, box);
                    } else {
                        box.stopHighlight();
                        box.attr('pause', 123);
                        pauseButton.html(wpvr_localize.continue_button);
                        box.doText(wpvr_localize.work_paused);
                    }


                };
                box.doCancel(function () {
                    box.attr('pause', 'false');
                    pause_function();
                    box.doHide();
                    wpvr_confirm(
                        wpvr_localize.really_want_cancel,

                        function () {
                            box.doShow();
                            pause_function();
                        },
                        wpvr_localize.continue_button,
                        function () { //IF yes
                            box.attr('work', 0);
                            var k = box.attr('k');
                            wpvr_single_add_unwanted_video(parseInt(k), videos, form_url, box);
                            wpvr_remove_loading_spinner(spinner);
                        },
                        wpvr_localize.cancel_anyway
                    );
                });
                box.doPause(pause_function);
                wpvr_single_add_unwanted_video(0, videos, form_url, box);
            });


        });

        //Add videos one at a time from test screen results
        $('.wpvr_test_form_add_each').bind('click', function (e) {
            e.preventDefault();
            var btn = $(this);
            var session = btn.attr('session');
            var form = $('#wpvr_test_form');
            var form_url = form.attr('url');
            is_deferred = btn.attr('is_deferred');


            var videos = [];
            $('.wpvr_video_cb', form).each(function () {
                var input = $(this);
                var video = {
                    'video_id': input.attr('name'),
                    'div_id': input.attr('div_id'),
                };
                if (input.prop('checked')) videos.push(video);
            });
            if (videos.length == 0) {
                btn.shake();
                return false;
            }
            var spinner = wpvr_add_loading_spinner(btn, 'pull-right');
            var box = wpvr_show_loading({
                title: wpvr_localize.adding_selected_videos,
                text: wpvr_localize.work_in_progress + "...",
                progressBar: true, // OR window
                cancelButton: wpvr_localize.cancel_button, // OR window
                pauseButton: wpvr_localize.pause_button, // OR window
                isModal: true,
            });

            box.doProgress({pct: 1, text: wpvr_localize.loading_raw + ''});
            box.doHighlight();
            box.attr('work', 1);
            box.attr('pause', 'false');
            box.attr('is_deferred', is_deferred);
            box.attr('spinner_id', spinner.attr('id'));
            box.attr('session', session);
            box.attr('count_skipped', 0);
            box.attr('start_timestamp', performance.now());
            box.attr('count_added', 0);
            box.attr('count_added_authors', 0);
            box.attr('count_added_comments', 0);
            pause_function = function () {
                var pauseButton = $('.wpvr_loading_pause', box);
                var k = box.attr('k');
                var pause = box.attr('pause');


                if (pause != 'false') {
                    box.doHighlight();
                    box.attr('pause', 'false');
                    pauseButton.html(wpvr_localize.pause_button);
                    box.doText(wpvr_localize.work_in_porogress + '...');

                    wpvr_single_add_video(parseInt(k) + 1, videos, form_url, box);
                } else {
                    box.stopHighlight();
                    box.attr('pause', 123);
                    pauseButton.html(wpvr_localize.continue_button);
                    box.doText(wpvr_localize.work_paused);
                }


            };
            box.doCancel(function () {
                box.attr('pause', 'false');
                pause_function();
                box.doHide();
                wpvr_confirm(
                    wpvr_localize.really_want_cancel,

                    function () {
                        box.doShow();
                        pause_function();
                    },
                    wpvr_localize.continue_button,
                    function () { //IF yes
                        box.attr('work', 0);
                        var k = box.attr('k');
                        wpvr_single_add_video(parseInt(k), videos, form_url, box);
                        wpvr_remove_loading_spinner(spinner);
                    },
                    wpvr_localize.cancel_anyway
                );
            });
            box.doPause(pause_function);

            wpvr_single_add_video(0, videos, form_url, box);
        });

        //Check All videos of the section
        $('.wpvr_check_all_section').bind('click', function (e) {
            e.preventDefault();
            var zone_id = $(this).attr('zone_id');
            var zone = $('#zone_' + zone_id);
            var state = $(this).attr('state');
            if (state == 'off') {
                $('.wpvr_video_cb', zone).prop('checked', true);
                $('.wpvr_video', zone).not('.skipped').addClass('checked').removeClass('wpvr_has_video_info');
                $(this).attr('state', 'on');
            } else {
                $('.wpvr_video_cb', zone).prop('checked', false);
                $('.wpvr_video', zone).not('.skipped').removeClass('checked').addClass('wpvr_has_video_info');
                $(this).attr('state', 'off');
            }


            wpvr_init_video_popover_on_zone(zone);
            wpvr_count_checked();
        });

        //Check All sections
        $('.wpvr_switch_btn').each(function () {
            var btn = $(this);
            btn.lc_switch();
        });
        $('.wpvr_test_form_toggleAll').each(function () {

            $(this).bind('click', function (e) {
                e.preventDefault();
                var zone_id = $(this).attr('zone_id');
                var zone = $('#wpvr_test_form');
                var state = $(this).attr('state');
                if (state == 'off') {
                    $('.wpvr_video_cb', zone).prop('checked', true);
                    $('.wpvr_video', zone).not('.skipped').addClass('checked').removeClass('wpvr_has_video_info');
                    $('.wpvr_test_form_toggleAll').attr('state', 'on');
                } else {
                    $('.wpvr_video_cb', zone).prop('checked', false);
                    $('.wpvr_video', zone).not('.skipped').removeClass('checked').addClass('wpvr_has_video_info');
                    $('.wpvr_test_form_toggleAll').attr('state', 'off');
                }

                wpvr_init_video_popover_on_zone(zone);
                wpvr_count_checked();
            });

        });


        //Refresh the test screen results

        $('body').on('click', '#wpvr_test_form_refresh', function (e) {
            e.preventDefault();
            window.location.reload();
        });

        function wpvr_update_select_colors() {
            $('.wpvrManualOptions').each(function () {
                var s = $('.cmb_select', $(this));
                $(this).removeClass('isOn').removeClass('isOff');
                if (s.attr('value') == 'on') $(this).addClass('isOn');
                else $(this).addClass('isOff');
            });
        }

        wpvr_update_select_colors();

        $('.wpvrManualOptions .cmb_select').change(function () {
            wpvr_update_select_colors();
        });

        $('.wpvr_toggle_grabbing_button').click(function (e) {
            e.preventDefault();
            var btn = $(this);
            var state = btn.attr('state');

            if (state == 'off') var new_value = 'on';
            else var new_value = 'off';

            btn.attr('state', new_value);

            $('.wpvrManualOptions .cmb_select').each(function () {
                $(this).attr('value', new_value);
            });
            wpvr_update_select_colors();
        });

        //Video Result Item on click action
        $('body').on('click', '.wpvr_video', function (e) {
            var video = $(this);

            if (video.hasClass('skipped')) {
                return;
            }
            var state = $('.wpvr_video_cb', video).prop('checked');
            if (state) {
                $('.wpvr_video_cb', video).prop('checked', false);
                video.removeClass('checked').addClass('wpvr_has_video_info');
            } else {
                $('.wpvr_video_cb', video).prop('checked', true);
                video.addClass('checked').removeClass('wpvr_has_video_info');
            }

            wpvr_init_video_popover(video);
            wpvr_count_checked();


        });
        $('body').on('click', '.wpvr_video_edit', function (e) {
            e.preventDefault();
            window.open($(this).attr('link'), '_blank');
            return false;
        });

        $('body').on('click', '.wpvr_video_merge', function (e) {
            e.preventDefault();
            var ids = $(this).attr('ids');
            var views = $(this).attr('views');
            wpvr_apply_bulk_action('merge', ids, views);
            return false;
        });

        $('body').on('click', '.wpvr_video_update', function (e) {
            e.preventDefault();
            var spinner = wpvr_add_loading_spinner($(this), 'pull-right');
            $('#submitdiv #publish').trigger('click');

        });
        $('body').on('click', '.wpvr_video_view', function (e) {
            e.preventDefault();
            var url = $(this).attr('url');
            var service = $(this).attr('service');
            var video_id = $(this).attr('video_id');
            var post_id = $(this).attr('post_id');

            var boxPreview = wpvr_show_loading({
                width: '60%',
                title: wpvr_localize.video_preview,
                text: '<div id="wpvr_video_preview"></div>',
            });

            $.ajax({
                url: wpvr_globals.ajax_url,
                type: 'POST',
                data: {
                    action: 'get_video_preview',
                    post_id: post_id,
                    video_id: video_id,
                    service: service
                },
                success: function (data) {
                    $data = wpvr_get_json(data);

                    $('#wpvr_video_preview').html($data.data);
                    $('.wpvr_loading_msg', boxPreview).center();
                },
                error: function (xhr, ajaxOptions, thrownError) {
                    alert(thrownError);
                }
            });

            return false;
        });


        /* HELPER JS CODE */

        /**********************************************************/

        function wpvr_add_element_counting(target, elt, counter_id) {
            var counter = $('#' + target.attr('counter_id'));
            var str_values = target.val().trim().replace(/(\r\n|\n|\r)/gm, "");
            var arr_values;

            if (str_values != '') arr_values = str_values.split(',');
            else arr_values = [];

            arr_values.push(elt.trim());
            str_values = arr_values.join(",\n");
            target.val(str_values);
            $('#' + counter_id + ' span').html(arr_values.length);

        }

        $('.wpvr_collapse_sections').click(function (e) {
            e.preventDefault();
            var btn = $(this);
            var zone_id = btn.attr('zone_id');
            var is_btn = btn.attr('is_btn');
            btn.toggleClass('open');

            if (zone_id == 'all') {
                var zone = $('.wpvr_source_result');

                if (btn.hasClass('open')) {
                    zone.addClass('open');
                    $('.wpvr_collapse_sections', zone).addClass('open');
                } else {
                    zone.removeClass('open');
                    $('.wpvr_collapse_sections', zone).removeClass('open');
                }
            } else {
                var zone = $('.wpvr_source_result#' + zone_id);
                zone.toggleClass('open');
                if (is_btn == '0') {
                    $('.wpvr_collapse_sections', zone).toggleClass('open');
                }
            }

        });


        $('.wpvr_show_section_authors').click(function (e) {
            e.preventDefault();
            var btn = $(this);
            var state = btn.attr('state');
            var zone_id = btn.attr('zone_id');
            var zone = $('.wpvr_source_result#source_' + zone_id);


            if (state === 'off') {
                btn.attr('state', 'on');
                btn.removeClass('off').addClass('on');

                $('.wpvr_has_video_info', zone).each(function () {
                    wpvr_init_video_popover($(this));
                });
            } else {
                btn.attr('state', 'off');
                btn.removeClass('on').addClass('off');

                $('.wpvr_has_video_info', zone).webuiPopover('destroy');

            }
        });


        $('.wpvr_helper_wrap').each(function () {
            var wrap = $(this);
            var service = wrap.attr('service');
            var helper_url = wrap.attr('helper_url');
            var helper_dest = $('#' + wrap.attr('helper_dest_id'));
            var helper_counter_id = wrap.attr('helper_counter_id');
            var helper_type = wrap.attr('helper_type');
            var helper_append = wrap.attr('helper_append');

            var helper_button = $('.wpvr_helper_button', wrap);
            var helper_input = $('.wpvr_helper_input', wrap);
            var helper_toggler = $('.wpvr_helper_toggler', wrap);
            var helper_form = $('.wpvr_helper_form', wrap);

            helper_input.keypress(function (event) {
                if (event.which == 13) {
                    event.preventDefault();
                    helper_button.trigger('click');
                }
            });


            helper_toggler.click(function (e) {
                e.preventDefault();
                $(this).toggleClass('closed');
                helper_form.toggle();
            });

            helper_button.click(function (e) {
                e.preventDefault();
                var helper_value = helper_input.attr('value');
                if (helper_value == '') return false;

                var spinner = wpvr_add_loading_spinner(helper_button);

                $.ajax({
                    type: 'POST',
                    url: wpvr_globals.ajax_url,
                    data: {
                        helper_value: helper_value,
                        helper_type: helper_type,
                        service: service,
                        action: 'use_helper',
                    },
                    success: function (data) {
                        wpvr_remove_loading_spinner(spinner);
                        var $json = wpvr_get_json(data);
                        var boxHelper = wpvr_show_loading({
                            title: 'Helper : ' + helper_type,
                            text: wpvr_localize.loadingCenter,
                            isModal: false,
                            cancelButton: '<i class="fa fa-times"></i> Close Helper',
                        });

                        boxHelper.doCancel(function () {
                            boxHelper.doClose();
                        });
                        if ($json.status != 1) {
                            boxHelper.doText($json.msg);
                            $('.wpvr_loading_msg', boxHelper).center();
                        }
                        var lines = '';
                        $.each($json.data, function (i, item) {

                            if (i % 2 == 1) var odd = 'odd';
                            else var odd = '';
                            lines = lines +
                                '<div class="wpvr_helper_item ' + odd + '" >' +
                                '<div style="visbility:hidden;opacity:0;" class="wpvr_helper_item_thumb pull-left">' +
                                '<img src="' + item.thumb + '" />' +
                                '</div>' +
                                '<button class="wpvr_helper_choose" item_id="' + item.id + '" >' +
                                'Choose this ' + item.label +
                                '</button>' +
                                '<div class="wpvr_helper_item_main">' +
                                '<div class="wpvr_helper_item_main_txt">' + item.name + '</div><br/>' +
                                '</div>' +
                                '<div class="wpvr_clearfix"></div>' +
                                '</div>'
                            ;

                            var list = '<div class="wpvr_helper_list">' + lines + '</div>';
                            boxHelper.doText(list);
                            $('.wpvr_loading_msg', boxHelper).center();

                            $('.wpvr_helper_choose', boxHelper).click(function (e) {
                                var item_id = $(this).attr('item_id');

                                if (helper_append != 1) {
                                    helper_dest.attr('value', item_id);
                                } else {
                                    wpvr_add_element_counting(helper_dest, item_id, helper_counter_id);
                                }
                                helper_input.attr('value', '');
                                boxHelper.doClose();
                            });

                        });
                    },
                    error: function (xhr, ajaxOptions, thrownError) {
                        alert(thrownError);
                    }
                });


            });
        });


        $('.wpvr_autoClean_fields#autoCleanSchedule').change(function () {
            var value = $(this).attr('value');
            if (value == 'weekly') {
                $('.wpvr_autoClean_scheduleTime_wrap').fadeIn();
                $('.wpvr_autoClean_scheduleDay_wrap').fadeIn();
            } else if (value == 'daily') {
                $('.wpvr_autoClean_scheduleTime_wrap').fadeIn();
                $('.wpvr_autoClean_scheduleDay_wrap').hide();
            } else {
                $('.wpvr_autoClean_scheduleTime_wrap').hide();
                $('.wpvr_autoClean_scheduleDay_wrap').hide();
            }
        });

        $('.wpvr_autoClean_fields#autoCleanSchedule').each(function () {
            var value = $(this).attr('value');
            if (value == 'weekly') {
                $('.wpvr_autoClean_scheduleTime_wrap').fadeIn();
                $('.wpvr_autoClean_scheduleDay_wrap').fadeIn();
            } else if (value == 'daily') {
                $('.wpvr_autoClean_scheduleTime_wrap').fadeIn();
                $('.wpvr_autoClean_scheduleDay_wrap').hide();
            } else {
                $('.wpvr_autoClean_scheduleTime_wrap').hide();
                $('.wpvr_autoClean_scheduleDay_wrap').hide();
            }
        });


    });

    window.wpvr_script_loaded = true;

});

function wpvr_draw_doughnut(canevasObject, data) {

    var chart_options = {
        animateScale: true,
        animationSteps: 50,
        animationEasing: "easeOutQuart",
        maintainAspectRatio: false,
        responsive: true,
        legend: {
            display: false,
        },
        cutoutPercentage: 60,
        scaleStartValue: 0,
        scaleStepWidth: 50,
        animation: {
            onComplete: function (animation) {
                var fact = canevasObject.siblings('.wpvr_xchart_fact');
                //Center fact with canevas
                fact.css({
                    "position": "absolute",
                    "top": (((canevasObject.height() - fact.outerHeight()) / 2) + canevasObject.scrollTop() + "px"),
                    "left": (((canevasObject.width() - fact.outerWidth()) / 2) + canevasObject.scrollLeft() + "px")
                }).fadeIn();

            },
        },
    };
    canevasObject.attr("width", canevasObject.parent().width());
    var ctx = canevasObject.get(0).getContext("2d");

    var wpvr_chart_object = new Chart(ctx, {
        type: 'doughnut',
        data: data,
        options: chart_options,
    });
    return wpvr_chart_object;
}


