jQuery(document).ready(function () {

    function wpvr_scroll_to_target(target, offset) {
        var targetTop = target.offset().top - parseInt(offset);
        $('html, body').animate({scrollTop: targetTop}, 'fast');
    }

    function wpvr_is_js_function(functionToCheck) {
        return functionToCheck && {}.toString.call(functionToCheck) === '[object Function]';
    }

    function wpvr_notices_init_buttons(context) {

        jQuery('.wpvr_notices_button,.wpvr_notices_link', context).each(function () {
            var btn = jQuery(this);
            var token = btn.data('token');
            var button_js = window.wpvr_notices_js_functions[token];

            if (wpvr_is_js_function(button_js.click)) {
                btn.click(function (e) {
                    button_js.click(e);
                });
            }

            if (wpvr_is_js_function(button_js.hover)) {
                btn.on('hover', function (e) {
                    button_js.hover(e);
                })
            }
        });


        jQuery('.wpvr_notices_tour_nav', context).click(function (e) {
            e.preventDefault();

            WebuiPopovers.hide(jQuery(this).data('tour_source'));


            // wpvr_scroll_to_target( jQuery(jQuery(this).data('tour_target' )) , 120 );


            WebuiPopovers.show(jQuery(this).data('tour_target'));


        });

    }

    wpvr_notices_init_buttons(jQuery('body'));

    jQuery('.wpvr_notices_popover_wrap').each(function () {
        var notice_wrap = jQuery(this);
        var notice = jQuery('.wpvr_notices_popover', notice_wrap);
        var notice_args = notice.data();

        var target = jQuery(notice_args.popover_target);

        target.webuiPopover({
            content: notice_wrap.html(),
            trigger: 'manual',
            closeable: false,
            backdrop: true,
            dismissible: false,
            autoHide: false,
            style: 'wpvr_notices_popover',
            // delay: {//show and hide delay time of the popover, works only when trigger is 'hover',the value can be number or object
            //     show: notice_args.popover_delay,
            //     hide: 0
            // },
            placement: notice_args.popover_placement,
            animation: 'pop',
            width: '600px',
            onShow: function ($el) {
                target.addClass('popovered');
                wpvr_notices_init_buttons($el);
                wpvr_scroll_to_target(target, 120);
            },
            onHide: function ($el) {
                target.removeClass('popovered');
            },
        });
        if (notice_args.init_only == '0') {
            setTimeout(function () {
                target.webuiPopover('show');
            }, notice_args.popover_delay);
        }


    });

    jQuery('.wpvr_notices_dialog').each(function () {
        var notice = jQuery(this);
        var notice_args = notice.data();

        setTimeout(function () {
            var noticeBox = wpvr_show_loading({
                title: notice_args.dialog_title,
                text: atob(notice_args.dialog_text),
                isModal: notice_args.dialog_ismodal,
                maskClass: notice_args.dialog_maskclass,
                boxClass: notice_args.dialog_boxclass,
            });

            wpvr_notices_init_buttons(noticeBox);

        }, notice_args.dialog_delay);


    });

});