<?php
/**
 *  WP-SpamShield Dynamic JS File
 *  Version: 1.9.35
 */

define( 'WPSS_DEBUG', FALSE );
define( 'WPSS_DISABLE_TIMER', FALSE );
if( 0 === strpos( PHP_SAPI, 'cli' ) || empty( $_SERVER ) || empty( $_SERVER['REQUEST_URI'] ) ) { return; }

/* Security Check - BEGIN */
if( !empty( $_GET ) || FALSE !== strpos( $_SERVER['REQUEST_URI'], '?' ) || !empty( $_SERVER['QUERY_STRING'] ) ) {
	@header( 'HTTP/1.0 403 Forbidden', TRUE, 403 );
	die( 'ERROR: This resource will not function with a query string. Remove the query string from the URL and try again.' );
}
$request_method = ( empty( $_SERVER['REQUEST_METHOD'] ) ) ? '' : strtoupper( $_SERVER['REQUEST_METHOD'] );
if( $request_method !== 'GET' && $request_method !== 'HEAD' ) {
	@header( 'Allow: GET,HEAD', TRUE ); @header( 'HTTP/1.0 405 Method Not Allowed', TRUE, 405 );
	die( 'ERROR: This resource does not accept requests of that type.' );
}
/* Security Check - END */

if( TRUE !== WPSS_DEBUG ) { @ini_set( 'display_errors', 0 ); @error_reporting( 0 ); }

/* Timer Start */
$start_time = microtime( TRUE );
$current_dt = $_SERVER['REQUEST_TIME'];

/* INITIALIZE VARS */
date_default_timezone_set( 'UTC' );

define( 'WPSS_DS',			DIRECTORY_SEPARATOR			);
define( 'WPSS_SERVER_NAME',	wpss_js_get_server_name()	);

/* SESSION CHECK AND FUNCTIONS - BEGIN */
global $session_id, $is_https, $this_url;
$session_id	= @session_id();
$is_https	= wpss_js_is_https();
$this_url	= wpss_js_get_url();

if( empty( $session_id ) && !headers_sent() ) { @session_start(); $session_id = @session_id(); }

if( !defined( 'WPSS_SERVER_NAME_NODOT' ) ) { define( 'WPSS_SERVER_NAME_NODOT', ( str_replace( '.', '', WPSS_SERVER_NAME ) ) ); }
if( !defined( 'WPSS_HASH_ALT' ) ) { define( 'WPSS_HASH_ALT', ( md5( WPSS_SERVER_NAME_NODOT ) ) ); }
if( !defined( 'WPSS_SITE_URL' ) && !empty( $_SESSION['wpss_site_url_'.WPSS_HASH_ALT] ) ) {
	define( 'WPSS_SITE_URL', ( $_SESSION['wpss_site_url_'.WPSS_HASH_ALT] ) );
}
if( defined( 'WPSS_SITE_URL' ) && !defined( 'WPSS_HASH' ) ) {
	define( 'WPSS_HASH', ( md5( WPSS_SITE_URL ) ) );
} elseif( !empty( $_SESSION ) && !empty( $_COOKIE ) && !defined( 'WPSS_HASH' ) ) {
	foreach( $_COOKIE as $ck_name => $ck_v ) {
		if( preg_match( "~^comment_author_([a-z0-9]{32})$~i", $ck_name, $matches ) ) { define( 'WPSS_HASH', $matches[1] ); break; }
	}
}
$lang_ck_key	= 'UBR_LANG'; $lang_ck_val = 'default';
$current_ip		= $_SERVER['REMOTE_ADDR'];
$current_pt		= ( !empty( $_SERVER['REMOTE_PORT'] ) ) ? $_SERVER['REMOTE_PORT'] : '';
$current_ua		= wpss_js_get_user_agent();
$current_mt		= $start_time;	/* Site entry time - microtime( TRUE ) */
/* SESSION CHECK AND FUNCTIONS - END */

if( defined( 'WPSS_HASH' ) && !empty( $_SESSION ) ) {
	/**
	 *	IP, PAGE HITS, PAGES VISITED HISTORY - BEGIN
	 *	Initial IP Address when visitor first comes to site
	 *		IP History		- Lets see if they change IPs
	 *		Port History	- Can be telling when spammers change IPs
	 *		Page hits		- This page is more reliable than main if caching is on, so we'll keep a separate count
	 *		Referrer Hist	- More reliable way to keep a list of pages, than using main
	 */
	$key_init				= array( 'ip', 'pt', 'ua', 'mt', 'dt', );
	$key_slug				= array( 'pages_hist' => 'jscripts_referers_history', 'hits_per_page' => 'jscripts_referers_history_count', 'total_page_hits' => 'page_hits_js', 'ip_hist' => 'jscripts_ip_history', 'pt_hist' => 'jscripts_pt_history', 'init_ip' => 'user_ip_init', 'init_pt' => 'user_pt_init', 'init_ua' => 'user_agent_init', 'init_mt' => 'time_init', 'init_dt' => 'timestamp_init', );
	$ck_key_init_dt			= 'NCS_INENTIM'; if( empty( $_COOKIE[$ck_key_init_dt] ) ) { $new_visit = TRUE; } $key_all = array();
	foreach( $key_slug as $k => $v ) { $key_all['key_'.$k] = 'wpss_'.$v.'_' . WPSS_HASH; }; extract( $key_all );
	foreach( $key_init as $i => $k ) { if( empty( $_SESSION[ ${'key_init_'.$k} ] ) ) { $_SESSION[ ${'key_init_'.$k} ] = ${'current_'.$k}; } }
	foreach( array( 'ip', 'pt' ) as $i => $k ) {
		if( empty( $_SESSION[${'key_'.$k.'_hist'}] ) ) { $_SESSION[${'key_'.$k.'_hist'}] = array(); $_SESSION[${'key_'.$k.'_hist'}][] = ${'current_'.$k}; }
		if( ${'current_'.$k} !== $_SESSION[${'key_init_'.$k}] || !in_array( ${'current_'.$k}, $_SESSION[${'key_'.$k.'_hist'}] ) ) { $_SESSION[${'key_'.$k.'_hist'}][] = ${'current_'.$k}; }
	}

	if( empty( $_SESSION[$key_total_page_hits] ) ) { $_SESSION[$key_total_page_hits] = 0; }; ++$_SESSION[$key_total_page_hits];
	if( empty( $_SESSION[$key_pages_hist] ) ) { $_SESSION[$key_pages_hist] = array(); }
	if( empty( $_SESSION[$key_hits_per_page] ) ) { $_SESSION[$key_hits_per_page] = array(); }
	if( !empty( $_SERVER['HTTP_REFERER'] ) ) {
		$current_ref	= wpss_js_get_referer();
		$key_last_ref	= 'wpss_jscripts_referer_last_' . WPSS_HASH;
		$_SESSION[$key_pages_hist][] = $current_ref;
		if( !isset( $_SESSION[$key_hits_per_page][$current_ref] ) ) { $_SESSION[$key_hits_per_page][$current_ref] = 1; }; ++$_SESSION[$key_hits_per_page][$current_ref];
		/* Last Referrer */
		if( empty( $_SESSION[$key_last_ref] ) ) { $_SESSION[$key_last_ref] = ''; }; $_SESSION[$key_last_ref] = $current_ref;
	}
	/* Initial Referrer - Where Visitor Entered Site // External Referrer --> Landing Page */
	$key_first_ref = 'wpss_referer_init_' . WPSS_HASH;
	if( empty( $_SESSION[$key_first_ref] ) && !empty( $_COOKIE['JCS_INENREF'] ) && FALSE === strpos( $_COOKIE['JCS_INENREF'], WPSS_SERVER_NAME ) ) { $_SESSION[$key_first_ref] = $_COOKIE['JCS_INENREF']; }
	/* IP, PAGE HITS, PAGES VISITED HISTORY - END */

	/* AUTHOR, EMAIL, URL HISTORY - BEGIN */

	/**
	 *	Keep history of Author, Author Email, and Author URL in case they keep changing
	 *	This will expose spammer behavior patterns
	 *	Comment Author, Comment Author Email, Comment Author URL
	 */

	$key_hist_slug = array( 'author', 'author_email', 'author_url' );
	foreach( $key_hist_slug as $i => $k ) {
		$slug = 'key_'.$k; $slug_hist = 'key_'.$k.'_hist';
		${'key_'.$k.'_hist'} = 'wpss_'.$k.'_history_' . WPSS_HASH; ${$slug} = 'comment_'.$k.'_' . WPSS_HASH;
		if( empty( $_SESSION[${$slug_hist}] ) ) {
			$_SESSION[${$slug_hist}] = array();
			if( !empty( $_COOKIE[${$slug}] ) ) { $_SESSION[${$slug}] = $_COOKIE[${$slug}]; $_SESSION[${$slug_hist}][] = $_COOKIE[${$slug}]; }
		} elseif( !empty( $_COOKIE[${$slug}] ) ) { $_SESSION[${$slug}] = $_COOKIE[${$slug}]; }
	}
	/* AUTHOR, EMAIL, URL HISTORY - END */

	/* SESSION USER BLACKLIST CHECK - BEGIN */
	if( !empty( $_SESSION['wpss_clear_blacklisted_user_' . WPSS_HASH] ) ) { $cl_sbluck = TRUE; unset( $_SESSION['wpss_blacklisted_user_' . WPSS_HASH] ); }
	elseif( !empty( $_SESSION['wpss_blacklisted_user_' . WPSS_HASH] ) && empty( $_COOKIE[$lang_ck_key] ) ) { $sbluck = TRUE; }
	elseif( !empty( $_COOKIE[$lang_ck_key] ) && $_COOKIE[$lang_ck_key] == $lang_ck_val ) { $_SESSION['wpss_blacklisted_user_' . WPSS_HASH] = TRUE; }
	/* SESSION USER BLACKLIST CHECK - END */
}

/* STANDARD FUNCTIONS - BEGIN */
function wpss_js_timer( $start = 0, $end = 0 ) {
	if( empty( $start ) || empty( $end ) ) { $start = $end = 0; }
	return number_format( ( $end - $start ), 6 );
}

function wpss_js_get_user_agent() {
	return !empty( $_SERVER['HTTP_USER_AGENT'] ) ? wpss_js_sanitize_string( $_SERVER['HTTP_USER_AGENT'] ) : '';
}
function wpss_js_get_referer() {
	return !empty( $_SERVER['HTTP_REFERER'] ) ? wpss_js_sanitize_string( $_SERVER['HTTP_REFERER'] ) : '';
}

function wpss_js_is_https() {
	return (
			( !empty( $_SERVER['HTTPS'] )					&& 'off'	!==	$_SERVER['HTTPS']					)
		||	( !empty( $_SERVER['SERVER_PORT'] )				&& '443'	 ==	$_SERVER['SERVER_PORT']				)
		||	( !empty( $_SERVER['HTTP_X_FORWARDED_PROTO'] )	&& 'https'	=== $_SERVER['HTTP_X_FORWARDED_PROTO']	)
		||	( !empty( $_SERVER['HTTP_X_FORWARDED_SSL'] )	&& 'off'	!== $_SERVER['HTTP_X_FORWARDED_SSL']	)
	);
}

function wpss_js_get_server_addr() {
	if( !empty( $_SERVER['SERVER_ADDR'] ) ) { $server_addr = $_SERVER['SERVER_ADDR']; }
	elseif( !empty( $_SERVER['LOCAL_ADDR'] ) ) { $server_addr = $_SERVER['SERVER_ADDR'] = $_SERVER['LOCAL_ADDR']; }
	return !empty( $server_addr ) ? $server_addr : '';
}

function wpss_js_get_server_name() {
	if( !empty( $_SERVER['HTTP_HOST'] ) ) {
		$server_name = $_SERVER['HTTP_HOST'];
	} elseif( !empty( $_SERVER['SERVER_NAME'] ) ) {
		$server_name = $_SERVER['HTTP_HOST'] = $_SERVER['SERVER_NAME'];
	}
	return ( !empty( $server_name ) && '.' !== trim( $server_name ) ) ? strtolower( $server_name ) : '';
}

function wpss_js_get_url() {
	global $is_https;
	$scheme = ( $is_https ) ? 'https://' : 'http://';
	return $scheme . WPSS_SERVER_NAME . $_SERVER['REQUEST_URI'];
}

function wpss_js_get_ck_dir() {
	global $this_url;
	$path		= __FILE__;
	$jscripts	= WPSS_DS . 'wp-content' . WPSS_DS . 'plugins' . WPSS_DS . 'wp-spamshield' . WPSS_DS . 'js' . WPSS_DS . 'jscripts.php';
	$path_guess	= str_replace( $jscripts, '', $path );
	$wp_cnf		= $path_guess . WPSS_DS . 'wp-config.php';
	$ck_dir		= ( file_exists( $wp_cnf ) && !empty( $_SERVER['DOCUMENT_ROOT'] ) ) ? str_replace( WPSS_DS, '/', str_replace( $_SERVER['DOCUMENT_ROOT'], '', $path_guess ) . WPSS_DS ) : '/';
	if( FALSE !== strpos( $ck_dir, 'public_html' ) ) {
		$arr	= (array) explode( 'public_html', $ck_dir );
		$ck_dir	= trim( (string) end( $arr ) );
	}
	return ( FALSE !== strpos( $this_url, WPSS_SERVER_NAME . $ck_dir ) && FALSE === strpos( $ck_dir, 'public_html' ) && FALSE === strpos( $ck_dir, '/htdocs/' ) && FALSE === strpos( $ck_dir, WPSS_SERVER_NAME ) ) ? $ck_dir : '/';
}

function wpss_js_sanitize_string( $str) {
	$str=trim( addslashes( htmlentities( stripslashes( strip_tags( $str ) ) ) ) );
	return str_replace( chr( 0 ), '', $str );
}
/* STANDARD FUNCTIONS - END */

/* SET COOKIE VALUES - BEGIN */
if( empty( $session_id ) ) { $session_id = @session_id(); }
$DATE_C_YYMM	= date( 'ym', $current_dt );
$SJECT			= 'SJECT' . $DATE_C_YYMM;
$CKONT			= 'CK0NT' . $DATE_C_YYMM; /* @mod 1.9.35 'CKON' to 'CK0NT' */
$ck_jq_slug		= array( 'ck_key', 'ck_val', 'jq_key', 'jq_val', ); $ck_jq_key = array();
$ck_dir			= wpss_js_get_ck_dir();
$ck_sec			= ( $is_https ) ? 'secure' : '';
foreach( $ck_jq_slug as $i => $k ) { $ck_jq_key[$k] = md5( 'wpss_' . str_replace( '_', '', $k ) . '_' . WPSS_SERVER_NAME_NODOT . '_' . $session_id ); }; extract( $ck_jq_key );
/* SET COOKIE VALUES - END */

/* Last thing before headers sent */
$_SESSION['wpss_sess_status'] = 'on';
if( !empty( $current_ref ) && preg_match( "~([&\?])form\=response$~i", $current_ref ) && !empty( $_SESSION[$key_author] ) ) {
	@setcookie( $key_author, $_SESSION[$key_author], 0, $ck_dir, NULL, $is_https );
	if( !empty( $_SESSION[$key_author_email] )	) { @setcookie( $key_author_email,	$_SESSION[$key_author_email],	0, $ck_dir, NULL, $is_https ); }
	if( !empty( $_SESSION[$key_author_url] )	) { @setcookie( $key_author_url,	$_SESSION[$key_author_url],		0, $ck_dir, NULL, $is_https ); }
}
if( !empty( $new_visit ) ) {
	@setcookie( $ck_key_init_dt, $current_dt, ( $current_dt + 3600 ), $ck_dir, WPSS_SERVER_NAME, $is_https, TRUE ); /* 1 hour */
}
if( !empty( $cl_sbluck ) ) {
	@setcookie( $lang_ck_key, $lang_ck_val, ( $current_dt - 31536000 ), $ck_dir, WPSS_SERVER_NAME, $is_https ); /* -1 year (delete cookie)*/
	unset( $_SESSION['wpss_clear_blacklisted_user_'.WPSS_HASH], $_SESSION['wpss_blacklisted_user_'.WPSS_HASH] );
}elseif( !empty( $sbluck ) ) {
	@setcookie( $lang_ck_key, $lang_ck_val, ( $current_dt + ( 60 * 60 * 24 * 365 * 10 ) ), $ck_dir, WPSS_SERVER_NAME, $is_https, TRUE ); /* 10 years */
}
@setcookie( $ck_key, $ck_val, ( $current_dt + ( 60 * 60 * 4 ) ), $ck_dir, WPSS_SERVER_NAME, $is_https, TRUE ); /* 4 hours - Keep this line as backstop for cache control on browsers with aggressive caching: Safari, etc. */
@setcookie( strtolower( $CKONT ), strtolower( $SJECT . '_' . strrev( uniqid() ) ), ( $current_dt + ( 60 * 5 ) ), $ck_dir, WPSS_SERVER_NAME, $is_https, TRUE ); /* 5 minutes - Cache control - setting cookies turns off Varnish caching for this script */

/**
 *	Control caching
 *	Remove some headers
 *	Set headers:
 *	- 'Cache-Control'		- HTTP/1.1 - Tell browsers and proxies not to cache this
 *	- 'Surrogate-Control'	- Tell surrogates (gateway caches/reverse proxies) not to cache this
 *	- 'Pragma'				- HTTP/1.0 - Tell browsers and proxies not to cache this
 *	- 'Expires'				- Date in the past
 *	- 'Vary'				- Force no caching
 *	- 'Content-Type'		- Tell browser this is JavaScript
 *	- 'X-Robots-Tag'		- Tell search engines not to index this
 */
$rem_hdr = array( 'Cache-Control', 'Last-Modified', 'ETag', );
$set_hdr = array( 'Cache-Control: private, no-store, no-cache, must-revalidate, max-age=0, proxy-revalidate, s-maxage=0', 'Surrogate-Control: no-cache, must-revalidate, max-age=0', 'Pragma: no-cache', 'Expires: Tue, 11 Sep 2001 12:46:40 GMT', 'Vary: *', 'Content-Type: application/javascript; charset=UTF-8', 'X-Robots-Tag: none', );
foreach( $rem_hdr as $i => $h ) { @header_remove( $h ); }; foreach( $set_hdr as $i => $h ) { @header( $h, TRUE ); }

$content = ''; /* Note: 1e3 = 1000 */
$content .= "function wpss_set_ckh(n,v,e,p,d,s){var t=new Date;t.setTime(t.getTime());if(e){e=e*1e3}var u=new Date(t.getTime()+e);document.cookie=n+'='+encodeURIComponent(v)+(e?';expires='+u.toGMTString()+';max-age='+e/1e3+';':'')+(p?';path='+p:'')+(d?';domain='+d:'')+(s?';secure':'')}function wpss_init_ckh(){wpss_set_ckh('" . $ck_key . "','" . $ck_val . "','" . ( 60 * 60 * 4 ) . "','" . $ck_dir . "','" . WPSS_SERVER_NAME . "','" . $ck_sec . "');wpss_set_ckh('" . $SJECT . "','" . $CKONT . "','" . ( 60 * 60 * 1 ) . "','" . $ck_dir . "','" . WPSS_SERVER_NAME . "','" . $ck_sec . "');}wpss_init_ckh();jQuery(document).ready(function($){var h=\"form[method='post']\";\$(h).submit(function(){\$('<input>').attr('type','hidden').attr('name','" . $jq_key . "').attr('value','" . $jq_val . "').appendTo(h);return true;})});" . "\n";

/* Timer */
if( TRUE !== WPSS_DISABLE_TIMER ) {
	$end_time		= microtime( TRUE );
	$total_time		= wpss_js_timer( $start_time, $end_time );
	$js_generated	= "// Generated in: " . $total_time . ' seconds' . "\n";
	/* Time = 0.00000, or too long, indicate server/config error */
	$js_generated .= ( empty( $total_time ) || $total_time > .5 ) ? "// ERROR: There is an error in your server configuration or website setup." . "\n" : ''; /* @mod 1.9.35 */
	$content .= $js_generated;
}

echo $content;
