<?php
global $pro_ads_statistics, $wppas_stats;


$html = '';

$time = mktime(0,0,0, $args['month'], $args['day'], $args['year']);
$sdate = mktime(0,0,0, $args['month'], $args['day'], $args['year']);
$edate = mktime(23,59,59, $args['month'], $args['day'], $args['year']);

$select = $wppas_stats->decode_array( $args['select'] );

// Title
if(!empty($select))
{
	$skey = key($select);
	$html.= '<h1>';
		$html.= sprintf(__('Stats for %s: %s', 'wpproads'), $skey, '#'.$select[$skey].' - '.get_the_title($select[$skey]));
	$html.= '</h1>';	
}
else
{
	$html.= '<h1>'.__('Statistics','wpproads').'</h1>';
}


// Stats
if( $args['s_type'] == 'day')
{	
	$html.= '<div style="background-color:#abdb6d; color:#FFF; font-size:24px; text-align:center;">';
		$html.= sprintf(__('Stats for %s'), date_i18n('l, M d, Y', $time));
	$html.= '</div>';
	
	$impr = $wppas_stats->_get_daily_stats(wp_parse_args(array('type' => 'impressions'), $args));
	$clicks = !empty($impr) ? $wppas_stats->_get_daily_stats(wp_parse_args(array('type' => 'clicks'), $args)) : 0;
	$ctr = $wppas_stats->get_ctr(array('clicks' => $clicks, 'impressions' => $impr));
	
	$html.= '<table style="border: 1px solid #EFEFEF;">';
		
		$html.= '<tr>';
			$html.= '<td style="text-align:center; background-color:#666; color:#FFF;">';
				$html.= '<div>'.__('Total Impressions','wpproads').'</div>';
				$html.= '<div style="font-size:14px;">'.$impr.'</div>';
			$html.= '</td>';
			$html.= '<td style="text-align:center; background-color:#666; color:#FFF;">';
				$html.= '<div>'.__('Total Clicks','wpproads').'</div>';
				$html.= '<div style="font-size:14px;">'.$clicks.'</div>';
			$html.= '</td>';
			$html.= '<td style="text-align:center; background-color:#666; color:#FFF;">';
				$html.= '<div>'.__('CTR','wpproads').'</div>';
				$html.= '<div style="font-size:14px;">'.$ctr.'</div>';
			$html.= '</td>';
		$html.= '</tr>';
		
	$html.= '</table>';
	
	$html.= '<table style="border: 1px solid #EFEFEF;">';
		
		$html.= '<tr>';
			$html.= '<th style="border: 1px solid #EFEFEF; border-bottom:1px solid #666; background-color:#EFEFEF;"><strong style="padding:10px;">'.__('Time','wpproads').'</strong></th>';
			$html.= '<th style="border: 1px solid #EFEFEF; border-bottom:1px solid #666; background-color:#EFEFEF;"><strong>'.__('Impressions','wpproads').'</strong></th>';
			$html.= '<th style="border: 1px solid #EFEFEF; border-bottom:1px solid #666; background-color:#EFEFEF;"><strong>'.__('Clicks','wpproads').'</strong></th>';
			$html.= '<th style="border: 1px solid #EFEFEF; border-bottom:1px solid #666; background-color:#EFEFEF;"><strong>'.__('CTR','wpproads').'</strong></th>';
		$html.= '</tr>';
		
		
		$stats = $wppas_stats->load_daily_stats(array(
			'select' => '*',
			'where'  => 'time >= '.$sdate.' AND time <= '.$edate,
			'limit'  => 1
		));
		$unique_str = $args['unique'] ? 'unique_' : '';
		$unique_both = $args['unique'] ? 'unique' : 'all';
			
		if( !empty($stats))
		{
			$array = json_decode($stats[0]->data,true);
			$array = !empty($select) ? $this->filter_stats_array($array, $select) : $array;
			
			foreach($array as $key => $arr)
			{
				if( !empty($arr))
				{
					$impr = $arr['hourly_'.$unique_str.'impressions'];
					$clicks = array_key_exists('hourly_'.$unique_str.'clicks',$arr) ? $arr['hourly_'.$unique_str.'clicks'] : 0;
					
					if( !empty($impr) || !empty($clicks) )
					{
						$ctr = $wppas_stats->get_ctr(array('clicks' => $clicks, 'impressions' => $impr));
						$html.= '<tr>';
							$html.= '<td style="border: 1px solid #EFEFEF;">'.date_i18n('G:i',$key).'</td>';
							$html.= '<td style="border: 1px solid #EFEFEF;"><strong>'.$impr.'</strong> '.__('Impressions','wpproads').'</td>';
							$html.= '<td style="border: 1px solid #EFEFEF;"><strong>'.$clicks.'</strong> '.__('Clicks','wpproads').'</td>';
							$html.= '<td style="border: 1px solid #EFEFEF;">'.__('CTR','wpproads').': <strong>'.$ctr.'</strong></td>';
						$html.= '</tr>';
					}
				}
			}
		}	
		
	$html.= '</table>';
}
elseif( $args['s_type'] == 'month')
{
	$am_days = cal_days_in_month(CAL_GREGORIAN, $args['month'], $args['year']);
	
	$sdate = mktime(0,0,0, $args['month'], 1, $args['year']);
	$edate = mktime(23,59,59, $args['month'], $am_days, $args['year']);
			
	//$stats = $wppas_stats->create_stats_array(array('start' => $sdate, 'end' => $edate));
	
	$html.= '<div style="background-color:#abdb6d; color:#FFF; font-size:24px; text-align:center;">';
		$html.= sprintf(__('Stats for %s'), date_i18n('F, Y', $time));
	$html.= '</div>';
	
	$impr = $wppas_stats->_get_monthly_stats(wp_parse_args(array('type' => 'impressions'), $args));
	$clicks = !empty($impr) ? $wppas_stats->_get_monthly_stats(wp_parse_args(array('type' => 'clicks'), $args)) : 0;
	$ctr = $wppas_stats->get_ctr(array('clicks' => $clicks, 'impressions' => $impr));
	
	$html.= '<table style="border: 1px solid #EFEFEF;">';
		$html.= '<tr>';
			$html.= '<td style="background-color:#666; height:1px;"></td>';
			$html.= '<td style="background-color:#666; height:1px;"></td>';
			$html.= '<td style="background-color:#666; height:1px;"></td>';
		$html.= '</tr>';
		$html.= '<tr>';
			$html.= '<td style="text-align:center; background-color:#666; color:#FFF;">';
				$html.= '<div>'.__('Total Impressions','wpproads').'</div>';
				$html.= '<div style="font-size:18px;">'.$impr.'</div>';
			$html.= '</td>';
			$html.= '<td style="text-align:center; background-color:#666; color:#FFF;">';
				$html.= '<div>'.__('Total Clicks','wpproads').'</div>';
				$html.= '<div style="font-size:18px;">'.$clicks.'</div>';
			$html.= '</td>';
			$html.= '<td style="text-align:center; background-color:#666; color:#FFF;">';
				$html.= '<div>'.__('CTR','wpproads').'</div>';
				$html.= '<div style="font-size:18px;">'.$ctr.'</div>';
			$html.= '</td>';
		$html.= '</tr>';
		$html.= '<tr>';
			$html.= '<td style="background-color:#666; height:1px;"></td>';
			$html.= '<td style="background-color:#666; height:1px;"></td>';
			$html.= '<td style="background-color:#666; height:1px;"></td>';
		$html.= '</tr>';
	$html.= '</table>';
	
	$html.= '<table style="border: 1px solid #EFEFEF;">';
		
		$html.= '<tr>';
			$html.= '<th style="border: 1px solid #EFEFEF; border-bottom:1px solid #666; background-color:#EFEFEF;"><strong style="padding:10px;">'.__('Day','wpproads').'</strong></th>';
			$html.= '<th style="border: 1px solid #EFEFEF; border-bottom:1px solid #666; background-color:#EFEFEF;"><strong>'.__('Impressions','wpproads').'</strong></th>';
			$html.= '<th style="border: 1px solid #EFEFEF; border-bottom:1px solid #666; background-color:#EFEFEF;"><strong>'.__('Clicks','wpproads').'</strong></th>';
			$html.= '<th style="border: 1px solid #EFEFEF; border-bottom:1px solid #666; background-color:#EFEFEF;"><strong>'.__('CTR','wpproads').'</strong></th>';
		$html.= '</tr>';
		
		for( $i = 1; $i <= $am_days; $i++ )
		{
			$sdate = mktime(0,0,0, $args['month'], $i, $args['year']);
			$edate = mktime(23,59,59, $args['month'], $i, $args['year']);
			$time = mktime(0,0,0, $args['month'], $i, $args['year']);
			
			$impr = $wppas_stats->_get_daily_stats( wp_parse_args(array('start' => $sdate, 'end' => $edate, 'day' => $i, 'type' => 'impressions'), $args) );
			//echo date('d.m.Y',$sdate).' '.$i.':'.$impr.'<br>';
			if( !empty($impr))
			{
				$clicks = $wppas_stats->_get_daily_stats( wp_parse_args(array('start' => $sdate, 'end' => $edate, 'day' => $i, 'type' => 'clicks'), $args) );
				$ctr = $wppas_stats->get_ctr(array('clicks' => $clicks, 'impressions' => $impr));
				
				$html.= '<tr>';
					$html.= '<td style="border: 1px solid #EFEFEF;">'.date('D, d F',$time).'</td>';
					$html.= '<td style="border: 1px solid #EFEFEF;"><strong>'.$impr.'</strong> '.__('Impressions','wpproads').'</td>';
					$html.= '<td style="border: 1px solid #EFEFEF;"><strong>'.$clicks.'</strong> '.__('Clicks','wpproads').'</td>';
					$html.= '<td style="border: 1px solid #EFEFEF;">'.__('CTR','wpproads').': <strong>'.$ctr.'</strong></td>';
				$html.= '</tr>';
			}
		}
		
	$html.= '</table>';
}
elseif( $args['s_type'] == 'year')
{	
	$html.= '<div style="background-color:#abdb6d; color:#FFF; font-size:24px; text-align:center;">';
		$html.= sprintf(__('Stats for %s'), $args['year']);
	$html.= '</div>';
	
	$sdate = mktime(0,0,0, 1, 1, $args['year']);
	$edate = mktime(23,59,59, 12, 31, $args['year']);
	
	$impr = $wppas_stats->_get_yearly_stats(wp_parse_args(array('type' => 'impressions'), $args));
	$clicks = !empty($impr) ? $wppas_stats->_get_yearly_stats(wp_parse_args(array('type' => 'clicks'), $args)) : 0;
	$ctr = $wppas_stats->get_ctr(array('clicks' => $clicks, 'impressions' => $impr));
	
	$html.= '<table style="border: 1px solid #EFEFEF;">';
		$html.= '<tr>';
			$html.= '<td style="background-color:#666; height:1px;"></td>';
			$html.= '<td style="background-color:#666; height:1px;"></td>';
			$html.= '<td style="background-color:#666; height:1px;"></td>';
		$html.= '</tr>';
		$html.= '<tr>';
			$html.= '<td style="text-align:center; background-color:#666; color:#FFF;">';
				$html.= '<div>'.__('Total Impressions','wpproads').'</div>';
				$html.= '<div style="font-size:18px;">'.$impr.'</div>';
			$html.= '</td>';
			$html.= '<td style="text-align:center; background-color:#666; color:#FFF;">';
				$html.= '<div>'.__('Total Clicks','wpproads').'</div>';
				$html.= '<div style="font-size:18px;">'.$clicks.'</div>';
			$html.= '</td>';
			$html.= '<td style="text-align:center; background-color:#666; color:#FFF;">';
				$html.= '<div>'.__('CTR','wpproads').'</div>';
				$html.= '<div style="font-size:18px;">'.$ctr.'</div>';
			$html.= '</td>';
		$html.= '</tr>';
		$html.= '<tr>';
			$html.= '<td style="background-color:#666; height:1px;"></td>';
			$html.= '<td style="background-color:#666; height:1px;"></td>';
			$html.= '<td style="background-color:#666; height:1px;"></td>';
		$html.= '</tr>';
	$html.= '</table>';
	
	$html.= '<table style="border: 1px solid #EFEFEF;">';
		
		$html.= '<tr>';
			$html.= '<th style="border: 1px solid #EFEFEF; border-bottom:1px solid #666; background-color:#EFEFEF;"><strong style="padding:10px;">'.__('Month','wpproads').'</strong></th>';
			$html.= '<th style="border: 1px solid #EFEFEF; border-bottom:1px solid #666; background-color:#EFEFEF;"><strong>'.__('Impressions','wpproads').'</strong></th>';
			$html.= '<th style="border: 1px solid #EFEFEF; border-bottom:1px solid #666; background-color:#EFEFEF;"><strong>'.__('Clicks','wpproads').'</strong></th>';
			$html.= '<th style="border: 1px solid #EFEFEF; border-bottom:1px solid #666; background-color:#EFEFEF;"><strong>'.__('CTR','wpproads').'</strong></th>';
		$html.= '</tr>';
		
		$am_days = cal_days_in_month(CAL_GREGORIAN, $args['month'], $args['year']);
		
		for( $i = 1; $i <= 12; $i++ )
		{
			$time = mktime(0,0,0, $i, $args['day'], $args['year']);
			
			$impr = $wppas_stats->_get_monthly_stats( wp_parse_args(array('month' => $i, 'type' => 'impressions'), $args) );
			
			if( !empty($impr))
			{
				$clicks = $wppas_stats->_get_monthly_stats( wp_parse_args(array('month' => $i, 'type' => 'clicks'), $args) );
				$ctr = $wppas_stats->get_ctr(array('clicks' => $clicks, 'impressions' => $impr));
			
				$html.= '<tr>';
					$html.= '<td style="border: 1px solid #EFEFEF;">'.date('F',$time).'</td>';
					$html.= '<td style="border: 1px solid #EFEFEF;"><strong>'.$impr.'</strong> '.__('Impressions','wpproads').'</td>';
					$html.= '<td style="border: 1px solid #EFEFEF;"><strong>'.$clicks.'</strong> '.__('Clicks','wpproads').'</td>';
					$html.= '<td style="border: 1px solid #EFEFEF;">'.__('CTR','wpproads').': <strong>'.$ctr.'</strong></td>';
				$html.= '</tr>';
			}
		}
		
	$html.= '</table>';
}
elseif( $args['s_type'] == 'all')
{
	$html.= '<div style="background-color:#abdb6d; color:#FFF; font-size:24px; text-align:center;">';
		$html.= __('All Time Stats');
	$html.= '</div>';
	
	$years = $wppas_stats->get_stat_years();
	$l = count($years)-1;
	
	$start = mktime(0,0,0, 1, 1, $years[0]);
	$end = mktime(23,59,59, 31, 12, $years[$l]);
	
	$impr = $wppas_stats->_get_alltime_stats(wp_parse_args(array('type' => 'impressions'), $args));
	$clicks = !empty($impr) ? $wppas_stats->_get_alltime_stats(wp_parse_args(array('type' => 'clicks'), $args)) : 0;
	$ctr = $wppas_stats->get_ctr(array('clicks' => $clicks, 'impressions' => $impr));
	
	$html.= '<table style="border: 1px solid #EFEFEF;">';
		$html.= '<tr>';
			$html.= '<td style="background-color:#666; height:1px;"></td>';
			$html.= '<td style="background-color:#666; height:1px;"></td>';
			$html.= '<td style="background-color:#666; height:1px;"></td>';
		$html.= '</tr>';
		$html.= '<tr>';
			$html.= '<td style="text-align:center; background-color:#666; color:#FFF;">';
				$html.= '<div>'.__('Total Impressions','wpproads').'</div>';
				$html.= '<div style="font-size:18px;">'.$impr.'</div>';
			$html.= '</td>';
			$html.= '<td style="text-align:center; background-color:#666; color:#FFF;">';
				$html.= '<div>'.__('Total Clicks','wpproads').'</div>';
				$html.= '<div style="font-size:18px;">'.$clicks.'</div>';
			$html.= '</td>';
			$html.= '<td style="text-align:center; background-color:#666; color:#FFF;">';
				$html.= '<div>'.__('CTR','wpproads').'</div>';
				$html.= '<div style="font-size:18px;">'.$ctr.'</div>';
			$html.= '</td>';
		$html.= '</tr>';
		$html.= '<tr>';
			$html.= '<td style="background-color:#666; height:1px;"></td>';
			$html.= '<td style="background-color:#666; height:1px;"></td>';
			$html.= '<td style="background-color:#666; height:1px;"></td>';
		$html.= '</tr>';
	$html.= '</table>';
	
	$html.= '<table style="border: 1px solid #EFEFEF;">';
		
		$html.= '<tr>';
			$html.= '<th style="border: 1px solid #EFEFEF; border-bottom:1px solid #666; background-color:#EFEFEF;"><strong style="padding:10px;">'.__('Time','wpproads').'</strong></th>';
			$html.= '<th style="border: 1px solid #EFEFEF; border-bottom:1px solid #666; background-color:#EFEFEF;"><strong>'.__('Impressions','wpproads').'</strong></th>';
			$html.= '<th style="border: 1px solid #EFEFEF; border-bottom:1px solid #666; background-color:#EFEFEF;"><strong>'.__('Clicks','wpproads').'</strong></th>';
			$html.= '<th style="border: 1px solid #EFEFEF; border-bottom:1px solid #666; background-color:#EFEFEF;"><strong>'.__('CTR','wpproads').'</strong></th>';
		$html.= '</tr>';
		
		$years = $wppas_stats->get_stat_years();
		foreach($years as $i => $year)
		{
			$impr = $wppas_stats->_get_yearly_stats( wp_parse_args(array('year' => $year, 'type' => 'impressions'), $args) );
			
			if( !empty($impr))
			{
				$clicks = $wppas_stats->_get_yearly_stats( wp_parse_args(array('year' => $year, 'type' => 'clicks'), $args) );
				$ctr = $wppas_stats->get_ctr(array('clicks' => $clicks, 'impressions' => $impr));
			
				$html.= '<tr>';
					$html.= '<td style="border: 1px solid #EFEFEF;">'.$year.'</td>';
					$html.= '<td style="border: 1px solid #EFEFEF;"><strong>'.$impr.'</strong> '.__('Impressions','wpproads').'</td>';
					$html.= '<td style="border: 1px solid #EFEFEF;"><strong>'.$clicks.'</strong> '.__('Clicks','wpproads').'</td>';
					$html.= '<td style="border: 1px solid #EFEFEF;">'.__('CTR','wpproads').': <strong>'.$ctr.'</strong></td>';
				$html.= '</tr>';
			}
		}
		
	$html.= '</table>';
}
?>