/**********************************
 * WPPAS VBC EDITOR 4.7.6 
 * @author Tunafish
***********************************/
(function( $ ) {
	"use strict";
	
	var _W = $.fn.wppas;

	$.extend(true, _W, {
		
		/**
		 * START SCREEN - SETTINGS
		 *
		 *
		 */
		startscreen: function(options) {
			
			var _t = $(this),
				//_wppas = _t.wppas(),
				banner_size = $('#wppas_banner_size').val();
			
			// Wait for page to be loaded
			_t.wppas.onReady(function (){
				$('.wppas_loading_vbc').hide();
				$('#vbc_main_area').show();
				$('#wppas_banner_work_area').find('.work_area_info .current_view_size').html($('#wppas_banner_work_area').width()+'px');
			});
			
			// switching between tabs
			$('#vbc_menu').wppas.tabs({container: '.vbc_main_tabs_container', ul: '.vbc_main_menu_toggle', screen_sizes: options.screen_sizes});
			
			
			// Select default banner size
			$('.wppas_banner_sizes').find('.wppas_home_tpl_btn').removeClass('selected');
			$(".wppas_banner_sizes").find("[data-type='" + banner_size+"']").addClass('selected');
			var bsize = banner_size.split('x');
			$('#custom_bsize_w').val(bsize[0]);
			$('#custom_bsize_h').val(bsize[1]);
			var w = bsize[0] != 'full' ? (bsize[0]*100)/800 : 100,
				h = bsize[1] != 'full' ? (bsize[1]*100)/800 : 100;
			$('.custom_bsize_preview').css({width: w+'%', height: h+'%'});
			$('.custom_bsize_preview').removeClass('full');	
			if( w == 100 ){
				$('.custom_bsize_preview').addClass('full');	
			}
			
			
			
			// -- CHANGE BANNER SIZE --
			$('#wppas_banner_size').on('change', function(){
				
				var bsize = $(this).val().split('x');
				$('.wppas_home_tpl_btn').removeClass('selected');
				$(".wppas_info_btns").find("[data-type='" + bsize[0]+"x"+bsize[1]+"']").addClass('selected');
			});
			
			// -- BANNER SIZE BUTTONS --
			$('.bsize').on('click', function(){
				
				var bsize = $(this).data('type').split('x');
				
				$('.wppas_home_tpl_btn').removeClass('selected');
				$(this).addClass('selected');
				
				//$('#wppas_banner_size option[value="'+bsize[0]+'x'+bsize[1]+'"]').prop('selected', true);
				$('#wppas_banner_size').val(bsize[0]+'x'+bsize[1]);
				
				$('#custom_bsize_w').val('');
				$('#custom_bsize_h').val('');
				
				_t.wppas.update_banner_size(bsize);
			});
			
			
			// -- CUSTOM BSIZE --
			$('#custom_bsize_w').on('change', function(){
				var _s = $(this).val() != '' ? $(this).val() : 100,
					w = (_s*100)/800,
					h = $('#custom_bsize_h').val() != '' ? $('#custom_bsize_h').val() : 100,
					size = _s+'x'+h,
					bsize = size.split('x');
					
				$('.custom_bsize_preview').css({width: w+'%'});
				$('#wppas_banner_size').val(size);
				$('.wppas_home_tpl_btn').removeClass('selected');
				
				_t.wppas.update_banner_size(bsize);
			});
			$('#custom_bsize_h').on('change', function(){
				var _s = $(this).val() != '' ? $(this).val() : 100,
					h = (_s*100)/800,
					w = $('#custom_bsize_w').val() != '' ? $('#custom_bsize_w').val() : 100,
					size = w+'x'+_s,
					bsize = size.split('x');
					
				$('.custom_bsize_preview').css({height: h+'%'});
				$('#wppas_banner_size').val(size);
				$('.wppas_home_tpl_btn').removeClass('selected');
				
				_t.wppas.update_banner_size(bsize);
			});
			
			
			
			// -- Open banner editor --
			$('.open_banner_editor').on('click', function(){
				
				var target = $(this).data('target'),
					container = $(this).data('container');
				
				_t.wppas.select_tab({target: target, container: container});
				/*if( !$(this).hasClass('disabled') ){
				
					var bsize = $('#wppas_banner_size').val();
					
					$.ajax({
					   type: "POST",
					   url: ajaxurl,
					   data: "action=load_banner_editor&bsize="+ bsize
					}).done(function( msg ) {
				
						$('#vbc_content_container').html( msg );
						
						_t.wppas.activate_switch_buttons();
					});
				}else{
					console.log('Button Disabled');
				}*/
				
			});
			
		}
		
	});
	
}( jQuery ));