/**********************************
 * WPPAS 4.7.6 
 * @author Tunafish
***********************************/
(function( $ ) {
	"use strict";
	
	var windowsize = $(window).size();
		
	$.fn.extend({
		
		wppas: function(options) {
			
		},
		
		/*
		 * SHOW BANNERS
		 */
		wppas_show: function(options) {
			
			var defaults = {
				bid: 0,
				bw: 300,
				effect: '',
				scale: 1,
				//sizes_arr: {},
				html: {},
				force_size: 0
			};
			
			// Merge of Defaults									
			options = $.extend(true,{},defaults, options);
			
			var _t = $(this),
				ID = !options.ID ? options.bid : options.ID,
				bsizes_arr = [];
			
			// SHOW
			if(options.effect == ''){
				_t.show();
			}
			
			
			$.each(options.html, function( index, value ) {
				bsizes_arr.push(Number(index));
			});
			
			

			$(this).each(function() {
				
				if( !$(this).hasClass('lded') ){
				
					// LOAD BANNER HTML
					_t.wppas.banner_html({
						bsizes_arr: bsizes_arr,
						itm: $(this),  
						ID: ID,
						options: options
					});
				
					// On resize
					_t.wppas.window_resize({bsizes_arr: bsizes_arr, ID: ID, options:options, itm: '.b_cont_'+ID}); // $(this) does not work in this case...
					
					// Reload banner html if needed.
					if(typeof options.timeline_arr != 'undefined'){
						if( typeof options.timeline_arr['main'] !== 'undefined' && options.timeline_arr['main']!== null){
							if( typeof options.timeline_arr.main.btime != 'undefined' && options.timeline_arr.main.btime != ""){
								
								setTimeout(function(){
									_t.html('');
									_t.removeClass('lded');
									_t.wppas_show(options);
								}, options.timeline_arr.main.btime);
							}
						}
					}
					
					
					
					// set bg color
					if( typeof options.timeline_arr['main'] !== 'undefined' && options.timeline_arr['main']!== null){
						if( typeof options.timeline_arr.main.bbg != 'undefined'){
							$(this).css({'background-color': options.timeline_arr.main.bbg});
						}else{
							$(this).css({'background-color': 'transparent'});
						}
					}
					
					
					$(this).addClass('lded');
				}
					
			});
		},
		
		
		
		/*
		 * SHOW ADZONES
		 */
		wppas_show_adzone: function(options) {
			
			var defaults = {
				aid: 0,
				w: 300,
				effect: ''
			};
			
			// Merge of Defaults									
			options = $.extend(true,{},defaults, options);
			
			var _t = $(this),
				ID = !options.ID ? options.aid : options.ID;
			
			// SHOW
			if(options.effect == ''){
				_t.show();
			}
			
		}
	});
	
	
	
	
	var _W = $.fn.wppas;
	var windowsize = $(window).width();

	$.extend(true, _W, {
		
		
		banner_html: function(args) {
			
			var _t = $(this),
				cw = args.itm.width() < args.options.w ? args.itm.width() : $(window).width(),
				fsize = _t.wppas.closest(args.options.force_size, args.bsizes_arr), 
				size = args.options.force_size ? fsize : _t.wppas.closest_higher(cw, args.bsizes_arr), 
				itm = args.itm;
		
			_t.wppas.aspect_ratio_sizing({editor:0, keep_aspect_ratio:args.options.keep_aspect_ratio, options:args.options, itm:itm});
			//console.log(size);
			itm.html( args.options.html[size] );
			itm.find('.layer').hide().css({opacity:0});
			
			// Activate Layers
			_t.wppas.activate_layers(args); //args.rand_class
			
			// select Google Fonts
			_t.wppas.load_google_fonts({itm: itm});
			
			if(args.options.scale == 1){
				_t.wppas.scale_banner(itm);
			}
		},
		
		
		
		
		/**
		 * ALIGN LAYERS
		 *
		 *
		 */
		align_layers: function($itm, args){
			
			
			var _t = $(this),
				$unit = ''; // px
			
			
			// HORIZONTAL
			$itm.removeClass('left center right');
			if( args['pos_h'] == 'left'){
				$itm.addClass('left');
				var pos_left = args['left'] == '' ? 0 : _t.wppas.get_value(args['left'])+$unit;
				$itm.css({'left': pos_left, 'right':'auto', 'margin':'auto'});
			}else if( args['pos_h'] == 'center'){
				$itm.addClass('center');
				var pos_right = args['right'] == '' ? 0 : _t.wppas.get_value(args['right'])+$unit,
					pos_left = args['left'] == '' ? 0 : _t.wppas.get_value(args['left'])+$unit;
				$itm.css({'left': pos_left, 'right': pos_right, 'margin':'auto'});
			}else if( args['pos_h'] == 'right'){
				$itm.addClass('right');
				var pos_right = args['right'] == '' ? 0 : _t.wppas.get_value(args['right'])+$unit;
				$itm.css({'right': pos_right, 'left':'auto', 'margin':'auto'});
			}
			
			// VERTICAL
			$itm.removeClass('top middle bottom');
			if( args['pos_v'] == 'top'){
				$itm.addClass('top');
				var pos_top = args['top'] == '' ? 0 : _t.wppas.get_value(args['top'])+$unit;
				$itm.css({'top': pos_top, 'bottom':'auto'});
			}else if( args['pos_v'] == 'middle'){
				$itm.addClass('middle');
				var pos_top = args['top'] == '' ? 0 : _t.wppas.get_value(args['top'])+$unit,
					pos_bottom = args['bottom'] == '' ? 0 : _t.wppas.get_value(args['bottom'])+$unit;
				$itm.css({'top': pos_top, 'bottom': pos_bottom});
				
			}else if( args['pos_v'] == 'bottom'){
				$itm.addClass('bottom');
				var pos_bottom = args['bottom'] == '' ? 0 : _t.wppas.get_value(args['bottom'])+$unit;
				$itm.css({'bottom': pos_bottom, 'top':'auto'});
			}
				
		},
		
		
		
		/**
		 * ACTIVATE LAYERS
		 *
		 *
		 */
		activate_layers: function(args){
			
			$.each(args.itm.find('.layer'), function(i, obj) {
				
				var _t = $(this),
					layer_id = $(obj).data('itm'),
					cw = args.itm.width() < args.options.w ? args.itm.width() : $(window).width(),
					fsize = _t.wppas.closest(args.options.force_size, args.bsizes_arr), 
					size = args.options.force_size ? fsize : _t.wppas.closest_higher(cw, args.bsizes_arr);
					//size = $(this).wppas.closest_higher(cw, args.bsizes_arr);
				
				// DECODE LAYER HTML
				if( $(this).hasClass('enc') || $(this).hasClass('html') ){
					//var inner_html = atob();
					var inner_html = decodeURIComponent($(this).html());
					// @since v5.2.1 - Fix for scripts
					$(this).html('');
					// FIX for SVG postscribe bug
					// http://jsfiddle.net/Znpxv/75/
					// https://github.com/krux/postscribe/issues/348
					if( $(obj).data('type') == 'svg'){
						//console.log('svg');
						$(this).html(inner_html.replace(/[%]27/g, "'"));
						//inner_html = inner_html.replace("xmlns:", "");
						//inner_html = inner_html.replace(/xmlns:/g, "");
						//inner_html = inner_html.replace(/xml:/g, "");
					}else{
						postscribe($(this), inner_html.replace(/[%]27/g, "'"));
					}
					//postscribe($(this), inner_html.replace(/[%]27/g, "'"));
				}
				$.each($(this).find('.enc'), function(i, obj) {
					//console.log($(obj).html());
					var inner_html = decodeURIComponent($(obj).html());
					$(obj).html('');
					postscribe($(obj), inner_html.replace(/[%]27/g, "'"));
				});
				
					 
				// IF ANIMATION IS AVAILABLE
				if( typeof args.options.timeline_arr != 'undefined'){
					var timeline_arr = typeof args.options.timeline_arr[size] !== 'undefined' ? args.options.timeline_arr[size] : args.options.timeline_arr[1200];
					if( typeof timeline_arr !== 'undefined'){
						if( typeof timeline_arr[layer_id] !== 'undefined'){
							if( typeof timeline_arr[layer_id].animation !== 'undefined'){
								var animation = timeline_arr[layer_id].animation,
									data = {
										obj: obj,
										type: animation.start_animation_type,
										end_type: animation.end_animation_type,
										start: animation.start_time,
										end: animation.end_time,
										// defaults
										itm: args.itm,
										itm_h: args.itm.height(),
										itm_w: args.itm.width(),
										trans_sec: animation.start_animation_speed,
										start_pos_offset: animation.start_pos_offset,
										end_trans_sec: animation.end_animation_speed,
										trans_effect: animation.start_animation_effect, //'linear',
										end_trans_effect: animation.end_animation_effect, //'linear',
										end_repeat: animation.end_animation_repeat, //'linear',
										fade_in_speed: animation.fade_in_speed,
										fade_out_speed: animation.fade_out_speed,
									};
								//console.log(data);
								// START Animations
								
								$(this).wppas.start_layer_animation(data);
				
							}else{
								$(obj).fadeIn(500);
							}
						}else{
							$(obj).fadeIn(500);
						}
					}else{
						$(obj).fadeIn(500);
					}
				}else{
					$(obj).fadeIn(500);
				}
			});
			
			
		},
		
		
		
		
		
		
		/**
		 * START LAYER ANIMATION
		 *
		 *
		 */
		start_layer_animation: function(args){
			
			// START Animations
			$(args.obj).wppas.layer_animations(args, 'start');
		},
		
		
		/**
		 * END LAYER ANIMATION
		 *
		 *
		 */
		end_layer_animation: function(args){
			
			if(args.end > 0){
				setTimeout(function() {
					$(args.obj).wppas.layer_animations(args, 'end');
				}, Number(args.end));
			}
		},
		
		
		
		/**
		 * ACTIVATE LAYERS
		 *
		 *
		 */
		layer_animations: function(args, pos){
			
			var _t = $(this),
				type = args.type,
				end_type = args.end_type,
				obj = args.obj;
			
			// START ANIMATIONS ------------------------------------------------------------------------------------
			if( pos == 'start'){
				// No Animation -----------------------------------------------------------------------
				if( type == '' || typeof type == 'undefined'){
					$(obj).show().css({opacity:1});
				}
				// FADE IN -----------------------------------------------------------------------
				else if( type == 'fade_in' ){
					$(obj).delay(Number(args.start)).show().animate({opacity:1}, Number(args.fade_in_speed), 'linear', function(){
						
						// END ANimations
						_t.wppas.end_layer_animation(args);	
					});
				}
				// SLIDE from BOTTOM to TOP	-----------------------------------------------------------------------
				else if( type == 'from_bottom'){
					
					if( $(obj).css('top') != 'auto' ){
						var layer = $(obj).css('top').split('px'),
							fade_in_speed = args.fade_in_speed != '' ? Number(args.fade_in_speed) : 0;
						
						$(obj).css({'top': args.itm_h+'px', 'opacity': 0});
						setTimeout(function() {
						//$(obj).delay(Number(args.start), function(n){
							$(obj).show().animate({'opacity': 1}, {duration:fade_in_speed, queue:false}, 'linear');	
							$(obj).show().animate({'top': _t.wppas.get_value(layer[0])}, {easing:args.trans_effect, duration:Number(args.trans_sec), queue:false, complete: function(){
								// END ANimations
								_t.wppas.end_layer_animation(args);	
							}});
						}, Number(args.start));
				
					}else if( $(obj).css('bottom') != 'auto' ){
						var layer = $(obj).css('bottom').split('px'),
							fade_in_speed = args.fade_in_speed != '' ? Number(args.fade_in_speed) : 0;
						
						$(obj).css({'bottom': -$(obj).height()+'px', 'opacity': 0});
						setTimeout(function() {
							$(obj).show().animate({'opacity': 1}, {duration:fade_in_speed, queue:false}, 'linear');
							$(obj).show().animate({'bottom': _t.wppas.get_value(layer[0])}, {easing:args.trans_effect, duration:Number(args.trans_sec), queue:false, complete: function(){
								// END ANimations
								_t.wppas.end_layer_animation(args);	
							}});
						}, Number(args.start));
					}
				}
				// SLIDE from TOP to BOTTOM -----------------------------------------------------------------------
				else if( type == 'from_top' ){
					
					if( $(obj).css('top') != 'auto' ){
						var layer = $(obj).css('top').split('px'),
							fade_in_speed = args.fade_in_speed != '' ? Number(args.fade_in_speed) : 0,
							start_pos_offset = Number(args.start_pos_offset),
							start_pos = ((-args.itm_h)-($(obj).height()+start_pos_offset));
						//console.log('TOP START: '+start_pos+' '+start_pos_offset);
						
						$(obj).css({'top': start_pos+'px', 'opacity': 0});
						//$(obj).delay(Number(args.start)).queue(function(n){
						setTimeout(function() {
							$(obj).show().animate({'opacity': 1}, {duration:fade_in_speed, queue:false}, 'linear');
							$(obj).show().animate({'top': _t.wppas.get_value(layer[0])}, {easing:args.trans_effect, duration:Number(args.trans_sec), queue:false, complete: function(){
								// END ANimations
								_t.wppas.end_layer_animation(args);	
							}});
						}, Number(args.start));
						
					}else if( $(obj).css('bottom') != 'auto' ){
						var layer = $(obj).css('bottom').split('px'),
							fade_in_speed = args.fade_in_speed != '' ? Number(args.fade_in_speed) : 0;
						
						$(obj).css({'bottom': args.itm_h+'px', 'opacity': 0});
						setTimeout(function() {
							$(obj).show().animate({'opacity': 1}, {duration:fade_in_speed, queue:false}, 'linear');
							$(obj).show().animate({'bottom': _t.wppas.get_value(layer[0])}, {easing:args.trans_effect, duration:Number(args.trans_sec), queue:false, complete: function(){
								// END ANimations
								_t.wppas.end_layer_animation(args);	
							}});
						}, Number(args.start));
					}else{
						var layer = 0,
							fade_in_speed = args.fade_in_speed != '' ? Number(args.fade_in_speed) : 0;
						
						$(obj).css({'top': -$(obj).height()+'px', 'opacity': 0});
						setTimeout(function() {
							$(obj).show().animate({'opacity': 1}, {duration:fade_in_speed, queue:false}, 'linear');
							$(obj).show().animate({'top': _t.wppas.get_value(layer)}, {easing:args.trans_effect, duration:Number(args.trans_sec), queue:false, complete: function(){
								// END ANimations
								_t.wppas.end_layer_animation(args);	
							}});
						}, Number(args.start));
					}
				}
				// SLIDE from LEFT to RIGHT -----------------------------------------------------------------------
				else if( type == 'from_left' ){
					
					if( $(obj).css('left') != 'auto' ){
						var layer = $(obj).css('left').split('px'),
							fade_in_speed = args.fade_in_speed != '' ? Number(args.fade_in_speed) : 0;
						
						$(obj).css({'left': -$(obj).width()+'px', 'opacity': 0});
						setTimeout(function() {
							$(obj).show().animate({'opacity': 1}, {duration:fade_in_speed, queue:false}, 'linear');
							$(obj).show().animate({'left': _t.wppas.get_value(layer[0])}, {easing:args.trans_effect, duration:Number(args.trans_sec), queue:false, complete: function(){
								// END ANimations
								_t.wppas.end_layer_animation(args);
							}});
						}, Number(args.start));
						
					}else if( $(obj).css('right') != 'auto' ){
						var layer = $(obj).css('right').split('px'),
							fade_in_speed = args.fade_in_speed != '' ? Number(args.fade_in_speed) : 0;
						//console.log($(obj));
						//console.log(_t.wppas.get_value(layer[0]));
						$(obj).css({'right': _t.wppas.get_value((args.itm_w+$(obj).width())), 'opacity': 0});
						setTimeout(function() {
							$(obj).show().animate({'opacity': 1}, {duration:fade_in_speed, queue:false}, 'linear');
							$(obj).show().animate({'right': _t.wppas.get_value(layer[0])}, {easing:args.trans_effect, duration:Number(args.trans_sec), queue:false, complete: function(){
								// END ANimations
								_t.wppas.end_layer_animation(args);	
							}});
						}, Number(args.start));
					}
				}
				// SLIDE from RIGHT to LEFT -----------------------------------------------------------------------
				else if( type == 'from_right' ){
					
					if( $(obj).css('left') != 'auto' ){
						var layer = $(obj).css('left').split('px'),
							fade_in_speed = args.fade_in_speed != '' ? Number(args.fade_in_speed) : 0;
						
						$(obj).css({'left': args.itm_w+'px'});
						setTimeout(function() {
							$(obj).show().animate({'opacity': 1}, {duration:fade_in_speed, queue:false}, 'linear');
							$(obj).show().animate({'left': _t.wppas.get_value(layer[0])}, {easing:args.trans_effect, duration:Number(args.trans_sec), queue:false, complete: function(){
								// END ANimations
								_t.wppas.end_layer_animation(args);	
							}});
						}, Number(args.start));
						
					}else if( $(obj).css('right') != 'auto' ){
						var layer = $(obj).css('right').split('px'),
							fade_in_speed = args.fade_in_speed != '' ? Number(args.fade_in_speed) : 0;
						
						$(obj).css({'right': -$(obj).width()+'px'});
						setTimeout(function() {
							$(obj).show().animate({'opacity': 1}, {duration:fade_in_speed, queue:false}, 'linear');
							$(obj).show().animate({'right': _t.wppas.get_value(layer[0])}, {easing:args.trans_effect, duration:Number(args.trans_sec), queue:false, complete: function(){
								
								// END ANimations
								_t.wppas.end_layer_animation(args);	
							}});
						}, Number(args.start));
					}
				}
			}
			
			
			
			// END ANIMATIONS ------------------------------------------------------------------------------------
			if( pos == 'end'){
				
				if( end_type == ''){
					$(obj).delay(args.end).animate({opacity:0}, 0, function(){
						$(this).hide();	
						
						// REPEAT if needed.
						if( args.end_repeat == 1){
							_t.wppas.start_layer_animation(args);
						}
					});
				}
				// FADE OUT
				else if( end_type == 'fade_out' ){
					//$(obj).delay(args.end).fadeOut(args.fade_out_speed);
					$(obj).animate({opacity:0}, Number(args.fade_out_speed), function(){
						$(this).hide();
						
						// REPEAT if needed.
						if( args.end_repeat == 1){
							_t.wppas.start_layer_animation(args);
						}	
					});
				}
				// SLIDE OUT to TOP	-----------------------------------------------------------------------
				else if( end_type == 'to_top'){
					
					//if( $(obj).css('top') != 'auto' ){
						var layer = $(obj).css('top'),
							layer_top = $(obj).css('top'),
							layer_bottom = $(obj).css('bottom'),
							opacity = args.fade_out_speed != undefined ? 0 : 1,
							fade_out_speed = args.fade_out_speed != '' ? Number(args.fade_out_speed) : '';
						
						//$(obj).css({'bottom': 'auto', 'top': layer});
						$(obj).css({'bottom': layer_bottom, 'top': layer_top});
						if( fade_out_speed != ''){
							$(obj).animate({'opacity': 0}, {easing: 'linear', duration:fade_out_speed, queue:false});
						}
						$(obj).animate({'top': '-'+_t.wppas.get_value($(obj).height())}, {easing:args.end_trans_effect, duration:Number(args.end_trans_sec), queue:false, complete: function(){
							//$(this).css({'display': 'none', 'top': layer, 'opacity': 0});
							$(this).css({'display': 'none', 'top': layer_top, 'bottom': layer_bottom, 'opacity': 0});		
							
							// REPEAT if needed.
							if( args.end_repeat == 1){
								_t.wppas.start_layer_animation(args);
							}
						}});
						
					/*}else{
						var layer = $(obj).css('bottom'),
							opacity = args.fade_out_speed != undefined ? 0 : 1,
							fade_out_speed = args.fade_out_speed != '' ? Number(args.fade_out_speed) : '';
						
						$(obj).css({'top': 'auto', 'bottom': layer});
						if( fade_out_speed != ''){
							$(obj).animate({'opacity': 0}, {easing:'linear', duration:fade_out_speed, queue:false});
						}
						$(obj).animate({'bottom': _t.wppas.get_value(args.itm_h)}, {easing:args.end_trans_effect, duration:Number(args.end_trans_sec), queue:false, complete: function(){
							$(this).css({'display': 'none', 'bottom': layer, 'opacity': 0});	
							
							// REPEAT if needed.
							if( args.end_repeat == 1){
								_t.wppas.start_layer_animation(args);
							}
						}});
					}*/
				}
				// SLIDE OUT to BOTTOM -----------------------------------------------------------------------
				else if( end_type == 'to_bottom' ){
					
					//if( $(obj).css('bottom') != 'auto' ){
						var layer = $(obj).css('bottom'),
							layer_top = $(obj).css('top'),
							layer_bottom = $(obj).css('bottom'),
							opacity = args.fade_out_speed != undefined ? 0 : 1,
							fade_out_speed = args.fade_out_speed != '' ? Number(args.fade_out_speed) : '';
						
						//$(obj).css({'top': 'auto', 'bottom': layer});
						//$(obj).css({'top': 'auto', 'bottom': layer_bottom, 'top': layer_top});
						$(obj).css({'bottom': layer_bottom, 'top': layer_top});				
						if( fade_out_speed != ''){
							$(obj).animate({'opacity': 0}, {easing:'linear', duration:fade_out_speed, queue:false});
						}
						$(obj).animate({'bottom': '-'+_t.wppas.get_value(args.itm_h)}, {easing:args.end_trans_effect, duration:Number(args.end_trans_sec), queue:false, complete: function(){
							//$(this).css({'display': 'none', 'bottom': layer});	
							$(this).css({'display': 'none', 'bottom': layer, 'top': layer_top, 'opacity': 0});	
							
							// REPEAT if needed.
							if( args.end_repeat == 1){
								_t.wppas.start_layer_animation(args);
							}
						}});
					/*}else{
						var layer = $(obj).css('top'),
							opacity = args.fade_out_speed != undefined ? 0 : 1,
							fade_out_speed = args.fade_out_speed != '' ? Number(args.fade_out_speed) : '';
						
						$(obj).css({'bottom': 'auto', 'top': layer});
						if( fade_out_speed != ''){
							$(obj).animate({'opacity': 0}, {easing:'linear', duration:fade_out_speed, queue:false});
						}
						$(obj).animate({'top': '-' + _t.wppas.get_value($(obj).height())}, {easing:args.end_trans_effect, duration:Number(args.end_trans_sec), queue:false, complete: function(){
							$(this).css({'display': 'none', 'top': layer});	
							
							// REPEAT if needed.
							if( args.end_repeat == 1){
								_t.wppas.start_layer_animation(args);
							}
						}});	
					}*/
				}
				// SLIDE OUT to LEFT -----------------------------------------------------------------------
				else if( end_type == 'to_left' ){
					
					//if( $(obj).css('left') != 'auto' ){
						var layer = $(obj).css('left'),
							layer_left = $(obj).css('left'),
							layer_right = $(obj).css('right'),
							opacity = args.fade_out_speed != undefined ? 0 : 1,
							fade_out_speed = args.fade_out_speed != '' ? Number(args.fade_out_speed) : '';
						
						//$(obj).css({'right': 'auto', 'left': layer});
						$(obj).css({'right': layer_right, 'left': layer_left});
						if( fade_out_speed != ''){
							$(obj).animate({'opacity': 0}, {easing:'linear', duration:fade_out_speed, queue:false});
						}
						$(obj).animate({'left': '-'+ _t.wppas.get_value($(obj).width())}, {easing:args.end_trans_effect, duration:Number(args.end_trans_sec), queue:false, complete: function(){
							//$(this).css({'display': 'none', 'left': layer, 'opacity':0});	
							$(this).css({'display': 'none', 'left': layer_left, 'right': layer_right, 'opacity': 0});	
							
							// REPEAT if needed.
							if( args.end_repeat == 1){
								_t.wppas.start_layer_animation(args);
							}
						}});
					/*}else{
						var layer = $(obj).css('right'),
							opacity = args.fade_out_speed != undefined ? 0 : 1,
							fade_out_speed = args.fade_out_speed != '' ? Number(args.fade_out_speed) : '';
						
						$(obj).css({'left': 'auto', 'right': layer});
						
						if( fade_out_speed != ''){
							$(obj).animate({'opacity': 0}, {easing:'linear', duration:fade_out_speed, queue:false});
						}
						$(obj).animate({'right': _t.wppas.get_value(args.itm_w)}, {easing:args.end_trans_effect, duration:Number(args.end_trans_sec), queue:false, complete: function(){
							$(this).css({'display': 'none', 'left': layer, 'opacity':0});	
							
							// REPEAT if needed.
							if( args.end_repeat == 1){
								_t.wppas.start_layer_animation(args);
							}
						}});
					}*/
					
				}
				// SLIDE OUT to RIGHT -----------------------------------------------------------------------
				else if( end_type == 'to_right' ){
					
					//if( $(obj).css('left') != 'auto' ){
						
						var layer = $(obj).css('left'),
							layer_left = $(obj).css('left'),
							layer_right = $(obj).css('right'),
							opacity = args.fade_out_speed != undefined ? 0 : 1,
							fade_out_speed = args.fade_out_speed != '' ? Number(args.fade_out_speed) : '';
						
						//$(obj).css({'right': 'auto', 'left': layer});
						$(obj).css({'right': layer_right, 'left': layer_left});
						if( fade_out_speed != ''){
							$(obj).animate({'opacity': 0}, {easing:'linear', duration:fade_out_speed, queue:false});
						}
						$(obj).animate({'left': _t.wppas.get_value(args.itm_w)}, {easing:args.end_trans_effect, duration:Number(args.end_trans_sec), queue:false, complete: function(){
							//$(this).css({'display': 'none', 'left': layer, 'opacity': 0});	
							$(this).css({'display': 'none', 'left': layer_left, 'right': layer_right, 'opacity': 0});	
							
							// REPEAT if needed.
							if( args.end_repeat == 1){
								_t.wppas.start_layer_animation(args);
							}
						}});
					/*}else{
						var layer = $(obj).css('right'),
							opacity = args.fade_out_speed != undefined ? 0 : 1,
							fade_out_speed = args.fade_out_speed != '' ? Number(args.fade_out_speed) : '';
						
						$(obj).css({'left': 'auto', 'right': layer});
						if( fade_out_speed != ''){
							$(obj).animate({'opacity': 0}, {easing:'linear', duration:fade_out_speed, queue:false});
						}
						$(obj).animate({'right': '-'+_t.wppas.get_value($(obj).width())}, {easing:args.end_trans_effect, duration:Number(args.end_trans_sec), queue:false, complete: function(){
							$(this).css({'display': 'none', 'right': layer, 'opacity': 0});	
							
							// REPEAT if needed.
							if( args.end_repeat == 1){
								_t.wppas.start_layer_animation(args);
							}
						}});
					}*/
				}	
			}
		},
		
		
		
		
		
		/**
		 * RETURN VALUE - number + px || %
		 * value can be for example 100 | 100px | 100%
		 *
		 */
		get_value: function(value){
			var is_num = !isNaN(value),
				val = 'px',
				num = '',
				size = '';
			
			if( !is_num ){
				num = parseInt(value, 10);
				val = typeof value != 'undefined' ? value.split(num)[1] : 0;
			}else{
				num = value;
			}
			
			return num+val;
		},
		
		
		
		/**
		 * WINDOW RESIZE
		 *
		 *
		 */
		window_resize: function(args){
			
			var _t = $(this);
			
			$(window).on('resize', function () {
			
				if( $(window).width() != windowsize ){	

					windowsize = $(window).width();
					//console.log('resizing '+args.itm);
					if(args.options.scale == 1){
						_t.wppas.scale_banner();
					}
				
					$.each($(args.itm), function(){
						// LOAD BANNER HTML
						_t.wppas.banner_html({
							bsizes_arr: args.bsizes_arr, 
							itm: $(this),
							ID: args.ID,
							options: args.options
						});
					});
					// reset windowsize var to make sure all banners get resized.
					windowsize = 0;
				}
			}).trigger('resize');
		},
		
		
		
		/**
		 * Proportions
		 *
		 * var prop = wppas.getProportion($('#item'));
		 * $('#item').css({'transform': 'scale('+prop.proportion+')'});
		 *
		 */
		get_proportion: function(itm) {
			var width = itm.parent().width();
			var height = itm.parent().height();
			
			width = width != 0 ? width : itm.width();
			height = height != 0 ? height : itm.height();
			
			var proportion_width = width / itm.width();
			var proportion_height = height / itm.height();
			//console.log(proportion_width +' '+proportion_height);
			
			var prop = Math.min(proportion_width, proportion_height);
			
			// Dont allow banner to be bigger then original width.
			prop = prop > 1 ? 1 : prop;
			prop = prop > 0 ? prop : 1;
			
			return {
				proportion: prop
			};
		},
		
		
		
		
		/**
		 * RANDOM UNIQUE ID
		 *
		 *
		 */
		wppas_random_id: function(txt){
			return (+new Date).toString(36).slice(-5)+txt;	
		},
		
		
		
		
		/**
		 *GET LATEST Z-INDEX
		 *
		 *
		 */
		get_latest_zindex: function(){
			var zindex = jQuery('.timeline_itm').length;
			zindex = zindex+5;
			
			return zindex;	
		},
		
		
		
		
		
		/**
		 * CREATE BANNER CONTAINER - b_container, bcont
		 *
		 *
		 */
		wppas_b_container: function(args)
		{
			var defaults = {
				'width': 300,
				'height': 250,
				'overflow': jQuery('#boverflow').is(':checked') ? 'visible' : 'hidden',
				//'scale': jQuery('#bscale').val()
			};
			
			args = jQuery.extend( defaults, args );
			
			//console.log('create bcontainer');
			var w = args['width'] != 'full' ? args['width']+'px' : '100%',
				h = args['height'] != 'full' ? args['height']+'px' : '100%';
				
			//jQuery('.b_container').css({'max-width': w, 'max-height': h, 'overflow': args["overflow"]});
			jQuery('.b_container').css({'width': w, 'height': h, 'overflow': args["overflow"]});
			//jQuery('.b_container').attr('data-scale', args['scale']);
		},
		
		
		
		
		
		/**
		 * CALCULATE ASPECT RATIO SIZE
		 *
		 *
		 */
		ratio_height: function(args) {
			var bsize = args.bsize != '' ? args.bsize.split('x') : jQuery('#wppas_banner_size').val().split('x');
			
			var maxWidth = bsize[0]; // Max width for the image
			var maxHeight = bsize[1]; // Max height for the image
			var ratio = 0;  // Used for aspect ratio
			//var width = args.editor ? jQuery('.b_container').width() : args.itm.width();
			var width = args.editor ? jQuery('#banner-preview')[0].getBoundingClientRect().width : args.itm[0].getBoundingClientRect().width;
			//console.log(jQuery('.b_container')[0].getBoundingClientRect().width);
			//console.log(width);
			ratio = Number(width) / Number(maxWidth);
			var newHeight = maxHeight * ratio;
			
			//console.log('w:'+width+' '+newHeight);
			return newHeight;	
		},
		
		
		
		
		
		
		
		/**
		 * SET ASPECT RATIO SIZE
		 *
		 *
		 */
		aspect_ratio_sizing: function(args) {
			
			var _t = $(this);
			
			if( args.keep_aspect_ratio == 1 ){
				//console.log( args.options );
				var bsize = args.editor ? '' : args.options.size;
				var newHeight = _t.wppas.ratio_height({bsize: bsize, editor: args.editor, itm: args.itm });
				
				if( args.editor ){
					//console.log(newHeight);
					jQuery('#banner-preview').css({'max-height':newHeight+'px'});
					jQuery('#wppas_banner_work_area').css({'height': newHeight+'px'});
					//jQuery('.b_container').css({'max-height':newHeight+'px'});
					//jQuery('.b_container').css({'height':newHeight+'px'});
				}else{
					//args.itm.css({'max-height':newHeight+'px'});
				}
				
			}	
		},
		
		
		
		scale_banner: function(itm){
			var _t = $(this);
			//console.log('scale banner');
			//console.log(itm);
			if( typeof itm != 'undefined'){
				var prop = _t.wppas.get_proportion(itm); //$('.b_container')
				
				itm.css({'transform': 'scale('+prop.proportion+')', 'transform-origin':'0px 0px 0px'}); //$('.b_container')
				// Margin fix - neccessery for some themes
				
				var mrgn = itm.height() - itm[0].getBoundingClientRect().height;
				//console.log( mrgn+': '+itm.height()+' - '+itm[0].getBoundingClientRect().height);
				if( mrgn != itm.height()){
					//itm.css({'margin-bottom':-mrgn});
					itm[0].style.setProperty( 'margin-bottom', -mrgn+'px', 'important' );
				}
			}else{
				$.each($('.b_container'), function( i, obj ) {
					var scale = $(obj).data('scale');
					scale = typeof scale === 'undefined' ? jQuery('#bscale').val() : scale;
					scale = typeof scale === 'undefined' ? 1 : scale;
					
					if( !$(obj).parent().hasClass('wpslide') && scale == 1){
						
						var prop = _t.wppas.get_proportion($(obj)); //$('.b_container')
						$(obj).css({'transform': 'scale('+prop.proportion+')', 'transform-origin':'0px 0px 0px'});
						// Margin fix - neccessery for some themes
						var mrgn = $(obj).height() - $(obj)[0].getBoundingClientRect().height;
						if( mrgn != $(obj).height()){
							//$(obj).css({"margin-bottom":-mrgn});
							$(obj)[0].style.setProperty( 'margin-bottom', -mrgn+'px', 'important' );
						}
					}
				});
			}
		},
		
		
		
		
		/**
		 * FIND CLOSEST NR IN ARRAY
		 *
		 *
		 */
		closest_nr: function(num, arr) {
			var curr = arr[0];
			var diff = Math.abs (num - curr);
			for (var val = 0; val < arr.length; val++) {
				var newdiff = Math.abs (num - arr[val]);
				if (newdiff < diff) {
					diff = newdiff;
					curr = arr[val];
				}
			}
			return curr;
		},
		
		
		
		/**
		 * FIND CLOSEST "HIGHER" (screen size) NR IN ARRAY
		 *
		 *
		 */
		closest_higher: function(num, arr){
    
			var closest = Math.max.apply(null, arr);
			
			for(var i = 0; i < arr.length; i++){
				if(arr[i] >= num && arr[i] < closest){
					
					closest = arr[i];
				}
			}
			return closest;
		},
		
		
		
		
		/**
		 * FIND CLOSEST "HIGHER" (screen size) NR IN ARRAY where textarea is not empty!
		 *
		 *
		 */
		closest: function(num, arr){
    
			var closest = Math.max.apply(null, arr);
			
			for(var i = 0; i < arr.length; i++){
				if(arr[i] >= num && arr[i] < closest){
					
					if( jQuery("textarea[name=wppas_banner_html_"+arr[i]+"]").val() != ''){
						closest = arr[i];
					}
				}
			}
			return closest;
		},
		
		
		
		
		
		/**
		 * FIRE WHEN PAGE IS LOADED.
		 *
		 *
		 */
		onReady: function(callback) {
			var intervalID = window.setInterval(checkReady, 1000);
			function checkReady() {
				if (document.getElementsByTagName('body')[0] !== undefined) {
					window.clearInterval(intervalID);
					
					callback.call(this);
				}
			}
		},
		
		
		
		
		
		/**
		 * TABS
		 *
		 *
		 */
		tabs: function(options) {
			
			var settings = $.extend({
				// These are the defaults.
				container: ".vbc_menu_toggle",
				ul: ".vbc_menu_toggle",
				nfer: ".vbc_nfer"
			}, options );
			
			var _t = $(settings.container),
				_ul = settings.ul,
				_nfer = settings.nfer;
			
			_t.find(_ul+' li').on('click', function(){
				
				// AJAX ACTION
				if ($(this).attr('data-ajax')) {
					
					var nfer_id = $(this).data('ajax');
					
					// options 
					if( nfer_id == 'vbc-general') {
						var bsize = $('#wppas_banner_size').val();
						
						$.ajax({
						   type: "POST",
						   url: ajaxurl,
						   data: "action=vbc_load_banner_editor&option=startscreen"
						}).done(function( msg ) {
					
							$('#vbc_content_container').html( msg );
							
						});
					}
					if( nfer_id == 'vbc-editor') {
						var bsize = $('#wppas_banner_size').val();
						
						$.ajax({
						   type: "POST",
						   url: ajaxurl,
						   data: "action=vbc_load_banner_editor&bsize="+ bsize+"&option=editor"
						}).done(function( msg ) {
					
							$('#vbc_content_container').html( msg );
							
							_t.wppas.activate_switch_buttons();
						});
					}
					// end options
				
				// DEFAULT SHOW/HIDE CONTENT ACTION	
				}else if ($(this).attr('data-link')){
					
					var url = $(this).data('link');
					var target = $(this).data('link_target');
					if(typeof target != 'undefined'){
						window.open(url, target);
					}else{
						window.location.href = url;
					}
				
				}else if ($(this).attr('data-target')){
				
					var nfer_id = $(this).data('target');
					//console.log(nfer_id);
					_t.find(_nfer).hide();
					_t.find('#'+nfer_id).show();
				}
				
				
				// SELECT CURRENT TAB
				if( !$(this).attr('data-option') ){
					_t.find(_ul+' li').removeClass('selected');
					$(this).addClass('selected');
				}
				
				// If export tab
				if( $(this).hasClass('vbc_export_tab') ){
					//console.log(options);
					var export_type = $(this).data('type');
					
					if( export_type == 'banner'){
						_t.wppas.wppas_export_banner(options);
					}else{
						_t.wppas.wppas_export_adzone(options);
					}
				}
				
				//window.location.hash = nfer_id;
				return false;
				
			});
		},
		
		
		
		/**
		 * SELECT SPECIFIC TAB - using another button outside the menu.
		 *
		 *
		 */
		select_tab: function(options) {
			
			var settings = $.extend({
				// These are the defaults.
				target: "vbc-editor",
				container: '#vbc_main_area'
			}, options );
			
			
			var _o = $(".vbc_menu_toggle li[data-target='" + settings.target +"']"),
				_t = $(settings.container);
			
			//console.log(_o);
			_t.find('.vbc_nfer').hide();
			_t.find('#'+settings.target).show();
			
			_t.find('.vbc_menu_toggle li').removeClass('selected');
			_o.addClass('selected');
		},
		
		
		
		
		/**
		 * SWITCH BUTTONS
		 *
		 *
		 */
		activate_switch_buttons: function(){
			$.each($('.wppas_switch_btn input'), function() {
				var btn = $(this),
					on_lbl = btn.data('on_label') ? btn.data('on_label') : '',
					off_lbl = btn.data('off_label') ? btn.data('off_label') : '',
					lbl_placement = btn.data('labels_placement') ? btn.data('labels_placement') : 'both',
					width = btn.data('width') ? btn.data('width') : 50,
					height = btn.data('height') ? btn.data('height') : 25,
					button_width = btn.data('button_width') ? btn.data('button_width') : 30;
				
				//if( !btn.hasClass('active') ){
				//if (typeof btn.attr('data-off_label') == "undefined") { 
					btn.switchButton({ 
						on_label : on_lbl,
						off_label : off_lbl,
						labels_placement:lbl_placement,
						width: width,
						height: height,
						button_width: button_width,
						on_callback: function(){ btn.val(1); }, 
						off_callback: function(){ btn.val(0);} /*console.log('OFF'); console.log(this.element.data('off_label'));*/
					});
					//btn.addClass('active')
				//}
			});	
		},
		
		
		
		
		/**
		 * LOAD GOOGLE FONT
		 *
		 *
		 */
		load_google_fonts: function( args ){
			var _t = $(this);
			
			// @since v5.1.6 -- Allow fonts for text and html layer types
			$.each(args.itm.find('.layer'), function() {
			//$.each(args.itm.find('.layer .itm_html'), function() {
				if( $(this).hasClass('text') || $(this).hasClass('html'))
				{
					var font = $(this).css('font-family');
					//console.log(font);
					_t.wppas.addGoogleFont( font );
				}
			});
		},
		
		
		
		
		/**
		 * ADD GOOGLE FONT
		 *
		 *
		 */
		addGoogleFont: function( FontName ) {
			
			if( typeof FontName != 'undefined' ){
				var FontName = FontName.replace(/\"/g, ""),
					FontName = FontName.replace(/\'/g, "") // @since v5.1.6
					
				if( FontName != 'Verdana' && FontName != 'Verdana, sans-serif' && FontName != 'Arial' && FontName != 'Impact' && FontName != 'Times' && FontName != 'FontAwesome' ){
					
					if($(this).wppas.is_google_font(FontName)){
					
						// Check if font stylesheet already exists. if not add it to head.
						if (!$('link[href="https://fonts.googleapis.com/css?family='+ FontName +':100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic"]').length){
							$('<link href="https://fonts.googleapis.com/css?family='+ FontName +':100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic" rel="stylesheet" type="text/css">').appendTo("head");
						}
					
					}
					
					//$("head").append("<link href='https://fonts.googleapis.com/css?family="+ FontName +":100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic' rel='stylesheet' type='text/css'>");
				}
			}
		},
		
		
		
		
		/**
		 * CREATE BORDER RADIUS
		 */
		border_radius_css: function(radius){
			
			var _t = $(this),
				css = '';
				
			css+= radius['top-left'] != '' ? _t.wppas.get_value(radius['top-left'])+' ' : 0+' ';
			css+= radius['top-right'] != '' ? _t.wppas.get_value(radius['top-right'])+' ' : 0+' ';
			css+= radius['bottom-right'] != '' ? _t.wppas.get_value(radius['bottom-right'])+' ' : 0+' ';
			css+= radius['bottom-left'] != '' ? _t.wppas.get_value(radius['bottom-left']) : 0;
			
			return css;
		},
		
		
		
		
		/**
		 * CHECK IF EMAIL IS VALID
		 */
		is_valid_email: function(email){
			var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
			return regex.test(email);	
		},
		
		
		
		
		
		/**
		 * IN ARRAY
		 * sub is optional to load items from a sub array.
		 */
		in_array: function( needle, haystack, sub ) {
			for ( var i = 0; i < haystack.length; i++ ) {
				var arr = typeof sub != 'undefined' ? haystack[ i ][sub] : haystack[ i ];
				if ( arr.trim() == needle ) {
					return true;
				}
			}
			return false;
		},
		
		
		
		/**
		 * Check if font is google font
		 */
		is_google_font: function(font){
			var google_fonts = ["ABeeZee","Abel","Abril Fatface","Aclonica","Acme","Actor","Adamina","Advent Pro","Aguafina Script","Akronim","Aladin","Aldrich","Alef","Alegreya","Alegreya SC","Alegreya Sans","Alegreya Sans SC","Alex Brush","Alfa Slab One","Alice","Alike","Alike Angular","Allan","Allerta","Allerta Stencil","Allura","Almendra","Almendra Display","Almendra SC","Amarante","Amaranth","Amatic SC","Amethysta","Anaheim","Andada","Andika","Angkor","Annie Use Your Telescope","Anonymous Pro","Antic","Antic Didone","Antic Slab","Anton","Arapey","Arbutus","Arbutus Slab","Architects Daughter","Archivo Black","Archivo Narrow","Arimo","Arizonia","Armata","Artifika","Arvo","Asap","Asset","Astloch","Asul","Atomic Age","Aubrey","Audiowide","Autour One","Average","Average Sans","Averia Gruesa Libre","Averia Libre","Averia Sans Libre","Averia Serif Libre","Bad Script","Balthazar","Bangers","Basic","Battambang","Baumans","Bayon","Belgrano","Belleza","BenchNine","Bentham","Berkshire Swash","Bevan","Bigelow Rules","Bigshot One","Bilbo","Bilbo Swash Caps","Bitter","Black Ops One","Bokor","Bonbon","Boogaloo","Bowlby One","Bowlby One SC","Brawler","Bree Serif","Bubblegum Sans","Bubbler One","Buda","Buenard","Butcherman","Butterfly Kids","Cabin","Cabin Condensed","Cabin Sketch","Caesar Dressing","Cagliostro","Calligraffitti","Cambo","Candal","Cantarell","Cantata One","Cantora One","Capriola","Cardo","Carme","Carrois Gothic","Carrois Gothic SC","Carter One","Caudex","Cedarville Cursive","Ceviche One","Changa One","Chango","Chau Philomene One","Chela One","Chelsea Market","Chenla","Cherry Cream Soda","Cherry Swash","Chewy","Chicle","Chivo","Cinzel","Cinzel Decorative","Clicker Script","Coda","Coda Caption","Codystar","Combo","Comfortaa","Coming Soon","Concert One","Condiment","Content","Contrail One","Convergence","Cookie","Copse","Corben","Courgette","Cousine","Coustard","Covered By Your Grace","Crafty Girls","Creepster","Crete Round","Crimson Text","Croissant One","Crushed","Cuprum","Cutive","Cutive Mono","Damion","Dancing Script","Dangrek","Dawning of a New Day","Days One","Delius","Delius Swash Caps","Delius Unicase","Della Respira","Denk One","Devonshire","Dhurjati","Didact Gothic","Diplomata","Diplomata SC","Domine","Donegal One","Doppio One","Dorsa","Dosis","Dr Sugiyama","Droid Sans","Droid Sans Mono","Droid Serif","Duru Sans","Dynalight","EB Garamond","Eagle Lake","Eater","Economica","Ek Mukta","Electrolize","Elsie","Elsie Swash Caps","Emblema One","Emilys Candy","Engagement","Englebert","Enriqueta","Erica One","Esteban","Euphoria Script","Ewert","Exo","Exo 2","Expletus Sans","Fanwood Text","Fascinate","Fascinate Inline","Faster One","Fasthand","Fauna One","Federant","Federo","Felipa","Fenix","Finger Paint","Fira Mono","Fira Sans","Fjalla One","Fjord One","Flamenco","Flavors","Fondamento","Fontdiner Swanky","Forum","Francois One","Freckle Face","Fredericka the Great","Fredoka One","Freehand","Fresca","Frijole","Fruktur","Fugaz One","GFS Didot","GFS Neohellenic","Gabriela","Gafata","Galdeano","Galindo","Gentium Basic","Gentium Book Basic","Geo","Geostar","Geostar Fill","Germania One","Gidugu","Gilda Display","Give You Glory","Glass Antiqua","Glegoo","Gloria Hallelujah","Goblin One","Gochi Hand","Gorditas","Goudy Bookletter 1911","Graduate","Grand Hotel","Gravitas One","Great Vibes","Griffy","Gruppo","Gudea","Habibi","Halant","Hammersmith One","Hanalei","Hanalei Fill","Handlee","Hanuman","Happy Monkey","Headland One","Henny Penny","Herr Von Muellerhoff","Hind","Holtwood One SC","Homemade Apple","Homenaje","IM Fell DW Pica","IM Fell DW Pica SC","IM Fell Double Pica","IM Fell Double Pica SC","IM Fell English","IM Fell English SC","IM Fell French Canon","IM Fell French Canon SC","IM Fell Great Primer","IM Fell Great Primer SC","Iceberg","Iceland","Imprima","Inconsolata","Inder","Indie Flower","Inika","Irish Grover","Istok Web","Italiana","Italianno","Jacques Francois","Jacques Francois Shadow","Jim Nightshade","Jockey One","Jolly Lodger","Josefin Sans","Josefin Slab","Joti One","Judson","Julee","Julius Sans One","Junge","Jura","Just Another Hand","Just Me Again Down Here","Kalam","Kameron","Kantumruy","Karla","Karma","Kaushan Script","Kavoon","Kdam Thmor","Keania One","Kelly Slab","Kenia","Khand","Khmer","Kite One","Knewave","Kotta One","Koulen","Kranky","Kreon","Kristi","Krona One","La Belle Aurore","Laila","Lancelot","Lato","League Script","Leckerli One","Ledger","Lekton","Lemon","Libre Baskerville","Life Savers","Lilita One","Lily Script One","Limelight","Linden Hill","Lobster","Lobster Two","Londrina Outline","Londrina Shadow","Londrina Sketch","Londrina Solid","Lora","Love Ya Like A Sister","Loved by the King","Lovers Quarrel","Luckiest Guy","Lusitana","Lustria","Macondo","Macondo Swash Caps","Magra","Maiden Orange","Mako","Mallanna","Mandali","Marcellus","Marcellus SC","Marck Script","Margarine","Marko One","Marmelad","Marvel","Mate","Mate SC","Maven Pro","McLaren","Meddon","MedievalSharp","Medula One","Megrim","Meie Script","Merienda","Merienda One","Merriweather","Merriweather Sans","Metal","Metal Mania","Metamorphous","Metrophobic","Michroma","Milonga","Miltonian","Miltonian Tattoo","Miniver","Miss Fajardose","Modern Antiqua","Molengo","Molle","Monda","Monofett","Monoton","Monsieur La Doulaise","Montaga","Montez","Montserrat","Montserrat Alternates","Montserrat Subrayada","Moul","Moulpali","Mountains of Christmas","Mouse Memoirs","Mr Bedfort","Mr Dafoe","Mr De Haviland","Mrs Saint Delafield","Mrs Sheppards","Muli","Mystery Quest","NTR","Neucha","Neuton","New Rocker","News Cycle","Niconne","Nixie One","Nobile","Nokora","Norican","Nosifer","Nothing You Could Do","Noticia Text","Noto Sans","Noto Serif","Nova Cut","Nova Flat","Nova Mono","Nova Oval","Nova Round","Nova Script","Nova Slim","Nova Square","Numans","Nunito","Odor Mean Chey","Offside","Old Standard TT","Oldenburg","Oleo Script","Oleo Script Swash Caps","Open Sans","Open Sans Condensed","Oranienbaum","Orbitron","Oregano","Orienta","Original Surfer","Oswald","Over the Rainbow","Overlock","Overlock SC","Ovo","Oxygen","Oxygen Mono","PT Mono","PT Sans","PT Sans Caption","PT Sans Narrow","PT Serif","PT Serif Caption","Pacifico","Paprika","Parisienne","Passero One","Passion One","Pathway Gothic One","Patrick Hand","Patrick Hand SC","Patua One","Paytone One","Peralta","Permanent Marker","Petit Formal Script","Petrona","Philosopher","Piedra","Pinyon Script","Pirata One","Plaster","Play","Playball","Playfair Display","Playfair Display SC","Podkova","Poiret One","Poller One","Poly","Pompiere","Pontano Sans","Port Lligat Sans","Port Lligat Slab","Prata","Preahvihear","Press Start 2P","Princess Sofia","Prociono","Prosto One","Puritan","Purple Purse","Quando","Quantico","Quattrocento","Quattrocento Sans","Questrial","Quicksand","Quintessential","Qwigley","Racing Sans One","Radley","Rajdhani","Raleway","Raleway Dots","Ramabhadra","Rambla","Rammetto One","Ranchers","Rancho","Rationale","Redressed","Reenie Beanie","Revalia","Ribeye","Ribeye Marrow","Righteous","Risque","Roboto","Roboto Condensed","Roboto Slab","Rochester","Rock Salt","Rokkitt","Romanesco","Ropa Sans","Rosario","Rosarivo","Rouge Script","Rozha One","Rubik Mono One","Rubik One","Ruda","Rufina","Ruge Boogie","Ruluko","Rum Raisin","Ruslan Display","Russo One","Ruthie","Rye","Sacramento","Sail","Salsa","Sanchez","Sancreek","Sansita One","Sarina","Sarpanch","Satisfy","Scada","Schoolbell","Seaweed Script","Sevillana","Seymour One","Shadows Into Light","Shadows Into Light Two","Shanti","Share","Share Tech","Share Tech Mono","Shojumaru","Short Stack","Siemreap","Sigmar One","Signika","Signika Negative","Simonetta","Sintony","Sirin Stencil","Six Caps","Skranji","Slabo 13px","Slabo 27px","Slackey","Smokum","Smythe","Sniglet","Snippet","Snowburst One","Sofadi One","Sofia","Sonsie One","Sorts Mill Goudy","Source Code Pro","Source Sans Pro","Source Serif Pro","Special Elite","Spicy Rice","Spinnaker","Spirax","Squada One","Stalemate","Stalinist One","Stardos Stencil","Stint Ultra Condensed","Stint Ultra Expanded","Stoke","Strait","Sue Ellen Francisco","Sunshiney","Supermercado One","Suwannaphum","Swanky and Moo Moo","Syncopate","Tangerine","Taprom","Tauri","Teko","Telex","Tenor Sans","Text Me One","The Girl Next Door","Tienne","Tinos","Titan One","Titillium Web","Trade Winds","Trocchi","Trochut","Trykker","Tulpen One","Ubuntu","Ubuntu Condensed","Ubuntu Mono","Ultra","Uncial Antiqua","Underdog","Unica One","UnifrakturCook","UnifrakturMaguntia","Unkempt","Unlock","Unna","VT323","Vampiro One","Varela","Varela Round","Vast Shadow","Vesper Libre","Vibur","Vidaloka","Viga","Voces","Volkhov","Vollkorn","Voltaire","Waiting for the Sunrise","Wallpoet","Walter Turncoat","Warnes","Wellfleet","Wendy One","Wire One","Yanone Kaffeesatz","Yellowtail","Yeseva One","Yesteryear","Zeyada"];
			
			return $(this).wppas.in_array( font, google_fonts ) ? true : false;
		}
		
	});
	
}( jQuery ));