<?php
/**
 * Init related functions and actions.
 *
 * @author 		Tunafish
 * @package 	wp_pro_ad_system/classes
 * @version     4.0.0
 */
 
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'Pro_Ads_Init' ) ) :


class Pro_Ads_Init {	
	
	

	public function __construct() 
	{
		global $pro_ads_main, $pro_ads_codex, $pro_ads_cpts, $pro_ads_advertisers, $pro_ads_campaigns, $pro_ads_banners, $pro_ads_adzones, $pro_ads_statistics, $wppas_stats, $wppas_stats_tpl, $pro_ads_templates, $pro_ads_shortcodes, $pro_ads_multisite, $pro_ads_responsive, $pro_ads_browser, $pro_ad_custom_widgets, $pro_ads_updates, $pro_ads_geo_targeting, $pro_ads_banner_creator, $wppas_banner_creator, $wppas_adzone_creator, $wppas_paypal_ipn, $wppas_google_fonts, $wppas_activate, $wppas_mobile_detect, $wppas_svg, $wppas_shape, $wppas_vc_addon, $wppas_ajax_image_upload;
		
		//$wpproads_stats_version = get_option('wpproads_stats_version', '_new');
		
		// Run this on activation.
		register_activation_hook( WP_ADS_FILE, array( $this, 'install' ) );
		
		// Load Functions ------------------------------------------------- 
		require_once( WP_ADS_INC_DIR .'/ajax_functions.php');
		
		// Load Classes --------------------------------------------------- 
		require_once( WP_ADS_DIR.'classes/extends/Pro_Ads_CPT_Meta_Options.php');
		require_once( WP_ADS_DIR.'classes/Pro_Ads_CPTs.php');	
		require_once( WP_ADS_DIR.'classes/Pro_Ads_Main.php');
		require_once( WP_ADS_DIR.'classes/Pro_Ads_Codex.php');
		require_once( WP_ADS_DIR.'classes/Pro_Ads_Advertisers.php');
		require_once( WP_ADS_DIR.'classes/Pro_Ads_Banners.php');
		require_once( WP_ADS_DIR.'classes/Pro_Ads_Campaigns.php');
		require_once( WP_ADS_DIR.'classes/Pro_Ads_Adzones.php');
		require_once( WP_ADS_DIR.'classes/WPPAS_Stats.php');
		require_once( WP_ADS_DIR.'classes/WPPAS_Stats_Tpl.php');
		require_once( WP_ADS_DIR.'classes/Pro_Ads_Statistics_new.php');
		
		require_once( WP_ADS_DIR.'classes/WPPAS_Core.php');
		require_once( WP_ADS_DIR.'classes/WPPAS_TPL.php');
		require_once( WP_ADS_DIR.'classes/WPPAS_DEF.php');
		require_once( WP_ADS_DIR.'classes/WPPAS_Banner_Creator.php');
		require_once( WP_ADS_DIR.'classes/WPPAS_Banner.php');
		require_once( WP_ADS_DIR.'classes/WPPAS_Adzone_Creator.php');
		require_once( WP_ADS_DIR.'classes/WPPAS_Display_Options.php');
		require_once( WP_ADS_DIR.'classes/WPPAS_BuySell.php');
		require_once( WP_ADS_DIR.'classes/WPPAS_AlphaID.php');
		require_once( WP_ADS_DIR.'classes/WPPAS_Paypal_IPN.php');
		require_once( WP_ADS_DIR.'classes/WPPAS_SVG_Items.php');
		require_once( WP_ADS_DIR.'classes/WPPAS_Shape_Items.php');
		require_once( WP_ADS_DIR.'classes/WPPAS_Google_Fonts.php');
		require_once( WP_ADS_DIR.'classes/WPPAS_Activate.php');
		require_once( WP_ADS_DIR.'classes/WPPAS_VC_Addon.php');
		require_once( WP_ADS_DIR.'classes/WPPAS_Ajax_Image_Upload.php');
		require_once( WP_ADS_DIR.'classes/WPPAS_Mobile_Detect.php');
		require_once( WP_ADS_DIR.'classes/WPPAS_Detect.php');
		require_once( WP_ADS_DIR.'classes/Pro_Ads_Templates.php');
		require_once( WP_ADS_DIR.'classes/Pro_Ads_Shortcodes.php');
		require_once( WP_ADS_DIR.'classes/Pro_Ads_Multisite.php');
		require_once( WP_ADS_DIR.'classes/Pro_Ads_Browser.php');
		require_once( WP_ADS_DIR.'classes/Pro_Ads_Responsive.php');
		require_once( WP_ADS_DIR.'classes/Pro_Ads_Tinymce.php');
		require_once( WP_ADS_DIR.'classes/Pro_Ads_Api.php');
		require_once( WP_ADS_DIR.'classes/Pro_Ads_Custom_Widgets.php');
		
		require_once( WP_ADS_DIR.'classes/Pro_Ads_Updates.php');
		//require_once( WP_ADS_DIR.'classes/Pro_Ads_Vsc_Class.php');
		require_once( WP_ADS_DIR.'classes/Pro_Ads_Post_Control.php');
		
		/* ----------------------------------------------------------------
		 * Set Classes
		 * ---------------------------------------------------------------- */
		$pro_ads_cpt_meta_options = new Pro_Ads_CPT_Meta_Options();
		$pro_ads_cpts = new Pro_Ads_CPTs();	
		$pro_ads_main = new Pro_Ads_Main();
		$pro_ads_codex = new Pro_Ads_Codex();
		$pro_ads_advertisers = new Pro_Ads_Advertisers();
		$pro_ads_banners = new Pro_Ads_Banners();
		$pro_ads_campaigns = new Pro_Ads_Campaigns();
		$pro_ads_adzones = new Pro_Ads_Adzones();
		
		$wppas_stats = new WPPAS_Stats();
		$wppas_stats_tpl = new WPPAS_Stats_Tpl();
		$pro_ads_statistics = new Pro_Ads_Statistics();
		
		$wppas_banner_creator = new WPPAS_Banner_Creator();
		$wppas_adzone_creator = new WPPAS_Adzone_Creator();
		$wppas_paypal_ipn = new WPPAS_Paypal_IPN();
		$wppas_svg = new WPPAS_SVG_Items();
		$wppas_shape = new WPPAS_Shape_Items();
		$wppas_google_fonts = new WPPAS_Google_Fonts();
		$wppas_activate = new WPPAS_Activate();
		$wppas_vc_addon = new WPPAS_VC_Addon();
		$wppas_ajax_image_upload = new WPPAS_Ajax_Image_upload();
		$wppas_mobile_detect = new WPPAS_Mobile_Detect();
		$pro_ads_templates = new Pro_Ads_Templates();
		$pro_ads_shortcodes = new Pro_Ads_Shortcodes();
		$pro_ads_multisite = new Pro_Ads_Multisite();
		$pro_ads_browser = new Pro_Ads_Browser();
		$pro_ads_responsive = new Pro_Ads_Responsive();
		$pro_ads_tinymce = new Pro_Ads_Tinymce();
		$pro_ads_api = new Pro_Ads_Api();
		$pro_ads_updates = new Pro_Ads_Updates();
		$pro_ads_post_control = new Pro_Ads_Post_Control();
		//$pro_ads_vsc_class = new WPPROADVSC_AddonClass();
		
		
		// Actions --------------------------------------------------------
		add_action('init', array( $this, 'init_method') );
		add_action('init', array( $this, 'custom_rewrite_tags'), 10, 0);
		add_action('parse_request', array($this, 'handle_api_requests'), 0);
		add_action('admin_init', array( $this, 'admin_init_method') );
		add_action('wp_enqueue_scripts', array($this, 'wppas_enqueue_scripts') );
		add_action('wp_head', array( $this, 'add_to_head'), 1 );
		add_action('wppas_head', array( $pro_ads_main, 'debug_marker' ), 2 );
		add_action('admin_menu', array( $this,'admin_actions') );
		add_action('admin_head', array( $this, 'menu_highlight' ) );
		add_action('plugins_loaded', array( $this, 'check_for_add_on_plugins'));
		add_action('wp_footer', array($this, 'add_to_footer') );
		add_action('widgets_init', array($this, 'pro_ad_adzone_widgets_init'), 30 );
		add_action('admin_bar_menu', array($this, 'pro_ads_admin_bar'), 100);
		add_action('admin_notices', array($this, 'pro_ads_admin_notices') );
		add_filter('admin_footer_text', array( $this, 'wpproads_admin_footer_text' ), 1 );
		
		// Cornerstone
		add_action( 'cornerstone_register_elements', array( $this, 'wpproads_cornerstone_elements') );
		
		
		// Custom Tables
		if(!class_exists('WP_List_Table')){
			require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );
		}
		require_once( WP_ADS_INC_DIR.'/stats_table/stats.php');
		require_once( WP_ADS_INC_DIR.'/stats_table/stats_day.php');
		require_once( WP_ADS_INC_DIR.'/stats_table/stats_year.php');
		require_once( WP_ADS_INC_DIR.'/stats_table/stats_all.php');
		require_once( WP_ADS_INC_DIR.'/pagination_table.php');
	}
	
	
	
	/**
	 * Install WPPAS
	 */
	public function install() 
	{
		global $pro_ads_updates;
		
		$this->create_tables();
		$pas_version = get_option( 'pro_ad_system_version', 0 );
		
		//$current_version = get_option( 'pro_ad_system_version', null );
		set_transient( '_pas_activation_redirect', 1, 60 * 60 );
		
		// Update Settings
		$wpproads_enable_stats = get_option('wpproads_enable_stats', 0);
		if( empty($pas_version) && empty( $wpproads_enable_stats ) ) 
		{
			update_option( 'wpproads_enable_stats', 1);
			update_option( 'wpproads_enable_userdata_stats', 0);
		}
		
		// Update version
		$pro_ads_updates->pro_ads_updates();
	}
	
	
	
	/*
	 * API Requeste - Paypal
	 *
	 * @access public
	 * @return null
	*/
	public function handle_api_requests()
	{
		global $wppas_paypal_ipn;
		
		// Receive Paypal data
		if ( isset( $_GET['wppas-pp-ipn'] ) && !empty( $_GET['wppas-pp-ipn'] )) 
		{
			if($wppas_paypal_ipn->check_ipn_request())
			{
				$ipn_response = $wppas_paypal_ipn->successful_request($IPN_status = true);
				if( $_GET['wppas-pp-ipn'] == 'IPN' )
				{
					WPPAS_BuySell::receive_payment( $ipn_response );
				}
				elseif( $_GET['wppas-pp-ipn'] == 'RENEW' )
				{
					WPPAS_BuySell::receive_payment_renewal( $ipn_response );
				}
			}
			else
			{
				$wppas_paypal_ipn->log_add('ERROR : Invalid ipn_request');	
			}
		}
	}
	
	
	
	/*
	 * Init actions
	 *
	 * @access public
	 * @return null
	*/
	public function init_method() 
	{	
		global $pro_ads_bs_templates, $pro_ads_main, $pro_ads_updates, $pro_ads_statistics, $wppas_stats, $wppas_ajax_image_upload;
		
		define( 'WP_ADS_USER_CAN', current_user_can( WP_ADS_ROLE_USER ) && $pro_ads_main->buyandsell_is_active() || current_user_can( WP_ADS_ROLE_USER ) && $pro_ads_main->buyandsell_woo_is_active()  ? WP_ADS_ROLE_USER : $this->get_admin_role() );
		
		$pro_ads_main->daily_updates();
		$pro_ads_updates->pro_ads_updates();
		
		// Ajax Upload -- wppas_vbc_
		add_action('wp_ajax_wppas_vbc_upload', array($wppas_ajax_image_upload, 'upload'));
		add_action('wp_ajax_wppas_vbc_delete', array($wppas_ajax_image_upload, 'delete_file'));
		/* For non logged-in user */
		add_action('wp_ajax_nopriv_wppas_vbc_upload', array($wppas_ajax_image_upload, 'upload'));
		add_action('wp_ajax_nopriv_wppas_vbc_delete', array($wppas_ajax_image_upload, 'delete_file'));
		
		/*
		 * FRONTEND ONLY
		*/
		if( !is_admin() )
		{
			$wppas_ajax_image_upload->add_script();
			// Page view banner load
			//update_option( 'wpproads_pvbl', array() );
			$wppas_stats->update_pvbl_cookie();
		}
		// $this->create_tables();
		
		/*if( current_user_can(WP_ADS_ROLE_ADMIN) ){
			$wppas_stats->remove_user_cookie();
		}*/
		
	}
	
	
	
	
	
	/*
	 * Admin Init actions
	 *
	 * @access public
	 * @return null
	*/
	public function admin_init_method()
	{
		/* -------------------------------------------------------------------------------------------------
		 * Code to activate the auto updater.
		 * ------------------------------------------------------------------------------------------------- */
		$wpproads_license_key = get_option('wpproads_license_key', '');
		//set_site_transient('update_plugins', null);
		require( WP_ADS_DIR.'/classes/PLU_Auto_Plugin_Updater.php');
		$api_url = 'http://community.tunasite.com/?plu-plugin=ajax-handler';
		//$api_url = 'http://tunasite.com/updates/?plu-plugin=ajax-handler';
		// current plugin version | remote url | Plugin Slug (plugin_directory/plugin_file.php) | users envato license key (default: '') | envato item ID (default: '')
		new PLU_Auto_Plugin_Updater(WP_ADS_VERSION, $api_url, WP_ADS_PLUGIN_SLUG.'/'.WP_ADS_PLUGIN_SLUG.'.php', $wpproads_license_key, WP_ADS_ENVATO_ID);
	}
	
	
	
	/*
	 * Chack for add-on plugins
	 *
	 * @access public
	 * @return null
	*/
	public function check_for_add_on_plugins()
	{
		/*$has_smartrack = class_exists('sTrack_Core') ? 1 : 0;
		define( 'WPPAS_HAS_SMARTRACK', $has_smartrack );*/
	}
	
	
	
	
	/*
	 * Enqueue Scripts & Styles for the Front end
	 *
	 * @access public
	 * @return null
	*/
	public function wppas_enqueue_scripts()
	{
		global $pro_ads_codex, $wppas_banner_creator, $pro_ads_multisite;
		
		$wppas_dev_mode = get_option('wppas_dev_mode', 0);
		
		// Enqueue scripts
		wp_enqueue_script('jquery');
		wp_enqueue_script('jquery-ui-core');
		wp_enqueue_script('jquery-effects-core');
		wp_enqueue_script('jquery-effects-shake');
		wp_enqueue_script('wppas_dummy_advertising', WP_ADS_TPL_URL . '/js/advertising.js');
		wp_register_script( 'wp-color-picker-alpha', WP_ADS_URL.'public/assets/js/wp-color-picker-alpha.min.js', array( 'wp-color-picker' ), '1.0.0', true );
		//wp_enqueue_script('wppas_jquery_cookie', WP_ADS_TPL_URL . '/js/jquery.cookie.js', array( 'jquery' ), WP_ADS_VERSION, true );
		
		/**
		 * async removed @since v5.3.0
		 *
		$wpproads_enable_async_js_tag = get_option('wpproads_enable_async_js_tag', 1);
		if( $wpproads_enable_async_js_tag )
		{
			wp_enqueue_script('wppas_asyncjs', admin_url('admin-ajax.php').'?action=wppas_asyncjs');
		}*/
		
		// Register scripts & styles for later use
		$wppas_js_url = !$wppas_dev_mode ? WP_ADS_TPL_URL.'/js/wppas.min.js' : WP_ADS_TPL_URL.'/js/wppas.js';
		wp_register_script('wp_pro_add_js_functions', $wppas_js_url );
		//wp_register_script('wp_pro_add_js_functions', WP_ADS_TPL_URL.'/js/wppas.js' );
		wp_register_script('wp_pro_add_corncurl', WP_ADS_TPL_URL.'/js/corncurl.min.js');
		wp_register_script('wp_pro_add_scrolltofixed', WP_ADS_TPL_URL.'/js/jquery-scrolltofixed-min.js');
		wp_register_script('wppas_jquery_cookie', WP_ADS_TPL_URL . '/js/jquery.cookie.js' );
		wp_register_script('wppas_jshowoff', WP_ADS_TPL_URL . '/js/jquery.jshowoff.min.js', array( 'jquery' ), WP_ADS_VERSION, true );
		wp_register_script('wppas_bxslider',  WP_ADS_TPL_URL . '/js/jquery.bxslider.min.pas.js', array( 'jquery' ), WP_ADS_VERSION, true );
		wp_register_script('wppas_jsrslider', WP_ADS_URL.'public/assets/js/slide/jssor.slider.min.js', array( 'jquery' ), WP_ADS_VERSION,true);
		//wp_register_script('wppas_asyncjs', admin_url('admin-ajax.php').'?action=wppas_asyncjs');
		
		// Styles
		$wppas_css_url = !$wppas_dev_mode ? WP_ADS_TPL_URL."/css/wppas.min.css" : WP_ADS_TPL_URL."/css/wppas.css";
		wp_register_style( 'wp_pro_add_style', $wppas_css_url, false, WP_ADS_VERSION, "all" );
		
		
		/* -- Visual banner creator -- */
		wp_register_style( 'wp_pro_ad_UI_style', WP_ADS_TPL_URL . '/css/jqueryUI/jquery-ui.min.css', false, WP_ADS_VERSION, "all" );
		wp_register_style("WPPAS_VBC_EDITR_STYLE", WP_ADS_URL."public/assets/css/vbc/wppas_vbc_editor.css", false, WP_ADS_VERSION, "all");
		wp_enqueue_style("WPPAS_VBC_BNR_STYLE", WP_ADS_URL."public/assets/css/vbc/wppas_vbc_bnr.css", false, WP_ADS_VERSION, "all");
		wp_enqueue_script('WPPAS_VBC_EF', WP_ADS_URL.'public/assets/js/vbc/jquery-ui-effects.min.js', array( 'jquery' ), WP_ADS_VERSION, true );
		$this->vbc_styles_and_scripts();
		
		$wppas_banner_creator->itm_edit_container();
		WPPAS_TPL::save_confirms(array('for' => 'banner'));
		WPPAS_DEF::predefined_buttons(array('localize' => 1));
		wp_localize_script( 'WPPAS_VBC_EDITR', 'WP_ADS_URL', array('url' => WP_ADS_URL) );
		wp_localize_script( 'WPPAS_VBC_EDITR', 'URL', array('url' => $pro_ads_multisite->wpproads_get_site_url()) );
		
		wp_register_script('wp_pro_ads_ace', WP_ADS_TPL_URL.'/js/ace/ace.js');
		wp_register_script('wp_pro_ads_js_switch_button', WP_ADS_TPL_URL.'/js/jquery.switchButton.js', array( 'jquery' ), WP_ADS_VERSION, true);
		wp_register_style( 'chosen_style', WP_ADS_INC_URL . '/chosen/chosen.css', false, WP_ADS_VERSION, "all" );
		wp_register_script( 'chosen', WP_ADS_INC_URL . '/chosen/chosen.jquery.min.js', array( 'jquery' ), false, true );
		
		wp_register_style( 'wppas_font_awesome_style', WP_ADS_INC_URL.'/font-awesome/css/font-awesome.min.css', false, WP_ADS_VERSION, 'all');
		/* -- end visual banner creator -- */
		
		
		/**
		 * CUSTOM DYNAMIC CSS
		 * @since v4.7.4
		 * https://codex.wordpress.org/Function_Reference/wp_add_inline_style
		 * before: wp_register_style( 'wppas_php_style', admin_url('admin-ajax.php').'?action=wppas_php_style', false, WP_ADS_VERSION, "all" );
		*/
		
		// Customizable CSS file -> wppas_php_style - ajax_functions.php
		//wp_register_style( 'wppas_php_style', admin_url('admin-ajax.php').'?action=wppas_php_style', false, WP_ADS_VERSION, "all" );
		wp_register_style(
			'wppas_php_style',
			WP_ADS_TPL_URL."/css/wppas_custom_css.css"
		);
		
		//$wpproads_adzone_class = get_option('wpproads_adzone_class', 'wppaszone');
		$wpproads_adzone_class = $pro_ads_codex->wpproads_adzone_class();
		
		$custom_css = "
			/* ----------------------------------------------------------------
			 * WP PRO ADVERTISING SYSTEM - ADZONES
			 * ---------------------------------------------------------------- */
			.".$wpproads_adzone_class." img {
				max-width: 100%;
				height:auto;
			}
			.".$wpproads_adzone_class." {overflow:hidden; visibility: visible !important; display: inherit !important; }
			.pas_fly_in .".$wpproads_adzone_class." {visibility: hidden !important; }
			.pas_fly_in.showing .".$wpproads_adzone_class." {visibility: visible !important; }
			
			.wppasrotate, .".$wpproads_adzone_class." li { margin: 0; padding:0; list-style: none; }
			.rotating_paszone > .pasli { visibility:hidden; }
			.".$wpproads_adzone_class." .jshowoff .wppasrotate .pasli { visibility: inherit; }
		";
		
		wp_add_inline_style( 'wppas_php_style', $custom_css );
		// -- end custom dynamic CSS --
		
		wp_register_style( 'wppas_font_awesome_style', WP_ADS_INC_URL.'/font-awesome/css/font-awesome.min.css', false, WP_ADS_VERSION, 'all');
		
		// Localize scripts
		wp_localize_script('wp_pro_add_js_functions', 'wppas_ajax_script', array( 'ajaxurl' => admin_url( 'admin-ajax.php' ) ) );
	}
	
	
	
	
	
	
	public function vbc_styles_and_scripts()
	{
		$wppas_dev_mode = get_option('wppas_dev_mode', 0);
		
		wp_enqueue_script('WPPAS_POSRBE', WP_ADS_URL.'public/assets/js/vbc/postscribe.min.js', array('jquery'), WP_ADS_VERSION, true);
		//wp_enqueue_script('WPPAS_HTML2CS', WP_ADS_URL.'public/assets/js/vbc/html2canvas.js', array('jquery'), WP_ADS_VERSION, true);
		wp_enqueue_script('WPPAS_DOMTOIMG', WP_ADS_URL.'public/assets/js/dom-to-image.js', array('jquery'), WP_ADS_VERSION, true);
		
		
		$wppas_vbc = !$wppas_dev_mode ? WP_ADS_URL.'public/assets/js/vbc/jquery.wppas.vbc.min.js' : WP_ADS_URL.'public/assets/js/vbc/__dv/jquery.wppas.vbc.js';
		wp_enqueue_script('WPPAS_VBC', $wppas_vbc, array( 'jquery' ), WP_ADS_VERSION, true );
		
		$wppas_vbc_editor = !$wppas_dev_mode ? WP_ADS_URL.'public/assets/js/vbc/jquery.wppas.vbc.editor.min.js' : WP_ADS_URL.'public/assets/js/vbc/__dv/jquery.wppas.vbc.editor.js';
		wp_register_script('WPPAS_VBC_EDITR', $wppas_vbc_editor, array( 'jquery' ), WP_ADS_VERSION, true );
		
		$wppas_vbc_bs = !$wppas_dev_mode ? WP_ADS_URL.'public/assets/js/vbc/jquery.wppas.buyandsell.min.js' : WP_ADS_URL.'public/assets/js/vbc/__dv/jquery.wppas.buyandsell.js';
		wp_register_script('WPPAS_VBC_BS', $wppas_vbc_bs, array( 'jquery' ), WP_ADS_VERSION, true );
		wp_localize_script( 'WPPAS_VBC_BS', 'ajax', array( 'url' => admin_url( 'admin-ajax.php' ) ) );	
		
		if( is_admin())
		{
			$wppas_vbc_stscrn = !$wppas_dev_mode ? WP_ADS_URL.'public/assets/js/vbc/jquery.wppas.vbc.startscreen.min.js' : WP_ADS_URL.'public/assets/js/vbc/__dv/jquery.wppas.vbc.startscreen.js';
			wp_enqueue_script('WPPAS_VBC_STSCRN', $wppas_vbc_stscrn, array( 'jquery' ), WP_ADS_VERSION, true );
			
			$wppas_vbc_adzn_stscrn = !$wppas_dev_mode ? WP_ADS_URL.'public/assets/js/vbc/jquery.wppas.vbc.adzone.startscreen.min.js' : WP_ADS_URL.'public/assets/js/vbc/__dv/jquery.wppas.vbc.adzone.startscreen.js';
			wp_enqueue_script('WPPAS_VBC_ADZN_STSCRN', $wppas_vbc_adzn_stscrn, array( 'jquery' ), WP_ADS_VERSION, true );
			
			wp_register_script('WPPAS_VBC_GFONT_JS', WP_ADS_URL.'public/assets/js/gfont/jquery.fontselect_cm.js', array( 'jquery' ), WP_ADS_VERSION, true );
			wp_register_style( 'WPPAS_VBC_GFONT_CSS', WP_ADS_URL.'public/assets/css/gfont/fontselect-default.css', false, WP_ADS_VERSION, 'all');
		}
	}

	
	
	
	
	
	/*
	 * Init Custom rewrite tags
	 *
	 * @access public
	 * @return null
	 *
	 * Usage:
	 * global $wp_query;
	 * $wp_query->query_vars['pasID'];
	*/
	public function custom_rewrite_tags() 
	{
		add_rewrite_tag('%pasID%', '([^&]+)'); // //([0-9]+)
		add_rewrite_tag('%pasSLUG%', '([^&]+)');
		add_rewrite_tag('%pasZONE%', '([^&]+)');
		add_rewrite_tag('%pasREF%', '([^&]+)');
		
		$mod_rewrite_str   = get_option('wp_ads_mod_rewrite', 'pas');
		add_rewrite_rule('^'.$mod_rewrite_str.'/([^/]*)/([^/]*)/([^/]*)/?','index.php?pasSLUG=$matches[1]&pasZONE=$matches[2]&pasREF=$matches[3]','top');
	}
	
	
	
	

	/*
	 * Get admin role
	 *
	 * @access public
	 * @return $role
	*/
	public function get_admin_role()
	{
		$role = WP_ADS_ROLE_ADMIN;
		
		if ( ! function_exists( 'is_plugin_active_for_network' ) ) {
			require_once( ABSPATH . '/wp-admin/includes/plugin.php' );
		}
		
		if ( is_multisite() ) 
		{
			if( is_plugin_active_for_network('wppas/wppas.php') )
			{
				$role = WP_ADS_ROLE_SUPERADMIN;
			}
		}
		
		return $role;
	}
	
	
	
	
	
	/*
	 * Admin page Init actions
	 *
	 * @access public
	 * @return null
	*/
	public function admin_actions() 
	{
		global $pro_ads_main, $pro_ads_multisite, $wppas_banner_creator, $wppas_adzone_creator, $wppas_ajax_image_upload;
		
		// Check if admin actions need to be loaded.
		if( $pro_ads_multisite->pro_ads_load_admin_data() )
		{
			wp_enqueue_style( 'wpproads_standard_admin', WP_ADS_TPL_URL . '/css/admin_standard.css', false, WP_ADS_VERSION, "all" );
			//wp_enqueue_style('wppas_font_awesome_style');
			wp_enqueue_style( 'wp-color-picker' );
			wp_enqueue_script( 'wp-color-picker');
			wp_register_script( 'wp-color-picker-alpha', WP_ADS_URL.'public/assets/js/wp-color-picker-alpha.min.js', array( 'wp-color-picker' ), '1.0.0', true );
			wp_register_script('WPPAS_VBC', WP_ADS_URL.'public/assets/js/vbc/__dv/jquery.wppas.vbc.js', array( 'jquery' ), WP_ADS_VERSION, true );
			wp_register_script('wp_pro_ads_js_switch_button', WP_ADS_TPL_URL.'/js/jquery.switchButton.js', array( 'jquery' ), WP_ADS_VERSION, true);
			
			if(is_admin() && isset( $_GET['page'] ) || is_admin() && isset($_GET['post_type']) || is_admin() && isset($_GET['post']) && $this->wp_pro_ad_check_cpt( get_post_type( $_GET['post'] )) )
			{
				if( 
					isset( $_GET['page'] ) && $_GET['page'] == 'wp-pro-advertising' || 
					isset( $_GET['page'] ) && $_GET['page'] == 'wp-pro-ads-stats' ||  
					isset( $_GET['page'] ) && $_GET['page'] == 'wppas-banner-creator' ||  
					isset( $_GET['page'] ) && $_GET['page'] == 'wp-pro-ads-banners' ||  
					isset( $_GET['page'] ) && $_GET['page'] == 'wp-pro-ads-purchases' || 
					isset( $_GET['page'] ) && $_GET['page'] == 'wp-pro-ads-options' || 
					isset( $_GET['page'] ) && $_GET['page'] == 'pro-ads-bs-options' || 
					isset( $_GET['post_type'] ) && $this->wp_pro_ad_check_cpt( $_GET['post_type'] ) ||
					isset( $_GET['post'] ) && $this->wp_pro_ad_check_cpt( get_post_type( $_GET['post'] ))
					
				 ){
					wp_enqueue_script('jquery');
					wp_enqueue_script('jquery-ui-core');
					wp_enqueue_script("jquery-effects-core");
					wp_enqueue_script("jquery-effects-shake");
					wp_enqueue_script('jquery-ui-sortable');
					wp_enqueue_script('jquery-ui-draggable');
					wp_enqueue_script('jquery-ui-droppable');
					wp_enqueue_script('jquery-ui-resizable');
					wp_enqueue_script('jquery-ui-datepicker');
					wp_enqueue_script('pro_ad_admin_js', WP_ADS_TPL_URL . '/js/admin.js', array( 'jquery' ), WP_ADS_VERSION, true );
					wp_enqueue_script('wp_pro_ads_js_switch_button');
					
					wp_enqueue_style( 'wppas_font_awesome_style', WP_ADS_INC_URL.'/font-awesome/css/font-awesome.min.css', false, WP_ADS_VERSION, 'all');
					
					// -- Visual Banner Creator --
					$wppas_ajax_image_upload->add_script(array('type' => 'zip', 'allow_ext' => 'zip,application/octet-stream,application/zip,application/x-zip,application/x-zip-compressed'));	
					wp_enqueue_script('WPPAS_VBC');
					
					$this->vbc_styles_and_scripts();
					
					wp_register_script('wppas_jsrslider', WP_ADS_URL.'public/assets/js/slide/jssor.slider.min.js', array( 'jquery' ), WP_ADS_VERSION,true);
					// wp localize scripts
					$wppas_banner_creator->itm_edit_container();
					WPPAS_TPL::save_confirms(array('for' => 'banner'));
					WPPAS_TPL::save_confirms(array('for' => 'adzone'));
					WPPAS_DEF::predefined_buttons(array('localize' => 1));
					wp_localize_script( 'WPPAS_VBC_EDITR', 'WP_ADS_URL', array('url' => WP_ADS_URL) );
					wp_localize_script( 'WPPAS_VBC_EDITR', 'URL', array('url' => $pro_ads_multisite->wpproads_get_site_url()) ); //get_bloginfo('url')
					wp_enqueue_script( 'WPPAS_VBC_EDITR' );
					
					wp_enqueue_style("WPPAS_VBC_EDITR_STYLE", WP_ADS_URL."public/assets/css/vbc/wppas_vbc_editor.css", false, WP_ADS_VERSION, "all");
					wp_enqueue_style("WPPAS_VBC_BNR_STYLE", WP_ADS_URL."public/assets/css/vbc/wppas_vbc_bnr.css", false, WP_ADS_VERSION, "all");
					
					// -- end Visual Banner Creator --
					
					wp_enqueue_script('wp_pro_ads_js_cufon', WP_ADS_TPL_URL.'/js/cufon-yui.js');
					wp_enqueue_script('wp_pro_ads_js_font', WP_ADS_TPL_URL.'/js/ITCAvantGardeStd-Bold_700.font.js');
					
					//wp_enqueue_script('wp_pro_ads_js_switch_button', WP_ADS_TPL_URL.'/js/jquery.switchButton.js', array( 'jquery' ), WP_ADS_VERSION, true);
					wp_enqueue_script('wp_pro_ads_js_timepicker', WP_ADS_TPL_URL.'/js/timepicker/jquery.timepicker.min.js', array( 'jquery' ), WP_ADS_VERSION, true);
					wp_enqueue_script('wp_pro_ads_js_timepickerdatepair', WP_ADS_TPL_URL.'/js/timepicker/datepair.js', array( 'jquery' ), WP_ADS_VERSION, true);
					wp_enqueue_script('wp_pro_ads_js_timepickerdatepairjquery', WP_ADS_TPL_URL.'/js/timepicker/jquery.datepair.js', array( 'jquery' ), WP_ADS_VERSION, true);
					wp_register_script('wp_pro_ads_ace', WP_ADS_TPL_URL.'/js/ace/ace.js');
					
					// Localize scripts
					wp_localize_script('pro_ad_admin_js', 'wppas_local', 
						array( 
							'variable'    => __('VARIABLE', 'wpproads'), 
							'fixed'       => __('FIXED','wpproads') ,
							'date_format' => $pro_ads_main->dateformat_PHP_to_jQueryUI( get_option( 'date_format' ) )
						) 
					);
					
					// Main CSS
					wp_enqueue_style("wp_pro_ads_main_style", WP_ADS_TPL_URL."/css/wppas.min.css", false, WP_ADS_VERSION, "all");
					wp_enqueue_style("wp_pro_ads_timepicker_style", WP_ADS_TPL_URL."/css/jquery.timepicker.css", false, WP_ADS_VERSION, "all");
					
					
					
					// Statistics only
					if( isset( $_GET['page'] ) && $_GET['page'] == 'wp-pro-ads-stats' )
					{
						wp_enqueue_script('pro_ad_statistics_flot', WP_ADS_TPL_URL . '/js/jquery.flot.min.js');
						wp_enqueue_script('pro_ad_statistics_flot_time', WP_ADS_TPL_URL . '/js/jquery.flot.time.js');
						wp_enqueue_script('pro_ad_statistics_flot_pie', WP_ADS_TPL_URL . '/js/jquery.flot.pie.min.js');
						wp_enqueue_script('pro_ad_statistics_flot_resize', WP_ADS_TPL_URL . '/js/jquery.flot.resize.min.js');
						wp_enqueue_style( 'pro_ad_statistics_flot_style', WP_ADS_TPL_URL . '/css/graph.css', false, WP_ADS_VERSION, "all" );
					}
					
					// Chosen
					wp_enqueue_style( 'wppas_chosen_style', WP_ADS_INC_URL . '/chosen/chosen.css', false, WP_ADS_VERSION, "all" );
					wp_enqueue_script( 'wppas_chosen', WP_ADS_INC_URL . '/chosen/chosen.jquery.min.js', array( 'jquery' ), false, true );
					
					// Load media
					if( function_exists('wp_enqueue_media') )
					{
						wp_enqueue_media();
					}
					
					// Wordpress thickbox: Example link: <a href="" class="thickbox">Link</a>. (http://manchumahara.com/2010/03/22/using-wordpress-native-thickbox/) 
					wp_enqueue_script('thickbox',null,array('jquery'));
					wp_enqueue_style('thickbox.css', '/'.WPINC.'/js/thickbox/thickbox.css', null, '1.0');
					
					
					wp_enqueue_style( 'wpproadstuna_admin_style', WP_ADS_TPL_URL . '/css/tuna-admin.css', false, WP_ADS_VERSION, "all" );
					wp_enqueue_style( 'wppas_admin_style', WP_ADS_TPL_URL . '/css/wppas_admin.css', false, WP_ADS_VERSION, "all" ); // since v5.0.0
					wp_enqueue_style( 'wpproads_tuna_admin_colors', WP_ADS_TPL_URL . '/css/tuna-admin-colors.php', false, WP_ADS_VERSION, "all" );
					wp_enqueue_style( 'wp_pro_ad_admin_style', WP_ADS_TPL_URL . '/css/admin.css', false, WP_ADS_VERSION, "all" );
					wp_enqueue_style( 'wp_pro_ad_UI_style', WP_ADS_TPL_URL . '/css/jqueryUI/jquery-ui.min.css', false, WP_ADS_VERSION, "all" );
				 }
			}
			
	
			// Create menu
			add_menu_page(
				__('Advertising', 'wpproads'), 
				__('Advertising', 'wpproads'), 
				WP_ADS_USER_CAN,  
				"wp-pro-advertising", 
				array( $this, "wp_pro_ad_dashboard"),
				WP_ADS_URL."images/logo_20.png", // since v4.6.19
				20 // since v4.6.20
			);
			
			WPPAS_CORE::vbc_menu();
			
			add_submenu_page("wp-pro-advertising", __('AD Dashboard', 'wpproads'), __('AD Dashboard', 'wpproads'), WP_ADS_USER_CAN, "wp-pro-advertising", array( $this, "wp_pro_ad_dashboard"));
			//add_submenu_page("wp-pro-advertising", __('Banner Creator', 'wpproads'), __('Banner Creator', 'wpproads'), WP_ADS_USER_CAN, "wppas-banner-creator", array( $this, "wppas_banner_creator"));
			add_submenu_page("wp-pro-advertising", __('Statistics', 'wpproads'), __('Statistics', 'wpproads'), WP_ADS_USER_CAN, "wp-pro-ads-stats", array( $this, "wp_pro_ad_stats"));
			//add_submenu_page("wp-pro-advertising", __('Purchases', 'wpproads'), __('Purchases', 'wpproads'), WP_ADS_USER_CAN, "wp-pro-ads-purchases", array( $this, "wppas_purchases"));
		
			if( current_user_can(WP_ADS_ROLE_ADMIN))
			{
				add_filter( 'custom_menu_order', array($this, 'submenu_order') );
			}
		
		}
	}
	
	
	function submenu_order( $menu_ord ) 
	{
		global $submenu;
			
		// Enable the next line to see all menu orders
		//echo '<pre>'.print_r($submenu['edit.php?post_type=advertising'],true).'</pre>';
		//echo '<pre>'.print_r($submenu['wp-pro-advertising'],true).'</pre>';
		if( isset($submenu['wp-pro-advertising']))
		{
			$arr = array();
			$itms = count($submenu['wp-pro-advertising']);
			
			//$arr[] = $submenu['wp-pro-advertising'][5];
			$arr[] = $submenu['wp-pro-advertising'][4];
			$arr[] = $submenu['wp-pro-advertising'][0];
			$arr[] = $submenu['wp-pro-advertising'][1];
			$arr[] = $submenu['wp-pro-advertising'][2];
			$arr[] = $submenu['wp-pro-advertising'][3];
			$arr[] = $submenu['wp-pro-advertising'][5];
			
			// Allow (3rd party) add-ons to add item to menu
			if( $itms > 6 )
			{
				for($m = 6; $m < $itms; $m++)
				{
					$arr[] = $submenu['wp-pro-advertising'][$m];
				}
			}
			
			//$arr[] = $submenu['wp-pro-advertising'][6];
			$submenu['wp-pro-advertising'] = $arr;
		}
	
		return $menu_ord;
	}
	
	/*
	 * Highlights the correct top level admin menu item for post types.
	*/
	public function menu_highlight() 
	{
		global $menu, $submenu, $parent_file, $submenu_file, $self, $post_type, $taxonomy;

		if ( isset( $post_type ) ) {
			if ( in_array( $post_type, PAS()->cpts ) ) {
				$submenu_file = 'edit.php?post_type=' . esc_attr( $post_type );
				$parent_file  = 'wp-pro-advertising';
			}
		}
	}
	
	
	
	/*
	 * Admin menu functions
	 *
	 * @access public
	 * @return html
	*/
	public function wp_pro_ad_dashboard()
	{
		include( WP_ADS_TPL_DIR.'/wppas_dashboard.php');
	}
	public function wp_pro_ad_stats()
	{
		include( WP_ADS_TPL_DIR.'/pro_ad_stats.php');
	}
	public function wp_pro_ad_options()
	{
		include( WP_ADS_TPL_DIR.'/pro_ad_options.php');
	}
	/*public function wppas_banner_creator()
	{
		include( WP_ADS_TPL_DIR.'/wppas_banner_creator.php');
	}*/
	/*public function wppas_purchases()
	{
		include( WP_ADS_TPL_DIR.'/wppas_purchases.php');
	}*/
	/*public function wppas_banners()
	{
		include( WP_ADS_TPL_DIR.'/wppas_banners.php');
	}*/
	
	
	
	
	
	
	
	/*
	 * Create the database tables the plugin needs to function.
	 *
	 * @access public
	 * @return void
	*/
	public function create_tables() 
	{
		global $wpdb;
		require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );

		$wpdb->hide_errors();
		
		$collate = '';

		if ( $wpdb->has_cap( 'collation' ) ) 
		{
			if ( ! empty($wpdb->charset ) ) 
			{
				$collate .= "DEFAULT CHARACTER SET $wpdb->charset";
			}
			if ( ! empty($wpdb->collate ) )
			{
				$collate .= " COLLATE $wpdb->collate";
			}
		}
		
		// daily statistics
		$sql_wppas_stats = "CREATE TABLE " . $wpdb->prefix . "wppas_stats (
			id int(11) NOT NULL AUTO_INCREMENT,
			time int(11) NOT NULL,
			impressions int(11) NOT NULL,
			clicks int(11) NOT NULL,
			data longtext NOT NULL,
			UNIQUE KEY id (id),
			KEY time (time)
		) ".$collate.";";
		dbDelta( $sql_wppas_stats );
		
		// v5.0.5+ daily statistics
		$sql_wppas_daily_stats = "CREATE TABLE " . $wpdb->prefix . "wppas_daily_stats (
			id int(11) NOT NULL AUTO_INCREMENT,
			time int(11) NOT NULL,
			impressions int(11) NOT NULL,
			unique_impressions int(11) NOT NULL,
			clicks int(11) NOT NULL,
			unique_clicks int(11) NOT NULL,
			data longtext NOT NULL,
			UNIQUE KEY id (id),
			KEY time (time)
		) ".$collate.";";
		dbDelta( $sql_wppas_daily_stats );
		
		// v5.1.5+ Buy and Sell
		$sql_wppas_buysell = "CREATE TABLE " . $wpdb->prefix . "wppas_buysell (
			id int(11) NOT NULL AUTO_INCREMENT,
			time int(11) NOT NULL,
			user_id int(11) NOT NULL,
			email VARCHAR( 80 ) NOT NULL,
			ip_address VARCHAR( 50 ) NOT NULL,
			advertiser_id int(11) NOT NULL,
			banner_id mediumint(9) NOT NULL,
			adzone_id mediumint(9) NOT NULL,
			alphaID VARCHAR( 100 ) NOT NULL,
			banner longtext NOT NULL,
			status VARCHAR( 50 ) NOT NULL,
			price VARCHAR(50) NOT NULL,
			am_paid VARCHAR(50) NOT NULL,
			pos VARCHAR(50) NOT NULL,
			trans_date VARCHAR(100) NOT NULL,
			transaction VARCHAR(200) NOT NULL,
			provider VARCHAR( 50 ) NOT NULL,
			UNIQUE KEY id (id),
			KEY time (time)
		) ".$collate.";";
		dbDelta( $sql_wppas_buysell );
	}
	
	
	
	
	
	
	
	/*
	 * Create Widget
	 *
	 * @access public
	 * @return string
	*/
	public function pro_ad_adzone_widgets_init() 
	{	
		register_widget('Wppas_Custom_Widgets');
	}


	
	
	
		
	
	
	
	/*
	 * Add stuff to the website <head>
	 *
	 * @access public
	 * @return string
	*/
	public function add_to_head()
	{
		$custom_css = get_option('wpproads_custom_css', '');
		$wpproads_google_analytics_id = get_option('wpproads_google_analytics_id', '');
		
		/*
		 * Action: 'wppas_head' - Allow other plugins to output inside the WP PRO Advertising section of the head section.
		*/
		do_action( 'wppas_head' );
		
		
		// Load custom CSS ----------------------------------------
		if( !empty( $custom_css ))
		{
			echo '<style type="text/css" id="wp_pro_advertising_system_css">'.stripslashes($custom_css).'</style>',"\n";
		}
		
		// Google Analytics
		if( !empty($wpproads_google_analytics_id) )
		{
			echo "<script>(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)})(window,document,'script','//www.google-analytics.com/analytics.js','wppas_ga');wppas_ga('create', '".$wpproads_google_analytics_id."', 'auto');</script>";
		}

		echo '<!-- / ', PAS()->plugin_str, ". -->\n\n";
	}
	
	
	
	
	
	/*
	 * Add stuff to the website footer
	 *
	 * @access public
	 * @return string
	*/
	public function add_to_footer()
	{
		global $pro_ads_templates;
		
		
		
	}
	

	
	
	
	
	/*
	 * Allowed CPTs
	 *
	 * @access public
	 * @return int
	*/
	public function wp_pro_ad_check_cpt( $cpt )
	{
		//$cpts = array('advertisers', 'campaigns', 'banners', 'adzones');
		
		return in_array($cpt, PAS()->cpts) ? 1 : 0;
	}
	
	
	
	
	
	
	
	/*
	 * Check if admin page is from the advertising plugin
	 *
	 * @access public
	 * @return int
	*/
	public function page_is_wpproads_admin()
	{
		$is_wpproads_admin = 0;
		
		if(is_admin() && isset( $_GET['page'] ) || is_admin() && isset($_GET['post_type']) || is_admin() && isset($_GET['post']) && $this->wp_pro_ad_check_cpt( get_post_type( $_GET['post'] )) )
		{
			if( 
				isset( $_GET['page'] ) && $_GET['page'] == 'wp-pro-advertising' || 
				isset( $_GET['page'] ) && $_GET['page'] == 'wp-pro-ads-stats' ||  
				isset( $_GET['page'] ) && $_GET['page'] == 'wp-pro-ads-options' || 
				isset( $_GET['page'] ) && $_GET['page'] == 'pro-ads-bs-options' || 
				isset( $_GET['post_type'] ) && $this->wp_pro_ad_check_cpt( $_GET['post_type'] ) ||
				isset( $_GET['post'] ) && $this->wp_pro_ad_check_cpt( get_post_type( $_GET['post'] ))
				
			 ){
				 $is_wpproads_admin = 1;
			 }
		}
		
		return $is_wpproads_admin;
	}
	
	
	
	
	
	
	
	/**
	 * Draw the Admin Bar
	 * @global object $wp_admin_bar
	 * @return null
	 */
	public function pro_ads_admin_bar()
	{
		global $wp_admin_bar, $pro_ads_main, $pro_ads_multisite;
		
		$wpproads_enable_adminbar = get_option('wpproads_enable_adminbar',1);
		
		if (!is_super_admin() || !is_admin_bar_showing() || !$wpproads_enable_adminbar || !$pro_ads_multisite->pro_ads_load_admin_data() )
			return;
		
		$admin_url = get_admin_url();
		
		// Root Menu
		$wp_admin_bar->add_menu(array(
			'id' => 'wpproads_adminbar',
			'title' => '<img src="'.WP_ADS_URL.'images/logo_20.png" alt="WP PRO Advertising" style="width:16px;margin:-1px 3px;vertical-align:initial;display:inline-block;" />'.__('Advertising', 'wpproads'),
			'href' => $admin_url.'admin.php?page=wp-pro-advertising',
			'meta' => array('html' => '')
		));
		// New Requests Menu
		/*$wp_admin_bar->add_menu(array(
			'parent' => 'wpproads_adminbar',
			'id' => 'wpproads_advertisers',
			'title' => __('Advertisers', 'wpproads'),
			'href' => $admin_url.'edit.php?post_type=advertisers'
		));
		// Add Campaign Menu
		$wp_admin_bar->add_menu(array(
			'parent' => 'wpproads_adminbar',
			'id' => 'wpproads_campaigns',
			'title' => __('Campaigns', 'wpproads'),
			'href' => $admin_url.'edit.php?post_type=campaigns'
		));
		// Campaigns Menu
		$wp_admin_bar->add_menu(array(
			'parent' => 'wpproads_adminbar',
			'id' => 'wpproads_banners',
			'title' => __('Banners', 'wpproads'),
			'href' => $admin_url.'edit.php?post_type=banners'
		));
		// Settings Menu
		$wp_admin_bar->add_menu(array(
			'parent' => 'wpproads_adminbar',
			'id' => 'wpproads_adzones',
			'title' => __('Adzones', 'wpproads'),
			'href' => $admin_url.'edit.php?post_type=adzones'
		));*/
		// Settings Menu
		$wp_admin_bar->add_menu(array(
			'parent' => 'wpproads_adminbar',
			'id' => 'wpproads_statistics',
			'title' => __('Statistics', 'wpproads'),
			'href' => $admin_url.'admin.php?page=wp-pro-ads-stats'
		));
	}
	
	
	
	
	
	
	/**
	 * Change the admin footer text on WP PRO Advertising admin pages
	 *
	 * @since  4.2.9
	 * @param  string $footer_text
	 * @return string
	 */
	public function wpproads_admin_footer_text( $footer_text ) 
	{
		$is_wpproads_admin = $this->page_is_wpproads_admin();
		
		// Check to make sure we're on a WP PRO Advertising admin page
		if ( $is_wpproads_admin ) 
		{
			// Change the footer text
			$footer_text = sprintf( __( 'If you like <strong>WP PRO Advertising</strong> please leave us a <a href="%1$s" target="_blank">&#9733;&#9733;&#9733;&#9733;&#9733;</a> rating on <a href="%1$s" target="_blank">Codecanyon.net</a>. A huge thanks in advance!', 'wpproads' ), 'https://codecanyon.net/item/wp-pro-advertising-system-all-in-one-ad-manager/269693' );
		}

		return $footer_text;
	}
	
	
	
	
	
	/**
	 * Admin Notices
	 * @return html
	 */
	public function pro_ads_admin_notices() 
	{
		global $pro_ads_main, $pro_ads_multisite;
		
		$notice = array();
		
		if( $pro_ads_multisite->pro_ads_load_admin_data() )
		{
			/*
			 * Available Notices
			
			//V4.0.4 statistics settings update
			$wpproads_enable_stats = get_option('wpproads_enable_stats', 0);
			$notice[] = PAS()->version >= '4.0.4' && $wpproads_enable_stats == '' ? sprintf(__('<p><strong>%s - Settings update required.</strong> Please update the Statistics settings. Select your option below.</p>','wpproads'), 'WP Pro Advertising System').'<p class="submit"><a class="button-primary" href="'.esc_url( add_query_arg( 'wpproads_stats_update', 'enable' ) ).'">'.__('Enable Statistics','wpproads').'</a> <a class="button-primary" href="'.esc_url( add_query_arg( 'wpproads_stats_update', 'disable' ) ).'">'.__('Disable Statistics','wpproads').'</a>' : '';
			*/
			/*
			 * Handle Notices
			*/
			//V4.0.4 statistics settings update
			/*if ( !empty( $_GET['wpproads_stats_update'] ) ) 
			{
				$status = $_GET['wpproads_stats_update'] == 'enable' ? 1 : 0;
				update_option( 'wpproads_enable_stats', $status);
				update_option( 'wpproads_enable_userdata_stats', $status);
			}*/
		}
		
		
		if( !empty($notice) )
		{
			foreach($notice as $note)
			{
				echo !empty($note) ? '<div class="updated wpproads-message">'.$note.'</div>' : '';
			}
		}
	}
	
	
	
	
	/**
	 * Cornerstone
	 * @return 
	 */
	public function wpproads_cornerstone_elements() 
	{
		cornerstone_register_element( 'WPPAS_Element', 'wppas-element', WP_ADS_TPL_DIR . '/cornerstone/wppas-element' );
	}

}

endif;