/**********************************
 * WPPAS VBC EDITOR 5.1.5
 * @author Tunafish
***********************************/
(function( $ ) {
	"use strict";
	
	var _W = $.fn.wppas;

	$.extend(true, _W, {
		
		/**
		 * PURCHASES
		 */
		purchases: function(options){
			var _t = $(this);
			
			// remove unfinished order button
			$('.wppas_purchases').find('.remove').on('click', function(){
				var order_id = $(this).data('order-id');
				
				$('.wppas_purchases').find('.order_'+order_id).css({'opacity': .3});
				
				$.ajax({
				   type: "POST",
				   url: ajax.url,
				   data: "action=bs_remove_order&id="+order_id
				}).done(function( msg ) {
					//console.log(msg);
					$('.wppas_purchases').find('.order_'+order_id).remove();
				});
			});
		},
		
		
		
		
		/**
		 * START SCREEN - SETTINGS
		 *
		 *
		 */
		buysell: function(options) {
			
			var _t = $(this);
			
			
			$("#bs_confirm_user_details").on("click", function(){
				
				var proceed = 1,
					bsize = $('#wppas_banner_size').val().split('x'),
					size = $('#wppas_banner_size').val(),
					adzone_data = { 
						ID: $('#wppas_adzone_id').val(),
						price: $('#wppas_bs_price').val(),
						pos: $('#wppas_bs_pos').val(),
						contract: $('#wppas_bs_contract').val(),
						duration: $('#wppas_bs_duration').val(),
						size: $('#wppas_banner_size').val(),
					},
					user_data = {
						name: $('#bs_name').val(),
						email: $('#bs_email').val()
					};
				
				// Check if all data is valid to proceed.
				proceed = !_t.wppas.is_valid_email(user_data['email']) ? 0 : proceed;
				proceed = user_data['name'] == '' ? 0 : proceed;
				//proceed = banner_data['name'] == '' ? 0 : proceed;
				
				if( proceed ){
					var array = {};
					array['user_data'] = JSON.stringify(user_data);
					array['adzone_data'] = JSON.stringify(adzone_data);
					$('.vbc_loader_bg').show();
					$('.wppas_bs_loading_vbc').show();
					
					_t.wppas.bs_vbc_form(array);
				}else{
					//console.log('Please fill in all requested data.');
					$('.bs_confirmation_notice').html('Please provide your full name and valid email address.');
				}
			});
			
			
			$("body").on("click", "#bs_confirm_banner", function(){
				_t.wppas.deselect_items();
				
				//console.log( JSON.parse(decodeURIComponent($('#wppas_data').val())));
				
				var proceed = 1,
					data = JSON.parse(decodeURIComponent($('#wppas_data').val())),
					inf = JSON.parse(decodeURIComponent($('#wppas_inf').val())),
					bsize = data['adzone_data']['size'].split('x'), //$('#wppas_banner_size').val().split('x'),
					size = data['adzone_data']['size'], //$('#wppas_banner_size').val(),
					adzone_data = data['adzone_data'],
					user_data = data['user_data'],
					banners_html = [],
					banner_data = {
						ID: $('#banner_ID').val(),
						order_id: inf['order_id'],
						size: data['adzone_data']['size'], //$('#wppas_banner_size').val(),
						w: bsize[0],
						h: bsize[1],
						name: $('#bs_banner_title').val(),
						link: $('#bs_link').val(),
						contract: data['adzone_data']['contract'],
						duration: data['adzone_data']['duration'],
						bs_pos: data['adzone_data']['pos'],
						//advertiser: $('#wppas_banner_advertiser').val(),
						//campaign: $('#wppas_banner_campaign').val(),
						keep_aspect_ratio: 1,
						timeline_arr: _t.wppas.load_timeline_arr()
					};
				
				// Check if all data is valid to proceed.
				proceed = !_t.wppas.is_valid_email(user_data['email']) ? 0 : proceed;
				proceed = user_data['name'] == '' ? 0 : proceed;
				proceed = banner_data['name'] == '' ? 0 : proceed;
				
				if( proceed ){
					
					$.each(options.screen_sizes, function( index, value ) {
						
						var b_html = $("#wppas_banner_html_"+value.size).val();
						
						if(b_html != ""){
							banners_html.push({
								"screen_size": value.size,
								"html": b_html.replace(/&quot;/g, "'") // Replace &quot with ' to solve issue with ajax not saving the HTML anymore.
							});
						}
					});
					
					var array = {};
					array['user_data'] = JSON.stringify(user_data);
					array['adzone_data'] = JSON.stringify(adzone_data);
					array['banner_data'] = JSON.stringify( banner_data );
					array['banner_html'] = JSON.stringify( banners_html );
					$('.vbc_loader_bg').show();
					$('.wppas_bs_loading_vbc').show();
					
					_t.wppas.bs_paypal_form(array);
					
					// ajax.url
					
				}else{
					//console.log('Please fill in all requested data.');
					$('.bs_confirmation_notice').html('Please provide a banner title.');
				}
			});
		},
		
		
		
		/**
		 * Visual Banner Creator form
		 */
		bs_vbc_form: function(data){
			var _t = $(this),
				html = '';
			
			// ajax.url
			$.ajax({
			   type: "POST",
			   url: ajax.url,
			   data: "action=load_bs_vbc_form&data="+encodeURIComponent(JSON.stringify(data))
			}).done(function( msg ) {
				//console.log(msg);
				//$("html, body").animate({ scrollTop: 0 }, "slow");
				$(window).scrollTop(0);
				$('.bs_order_form').hide();
				$('.vbc_loader_bg').hide();
				$('.wppas_bs_loading_vbc').hide();
				$('.bs_payment_container').show();
				$('.bs_payment').html( msg );
				
			});
			
			return html;
		},
		
		
		/**
		 * Paypal form
		 */
		bs_paypal_form: function(data){
			var _t = $(this),
				html = '';
			
			// ajax.url
			$.ajax({
			   type: "POST",
			   url: ajax.url,
			   data: "action=load_bs_paypal_form&data="+encodeURIComponent(JSON.stringify(data))
			}).done(function( msg ) {
				//console.log(msg);
				//$("html, body").animate({ scrollTop: 0 }, "slow");
				_t.wppas.update_got_saved(1);
				$(window).scrollTop(0);
				$('.bs_order_form').hide();
				$('.vbc_loader_bg').hide();
				$('.wppas_bs_loading_vbc').hide();
				$('.bs_payment_container').show();
				$('.bs_payment_container').show();
				$('.bs_payment').html( msg );
			});
			
			return html;
		},
		
		
		
		/**
		 * LOAD VBC
		 */
		load_vbc: function(options){
			var _t = $(this),
				banner_id = options.banner_id,
				html = '';
			
			$("#vbc_edit_modal").show();
			$("html").css({"overflow":"hidden"});
			$("body").css({"overflow":"hidden"});
			$(".vbc_loader_duration").show();
			
			$.ajax({
			   type: "POST",
			   url: ajax.url,
			   data: "action=load_vbc&banner_id="+banner_id
			}).done(function( msg ) {
				console.log(msg);
				$('.vbc_edit_modal_content').html(msg);
				$(".vbc_loader_duration").hide();
				//$("html, body").animate({ scrollTop: 0 }, "slow");
			});
			
			return html;
		}
		
	});
	
}( jQuery ));