<?php
class WPPAS_Banner {	
	
	public function __construct() 
	{
		
	}
	
	
	
	/**
	 * CREATE HTML FROM TIMELINE - under dev...
	 * @since v5.1.9
	 *
	 */
	public static function create_html_from_timeline($args = array())
	{
		global $wppas_banner_creator;
		
		$timeline = WPPAS_TPL::vbc_data(array('id' => $args['bid'], 'type' => 'timeline_arr', 'default' => ''));
		$result = array();
		
		if(!empty($timeline))
		{
			//echo '<pre>'.print_r($timeline, true).'</pre>';	
			// IF VERSION IS OLDER THEN 5.1.9 we need top use the saved banner HTML.
			if(!array_key_exists('v', $timeline))
			{
				return array();
			}
			
			foreach($timeline as $screen_size => $size)
			{
				$html = '';
				if( $screen_size != 'main' && $screen_size != 'v' )
				{
					//echo $screen_size.'<br>';
					foreach($size as $layer_id => $layer)
					{
						//echo '<pre>'.print_r($layer,true).'</pre>';
						$html.= $layer_id != '_empty_' ? self::banner_layer_html($layer) : '';
					}
					$result[$screen_size] = $html;
				}
			}
		}
		
		return $result;
	}
	
	
	public static function js_html_var($arr = array())
	{
		$js = '';
		if(!empty($arr))
		{	
			foreach($arr as $screen_size => $html)
			{
				$bhtml = preg_replace( "/\r|\n/", "", $html ); // remove line breaks
				$bhtml = str_replace("'", "\\'", $bhtml); // Add slashes to single qoutes
				
				$js.= $screen_size.': ';
				$js.= '\''.$bhtml.'\',';	
			}
		}
		
		return $js;
	}
	
	
	
	/**
	 * IS ENCODED
	 */
	public static function isEncoded($layer = array())
	{
		$encoded = 0;
		$encoded = $layer['data']['type'] == 'html' ? 1 : $encoded;
		$encoded = $layer['data']['type'] == 'svg' && $layer['v'] >= 522 ? 1 : $encoded;
		$encoded = $layer['data']['type'] == 'shape' && $layer['v'] >= 522 ? 1 : $encoded;
		//$encoded = $layer['data']['type'] == 'text' && $layer['v'] >= 522 ? 1 : $encoded;
		
		return $encoded;
	}
	
	
	
	/**
	 * Create banner layer HTML
	 *
	*/
	public static function banner_layer_html($layer = array())
	{
		$html = '';
		$zindex = $layer['zindex'];
		//echo '<pre>'.print_r($layer['css'], true).'</pre>';	
		// Container
		$encoded = self::isEncoded($layer);
		$enc = $encoded ? ' enc' : '';
		$custom_class = array_key_exists('custom_class', $layer['css']['item']) ? ' '.$layer['css']['item']['custom_class'] : '';
		
		$html.= '<div class="layer '.$layer['css']['layer']['pos_h'].' '.$layer['css']['layer']['pos_v'].' '.$layer['data']['type'].' '.$layer['ID'].$enc.$custom_class.'" data-itm="'.$layer['ID'].'" data-type="'.$layer['data']['type'].'" style="'.self::inline_css_style($layer['css']['layer']).' z-index:'.$zindex.';">';
		
			// Content
			$html.= self::banner_layer_content_html($layer);
			
		$html.= '</div>';
		
		return $html;	
	}
	
	
	
	
	/**
	 * Create banner layer content HTML
	 *
	*/
	public static function banner_layer_content_html($layer = array())
	{
		$html = '';
		$style = '';
		if( array_key_exists('data', $layer))
		{
			$object = array_key_exists('object', $layer['data']) ? $layer['data']['object'] : '';
			$item = array_key_exists('itm', $layer['data']) ? $layer['data']['itm'] : '';
			
			if( $object == 'image' )
			{
				$content = '<img src="'.$layer['data']['src'].'" />';
			}
			elseif( $object == 'text' )
			{
				$content = '<span class="itm_html Text_element enc" style="'.self::inline_css_style($layer['css']['item']).'">'.$layer['data']['code'].'</div>';
			}
			/*elseif( $object == 'shape' )
			{
				$content = '<div class="shape '.$layer['data']['itm'].'" style="'.self::inline_css_style($layer['css']['item']).'"></div>';	
			}*/
			elseif( $object == 'html' && $item == 'button' )
			{
				if( array_key_exists('class', $layer['data']['values']))
				{
					$class = $layer['data']['values']['class'];
					$custom = $layer['data']['values']['custom'];
					$btn = WPPAS_DEF::predefined_buttons(array('class' => $class));
					// Load button style
					$style.= '<style>';
						$style.= '.'.$layer['ID'].' .btn{';
							if($class != '')
							{
								foreach($btn['css']['default'] as $key => $val)
								{
									$style.= $key.':'.$val.';';
								}
							}
							foreach($custom['css']['default'] as $key => $val)
							{
								$style.= $key.':'.$val.';';
							}
						$style.= '}';
						$style.= '.'.$layer['ID'].' .btn:hover{';
							if($class != '')
							{
								foreach($btn['css']['hover'] as $key => $val)
								{
									$style.= $key.':'.$val.';';
								}
							}
							foreach($custom['css']['hover'] as $key => $val)
							{
								$style.= $key.':'.$val.';';
							}
						$style.= '}';
					$style.= '</style>';
				}
				
				$content = array_key_exists('code', $layer['data']) ? $layer['data']['code'].$style : '';
				//$content = array_key_exists('code', $layer['data']) ? '<div style="'.self::inline_css_style($layer['css']['item']).'">'.$layer['data']['code'].$style.'</div>' : '';
			}
			else
			{
				//$content = array_key_exists('code', $layer['data']) ? '<div style="'.self::inline_css_style($layer['css']['item']).'">'.$layer['data']['code'].'</div>' : '';
				$content = array_key_exists('code', $layer['data']) ? $layer['data']['code'] : '';
			}
			
			$html.= $content;
		}
		
		return $html;	
	}
	
	
	
	
	/**
	 * Create inline css style string from array
	 *
	*/
	public static function inline_css_style($layer = array())
	{
		$exclude = array('pos_v','pos_h','item-color','custom_class');
		$str = '';
		if( !empty($layer))
		{
			foreach($layer as $key => $css)
			{
				if( !in_array($key, $exclude) )
				{
					$str.= WPPAS_TPL::css_str(array('key' => $key, 'value' => $css));	
				}
			}
		}
		
		return $str;
	}
	
	
	
}
?>