<?php
class WPPAS_Activate {		
	
	
	public function __construct() 
	{
		
	}
	
	
	/*
	 * REMOTE POST handler
	 *
	 * @access public
	 * @return array
	*/
	public function remote_post($args = array())
	{
		global $wp_version;
		
		$defaults = array(
			'body' => array(),
			'url'  => 'http://community.tunasite.com/?plu-plugin=ajax-handler'
		);
		$args = wp_parse_args( $args, $defaults );
		
		$request = array(
			'body' => $args['body'],
			'user-agent' => 'WordPress/' . $wp_version . '; ' . get_bloginfo('url')
		);
		
		$response = wp_remote_post($args['url'], $request);
		$response_code = wp_remote_retrieve_response_code( $response );
		$response_body = wp_remote_retrieve_body( $response );
		//print_r($args['body']);
		// ERROR
		if ( $response_code != 200 || is_wp_error( $response ) ) 
		{
			return array('server_status' => 0, 'body' => $response);
		}
		// OK
		else
		{
			return array('server_status' => 1, 'body' => $response_body);
		}
	}
	
	
	
	/*
	 * REGISTER Plugin
	 *
	 * @access public
	 * @return array
	*/
	public function register($args = array())
	{
		global $pro_ads_multisite;
		
		$defaults = array(
			'action'       => 'register_v5', //'check',
			'license-key'  => '',
		);
		$args = wp_parse_args( $args, $defaults );
		$wppas_dev_mode = get_option('wppas_dev_mode', 0);
		
		$request_body = array(
			'body' => array(
				'action'      => $args['action'], 
				'envato_id'   => WP_ADS_ENVATO_ID,
				'item_slug'   => WP_ADS_PLUGIN_SLUG,
				'license-key' => $args['license-key'],
				'api-key'     => md5(get_bloginfo('url')),
				'url'         => get_bloginfo('url'),
				'email'       => get_bloginfo('admin_email')
			)
		);
		
		$response = $this->remote_post($request_body);
		echo $wppas_dev_mode ? '<pre>'.print_r($response,true).'</pre>' : '';
		
		// If plugin registered succesfully
		if( $response['server_status'] )
		{
			//echo $response['body'];
			$resp = json_decode($response['body']);
			
			if($resp->registered)
			{
				update_option( 'wpproads_license_key', $args['license-key'] );
				update_option( 'wppas_activation', array('verify' => $resp->verify, 'user_data' => $resp->user_data) );
				if( $pro_ads_multisite->pro_ads_plugin_is_network_activated() && is_main_site() )
				{
					update_site_option( 'wpproads_license_key', $args['license-key'] );
					update_site_option( 'wppas_activation', array('verify' => $resp->verify, 'user_data' => $resp->user_data) );
				}
			}
			else
			{
				update_option( 'wpproads_license_key', '' );
				update_option( 'wppas_activation', '' );
				if( $pro_ads_multisite->pro_ads_plugin_is_network_activated() && is_main_site() )
				{
					update_site_option( 'wpproads_license_key', '' );
					update_site_option( 'wppas_activation', '' );
				}
			}
			
			return $resp;
		}
		// In case of error.
		else
		{
			return array('msg' => __('Could not connect with server. Please try again in a few minutes.','wpproads'), 'error' => $response['body']);
		}
	}
	
	
	
	
	
	
	/*
	 * DE-REGISTER Plugin
	 *
	 * @access public
	 * @return array
	*/
	public function deregister($args = array())
	{
		global $pro_ads_multisite;
		
		$defaults = array(
			'action'       => 'unregister', //'check',
			'license-key'  => '',
		);
		$args = wp_parse_args( $args, $defaults );
		$wppas_dev_mode = get_option('wppas_dev_mode', 0);
		
		$request_body = array(
			'body' => array(
				'action'      => $args['action'], 
				'envato_id'   => WP_ADS_ENVATO_ID,
				'license-key' => $args['license-key']
			)
		);
		
		$response = $this->remote_post($request_body);
		echo $wppas_dev_mode ? '<pre>'.print_r($response,true).'</pre>' : '';
		
		if( $response['server_status'] )
		{
			update_option( 'wpproads_license_key', '' );
			update_option( 'wppas_activation', '' );
			if( $pro_ads_multisite->pro_ads_plugin_is_network_activated() && is_main_site() )
			{
				update_site_option( 'wpproads_license_key', '' );
				update_site_option( 'wppas_activation', '' );
			}
				
			return array('msg' => 'License code deactivated successfully.');
		}
		else
		{
			return array('msg' => __('Could not connect with server. Please try again in a few minutes.','wpproads'), 'error' => $response['body']);	
		}
	}
	
	
	
	
	
	
	
	
	/*
	 * CHECK SUPPORT STATUS
	 *
	 * statuses: 0 = inactive, 1 = active
	 * codes: inactive, active, expired
	 *
	 * @access public
	 * @return array
	*/
	public function check_support()
	{
		$status = 0;
		$code = 'inactive';
		$days = 0;
		$timestamp = '';
		$data = get_option( 'wppas_activation', '' );
		
		if( !empty($data) )
		{	
			$date = new DateTime($data['verify']->supported_until);
			$timestamp = strtotime($date->format('Y-m-d H:i:s'));
			
			if($timestamp > time())
			{
				$status = 1;
				$code = 'active';
				$datediff = $timestamp - time();
				$days = floor($datediff/(60*60*24));
			}
			else
			{
				$status = 0;
				$code = 'expired';	
			}
		}
		
		return array('status' => $status, 'code' => $code, 'time' => $timestamp, 'days' => $days);
	}
	
	
}
?>