<?php
/**
 * Prevent w3tc caching for banners.
 */
$wpproads_page_caching = get_option('wpproads_page_caching', 1);
if( !$wpproads_page_caching )
{
	!defined('DONOTCACHEPAGE') ? define('DONOTCACHEPAGE', true) : '';
}


class Pro_Ads_Shortcodes {	

	public function __construct() 
	{
		ob_start();
		add_shortcode('pro_ad_display_adzone', array($this, 'sc_display_adzone'));
		add_shortcode('pro_ad_display_banner', array($this, 'sc_display_banner'));
		add_shortcode('hide_post_ads', array($this, 'sc_hide_post_ads'));
		add_shortcode('wpproads_clearfix', array($this, 'wpproads_clearfix'));
		add_shortcode('wpproads', array($this, 'sc_wpproads'));
		add_shortcode('wpproads_banner', array($this, 'sc_wpproads_banner'));
		add_shortcode('wpproads_adzone', array($this, 'sc_wpproads_adzone'));
		add_shortcode('wpproads_buysell_form', array($this, 'sc_wpproads_buy_sell_form'));
		add_shortcode('wpproads_buysell_user_dashboard', array($this, 'sc_wpproads_buy_sell_user_dashboard'));
	}
	
	
	
	
	
	
	public function default_atts( $adzone_id = 1 )
	{
		global $pro_ads_responsive;
		
		$device = $pro_ads_responsive->get_device_type();
		
		// Shortcode options
		$defaults = array(
			'id'                 => $adzone_id,
			'screen'             => $device['prefix'],
			'class'              => '',
			'ajax_load'          => 0,
			'align'              => '',
			'fixed'              => '',
			'fixed_item'         => '',
			'fixed_till'         => '',
			//'fixed_cont'         => '',
			'border'             => '',
			'border_color'       => '',
			'padding'            => '',
			'background_color'   => '',
			'background_pattern' => '',
			'border_radius'      => '',
			'border'             => '',
			'border_color'       => '',
			'popup'              => 0,
			'exit_popup'         => 0,
			'popup_bg'           => '',
			'popup_opacity'      => '',
			'popup_close_btn'    => 1,
			'popup_auto_close_time' => 5,
			'delay'              => 0,
			'flyin'              => 0,
			'flyin_delay'        => 3,
			'flyin_position'     => 'bottom-right',
			'cookie'             => 0,
			'nobg'               => 0,
			'corner_curl'        => 0,
			'corner_small'       => 26,
			'corner_big'         => 100,
			'corner_animate'     => 1,
			'background'         => '',
			'container'          => '',
			'container_type'     => '',
			'repeat'             => '',
			'stretch'            => '',
			'bg_color'           => '',
			'info_text'          => '',
			'info_text_img'      => '',
			'info_text_url'      => '',
			'info_text_position' => 'above',
			'font_size'          => 11,
			'font_color'         => '#C0C0C0',
			'text_decoration'    => 'none',
			'hide_if_loggedin'   => 0,
			'rss'                => 0
		);	
		
		return apply_filters( 'wp_pro_ads_extend_shortcode_atts', $defaults );
	}
	
	
	
	
	/*
	 * Shortcode function for both banners and adzones - [wpproads id="1"]
	 * @since v5.1.7
	 *
	 * @access public
	 * @return array
	*/
	public function sc_wpproads( $atts, $content = null ) 
	{	
		global $wppas_banner_creator, $wppas_adzone_creator, $wppas_stats;
		//$atts = shortcode_atts( $this->default_atts(), $atts, 'wpproads_banner' );
		
		if( !empty($atts['id']))
		{
			wp_enqueue_script('WPPAS_POSRBE', WP_ADS_URL.'public/assets/js/vbc/postscribe.min.js', array('jquery'), WP_ADS_VERSION, true);
			wp_enqueue_style("WPPAS_VBC_BNR_STYLE", WP_ADS_URL."public/assets/css/vbc/wppas_vbc_bnr.css", false, WP_ADS_VERSION, "all");
			
			$post_type = get_post_type( $atts['id'] );
			$is_banner = $post_type == 'wppas_banners' ? 1 : 0;
			
			// If alterenative adzone ID
			if($post_type == 'adzones')
			{
				return do_shortcode('[pro_ad_display_adzone id="'.$atts['id'].'"]');
			}
			
			$options = array();
			$options['ID'] = $atts['id'];
			isset($atts['hide']) ? $options['hide'] = $atts['hide'] : '';
			
			// Check if banner/adzone has to be shown (based on campaign status and other user defined options)
			//$show = $is_banner ? $wppas_banner_creator->show_or_hide_banner( $atts['id'], $options ) : 1;
			$show = $wppas_banner_creator->show_or_hide_banner( $atts['id'], $options );
			//echo $atts['id'].' '.$show.'<br>';
			
			if( $show )
			{
				$load_delay = isset($atts['delay']) ? $atts['delay'] : 0;
				$hold = isset($atts['hold']) ? $atts['hold'] : 0;
				$rss = isset($atts['rss']) ? $atts['rss'] : 0;
				
				// Options array
				isset($atts['adzone']) ? $options['adzone'] = $atts['adzone'] : '';
				isset($atts['hide_empty']) ? $options['hide_empty'] = $atts['hide_empty'] : '';
				isset($atts['display']) ? $options['display'] = $atts['display'] : '';
				isset($atts['center']) ? $options['center'] = $atts['center'] : '';
				isset($atts['style']) ? $options['style'] = $atts['style'] : '';
				isset($atts['class']) ? $options['class'] = $atts['class'] : '';
				isset($atts['effect']) ? $options['effect'] = $atts['effect'] : '';
				isset($atts['margin']) ? $options['margin'] = $atts['margin'] : '';
				isset($atts['position']) ? $options['position'] = $atts['position'] : '';
				isset($atts['close_btn_position']) ? $options['close_btn_position'] = $atts['close_btn_position'] : '';
				isset($atts['buysell']) ? $options['buysell'] = $atts['buysell'] : '';
				isset($atts['bg']) ? $options['bg'] = $atts['bg'] : '';
				isset($atts['rss']) ? $options['rss'] = $atts['rss'] : '';
				isset($atts['text_wrap']) ? $options['text_wrap'] = $atts['text_wrap'] : '';
				isset($atts['info_text']) ? $options['info_text'] = $atts['info_text'] : '';
				isset($atts['inft_pos']) ? $options['inft_pos'] = $atts['inft_pos'] : '';
				isset($atts['inft_font_size']) ? $options['inft_font_size'] = $atts['inft_font_size'] : '';
				isset($atts['inft_padding']) ? $options['inft_padding'] = $atts['inft_padding'] : '';
				isset($atts['inft_cont_bg']) ? $options['inft_cont_bg'] = $atts['inft_cont_bg'] : '';
				
				// Triggers
				isset($atts['trigger']) ? $options['trigger'] = $atts['trigger'] : '';
				isset($atts['delay']) ? $options['delay'] = $atts['delay'] : '';
				isset($atts['scroll_pos']) ? $options['scroll_pos'] = $atts['scroll_pos'] : '';
				isset($atts['inactive_sec']) ? $options['inactive_sec'] = $atts['inactive_sec'] : '';
				
				// VC
				isset($atts['wppas_css_vc_design']) ? $options['vc_design'] = $atts['wppas_css_vc_design'] : '';
				isset($atts['wppas_css_vc_design']) ? $options['vc_class'] = vc_shortcode_custom_css_class($atts['wppas_css_vc_design']) : '';
				
				if( $is_banner )
				{
					//$banner_data = $wppas_banner_creator->load_banner_data($atts['id']);
					$banner = $wppas_banner_creator->load_banner(array(
						'bid' => $atts['id'], 
						'options' => $options,
						'load_delay' => $load_delay,
						'hold' => $hold,
						'do_stats' => 1
					));
					
					return $banner;
				}
				else
				{
					//$data = $wppas_adzone_creator->load_adzone_data($atts['id']);
					$adzone = $wppas_adzone_creator->show_adzone(array(
						'aid' => $atts['id'],
						'options' => $options,
					));	
					
					return $adzone;
				}

			}
		}
	}
	
	
	
	
	
	/*
	 * Shortcode function - [wpproads_banner id="1"]
	 *
	 * @access public
	 * @return array
	*/
	public function sc_wpproads_banner( $atts, $content = null ) 
	{	
		global $wppas_banner_creator, $wppas_stats;
		
		//$atts = shortcode_atts( $this->default_atts(), $atts, 'wpproads_banner' );
		
		if( !empty($atts['id']))
		{
			$options = array();
			$options['ID'] = $atts['id'];
			isset($atts['hide']) ? $options['hide'] = $atts['hide'] : '';
			
			// Check if banner has to be shown (based on campaign status and other user defined options)
			$show = $wppas_banner_creator->show_or_hide_banner( $atts['id'], $options );
			
			if( $show )
			{
				//$options = isset($atts['options']) ? json_decode(urldecode('['.$atts['options'].']'),true) : array();
				$load_delay = isset($atts['delay']) ? $atts['delay'] : 0;
				//$hold = isset($atts['hold']) ? $atts['hold'] : 0;
				
				// Options array
				isset($atts['adzone']) ? $options['adzone'] = $atts['adzone'] : '';
				isset($atts['display']) ? $options['display'] = $atts['display'] : '';
				isset($atts['center']) ? $options['center'] = $atts['center'] : '';
				isset($atts['effect']) ? $options['effect'] = $atts['effect'] : '';
				isset($atts['margin']) ? $options['margin'] = $atts['margin'] : '';
				isset($atts['position']) ? $options['position'] = $atts['position'] : '';
				isset($atts['close_btn_position']) ? $options['close_btn_position'] = $atts['close_btn_position'] : '';
				isset($atts['buysell']) ? $options['buysell'] = $atts['buysell'] : '';
				isset($atts['bg']) ? $options['bg'] = $atts['bg'] : '';
				isset($atts['info_text']) ? $options['info_text'] = $atts['info_text'] : '';
				
				// Triggers
				isset($atts['trigger']) ? $options['trigger'] = $atts['trigger'] : '';
				isset($atts['delay']) ? $options['delay'] = $atts['delay'] : '';
				isset($atts['scroll_pos']) ? $options['scroll_pos'] = $atts['scroll_pos'] : '';
				isset($atts['inactive_sec']) ? $options['inactive_sec'] = $atts['inactive_sec'] : '';
				
				
				$banner_data = $wppas_banner_creator->load_banner_data($atts['id']);
				$banner = $wppas_banner_creator->load_banner(array(
					'bid' => $atts['id'], 
					'options' => $options,
					'load_delay' => $load_delay
				));
				
				// Save Impressions.
				$wppas_stats->save_stats(array(
					'type'          => 'impressions',
					'banner_id'     => $atts['id'],
					'advertiser_id' => !empty($banner_data['banner_data'][0]['advertiser']) ? $banner_data['banner_data'][0]['advertiser'] : 0,
					'campaign_id'   => !empty($banner_data['banner_data'][0]['campaign']) ? $banner_data['banner_data'][0]['campaign'] : 0,
					'adzone_id'     => 0
				));
				
				return $banner;
			}
		}
	}
	
	
	
	
	/*
	 * Shortcode function - [wpproads_adzone id="1"]
	 *
	 * @access public
	 * @return array
	*/
	public function sc_wpproads_adzone( $atts, $content = null ) 
	{	
		global $wppas_adzone_creator, $wppas_stats;
		
		$atts = shortcode_atts( $this->default_atts(), $atts, 'wpproads_adzone' );
		
		if( !empty($atts['id']))
		{
			// Check if banner has to be shown (based on campaign status and other user defined options)
			//$show = $wppas_banner_creator->show_or_hide_banner( $atts['id'] );
			$show = 1;
			
			if( $show )
			{
				$data = $wppas_adzone_creator->load_adzone_data($atts['id']);
				$adzone = $wppas_adzone_creator->show_adzone(array(
					'aid' => $atts['id']
				));
				
				return $adzone;
			}
		}
	}
	
	
	
	
	/*
	 * Shortcode function - [pro_ad_display_adzone id="1" popup="0"]
	 *
	 * @access public
	 * @return array
	*/
	public function sc_display_adzone( $atts, $content = null ) 
	{	
		global $pro_ads_codex, $pro_ads_templates, $pro_ads_adzones, $pro_ads_responsive, $pro_ads_multisite;
		
		
		//$atts = wp_parse_args($atts, $this->default_atts());
		$atts = shortcode_atts( $this->default_atts(), $atts, 'pro_ad_display_adzone' );
		extract($atts);
		
		
		/***
		 * Multisite ___________________________________________________________________ */
		$pro_ads_multisite->wpproads_wpmu_load_from_main_start();
		
		wp_enqueue_style( 'wp_pro_add_style' );
		wp_enqueue_style( 'wppas_php_style' );
		
		// Check if cookies script needs to be loaded.
		if( esc_attr($cookie) )
		{
			wp_enqueue_script( 'wppas_jquery_cookie' );
		}
		wp_enqueue_script( 'wp_pro_add_js_functions' );
		
		
		if( !empty($fixed_cont))
		{
			wp_enqueue_script( 'wp_pro_add_scrolltofixed' );
		}
		
		// Check if adzone is popup
		if( esc_attr($popup) )
		{
			if( $pro_ads_codex->wpproads_adzone_is_grid( $id ) )
			{
				// popup grid
				$adzone = $pro_ads_templates->pro_ad_popup_screen( 
					array(
						'html' => $pro_ads_adzones->display_adzone_grid( esc_attr($id), $atts ), 
						'adzone_id' => $id,
						'exit_popup' => $exit_popup,
						'popup_bg'  => $popup_bg,
						'popup_opacity' => $popup_opacity,
						'popup_close_btn' => $popup_close_btn,
						'popup_auto_close_time' => $popup_auto_close_time,
						'atts' => $atts
					) 
				);
			}
			else
			{
				// popup banner
				wp_enqueue_style( 'wppas_font_awesome_style');
				$adzone_arr = $pro_ads_adzones->display_adzone( esc_attr($id), $atts );
				$adzone = $pro_ads_templates->pro_ad_popup_screen( 
					array(
						'html' => $adzone_arr['html'],
						'active_banners' => $adzone_arr['active_banners'],
						'adzone_id' => $id,
						'exit_popup' => $exit_popup,
						'popup_bg'  => $popup_bg,
						'popup_opacity' => $popup_opacity,
						'popup_close_btn' => $popup_close_btn,
						'popup_auto_close_time' => $popup_auto_close_time,
						'atts' => $atts
					) 
				);
				//print_r($atts);
			}
		}
		// Check if adzone is fly in
		elseif( esc_attr($flyin) )
		{
			if( $pro_ads_codex->wpproads_adzone_is_grid( $id ) )
			{
				// fly in grid
				$adzone = $pro_ads_templates->pro_ad_fly_in( 
					array(
						'html' => $pro_ads_adzones->display_adzone_grid( esc_attr($id), $atts ), 
						'adzone_id' => $id,
						'delay' => $flyin_delay,
						'position' => $flyin_position,
						'atts' => $atts
					) 
				);
			}
			else
			{
				// fly in banner
				$adzone_arr = $pro_ads_adzones->display_adzone( esc_attr($id), $atts );
				$adzone = $pro_ads_templates->pro_ad_fly_in( 
					array(
						'html' => $adzone_arr['html'], 
						'adzone_id' => $id,
						'delay' => $flyin_delay,
						'position' => $flyin_position,
						'atts' => $atts
					) 
				);
			}
		}
		// Check if adzone is background ad
		elseif( esc_attr($background) )
		{
			$adzone = $pro_ads_adzones->display_adzone_as_background( $atts );
		}
		// Check if adzone is corner peeler
		elseif( esc_attr($corner_curl) )
		{
			$adzone = $pro_ads_adzones->display_adzone_as_corner_curl( $atts );
		}
		// Normal adzone
		else
		{
			if( $pro_ads_codex->wpproads_adzone_is_grid( $id ) )
			{
				// ad grid
				$adzone = $pro_ads_adzones->display_adzone_grid( esc_attr($id), $atts );
			}
			else
			{
				// normal
				$adzone_arr = $pro_ads_adzones->display_adzone( esc_attr($id), $atts );
				$adzone = $adzone_arr['html'];
			}
		}
		
		//restore_current_blog();	
		
		/***
		 * Multisite ___________________________________________________________________ */
		$pro_ads_multisite->wpproads_wpmu_load_from_main_stop();
		
		return $adzone;
	}
	
	
	
	
	
	
	
	/*
	 * Shortcode function - [pro_ad_display_banner id=""]
	 *
	 * @access public
	 * @return null
	*/
	public function sc_display_banner( $atts, $content = null )
	{
		global $pro_ads_banners, $pro_ads_multisite;
		
		/***
		 * Multisite ___________________________________________________________________ */
		$pro_ads_multisite->wpproads_wpmu_load_from_main_start();
	
		//wp_enqueue_style("wp_pro_add_style", WP_ADS_TPL_URL."/css/wpproadds.min.css", false, WP_ADS_VERSION, "all");
		wp_enqueue_style( 'wp_pro_add_style' );	
		extract( shortcode_atts( array(
			'id'        => 1,
			'aid'       => 0,
			'container' => 1
		), $atts ) );
		
		$single_banner = $pro_ads_banners->get_banner_item( array('id' => $id, 'aid' => $aid, 'container' => $container) );
		
		/***
		 * Multisite ___________________________________________________________________ */
		$pro_ads_multisite->wpproads_wpmu_load_from_main_stop();
		
		return $single_banner;
	}
	
	
	
	
	
	
	/*
	 * Shortcode function - [sc_hide_post_ads]
	 *
	 * @access public
	 * @return null
	*/
	public function sc_hide_post_ads()
	{
		return '';
	}
	
	
	
	
	/*
	 * Shortcode function - [wpproads_clearfix]
	 *
	 * @access public
	 * @return null
	*/
	public function wpproads_clearfix( $atts, $content = null )
	{
		extract( shortcode_atts( array(
			'id'        => '',
			'class'     => 'clearFix',
			'style'     => ''
		), $atts ) );
		
		$style = !empty($style) ? ' '.$style : $style;
		
		return '<div '.$id.' '.$class.' style="clear:both;'.$style.'"></div>';
	}
	
	
	
	
	/*
	 * Shortcode function - [wpproads_buysell_form]
	 *
	 * @access public
	 * @return null
	*/
	public function sc_wpproads_buy_sell_form( $atts, $content = null )
	{
		wp_enqueue_script('jquery-ui-core');
		wp_enqueue_script('jquery-effects-core');
		wp_enqueue_script("jquery-effects-shake");
		wp_enqueue_script('jquery-ui-sortable');
		wp_enqueue_script('jquery-ui-draggable');
		wp_enqueue_script('jquery-ui-droppable');
		wp_enqueue_script('jquery-ui-resizable');
		wp_enqueue_style( 'wp_pro_ad_UI_style');
		// Color picker
		wp_enqueue_style( 'wp-color-picker' );
		wp_enqueue_style('WPPAS_VBC_EDITR_STYLE');
		wp_enqueue_style( 'wp_pro_add_style');
		wp_enqueue_script(
			'iris',
			admin_url( 'js/iris.min.js' ),
			array( 'jquery-ui-draggable', 'jquery-ui-slider', 'jquery-touch-punch' ),
			false,
			1
		);
		wp_enqueue_script(
			'wp-color-picker',
			admin_url( 'js/color-picker.min.js' ),
			array( 'iris' ),
			false,
			1
		);
		$colorpicker_l10n = array(
			'clear' => __( 'Clear' ),
			'defaultString' => __( 'Default' ),
			'pick' => __( 'Select Color' ),
			'current' => __( 'Current Color' ),
		);
		wp_localize_script( 'wp-color-picker', 'wpColorPickerL10n', $colorpicker_l10n );
		// end color picker
		
		wp_enqueue_script('WPPAS_VBC_EDITR');
		wp_enqueue_script('WPPAS_VBC_BS');
		
		wp_enqueue_script('wp_pro_ads_ace');
		wp_enqueue_script('wp_pro_ads_js_switch_button');
		wp_enqueue_style( 'chosen_style');
		wp_enqueue_script( 'chosen');
		wp_enqueue_style( 'wppas_font_awesome_style');
		
		
		return WPPAS_BuySell::order_form($atts);
	}
	
	
	
	/*
	 * Shortcode function - [wpproads_buysell_user_dashboard]
	 *
	 * @access public
	 * @return null
	*/
	public function sc_wpproads_buy_sell_user_dashboard($atts, $content = null)
	{
		wp_enqueue_script('jquery-ui-core');
		wp_enqueue_script('jquery-effects-core');
		wp_enqueue_script("jquery-effects-shake");
		wp_enqueue_script('jquery-ui-sortable');
		wp_enqueue_script('jquery-ui-draggable');
		wp_enqueue_script('jquery-ui-droppable');
		wp_enqueue_script('jquery-ui-resizable');
		wp_enqueue_style( 'wp_pro_ad_UI_style');
		// Color picker
		wp_enqueue_style( 'wp-color-picker' );
		wp_enqueue_style('WPPAS_VBC_EDITR_STYLE');
		wp_enqueue_style( 'wp_pro_add_style');
		wp_enqueue_script(
			'iris',
			admin_url( 'js/iris.min.js' ),
			array( 'jquery-ui-draggable', 'jquery-ui-slider', 'jquery-touch-punch' ),
			false,
			1
		);
		wp_enqueue_script(
			'wp-color-picker',
			admin_url( 'js/color-picker.min.js' ),
			array( 'iris' ),
			false,
			1
		);
		$colorpicker_l10n = array(
			'clear' => __( 'Clear' ),
			'defaultString' => __( 'Default' ),
			'pick' => __( 'Select Color' ),
			'current' => __( 'Current Color' ),
		);
		wp_localize_script( 'wp-color-picker', 'wpColorPickerL10n', $colorpicker_l10n );
		// end color picker
		
		wp_enqueue_script('WPPAS_VBC_EDITR');
		wp_enqueue_script('WPPAS_VBC_BS');
		
		wp_enqueue_script('wp_pro_ads_ace');
		wp_enqueue_script('wp_pro_ads_js_switch_button');
		wp_enqueue_style( 'chosen_style');
		wp_enqueue_script( 'chosen');
		wp_enqueue_style( 'wppas_font_awesome_style');
		
		return WPPAS_BuySell::user_dashboard();
	}
}
?>