<?php
class Pro_Ads_Banner_Creator {	

	public function __construct() 
	{
		// Actions --------------------------------------------------------
		add_action('init', array( $this, 'init_method') );
		add_action('admin_menu', array( $this,'admin_actions') );
		add_action( 'add_meta_boxes', array($this, 'bc_meta_options'));
		add_action( 'save_post', array($this, 'pro_ads_bc_meta_options_save_postdata' ));
	}
	
	
	
	
	
	/*
	 * Init actions
	 *
	 * @access public
	 * @return null
	*/
	public function init_method() 
	{
		wp_enqueue_script('jquery-ui-sortable');
		wp_enqueue_script('pro_ads_bc_fabric', WP_ADS_TPL_URL . '/js/fabric.min.js');
		wp_enqueue_style("pro_ads_bc_style", WP_ADS_TPL_URL."/css/banner_creator.css", false, WP_ADS_VERSION, "all");
	}
	
	
	
	
	
	
	/*
	 * Show image editor
	 *
	 * @access public
	 * @return array
	*/
	public function show_banner_creator( $frontend = 0 )
	{
		global $wpdb, $post;
		
		$banner_bc_data_uri        = get_post_meta( $post->ID, '_banner_bc_data_uri', true );
		$banner_bc_json            = base64_decode(get_post_meta( $post->ID, '_banner_bc_json', true ));
		?>
        <div class="pro_ads_banner_creator" style="float:left;">
            <div id="bc_canvas_holder">
                <canvas id="bcCanvas" width="300" height="250"><?php _e('Canvas not suported','wpproads'); ?></canvas>
            </div>
            
            <div id="button_tools_cont" style="margin:10px 0 20px 0;"> 
                <a class="button-secondary" id="clear_bc"><?php _e('Clear','wpproads'); ?></a>
                <a class="button-secondary" id="preview_bc" title="<?php _e('Preview Banner','wpproads'); ?>"><i class="fa fa-search"></i></a>
                <a class="button-primary" id="save_bc" title="<?php _e('Save Banner','wpproads'); ?>" style="display:none;"><i class="fa fa-save"></i></a>
                <a class="button-primary" id="export_bc" style="display:none;"><?php _e('Export Banner (.PNG)','wpproads'); ?></a>
            </div>   
            <div id="button_tools_cont" style="margin:10px 0 20px 0;">
                
            </div>    
           
            <ul id="log"></ul>
            
            <input type="hidden" id="banner_data_uri" name="banner_data_uri" value="<?php echo $banner_bc_data_uri; ?>" />
            <textarea style="display:none;" id="banner_json" name="banner_json"><?php echo $banner_bc_json; ?></textarea>
        </div>
        
        <div class="sidebar" style="float:right; width:300px; margin:0 0 0 20px;">
            
            
            <div id="widgets-right" class="pro_ads_banner_creator">
            
                <div>
                    <div id="sidebar" >
                        <div class="sidebar-name" style="background:#FFF;">
                            <div class="sidebar-name-arrow"></div>
                            <h3><?php _e('Banner Size','wpproads'); ?></h3>
                        </div>
                        <div class="sidebar-description canvas_sidebar" style="padding:10px; background:#EFEFEF; border: solid 1px #E5E5E5;">
                            <div style="padding:5px;">
                                <select id="banner_size" name="banner_size">
                                    <option value=""><?php _e('-- Select your banner size --','wpproads'); ?></option>
                                    <option value="468x60">
                                        IAB Full Banner (468 x 60)
                                    </option>
                                    <option value="120x600">
                                        IAB Skyscraper (120 x 600)
                                    </option>
                                    <option value="728x90">
                                        IAB Leaderboard (728 x 90)
                                    </option>
                                    <option value="300x250" selected="selected">
                                        IAB Medium Rectangle (300 x 250)
                                    </option>
                                    <option value="120x90">
                                        IAB Button 1 (120 x 90)
                                    </option>
                                    <option value="160x600">
                                        IAB Wide Skyscraper (160 x 600)
                                    </option>
                                    <option value="120x60">
                                        IAB Button 2 (120 x 60)
                                    </option>
                                    <option value="125x125">
                                        IAB Square Button (125 x 125)
                                    </option>
                                    <option value="180x150">
                                        IAB Rectangle (180 x 150)
                                    </option>
                                    <option value="custom">
                                        <?php _e('Custom','wpproads'); ?>
                                    </option>
                                </select>
                            </div>
                            <hr />
                            <div id="custom_size" style="padding:5px; display:none;">
                                <?php _e('Width:','wpproads'); ?>&nbsp; <input type="number" value="300" id="canvas_width" />px.
                                <?php _e('Height:','wpproads'); ?> <input type="number" value="250" id="canvas_height" />px.
                            </div>
                            <div style="padding:5px;"><a class="button-secondary" id="update_canvas"><?php _e('Update','wpproads'); ?></a></div>
                        </div>
                    </div>
                </div>
                
                <div>
                    <div id="sidebar" >
                        <div class="sidebar-name" style="background:#FFF;">
                            <div class="sidebar-name-arrow"></div>
                            <h3><?php _e('+ Edit Elements','wpproads'); ?></h3>
                        </div>
                        <div class="sidebar-description" style="padding:10px; background:#EFEFEF; border: solid 1px #E5E5E5; display:none;">
                            <small><?php _e('Edit the current selected element.','wpproads'); ?></small>
                            
                            <div style="padding:5px;">
                            	<a class="button-secondary bc_remove_selected_element" title="<?php _e('Remove selected item','wpproads'); ?>"><i class="fa fa-trash"></i></a>
                                <a class="button-secondary bc_bring_to_front_selected_element" title="<?php _e('Move Up','wpproads'); ?>"><i class="fa fa-long-arrow-up"></i></a>
                                <a class="button-secondary bc_send_to_back_selected_element" title="<?php _e('Move Down','wpproads'); ?>"><i class="fa fa-long-arrow-down"></i></a>
                            </div>
                            <div style="padding:5px;"><input type="text" id="update_object_bg_color" value="" class="imge-color-field" /></div>
                            <div style="padding:5px;"><a class="button-primary" id="update_element"><?php _e('Update Element','wpproads'); ?></a></div>
                        </div>
                    </div>
                </div>
                
                <div>
                    <div id="sidebar" >
                        <div class="sidebar-name" style="background:#FFF;">
                            <div class="sidebar-name-arrow"></div>
                            <h3><?php _e('+ Add Image','wpproads'); ?></h3>
                        </div>
                        <div class="sidebar-description" style="padding:10px; background:#EFEFEF; border: solid 1px #E5E5E5; display:none;">
                            <div id="img_loader_cont" style="display:none;"><!--<img style="display:none;" id="image_loader" src="" />--></div>
                        
                            <div style="padding:5px;">
                                <a class="button-secondary" id="select_image_url"><?php _e('Select Image','wpproads'); ?></a>
                                <span id="img_url" style="font-size:11px;"></span>
                                <input type="hidden" id="image_url" readonly="readonly" />
                            </div>
                            
                            <div style="padding:5px;"><input type="number" min=".1" max="1" step=".1" id="image_opacity" value="1" /> <?php _e('Opacity','wpproads'); ?></div>
                            <div style="padding:5px;"><a class="button-primary "id="add_image"><?php _e('Add Image','wpproads'); ?></a></div>
                        </div>
                    </div>
                </div>
                
                <div>
                    <div id="sidebar" >
                        <div class="sidebar-name" style="background:#FFF;">
                            <div class="sidebar-name-arrow"></div>
                            <h3><?php _e('+ Add Object','wpproads'); ?></h3>
                        </div>
                        <div class="sidebar-description" style="padding:10px; background:#EFEFEF; border: solid 1px #E5E5E5; display:none;">
                            <div style="padding:5px;">
                                <select id="object_type">
                                    <option value="circle"><?php _e('Circle','wpproads'); ?></option>
                                    <option value="rectangle"><?php _e('Rectangle','wpproads'); ?></option>
                                    <option value="triangle"><?php _e('Triangle','wpproads'); ?></option>
                                </select>
                            </div>
                            <div style="padding:5px;"><input type="text" id="object_bg_color" value="" class="imge-color-field" /></div>
                            <div style="padding:5px;"><input type="number" min=".1" max="1" step=".1" id="object_opacity" value="1" /> <?php _e('Opacity','wpproads'); ?></div>
                            <div style="padding:5px;"><a class="button-primary "id="add_object"><?php _e('Add Object','wpproads'); ?></a></div>
                        </div>
                    </div>
                </div>
                
                <div>
                    <div id="sidebar" >
                        <div class="sidebar-name" style="background:#FFF;">
                            <div class="sidebar-name-arrow"></div>
                            <h3><?php _e('+ Add Text','wpproads'); ?></h3>
                        </div>
                        <div class="sidebar-description" style="padding:10px; background:#EFEFEF; border: solid 1px #E5E5E5; display:none; position:relative;">
                            <div style="padding:5px;"><textarea id="text_ipt" placeholder="<?php _e('Text','wpproads'); ?>"></textarea></div>
                            <div style="padding:5px;"><input type="text" id="text_color" value="" class="imge-color-field" /> <?php _e('Font Color','wpproads'); ?></div> 
                            <div style="padding:5px;"><input type="text" id="text_border_color" value="" class="imge-color-field" /> <?php _e('Border Color','wpproads'); ?></div>
                            <div style="padding:5px;"><input type="number" min=".1" max="1" step=".1" id="font_opacity" value="1" /> <?php _e('Opacity','wpproads'); ?></div>
                            <div style="padding:5px; height:45px; position:relative; margin: 4px;">
                                <select id="font_name_select" style="position:absolute; left:0; top:0; width:100%;">
                                    <option value="Verdana"></option>
                                    <option value="Verdana">Verdana</option>
                                    <option value="Arial"><?php _e('Arial','wpproads'); ?></option>
                                    <option value="Impact"><?php _e('Impact','wpproads'); ?></option>
                                </select>
                                <input id="font_name" type="text" name="" value="" style="position: absolute; width: 90%; margin: 2px; left:0; top:0; border:none;">
                                <span class="description" style="position:absolute; margin-top: 25px;"><?php echo sprintf( __( 'You can add any %s.', 'wpproads'), '<a href="http://www.google.com/fonts" target="_blank">Google Font</a>'); ?></span>
                                <script type="text/javascript">
                                jQuery(document).ready(function($){
                                    var $input = jQuery('#font_name');
                                    var $select = jQuery('#font_name_select');
                                     
                                    $select.change(function(){
                                        modify();
                                    })
                                     
                                    function modify(){
                                        
                                        $input.val($select.val());
                                        //output();
                                    }
                                     
                                    function output(){
                                        jQuery('p').text('value: ' + $input.val());
                                    }
                                     
                                    $input.on('click', function(){
                                        jQuery(this).select()
                                    }).on('blur', function(){
                                     //output();
                                    })
                                     
                                    modify();
                                });
                                </script>
                            </div>
                            <div style="padding:5px;"><input type="number" id="font_size" placeholder="<?php _e('Font Size','wpproads'); ?>" /></div>
                            <div style="padding:5px;"><input type="number" id="font_border_width" placeholder="<?php _e('Border Width','wpproads'); ?>" /></div>
                            <div style="padding:5px;"><a class="button-primary "id="add_text"><?php _e('Add Text','wpproads'); ?></a></div>
                        </div>
                    </div>
                </div>
                
            </div>
            
        
            
        </div>
        <!-- end .sidebar -->
        
        <div class="clearFix"></div>
        
        <script type="text/javascript">
        var canvas = this.__canvas = new fabric.Canvas('bcCanvas');
        var my_object = {};
        
        jQuery(document).ready(function($){
			
			
			/*
			 * IMPORT BANNER ELEMENTS
			*/
			var json_import = <?php echo $banner_bc_json; ?>;
		
			if( json_import != '' )
			{
				$.each(json_import.objects, function(arrayID,group) {
					
					if(group.type == 'circle'){
						
						var layerID = get_layer_id('circle', group.radius);
						var type = 'circle';
						my_object[layerID] = new fabric.Circle({ 
							id: layerID,
							radius: group.radius,
							originX: group.originX,
							originY: group.originY, 
							scaleX: group.scaleX,
							scaleY: group.scaleY,
							fill: group.fill, 
							left: group.left, 
							top: group.top,
							opacity: group.opacity,
							transparentCorners: false
						});
					}
					else if( group.type == 'rect'){
						
						var layerID = get_layer_id('rectangle', '');
						var type = 'rectangle';
						my_object[layerID] = new fabric.Rect({
							id: layerID,
							left: group.left,
							top: group.top,
							originX: group.originX,
							originY: group.originY,
							scaleX: group.scaleX,
							scaleY: group.scaleY,
							width: group.width,
							height: group.height,
							angle: group.angle,
							fill: group.fill,
							opacity: group.opacity,
							transparentCorners: false
						});	
						
					}else if( group.type == 'triangle'){
						var layerID = get_layer_id('triangle', '');
						var type = 'triangle';
						my_object[layerID] = new fabric.Triangle({
							id: layerID,
							left: group.left,
							top: group.top,
							originX: group.originX,
							originY: group.originY,
							scaleX: group.scaleX,
							scaleY: group.scaleY,
							width: group.width,
							height: group.height,
							angle: group.angle,
							fill: group.fill,
							opacity: group.opacity,
							transparentCorners: false
						});	
					}
					
					canvas.add(my_object[layerID]);
					
					if( group.type == 'circle' || group.type == 'rect' || group.type == 'triangle' ){
						var type_icon = get_type_icon( type );
						edit_layer_btn(layerID, '<i class="fa fa-'+type_icon+'" style="color:'+group.fill+'; opacity:'+group.opacity+';"></i>');
					}
				});
				
				//canvas.loadFromJSON($('#banner_json').val(),canvas.renderAll.bind(canvas));
				//canvas.renderAll();
			}
			// END IMPORT
			
			
            
            // Banner Size
            var val;
            var arr;
            
            $('#banner_size').change(function(){

                val = $(this).val();
                
                if( val == 'custom')
                {
                    $('#custom_size').show();
                }
                else
                {
                    $('#custom_size').hide();
                    arr = val.split('x');
                }
            });
            
            $('#update_canvas').click(function(){
                
                if( val == 'custom' || arr[0] == '')
                {
                    var width = $('#canvas_width').val();
                    var height = $('#canvas_height').val();
                }
                else
                {
                    var width = arr[0];
                    var height = arr[1];
                }
                canvas.setHeight(height);
                canvas.setWidth(width);
            });
        
			
			
			
			
			/*
			 * UPDATE SELECTED ELEMENTS 
			*/
            $('.bc_remove_selected_element').click(function(){
				var activeObject = canvas.getActiveObject();
                if (activeObject) {
					canvas.remove(activeObject);
				}else{
                    alert('<?php _e('No element selected.','wpproads'); ?>')	
                }
			});
			$('.bc_bring_to_front_selected_element').click(function(){
				var activeObject = canvas.getActiveObject();
				if (activeObject) {
					
				  canvas.bringToFront(activeObject);
				}
			});
			$('.bc_send_to_back_selected_element').click(function(){
				var activeObject = canvas.getActiveObject();
				if (activeObject) {
				  canvas.sendToBack(activeObject);
				}
			});
			
            $('#update_element').click(function(){
                var activeObject = canvas.getActiveObject();
                if (activeObject) {
					var item_id = activeObject.get('id');
					type_icon = type_icon == 'rect' ? 'rectangle' : type_icon;
                    var color = $('#update_object_bg_color').val();
					var type_icon = get_type_icon( activeObject.get('type') );
                
                    activeObject.set('fill', color);
                    canvas.renderAll();
					
					$('.bc_preview_icon_'+item_id).html('<i class="fa fa-'+type_icon+'" style="color:'+color+';"></i>'); // opacity:'+opacity+';
                }else{
                    alert('<?php _e('No element selected.','wpproads'); ?>')	
                }
            });
			
			
			
			
            
        
            $('#add_image').click(function(){
                
                var scale = 1;
                var layerID = get_layer_id('image');
                var image = $('#image_url').val();
                var opacity = $('#image_opacity').val() != '' ? $('#image_opacity').val() : 1;
                //$('#image_loader').attr('src', image);
                $('#img_loader_cont').append('<img id="image_loader_'+layerID+'" src="'+image+'" />');
                // source: $('#image_loader_'+layerID)[0],
                
                fabric.Image.fromURL(image, function( oimg ) {
                    my_object[layerID] = oimg;
                    my_object[layerID].set({
						id: layerID,
                        opacity: opacity,
						transparentCorners: false
                    })
                    .scale(scale)
                    .setCoords();
                    canvas.add( my_object[layerID] );
                });
                
                edit_layer_btn(layerID, '<img src="'+image+'" width="10" style="opacity:'+opacity+';" />', scale);
                $('#image_url').val('');
                $('#img_url').html('');
            });
        
            $('#add_text').click(function(){
                
                var text = $('#text_ipt').val();
                if( text != '' ){
                    var color = $('#text_color').val() != '' ? $('#text_color').val() : '#9cf';
                    var stroke_color = $('#text_border_color').val() != '' ? $('#text_border_color').val() : 'transparent';
                    var stroke_width = $('#font_border_width').val() != '' ? $('#font_border_width').val() : 1;
                    var font = $('#font_name').val() != '' ? $('#font_name').val() : 'Verdana, sans-serif';
                    var opacity = $('#font_opacity').val() != '' ? $('#font_opacity').val() : 1;
                    
                    addGoogleFont(font); // for example
                    var font_size = $('#font_size').val() != '' ? $('#font_size').val() : 48;
                    var layerID = get_layer_id( 'text' );
                    
                    
                    my_object[layerID] = new fabric.IText(text, {
						id: layerID,
                        left: 50,
                        top: 50,
                        fontFamily: font,
                        fontSize: font_size,
                        strokeWidth: stroke_width,
                        stroke: stroke_color,
                        //angle: getRandomInt(-10, 10),
                        fill: color,
                        opacity: opacity,
                        //scaleX: 0.5,
                        //scaleY: 0.5,
                        fontWeight: '',
                        originX: 'left',
                        hasRotatingPoint: true,
                        centerTransform: true,
						transparentCorners: false
                    });
                    canvas.add(my_object[layerID]);
                    canvas.renderAll();
                    
                    var stroke_css = stroke_color != '' ? 'text-shadow: -1px 0 '+stroke_color+', 0 1px '+stroke_color+', 1px 0 '+stroke_color+', 0 -1px '+stroke_color+';' : '';
                    edit_layer_btn(layerID, '<strong style="font-family:'+font+'; color:'+color+'; opacity:'+opacity+'; '+stroke_css+'">'+text+'</strong');
                }
            });
                
            $('#add_object').click(function(){
                
                var type = $('#object_type').val();
                var color = $('#object_bg_color').val() != '' ? $('#object_bg_color').val() : '#000';
                var opacity = $('#object_opacity').val() != '' ? $('#object_opacity').val() : 1;
                
                if( type == 'circle') {
                    
                    var radius = 50;
                    var layerID = get_layer_id('circle', radius);
                    
                    my_object[layerID] = new fabric.Circle({ 
						id: layerID,
                        radius: radius, 
                        fill: color, 
                        left: 20, 
                        top: 20,
                        opacity: opacity,
                        transparentCorners: false
                    });
                }
                else if( type == 'rectangle') {
                    
                    var layerID = get_layer_id('rectangle', '');
                    
                    my_object[layerID] = new fabric.Rect({
						id: layerID,
                        left: 20,
                        top: 20,
                        originX: 'left',
                        originY: 'top',
                        width: 100,
                        height: 100,
                        angle: 0,
                        fill: color,
                        opacity: opacity,
                        transparentCorners: false
                    });
                }
                else if( type == 'triangle' ) {
					
                    var layerID = get_layer_id('triangle', '');
                    
                    my_object[layerID] = new fabric.Triangle({
						id: layerID,
                        left: 20, 
                        top: 20,
                        width: 100,
                        height: 100,
                        fill: color,
                        opacity: opacity,
                        transparentCorners: false
                    });
                }
                
                canvas.add(my_object[layerID]);
                
                var type_icon = get_type_icon( type );
                edit_layer_btn(layerID, '<i class="fa fa-'+type_icon+'" style="color:'+color+'; opacity:'+opacity+';"></i>');
            });
            
			
			
			$('#preview_bc').click(function(){
                canvas.deactivateAllWithDispatch().renderAll();
				
                var img = canvas.toDataURL('png');
                window.open( img );
            });
            
			
			$('#save_bc').click(function(){
				
				bc_save_banner(0);
			});
            
            $('#export_bc').click(function(){
                
                bc_save_banner(1);
            });
            
            
            
            
            $('#clear_bc').click(function(){
                
                if (confirm('Are you sure?')) {
                    canvas.clear();
                    $('#log').html('');
					
					$.ajax({
					   type: "POST",
					   url: ajaxurl,
					   data: "action=bc_save_banner&banner_id=<?php echo $post->ID; ?>&data_uri=&json="
					}).done(function( obj ) {
					   //success: function( obj ){
						   
						   $('#banner_data_uri').val('');
						   $('#banner_json').val('');
					  // }
                	});
				}
                
                save_img_btn_status();
            });
            
            
            
            
            
            
            $( "#log" ).sortable({
                update: function( event, ui ) {
                    //alert("New position: " + ui.item.index());	
                },
                stop: function(e, ui) {
                    $.map($(this).find('li'), function(el) {
                        
                        canvas.sendToBack( my_object[$(el).attr('itemid')] );
                    });
                },
                placeholder: "ui-state-highlight"
            });
            $( "#log" ).disableSelection();
            
            
            /*
             * Media Popup - works for admins only
            */
            $('#select_image_url').click(function()
            {
                wp.media.editor.send.attachment = function(props, attachment)
                {
                    $('#image_url').val(attachment.url);
                    $('#img_url').html('<img src="'+attachment.url+'" width="25" />');
                }
                wp.media.editor.open(this);
                
                return false;
            });
            
            
			
			
			$('.imge-color-field').wpColorPicker();
					
			$(".sidebar-name").click(function(){
				
				$(this).toggleClass('open');
				$(this).next().slideToggle();
			});
			
			$(".option-cancel").click(function(){
				if( $(".option-title-toggle").hasClass('open') ){
					$(".option-title-toggle").removeClass('open');
					$(".option-title-toggle").next().slideToggle(500);
				}
			});
            
            
        });
        
        
        function addGoogleFont(FontName) {
            jQuery("head").append("<link href='https://fonts.googleapis.com/css?family=" + FontName + "' rel='stylesheet' type='text/css'>");
        }
        
        
        
        function get_layer_id( type, value ){
            var number = 1 + Math.floor(Math.random() * 100000);
            var value = !value ? '' : '_'+value;
            var layer = type+'_'+number+value;
            
            return layer;	
        }
        
        
        function get_type_icon( type ){
            var icon;
            
            if( type == 'circle'){
                icon = 'circle';	
            }else if( type == 'rectangle' || type == 'rect'){
                icon = 'square';	
            }else if( type == 'triangle' ){
				icon = 'play';	
			}
            
            return icon;
        }
        
        
        function edit_layer_btn( itemID, value, scale ){
            var value = !value ? '' : value;
            var scale = !scale ? 1 : scale;
            
            jQuery('#log').prepend(
                '<li itemid="'+itemID+'" class="edit_li_item item_cont_'+itemID+'">'+
                '<a class="remove" item="'+itemID+'" title="<?php _e('Remove','wpproads'); ?>"><i class="fa fa-times"></i></a> '+
                '<div style="float:right; color:#DDD;"><small><?php _e('Drag to change layer index.','wpproads'); ?></small></div>'+
                '<small><?php _e('ID:','wpproads'); ?>'+itemID +'</small> <span style="display:inline-block;" class="bc_preview_icon_'+itemID+'">'+value+'</span></li>');
            
            save_img_btn_status();
            
            
            jQuery('.remove').on('click', function(){
                //alert(jQuery(this).attr('itemnr'));
                //canvas.setActiveObject(canvas.item(jQuery(this).attr('itemnr')));
                //canvas.remove(canvas.item(jQuery(this).attr('itemnr')));
                canvas.remove( my_object[jQuery(this).attr('item')] );
                jQuery('.item_cont_'+jQuery(this).attr('item')).remove();
                
                save_img_btn_status();
            });	
        }
        
        
        function save_img_btn_status(){
            // Enable Save Image button
            if( jQuery("#log").children().length ){
                jQuery('#export_bc').show();
				jQuery('#save_bc').show();
                jQuery('.canvas_sidebar').hide();
                
                set_tab_status( 0 );
            }else{
                jQuery('#export_bc').hide();
				jQuery('#save_bc').hide();
                jQuery('.canvas_sidebar').show();
                
                set_tab_status( 1 );
            }
        }
        
        
        function set_tab_status( status ){
            // tab status 1 = active
            if( status == 1 ){ 
                jQuery(".styling_tab").each(function() {
                    jQuery(this).removeClass('hidden_tab');
                    jQuery(this).attr("href", jQuery(this).attr("data-oldhref"));
                });	
            } else {
                
                jQuery(".styling_tab").each(function() {
                    jQuery(this).addClass('hidden_tab');
                    jQuery(this).attr("data-oldhref", jQuery(this).attr("href"));
                    jQuery(this).removeAttr("href");
                });
            }
        }
		
		
		
		function bc_save_banner( export_png ){
			canvas.deactivateAllWithDispatch().renderAll();
			
			var data_uri = canvas.toDataURL('png');
			var json = JSON.stringify(canvas);
			
			jQuery('#banner_data_uri').val(data_uri);
			jQuery('#banner_json').val(json);
			
			jQuery('.pro_ads_banner_creator').css({ opacity : .5});
			
			jQuery.ajax({
			   type: "POST",
			   url: ajaxurl,
			   data: "action=bc_save_banner&banner_id=<?php echo $post->ID; ?>&data_uri="+ data_uri+"&json="+json
			}).done(function( obj ) {
			   //success: function( obj ){
				   
				   msg = JSON.parse( obj );
				   
				   if( export_png ){
					   jQuery.ajax({
							type: "POST",
							url: ajaxurl,
							data: "action=bc_export_image&img="+ msg.data_uri
					   }).done(function( obj ) {
							//success: function( obj ){
								msg = JSON.parse( obj );
								alert(msg.url);
								jQuery('.pro_ads_banner_creator').css({ opacity : 1});
							//}
						});
				   }else{
				       jQuery('.pro_ads_banner_creator').css({ opacity : 1});   
				   }
				     
			  // }
		  });
		}	

        
        /*
        fabric.loadSVGFromString(svg, function(objects, options) {
          var obj = fabric.util.groupSVGElements(objects, options);
          canvas.add(obj).centerObject(obj).renderAll();
          obj.setCoords();
        });
        */
		
        </script>
        <?php		
	}
	
	
	
	
	
	
	
	/*
	 * Adds a box to the main column on the Post and Page edit screens.
	 *
	 * @access public
	*/
	public function bc_meta_options() 
	{
		$screens = array( 'banners' );
	
		foreach ( $screens as $screen ) 
		{	
			//add_meta_box( 'pro_ads_bc_meta_options_id', __( 'Visual Banner Creator:', 'wpproads' ), array($this, 'pro_ads_bc_meta_options_custom_box'), $screen, 'normal', 'default' );
			
		}
	}
	
	
	
	
	
	function pro_ads_bc_meta_options_custom_box( $post ) 
	{
		// Add an nonce field so we can check for it later.
		wp_nonce_field( 'pro_ads_bc_meta_options_inner_custom_box', 'pro_ads_bc_meta_options_inner_custom_box_nonce' );
		
		if( $post->ID )
		{
			?>
			<div class="tuna_meta">
				<table class="form-table">
					<tbody>
						<tr valign="top">
							<td>
								<?php $this->show_banner_creator(); ?>
							</td>
						</tr>
					</tbody>
				</table>
			</div>
			<?php
		}
		else
		{
			_e('You need to save the banner before you can use the Visual Banner Creator.','wpproads');	
		}
	}
	
	
	
	
	
	
	function pro_ads_bc_meta_options_save_postdata( $post_id ) 
	{
		// Check if our nonce is set.
		if ( ! isset( $_POST['pro_ads_bc_meta_options_inner_custom_box_nonce'] ) )
		return $post_id;
		$nonce = $_POST['pro_ads_bc_meta_options_inner_custom_box_nonce'];
		// Verify that the nonce is valid.
		if ( ! wp_verify_nonce( $nonce, 'pro_ads_bc_meta_options_inner_custom_box' ) )
		  return $post_id;
		// If this is an autosave, our form has not been submitted, so we don't want to do anything.
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) 
		  return $post_id;
		// Check the user's permissions.
		if ( 'page' == $_POST['post_type'] ) {
		if ( ! current_user_can( 'edit_page', $post_id ) )
			return $post_id;
		} else {
		if ( ! current_user_can( 'edit_post', $post_id ) )
			return $post_id;
		}
		/* OK, its safe for us to save the data now. */
			
		/*// Sanitize user input.
		$adzone_buyandsell_contract         = sanitize_text_field( $_POST['adzone_buyandsell_contract'] );
		$adzone_buyandsell_duration         = sanitize_text_field( $_POST['adzone_buyandsell_duration'] );
		$adzone_buyandsell_price            = sanitize_text_field( $_POST['adzone_buyandsell_price'] );
		$adzone_buyandsell_est_impressions  = sanitize_text_field( $_POST['adzone_buyandsell_est_impressions'] );
		
		// Update the meta field in the database.
		update_post_meta( $post_id, 'adzone_buyandsell_contract', $adzone_buyandsell_contract );
		update_post_meta( $post_id, 'adzone_buyandsell_duration', $adzone_buyandsell_duration );
		update_post_meta( $post_id, 'adzone_buyandsell_price', $adzone_buyandsell_price );
		update_post_meta( $post_id, 'adzone_buyandsell_est_impressions', $adzone_buyandsell_est_impressions );*/
	}
	
}
?>