<?php
class WPPAS_TPL {	
	
	public function __construct() 
	{
		
	}
	
	
	
	/**
	 * Get item data or default values.
	 *
	 */
	public static function vbc_data($args = array())
	{
		global $wppas_banner_creator, $wppas_adzone_creator;
			
		$defaults = array(
			'id'      => 0, 
			'type'     => 'size',
			'default'  => '300x250',
			'request' => 'banner' // depricated - not longer neccesery
		);
		$args = wp_parse_args( $args, $defaults );
		
		$post_type = get_post_type( $args['id'] );
		
		//if( $args['request'] == 'adzone' )
		if($post_type == 'wppas_adzones')
		{
			$data = $wppas_adzone_creator->load_adzone_data($args['id']);
			if( array_key_exists($args['type'], $data['adzone_data'][0]))
			{
				$result = $data['adzone_data'][0][$args['type']] != '' ? $data['adzone_data'][0][$args['type']] : $args['default'];
			}
			else
			{
				$result = $args['default'];
			}
		}
		else
		{
			$data = $wppas_banner_creator->load_banner_data($args['id']);
			if( array_key_exists($args['type'], $data['banner_data'][0]))
			{
				$result = $data['banner_data'][0][$args['type']] != '' ? $data['banner_data'][0][$args['type']] : $args['default'];
			}
			else
			{
				$result = $args['default'];
			}
		}
		
		return $result;
	}
	
	
	
	public static function save_confirms($args = array())
	{
		$defaults = array(
			'for' => 'banner'
		);
		$args = wp_parse_args( $args, $defaults );
		
		$array = array(
			__('SAVED','wpproads'),
			__('GOOD JOB','wpproads'),
			__('NICE','wpproads'),
			__('SWEET','wpproads'),
			__('DONE','wpproads'),
			__('YES','wpproads'),
			__('OK','wpproads'),
			__('READY','wpproads'),
			__('ALL GOOD','wpproads')
		);
		
		if( $args['for'] == 'banner' )
		{
			wp_localize_script( 'WPPAS_VBC_EDITR', 'itm_editor_save_confirms', array('array' => json_encode($array)) );
		}
		else
		{
			wp_localize_script( 'WPPAS_VBC_ADZN_STSCRN', 'itm_editor_save_confirms', array('array' => json_encode($array)) );
		}
		return $array;
	}
	
	
	
	/**
	 * CSS string
	 *
	 */
	public static function css_str($args = array())
	{
		$defaults = array(
			'key'     => '',
			'value'    => ''
		);
		$args = wp_parse_args( $args, $defaults );
		$css = '';
		$val = '';
		
		if( !empty($args['key']) && !empty($args['value']) )
		{
			if( is_array($args['value']) )
			{
				foreach($args['value'] as $itm)
				{
					$val.= !empty($itm) ? $itm.' ' : '0 ';
				}
			}
			else
			{
				$val = 	$args['value'];
			}
			
			if( !empty($val))
			{
				$css.= $args['key'].':';
				$css.= $val.';';
			}
		}
		
		return $css;
	}
	
	
	
	public static function itm_defaults()
	{
		$defaults = array(
			'title'       => '',
			'name'        => '', 
			'slug'        => '',
			'type'        => 'text',
			'id'          => '',
			'placeholder' => '',
			'value'       => '',
			'class'       => '',
			'style'       => '',
			'script'      => '',
			'text-align'  => 'left',
			'height'      => '100px', // for textareas
			'size'        => '', // one_third
			'desc_pos'    => 'bottom', // bottom, top
			'desc'        => '',
			'content'     => '',
			'show_icon'   => 1,
			'icon'        => 'pencil',
			'icon_type'   => 'fa',
			'select_opts' => array(),
			'chk-on'      => __('ON','wpproads'),
			'chk-off'     => __('OFF','wpproads'),
			'chk_width'   => 50,
			'chk_height'  => 30,
			'chk_btn_width' => 30,
			'chk_labels_placement' => 'right',
			'chk_data-values' => '',
			'color_change' => '',
			'trigger_switch_button' => 0
		);
		
		return $defaults;
	}
	
	
	
	
	/** 
	 * SEP LINE
	 *
	 */
	 public static function sep_line($args = array())
	{
		$defaults = self::itm_defaults();
		$args = wp_parse_args( $args, $defaults );
		
		$html = '';
		
		$html.= '<div class="wppas_sep_cont '.$args['class'].'">';
			$html.= '<div class="wppas_sep_line" style="margin: 50px 0 15px 0;">';
				$html.= !empty($args['title']) ? '<span style="background-color:#FFF;"><strong>'.$args['title'].'</strong></span>' : '';
			$html.= '</div>';
			
			if( !empty($args['desc']))
			{
				$html.= '<div class="wppas_sep_dec" style="margin: 0 0 40px; text-align:center;">';
					$html.= $args['desc'];
				$html.= '</div>';
			}
		$html.= '</div>';
		
		return $html;
	}
	
	
	/** 
	 * INFO BOX
	 *
	 */
	public static function info_box($args = array())
	{
		$defaults = self::itm_defaults();
		$args = wp_parse_args( $args, $defaults );
		
		$html = '';
		
		$html.= '<div class="wppas_info_box info '.$args['class'].'">';
			$html.= '<i class="fa fa-'.$args['icon'].'" aria-hidden="true"></i> ';
			$html.= $args['desc'];
		$html.= '</div>';
		
		return $html;
	}
	
	
	
	/** 
	 * INPUT CONTAINER
	 *
	 */
	public static function inpt_cont($args = array())
	{
		$defaults = self::itm_defaults();
		$args = wp_parse_args( $args, $defaults );
		
		$html = '';
		$html.= '<span class="input_container '.$args['size'].'">';
			$html.= !empty($args['title']) ? '<h3 class="title">'.$args['title'].'</h3>' : '';
			$html.= $args['desc_pos'] == 'top' && !empty($args['desc']) ? '<span class="description top">'.$args['desc'].'</span>' : '';
			$html.= '<div style="position: relative;">';
				$html.= '<input type="'.$args['type'].'" class="'.$args['class'].'" id="'.$args['id'].'" name="'.$args['name'].'" value="'.$args['value'].'" placeholder="'.$args['placeholder'].'" />';
				$html.= $args['show_icon'] ? '<i class="input_icon fa fa-'.$args['icon'].'" aria-hidden="true"></i>' : '';
			$html.= '</div>';
			$html.= $args['desc_pos'] == 'bottom' && !empty($args['desc']) ? '<span class="description bottom">'.$args['desc'].'</span>' : '';
		$html.= '</span>';
		
		return $html;
	} 
	
	
	
	
	/** 
	 * TEXTAREA
	 *
	 */
	public static function textarea_cont($args = array())
	{
		$defaults = self::itm_defaults();
		$args = wp_parse_args( $args, $defaults );
		
		$html = '';
		$html.= '<span class="input_container '.$args['size'].'">';
			$html.= !empty($args['title']) ? '<h3 class="title">'.$args['title'].'</h3>' : '';
			$html.= $args['desc_pos'] == 'top' && !empty($args['desc']) ? '<span class="description top">'.$args['desc'].'</span>' : '';
			$html.= '<div style="position: relative;">';
				$html.= '<textarea type="text" class="'.$args['class'].'" id="'.$args['id'].'" name="'.$args['name'].'" placeholder="'.$args['placeholder'].'" style="width:100%; height:'.$args['height'].';">'.$args['value'].'</textarea>';
			$html.= '</div>';
			$html.= $args['desc_pos'] == 'bottom' && !empty($args['desc']) ? '<span class="description bottom">'.$args['desc'].'</span>' : '';
		$html.= '</span>';
		
		return $html;
	} 
	
	
	
	
	/** 
	 * SELECT CONTAINER
	 *
	 */
	public static function select_cont($args = array())
	{
		$defaults = self::itm_defaults();
		$args = wp_parse_args( $args, $defaults );
		
		// Example aerray
		/*$args['select_opts'] = array(
			'left' => array(
				'value' => 'left',
				'text'  => 'Left'
			),
			'right' => array(
				'value' => 'left',
				'text'  => 'Left'
			),
		);*/
		
		$html = '';
		$html.= '<span class="input_container '.$args['size'].'">';
			$html.= !empty($args['title']) ? '<h3 class="title">'.$args['title'].'</h3>' : '';
			$html.= $args['desc_pos'] == 'top' && !empty($args['desc']) ? '<span class="description top">'.$args['desc'].'</span>' : '';
			$html.= '<select id="'.$args['id'].'" name="'.$args['name'].'" class="'.$args['class'].'">';
				if( !empty($args['select_opts']))
				{
					foreach($args['select_opts'] as $key => $opt)
					{
						$val = array_key_exists('value', $opt) && $key != $opt['value'] ? $opt['value'] : $key;
						$txt = array_key_exists('text', $opt) ? $opt['text'] : $val;
						
						$html.= '<option value="'.$val.'" '.selected($args['value'], $val, false).'>'.$txt.'</option>';
					}
				}
				else
				{
					$html.= '<option value="">'.__('No options available','wpproads').'</option>';
				}
			$html.= '</select>';
			$html.= $args['desc_pos'] == 'bottom' && !empty($args['desc']) ? '<span class="description bottom">'.$args['desc'].'</span>' : '';
		$html.= '</span>';
		
		return $html;
	}
	
	
	
	
	
	
	
	/** 
	 * CHECKBOX
	 *
	 */
	public static function checkbox_cont($args = array())
	{
		$defaults = self::itm_defaults();
		$args = wp_parse_args( $args, $defaults );
		
		$ckd = $args['value'] ? 'checked="checked"' : '';
		$html = '';
		$html.= '<div class="input_container '.$args['size'].'" style="text-align:'.$args['text-align'].';">';
			$html.= !empty($args['title']) ? '<h3 class="title">'.$args['title'].'</h3>' : '';
			$html.= $args['desc_pos'] == 'top' && !empty($args['desc']) ? '<span class="description top">'.$args['desc'].'</span>' : '';
			$html.= '<div class="wppas_switch_btn h'.$args['chk_height'].'" style="margin-bottom: 15px;">';
				$html.= '<input id="'.$args['id'].'" class="'.$args['class'].'" type="checkbox" name="'.$args['name'].'" value="'.$args['value'].'" '.$ckd.' 
					data-labels_placement="'.$args['chk_labels_placement'].'" 
					data-on_label="'.$args['chk-on'].'" 
					data-off_label="'.$args['chk-off'].'"
					data-width="'.$args['chk_width'].'" 
					data-height="'.$args['chk_height'].'" 
					data-button_width="'.$args['chk_btn_width'].'" 
					data-values="'.$args['chk_data-values'].'"
				>';
			$html.= '</div>';
			$html.= $args['desc_pos'] == 'bottom' && !empty($args['desc']) ? '<span class="description bottom">'.$args['desc'].'</span>' : '';
		$html.= '</div>';
		
		if( $args['trigger_switch_button'] )
		{
			$html.= '<script type="text/javascript">';
				$html.= 'jQuery(document).ready(function($){';
					$html.= '$(this).wppas.activate_switch_buttons();';
				$html.= '});';
			$html.= '</script>';
		}
		
		return $html;
	}
	
	
	
	
	
	/** 
	 * COLOR PICKER
	 *
	 */
	public static function colorpicker_cont($args = array())
	{
		$defaults = self::itm_defaults();
		$args = wp_parse_args( $args, $defaults );
		$uniqueID = 'wp'.uniqid();
		
		$html = '';
		$html.= '<div class="input_container '.$uniqueID.' '.$args['size'].' cont_'.$args['id'].' '.$args['class'].'" style="text-align:'.$args['text-align'].';'.$args['style'].'">'; // wp-color-bg
			$html.= !empty($args['title']) ? '<h3 class="title">'.$args['title'].'</h3>' : '';
			$html.= $args['desc_pos'] == 'top' && !empty($args['desc']) ? '<span class="description top">'.$args['desc'].'</span>' : '';
			$html.= '<div>';
				$html.= '<input type="text" id="'.$args['id'].'" value="'.$args['value'].'" class="vbc-color-field color_picker '.$args['id'].'" data-alpha="true" />';
			$html.= '</div>';
			$html.= $args['desc_pos'] == 'bottom' && !empty($args['desc']) ? '<span class="description bottom">'.$args['desc'].'</span>' : '';
		$html.= '</div>';
		
		// JS
		$html.= '<script type="text/javascript">';
			$html.= 'jQuery(document).ready(function($){';
				$html.= '$(".'.$uniqueID.'").find(".'.$args['id'].'").wpColorPicker({';
		  			$html.= 'change: function(event, ui){';
						$html.= 'var selected_color = ui.color.toString();';
						$html.= $args['color_change'];
		  			$html.= '}'; 
				$html.= '});';
			$html.= '});';
        $html.= '</script>';

		
		return $html;
	}
	
	
	
	
	
	
	/** 
	 * ALIGN BUTTONS
	 *
	 */
	public static function align_cont($args = array())
	{
		$defaults = self::itm_defaults();
		$args = wp_parse_args( $args, $defaults );
		
		$val_h = is_array($args['value']) ? $args['value'][0] : $args['value'];
		$val_v = is_array($args['value']) ? $args['value'][1] : '';
		$connect = array_key_exists('connect', $args) ? $args['connect'] : '';
		
		$inputs_h = array(
			'left' => array('text' => __('Align Left','wpproads')),
			'center' => array('text' => __('Align Center','wpproads')),
			'right' => array('text' => __('Align Right','wpproads')),
		);
		$inputs_v = array(
			'top' => array('text' => __('Align Top','wpproads')),
			'middle' => array('text' => __('Align Middle','wpproads')),
			'bottom' => array('text' => __('Align Bottom','wpproads')),
		);
		
		
		$html = '';
		$html.= '<div class="input_container '.$args['size'].'" style="text-align:'.$args['text-align'].';">';
			$html.= !empty($args['title']) ? '<h3 class="title">'.$args['title'].'</h3>' : '';
			$html.= $args['desc_pos'] == 'top' && !empty($args['desc']) ? '<span class="description top">'.$args['desc'].'</span>' : '';
			
			
			// Horizontal Buttons
			$html.= '<div>';
				$html.= '<input type="hidden" id="'.$args['id'].'_h" name="'.$args['name'].'_h" value="'.$val_h.'" />';
				$html.= '<div class="wppas_align_legend pos_h"><i class="fa fa-arrows-h" aria-hidden="true"></i></div>';
				foreach($inputs_h as $key => $input_h)
				{
					$selected = $val_h == $key ? ' selected' : '';
					$html.= '<div class="wppas_align_btn alh '.$key.$selected.'" data-al="h" data-align="'.$key.'" title="'.$input_h['text'].'"></div>';
				}
			$html.= '</div>';
			
			// Vertical Buttons
			if( is_array($args['value']) )
			{
				$html.= '<div>';
					$html.= '<input type="hidden" id="'.$args['id'].'_v" name="'.$args['name'].'_v" value="'.$val_v.'" />';
					$html.= '<div class="wppas_align_legend pos_v"><i class="fa fa-arrows-v" aria-hidden="true"></i></div>';
					foreach($inputs_v as $key => $input_v)
					{
						$selected = $val_v == $key ? ' selected' : '';
						$html.= '<div class="wppas_align_btn alv '.$key.$selected.'" data-al="v" data-align="'.$key.'" title="'.$input_v['text'].'"></div>';
					}
				$html.= '</div>';
			}
			
			$html.= $args['desc_pos'] == 'bottom' && !empty($args['desc']) ? '<span class="description bottom">'.$args['desc'].'</span>' : '';
		$html.= '</div>';
		
		// JS
		$html.= '<script type="text/javascript">';
			$html.= 'jQuery(document).ready(function($){';
				$html.= '$("body").on("click", ".wppas_align_btn", function(){';
					$html.= 'var type = $(this).data("al");';
					$html.= 'var align = $(this).data("align");';
					//$html.= 'console.log("#'.$args['id'].'_"+type);';
					$html.= '$(".timeline_itm.selected").find("#'.$args['id'].'_"+type).attr("value", align);';
					$html.= '$(".wppas_align_btn.al"+type).removeClass("selected");';
					$html.= '$(this).addClass("selected");';
					
					if(!empty($connect))
					{
						$html.= '$(".'.$connect.' input[type=text]").each(function() {';
							$html.= 'if( $(this).data("pos") == type ){';
								$html.= '$(this).prop("readonly", false);';
							$html.= '}';
						$html.= '});';
						
						// Horizontal
						$html.= 'if(type == "h"){'; //&& align != "center"
							$html.= 'if(align == "left"){';
								$html.= '$(".'.$connect.'").find("#edit_itm_offset_right").prop("readonly", true);';
								$html.= '$(".'.$connect.'").find("#edit_itm_offset_right").val("");';
							$html.= '}else if(align == "right"){';
								$html.= '$(".'.$connect.'").find("#edit_itm_offset_left").prop("readonly", true);';
								$html.= '$(".'.$connect.'").find("#edit_itm_offset_left").val("");';
							$html.= '}else if(align == "center"){';
								$html.= '$(".'.$connect.'").find("#edit_itm_offset_left").val("");';
								$html.= '$(".'.$connect.'").find("#edit_itm_offset_right").val("");';
							$html.= '}';
						$html.= '}';
						
						// Vertical
						$html.= 'if(type == "v"){'; // && align != "middle"
							$html.= 'if(align == "top"){';
								$html.= '$(".'.$connect.'").find("#edit_itm_offset_bottom").prop("readonly", true);';
								$html.= '$(".'.$connect.'").find("#edit_itm_offset_bottom").val("");';
							$html.= '}else if(align == "bottom"){';
								$html.= '$(".'.$connect.'").find("#edit_itm_offset_top").prop("readonly", true);';
								$html.= '$(".'.$connect.'").find("#edit_itm_offset_top").val("");';
							$html.= '}else if(align == "middle"){';
								$html.= '$(".'.$connect.'").find("#edit_itm_offset_top").val("");';
								$html.= '$(".'.$connect.'").find("#edit_itm_offset_bottom").val("");';
							$html.= '}';
						$html.= '}';
					}
					
				$html.= '});';
			$html.= '});';
		$html.= '</script>';
		
		return $html;
	}
	
	
	
	
	
	/** 
	 * OFFSET FORM
	 *
	 */
	public static function offset_cont($args = array())
	{
		$defaults = self::itm_defaults();
		$args = wp_parse_args( $args, $defaults );
		
		/*
		// Example Array
		WPPAS_TPL::offset_cont(array(
			'offset' => array(
				'outer' => array(
					'label' => 'offset',
					'id'    => array('top' => '', 'right' => '', 'bottom' => '', 'left' => ''),
					'active' => array(),
					'name'  => array('top' => '', 'right' => '', 'bottom' => '', 'left' => ''),
					'value' => array('top' => '', 'right' => '', 'bottom' => '', 'left' => ''),
					'connect' => ''
				),
				// Inner is optional
				'inner' => array(
					'label' => 'margin',
					'id'    => array('top' => '', 'right' => '', 'bottom' => '', 'left' => ''),
					'active' => array(),
					'name'  => array('top' => '', 'right' => '', 'bottom' => '', 'left' => ''),
					'value' => array('top' => '', 'right' => '', 'bottom' => '', 'left' => '')
				)
			)
		));
		*/
		
		$inputs = array('top', 'right', 'bottom', 'left');
		$inner_exists = array_key_exists('inner',$args['offset']) ? 1 : 0;
		$no_inner_css = !$inner_exists ? 'single' : '';
		$connect_outer = array_key_exists('connect', $args['offset']['outer']) ? ' '.$args['offset']['outer']['connect'] : '';
		$connect_inner = $inner_exists && array_key_exists('connect', $args['offset']['inner']) ? ' '.$args['offset']['inner']['connect'] : '';
		
		$html = '';
		$html.= '<div class="wppas_offset_cont '.$args['size'].'">';
			$html.= !empty($args['title']) ? '<h3 class="title">'.$args['title'].'</h3>' : '';
			$html.= $args['desc_pos'] == 'top' && !empty($args['desc']) ? '<span class="description top">'.$args['desc'].'</span>' : '';
			
			$html.= '<div class="wppas_offset '.$no_inner_css.'">';
				$html.= '<div class="vbc_offset vbc_outer'.$connect_outer.'">';
					$html.= '<label>'.$args['offset']['outer']['label'].'</label>';
					
					foreach($inputs as $input)
					{
						$data_pos = $input == 'top' || $input == 'bottom' ? 'v' : 'h';
						$html.= '<input type="text" id="'.$args['offset']['outer']['id'][$input].'" name="'.$args['offset']['outer']['name'][$input].'" value="'.$args['offset']['outer']['value'][$input].'" class="vbc_'.$input.'" data-pos="'.$data_pos.'" placeholder="-" />';
					}
				   
				   if($inner_exists)
				   {
					   $html.= '<div class="vbc_offset vbc_cont'.$connect_inner.'">';
							$html.= '<label>'.$args['offset']['inner']['label'].'</label>';
							foreach($inputs as $input)
							{
								$data_pos = $input == 'top' || $input == 'bottom' ? 'v' : 'h';
								$html.= '<input type="text" id="'.$args['offset']['inner']['id'][$input].'" name="'.$args['offset']['inner']['name'][$input].'" value="'.$args['offset']['inner']['value'][$input].'" class="vbc_'.$input.'" data-pos="'.$data_pos.'" placeholder="-" />';
							}
					   $html.= '</div>';
				   }
				   
				$html.= '</div>';
				// end .vbc_outer
			$html.= '</div>';
			
			$html.= $args['desc_pos'] == 'bottom' && !empty($args['desc']) ? '<span class="description bottom">'.$args['desc'].'</span>' : '';
		$html.= '</div>';
		
		return $html;
	}
	
	
	
	
	
	/** 
	 * ICON
	 *
	 */
	public static function icon($args = array())
	{
		$defaults = self::itm_defaults();
		$args = wp_parse_args( $args, $defaults );
		
		$html = '';
		$style = !empty($args['style']) ? ' style="'.$args['style'].'"' : '';
		$html.= '<i class="'.$args['icon_type'].' '.$args['icon'].'"'.$style.'></i>';
		
		return $html;
	}
	
	
	
	
	
	
	
	/** 
	 * FULL PAGE MODAL
	 *
	 */
	public static function full_page_modal($args = array())
	{
		$defaults = self::itm_defaults();
		$args = wp_parse_args( $args, $defaults );
		
		$html = '';
		$html.= '<div id="'.$args['id'].'" class="wppas-modal fullpage" style="display:none;">';
			$html.= '<div class="wppas-close-modal"><div class="lr"><div class="rl"></div></div></div>';
			$html.= '<div class="wppas-modal-content">';
				$html.= $args['content'];
			$html.= '</div>';
		$html.= '</div>';
		
		$html.= '<script type="text/javascript">';
			$html.= 'jQuery(document).ready(function($){';
				$html.= $args['script'];
				$html.= '$("body").on("click", ".wppas-close-modal", function(){';
					$html.= '$(".wppas-modal").hide();';
					$html.= '$("html").css({"overflow":"auto"});$("body").css({"overflow":"auto"});';
				$html.= '});';
			$html.= '});';
		$html.= '</script>';
		
		return $html;
	}
	
	
	
	/** 
	 * encodeURIComponent
	 *
	*/
	public static function encodeURIComponent($str) {
		$revert = array('%21'=>'!', '%2A'=>'*', '%27'=>"'", '%28'=>'(', '%29'=>')');
		return strtr(rawurlencode($str), $revert);
	}
	
}
?>