<?php
/**
 * Init related functions and actions.
 *
 * @author      Tunafish
 * @package 	  wp_pro_ad_system/classes
 * @version     1.0.0
 */
 
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'WPPAS_Core' ) ) :


class WPPAS_Core {	
	
	/**
	 * Initializes variables and actions
	 */
	public static function init() 
	{	
		
	}
	
	
	/**
	 * VBC MENU
	 */
	public static function vbc_menu($args = array())
	{
		// Create menu
		add_menu_page(
			__('Banner Creator', 'wpproads'), 
			__('Banner Creator', 'wpproads'), 
			WP_ADS_USER_CAN,  
			"wppas-banner-creator", 
			array( __CLASS__, "wppas_banner_creator_page"),
			WP_ADS_URL."images/logo_20.png",
			21
		);
		
		add_submenu_page("wppas-banner-creator", __('Purchases', 'wpproads'), __('Purchases', 'wpproads'), WP_ADS_USER_CAN, "wp-pro-ads-purchases", array( __CLASS__, "wppas_purchases"));
		//add_submenu_page("wppas-banner-creator", __('Banners', 'wpproads'), __('Banners', 'wpproads'), WP_ADS_USER_CAN, "wp-pro-ads-banners", array( __CLASS__, "wppas_banners"));
	}
	
	public static function wppas_banner_creator_page($args = array())
	{
		include( WP_ADS_TPL_DIR.'/wppas_banner_creator.php');
	}
	public static function wppas_banners()
	{
		include( WP_ADS_TPL_DIR.'/wppas_banners.php');
	}
	public static function wppas_purchases()
	{
		include( WP_ADS_TPL_DIR.'/wppas_purchases.php');
	}
	
	
	
	public static function create_folder($args = array())
	{
		$defaults = array(
			'folder' => '/wppas/banners/'
		);
		$args = wp_parse_args( $args, $defaults );
		
		$upload = wp_upload_dir();
		$upload_dir = $upload['basedir'];
		//$upload_folder = '/wppas/banners/'.$alphaID;
		$banner_dir = $upload_dir . $args['folder'];
		wp_mkdir_p( $banner_dir );
		
		return array(
			'dir' => $banner_dir,
			'url' => $upload['baseurl'].$args['folder']
		);
	}
	
}


// Let's get going
if ( function_exists( 'add_action' ) ) 
{
	add_action( 'plugins_loaded', array( 'WPPAS_Core', 'init' ), 20 );
}

endif;