<?php
class WPPAS_Banner_Creator {	

	public function __construct() 
	{
		add_filter('the_content', array($this, 'update_content'), 99);
		add_action('before_delete_post', array($this, 'banner_remove_action') );
	}
	
	
	
	
	
	/**
	 * CREATE BANNER
	 *
	 */
	public function load_banner($args = array()) 
	{	
		$defaults = array(
			'bid'         => 0,
			'options'     => array(),
			'hold'        => 0,
			'do_stats'    => 0,
			'load_delay'  => 0, // int - milliseconds to wait before loading the ad.
			'window_load' => 1 // bool - wait to load ads untill full page is loaded.
		);
		
		$args = wp_parse_args( $args, $defaults );
		
		$banner = $this->load_banner_data($args['bid']);
		$unique = 'wp'.uniqid();
		$adzone = array_key_exists('adzone', $args['options']) ? $args['options']['adzone'] : 0;
		//echo '<pre>'.print_r($banner,true).'</pre>';
		$w = $this->vbc_banner_data(array('bid' => $args['bid'], 'type' => 'w', 'default' => '300')); //$banner['banner_data'][0]['w'];
		$h = $this->vbc_banner_data(array('bid' => $args['bid'], 'type' => 'h', 'default' => '250')); //$banner['banner_data'][0]['h'];
		$w = $w != 'full' ? $w.'px' : '100%';
		$h = $h != 'full' ? $h.'px' : '100%';
		$bscale = WPPAS_TPL::vbc_data(array('id' => $args['bid'], 'type' => 'scale_banner', 'default' => 1));
		$args['options']['unique'] = $unique;
		$args['options']['width'] = $w;
		$args['options']['height'] = $h;
		$args['options']['scale'] = $bscale;
		$vc_class = WPPAS_Display_Options::option($args['options'], 'vc_class', '');
		
		//$nfl = array_key_exists('no_follow', $banner['banner_data'][0]) ? $banner['banner_data'][0]['no_follow'] : 0;
		$nfl = WPPAS_TPL::vbc_data(array('id' => $args['bid'], 'type' => 'no_follow', 'default' => 0));
		$nfl_str = $nfl ? ' rel="nofollow"' : '';
		$display_options_css = WPPAS_Display_Options::display_options_css($args['options']);
		
		$is_popup = WPPAS_Display_Options::is_popup($args['options']);
		$use_trigger = WPPAS_Display_Options::use_trigger($args['options']);
		$target = $this->vbc_banner_data(array('bid' => $args['bid'], 'type' => 'target', 'default' => '_blank'));
		$effect = array_key_exists('effect', $args['options']) ? $args['options']['effect'] : '';
		$custom_class = array_key_exists('class', $args['options']) ? ' '.$args['options']['class'] : '';
		
		$link = $this->create_link($banner, $args['options']);
		$link_html = !empty($link) ? ' href="'.$link.'"'.$nfl_str.' target="'.$target.'"' : '';
		
		$html = '';
		//$wi = empty($adzone) ? $w : 'inherit';
		//$hi = empty($adzone) ? $h : 'inherit';
		//$html.= WPPAS_Display_Options::info_text($args['options']);
		$html.= '<a class="b_container b_cont_'.$unique.' '.$unique.' '.$vc_class.$custom_class.'"'.$link_html.' style="width:'.$w.';height:'.$h.';max-width:'.$w.'; max-height:'.$h.'; background-color:#EFEFEF;display:none;'.$display_options_css.'" data-unique="'.$unique.'" data-bid="'.$args['bid'].'" data-rdm="'.$unique.'" data-zn="'.$adzone.'" data-scale="'.$bscale.'"></a>';
		
		// @since v5.1.9 Create HTML from timeline items - under dev...
		$html_arr = WPPAS_Banner::create_html_from_timeline($args);
		$js_html = WPPAS_Banner::js_html_var($html_arr);
		
		
		$html.= '<script type="text/javascript">';
			$html.= 'var bhtml_'.$unique.' = { ';
			
				if( !empty($js_html))
				{
					$html.= $js_html;
				}
				else
				{
					// For older version before 5.1.9
					if( !empty($banner['banners_html']))
					{
						foreach($banner['banners_html'] as $key => $bnr)
						{
							// Remove line breaks
							$bhtml = preg_replace( "/\r|\n/", "", $bnr['html'] );
							// Add slashes to single qoutes
							$bhtml = str_replace("'", "\\'", $bhtml);
							$html.= $key.': \''.$bhtml.'\',';
						}
					}
				}
			$html.= '};';
			
			$html.= 'function wppasReloadBnr_'.$unique.'(){ ';
				
				$html.= 'jQuery(".'.$unique.'").wppas_show({'; //.b_cont_'.$args['bid'].'
					$html.= 'bid: '.$args['bid'].',';
					$html.= 'bw: jQuery(".b_cont_'.$unique.'").width(),';
					$html.= 'effect:"'.$effect.'",';
					$html.= 'html: bhtml_'.$unique.',';
					$html.= 'scale: '.$bscale.',';
					$html.= !empty($banner['banner_data'][0]['timeline_arr']) ? 'timeline_arr: '.json_encode($banner['banner_data'][0]['timeline_arr']).',' : '';
					// add all banner options (except specific editor options like timeline)
				
					$dont_add = array(
						'timeline', 
						'timeline_arr',
						'link', 
						'name',
						'target',
						'hide_for_categories',
						'hide_for_tags',
						'hide_for_posts',
						'hide_for_pages',
						'auto_show'
					);
					foreach( $banner['banner_data'][0] as $key => $dt )
					{
						if( !in_array($key, $dont_add) )
						{
							$html.= is_numeric($dt) ? $key.':'.$dt.',' : $key.':"'.$dt.'",';
						}
					}
				$html.= '});';
				
				//Extra display JS
				$html.= WPPAS_Display_Options::extra_display_js($args['options']);
				
				// IF EFFECT IS DEFINED - Show banner after everything is loaded with effect.
				$html.= WPPAS_Display_Options::banner_effect($args['options']);
				
				// Info text wrapper
				$html.= WPPAS_Display_Options::info_text($args['options']);
			$html.= '}';
			// END FUNCTION wppasReloadBnr_
			
			if( !$args['hold'] )
			{
				$html.= 'jQuery(document).ready(function($){';
					$html.= $args['window_load'] ? '$(window).load(function() {' : '';
						if( !$use_trigger )
						{
							$html.= $args['load_delay'] ? 'setTimeout(function() {' : '';
								$html.= 'wppasReloadBnr_'.$unique.'();';
							$html.= $args['load_delay'] ? '}, Number('.$args['load_delay'].'));' : '';
						}
						else
						{
							$html.= WPPAS_Display_Options::trigger_js($args['options']);	
						}
					$html.= $args['window_load'] ? '});' : '';
				$html.= '});';
			}
		$html.= '</script>';
		
		//Extra display html
		$html.= WPPAS_Display_Options::extra_display_html($args['options']);
		
		
		// Do Stats
		if($args['do_stats'])
		{
			global $wppas_stats;
			$rss = array_key_exists('rss', $args['options']) ? $args['options']['rss'] : 0;
			
			// Save Impressions.
			$wppas_stats->save_stats(array(
				'type'          => 'impressions',
				'banner_id'     => $args['bid'],
				'advertiser_id' => !empty($banner['banner_data'][0]['advertiser']) ? $banner['banner_data'][0]['advertiser'] : 0,
				'campaign_id'   => !empty($banner['banner_data'][0]['campaign']) ? $banner['banner_data'][0]['campaign'] : 0,
				'adzone_id'     => 0,
				'rss' => $rss
			));
		}
		
		return $html;
	}
	
	
	
	
	
	
	/**
	 * SHOW BANNER BY (export) CODE
	 * Used to load example bannerscreated with BuySell frontend editor.
	 *
	 */
	public function show_banner_by_code($banner)
	{
		$rand = substr(uniqid('', true), -5);
		$unique = uniqid();
		$link = '';
		$link_html = !empty($link) ? ' href="'.$link.'"' : '';
		$w = $banner['banner_data']['w'];
		$h = $banner['banner_data']['h'];
		$w = $w != 'full' ? $w.'px' : '100%';
		$h = $h != 'full' ? $h.'px' : '100%';
		
		$html = '';
		$html.= '<a class="b_container b_cont_'.$rand.' '.$unique.'"'.$link_html.' style="max-width:'.$w.'; max-height:'.$h.'; background-color:#EFEFEF;display:none;" data-bid="'.$rand.'" data-rdm="'.$unique.'"></a>';
		
		$html.= '<script type="text/javascript">';
			$html.= 'var bhtml_'.$rand.' = { ';
			foreach($banner['banner_html'] as $key => $bnr)
			{
				// Remove line breaks
				$bhtml = preg_replace( "/\r|\n/", "", $bnr['html'] );
				// Add slashes to single qoutes
				$bhtml = str_replace("'", "\\'", $bhtml);
				$html.= $key.': \''.$bhtml.'\',';
			}
			$html.= '};';
			
			$html.= 'function wppasReloadBnr_'.$rand.'(){ ';
				
				$html.= 'jQuery(".b_cont_'.$rand.'").wppas_show({';
					$html.= 'bid: '.$rand.',';
					$html.= 'bw: jQuery(".b_cont_'.$rand.'").width(),';
					$html.= 'html: bhtml_'.$rand.',';
					$html.= !empty($banner['banner_data']['timeline_arr']) ? 'timeline_arr: '.json_encode($banner['banner_data']['timeline_arr']).',' : '';
					// add all banner options (except specific editor options like timeline)
					foreach( $banner['banner_data'][0] as $key => $dt )
					{
						if($key != 'timeline' && $key != 'timeline_arr' && $key != 'link' && $key != 'name' && $key != 'target'){
							$html.= is_numeric($dt) ? $key.':'.$dt.',' : $key.':"'.$dt.'",';
						}
					}
				$html.= '});';
			$html.= '}';
			// END FUNCTION wppasReloadBnr_
			
			$html.= 'jQuery(document).ready(function($){';
				$html.= 'wppasReloadBnr_'.$rand.'();';
			$html.= '});';
		$html.= '</script>';
		
		return $html;
	}
	
	
	
	
	
	/**
	 * LOAD BANNER DATA
	 *
	 */
	public function load_banner_data($id = 0, $timeline_arr = array())
	{
		if($id)
		{
			$banner_post = get_post($id);
			$banner_data = get_post_meta($id, '_wpproads_banner_data', array());
			$banners_html = get_post_meta($id, '_wpproads_html_banners', array());
			
			if(!array_key_exists('alphaID', $banner_data[0]['timeline_arr']['main']))
			{
				$banner_data[0]['timeline_arr']['main']['alphaID'] = WPPAS_AlphaID::getID();
			}
			
			$banner = array(
				'banner'       => $banner_post,
				'banner_data'  => $banner_data,
				'banners_html' => array_key_exists(0, $banners_html) ? $banners_html[0] : ''
			);
		}
		else
		{
			// Setup some vars for new banners
			if(empty($timeline_arr))
			{
				$banner['banner_data'][0]['timeline_arr']['v'] = str_replace('.', '', WP_ADS_VERSION);
				$banner['banner_data'][0]['timeline_arr']['main']['alphaID'] = WPPAS_AlphaID::getID();
			}
			else
			{
				$banner['banner_data'][0]['timeline_arr'] = $timeline_arr;
			}
		}
		
		return $banner;
	}
	
	
	
	
	/**
	 * GET BANNER ALPHA ID
	 *
	 */
	public function get_alphaID( $args = array() )
	{
		$defaults = array(
			'id' => 0
		);
		$args = wp_parse_args( $args, $defaults );
		$alphaID = '';
		
		if(!empty($args['id']))
		{
			$data = $this->load_banner_data($args['id']);
			if(!empty($data['banner_data'][0]['timeline_arr']['main']))
			{
				return array_key_exists('alphaID', $data['banner_data'][0]['timeline_arr']['main']) ? $data['banner_data'][0]['timeline_arr']['main']['alphaID'] : $alphaID;
			}
		}
		
		return $alphaID;
	}
	
	
	
	
	
	/**
	 * Banner Remove action
	 *
	 */
	public function banner_remove_action( $postid ){

		// Check if the global post type isn't ours and just return
		global $post_type;   
		if ( $post_type != 'wppas_banners' ) return;
	
		// Custom stuff for deleting banners
		$alphaID = $this->get_alphaID(array('id' => $postid));
		
		// remove from BS
		WPPAS_BuySell::remove_order(array('banner_id' => $postid));
		
		// Remove folder
		$this->deleteDir($alphaID);
		// remove all empty folders
		$this->Remove_Empty_Folders();
	}
	
	
	
	/**
	 * Remove all empty folders
	 */
	public function Remove_Empty_Folders($path = '')
	{	
		if( empty($path))
		{
			$upload = wp_upload_dir();
			$upload_dir = $upload['basedir'];
			$path = $upload['basedir'].'/wppas/banners';
		}
		$empty = true;
		
		foreach (glob($path.DIRECTORY_SEPARATOR."*") as $file)
		{
			$empty &= is_dir($file) && $this->Remove_Empty_Folders($file);
		}
		return $empty && rmdir($path);
	}
	/**
	 * Remove folder + contents
	 */
	public function deleteDir($alphaID, $path = '') {
		if(!empty($alphaID))
		{
			$upload = wp_upload_dir();
			$upload_dir = $upload['basedir'];
			$path = empty($path) ? $upload['basedir'].'/wppas/banners/'.$alphaID : $path;
			
			if (!file_exists($path)) return true;
			if (!is_dir($path)) return unlink($path);
			foreach (scandir($path) as $item) {
				if ($item == '.' || $item == '..') continue;
				if (!$this->deleteDir($alphaID, $path.DIRECTORY_SEPARATOR.$item)) return false;
			}
			return rmdir($path);
			
			
			/*
			if (! is_dir($path)) {
				//throw new InvalidArgumentException($path." must be a directory");
				return;
			}
			if (substr($path, strlen($path) - 1, 1) != '/') {
				$path .= '/';
			}
			
			$files = glob($path . '*', GLOB_MARK);
			foreach ($files as $file) {
				echo $file;
				if (is_dir($file)) {
					$this->deleteDir($alphaID, $file);
				} else {
					unlink($file);
				}
			}
			rmdir($path);
			*/
		}
	}
	
	
	
	
	
	
	
	/**
	 * ALL BANNERS QUERY
	 *
	 */
	public function all_banners_query( $args = array() )
	{
		$defaults = array(
			'posts_per_page'   => -1,
			'offset'           => 0,
			'orderby'          => 'date',
			'order'            => 'DESC',
			'include'          => '',
			'exclude'          => '',
			'meta_key'         => '',
			'meta_value'       => '',
			'post_type'        => 'wppas_banners',
			'post_mime_type'   => '',
			'post_parent'      => '',
			'author'	       => '',
			'author_name'	   => '',
			'post_status'      => 'publish',
			'suppress_filters' => true 
		);
		$args = wp_parse_args( $args, $defaults );
		$banners = get_posts( $args );
		
		return $banners;
	}
	
	
	
	/**
	 * ALL BANNERS
	 *
	 */
	public function all_banners_tpl( $args = array(), $options = array() )
	{
		$html = '';
		$defaults = array(
			'posts_per_page'   => -1,
			'offset'           => 0,
			'orderby'          => 'date',
			'order'            => 'DESC',
			'include'          => '',
			'exclude'          => '',
			'meta_key'         => '',
			'meta_value'       => '',
			'post_type'        => 'wppas_banners',
			'post_mime_type'   => '',
			'post_parent'      => '',
			'author'	       => '',
			'author_name'	   => '',
			'post_status'      => 'publish',
			'suppress_filters' => true 
		);
		$args = wp_parse_args( $args, $defaults );
		$banners = get_posts( $args );
		
		$def_options = array(
			'type' => 'vbc', // vbc | extern
			'new_btn' => 1,
			'import_btn' => 1,
			'view_all_btn' => 0
		);
		$options = wp_parse_args( $options, $def_options );
		$extern_str = $options['type'] == 'extern' ? '&type=extern' : '';
		
		
		$html.= '<ul id="all_vbc_items" class="wppas_actions">';
		
			if( !empty($banners))
			{
				foreach($banners as $i => $banner)
				{
					$html.= $this->all_banners_item($banner);
				}
			}
		
			// ADD NEW BUTTON
			if($options['new_btn'])
			{
				$html.= '<li class="wppas_action">'; // style="width:10%;"
					$html.= '<div class="wppas_action_meta wppas_action_addnew" style="height:100px;">';
						$html.= '<a href="admin.php?page=wppas-banner-creator&view=editor'.$extern_str.'" title="'.__('New Banner','wpproads').'" style="z-index: 10;position: absolute;text-align: center;width: 100%;height: 100%;color:#333;">';
							$html.= '<span class="wppas_icon_wrapper wppas_banner" style="line-height: 70px;">';
								$html.= '<i class="fa fa-plus" aria-hidden="true"></i>';
							$html.= '</span>';
						 $html.= '</a>';
						
						 $html.= '<span class="wppas_action_info" style="left:0; z-index:999;">';
							 $html.= '<span class="wppas_action_title_wrapper">';		
								$html.= '<a href="admin.php?page=wppas-banner-creator&view=editor" title="'.__('New Banner','wpproads').'">';
									$html.= '<span class="wppas_action_title" style="font-size: 10px;max-width: 90%;max-height: 15px;overflow: hidden;display: inline-block;">'.__('New Banner','wpproads').'</span>';	
									//$html.= '<div class="float_right"><i class="fa fa-pencil" aria-hidden="true" style="margin-right: 5px;"></i></div>';
								$html.= '</a>';			
							$html.= '</span>';
						$html.= '</span>';
					$html.= '</div>';
				$html.= '</li>';
			}
			
			// VIEW ALL BUTTON
			if($options['view_all_btn'])
			{
				$html.= '<li class="wppas_action">'; // style="width:10%;"
					$html.= '<div class="wppas_action_meta wppas_action_addnew" style="height:100px;">';
						$html.= '<a href="admin.php?page=wppas-banner-creator" title="'.__('All Banners','wpproads').'" style="z-index: 10;position: absolute;text-align: center;width: 100%;height: 100%;color:#333;">';
							$html.= '<span class="wppas_icon_wrapper wppas_banner" style="line-height: 70px;">';
								$html.= '<i class="fa fa-list" aria-hidden="true"></i>';
							$html.= '</span>';
						 $html.= '</a>';
						
						 $html.= '<span class="wppas_action_info" style="left:0; z-index:999;">';
							 $html.= '<span class="wppas_action_title_wrapper">';		
								$html.= '<a href="admin.php?page=wppas-banner-creator" title="'.__('All Banners','wpproads').'">';
									$html.= '<span class="wppas_action_title" style="font-size: 10px;max-width: 90%;max-height: 15px;overflow: hidden;display: inline-block;">'.__('All Banners','wpproads').'</span>';	
									//$html.= '<div class="float_right"><i class="fa fa-pencil" aria-hidden="true" style="margin-right: 5px;"></i></div>';
								$html.= '</a>';			
							$html.= '</span>';
						$html.= '</span>';
					$html.= '</div>';
				$html.= '</li>';
			}
			
			// IMPORT BUTTON
			if( $options['type'] == 'vbc' && $options['import_btn'] )
			{
				$html.= '<li class="wppas_action" style="width:10%;">';
					$html.= '<div class="wppas_action_meta wppas_action_import" style="height:100px;">';
						$html.= '<a title="'.__('Import Banner','wpproads').'" style="z-index: 10;position: absolute;text-align: center;width: 100%;height: 100%;color:#333;">';
							$html.= '<span class="wppas_icon_wrapper wppas_banner" style="line-height: 70px;">';
								$html.= '<i class="fa fa-download" aria-hidden="true"></i>';
							$html.= '</span>';
						 $html.= '</a>';
						
						 $html.= '<span class="wppas_action_info" style="left:0; z-index:999;">';
							 $html.= '<span class="wppas_action_title_wrapper">';		
								$html.= '<a title="'.__('Import Banner','wpproads').'">';
									$html.= '<span class="wppas_action_title" style="font-size: 10px;max-width: 90%;max-height: 15px;overflow: hidden;display: inline-block;">'.__('Import Banner','wpproads').'</span>';	
									//$html.= '<div class="float_right"><i class="fa fa-pencil" aria-hidden="true" style="margin-right: 5px;"></i></div>';
								$html.= '</a>';			
							$html.= '</span>';
						$html.= '</span>';
					$html.= '</div>';
					
				$html.= '</li>';
				
			$html.= '</ul>';
			
			// IMPORT popup editor 
			$html.= '<div id="import_itm_form" class="itm_edit_cont wppas_edit_form draggable_container" style="display:none; top: 15%; position: fixed; z-index: 9999; width: 50%; left: 27%;">';
				$html.= '<div class="header drag_handle">';
					$html.= '<i class="fa fa-bars" aria-hidden="true" style="padding: 10px 15px;"></i>';
					$html.= '<a class="wppas_itm_close wppas_itm_close_btn itm_header_btn"><i class="fa fa-close" aria-hidden="true"></i></a>';
					$html.= '<a id="wppas_import" class="wppas_import wppas_itm_save_btn_css itm_header_btn">';
						$html.= '<i class="fa fa-download" aria-hidden="true"></i>';
					$html.= '</a>';
					$html.= '<div class="clearFix"></div>';
				$html.= '</div>';
				$html.= '<div id="itm_edit_content_container">';
					
					$html.= '<div style="padding:10px 20px">';
						// Export code
						$html.= WPPAS_TPL::textarea_cont(array(
							'id' => 'wppas_import_code',
							'title' => __('Import code','wpproads'),
							'desc' => __('Import code.','wpproads'),
							'size' => 'one_second'
						));
						$html.= $this->add_itm_zip_form(array(
							'title' => __('Upload HTML5 folder (.zip)','wpproads'),
							'desc' => __('Upload HTML5 folders. Make sure they are compressed into a .zip file.','wpproads'),
							'size' => 'one_second'
						));
						/*$html.= '<span class="input_container">';
							$html.= '<h5 style="margin:0;">'.__('Import code','wpproads').'</h5>';
							$html.= '<div class="import_cd_cont">';
								
								$html.= '<textarea id="wppas_import_code" style="width:100%; height:150px; font-size: 11px; font-weight: normal;"></textarea>';
								$html.= '<span class="description bottom">'.__('Import code.','wpproads').'</span>';
								
							$html.= '</div>';
						$html.= '</span>';*/
						
					$html.= '</div>';
					
					$html.= '<div class="clearFix"></div>';
					$html.= '<div class="footer">';
						$html.= '<div class="wppas_import button-secondary green">'.__('Import','wpproads').'</div>';
						$html.= '<div class="wppas_itm_close button-secondary" style="margin-left: 10px;">'.__('Cancel','wpproads').'</div>';
					$html.= '</div>';
					
					$html.= '<div class="clearFix"></div>';	
					
				$html.= '</div>';
			$html.= '</div>';
			// end popup editor
			
			
			// JS
			$html.= '<script>';
				$html.= 'jQuery(document).ready(function($){';
					// make import popup draggable
					$html.= '$(\'.draggable_container\').draggable({ handle: ".drag_handle" });';
					
					// open import popup
					$html.= "$('.wppas_action_import').on('click', function(){";
						$html.= "$('#import_itm_form').show();";
					$html.= '});';
					
					// Import
					$html.= "$('.wppas_import').on('click', function(){";
						
						$html.= 'var code = JSON.parse($("#wppas_import_code").val());';
						$html.= 'var bdata = JSON.parse(code.banner_data);';
						$html.= 'var bhtml = JSON.parse(code.banner_html);';
						
						//$html.= 'console.log( code.banner_data );';
						
						$html.= "$.ajax({";
						   $html.= 'type: "POST",';
						   $html.= 'url: ajaxurl,';
						   $html.= 'data: "action=save_vbc_banner&banners="+encodeURIComponent(JSON.stringify( bhtml ))+"&data="+encodeURIComponent(JSON.stringify( bdata ))+"&bid=0&return=bitm"';
						$html.= '}).done(function( msg ) {';
							$html.= 'console.log(msg);';
							$html.= 'console.log("IMPORTED SUCCESS");';
							//$html.= 'var bid = msg;';
							$html.= "$('#all_vbc_items').prepend(msg);";
							$html.= "$('.itm_edit_cont').hide();";
						$html.= '});';
					$html.= "});";
					
					// close import popup
					$html.= "$('body').on('click', '.wppas_itm_close', function(event){";
						$html.= "$('.itm_edit_cont').hide();";
					$html.= "});";
				$html.= '});';
			$html.= '</script>';
		}
		
		return $html;	
	}
	
	
	
	
	
	
	public function all_banners_item($banner)
	{
		$banner = is_array($banner) ? $banner : get_post($banner);
		$banner_data = $this->load_banner_data($banner->ID);
		$status = array_key_exists('status', $banner_data['banner_data'][0]) ? $banner_data['banner_data'][0]['status'] : 'active';
		$draggable_class = $status == 'active' ? ' wppas_draggable' : '';
		$cursor = $status == 'active' ? 'move' : 'default';
		$size = WPPAS_TPL::vbc_data(array('id' => $banner->ID, 'type' => 'size', 'default' => '300x250'));
		
		$html = '';
		$html.= '<li class="wppas_action'.$draggable_class.'" data-id="'.$banner->ID.'" data-size="'.$size.'">';
			$html.= '<div class="wppas_action_meta wppas_action_addnew '.$status.'" style="height:100px;">';
				$html.= '<a style="cursor:'.$cursor.'; z-index: 10;position: absolute;text-align: center;width: 100%;height: 100%;"></a>';
				 
				 $html.= '<div class="wppas_bnr_preview '.$status.'">';
					$html.= $this->load_banner(array('bid' => $banner->ID));
					//$html.= do_shortcode('[wpproads_banner id="'.$banner->ID.'"]');
				 $html.= '</div>';
				 $html.= '<span class="wppas_action_info '.$status.'" style="left:0; z-index:999;">';
					 $html.= '<span class="wppas_action_title_wrapper">';		
						$html.= '<a href="admin.php?page=wppas-banner-creator&view=editor&bid='.$banner->ID.'" title="'.$banner->post_title.'">';
							$html.= '<span class="wppas_action_title" style="font-size: 10px;max-width: 90%;max-height: 15px;overflow: hidden;display: inline-block;">'.$banner->post_title.'</span>';	
						$html.= '</a>';
						
						// TOOLS
						$html.= '<div class="tools">';
							$html.= '<a class="tool" href="admin.php?page=wppas-banner-creator&view=editor&bid='.$banner->ID.'" title="'.__('Edit Banner','wpproads').'"><i class="fa fa-pencil" aria-hidden="true"></i></a>';
							//$html.= '<a class="tool"><i class="fa fa-pencil" aria-hidden="true"></i></a>';
						$html.= '</div>';	
								
					$html.= '</span>';
				$html.= '</span>';
			$html.= '</div>';
			
			/*$html.= '<div class="extra_tools">';
				$html.= '<a href="admin.php?page=wp-pro-ads-stats&group=banner&group_id='.$banner->ID.'">';
					$html.= '<i class="fa fa-area-chart" aria-hidden="true"></i>';
					$html.= '<span>'.__('Statistics','wpproads').'</span>';
				$html.= '</a>';
			$html.= '</div>';
			$html.= '';*/
		$html.= '</li>';	
		
		return $html;
	}
	
	
	
	
	
	
	
	public function adzone_linked_banner_item($bannerID)
	{
		$data = $this->load_banner_data($bannerID);
		$size = WPPAS_TPL::vbc_data(array('id' => $bannerID, 'type' => 'size', 'default' => '300x250'));
		$order = WPPAS_BuySell::load_order(array('query' => "WHERE banner_id = ".$bannerID." ORDER BY id DESC LIMIT 1"));
		$bs_data = WPPAS_BuySell::get_buysell_data();
		$pos_am = !empty($order) && !empty($order[0]->pos) ? $order[0]->pos : 0;
		$pos_str = !empty($pos_am) ? '<span style="color:#555;">('.__('Paid:','wpproads').' '.$pos_am.' '.$bs_data['cur'].')</span> ' : '';
		
		$html = '';
		$html.= '<li class="wppas_action wppas_draggable itm_'.$bannerID.'" data-id="'.$bannerID.'" data-size="'.$size.'" style="cursor:move;">';
			$html.= '<div class="wppas_action_meta wppas_action_addnew" style="height:100px;">';
				$html.= '<a style="cursor:move; z-index: 10;position: absolute;text-align: center;width: 100%;height: 100%;"></a>';
				 
				 $html.= '<div style="position:relative;">';
					$html.= $this->load_banner(array('bid' => $bannerID));
					$html.= '<div style="position:absolute; z-index:100; width:100%; height:100%; top:0; left:0;"></div>';
				 $html.= '</div>';
				 $html.= '<span class="wppas_action_info" style="left:0; z-index:999;">';
					 $html.= '<span class="wppas_action_title_wrapper">';		
						$html.= '<a style="cursor:default;">';
							$html.= '<span class="wppas_action_title" style="font-size: 10px;max-width: 90%;max-height: 15px;overflow: hidden;display: inline-block;">'.$pos_str.$data['banner']->post_title.'</span>';	
						$html.= '</a>';
						
						// TOOLS
						$html.= '<div class="tools">';
							$html.= '<a class="tool unlink_banner" data-id="'.$bannerID.'" title="'.__('Remove Banner','wpproads').'"><i class="fa fa-times" aria-hidden="true"></i></a>';
						$html.= '</div>';	
								
					$html.= '</span>';
				$html.= '</span>';
			$html.= '</div>';
			
		$html.= '</li>';	
		
		return $html;
	}
	
	
	
	
	
	
	/**
	 * CREATE LINK
	 *
	 */
	public function create_link($banner = array(), $options = array()) 
	{
		global $pro_ads_banners, $pro_ads_multisite;
		
		$banner_link = $this->vbc_banner_data(array('bid' => $banner['banner']->ID, 'type' => 'link', 'default' => ''));
		//$banner['banner_data'][0]['link'];
		$is_buysell = !empty($options) && array_key_exists('buysell', $options) ? $options['buysell'] : 0;
		$adzone_id = !empty($options) && array_key_exists('adzone', $options) ? $options['adzone'] : 0;
		
		if( !empty($banner_link) && !$is_buysell )
		{
			$banner_id = $banner['banner']->ID;
			$target = $this->vbc_banner_data(array('bid' => $banner_id, 'type' => 'target', 'default' => '_blank'));
			$ref_url = '';
			$remove_link_masking  = 0;
			$mod_rewrite       = get_option( 'wpproads_enable_mod_rewrite', 0);
			$mod_rewrite_str   = get_option('wp_ads_mod_rewrite', 'pas');
			
			// Create link
			//echo '<pre>'.print_r($banner['banner_data'][0],true).'</pre><br>';
			if( empty($remove_link_masking) )
			{
				if( !$mod_rewrite )
				{
					$adzone_str = !empty($adzone_id) ? '&amp;pasZONE='.base64_encode($adzone_id) : '';
					$ref_url_str = !empty($ref_url) ? '&amp;pasREF='.base64_encode($ref_url) : '';
					$link = !empty($banner_link) ? $pro_ads_multisite->wpproads_get_site_url().'?pasID='.base64_encode($banner_id).$adzone_str.$ref_url_str : '';
				}
				else
				{
					$adzone_str = !empty( $adzone_id ) ? $adzone_id : 0;
					$banner_slug = get_post( $banner['banner_data'][0]['ID'] )->post_name;
					$adzone_slug = !empty($adzone_str ) ? get_post( $adzone_str )->post_name : '0';
					$ref_url_slug = !empty($ref_url) ? '/'.base64_encode($ref_url) : '/0';
					$link = !empty( $banner_link ) ? $pro_ads_multisite->wpproads_get_site_url().'/'.$mod_rewrite_str.'/'.$banner_slug.'/'.$adzone_slug.$ref_url_slug : '';
				}
			}
			else
			{
				$link = !empty( $banner_link ) ? $banner_link : '';
			}
			
			return $link;
		}
		else
		{
			if( $is_buysell )
			{
				$data = WPPAS_BuySell::get_buysell_data();
				return $data['order_page'].'?adzone='.$adzone_id;	
			}
		}
	}
	
	
	
	
	
	
	
	/*
	 * Check if banner has to be displayed based on the campaign status and other user defined options. (does the banner has to be showen?)
	 * @since v5.1.9 - ALSO WORKS FOR ADZONES
	 *
	 * @param array $banner_id (int), $options array()
	 * @access public
	 * @return array
	*/
	public function show_or_hide_banner( $banner_id, $options = array() )
	{
		global $pro_ads_main, $pro_ads_campaigns, $pro_ads_responsive, $pro_geo_targeting_main;
		
		$show = 1;
		$post_type = get_post_type( $banner_id );
		$is_banner = $post_type == 'wppas_banners' ? 1 : 0;
		
		if( !empty( $banner_id ))
		{
			$banner_data = $is_banner ? $this->load_banner_data($banner_id) : array();
			
			// Check if banner is published (not in trash)
			if( get_post_status( $banner_id ) != 'publish' )
			{
				$show = 0;
				return $show;
			}
			
			// Check if banner is active
			if( $is_banner )
			{
				$banner_status = $this->vbc_banner_data(array('bid' => $banner_id, 'type' => 'status', 'default' => 'active'));
				if( $banner_status != 'active' )
				{
					$show = 0;
					return $show;
				}
			
				// Check if campaign is active
				$campaign_id = !empty($banner_data['banner_data'][0]['campaign']) ? $banner_data['banner_data'][0]['campaign'] : 0;
				if( !empty($campaign_id))
				{
					$campaign_status = $pro_ads_campaigns->check_campaign_status( $campaign_id );
					
					if($campaign_status != 1 )
					{
						$show = 0;
						return $show;
					}
				}
			}
			
			// Extra Options
			if( !empty($options) )
			{
				// Hide for device
				if( array_key_exists('hide', $options))
				{
					$devices = explode(',', $options['hide']);
					foreach( $devices as $device )
					{
						if( $device == 'mobile' && WPPAS_Detect::device(array('is' => 'is_mobile')) )
						{
							return 0;
						}
						elseif( $device == 'tablet' && WPPAS_Detect::device(array('is' => 'is_tablet')) )
						{
							return 0;
						}
						elseif( $device == 'desktop' )
						{
							if( !WPPAS_Detect::device(array('is' => 'is_tablet')) && !WPPAS_Detect::device(array('is' => 'is_mobile')) )
							{
								return 0;
							}
						}
						elseif( $device == 'ios' && WPPAS_Detect::device(array('is' => 'is_ios')) )
						{
							return 0;
						}
						elseif( $device == 'android' && WPPAS_Detect::device(array('is' => 'is_android')) )
						{
							return 0;
						}
						elseif( $device == 'samsung' && WPPAS_Detect::device(array('is' => 'is_samsung')) )
						{
							return 0;
						}
						elseif( $device == 'windows_mobile' && WPPAS_Detect::device(array('is' => 'is_windows_mobile')) )
						{
							return 0;
						}
						elseif( $device == 'blackberry' && WPPAS_Detect::device(array('is' => 'is_blackberry')) )
						{
							return 0;
						}
						elseif( $device == 'sony_ericsson' && WPPAS_Detect::device(array('is' => 'is_sony_ericsson')) )
						{
							return 0;
						}
						elseif( $device == 'motorola' && WPPAS_Detect::device(array('is' => 'is_motorola')) )
						{
							return 0;
						}
						elseif( $device == 'iphone' && WPPAS_Detect::device(array('is' => 'is_iphone')) )
						{
							return 0;
						}
						elseif( $device == 'ipad' && WPPAS_Detect::device(array('is' => 'is_ipad')) )
						{
							return 0;
						}
						elseif( $device == 'ipod' && WPPAS_Detect::device(array('is' => 'is_ipod')) )
						{
							return 0;
						}
					}
				}
			}
			
			
			// Hide for Specific categorys
			$taxonomies = get_taxonomies();
			$showhide = WPPAS_TPL::vbc_data(array('id' => $banner_id, 'type' => 'showhide', 'default' => 0));
			$categories = WPPAS_TPL::vbc_data(array('id' => $banner_id, 'type' => 'hide_for_categories', 'default' => ''));
			$tags = WPPAS_TPL::vbc_data(array('id' => $banner_id, 'type' => 'hide_for_tags', 'default' => ''));
			$taxo = wp_parse_args( $categories, $tags );
			
			if( !empty($taxo))
			{
				foreach($taxonomies as $taxonomy)
				{
					$terms = wp_get_post_terms( get_the_ID(), $taxonomy );
					if( !empty($terms))
					{
						foreach($taxo as $cat )
						{
							foreach($terms as $term)
							{
								if($cat == $term->term_id)
								{
									return $showhide;
									//return 0;
								}
							}
						}
					}
				}
			}
			
			// Hide for Specific Posts
			$all_posts = get_posts(array(
				'posts_per_page'   => -1,
				'post_status'      => 'publish',
				'post_type'        => apply_filters( 'wpproads_hide_posts', array('post'))
			));
			$posts = WPPAS_TPL::vbc_data(array('id' => $banner_id, 'type' => 'hide_for_posts', 'default' => ''));
			//$posts = $this->vbc_banner_data(array('bid' => $banner_id, 'type' => 'hide_for_posts', 'default' => ''));
			
			if( !empty($posts))
			{
				$curID = get_the_ID();
				if( !empty($curID))
				{
					if( in_array($curID, $posts))
					{
						return $showhide;
						//return 0;	
					}
				}
			}
			
			
			// Hide for Specific Pages
			$all_posts = get_posts(array(
				'posts_per_page'   => -1,
				'post_status'      => 'publish',
				'post_type'        => apply_filters( 'wpproads_hide_pages', array('page'))
			));
			$posts = WPPAS_TPL::vbc_data(array('id' => $banner_id, 'type' => 'hide_for_pages', 'default' => ''));
			//$posts = $this->vbc_banner_data(array('bid' => $banner_id, 'type' => 'hide_for_pages', 'default' => ''));
			
			if( !empty($posts))
			{
				$curID = get_the_ID();
				if( !empty($curID))
				{
					if( in_array($curID, $posts))
					{
						return $showhide;
						//return 0;	
					}
				}
			}
			
			
			
			/**
			 * TO DO...
			 *
			 *
					
			/*
			 * ADD-ON: Geo Targeting
			 *
			 *_______________________________________________________________________________________________________________
			 * Check if "Geo Targeting Plugin" is installed.
			*/
			/*if( $pro_ads_main->pro_geo_targeting_is_active() )
			{
				if( !$pro_geo_targeting_main->show_content( $bid ) )
				{
					$linked_banner_ids = array_diff($linked_banner_ids, array($bid));
				}
			}*/
			/*
			 *_______________________________________________________________________________________________________________
			*/
			
		}
		
		/*
		 * Filter for developers to adjust adzone linked banners.
		*/
		//$linked_banner_ids = apply_filters( 'wp_pro_ads_adzone_linked_banners', $linked_banner_ids);
		
		return $show;
	}
	
	
	
	
	/**
	 * UPDATE BANNER STATUS
	 */
	public function update_banner_status($args = array())
	{
		$defaults = array(
			'bid'    => 0,
			'reset'  => 0
		);
		$args = wp_parse_args( $args, $defaults );
		
		$data = $this->load_banner_data($args['bid']);
		$contract = $this->vbc_banner_data(array('bid' => $args['bid'], 'type' => 'contract', 'default' => ''));
		$duration = $this->vbc_banner_data(array('bid' => $args['bid'], 'type' => 'duration', 'default' => ''));
		$status = $this->vbc_banner_data(array('bid' => $args['bid'], 'type' => 'status', 'default' => 'active'));
		$expired = 0;
		$amount = 0;
		
		if( !empty($contract) && !empty($duration) )
		{
			if($contract == 'ppc')
			{
				$amount = get_post_meta( $args['bid'], '_wpproads_banner_clicks', true );	
			}
			elseif($contract == 'ppv')
			{
				$amount = get_post_meta( $args['bid'], '_wpproads_banner_impressions', true );	
			}
			else
			{
				$start_date = get_post_time('U', true, $args['bid']);
				$datediff = current_time('timestamp') - $start_date;
				$amount = floor($datediff / (60 * 60 * 24));
				//$day_str = $duration > 1 ? 'days' : 'day';
				//$end_date = strtotime('+'.$duration.' '.$day_str, $start_date);
			}
			
			
			$expired = $amount >= $duration ? 1 : $expired;
			if( $expired )
			{
				$data['banner_data'][0]['status'] = 'expired';
				
				update_post_meta($args['bid'], '_wpproads_banner_data', $data['banner_data'][0]);
				WPPAS_BuySell::update_order(array('banner_id' => $args['bid'], 'query' => "status = 'expired'"));
			}
			else
			{
				if($args['reset'])
				{
					$data['banner_data'][0]['status'] = 'active';
					update_post_meta($args['bid'], '_wpproads_banner_data', $data['banner_data'][0]);
				}
			}
		}
	}
	
	/**
	 * RESET BANNER STATS - for contracts
	 */
	public function reset_banner_stats($args = array())
	{
		$defaults = array(
			'ID'    => 0,
			'date'  => 0
		);
		$args = wp_parse_args( $args, $defaults );
		
		update_post_meta( $args['ID'], '_wpproads_banner_clicks', 0);
		update_post_meta( $args['ID'], '_wpproads_banner_impressions', 0);
		
		// Update banner creation date
		if($args['date'])
		{
			$time = current_time('mysql');
			wp_update_post(
				array (
					'ID'            => $args['ID'],
					'post_date'     => $time,
					'post_date_gmt' => get_gmt_from_date( $time )
				)
			);
		}
				
		// Update banner status
		$this->update_banner_status(array('bid' => $args['ID'], 'reset' => 1));
	}
	
	
	
	
	public function device_sizes($view = '')
	{
		$sizes = array(
			'phone_portrait' => array(
				'min' => '320',
				'max' => '736'
			),
			'tablet_portrait' => array(
				'min' => '737',
				'max' => '1023'
			),
			'desktop' => array(
				'min' => '1024',
				'max' => '1600'
			)
		);
		
		return empty($view) ? $sizes : $sizes[$view];
	}
	
	
	
	
	
	public function screen_sizes( $size = '' )
	{
		$sizes = array(
			175 => array(
				'view' => 'mobile',
				'size' => 175
			),
			234 => array(
				'view' => 'mobile',
				'size' => 234
			),
			320 => array(
				'view' => 'mobile',
				'size' => 320
			),
			375 => array(
				'view' => 'mobile',
				'size' => 375
			),
			440 => array(
				'view' => 'mobile',
				'size' => 440
			),
			560 => array(
				'view' => 'mobile',
				'size' => 560
			),
			600 => array(
				'view' => 'tablet',
				'size' => 600
			),
			800 => array(
				'view' => 'tablet',
				'size' => 800
			),
			940 => array(
				'view' => 'tablet',
				'size' => 940
			),
			1024 => array(
				'view' => 'tablet',
				'size' => 1024
			),
			1200 => array(
				'view' => 'desktop',
				'size' => 1200
			)
		);
		
		return empty($size) ? $sizes : $sizes[$size];	
	}
	
	
	
	public function save_confirms()
	{
		$array = array(
			__('SAVED','wpproads'),
			__('SICK','wpproads'),
			__('NICE','wpproads'),
			__('SWEET','wpproads')
		);
		
		wp_localize_script( 'WPPAS_VBC_EDITR', 'itm_editor_save_confirms', array('array' => json_encode($array)) );
		return $array;
	}
	
	
	
	public function banner_sizes( $args = array() )
	{
		$defaults = array(
			'type'        => '', // square
			'size'        => '' // 300x250
		);
		
		$args = wp_parse_args( $args, $defaults );
		
		$banners = array(
			// square banners
			'square' => array(
				'125x125' => array(
					'name' => 'square button',
					'size' => '125x125',
					'w'    => 125,
					'h'    => 125
				),
				'300x250' => array(
					'name' => 'medium rectangle',
					'size' => '300x250',
					'w'    => 300,
					'h'    => 250
				),
			),
			
			// horizontal banners
			'horizontal' => array(
				'234x60' => array(
					'name' => 'half banner',
					'size' => '234x60',
					'w'    => 234,
					'h'    => 60
				),
				'468x60' => array(
					'name' => 'full banner',
					'size' => '468x60',
					'w'    => 468,
					'h'    => 60
				),
				'728x90' => array(
					'name' => 'leaderboard',
					'size' => '728x90',
					'w'    => 728,
					'h'    => 90
				),
				'728x300' => array(
					'name' => 'pop-under',
					'size' => '728x300',
					'w'    => 728,
					'h'    => 300
				),
				'828x315' => array(
					'name' => 'Facebook cover',
					'size' => '828x315',
					'w'    => 828,
					'h'    => 315,
					'prev_class' => 'fb',
					'conversion' => array(
						'w' => 91,
						'h' => 38
					)
				),
				'1200x900' => array(
					'name' => 'Facebook post',
					'size' => '1200x900',
					'w'    => 1200,
					'h'    => 900,
					'prev_class' => 'fb',
					'conversion' => array(
						'w' => 58,
						'h' => 54
					)
				),
				'1024x512' => array(
					'name' => 'Twitter post',
					'size' => '1024x512',
					'w'    => 1024,
					'h'    => 512,
					'prev_class' => 'twitter',
					'conversion' => array(
						'w' => 58,
						'h' => 49
					)
				),
				'1500x500' => array(
					'name' => 'Twitter cover',
					'size' => '1500x500',
					'w'    => 1500,
					'h'    => 500,
					'prev_class' => 'twitter',
					'conversion' => array(
						'w' => 91,
						'h' => 55
					)
				),
				'1080x1080' => array(
					'name' => 'Instagram post',
					'size' => '1080x1080',
					'w'    => 1080,
					'h'    => 1080,
					'prev_class' => 'instagram',
					'conversion' => array(
						'w' => 52,
						'h' => 52
					)
				),
				'1200x628' => array(
					'name' => 'Instagram AD',
					'size' => '1200x628',
					'w'    => 1200,
					'h'    => 628,
					'prev_class' => 'instagram',
					'conversion' => array(
						'w' => 91,
						'h' => 60
					)
				),
				'1080x608' => array(
					'name' => 'Google Plus cover',
					'size' => '1080x608',
					'w'    => 1080,
					'h'    => 608,
					'prev_class' => 'google_plus',
					'conversion' => array(
						'w' => 91,
						'h' => 58
					)
				),
				'1400x425' => array(
					'name' => 'LinkedIn cover',
					'size' => '1400x425',
					'w'    => 1400,
					'h'    => 425,
					'prev_class' => 'in',
					'conversion' => array(
						'w' => 91,
						'h' => 48
					)
				)
			),
			
			// Vertical Banners
			'vertical' => array(
				'120x240' => array(
					'name' => 'vertical banner',
					'size' => '120x240',
					'w'    => 120,
					'h'    => 240
				),
				'240x400' => array(
					'name' => 'vertical rectangle',
					'size' => '240x400',
					'w'    => 240,
					'h'    => 400
				),
				'120x600' => array(
					'name' => 'skyscraper',
					'size' => '120x600',
					'w'    => 120,
					'h'    => 600
				),
				'160x600' => array(
					'name' => 'wide skyscraper',
					'size' => '160x600',
					'w'    => 160,
					'h'    => 600
				),
				'240x600' => array(
					'name' => 'extra wide skyscraper',
					'size' => '240x600',
					'w'    => 240,
					'h'    => 600
				),
				'300x600' => array(
					'name' => 'half page ad',
					'size' => '300x600',
					'w'    => 300,
					'h'    => 600
				),
				'600x1200' => array(
					'name' => 'Pintrest post',
					'size' => '600x1200',
					'w'    => 600,
					'h'    => 1200,
					'prev_class' => 'pintrest',
					'conversion' => array(
						'w' => 50,
						'h' => 69
					)
				),
				'1080x1920' => array(
					'name' => 'Snapchat post',
					'size' => '1080x1920',
					'w'    => 1080,
					'h'    => 1920,
					'prev_class' => 'snapchat',
					'conversion' => array(
						'w' => 60,
						'h' => 74
					)
				),
			),
			'extras' => array(
				'fullxfull' => array(
					'name' => '100% - full width/height',
					'size' => 'fullxfull',
					'w'    => 'full',
					'h'    => 'full'
				),
			)
		);
		
		// return
		if( !empty($args['type']) && !empty($args['size']) )
		{
			return $banners[$args['type']][$args['size']];
		}
		elseif( !empty($args['type']) )
		{
			return $banners[$args['type']];
		}
		else
		{
			return $banners;
		}	
	}
	
	
	
	
	
	public function itm_types()
	{
		$types = array(
			'text' => array(
				'icon' => '<i class="fa fa-font" aria-hidden="true"></i>',
				'label' => __('Text','wpproads')
			),
			'image' => array(
				'icon' => '<i class="fa fa-picture-o" aria-hidden="true"></i>',
				'label' => __('Image','wpproads')	
			),
			'square' => array(
				'icon' => '<i class="fa fa-square" aria-hidden="true"></i>',
				'label' => __('Square','wpproads')	
			),
			'circle' => array( 
				'icon' => '<i class="fa fa-circle" aria-hidden="true"></i>',
				'label' => __('Circle','wpproads')	
			)
		);
		
		return $types;	
	}
	
	
	
	public function vbc_loader($args = array())
	{
		$defaults = array(
			'w'        => 120, 
			'h'        => 120
		);
		
		$args = wp_parse_args( $args, $defaults );
		
		$html = '';
		$html.= '<svg width="'.$args['w'].'px" height="'.$args['h'].'px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100" preserveAspectRatio="xMidYMid" class="uil-hourglass"><rect x="0" y="0" width="100" height="100" fill="none" class="bk"></rect><g><path fill="none" stroke="#A7E482" stroke-width="5" stroke-miterlimit="10" d="M58.4,51.7c-0.9-0.9-1.4-2-1.4-2.3s0.5-0.4,1.4-1.4 C70.8,43.8,79.8,30.5,80,15.5H70H30H20c0.2,15,9.2,28.1,21.6,32.3c0.9,0.9,1.4,1.2,1.4,1.5s-0.5,1.6-1.4,2.5 C29.2,56.1,20.2,69.5,20,85.5h10h40h10C79.8,69.5,70.8,55.9,58.4,51.7z" class="glass"></path><clipPath id="uil-hourglass-clip1"><rect x="15" y="20" width="70" height="25" class="clip"><animate attributeName="height" from="25" to="0" dur="1s" repeatCount="indefinite" vlaues="25;0;0" keyTimes="0;0.5;1"></animate><animate attributeName="y" from="20" to="45" dur="1s" repeatCount="indefinite" vlaues="20;45;45" keyTimes="0;0.5;1"></animate></rect></clipPath><clipPath id="uil-hourglass-clip2"><rect x="15" y="55" width="70" height="25" class="clip"><animate attributeName="height" from="0" to="25" dur="1s" repeatCount="indefinite" vlaues="0;25;25" keyTimes="0;0.5;1"></animate><animate attributeName="y" from="80" to="55" dur="1s" repeatCount="indefinite" vlaues="80;55;55" keyTimes="0;0.5;1"></animate></rect></clipPath><path d="M29,23c3.1,11.4,11.3,19.5,21,19.5S67.9,34.4,71,23H29z" clip-path="url(#uil-hourglass-clip1)" fill="#6fa84b" class="sand"></path><path d="M71.6,78c-3-11.6-11.5-20-21.5-20s-18.5,8.4-21.5,20H71.6z" clip-path="url(#uil-hourglass-clip2)" fill="#6fa84b" class="sand"></path><animateTransform attributeName="transform" type="rotate" from="0 50 50" to="180 50 50" repeatCount="indefinite" dur="1s" values="0 50 50;0 50 50;180 50 50" keyTimes="0;0.7;1"></animateTransform></g></svg>';
		
		return $html;	
	}
	
	
	
	public function btn_prev_line( $am = 1 )
	{
		$html = '';
		
		for($i = 0; $i < $am; $i++)
		{
			$html.= '<div class="line"></div>';
		}
		
		return $html;
	}
	
	
	
	public function btn_prev_bg( $nr = 1 )
	{
		// TPL 1
		$tpl_1 = '';
		$tpl_1 .= '<div>';
			$tpl_1 .= $this->btn_prev_line(2);
		$tpl_1 .= '</div>';
		$tpl_1 .= '<div class="clearFix"></div>';
		
		$tpl_1 .= $this->btn_prev_line(4);
		$tpl_1 .= '<div style="float:right; width: 60%;">';
			$tpl_1 .= $this->btn_prev_line(5);
		$tpl_1 .= '</div>';
		$tpl_1 .= '<div style="float:left; width: 34%; height:25px; background:#d6d6d6; margin:2px 0 0 4px;"></div>';
		$tpl_1 .= '<div class="clearFix"></div>';
		$tpl_1 .= $this->btn_prev_line(2);
		
		//TPL 2
		$tpl_2 = '';
		$tpl_2 .= $this->btn_prev_line(3);
        $tpl_2 .= '<div>';
           	$tpl_2 .= $this->btn_prev_line(7);
        $tpl_2 .= '</div>';
       	$tpl_2 .= $this->btn_prev_line(6);
		
		// TPL 3
		$tpl_3 = '';
		$tpl_3 .= '<div>';
        	$tpl_3 .= $this->btn_prev_line(5);
			$tpl_3 .= '<div style="float:left; width: 20%; background:#d6d6d6; height: 12px; margin:3px;"></div>';
			$tpl_3 .= '<div style="float:right; width: 66%;">';
				$tpl_3 .= $this->btn_prev_line(3);
			$tpl_3 .= '</div>';
			$tpl_3 .= '<div class="clearFix"></div>';
			$tpl_3 .= $this->btn_prev_line(6);
		$tpl_3 .= '</div>';
		
		return ${'tpl_'.$nr};
	}
	
	
	
	
	
	
	public function vbc_container_tpl($args = array())
	{
		$defaults = array(
			'bid'     => 0,
			'type'    => 'vbc'
		);
		$args = wp_parse_args( $args, $defaults );
		
		$banner = $this->load_banner_data($args['bid']);
		$args['banner'] = $banner;
		$alphaID = $banner['banner_data'][0]['timeline_arr']['main']['alphaID'];
		?>
        <div class="vbc_container <?php echo $alphaID; ?>">
            
            <div class="wppas_loading_vbc">
				<?php _e('LOADING VISUAL BANNER CREATOR ...','wpproads'); ?>
                <div>
                	<?php echo $this->vbc_loader(); ?>
                </div>
            </div>
            <div class="vbc_main_tabs_container">
                <div id="vbc_main_area" style="display:none;">
                    <ul id="vbc_menu" class="vbc_menu_toggle vbc_main_menu_toggle">
                    	  <li data-link="admin.php?page=wppas-banner-creator">
                            <i class="fa fa-object-ungroup" aria-hidden="true" style="margin-right: 5px;"></i> <?php _e('All Banners','wpproads'); ?>
                        </li>
                        <li class="selected" data-target="vbc-general">
                            <i class="fa fa-cog" aria-hidden="true" style="margin-right: 5px;"></i> <?php _e('Banner Settings','wpproads'); ?>
                        </li>
                        <li data-target="vbc-editor">
                            <i class="fa fa-pencil" aria-hidden="true" style="margin-right: 5px;"></i> <?php _e('Banner Editor','wpproads'); ?>
                        </li>
                        <li class="vbc_export_tab" data-target="vbc-export" data-type="banner">
                            <i class="fa fa-download" aria-hidden="true" style="margin-right: 5px;"></i> <?php _e('Export','wpproads'); ?>
                        </li>
                        <?php
						   if( $args['bid'] )
						   {
								echo '<li data-link="admin.php?page=wp-pro-ads-stats&group=banner&group_id='.$args['bid'].'">';
									echo '<i class="fa fa-area-chart" aria-hidden="true" style="margin-right: 5px;"></i> '.__('Stats','wpproads');
								echo '</li>';
						   }
						   // Allow 3rd parties to add items to the menu.
						   echo apply_filters( 'wppas_banner_menu', '', $args['bid'] );
						   ?>
                        <li class="trash_banner trash right" data-option="vbc-trash">
                            <i class="fa fa-trash" aria-hidden="true" style="margin-right: 5px;"></i>
                        </li>
                        <li class="save_banner save right" data-option="vbc-save">
                            <i class="fa fa-save" aria-hidden="true" style="margin-right: 5px;"></i>
                        </li>
                        <li class="preview_banner preview right" data-option="vbc-preview">
                            <i class="fa fa-search" aria-hidden="true" style="margin-right: 5px;"></i>
                        </li>
                        <?php
						   if( $args['bid'] )
						   {
								echo '<li class="cover right" data-link="'.get_bloginfo('url').'?wppas_download='.$args['bid'].'" data-link_target="_blank">'; //banner_cover
									echo '<i class="fa fa-camera" aria-hidden="true" style="margin-right: 5px;"></i>';
								echo '</li>';
						   }
						   ?>
                     </ul>
                     
                     <!-- content container -->
                     <div id="vbc_content_container">
                        <div id="vbc-general" class="vbc_nfer"><?php echo $this->start_screen_tpl($args); ?></div>
                        <div id="vbc-editor" class="vbc_nfer" style="display:none;">
								<?php 
								// Notice for banners older then v5.1.9
								if( !empty($args['bid']))
								{
									//$data = $this->load_banner_data($args['bid']);
									$timeline_arr = $banner['banner_data'][0]['timeline_arr'];
									if( !array_key_exists('v', $timeline_arr) )
									{
										echo WPPAS_TPL::info_box(array(
											'desc' => __('Editing existing layers for this banner is disabled due to missing variables neccesery for plugin versions above 5.1.9. The banner however will keep working fine, existing layers can still be repositioned and new layers can be added and edited.','wpproads'),
											'icon' => 'info-circle'
										));
									}
									elseif($timeline_arr['v'] < 522)
									{
										echo WPPAS_TPL::info_box(array(
											'desc' => __('Some layers in this banner may not be editable due to missing variables neccesery for plugin versions above 5.2.1. The banner however will keep working fine, existing layers can still be repositioned and new layers can be added and edited.','wpproads'),
											'icon' => 'info-circle'
										));
									}
								}
								
								if( $args['type'] == 'vbc' )
								{
									echo $this->editor_template($args); 
								}
								?>
                        </div>
                        <div id="vbc-export" class="vbc_nfer" style="display:none;"><?php echo $this->export_template($args); ?></div>
                    </div>
                </div>
            </div>
            <!-- end .vbc_main_tabs_container -->
            
            <div class="vbc_loader_bg"></div>
            <div class="vbc_loader_duration">
            	<div class="vbc_loader">
            		<?php echo $this->vbc_loader(); ?>
                </div>
            </div>
            <div class="vbc_saved_confirm"><div class="vbc_conf_txt"><?php _e('SAVED','wpproads'); ?></div></div>
            <?php
			 echo WPPAS_TPL::full_page_modal(array(
			 	'id' => 'vbc_preview_container'
			 ));
			 ?>
            <!--<div class="vbc_preview_container">
            	<div class="preview_cont"></div>
            </div>-->
         </div>
         <!-- end .vbc_container -->
         <?php
	}
	
	
	/**
	 * Get banner data or default values.
	 *
	 */
	public function vbc_banner_data($args = array())
	{
		$defaults = array(
			'bid'      => 0, 
			'type'     => 'size',
			'default'  => '300x250'
		);
		$args = wp_parse_args( $args, $defaults );
		
		$banner = $this->load_banner_data($args['bid']);
		$result = !empty($banner['banner_data'][0][$args['type']]) ? $banner['banner_data'][0][$args['type']] : $args['default'];
		
		return $result;
	}
	
	
	
	public function start_screen_tpl($args = array())
	{
		global $pro_ads_advertisers, $pro_ads_campaigns;
		
		$defaults = array(
			'bid'    => 0, 
			'banner' => array()
		);
		$args = wp_parse_args( $args, $defaults );
		$banner = !empty($args['banner']) ? $args['banner'] : $this->load_banner_data($args['bid']);
		$alphaID = $banner['banner_data'][0]['timeline_arr']['main']['alphaID'];
		
		$bsize = WPPAS_TPL::vbc_data(array('id' => $args['bid'], 'type' => 'size', 'default' => '300x250'));
		$bname = !empty($banner['banner']->post_title) ? $banner['banner']->post_title : '';
		$blink = WPPAS_TPL::vbc_data(array('id' => $args['bid'], 'type' => 'link', 'default' => ''));
		$btarget = WPPAS_TPL::vbc_data(array('id' => $args['bid'], 'type' => 'target', 'default' => '_blank'));
		$baspectratio = WPPAS_TPL::vbc_data(array('id' => $args['bid'], 'type' => 'keep_aspect_ratio', 'default' => 1));
		$bscale = WPPAS_TPL::vbc_data(array('id' => $args['bid'], 'type' => 'scale_banner', 'default' => 1));
		//$bcenter = !empty($args['bid']) ? $banner['banner_data'][0]['center'] : 0;
		$bnofollow = WPPAS_TPL::vbc_data(array('id' => $args['bid'], 'type' => 'no_follow', 'default' => 0));
		$post_status = !empty($args['bid']) ? get_post_status($args['bid']) : '';
		
		$html = '';
		
		if( !empty($post_status) && $post_status == 'trash')
		{
			$html.= WPPAS_TPL::info_box(array(
				'desc' => __('NOTE: This banner is trashed.','wpproads'),
				'class' => 'warning',
				'icon' => 'exclamation-triangle'
			));
		}
		
		$html.= '<div class="'.$alphaID.'">';
		
			// HIDDEN FIELDS.
			$html.= '<input type="hidden" id="banner_ID" value="'.$args['bid'].'" />';
			$html.= '<input type="hidden" id="wppas_banner_size" value="'.$bsize.'" />';
			$html.= '<input type="hidden" id="wppas_banner_alpha_id" value="'.$alphaID.'" />';
			
			// -- 1. Banner Title --
			$html.= '<div class="vbc_option_box">';
				$html.= '<div class="info_header">';
					$html.= '<span class="nr">1</span>';
					$html.= '<span class="text">'.__('Banner Title','wpproads').'</span>';
				$html.= '</div>';
				
				$html.= $this->inpt_cont(array(
					'desc' => __('Add a banner title.','wpproads'),
					'id' => 'wppas_banner_name', 
					'placeholder' => __('Banner Title','wpproads'),
					'value' => $bname
				));
				
			$html.= '</div>';
			// end .vbc_option_box	
			
			
			
			// -- 2. Banner Sizing --
			$html.= '<div class="vbc_option_box">';
				$html.= '<div class="info_header">';
					$html.= '<span class="nr">2</span>';
					$html.= '<span class="text">'.__('Banner Sizing','wpproads').'</span>';
				$html.= '</div>';
				
				
				$html.= '<div class="wppas_sep_line">';
					$html.= '<span><strong>'.__("Common banner sizes","wpproads").'</strong></span>';
				$html.= '</div>';
				
				
				$html.= '<div class="wppas_info_btns wppas_banner_sizes">';
					
					$banners = $this->banner_sizes();
					foreach($banners as $group)
					{
						foreach($group as $size )
						{
							$conversion_w = array_key_exists('conversion',$size) ? $size['conversion']['w'] : 0;
							$conversion_h = array_key_exists('conversion',$size) ? $size['conversion']['h'] : 0;
							$prev_class = array_key_exists('prev_class',$size) ? ' '.$size['prev_class'] : '';
							$w = $size['w'] != 'full' ? ($size['w']*100)/800 : 100;
							$h = $size['h'] != 'full' ? ($size['h']*100)/800 : 100;
							$w = !empty($conversion_w) ? $conversion_w : $w;
							$h = !empty($conversion_h) ? $conversion_h : $h;
							$full_class = $w == 100 ? ' full' : '';
							
							$html.= '<a class="wppas_home_tpl_btn bsize" data-type="'.$size['size'].'" edit="0">';
								$html.= '<div class="btn_icon">';
									$html.= '<div class="prev_banner_container">';
										$html.= '<div class="prev_banner'.$full_class.$prev_class.'" style="width:'.$w.'%; height:'.$h.'%;"></div>';
									$html.= '</div>';
									
									//$rand = rand(2, 3);
									$html.= $this->btn_prev_bg(2);
								$html.= '</div>';
								$html.= '<div class="btn_info">';
									$html.= '<h5 style="margin:0; font-size:14px;">'.$size['name'].'</h5>';
									$html.= '<span>'.$size['w'].' x '.$size['h'].'</span>';
								$html.= '</div>';
								$html.= '<div class="clearFix"></div>';
							$html.= '</a>';
						}
					}
					
				$html.= '</div>';
				
				$html.= '<div class="wppas_sep_line">';
					$html.= '<span><strong>'.__("Custom banner size","wpproads").'</strong></span>';
				$html.= '</div>';
				
				$html.= '<div class="wppas_info_btns">';
					
					$w = (100*100)/800;
					$h = (100*100)/800;
					$html.= '<div>';
						$html.= '<div class="wppas_home_tpl_btn" style="width:auto; cursor:default;">';
							$html.= '<div class="btn_icon" style="float:none; opacity:1;">';
								$html.= '<div class="prev_banner_container">';
									$html.= '<div class="prev_banner custom_bsize_preview" style="width:'.$w.'%; height:'.$h.'%;"></div>';
								$html.= '</div>';
								$html.= $this->btn_prev_bg(2);
							$html.= '</div>';
						$html.= '</div>';
					$html.= '</div>';
					
					$html.= '<div style="display:inline-block; width:50%;">';
						
						$html.= WPPAS_TPL::inpt_cont(array(
							'desc' => __('Banner width in pixels.','wpproads'),
							'id' => 'custom_bsize_w', 
							'placeholder' => 100,
							'size' => 'one_third',
							'icon' => 'arrows-h'
						));
						
						$html.= WPPAS_TPL::inpt_cont(array(
							'desc' => __('Banner height in pixels.','wpproads'),
							'id' => 'custom_bsize_h', 
							'placeholder' => 100,
							'size' => 'one_third',
							'icon' => 'arrows-v'
						));
						
					$html.= '</div>';
				$html.= '</div>';
				
				// Advanced sizing options
				$html.= '<div class="wppas_sep_line">';
					$html.= '<span><strong>'.__("Advanced sizing options","wpproads").'</strong></span>';
				$html.= '</div>';
				
				$html.= '<div style="display:inline-block; width:90%; margin-bottom:20px; text-align:left;">';
					
					// Scaling
					$html.= WPPAS_TPL::checkbox_cont(array(
						'title' => __('Scale banner:','wpproads'),
						'desc' => __('Scale the banner when resizing. Turn this ON for optimal responsiveness.','wpproads'),
						'id' => 'bscale',
						'value' => $bscale,
						'size' => 'one_third'
					));
					
					// Aspect ratio
					$html.= WPPAS_TPL::checkbox_cont(array(
						'title' => __('Respect aspect ratio:','wpproads'),
						'desc' => __('Keeps banner aspect ratio. Turn this ON for optimal responsiveness.','wpproads'),
						'id' => 'baspectratio',
						'value' => $baspectratio,
						'size' => 'one_third'
					));
				   
				$html.= '</div>';
				
			$html.= '</div>';
			// end .vbc_option_box
			
			
			
			// -- 3. Banner Link --
			$html.= '<div class="vbc_option_box">';
				$html.= '<div class="info_header">';
					$html.= '<span class="nr">3</span>';
					$html.= '<span class="text">'.__('Banner Link','wpproads').'</span>';
				$html.= '</div>';
				
				$html.= WPPAS_TPL::inpt_cont(array(
					'desc' => __('Add a banner link (URL).','wpproads'),
					'id' => 'wppas_banner_link', 
					'placeholder' => __('http://banner-link.com','wpproads'),
					'value' => $blink,
					'icon' => 'link'
				));
				
				$html.= WPPAS_TPL::select_cont(array(
					'desc' => __('Link target.','wpproads'),
					'id' => 'wppas_banner_target',
					'value' => $btarget,
					'select_opts' => array(
						'_blank' => array('text' => __('_blank, Load in a new window.', 'wpproads')),
						'_self' => array('text' => __('_self, Load in the same frame as it was clicked.', 'wpproads')),
						'_parent' => array('text' => __('_parent, Load in the parent frameset.', 'wpproads')),
						'_top' => array('text' => __('_top, Load in the full body of the window.', 'wpproads')),
					)
				));
				
				// Advanced banner-link options 
				$html.= '<div class="wppas_sep_line">';
					$html.= '<span><strong>'.__("Advanced banner link options","wpproads").'</strong></span>';
				$html.= '</div>';
				
				$html.= '<div style="display:inline-block; width:90%; margin-bottom:20px; text-align:left;">';
					
					// noFollow
					$html.= WPPAS_TPL::checkbox_cont(array(
						'title' => __('No Follow:','wpproads'),
						'desc' => __('Add "No Follow" to banner link.','wpproads'),
						'id' => 'bnofollow',
						'value' => $bnofollow
					));
					
				$html.= '</div>';
				
			$html.= '</div>';
			// end .vbc_option_box	
			
			
			
			// -- 4. Banner Contract Settings --
			$b_status = WPPAS_TPL::vbc_data(array('id' => $args['bid'], 'type' => 'status', 'default' => 'active'));
			$bs_contract = WPPAS_TPL::vbc_data(array('id' => $args['bid'], 'type' => 'contract', 'default' => ''));
			$bs_duration = WPPAS_TPL::vbc_data(array('id' => $args['bid'], 'type' => 'duration', 'default' => ''));
			
			$html.= '<div class="vbc_option_box">';
				$html.= '<div class="info_header">';
					$html.= '<span class="nr">4</span>';
					$html.= '<span class="text">'.__('Contract Settings','wpproads').'</span>';
				$html.= '</div>';
				
				$html.= WPPAS_TPL::select_cont(array(
					'title' => __('Banner Status','wpproads'),
					'desc' => __('Status for this banner','wpproads'),
					'id' => 'wppas_banner_status',
					'class' => $b_status,
					'value' => $b_status,
					'select_opts' => array(
						'active' => array('text' => __('Active', 'wpproads')),
						'draft' => array('text' => __('Draft', 'wpproads')),
						'expired' => array('text' => __('Expired', 'wpproads'))
					),
					'size' => 'one_third'
				));
				
				$html.= WPPAS_TPL::select_cont(array(
					'title' => __('Contract','wpproads'),
					'desc' => __('(optional) Select a contract type for this banner','wpproads'),
					'id' => 'wppas_bs_contract',
					'value' => $bs_contract,
					'select_opts' => array(
						'no_contract' => array('value' => '', 'text' => __('No Contract', 'wpproads')),
						'ppc' => array('text' => __('Pay per Click', 'wpproads')),
						'ppv' => array('text' => __('Pay per View', 'wpproads')),
						'ppd' => array('text' => __('Pay per Day', 'wpproads'))
					),
					'size' => 'one_third'
				));
				
				$html.= WPPAS_TPL::inpt_cont(array(
					'title' => __('Contract Duration','wpproads'),
					'desc' => __('Select a duration for the selected contract type.','wpproads'),
					'id' => 'wppas_bs_duration', 
					'value' => $bs_duration,
					'size' => 'one_third'
				));
				
				// Realtime Contract info
				if( !empty($bs_contract) && !empty($bs_duration))
				{
					$banner_clicks = get_post_meta( $args['bid'], '_wpproads_banner_clicks', true );
					$banner_impressions = get_post_meta( $args['bid'], '_wpproads_banner_impressions', true );
					$html.= '<div style="text-align:left; margin:10px 3%; padding:10px 0; border-top: solid 1px #d8d8d8;">';
						if( $bs_contract == 'ppc' )
						{
							$am = $bs_duration - $banner_clicks;
							$html.= sprintf(__('Banner will expire after <strong>%s</strong> more clicks.','wpproads'), $am);
						}
						elseif( $bs_contract == 'ppv' )
						{
							$am = $bs_duration - $banner_impressions;
							$html.= sprintf(__('Banner will expire after <strong>%s</strong> more impressions.','wpproads'), $am);
						}
						else
						{
							$start_date = get_post_time('U', true, $args['bid']);
							//$html.= date('d.m.Y',$start_date);
							$datediff = current_time('timestamp') - $start_date;
							$days_dif = floor($datediff / (60 * 60 * 24));
							$am = $bs_duration - $days_dif;
							if($am > 0)
							{
								$day_str = $am > 1 ? 'days' : 'day';
								$html.= sprintf(__('Banner will expire in <strong>%s</strong> days <em>on (%s)</em>.','wpproads'), $am, date('d.m.Y',strtotime('+'.$am.' '.$day_str, current_time('timestamp'))));
							}
							else
							{
								$day_str = $am < -1 ? 'days' : 'day';
								$daydiff = current_time('timestamp') - strtotime($am.' '.$day_str, current_time('timestamp'));
								$daydiff = floor($daydiff / (60 * 60 * 24));
								if( $daydiff > 0 )
								{
									$html.= sprintf(__('Banner expired since <strong>%s</strong> days <em>on (%s)</em>.','wpproads'), $daydiff, date('l M j, Y',strtotime($am.' '.$day_str, current_time('timestamp'))));
								}
								else
								{
									$html.= sprintf(__('Banner expired since today <em>(%s)</em>','wpproads'), date('l M j, Y',strtotime($am.' '.$day_str, current_time('timestamp'))));
								}
							}
						}
					$html.= '</div>';
				}
				
			$html.= '</div>';
			// end .vbc_option_box	
			
			
			
			// -- 5. Advertiser & Campaign --
			$advertisers = $pro_ads_advertisers->get_advertisers();
			$_advertiser = WPPAS_TPL::vbc_data(array('id' => $args['bid'], 'type' => 'advertiser', 'default' => 0));
			$campaigns = $pro_ads_campaigns->get_campaigns( array('meta_key' => '_campaign_advertiser_id', 'meta_value' => $_advertiser));
			$_campaign = WPPAS_TPL::vbc_data(array('id' => $args['bid'], 'type' => 'campaign', 'default' => 0));
			
			$html.= '<div class="vbc_option_box">';
				$html.= '<div class="info_header">';
					$html.= '<span class="nr">5</span>';
					$html.= '<span class="text">'.__('Advertiser & Campaign','wpproads').'</span>';
				$html.= '</div>';
				
				// Advertiser
				$html.= '<span class="input_container one_second">';
					$html.= '<h3 style="font-size: 12px;color: #333;">'.__('Advertiser','wpproads').'</h3>';
					$html.= '<select id="wppas_banner_advertiser" class="chosen-select chosen-select-banner-advertiser select_banner_advertiser" required="required" data-placeholder="'.__('Select an advertiser', 'wpproads').'"> <!-- multiple -->';
						$html.= '<option value="">'.__('Select an advertiser', 'wpproads').'</option>';
						
						foreach( $advertisers as $advertiser )
						{
							$select = $_advertiser == $advertiser->ID ? 'selected' : '';
							$html.= '<option value="'.$advertiser->ID.'" '.$select.'>'.$advertiser->post_title.'</option>';
						}
					$html.= '</select>';
					$html.= '<span class="description bottom">'.__('Select the advertiser for this banner.','wpproads').'</span>';
				$html.= '</span>';
				
				// Campaign
				$campaign_id = !empty($_campaign) ? $_campaign : 0;
				$html.= '<span class="input_container one_second">';
					$html.= '<h3 style="font-size: 12px;color: #333;">'.__('Campaign','wpproads').'</h3>';
					$html.= '<div id="select_cont">';
						$html.= '<select id="wppas_banner_campaign" class="chosen-select chosen-select-banner-campaign select_banner_campaign" required="required">';
							$html.= '<option value="">'.__('Select a campaign', 'wpproads').'</option>';
							
							foreach( $campaigns as $campaign )
							{
								$select = $campaign_id == $campaign->ID ? 'selected' : '';
								$html.= '<option value="'.$campaign->ID.'" '.$select.'>'.$campaign->post_title.'</option>';
							}
							
						$html.= '</select>';
					$html.= '</div>';
					$html.= '<span class="description bottom">'.__('Select the campaign for this banner.','wpproads').'</span>';
				$html.= '</span>';
				
			$html.= '</div>';
			// end .vbc_option_box
			
			
			
			// -- 6. Display Options for posts and categories --	
			$html.= '<div class="vbc_option_box">';
				$html.= '<div class="info_header">';
					$html.= '<span class="nr">6</span>';
					$html.= '<span class="text">'.__('Display Options for Posts & Categories','wpproads').'</span>';
				$html.= '</div>';
				
				
				// Add banner to posts automatically
				$all_post_ad = WPPAS_TPL::vbc_data(array('id' => $args['bid'], 'type' => 'auto_show', 'default' => array()));
				$all_post_ad = !empty($all_post_ad) && array_key_exists('post_types', $all_post_ad) ? $all_post_ad['post_types'] : $all_post_ad;
				
				$html.= '<div class="input_container one_third">';
					$html.= '<h3 class="title" style="font-size: 12px;color: #333;">'.__('Add to all posts automatically','wpproads').'</h3>';
					$html.= '<select id="wppas_all_post_ad" name="wppas_all_post_ad[]" data-placeholder="'.__('No post types selected.', 'wpproads').'" class="chosen-select-ad-dashboard" multiple>';
						$html.= '<option value="0">'.__('','wpproads').'</option>';
						
						$post_types = get_post_types();
						if( !empty($post_types ))
						{
							foreach( $post_types as $post_type )
							{
								$exclude = array('attachment', 'revision', 'nav_menu_item', 'vbc_banners');
								if( !in_array( $post_type, PAS()->cpts ) && !in_array( $post_type, $exclude))
								{
									$selected = !empty($all_post_ad) && in_array($post_type, $all_post_ad) ? 'selected' : '';
									$html.= '<option value="'.$post_type.'" '.$selected.'>'.$post_type.'</option>';
								}
							}
						}
					$html.= '</select>';
					$html.= '<span class="description bottom">'.__('Select the post types where you want to show this banner automatically for every post.','wpproads').'</span>';
				$html.= '</div>';
				
				// Position
				$all_ad_pos = WPPAS_TPL::vbc_data(array('id' => $args['bid'], 'type' => 'auto_show', 'default' => array()));
				$all_ad_pos = !empty($all_ad_pos) ? $all_ad_pos['position'] : '';
				
				$html.= WPPAS_TPL::select_cont(array(
					'title' => __('Position','wpproads'),
					'desc' => __('Where do you want to show the banner in the post.','wpproads'),
					'id' => 'wppas_all_post_ad_position',
					'value' => $all_ad_pos,
					'select_opts' => array(
						'top' => array('text' => __('Top of the post', 'wpproads')),
						'middle' => array('text' => __('Middle of the post', 'wpproads')),
						'bottom' => array('text' => __('Bottom of the post', 'wpproads'))
					),
					'size' => 'one_third'
				));
				
				
				// Paragraph
				$all_ad_parag = WPPAS_TPL::vbc_data(array('id' => $args['bid'], 'type' => 'auto_show', 'default' => array()));
				$all_ad_parag = !empty($all_ad_parag) ? $all_ad_parag['paragraph'] : '';
				
				$html.= WPPAS_TPL::inpt_cont(array(
					'title' => __('Paragraphs (number)','wpproads'),
					'desc' => __('Select after how many paragraphs the ad should show (only works if you choose the middle position).','wpproads'),
					'id' => 'wppas_all_post_ad_parag', 
					'placeholder' => 2,
					'value' => $all_ad_parag,
					'size' => 'one_third'
				));
				
				// Shortcode
				$all_ad_sc = WPPAS_TPL::vbc_data(array('id' => $args['bid'], 'type' => 'auto_show', 'default' => array()));
				$all_ad_sc = !empty($all_ad_sc) ? $all_ad_sc['shortcode'] : '';
				
				$html.= WPPAS_TPL::inpt_cont(array(
					'title' => __('<em>(Optional)</em> Shortcode','wpproads'),
					'desc' => __('Add the shortcode here if you want to add extra customized attributes for this banner.','wpproads'),
					'id' => 'wppas_all_post_ad_sc', 
					'value' => $all_ad_sc
				));
				
				
				
				
				// Advanced banner-link options 
				$html.= '<div class="wppas_sep_line">';
					$html.= '<span><strong>'.__("Show/Hiding options","wpproads").'</strong></span>';
				$html.= '</div>';
				
				
				// Show/Hide
				$bshowhide = WPPAS_TPL::vbc_data(array('id' => $args['bid'], 'type' => 'showhide', 'default' => 0));
				$html.= WPPAS_TPL::checkbox_cont(array(
					'title' => __('Show / Hide:','wpproads'),
					'desc' => __('Show or Hide the banner:','wpproads'),
					'id' => 'bshowhide',
					'chk-on' => __('Show','wpproads'),
					'chk-off' => __('Hide','wpproads'),
					'value' => $bshowhide
				));
				
		
				// Hide for Categories.
				$categories = WPPAS_TPL::vbc_data(array('id' => $args['bid'], 'type' => 'hide_for_categories', 'default' => ''));
				
				$html.= '<div class="input_container one_second">';
					
					$html.= '<h3 style="font-size: 12px;color: #333;">'.__('For Categories','wpproads').'</h3>';
					$html.= '<select id="wppas_banner_hide_categories" name="banner_categories[]" data-placeholder="'.__('Select Categories', 'wpproads').'" style="width:100%;" class="chosen-select" multiple>';
						$html.= '<option value=""></option>';
		
						$taxonomies = get_taxonomies();
						$allowed_taxonomies = apply_filters( 'wp_pro_ads_banner_limit_categories', array('category'));
						$allowed_taxonomies = apply_filters( 'wpproads_hide_categories', $allowed_taxonomies);
						
						foreach($taxonomies as $i => $taxonomy)
						{
							$terms = get_terms($taxonomy);
							foreach($terms as $cat)
							{
								if(in_array($cat->taxonomy, $allowed_taxonomies))
								{
									$selected = !empty($categories) && is_array($categories) ? in_array($cat->term_id, $categories) ? 'selected' : '' : '';
									$html.= '<option value="'.$cat->term_id.'" '.$selected.'>'.$cat->name.' - (ID:'.$cat->term_id.')</option>';
								}
							}
						}
					$html.= '</select>';
					$html.= '<span class="description bottom">'.__('Select the categories you want this banner to show/hide for.','wpproads').'</span>';
				$html.= '</div>';
				
				
				// Hide for Tags.
				$tags = WPPAS_TPL::vbc_data(array('id' => $args['bid'], 'type' => 'hide_for_tags', 'default' => ''));
				
				$html.= '<div class="input_container one_second">';
					
					$html.= '<h3 style="font-size: 12px;color: #333;">'.__('For Tags','wpproads').'</h3>';
					$html.= '<select id="wppas_banner_hide_tags" name="banner_tags[]" data-placeholder="'.__('Select Tags', 'wpproads').'" style="width:100%;" class="chosen-select" multiple>';
						$html.= '<option value=""></option>';
		
						$taxonomies = get_taxonomies();
						$allowed_taxonomies = apply_filters( 'wpproads_hide_tags', array('post_tag'));
						
						foreach($taxonomies as $i => $taxonomy)
						{
							$terms = get_terms($taxonomy);
							foreach($terms as $tag)
							{
								if(in_array($tag->taxonomy, $allowed_taxonomies))
								{
									$selected = !empty($tags) && is_array($tags) ? in_array($tag->term_id, $tags) ? 'selected' : '' : '';
									$html.= '<option value="'.$tag->term_id.'" '.$selected.'>'.$tag->name.' - (ID:'.$tag->term_id.')</option>';
								}
							}
						}
					$html.= '</select>';
					$html.= '<span class="description bottom">'.__('Select the tags you want this banner to show/hide for.','wpproads').'</span>';
				$html.= '</div>';
				
				
				
				// Hide for Posts.
				$posts = $this->vbc_banner_data(array('bid' => $args['bid'], 'type' => 'hide_for_posts', 'default' => ''));
				
				$html.= '<div class="input_container one_second">';
					
					$html.= '<h3 style="font-size: 12px;color: #333;">'.__('For Posts','wpproads').'</h3>';
					$html.= '<select id="wppas_banner_hide_posts" name="banner_posts[]" data-placeholder="'.__('Select Posts', 'wpproads').'" style="width:100%;" class="chosen-select" multiple>';
						$html.= '<option value=""></option>';
						
						$all_posts = get_posts(array(
							'posts_per_page'   => -1,
							'post_status'      => 'publish',
							'post_type'        => apply_filters( 'wpproads_hide_posts', array('post'))
						));
		
						foreach($all_posts as $i => $post)
						{
							$selected = !empty($posts) && is_array($posts) ? in_array($post->ID, $posts) ? 'selected' : '' : '';
							$html.= '<option value="'.$post->ID.'" '.$selected.'>'.$post->post_name.' - (ID:'.$post->ID.')</option>';
						}
					$html.= '</select>';
					$html.= '<span class="description bottom">'.__('Select the posts you want this banner to show/hide for.','wpproads').'</span>';
				$html.= '</div>';
				
				// Hide for Pages.
				$posts = $this->vbc_banner_data(array('bid' => $args['bid'], 'type' => 'hide_for_pages', 'default' => ''));
				
				$html.= '<div class="input_container one_second">';
					
					$html.= '<h3 style="font-size: 12px;color: #333;">'.__('For Pages','wpproads').'</h3>';
					$html.= '<select id="wppas_banner_hide_pages" name="banner_pages[]" data-placeholder="'.__('Select Pages', 'wpproads').'" style="width:100%;" class="chosen-select" multiple>';
						$html.= '<option value=""></option>';
						
						$all_posts = get_posts(array(
							'posts_per_page'   => -1,
							'post_status'      => 'publish',
							'post_type'        => apply_filters( 'wpproads_hide_pages', array('page'))
						));
		
						foreach($all_posts as $i => $post)
						{
							$selected = !empty($posts) && is_array($posts) ? in_array($post->ID, $posts) ? 'selected' : '' : '';
							$html.= '<option value="'.$post->ID.'" '.$selected.'>'.$post->post_name.' - (ID:'.$post->ID.')</option>';
						}
					$html.= '</select>';
					$html.= '<span class="description bottom">'.__('Select the pages you want this banner to show/hide for.','wpproads').'</span>';
				$html.= '</div>';
			
			$html.= '</div>';
			// end .vbc_option_box
			
			
			// ---------------- Save benner function in  - jquery.wppas.vbc.editor.js - arround line 780
			$html.= '<a class="wppas_home_tpl_btn main green open_banner_editor" data-target="vbc-editor" data-container="#vbc_main_area"><i class="fa fa-pencil" aria-hidden="true" style="margin-right: 5px;"></i> '.__('Open Banner Editor','wpproads').'</a>';
			$html.= '<a class="wppas_home_tpl_btn main green save_banner save"><i class="fa fa-save" aria-hidden="true" style="margin-right: 5px;"></i> '.__('Save Banner','wpproads').'</a>';
		$html.= '</div>';
		$html.= $this->start_screen_js();
		
		return $html;
	}
	
	
	
	
	
	public function fa_icons()
	{
		$pattern = '/\.(fa-(?:\w+(?:-)?)+):before\s+{\s*content:\s*"\\\\(.+)";\s+}/';
		$subject =  file_get_contents(WP_ADS_INC_DIR.'/font-awesome/css/font-awesome.css');
		preg_match_all($pattern, $subject, $matches, PREG_SET_ORDER);
		
		
		foreach($matches as $match) {
			$icons[$match[1]] = $match[2];
		}
		
		ksort($icons); 
		
		return $icons;	
	}
	
	
	
	
	
	
	/**
	 * EDITOR TEMPLATE
	 *
	 */
	public function editor_template( $args = array())
	{
		global $wppas_svg;
		
		wp_enqueue_script('wp-color-picker-alpha');
		wp_enqueue_script('WPPAS_VBC_GFONT_JS');
		wp_enqueue_style('WPPAS_VBC_GFONT_CSS');
		
		$defaults = array(
			'bid'         => 0,
			'editor_opts' => array(),
			'create_folder' => 0,
			'banner' => array()
		);
		$args = wp_parse_args( $args, $defaults );
		
		$banner = !empty($args['banner']) ? $args['banner'] : $this->load_banner_data($args['bid']);
		$alphaID = $banner['banner_data'][0]['timeline_arr']['main']['alphaID'];
		
		// Create temporary folder (if new banner)
		$upload_folder = $this->create_temp_banner_folder($args, $banner);
		
		// Editor Options
		$editor_defaults = array(
			'frontend'    => 0,
			'html_editor' => 1,
			'add_images'  => 1,
			'add_text'    => 1,
			'add_shapes'  => 1,
			'add_icons'   => 1,
			'add_svg'     => 1,
			'add_button'  => 1,
			'add_html'    => 1,
			'add_zip'     => 0
		);
		$editor_opts = wp_parse_args( $args['editor_opts'], $editor_defaults );
		
		$screen_sizes = $this->screen_sizes();
		krsort($screen_sizes);
		
		$html = '';
		//$html.= '<div class="'.$alphaID.'">';
        $html.= '<div class="editor_loader" style="display:none;"></div>';
        $html.= '<div id="wppas_top_tools_container">';
            
            /**
             * DEVICE SIZES
             */
            $html.= '<div id="sizes_container">';
                $html.= '<ul>';
                
                	foreach( $screen_sizes as $screen_size )
					{
						$has_content = $screen_size['size'] == 1200 ? ' has_content' : '';
						$title = $screen_size['size'] == 1200 ? __('Main Banner','wpproads') : $screen_size['size'];
						$html.= '<li class="small view_btn '.$screen_size['size'].$has_content.'" data-view="desktop" data-min="'.$screen_size['size'].'"><i class="fa fa-'.$screen_size['view'].'" aria-hidden="true"></i> '.$title.'</li>';
					}
					
                   $html.= '<li id="wppas_trash_view" title="'.__('Empty banner code for selected screen size.','wpproads').'" class="small trash" style="background:none;border:none;padding:5px 8px 0;font-size:18px; color:#6d6d6d;">';
                    	$html.= '<i class="fa fa-trash" aria-hidden="true"></i>';
                   $html.= '</li>';
                 
                $html.= '</ul>';
                $html.= '<div class="clearFix"></div>';
            $html.= '</div>';
            
            
            
            
            
            /**
             * RIGHT MENU - TOOLS
             */
            $html.= '<div id="right_menu">
                <div class="tools">';
                  
				  	// Upload Images
					if($editor_opts['add_images'])
					{ 
						if( !$editor_opts['frontend'] )
						{
							// BACKEND UPLOADER
							$html.= '<div><a id="b_add_image" class="upload_image_btn tools_btn"><i class="fa fa-picture-o" aria-hidden="true"></i></a></div>';
						}
						else
						{
							// FRONTEND UPLOADER
							$html.= '<div id="wppas-vbc-upload-container">';
								$html.= '<a id="wppas-vbc-uploader" class="wppas_vbc_button tools_btn"><i class="fa fa-picture-o" aria-hidden="true"></i></a>';
							$html.= '</div>';
							$html.= '<script>';
								$html.= 'wppas_vbc_load_ajax_upload("'.admin_url( 'admin-ajax.php').'", "'.$upload_folder.'");';
							$html.= '</script>';
						}
					}
                  
					// Add Text
				  	if($editor_opts['add_text'])
					{ 
				  		$html.= '<div><a id="b_add_text" class="tools_btn"><i class="fa fa-font" aria-hidden="true"></i></a></div>';
					}
					
					// Add Shapes
					if($editor_opts['add_shapes'])
					{ 
                    	$html.= '<div class="shape_itm_container tools_itm_container">
                        <a id="add_shape" class="tools_btn"><i class="fa fa-circle" aria-hidden="true"></i></a>';
                        /*<div class="shapes_rollout_menu tools_rollout_menu">
                            <a class="b_add_shape tools_btn" data-type="square"><i class="fa fa-square" aria-hidden="true"></i></a>
                        </div>*/
							$html.= $this->add_item_popup_container(array('type' => 'shape'));
                    	$html.= '</div>';
					}
					
					// Add Icons
					if($editor_opts['add_icons'])
					{ 
                    	$html.= '<div class="icons_itm_container tools_itm_container">
                        <a class="b_add_icon tools_btn" data-type="icon"><i class="fa fa-trophy" aria-hidden="true"></i></a>
                        <div class="tools_rollout_menu" style="top:-86px;">
                        		<div class="fa_icons_container itm_container">';
								
								$icons = $this->fa_icons();
                             $i = 0;
								foreach($icons as $key => $icon)
								{
									$html.= '<a class="fa_icon_holder itm_holder" data-fa="'.$key.'" data-facode="'.$icon.'">&#x'.$icon.'</a>';
									$i++;
									
									if($i == 4 )
									{
										$html.= '<div style="clear:both;"></div>';	
										$i = 0;	
									}
								}
                            
                            $html.= '</div>
                        </div>
                    </div>';
					}
					
					// Add SVG
					if($editor_opts['add_svg'])
					{ 
                    	$html.= '<div class="svg_itm_container tools_itm_container">';
                        $html.= '<a id="add_svg" class="tools_btn">'.$wppas_svg->svg_items_arr(array('item' => 'heart')).'</a>';
						   $html.= $this->add_item_popup_container(array('type' => 'svg'));
                    	$html.= '</div>';
					}
					
					// Add Button
					if($editor_opts['add_button'])
					{ 
                    	$html.= '<div class="btn_itm_container tools_itm_container">';
							$html.= '<a id="b_add_btn" class="tools_btn"><i class="fa fa-check-square" aria-hidden="true"></i></a>';
						$html.= '</div>';
						$html.= $this->add_item_popup_container(array('type' => 'button'));
					}
					
					// Add HTML
					if($editor_opts['add_html'])
					{ 
                    	$html.= '<div class="html_itm_container tools_itm_container">';
							$html.= '<a id="b_add_html" class="tools_btn"><i class="fa fa-code" aria-hidden="true"></i></a>';
						$html.= '</div>';
						$html.= $this->add_item_popup_container(array('type' => 'html'));
					}
					
					// Add ZIP
					if($editor_opts['add_zip'])
					{ 
                    	$html.= '<div class="zip_itm_container tools_itm_container">';
							$html.= '<a id="b_add_zip" class="tools_btn"><i class="fa fa-file-archive-o" aria-hidden="true"></i></a>';
						$html.= '</div>';
						$html.= $this->add_item_popup_container(array('type' => 'zip'));
					}
					
                $html.= '</div>
            </div> 
        </div>';
        // end #wppas_top_tools_container
        
        
        $html.= '<div id="wppas_vbc_editor_container" class="wppas_vbc_editor_container">';
            
            
            /**
             * BANNER PREVIEW
             */
            $html.= '<div id="wppas_vsb_border">
                <div id="wppas_vsb_container">
                    <div id="wppas_banner_work_area">
                        <div class="work_area_info">';
                            $html.= '<span class="device_view">'.__('Desktop: 1200px <','wpproads').'</span>';
                            $html.= '<span class="current_view_size">1200px</span>
                        </div>
                        <div id="banner-preview">';
                            /*<div id="boutline"></div>*/ // doesnt work cause it overlays all items and the cannot be dragged again.
                            $html.= '<div id="bpreview"><div class="b_container"></div></div>
                            
                        </div>
                    </div>
                </div>
            </div>';
            
            
           
            /**
             * EDITOR TOOLS
             */
				$html.= '<div class="wppas_beditor_tools">';
					$html.= '<div class="item">';
						$html.= WPPAS_TPL::checkbox_cont(array(
							'title' => __('Overflow:','wpproads'),
							'id' => 'boverflow',
							'value' => 1,
							'chk-on' => __('VISIBLE','wpproads'),
							'chk-off' => __('HIDDEN','wpproads'),
							'chk_width' => 30,
							'chk_height' => 10,
							'chk_btn_width' => 15
						));
					$html.= '</div>';
				
					$html.= '<div class="item">';
						$html.= WPPAS_TPL::checkbox_cont(array(
							'title' => __('Text Resize:','wpproads'),
							'id' => 'btxtresize',
							'value' => 0,
							'chk-on' => __('YES','wpproads'),
							'chk-off' => __('NO','wpproads'),
							'chk_width' => 30,
							'chk_height' => 10,
							'chk_btn_width' => 15
						));
					$html.= '</div>';
					
					/*$html.= '<div class="item">';
						$html.= '<div class="input_container" style="text-align:left;">';
							$html.= '<h3 class="title">'.__('Download PNG','wpproads').'</h3>';
							$html.= '<div class="banner_cover cover" data-option="vbc-cover" style="cursor:pointer;">';
								$html.= '<i class="fa fa-camera" style="margin-right:5px;"></i>';
							$html.= '</div>';
						$html.= '</div>';
					$html.= '</div>';*/
                
					$html.= '<div class="clearFix"></div>';
				$html.= '</div>';
            
			
            /**
             * TIMELINE
             */
            $html.= '<div id="banner_timeline">
            	<ul class="timeline_container" style="margin:0;">
                	<li class="timeline_itm" id="vbc_main_itm">
                    	<span style="width:25px; padding:0 10px; text-align:center; cursor:pointer;">
                        	<i class="fa fa-cog" aria-hidden="true"></i>
                        </span>
                        
                        <!-- popup editor -->
                        <div id="main_itm_edit_form" class="itm_edit_cont wppas_edit_form draggable_container">
                        	<div class="header">';
                            	$html.= '<div class="drag_handle"><i class="fa fa-bars" aria-hidden="true"></i></div>';
								
								$html.= '<div style="float:right; width:30%;">';
                                $html.= '<a class="wppas_itm_close wppas_itm_close_btn itm_header_btn"><i class="fa fa-close" aria-hidden="true"></i></a>';
                                	$html.= '<a id="wppas_main_b_settings" class="wppas_main_b_settings_save wppas_itm_save_btn_css itm_header_btn">';
                                		$html.= '<i class="fa fa-save" aria-hidden="true"></i>';
                                	$html.= '</a>';
								$html.= '</div>
                             <div class="clearFix"></div>
                           </div>
                        	<div id="itm_edit_content_container">';
                            	
								$bsettings = !empty($banner['banner_data'][0]['timeline_arr']['main']) ? $banner['banner_data'][0]['timeline_arr']['main'] : array();
								$defaults = array(
									'btime' => '',
									'bbg' => ''
								);
								$bsettings = wp_parse_args( $bsettings, $defaults );
								
								// Main banner time
								$html.= $this->inpt_cont(array(
									'title' => __('Banner time.','wpproads'), 
									'id' => 'edit_itm_btime',  
									'size' => 'one_third',
									'desc' => __('(optional) The length of the banner in miliseconds.','wpproads'),
									'class' => 'field_btime', 
									'icon' => 'clock-o',
									'value' => $bsettings['btime']
								));
								
								// Font Color
								$html.= '<span class="input_container one_third">';
									$html.= '<h3 class="title">'.__('Background Color.','wpproads').'</h3>';
									$html.= '<div><input type="text" id="edit_itm_bbg" value="'.$bsettings['bbg'].'" class="vbc-color-field" data-alpha="true" /></div>';
									$html.= '<span class="description bottom">'.__('Banner background color.','wpproads').'</span>';
								$html.= '</span>';
								
								$html.= '<div class="clearFix"></div>';
								$html.= '<div class="footer">';
									$html.= '<div class="wppas_main_b_settings_save button-secondary green">'.__('Save','wpproads').'</div>';
									$html.= '<div class="wppas_itm_close button-secondary" style="margin-left: 10px;">'.__('Cancel','wpproads').'</div>';
								$html.= '</div>';
								
								$html.= '<div class="clearFix"></div>';	
	
								
                            $html.= '</div>
                        </div>
                        <!-- end popup editor -->
                    </li>
                </ul>
                <ul id="timeline_container" class="timeline_container">';
                	//echo count($banner['banner_data'][0]['timeline_arr'][1200]);
					$timeline_arr = $this->timeline_arr_zindex_order($banner['banner_data'][0]['timeline_arr']);
					//echo count($timeline_arr[1200]);
					/*foreach($banner['banner_data'][0]['timeline_arr'] as $key => $item)
					{
						if($key == 1200)
							{
								foreach($item as $i => $itm )
								{
									echo $itm['ID'].'<br>';
								}
							}
					}*/
					
					if( !empty($timeline_arr)) //$banner['banner_data'][0]['timeline_arr']))
					{	
						foreach($timeline_arr as $key => $item ) // $banner['banner_data'][0]['timeline_arr']
						{
							//if($i != 'main')
							if($key == 1200)
							{
								foreach($item as $i => $itm )
								{
									//echo $itm['ID'].'<br>';
									$data = array(
										'ID' => $itm['ID'],
										'css' => $itm['css'],
										'font' => $itm['font'],
										'animation' => $itm['animation'],
										'data' => $itm['data'],
										'zindex' => $itm['zindex'],
										'v' => array_key_exists('v', $itm) ? $itm['v'] : ''
									);
								
									$types = $this->itm_types();
									
									$type_fix = explode('_', $itm['ID']); // fix for older versions
									$type = !empty($data['data']['type']) ? $data['data']['type'] : $type_fix[1];
									$object = array_key_exists('object', $data['data']) ? $data['data']['object'] : $type;
									$item = array_key_exists('itm', $data['data']) ? $data['data']['itm'] : $object;
									
									$bg_color = !empty($data['css']['layer']['background-color']) ? $data['css']['layer']['background-color'] : '';
									$itm_color = !empty($data['css']['item']['color']) ? $data['css']['item']['color'] : '#000000';
									$itm_bg_color = !empty($data['css']['item']['background-color']) ? $data['css']['item']['background-color'] : '#000000';
									//$font_color = !empty($data['font']['color']) ? $data['font']['color'] : '#000000';
									$ibgcss = !empty($data['css']['layer']['background-color']) ? ' style="background-color:'.$bg_color.';"' : '';
									
									$html.= '<li class="wppas timeline_itm" id="itm_'.$data['ID'].'" data-itm="'.$data['ID'].'" data-object="'.$object.'" data-item="'.$item.'">';
										
										$html.= '<span class="handle"><span class="zindex">'.$data['zindex'].'</span> <i class="fa fa-arrows-v" aria-hidden="true"></i></span>';
										$html.= '<span class="hide visible"><i class="fa fa-eye" aria-hidden="true"></i></span>';
										
										// text
										if( $object == 'text' )
										{
											$iptbgcss = !empty($data['css']['layer']['background-color']) ? ' background-color:'.$bg_color.';' : '';
											$txt = !empty($data['data']['code']) ? $data['data']['code'] : $data['ID'];
											$html.= '<span class="desc"><span class="preview_cont"'.$ibgcss.'>'.$types[$type]['icon'].'</span> <span class="cont_desc"><small><input class="txt_prev" style="color:'.$itm_color.';'.$iptbgcss.'" readonly value="'.$txt.'" /></small></span></span>';
										}
										// Image
										else if( $object == 'image' )
										{
											$src = array_key_exists('src', $data) ? $data['data']['src'] : '';
											$html.= '<span class="desc" style="background-image:url('.$src.');">'.$types[$type]['icon'].'</span>';
										}
										// Icon
										else if( $object == 'icon' )
										{
											$html.= '<span class="desc"><span class="preview_cont"'.$ibgcss.'><i class="fa '.$data['data']['icon'].'" aria-hidden="true" style="color:'.$itm_color.';"></i></span> <span class="cont_desc"><small>('.$data['ID'].')</small></span></span>';
										}
										// SVG
										else if( $object == 'svg' )
										{
											$html.= '<span class="desc"><span class="preview_cont"'.$ibgcss.'><div class="svg_preview enc">'.$data['data']['code'].'</div></span> <span class="cont_desc"><small>('.$data['ID'].')</small></span></span>';
										}
										// Shape
										else if( $object == 'shape' || $object == 'square' || $object == 'circle' )
										{
											$code = array_key_exists('code', $data['data']) ? $data['data']['code'] : '';
											$html.= '<span class="desc"><span class="preview_cont"'.$ibgcss.'><div class="shape_preview enc">'.$code.'</div></span> <span class="cont_desc"><small>('.$data['ID'].')</small></span></span>';
										}
										// Border - *Deprecated
										else if( $object == 'border' )
										{
											$html.= '<span class="desc"><span class="preview_cont"><div class="border_itm" style="border-color:'.$itm_color.';"></div></span> <span class="cont_desc"><small>('.$data['ID'].')</small></span></span>';
										}
										// html
										else if( $object == 'html' )
										{
											if( $item == 'button' )
											{
												$html.= '<span class="desc"><span class="preview_cont"><i class="fa fa-check-square" aria-hidden="true"></i></span> <span class="cont_desc"><small>('.$data['ID'].')</small></span></span>';
											}
											else
											{
												$html.= '<span class="desc"><span class="preview_cont"><i class="fa fa-code" aria-hidden="true"></i></span> <span class="cont_desc"><small>('.$data['ID'].')</small></span></span>';
											}
										}
										
										
										
										// Remove editing for version below 5.1.9
										if( array_key_exists('layer', $data['css']) )
										{
											$html.= '<span><a class="edit wppas_vbc_edit_itm_style"><i class="fa fa-pencil" aria-hidden="true"></i></a></span>';
											$html.= '<span><a class="edit wppas_vbc_edit_itm_duplicate"><i class="fa fa-files-o" aria-hidden="true"></i></a></span>';
										}
										$html.= '<span><a class="edit trash_itm" data-itm="'.$data['ID'].'"><i class="fa fa-trash" aria-hidden="true"></i></a></span>';
										$html.= $this->itm_edit_container($data);
									$html.= '</li>';
								}
							}
							
						}
						//echo $html;
					}
					
                $html.= '</ul>';
            $html.= '</div>';

            
          
            /**
             * CODE EDITOR
             */
			 $show_editor = !$editor_opts['html_editor'] ? ' style="display:none;"' : '';
			
			 $html.= '<div class="wppas_html_editor"'.$show_editor.'>';
				$html.= '<a class="bhtml_header">'.__('','wpproads').' <i class="fa fa-caret-down" aria-hidden="true"></i></a>';
            	$html.= '<div class="banner_html">';
            		$html.= '<div class="info_div">';
						$html.= __('<strong>NOTE:</strong> This should only be used for debugging. Editing the banner HTML manually using this code editor may break the banner functionality and editing options. Be aware and only change code using this editor if you know what you are doing.','wpproads');
                	$html.= '</div>';
               
                	$sizes = $this->screen_sizes();
					$html_arr = WPPAS_Banner::create_html_from_timeline($args);
					
					if( !empty($html_arr))
					{
						foreach($sizes as $size)
						{
							$value = !empty($html_arr[$size['size']]) ? htmlspecialchars($html_arr[$size['size']]) : '';
							$html.= '<textarea id="wppas_banner_html_'.$size['size'].'" class="wppas_banner_html '.$size['size'].'" name="wppas_banner_html_'.$size['size'].'">'.$value.'</textarea>';
						}
					}
					else
					{
						// For old banners
						foreach($sizes as $size)
						{
							$value = !empty($banner['banners_html'][$size['size']]['html']) ? htmlspecialchars($banner['banners_html'][$size['size']]['html']) : '';
							$html.= '<textarea id="wppas_banner_html_'.$size['size'].'" class="wppas_banner_html '.$size['size'].'" name="wppas_banner_html_'.$size['size'].'">'.$value.'</textarea>';
						}
					}
              
                	$html.= '<pre id="wppas_banner_html_editor_'.$alphaID.'" class="wppas_banner_html_editor"></pre>';
            	$html.= '</div>';
        	$html.= '</div>';
		$html.= '</div>';
        
        
        $html.= '<div class="clearFix"></div>';
		//$html.= '</div>';
        
       
		$html.= $this->banner_editor_js(array('timeline_arr' => $timeline_arr)); //$banner['banner_data'][0]['timeline_arr']
		
		return $html;
	}
	
	
	
	/**
	 * SORT TIMELINE LIST BY ZINDEX
	 * STEP 1
	 */
	public function timeline_arr_zindex_order($timeline_arr)
	{
		$t_arr = array();
		//echo 'oi<pre>'.print_r($timeline_arr,true).'</pre>';
		//echo '<pre>'.print_r($timeline_arr[1200],true).'</pre>';
		
		if( !empty($timeline_arr))
		{	
			foreach($timeline_arr as $key => $item )
			{
				if($key != 'main' && $key != 'v')
				{
					$arr = array();
					foreach($item as $i => $itm )
					{
						if($i != '_empty_')
						{
							$zx = !array_key_exists($itm['zindex'], $arr) ? $itm['zindex'] : $itm['zindex']+1;
							$zx = !array_key_exists($zx, $arr) ? $zx : $zx+1;
							
							$data = array(
								'ID' => $itm['ID'],
								'css' => $itm['css'],
								'font' => $itm['font'],
								'animation' => $itm['animation'],
								'data' => $itm['data'],
								'zindex' => $zx, //$itm['zindex'],
								'v' => array_key_exists('v', $itm) ? $itm['v'] : ''
							);	
							$arr[$zx]['data'] = $data;
						}
					}
					
					ksort($arr);
					$t_arr[$key] = $arr;
				}
			}
			//echo count($t_arr[1200]);
			return $this->update_timeline_arr_with_good_zindex_values($timeline_arr, $t_arr);
		}
	}
	
	/**
	 * SORT TIMELINE LIST BY ZINDEX
	 * STEP 2
	 */
	public function update_timeline_arr_with_good_zindex_values($default_arr, $arr)
	{
		//echo '<pre>'.print_r($arr,true).'</pre>';
		$timeline_arr = array();
		$timeline_arr['main'] = $default_arr['main'];
		if( array_key_exists('v', $default_arr) )
		{
			$timeline_arr['v'] = $default_arr['v'];
		}
		foreach($arr as $key => $ar)
		{
			foreach($ar as $itm)
			{
				//echo '<pre>'.print_r($itm['data']['ID'],true).'</pre>';
				$timeline_arr[$key][$itm['data']['ID']] = $itm['data'];
			}
		}
		
		//echo '<pre>'.print_r($timeline_arr,true).'</pre>';
		return $timeline_arr;
	}
	
	
	
	
	
	
	/**
	 *
	 * ADD ITEM POPUP CONTAINER
	 *
	 */
	public function add_item_popup_container($args = array())
	{
		$defaults = array(
			'ID' => 0,
			'type' => 'html'
		);
		$args = wp_parse_args( $args, $defaults );
		
		$html = '';
		$html.= '<div id="itm_add_cont" class="wppas_item_add_popup itm_add_cont itm_add_'.$args['type'].' itm_edit_cont wppas_edit_form draggable_container">';
			// Header
			$html.= '<div class="header">';
				$html.= '<div class="drag_handle">';
					$html.= '<i class="fa fa-bars" aria-hidden="true"></i>';
				$html.= '</div>';
				$html.= '<div style="float:right; width:30%;">';
					$html.= '<a class="wppas_itm_close wppas_itm_close_btn itm_header_btn">';
						$html.= '<i class="fa fa-close" aria-hidden="true"></i>';
					$html.= '</a>';
					$html.= '<a class="wppas_add_itm_save_btn itm_header_btn" data-itm="'.$args['type'].'">';
						$html.= '<i class="fa fa-save" aria-hidden="true"></i>';
					$html.= '</a>';
				$html.= '</div>';
				$html.= '<div class="clearFix"></div>';
			$html.= '</div>';
			
			// Content
			$html.= '<div id="itm_edit_content_container" class="wppas">';
				
				// Add Html
				if( $args['type'] == 'html' )
				{
					$html.= $this->add_itm_html_form();
				}
				elseif( $args['type'] == 'button' )
				{
					$html.= $this->add_itm_button_form();
				}
				elseif( $args['type'] == 'svg' )
				{
					$html.= $this->add_itm_svg_form();
				}
				elseif( $args['type'] == 'shape' )
				{
					$html.= $this->add_itm_shape_form();
				}
				/*elseif( $args['type'] == 'zip' )
				{
					$html.= $this->add_itm_zip_form();
				}*/
				
			$html.= '</div>';
			
			// Footer
			$html.= '<div class="clearFix"></div>';
			$html.= '<div class="footer wppas">';
				$html.= '<div class="wppas_add_itm_save_btn button-secondary green" data-itm="'.$args['type'].'">'.__('Add','wpproads').'</div>';
				$html.= '<div class="wppas_itm_close button-secondary" style="margin-left: 10px;">'.__('Cancel','wpproads').'</div>';
			$html.= '</div>';
			$html.= '<div class="clearFix"></div>';	
			
		$html.= '</div>';
		
		return $html;
	}
	
	
	
	
	
	
	public function add_itm_html_form($args = array())
	{
		$html = '';
		$html.= '<textarea id="add_itm_html" placeholder="'.__('ADD YOUR CODE HERE','wpproads').'" style="width:100%; height:300px;"></textarea>';
		
		return $html;
	}
	
	
	// saves with .wppas_add_itm_save_btn
	// Button Creator
	public function add_itm_button_form($args = array())
	{
		$style = '';
		$bid = !empty($args['ID']) ? $args['ID'] : '';
		$btn_type = !empty($args['data']['values']['class']) ? $args['data']['values']['class'] : '';
		$tempID = 'wp'.uniqid();
		$temp_id_str = empty($bid) ? ' id="itm_'.$tempID.'"' : '';
		$ID = !empty($bid) ? $bid : $tempID;
		
		$html = '';
		$html.= '<div'.$temp_id_str.' style="padding:20px 0 0;">';
			$html.= '<div class="input_container one_second prevbtn">';
				$html.= '<div style="border-bottom:solid 1px #EFEFEF;">'.__('Button Preview:','wpproads').'</div>';
				$html.= '<div class="btn_creator_preview" style="margin:40px 0; text-align:center;">';
					
					$html.= '<div class="btn"><div class="btn_content"><span class="txt">'.__('Click Here','wpproads').'</span></div></div>';
					
					
				$html.= '</div>';
				$html.= '<style id="btn_prev_style" data-id="'.$bid.'">'.$style.'</style>';
				
				// Pre defined buttons
				$html.= '<div style="border-bottom:solid 1px #EFEFEF;">'.__('Predefined Templates:','wpproads').'</div>';
				$html.= '<div class="predefined_buttons_cont">';
					
					foreach( WPPAS_DEF::predefined_buttons() as $class => $btn )
					{
						// pre defined - button
						$html.= '<div class="prbtn wppas_btn '.$class.'" data-class="'.$class.'">';
							
							$html.= '<div class="btn_content">';
								// pre defined - Icon before
								if(!empty($btn['content']['icon']))
								{
									$html.= $btn['content']['icon']['position'] == 'before' ? WPPAS_TPL::icon(array(
										'icon' => $btn['content']['icon']['class'],
										'style' => $btn['content']['icon']['style']
									)) : '';
								}
								// pre defined - text
								$html.= !empty($btn['content']['text']) ? $btn['content']['text'] : '';
								// pre defined - Icon after
								if(!empty($btn['content']['icon']))
								{
									$html.= $btn['content']['icon']['position'] == 'after' ? WPPAS_TPL::icon(array(
										'icon' => $btn['content']['icon']['class'],
										'style' => $btn['content']['icon']['style']
									)) : '';
								}
							$html.= '</div>';
						$html.= '</div>';
						// pre defined - style
						$html.= '<style>';
							$html.= '.prbtn.'.$class.'{';
								foreach($btn['css']['default'] as $key => $val)
								{
									$html.= $key.':'.$val.';';
								}
							$html.= '}';
							$html.= '.prbtn.'.$class.':hover{';
								foreach($btn['css']['hover'] as $key => $val)
								{
									$html.= $key.':'.$val.';';
								}
							$html.= '}';
						$html.= '</style>';
					}
					
				$html.= '</div>';
			$html.= '</div>';
		
			$html.= '<div class="input_container one_second prevbtn">';
			
				$html.= WPPAS_TPL::inpt_cont(array(
					'title' => __('Text','wpproads'), 
					'id' => 'btn_creator_txt',
					'value' => __('Click Here','wpproads'),
					'size' => ''
				));
				$html.= WPPAS_TPL::inpt_cont(array(
					'title' => __('','wpproads'), 
					'id' => 'btn_creator_class',
					'type' => 'hidden',
					'icon' => ''
				));
				
				$html.= WPPAS_TPL::sep_line(array(
					'title' => __('Style','wpproads'), 
					'desc' => __('','wpproads'), 
				));
				
				$html.= WPPAS_TPL::colorpicker_cont(array(
					'title' => __('Background Color','wpproads'), 
					'id' => 'btn_creator_bg_color',
					//'value' => $bg_color,
					//'color_change' => '$(".btn_creator_preview").find(".btn").css({"background-color": selected_color }); $(".prevbtn #btn_creator_bg_color").val(selected_color);',
					'color_change' => '$(this).wppas.change_button_color({"item":"#itm_'.$ID.'","color":selected_color,"type": "default","key": "background-color"});',
					//'color_change' => 'var sel_col = selected_color != "" ? selected_color : "transparent"; console.log(sel_col); $("#itm_'.$ID.'").find("#btn_prev_style").append("#itm_'.$ID.' .prevbtn .btn_creator_preview .btn{background-color:"+sel_col+";}"); $("#itm_'.$ID.' .prevbtn #btn_creator_bg_color").val(selected_color);',
					'size' => 'one_second'
				));
				$html.= WPPAS_TPL::colorpicker_cont(array(
					'title' => __('Font Color','wpproads'), 
					'id' => 'btn_creator_font_color',
					//'value' => $color,
					//'color_change' => '$(".btn_creator_preview").find(".btn").css({"color": selected_color }); $(".prevbtn #btn_creator_font_color").val(selected_color);',
					'color_change' => '$(this).wppas.change_button_color({"item":"#itm_'.$ID.'","color":selected_color,"type": "default","key": "color"});',
					//'color_change' => '$("#itm_'.$ID.'").find("#btn_prev_style").append("#itm_'.$ID.' .prevbtn .btn_creator_preview .btn{color:"+selected_color+";}"); $("#itm_'.$ID.' .prevbtn #btn_creator_font_color").val(selected_color);',
					'size' => 'one_second'
				));
				// border
				$html.= WPPAS_TPL::inpt_cont(array(
					'title' => __('Border','wpproads'), 
					'id' => 'btn_creator_border',
					'placeholder' => __('0','wpproads'),
					'size' => 'small one_second'
				));
				$html.= WPPAS_TPL::colorpicker_cont(array(
					'title' => __('Border Color','wpproads'), 
					'id' => 'btn_creator_border_color',
					'color_change' => '$(this).wppas.change_button_color({"item":"#itm_'.$ID.'","color":selected_color,"type": "default","key": "border-color"});',
					//'color_change' => '$("#itm_'.$ID.'").find("#btn_prev_style").append("#itm_'.$ID.' .prevbtn .btn_creator_preview .btn{border-color:"+selected_color+";}"); $("#itm_'.$ID.' .prevbtn #btn_creator_border_color").val(selected_color);',
					'size' => 'one_second'
				));
				$html.= WPPAS_TPL::select_cont(array(
					'title' => __('Border style','wpproads'),
					'desc' => __('','wpproads'),
					'id' => 'btn_creator_border_style',
					'select_opts' => array(
						'none' => array('value' => '', 'text' => __('None', 'wpproads')),
						'solid' => array('text' => __('Solid', 'wpproads')),
						'dotted' => array('text' => __('Dotted', 'wpproads')),
						'dashed' => array('text' => __('Dashed', 'wpproads')),
						'double' => array('text' => __('Double', 'wpproads'))
					),
					'size' => 'one_second small'
				));
				
				$html.= WPPAS_TPL::inpt_cont(array(
					'title' => __('Border Radius (pixels)','wpproads'), 
					'id' => 'btn_creator_border_radius',
					'placeholder' => __('0','wpproads'),
					'size' => 'small one_second'
				));
			
				
				/* HOVER */
				//$bid_css = !empty($args['ID']) ? '#itm_'.$args['ID'].' ' : '';
				$html.= WPPAS_TPL::sep_line(array(
					'title' => __('Hover State','wpproads'), 
					'desc' => __('','wpproads'), 
				));
				
				$html.= WPPAS_TPL::colorpicker_cont(array(
					'title' => __('Background Color','wpproads'), 
					'id' => 'btn_creator_hover_bg_color',
					//'value' => $hover_bg_color,
					'color_change' => '$("#itm_'.$ID.'").find("#btn_prev_style").append("#itm_'.$ID.' .prevbtn .btn_creator_preview .btn:hover{background-color:"+selected_color+";}"); $("#itm_'.$ID.' .prevbtn #btn_creator_hover_bg_color").val(selected_color);',
					'size' => 'one_second'
				));
				$html.= WPPAS_TPL::colorpicker_cont(array(
					'title' => __('Font Color','wpproads'), 
					'id' => 'btn_creator_hover_font_color',
					//'value' => $hover_color,
					'color_change' => '$("#itm_'.$ID.'").find("#btn_prev_style").append("#itm_'.$ID.' .prevbtn .btn_creator_preview .btn:hover{color:"+selected_color+";}"); $("#itm_'.$ID.' .prevbtn #btn_creator_hover_font_color").val(selected_color);',
					'size' => 'one_second'
				));
				$html.= WPPAS_TPL::colorpicker_cont(array(
					'title' => __('Border Color','wpproads'), 
					'id' => 'btn_creator_hover_border_color',
					//'value' => $hover_color,
					'color_change' => '$("#itm_'.$ID.'").find("#btn_prev_style").append("#itm_'.$ID.' .prevbtn .btn_creator_preview .btn:hover{border-color:"+selected_color+";}"); $("#itm_'.$ID.' .prevbtn #btn_creator_hover_border_color").val(selected_color);',
					'size' => 'one_second'
				));
					
			$html.= '</div>';
		$html.= '</div>';
		
		return $html;
	}
	
	
	public function add_itm_svg_form($args = array())
	{
		global $wppas_svg;
		
		$defaults = array(
			'ID' => ''
		);
		$args = wp_parse_args( $args, $defaults );
		
		$tempID = 'wp'.uniqid();
		$temp_id_str = empty($args['ID']) ? ' id="itm_'.$tempID.'"' : '';
		$ID = !empty($args['ID']) ? $args['ID'] : $tempID;
		$svgs = $wppas_svg->svg_items();
		
		$html = '';
		$html.= '<div'.$temp_id_str.' style="padding:20px 0 0;">';
			$html.= '<div class="input_container one_second prevbtn">';
				$html.= '<div style="border-bottom:solid 1px #EFEFEF;">'.__('SVG Preview:','wpproads').'</div>';
				$html.= '<div class="svg_creator_preview" style="margin:40px 0; text-align:center; width:100px;">';
					
					$html.= $svgs[0]['code'];
					
				$html.= '</div>';
				
				// SVG ITEM LIST
				$html.= '<div style="border-bottom:solid 1px #EFEFEF;">'.__('All available items:','wpproads').'</div>';
				$html.= '<div class="svgs_cont" style="padding:20px 0;">';
					foreach($svgs as $svg)
					{
						$html.= '<a class="b_add_svg tools_btn itm_holder">'.$svg['code'].'</a>';
					}
				$html.= '</div>';
			$html.= '</div>';
		
			$html.= '<div class="input_container one_second prevbtn">';
				$html.= '<div style="border-bottom:solid 1px #EFEFEF;">'.__('Edit Options:','wpproads').'</div>';
				$html.= '<div class="svg_edit_options_cont" style="padding:20px 0;">';
					
					$html.= WPPAS_TPL::colorpicker_cont(array(
						'id' => 'svg_c1',
						'class' => 'svg_color_picker',
						'value' => '#DD3333',
						'color_change' => '$(this).wppas.change_svg_color({"item":$("#itm_'.$ID.'").find(".svg_creator_preview").find("svg").find(".c1"), "color":selected_color});', //console.log(selected_color);
						'size' => 'one_second'
					));
					$html.= WPPAS_TPL::colorpicker_cont(array(
						'id' => 'svg_c2',
						'class' => 'svg_color_picker',
						'value' => '',
						'style' => 'display:none;',
						'color_change' => '$(this).wppas.change_svg_color({"item":$("#itm_'.$ID.'").find(".svg_creator_preview").find("svg").find(".c2"), "color":selected_color});',
						'size' => 'one_second'
					));
					$html.= WPPAS_TPL::colorpicker_cont(array(
						'id' => 'svg_c3',
						'class' => 'svg_color_picker',
						'value' => '',
						'style' => 'display:none;',
						'color_change' => '$(this).wppas.change_svg_color({"item":$("#itm_'.$ID.'").find(".svg_creator_preview").find("svg").find(".c3"), "color":selected_color});', 
						'size' => 'one_second'
					));
					
				$html.= '</div>';
			$html.= '</div>';
		$html.= '</div>';
		
		return $html;	
	}
	
	
	
	public function add_itm_shape_form($args = array())
	{
		global $wppas_shape;
		
		$defaults = array(
			'ID' => 0,
			'css' => array() 
		);
		$args = wp_parse_args( $args, $defaults );
		$args['css'] = WPPAS_DEF::layer_css($args);
					
		$tempID = 'wp'.uniqid();
		$temp_id_str = empty($args['ID']) ? ' id="itm_'.$tempID.'"' : '';
		$ID = !empty($args['ID']) ? $args['ID'] : $tempID;
		$shapes = $wppas_shape->shape_items();
		
		$html = '';
		$html.= '<div'.$temp_id_str.' style="padding:20px 0 0;">';
			$html.= '<div class="input_container one_second prevbtn">';
				$html.= '<div style="border-bottom:solid 1px #EFEFEF;">'.__('Shape Preview:','wpproads').'</div>';
				$html.= '<div class="shape_creator_preview" style="margin:40px 0; text-align:center; width:100px;">';
					
					$html.= $shapes[0]['code'];
					
				$html.= '</div>';
				
				// SHAPE ITEM LIST
				$html.= '<div style="border-bottom:solid 1px #EFEFEF;">'.__('All available shapes:','wpproads').'</div>';
				$html.= '<div class="shapes_cont" style="padding:20px 0;">';
					foreach($shapes as $shape)
					{
						$html.= '<a class="b_add_shape tools_btn itm_holder">'.$shape['code'].'</a>';
					}
				$html.= '</div>';
			$html.= '</div>';
		
			$html.= '<div class="input_container one_second prevbtn">';
				$html.= '<div style="border-bottom:solid 1px #EFEFEF;">'.__('Edit Options:','wpproads').'</div>';
				
				// DIV edit
				$html.= '<div class="itm_edit_form_style shape_edit div_edit edit_options" style="padding:20px 0;">';
					// Item Color
					$html.= WPPAS_TPL::colorpicker_cont(array(
						'title' => __('Item Color.','wpproads'), 
						'id' => 'div_shape_color_picker',
						'value' => '#000000',
						'size' => 'one_second',
						'color_change' => '$(this).wppas.change_shape_color({
							"item":$("#itm_'.$ID.'").find(".shape_creator_preview").find(".c1"), 
							"color":selected_color,
							"type": "css",
							"key": "background-color"
						});',
					));
					
					// Border Color
					$html.= WPPAS_TPL::colorpicker_cont(array(
						'title' => __('Border Color.','wpproads'), 
						'id' => 'div_shape_border_picker',
						'value' => $args['css']['item']['border-color'],
						'size' => 'one_second',
						'color_change' => '$(this).wppas.change_shape_color({
							"item":$("#itm_'.$ID.'").find(".shape_creator_preview").find(".c1"), 
							"color":selected_color,
							"type": "css",
							"key": "border-color"
						});',
					));
					
					
					$html.= WPPAS_TPL::sep_line(array(
						'title' => __('Border Style','wpproads'), 
						'desc' => __('','wpproads'), 
					));
					// Border width
					$html.= $this->inpt_cont(array(
						'title' => __('width','wpproads'), 
						'id' => 'edit_itm_border', 
						'size' => 'one_second small',
						'placeholder' => 0,
					));
					// Border style
					$html.= WPPAS_TPL::select_cont(array(
						'title' => __('style','wpproads'),
						'desc' => __('','wpproads'),
						'id' => 'edit_itm_border_style',
						'value' => $args['css']['item']['border-style'],
						'select_opts' => array(
							'none' => array('value' => '', 'text' => __('None', 'wpproads')),
							'solid' => array('text' => __('Solid', 'wpproads')),
							'dotted' => array('text' => __('Dotted', 'wpproads')),
							'dashed' => array('text' => __('Dashed', 'wpproads')),
							'double' => array('text' => __('Double', 'wpproads'))
						),
						'size' => 'one_second small'
					));
					
					$html.= WPPAS_TPL::sep_line(array(
						'title' => __('Border Radius','wpproads'), 
						'desc' => __('','wpproads'), 
					));
					// Border Radius
					$html.= $this->inpt_cont(array(
						'title' => __('top left','wpproads'), 
						'id' => 'edit_itm_border_radius_top_left', 
						'size' => 'one_second small',
						'placeholder' => '-',
						'value' => !empty($args['css']['item']['border-radius']) && array_key_exists('top_left', $args['css']['item']['border-radius']) ? $args['css']['item']['border-radius']['top_left'] : ''
					));
					$html.= $this->inpt_cont(array(
						'title' => __('top right','wpproads'), 
						'id' => 'edit_itm_border_radius_top_right', 
						'size' => 'one_second small',
						'placeholder' => '-',
						'value' => !empty($args['css']['item']['border-radius']) && array_key_exists('top_right', $args['css']['item']['border-radius']) ? $args['css']['border-radius']['item']['top_right'] : ''
					));
					$html.= $this->inpt_cont(array(
						'title' => __('bottom left','wpproads'), 
						'id' => 'edit_itm_border_radius_bottom_left', 
						'size' => 'one_second small',
						'placeholder' => '-',
						'value' => !empty($args['css']['item']['border-radius']) && array_key_exists('bottom_left', $args['css']['item']['border-radius']) ? $args['css']['item']['border-radius']['bottom_left'] : ''
					));
					$html.= $this->inpt_cont(array(
						'title' => __('bottom right','wpproads'), 
						'id' => 'edit_itm_border_radius_bottom_right', 
						'size' => 'one_second small',
						'placeholder' => '-',
						'value' => !empty($args['css']['item']['border-radius']) && array_key_exists('bottom_right', $args['css']['item']['border-radius']) ? $args['css']['item']['border-radius']['bottom_right'] : ''
					));
					
					
				$html.= '</div>';
				// end DIV edit
				
				// SVG Edit
				$html.= '<div class="svg_edit_options_cont svg_edit edit_options" style="padding:20px 0; display:none;">';
					
					$html.= WPPAS_TPL::colorpicker_cont(array(
						'id' => 'svg_shape_color_picker',
						'class' => 'color_picker',
						'value' => '#DD3333',
						'color_change' => '$(this).wppas.change_shape_color({
							"item":$("#itm_'.$ID.'").find(".shape_creator_preview").find(".c1"), 
							"color":selected_color,
							"type": "css",
							"key": "fill"
						});',
						'size' => 'one_second'
					));
					$html.= WPPAS_TPL::colorpicker_cont(array(
						'id' => 'svg_shape_border_picker',
						'class' => 'color_picker',
						'value' => '',
						'color_change' => '$(this).wppas.change_shape_color({
							"item":$("#itm_'.$ID.'").find(".shape_creator_preview").find(".c1"), 
							"color":selected_color,
							"type": "css",
							"key": "stroke"
						});',
						'size' => 'one_second'
					));
					
					
				$html.= '</div>';
				//end SVG edit
				
			$html.= '</div>';
		$html.= '</div>';
		
		return $html;	
	}
	
	
	
	public function add_itm_zip_form($args = array())
	{
		$defaults = WPPAS_TPL::itm_defaults();
		$args = wp_parse_args( $args, $defaults );
		$html = '';
		
		$html.= '<div class="input_container '.$args['size'].'" style="border-left: solid 1px #e4e4e4;">';
			
			$html.= !empty($args['title']) ? '<h3 class="title">'.$args['title'].'</h3>' : '';
			$html.= '<div id="wppas-vbc-upload-container">';
				$html.= '<a id="wppas-vbc-uploader" class="wppas_vbc_button zip_upload_btn tools_btn">'.__('Upload .zip file','wpproads').'</a>';
			$html.= '</div>';
			$html.= '<div id="wppas-vbc-upload-imagelist">';
				$html.='<ul id="wppas-vbc-ul-list" class="wppas-vbc-upload-list"></ul>';
			$html.= '</div>';
			$html.= $args['desc_pos'] == 'bottom' && !empty($args['desc']) ? '<span class="description bottom">'.$args['desc'].'</span>' : '';
			$html.= '<script>';
				$html.= 'wppas_vbc_load_ajax_upload("'.admin_url( 'admin-ajax.php').'");';
			$html.= '</script>';
			/*$html.= '<p>'.__('Choose a .zip file to upload','wpproads').'</p>';
			$html.= '<form method="post" action="" enctype="multipart/form-data" id="zip_upload_form">';
				$html.= '<div><input type="file" name="wppas_zip_file" id="wppas_zip_file" accept=".zip,application/octet-stream,application/zip,application/x-zip,application/x-zip-compressed" /></div>';
				$html.= '<div id="wppas_upload_zip" class="button-secondary">'.__('Upload ZIP','wpproads').'</div>';
			$html.= '</form>';
			*/
			
		$html.= '</div>';
		
		
		
		return $html;
	}
	
	
	
	
	
	
	public function export_template( $args = array())
	{
		global $pro_ads_multisite;
		
		$html = '';
		$banner = !empty($args['bid']) ? $this->load_banner_data($args['bid']) : '';
		
		
		$html.= '<div>';
			$html.= '<span style="font-size:30px; margin: 20px 0 0; display:inline-block;"><strong>'.__("Show this banner on your website","wpproads").'</strong></span>';
			$html.= '<span style="display:inline-block;margin:10px 0 30px;">'.__('<strong>NOTE:</strong> Display options are not getting saved with the banner. They are only used to create the shortcode that shows the banner on your website.','wpproads').'</span>';
		$html.= '</div>';
		
		
		$html.= '<div class="export_options" style="display:inline-block;width:40%;min-width:300px;">';
		
			// -- SHORTCODE --
			$html.= '<div class="vbc_option_box">';
				$html.= '<div class="info_header">';
					$html.= '<span class="nr">1</span>';
					$html.= '<span class="text">'.__('Shortcode','wpproads').'</span>';
				$html.= '</div>';
				
				// Shortcode
				$html.= '<span class="input_container">';
					//$html.= '<h5 style="margin:0;">'.__('Wordpress shortcode','wpproads').'</h5>';
					$html.= '<div class="export_sc_cont">';
						if( !empty($args['bid']) )
						{
							$html.= '<input type="text" value="[wpproads id="'.$args['bid'].'"]" />';
							$html.= '<i class="input_icon fa fa-pencil" aria-hidden="true"></i>';
							$html.= '<span class="description bottom">'.__('A Wordpress shortcode to show the banner on this website.','wpproads').'</span>';
						}
						else
						{
							$html.= '<span class="description bottom">'.__('You need to save the banner in order for this option to be available.','wpproads').'</span>';
						}
					$html.= '</div>';
				$html.= '</span>';
				
			$html.= '</div>';
			// end .vbc_option_box
			
			
			
			// -- DISPLAY OPTIONS --
			//$html.= $this->wppas_display_options(array('ID' => $args['bid'], 'type' => 'banner'));
			
			
			
			/*// -- TEMPLATE TAG --
			$html.= '<div class="vbc_option_box">';
				$html.= '<div class="info_header">';
					$html.= '<span class="nr">2</span>';
					$html.= '<span class="text">'.__('Template Tag','wpproads').'</span>';
				$html.= '</div>';
				
				// Shortcode
				$html.= '<span class="input_container">';
					//$html.= '<h5 style="margin:0;">'.__('Wordpress shortcode','wpproads').'</h5>';
					$html.= '<div class="export_tpt_cont">';
						if( !empty($args['bid']) )
						{
							$html.= '<input type="text" value="do_shortcode(\'[SHORTCODE GOES HERE]\')" />';
							$html.= '<i class="input_icon fa fa-pencil" aria-hidden="true"></i>';
							$html.= '<span class="description bottom">'.__('Template tag to show the banner anywhere on this website.','wpproads').'</span>';
						}
						else
						{
							$html.= '<span class="description bottom">'.__('You need to save the banner in order for this option to be available.','wpproads').'</span>';
						}
					$html.= '</div>';
				$html.= '</span>';
				
			$html.= '</div>';
			// end .vbc_option_box	
			*/
			
			$html.= WPPAS_TPL::sep_line(array(
				'title' => __("Additional export options","wpproads"),
				'desc' => __('The following options allow you to show the banner as a default inline banner only. Display options selected above will not work on the iframe or HTML options.','wpproads')
			));
			
			// -- IFRAME --
			$html.= '<div class="vbc_option_box">';
				$html.= '<div class="info_header">';
					$html.= '<span class="nr">1</span>';
					$html.= '<span class="text">'.__('Iframe','wpproads').'</span>';
				$html.= '</div>';
				
				$html.= '<span class="input_container">';
					$html.= '<div class="export_iframe_cont">';
						if( !empty($args['bid']) )
						{
							$if = '';
							$if.= '<div style="max-width:'.$banner['banner_data'][0]['w'].'px; width:100%; height:'.$banner['banner_data'][0]['h'].'px;">';
								$if.= '<iframe ';
									$if.= 'src="'.$pro_ads_multisite->wpproads_get_site_url().'?wppasbid='.$args['bid'].'" ';
									$if.= 'border="0" ';
									$if.= 'scrolling="no" ';
									$if.= 'allowtransparency="true" ';
									$if.= 'width="100%" ';
									$if.= 'height="100%" ';
									$if.= 'style="border:0;">';
							   $if.= '</iframe>';
						   $if.= '</div>';
						   
							$html.= '<textarea id="wppas_iframe_code" style="width:100%; height:100px; font-size: 11px; font-weight: normal; margin-bottom: 10px;" readonly="readonly">'.$if.'</textarea>';
							$html.= '<span class="description bottom">'.__('Iframe code. This code can be used to place the banner anywhere you want even on other websites.','wpproads').'</span>';
						}
						else
						{
							$html.= '<span class="description bottom">'.__('You need to save the banner in order for this option to be available.','wpproads').'</span>';
						}
					$html.= '</div>';
					
				$html.= '</span>';
				
			$html.= '</div>';
			// end .vbc_option_box	
			
			
			
			// -- HTML --
			$html.= '<div class="vbc_option_box">';
				$html.= '<div class="info_header">';
					$html.= '<span class="nr">2</span>';
					$html.= '<span class="text">'.__('HTML Code','wpproads').'</span>';
				$html.= '</div>';
				
				$html.= '<span class="input_container">';
					//$html.= '<h5 style="margin:0;">'.__('To use on this website','wpproads').'</h5>';
					$html.= '<textarea id="wppas_html_code" style="width:100%; height:150px; font-size: 11px; font-weight: normal; margin-bottom: 10px;" readonly="readonly"></textarea>';
					$html.= '<span class="description bottom">'.__('Banner HTML code. This code can be used to place the banner anywhere you want even on other websites.','wpproads').'</span>';
					
				$html.= '</span>';
				
			$html.= '</div>';
			// end .vbc_option_box	
			
			
			// -- RSS --
			$html.= '<div class="vbc_option_box">';
				$html.= '<div class="info_header">';
					$html.= '<span class="nr">3</span>';
					$html.= '<span class="text">'.__('RSS Feed','wpproads').'</span>';
				$html.= '</div>';
				
				$html.= '<span class="input_container">';
					$html.= '<input id="wppas_rss_feed" style="width:100%; font-size: 11px; font-weight: normal; margin-bottom: 10px;" readonly="readonly" />';
					$html.= '<span class="description bottom">'.__('RSS Feed. The banner RSS feed.','wpproads').'</span>';
					
				$html.= '</span>';
				
			$html.= '</div>';
			// end .vbc_option_box	
			
			
			
			// EXPORT
			$html.= '<div class="wppas_sep_line" style="margin: 50px 0 15px 0;">';
				$html.= '<span style="background-color:#FFF;"><strong>'.__("Export banner code","wpproads").'</strong></span>';
			$html.= '</div>';
			
			$html.= '<div style="margin: 0 0 40px;">';
				$html.= 'This exports the banner including all it\'s layers so you can transfer it to another website.';
			$html.= '</div>';
			
			
			// -- EXPORT CODE --
			$html.= '<div class="vbc_option_box">';
				$html.= '<div class="info_header">';
					$html.= '<span class="nr">1</span>';
					$html.= '<span class="text">'.__('Export','wpproads').'</span>';
				$html.= '</div>';
				
				// Export code
				$html.= '<span class="input_container">';
					//$html.= '<h5 style="margin:0;">'.__('Export code','wpproads').'</h5>';
					$html.= '<div class="export_cd_cont">';
						
						$html.= '<textarea id="wppas_export_code" style="width:100%; height:150px; font-size: 11px; font-weight: normal; margin-bottom: 10px;"></textarea>';
						$html.= '<span class="description bottom">'.__('Export banner to import into another website.','wpproads').'</span>';
						
					$html.= '</div>';
				$html.= '</span>';
				
				// Export files to zip (under construction)
				//$html.= '<a id="export_files" data-id="'.$args['bid'].'">Export files</a>';
			$html.= '</div>';
			// end .vbc_option_box	
		
		$html.= '</div>';
		// end .export_options
		
		// -- DISPLAY OPTIONS --
		$html.= $this->wppas_display_options(array('ID' => $args['bid'], 'type' => 'banner'));
		
		
		return $html;
	}
	
	
	
	
	
	
	
	
	/**
	 *
	 * ITEM EDITOR CONTAINER
	 *
	 */
	public function itm_edit_container($args = array())
	{
		$defaults = array(
			'ID' => 0,
			'data' => array()
		);
		$args = wp_parse_args( $args, $defaults );
		
		$html = '';
	
		$html.= '<div class="itm_edit_cont wppas_edit_form draggable_container wppas">';
			$html.= '<div class="header">';
				$html.= '<div class="drag_handle">';
					$html.= '<i class="fa fa-bars" aria-hidden="true"></i>';
				$html.= '</div>';
				$html.= '<div style="float:right; width:30%;">';
					$html.= '<a class="wppas_itm_close wppas_itm_close_btn itm_header_btn">';
						$html.= '<i class="fa fa-close" aria-hidden="true"></i>';
					$html.= '</a>';
					$html.= '<a class="wppas_itm_save_btn itm_header_btn">';
						$html.= '<i class="fa fa-save" aria-hidden="true"></i>';
					$html.= '</a>';
				$html.= '</div>';
				$html.= '<div class="clearFix"></div>';
			$html.= '</div>';
			
			$html.= '<ul id="itm_menu" class="vbc_menu_toggle itm_edit_menu_toggle">
				<li class="selected css_tab" data-target="itm-edit-css">
					<i class="fa fa-css3" aria-hidden="true" style="margin-right: 5px;"></i> '.__('CSS','wpproads').'
				</li>
				<li class="font_tab" data-target="itm-edit-font" style="display:none;">
					<i class="fa fa-font" aria-hidden="true" style="margin-right: 5px;"></i> '.__('Font','wpproads').'
				</li>
				<li class="shape_tab" data-target="itm-edit-shape" style="display:none;">
					<i class="fa fa-circle" aria-hidden="true" style="margin-right: 5px;"></i> '.__('Shape','wpproads').'
				</li>
				<li class="icon_tab" data-target="itm-edit-icon" style="display:none;">
					<i class="fa fa-trophy" aria-hidden="true" style="margin-right: 5px;"></i> '.__('Icon','wpproads').'
				</li>
				<li class="html_tab" data-target="itm-edit-html" style="display:none;">
					<i class="fa fa-code" aria-hidden="true" style="margin-right: 5px;"></i> '.__('HTML','wpproads').'
				</li>
				<li class="button_tab" data-target="itm-edit-button" style="display:none;">
					<i class="fa fa-code" aria-hidden="true" style="margin-right: 5px;"></i> '.__('Button','wpproads').'
				</li>
				<li class="svg_tab" data-target="itm-edit-svg" style="display:none;">
					<i class="fa fa-code" aria-hidden="true" style="margin-right: 5px;"></i> '.__('SVG','wpproads').'
				</li>
				<li class="animation_tab" data-target="itm-edit-animation">
					<i class="fa fa-clock-o" aria-hidden="true" style="margin-right: 5px;"></i> '.__('Animation','wpproads').'
				</li>
			</ul>';
			
			$html.= '<div id="itm_edit_content_container">';
				$html.= '<div id="itm-edit-css" class="itm_nfer">'.$this->itm_editor_form_style($args).'</div>';
				$html.= '<div id="itm-edit-animation" class="itm_nfer" style="display:none;">'.$this->itm_editor_animation($args).'</div>';
				
				$html.= '<div id="itm-edit-font" class="itm_nfer itm_edt_opt" data-obj="text" data-item="text" style="display:none;">'.$this->itm_editor_form($args).'</div>';
				$html.= '<div id="itm-edit-html" class="itm_nfer itm_edt_opt" data-obj="html" data-item="html" style="display:none;">'.$this->itm_editor_html($args).'</div>';
				$html.= '<div id="itm-edit-button" class="itm_nfer itm_edt_opt" data-obj="html" data-item="button" style="display:none;">'.$this->itm_editor_button($args).'</div>';
				$html.= '<div id="itm-edit-svg" class="itm_nfer itm_edt_opt" data-obj="svg" data-item="svg" style="display:none;">'.$this->itm_editor_svg($args).'</div>';
				$html.= '<div id="itm-edit-shape" class="itm_nfer itm_edt_opt" data-obj="shape" data-item="shape" style="display:none;">'.$this->itm_editor_shape($args).'</div>';
				$html.= '<div id="itm-edit-icon" class="itm_nfer itm_edt_opt" data-obj="icon" data-item="icon" style="display:none;">'.$this->itm_editor_icon($args).'</div>';
				$html.= '<div class="clearFix"></div>';
			$html.= '</div>';
			
			$html.= '<div class="clearFix"></div>';
			$html.= '<div class="footer">';
				$html.= '<div class="wppas_itm_save_btn button-secondary green" data-itm="'.$args['ID'].'">'.__('Save','wpproads').'</div>';
				$html.= '<div class="wppas_itm_close button-secondary" style="margin-left: 10px;">'.__('Cancel','wpproads').'</div>';
			$html.= '</div>';
			
			$html.= '<div class="clearFix"></div>';	
		$html.= '</div>';
		
		if( empty($args['ID']))
		{
			wp_localize_script( 'WPPAS_VBC_EDITR', 'itm_editor_cont', array('form' => $html) );
		}
		
		return $html;
	}
	
	
	
	
	/**
	 * FONT EDITOR
	 *
	 */
	public function itm_editor_form($args = array())
	{
		global $wppas_google_fonts;
		
		$defaults = array(
			'ID' => 0,
			'css' => array()
			//'font' => array()
		);
		$args = wp_parse_args( $args, $defaults );
		
		$args['css'] = WPPAS_DEF::layer_css($args);
		
		/*$font_defaults = array(
			'color' => '#000000',
			'font-family' => '',
			'font-size' => '',
			'text-align' => 'left'
		);
		$args['font'] = wp_parse_args( $args['font'], $font_defaults );*/
		
		$html = '';
		$html.= '<div class="itm_edit_form">'; //wppas_edit_form draggable_container
			//$html.= '<span class="input_container" style="height:1px;"></span>'; //fix
        	$html.= '<div class="field_html field_text" style="width:49%; float:left; margin-top:5px;">';
				$html.= '<textarea id="edit_itm_html" placeholder="'.__('YOUR TEXT HERE','wpproads').'"></textarea>';
				$html.= '<span style="padding-left:10px;"><em><small>'.__('<strong>Note:</strong> Preview will not show the selected font color and text alignment.','wpproads').'</small></em></span>';
			$html.= '</div>';
			
			$html.= '<div class="field_html field_text" style="width:49%;float:right;max-height:100%;overflow:auto;">';
				
				// Font size
				$html.= WPPAS_TPL::inpt_cont(array(
					'title' => __('Font size.','wpproads'), 
					'id' => 'edit_itm_fontsize', 
					'placeholder' => __('12px','wpproads'), 
					'class' => 'field_font_size', 
					'icon' => 'text-height',
					'value' => $args['css']['item']['font-size'],
					'size' => 'one_second'
				));
				
				// Font Color
				$html.= WPPAS_TPL::colorpicker_cont(array(
					'title' => __('Font color.','wpproads'), 
					'id' => 'edit_itm_font_color',
					'value' => $args['css']['item']['color'],
					'size' => 'one_second'
				));
				
				// Font family
				$html.= '<span class="input_container one_second">';
					$html.= '<h3 class="title">'.__('Font family.','wpproads').'</h3>';
					$html.= '<select id="edit_itm_fontfamily">';
						$html.= '<optgroup label="'.__('Classic Fonts','wpproads').'">';
							$html.= '<option value="Verdana" '.selected($args['css']['item']['font-family'], 'Verdana', false).'>Verdana</option>';
							$html.= '<option value="Arial" '.selected($args['css']['item']['font-family'], 'Arial', false).'>'.__('Arial','wpproads').'</option>';
							$html.= '<option value="Monospace" '.selected($args['css']['item']['font-family'], 'Monospace', false).'>'.__('Monospace','wpproads').'</option>';
							$html.= '<option value="Fantasy" '.selected($args['css']['item']['font-family'], 'Fantasy', false).'>'.__('Fantasy','wpproads').'</option>';
							$html.= '<option value="Cursive" '.selected($args['css']['item']['font-family'], 'Cursive', false).'>'.__('Cursive','wpproads').'</option>';
							$html.= '<option value="sans-serif" '.selected($args['css']['item']['font-family'], 'sans-serif', false).'>'.__('Sans-Serif','wpproads').'</option>';
							$html.= '<option value="serif" '.selected($args['css']['item']['font-family'], 'serif', false).'>'.__('Serif','wpproads').'</option>';
							$html.= '<option value="Impact" '.selected($args['css']['item']['font-family'], 'Impact', false).'>'.__('Impact','wpproads').'</option>';
						$html.= '</optgroup>';
						$html.= '<optgroup label="'.__('Google Fonts','wpproads').'">';
							$html.= $wppas_google_fonts->form_select_options(array('selected' => $args['css']['item']['font-family']));
						$html.= '</optgroup>';
					$html.= '</select>';
				$html.= '</span>';
				
				// TEXT ALIGN
				$html.= '<span class="input_container one_second">';
					$html.= '<h3 class="title">'.__('Text Align.','wpproads').'</h3>';
					$html.= '<select id="edit_itm_text_align">';
						$html.= '<option value="left" '.selected($args['css']['item']['text-align'], 'left', false).'>Left</option>';
						$html.= '<option value="center" '.selected($args['css']['item']['text-align'], 'center', false).'>'.__('Center','wpproads').'</option>';
						$html.= '<option value="right" '.selected($args['css']['item']['text-align'], 'right', false).'>'.__('Right','wpproads').'</option>';
					$html.= '</select>';
				$html.= '</span>';
				
				// Google Fonts preview
				$html.= '<span class="input_container">';
					$html.= '<h3 class="title">'.__('Google Fonts Preview.','wpproads').'</h3>';
					$html.= '<input id="gfont_select" type="text" />';
				$html.= '</span>';
				
			$html.= '</div>';
			// end .field_html 
			
			$html.= '<div class="clearFix"></div>';
        $html.= '</div>';
		
		return $html;
	}
	
	
	/**
	 * CSS EDITOR
	 *
	 */
	public function itm_editor_form_style($args = array())
	{
		$defaults = array(
			'ID' => 0,
			'css' => array() 
		);
		$args = wp_parse_args( $args, $defaults );
		
		$args['css'] = WPPAS_DEF::layer_css($args);
		
		$html = '';
		$html.= '<div class="itm_edit_form_style wppas_edit_form css_edit">'; //draggable_container
			//$html.= '<span class="input_container" style="height:1px;"></span>'; //fix
			$html.= '<div style="border-bottom:solid 1px #EFEFEF;padding:20px 0 0;margin:0 10px 10px;">'.__('Layer CSS:','wpproads').'</div>';
			// Width
			$html.= WPPAS_TPL::inpt_cont(array('title' => __('Width.','wpproads'), 'id' => 'edit_itm_width', 'size' => 'one_second'));
			// Height
			$html.= WPPAS_TPL::inpt_cont(array('title' => __('Height.','wpproads'), 'id' => 'edit_itm_height', 'size' => 'one_second'));
			
			// BG Color
			$html.= WPPAS_TPL::colorpicker_cont(array(
				'title' => __('Background Color.','wpproads'), 
				'id' => 'edit_layer_bg_color',
				'value' => $args['css']['layer']['background-color'],
				'size' => 'one_second'
			));
			
			// Custom class
			$custom_class = array_key_exists('custom_class', $args['css']['item']) ? $args['css']['item']['custom_class'] : '';
			$html.= WPPAS_TPL::inpt_cont(array('title' => __('Custom Class.','wpproads'), 'id' => 'edit_itm_class', 'size' => 'one_second', 'value' => $custom_class));
			
			$pos_h = array_key_exists('pos_h', $args['css']['layer']) ? $args['css']['layer']['pos_h'] : 'left';
			$pos_v = array_key_exists('pos_h', $args['css']['layer']) ? $args['css']['layer']['pos_v'] : 'top';
			$html.= WPPAS_TPL::align_cont(array(
				'title' => __('Align layer','wpproads'),
				'desc' => __('Layer alignment.','wpproads'),
				'id' => 'edit_itm_align',
				'value' => array($pos_h,$pos_v),
				'connect' => 'laoffset',
				'size' => 'one_second'
			));
			
			$html.= WPPAS_TPL::offset_cont(array(
				'title' => __('Position','wpproads'),
				'desc' => __('Layer positioning and padding','wpproads'),
				'offset' => array(
					'outer' => array(
						'label' => __('Offset','wpproads'),
						'id'    => array('top' => 'edit_itm_offset_top', 'right' => 'edit_itm_offset_right', 'bottom' => 'edit_itm_offset_bottom', 'left' => 'edit_itm_offset_left'),
						'name'  => array('top' => '', 'right' => '', 'bottom' => '', 'left' => ''),
						'value' => array('top' => '', 'right' => '', 'bottom' => '', 'left' => ''),
						'connect' => 'laoffset'
					),
					// Inner is optional
					'inner' => array(
						'label' => 'padding',
						'id'    => array('top' => 'edit_itm_padding_top', 'right' => 'edit_itm_padding_right', 'bottom' => 'edit_itm_padding_bottom', 'left' => 'edit_itm_padding_left'),
						'name'  => array('top' => '', 'right' => '', 'bottom' => '', 'left' => ''),
						'value' => array('top' => '', 'right' => '', 'bottom' => '', 'left' => '')
					)
				),
				'size' => 'one_second'
			));
			
			$html.= '<div class="clearFix"></div>';
			
        $html.= '</div>';
		
		return $html;
	}
	
	
	
	/**
	 * ANIMATION EDITOR
	 *
	 */
	public function itm_editor_animation($args = array())
	{
		$defaults = array(
			'ID' => 0,
			'animation' => array() 
		);
		$args = wp_parse_args( $args, $defaults );
		
		$ani_defaults = array(
			'start_animation_type' => '',
			'start_animation_effect' => 'linear',
			'start_animation_speed' => 1000,
			'end_animation_type' => '',
			'end_animation_effect' => 'linear',
			'end_animation_speed' => 1000,
			'end_animation_repeat' => 0,
			'fade_in_speed' => 500,
			'fade_out_speed' => 500,
			'start_time' => 0,
			'start_pos_offset' => 0,
			'end_time' => ''
		);
		$args['animation'] = wp_parse_args( $args['animation'], $ani_defaults );
		
		$easing = $this->jquery_easing();
		$html = '';
		
		$html.= '<div class="itm_animation_edit_form wppas_edit_form">';
			//$html.= '<span class="input_container" style="height:1px;"></span>'; //fix
			$html.= '<div style="border-bottom:solid 1px #EFEFEF;padding:20px 0 0;margin:0 10px 10px;">'.__('Layer Animation:','wpproads').'</div>';
			// Start time
			$html.= $this->inpt_cont(array('title' => __('Layer Start Time.','wpproads'), 'top', 'desc' => __('The time before this layer becomes visible (in miliseconds).','wpproads'), 'id' => 'edit_itm_start_time', 'icon' => 'clock-o', 'value' => $args['animation']['start_time']));
			
			
			
			// Start Animation Type
			$html.= '<span class="input_container one_second">';
				$html.= '<h3 class="title">'.__('Start Animation Type.','wpproads').'</h3>';
				$html.= '<select id="edit_itm_start_animation_type">';
					$html.= '<option value="" '.selected($args['animation']['start_animation_type'], '', false).'>'.__('No Animation','wpproads').'</option>';
					$html.= '<option value="fade_in" '.selected($args['animation']['start_animation_type'], 'fade_in', false).'>'.__('Fade In','wpproads').'</option>';
					$html.= '<option value="from_top" '.selected($args['animation']['start_animation_type'], 'from_top', false).'>'.__('Slide in from Top','wpproads').'</option>';
					$html.= '<option value="from_bottom" '.selected($args['animation']['start_animation_type'], 'from_bottom', false).'>'.__('Slide in from Bottom','wpproads').'</option>';
					$html.= '<option value="from_left" '.selected($args['animation']['start_animation_type'], 'from_left', false).'>'.__('Slide in from Left','wpproads').'</option>';
					$html.= '<option value="from_right" '.selected($args['animation']['start_animation_type'], 'from_right', false).'>'.__('Slide in from Right','wpproads').'</option>';
				$html.= '</select>';
				//$html.= '<span class="description bottom">'.__('Start Animation Type.','wpproads').'</span>';
			$html.= '</span>';
			
			
			// Start Animation Effect
			$html.= '<span class="input_container one_second">';
				$html.= '<h3 class="title">'.__('Start Animation Effect.','wpproads').'</h3>';
				$html.= '<select id="edit_itm_start_animation_effect">';
				
					foreach($easing as $ease)
					{
						$html.= '<option value="'.$ease.'" '.selected($args['animation']['start_animation_effect'], $ease, false).'>'.$ease.'</option>';
					}
				$html.= '</select>';
				//$html.= '<span class="description bottom">'.__('Start Animation Type.','wpproads').'</span>';
			$html.= '</span>';
			
			// Start Animation Speed
			$html.= WPPAS_TPL::inpt_cont(array('title' => __('Start Animation Speed.','wpproads'), 'desc' => __('(in miliseconds).','wpproads'), 'id' => 'edit_itm_start_animation_speed', 'size' => 'one_second', 'icon' => 'clock-o', 'value' => $args['animation']['start_animation_speed']));
			
			// Fade In Speed
			$html.= WPPAS_TPL::inpt_cont(array('title' => __('Fade In Speed.','wpproads'), 'desc' => __('(in miliseconds).','wpproads'), 'id' => 'edit_itm_fade_in_speed', 'size' => 'one_second', 'icon' => 'clock-o', 'value' => $args['animation']['fade_in_speed']));
			
			// Animation start position offset
			$html.= WPPAS_TPL::inpt_cont(array('title' => __('Start Offset.','wpproads'), 'desc' => __('Start position offset (in pixels).','wpproads'), 'id' => 'edit_itm_start_pos_offset', 'size' => 'one_second', 'value' => $args['animation']['start_pos_offset']));
			
			
			
			
			
			// End time
			$html.= $this->inpt_cont(array('title' => __('Layer End Time.','wpproads'), 'desc' => __('This is the time the layer will be visible before it starts the end animation (in miliseconds).','wpproads'), 'id' => 'edit_itm_end_time', 'icon' => 'clock-o', 'value' => $args['animation']['end_time']));	
			
			// End Animation Type
			$html.= '<span class="input_container one_second">';
				$html.= '<h3 class="title">'.__('End Animation Type.','wpproads').'</h3>';
				$html.= '<select id="edit_itm_end_animation_type">';
					$html.= '<option value="" '.selected($args['animation']['end_animation_type'], '', false).'>'.__('No Animation','wpproads').'</option>';
					$html.= '<option value="fade_out" '.selected($args['animation']['end_animation_type'], 'fade_in', false).'>'.__('Fade Out','wpproads').'</option>';
					$html.= '<option value="to_top" '.selected($args['animation']['end_animation_type'], 'from_top', false).'>'.__('Slide out to Top','wpproads').'</option>';
					$html.= '<option value="to_bottom" '.selected($args['animation']['end_animation_type'], 'from_bottom', false).'>'.__('Slide out to Bottom','wpproads').'</option>';
					$html.= '<option value="to_left" '.selected($args['animation']['end_animation_type'], 'from_left', false).'>'.__('Slide out to Left','wpproads').'</option>';
					$html.= '<option value="to_right" '.selected($args['animation']['end_animation_type'], 'from_right', false).'>'.__('Slide out to Right','wpproads').'</option>';
				$html.= '</select>';
				//$html.= '<span class="description bottom">'.__('End Animation Type.','wpproads').'</span>';
			$html.= '</span>';
			
			// END Animation Effect
			$html.= '<span class="input_container one_second">';
				$html.= '<h3 class="title">'.__('End Animation Effect.','wpproads').'</h3>';
				$html.= '<select id="edit_itm_end_animation_effect">';
					
					foreach($easing as $ease)
					{
						$html.= '<option value="'.$ease.'" '.selected($args['animation']['end_animation_effect'], $ease, false).'>'.$ease.'</option>';
					}
				$html.= '</select>';
				//$html.= '<span class="description bottom">'.__('Start Animation Type.','wpproads').'</span>';
			$html.= '</span>';
			
			// End Animation Speed
			$html.= $this->inpt_cont(array('title' => __('End Animation Speed.','wpproads'), 'desc' => __('(in miliseconds).','wpproads'), 'id' => 'edit_itm_end_animation_speed', 'size' => 'one_second', 'icon' => 'clock-o', 'value' => $args['animation']['end_animation_speed']));
			
			// Fade Out Speed
			$html.= $this->inpt_cont(array('title' => __('Fade Out Speed.','wpproads'), 'desc' => __('(in miliseconds).','wpproads'), 'id' => 'edit_itm_fade_out_speed', 'size' => 'one_second', 'icon' => 'clock-o', 'value' => $args['animation']['fade_out_speed']));
			
			// END animation repeat
			$html.= '<span class="input_container one_second">';
				$html.= '<h3 class="title">'.__('End Animation Repeat.','wpproads').'</h3>';
				$html.= '<select id="edit_itm_end_animation_repeat">';
					$html.= '<option value="0" '.selected($args['animation']['end_animation_repeat'], 0, false).'>'.__('No','wpproads').'</option>';
					$html.= '<option value="1" '.selected($args['animation']['end_animation_repeat'], 1, false).'>'.__('Yes','wpproads').'</option>';
				$html.= '</select>';
				$html.= '<span class="description bottom">'.__('Repeat this layer after it finishes.','wpproads').'</span>';
			$html.= '</span>';
			
			$html.= '<div class="clearFix"></div>';
		$html.= '</div>';
		return $html;
	}
	
	
	
	
	/**
	 * HTML EDITOR
	 */
	public function itm_editor_html($args = array())
	{
		$html = '';
		$code = '';
		
		if(!empty($args))
		{
			if( array_key_exists('data', $args) )
			{
				if( !empty($args['ID']))
				{
					$type_fix = explode('_', $args['ID']); // fix for older versions
					$type = array_key_exists('type', $args['data']) ? $args['data']['type'] : $type_fix[1];
					
					if($type == 'html')
					{
						$code = array_key_exists('code', $args['data']) ? $args['data']['code'] : '';
						$code = urldecode($code);
						//$html.= '<pre>'.print_r($args,true).'</pre>';
					}
				}
			}
		}
		$html.= '<textarea id="edit_itm_html_code" style="width:100%; height:200px;">'.$code.'</textarea>';
		
		return $html;
	}
	
	
	
	
	/**
	 * BUTTON EDITOR
	 */
	public function itm_editor_button($args = array())
	{
		$html = '';
		
		if(!empty($args))
		{
			if( array_key_exists('data', $args) )
			{
				$html.= $this->add_itm_button_form($args);
			}
		}
		
		return $html;
	}
	
	
	/**
	 * SVG EDITOR
	 */
	public function itm_editor_svg($args = array())
	{
		$html = '';
		$html.= $this->add_itm_svg_form($args);
		
		return $html;
	}
	
	
	
	/**
	 * IC0N EDITOR
	 */
	public function itm_editor_icon($args = array())
	{
		$defaults = array(
			'ID' => 0,
			'css' => array()
		);
		$args = wp_parse_args( $args, $defaults );
		
		$args['css'] = WPPAS_DEF::layer_css($args);
		
		$html = '';
		$html.= '<div class="itm_edit_form wppas_edit_form icon_edit">'; // itm_edit_form_style
			
			// Item Color
			$html.= WPPAS_TPL::colorpicker_cont(array(
				'title' => __('Icon Color.','wpproads'), 
				'id' => 'edit_itm_font_color',
				'value' => $args['css']['item']['color'],
				'size' => 'one_second'
			));
			
			// Font size
			$html.= WPPAS_TPL::inpt_cont(array(
				'title' => __('Font size.','wpproads'), 
				'id' => 'edit_itm_fontsize', 
				'placeholder' => __('12px','wpproads'), 
				'class' => 'field_font_size', 
				'icon' => 'text-height',
				'value' => $args['css']['item']['font-size'],
				'size' => 'one_second'
			));
			
		$html.= '</div>';
		
		return $html;
	}
	
	
	
	
	/**
	 * SHAPE EDITOR
	 */
	public function itm_editor_shape($args = array())
	{
		$html = '';
		$html.= $this->add_itm_shape_form($args);
		
				
		return $html;
	}
	
	
	
	
	
	
	/** 
	 * JQUERY Easing
	 *
	 */
	public function jquery_easing()
	{
		$easing = array(
			'linear',
			'swing',
			'easeOutBack',
			'easeInBack',
			'easeInOutBack',
			'easeOutBounce',
			'easeInBounce',
			'easeInOutBounce',
			'easeInElastic',
			'easeOutElastic',
			'easeInOutElastic',
			'easeInCubic',
			'easeOutCubic',
			'easeInOutCubic',
			'easeInQuad',
			'easeOutQuad',
			'easeInOutQuad',
		);
		
		return $easing;
	}
	
	

	
	
	/** 
	 * INPUT CONTAINER
	 *
	 */
	public function inpt_cont($args = array())
	{
		$defaults = array(
			'title'       => '',
			'name'        => '', 
			'slug'        => '',
			'id'          => '',
			'placeholder' => '',
			'value'       => '',
			'class'       => '',
			'size'        => '', // one_third
			'desc_pos'    => 'bottom', // bottom, top
			'desc'        => '',
			'show_icon'   => 1,
			'icon'        => 'pencil'
		);
		$args = wp_parse_args( $args, $defaults );
		
		$html = '';
		$html.= '<span class="input_container '.$args['size'].'">';
			$html.= !empty($args['title']) ? '<h3 class="title">'.$args['title'].'</h3>' : '';
			$html.= $args['desc_pos'] == 'top' && !empty($args['desc']) ? '<span class="description top">'.$args['desc'].'</span>' : '';
			$html.= '<div style="position: relative;">';
				$html.= '<input type="text" class="'.$args['class'].'" id="'.$args['id'].'" value="'.$args['value'].'" placeholder="'.$args['placeholder'].'" />';
				$html.= $args['show_icon'] ? '<i class="input_icon fa fa-'.$args['icon'].'" aria-hidden="true"></i>' : '';
			$html.= '</div>';
			$html.= $args['desc_pos'] == 'bottom' && !empty($args['desc']) ? '<span class="description bottom">'.$args['desc'].'</span>' : '';
		$html.= '</span>';
		
		return $html;
	}
	
	
	
	
	
	/** 
	 * BANNER REMOVE CONFIRMATION
	 *
	 */
	public function banner_remove_confirmation($bid)
	{
		$html = '';
		$html.= '<div class="wppas_remove_confirmation">';
			$html.= '<h3 style="margin-bottom:20px;">'.__('Banner Removed','wpproads').'</h3>';
			$html.= '<a id="wppas_undo_banner_removal" class="wppas_confi_btn" data-id="'.$bid.'">';
				$html.= '<div style="font-size:30px;margin-top:25px;"><i class="fa fa-undo" aria-hidden="true"></i></div>';
				$html.= '<div>'.__('Undo','wpproads').'</div>';
			$html.= '</a>';
			$html.= '<a href="admin.php?page=wppas-banner-creator&view=editor" class="wppas_confi_btn">';
				$html.= '<div style="font-size:30px;margin-top:25px;"><i class="fa fa-pencil" aria-hidden="true"></i></div>';
				$html.= '<div>'.__('New Banner','wpproads').'</div>';
			$html.= '</a>';
			$html.= '<a href="admin.php?page=wppas-banner-creator&view=banners" class="wppas_confi_btn">';
				$html.= '<div style="font-size:30px;margin-top:25px;"><i class="fa fa-object-ungroup" aria-hidden="true"></i></div>';
				$html.= '<div>'.__('All Banners','wpproads').'</div>';
			$html.= '</a>';
		$html.= '</div>';
		
		return $html;
	}
	
	
	
	
	
	
	
	/** 
	 * START SCREEN JS TEMPLATE
	 *
	 */
	public function start_screen_js()
	{
		$sizes = $this->screen_sizes(); 
		$screen_sizes = json_encode($sizes);
		
		$js = '';
        $js.= '<script type="text/javascript">';
		
			$js.= 'var _VBC = jQuery("#wppas_visual_bc_container");';
			$js.= 'var screen_sizes = '.$screen_sizes.';';
			
			$js.= 'jQuery(document).ready(function($) {';
			
				$js.= '_VBC.wppas.startscreen({screen_sizes: screen_sizes});';
				
			$js.= '});';
			
		$js.= '</script>';
       
		return $js;
	}
	
	
	
	
	
	
	/** 
	 * BANNER EDITOR JS TEMPLATE
	 *
	 */
	public function banner_editor_js( $args = array() )
	{
		$sizes = $this->screen_sizes(); 
		$screen_sizes = json_encode($sizes);
		//print_r($args['timeline_arr']);
		$js = '';
		
        $js.= '<script type="text/javascript">';
		
		$js.= 'var screen_sizes = '.$screen_sizes.';';
		
		$js.= 'var sizes_arr = [];
		jQuery.each(screen_sizes, function( index, value ) {
			sizes_arr.push(value.size);
		});';
		
		$js.= 'var itm_types = {';
			
			$types = $this->itm_types();
			foreach($types as $key => $type)
			{
				$js.= "'".$key."': { ";
					$js.= "'icon': "."'".$type['icon']."',";
					$js.= "'label': "."'".$type['label']."',";
				$js.= "},";
			}
		$js.= '};';
		
		$js.= 'var _VBC = jQuery("#wppas_visual_bc_container");';
			
		$js.= 'jQuery(document).ready(function($){';
			
			$js.= 'var bsize = $("#wppas_banner_size").val().split("x");';
			
			$js.= '$(".draggable_container").draggable({ handle: ".drag_handle" });';
			$js.= '$(".vbc-color-field").wpColorPicker();';
			
			$js.= '$("#banner-preview").css({"max-width":bsize[0]+"px", "max-height":bsize[1]+"px"});';
			//$js.= '$("#banner-preview").css({"width":bsize[0]+"px", "height":bsize[1]+"px"});';
			$js.= '$("#wppas_banner_work_area").css({"height":bsize[1]+"px"});';
			$js.= '$("#sizes_container").find(".1200").addClass("selected");';
			$js.= '_VBC.wppas.activate_switch_buttons();';
			$js.= '_VBC.wppas.wppas_b_container( {"width": bsize[0],"height": bsize[1]});';
			
			// Make workarea resizable
			$js.= '_VBC.wppas.wppas_resizable_work_area(bsize[1]);';
			
			$js.= '_VBC.wppas.editor({screen_sizes: screen_sizes, sizes_arr: sizes_arr, timeline_arr: '.json_encode($args['timeline_arr']).', ajaxurl: "'.admin_url( 'admin-ajax.php' ).'"});';
			//_VBC.wppas.save_banner_button( screen_sizes );
		$js.= '});';
		$js.= '</script>';
		
		
		return $js;
	}
	
	
	
	/**
	 * DISPLAY Options
	 */
	public function wppas_display_options($args = array())
	{
		$defaults = array(
			'ID' => 0,
			'type' => 'banner'
		);
		$args = wp_parse_args( $args, $defaults );
		
		$displays = array(
			'inline' => array(
				'name' => __('Inline','wpproads'),
				'desc' => __('Add banner into the page content.','wpproads'),
				'size' => '300x250', // size for example banner.
				'style' => ''
			),
			'sticky' => array(
				'name' => __('Sticky','wpproads'),
				'desc' => __('Add sticky banner overlapping page content.','wpproads'),
				'size' => '300x250', // size for example banner.
				'style' => 'position: absolute;bottom: 20%;border: none;border-right: solid 4px #F6F6F6;right: 0;'
			),
			'popup' => array(
				'name' => __('Popup','wpproads'),
				'desc' => __('Add popup banner overlapping page content.','wpproads'),
				'size' => '300x250', // size for example banner.
				'style' => 'position: absolute;bottom: 35%;border: none;right: 31%;'
			)
		);
		
		$html = '';
		$html.= '<div class="shortcode_editor" style="display:inline-block;width:55%;vertical-align:top;min-width:300px;background-color:#f9f9f9;margin-left:10px;border:solid 1px #EFEFEF;border-top:none;">';
			$html.= '<div class="info_header">';
				$html.= '<span class="nr">-</span>';
				$html.= '<span class="text">'.__('Display Options','wpproads').'</span>';
			$html.= '</div>';
			$html.= '<div class="wppas_info_btns" style="width:43%; text-align:left; display:inline-block;">';
				
				foreach($displays as $key => $display)
				{
					$type = 'inline';
					$s = explode('x',$display['size']);
					$w = ($s[0]*100)/800;
					$h = ($s[1]*100)/800;
					$selected = $key == 'inline' ? ' selected' : '';
					
					$html.= '<a class="wppas_home_tpl_btn export_display_options'.$selected.'" data-type="'.$key.'" edit="0">';
						$html.= '<div class="btn_icon">';
							$html.= '<div class="prev_banner_container">';
								$html.= '<div class="prev_banner" style="width:'.$w.'%; height:'.$h.'%;'.$display['style'].'"></div>';
							$html.= '</div>';
							
							$html.= $this->btn_prev_bg(2);
						$html.= '</div>';
						$html.= '<div class="btn_info">';
							$html.= '<h5 style="margin:0; font-size:14px;">'.$display['name'].'</h5>';
							$html.= '<span>'.$display['desc'].'</span>';
						$html.= '</div>';
						$html.= '<div class="clearFix"></div>';
					$html.= '</a>';
				}
					
			$html.= '</div>';
			
			$html.= '<div class="display_options" style="display:inline-block;width:50%;vertical-align:top;text-align:left;min-width:350px;">';
				$html.= '<div class="selected_options">';
					$html.= $this->wppas_display_option_tabs( $args );
				$html.= '</div>';
			$html.= '</div>';
		$html.= '</div>';
		// end .shortcode_editor
		
		return $html;	
	}
	
	
	
	/**
	 * form - DISPLAY Options
	 */
	public function wppas_display_option_tabs($args = array())
	{
		$html = '';
		
		$html.= '<div id="display_options_menu">';
			$html.= '<div id="display_options_container">';
				$html.= '<div class="footer" style="margin:20px 0;">';
					$html.= '<div class="wppas_update_sc button-secondary green">'.__('Update Shortcode','wpproads').'</div>';
				$html.= '</div>';
				$html.= '<ul class="vbc_menu_toggle itm_edit_menu_toggle">
						<li class="selected css_tab" data-target="itm-edit-defaults">
							'.__('Defaults','wpproads').'
						</li>
						<li class="font_tab" data-target="itm-edit-triggers">
							'.__('Triggers','wpproads').'
						</li>
						<li class="font_tab" data-target="itm-edit-devices">
							'.__('Devices','wpproads').'
						</li>
					</ul>';
					
					$html.= '<div id="itm_edit_content_container" style="border:solid 1px #EFEFEF;border-top:none;padding:10px;max-height:300px;overflow:auto;">';
						
						// Defaults
						$html.= '<div id="itm-edit-defaults" class="itm_nfer">
							
							<input type="hidden" id="dopt_ID" value="'.$args['ID'].'" />
							<input type="hidden" id="dopt_type" value="'.$args['type'].'" />
							
							<div class="display_option_form selected inline">'.$this->wppas_display_options_forms(array('type' => 'inline','option' => 'default')).'</div>
							<div class="display_option_form sticky">'.$this->wppas_display_options_forms(array('type' => 'sticky','option' => 'default')).'</div>
							<div class="display_option_form popup">'.$this->wppas_display_options_forms(array('type' => 'popup','option' => 'default')).'</div>
						</div>';
						
						// Triggers
						$html.= '<div id="itm-edit-triggers" class="itm_nfer" style="display:none;">
							<div class="display_option_form selected inline">'.$this->wppas_display_options_forms(array('type' => 'inline','option' => 'trigger')).'</div>
							<div class="display_option_form sticky">'.$this->wppas_display_options_forms(array('type' => 'sticky','option' => 'trigger')).'</div>
							<div class="display_option_form popup">'.$this->wppas_display_options_forms(array('type' => 'popup','option' => 'trigger')).'</div>
						</div>';
						
						// Devices
						$html.= '<div id="itm-edit-devices" class="itm_nfer" style="display:none;">
							<div class="display_option_form selected inline">'.$this->wppas_display_options_forms(array('type' => 'inline','option' => 'devices')).'</div>
							<div class="display_option_form sticky">'.$this->wppas_display_options_forms(array('type' => 'sticky','option' => 'devices')).'</div>
							<div class="display_option_form popup">'.$this->wppas_display_options_forms(array('type' => 'popup','option' => 'devices')).'</div>
						</div>';
						$html.= '<div class="clearFix"></div>';
					$html.= '</div>';
					
					$html.= '<div class="clearFix"></div>';
				$html.= '</div>';
				// end #display_options_container
				
				$html.= '<div class="footer" style="margin:20px 0;">';
					$html.= '<div class="wppas_update_sc button-secondary green">'.__('Update Shortcode','wpproads').'</div>';
				$html.= '</div>';
				
				$html.= '<div class="clearFix"></div>';	
			
		$html.= '</div>';
		// end #display_options_menu
		
		return $html;
	}
	
	
	
	
	/**
	 * Inline form - DISPLAY Options
	 */
	public function wppas_display_options_forms($args = array())
	{
		$html = '';
		$html.= '<input type="hidden" id="dopt_display" value="'.$args['type'].'" />';
		
		// -- INLINE OPTIONS --
		if($args['type'] == 'inline' )
		{
			if($args['option'] == 'default')
			{
				// Centrer banner
				$html.= WPPAS_TPL::checkbox_cont(array(
					'title' => __('Center banner:','wpproads'),
					'desc' => __('Keep the banner centered on the page.','wpproads'),
					'id' => 'dopt_center',
					'value' => 0,
					'chk-on' => __('ON','wpproads'),
					'chk-off' => __('OFF','wpproads'),
					'chk_width' => 50,
					'chk_height' => 30,
					'chk_btn_width' => 30,
					'size' => 'one_second'
				));
				
				// Effects
				// https://api.jqueryui.com/category/effects/
				$html.= WPPAS_TPL::select_cont(array(
					'title' => __('Effect','wpproads'),
					'desc' => __('Effect when banner gets loaded.','wpproads'),
					'id' => 'dopt_load_effect',
					'value' => '',
					'select_opts' => array(
						'none' => array('value' => '', 'text' => __('None', 'wpproads')),
						'blind' => array('text' => __('Blind', 'wpproads')),
						'bounce' => array('text' => __('Bounce', 'wpproads')),
						'clip' => array('text' => __('Clip', 'wpproads')),
						'drop' => array('text' => __('Drop', 'wpproads')),
						'explode' => array('text' => __('Explode', 'wpproads')),
						'fade' => array('text' => __('Fade', 'wpproads')),
						'fold' => array('text' => __('Fold', 'wpproads')),
						'highlight' => array('text' => __('Highlight', 'wpproads')),
						'puff' => array('text' => __('Puff', 'wpproads')),
						'pulsate' => array('text' => __('Pulsate', 'wpproads')),
						'scale' => array('text' => __('Scale', 'wpproads')),
						'shake' => array('text' => __('Shake', 'wpproads')),
						'slide' => array('text' => __('Slide', 'wpproads'))				
					),
					'size' => 'one_second'
				));
					
				// Margin
				$html.= WPPAS_TPL::offset_cont(array(
					'title' => __('Margin','wpproads'),
					'desc' => __('Add margin (value in pixels) to the top, right, bottom and left side off the banner.','wpproads'),
					'offset' => array(
						'outer' => array(
							'label' => __('Margin','wpproads'),
							'id'    => array('top' => 'dopt_margin_top', 'right' => 'dopt_margin_right', 'bottom' => 'dopt_margin_bottom', 'left' => 'dopt_margin_left'),
							'name'  => array('top' => '', 'right' => '', 'bottom' => '', 'left' => ''),
							'value' => array('top' => '', 'right' => '', 'bottom' => '', 'left' => '')
						)
					),
					'size' => 'one_second'
				));
				
				$html.= WPPAS_TPL::select_cont(array(
					'title' => __('Wrap Text','wpproads'),
					'desc' => __('Selecting Left or Right will wrap the text around your banner.','wpproads'),
					'id' => 'dopt_text_wrap',
					'select_opts' => array(
						'none' => array('value' => '', 'text' => __('Default - No text wrapping', 'wpproads')),
						'left' => array('text' => __('Left', 'wpproads')),
						'right' => array('text' => __('Right', 'wpproads'))
					),
					'size' => 'one_second'
				));
				
				$html.= WPPAS_TPL::inpt_cont(array(
					'title' => __('Custom Class','wpproads'),
					'desc' => __('Add a custom class to the main banner container.','wpproads'),
					'id' => 'dopt_custom_class',
					'size' => 'one_second'
				));
				
				
				$html.= WPPAS_TPL::sep_line(array(
					'title' => __("Banner container","wpproads"),
					'desc' => __('Add an extra container around the banner.','wpproads')
				));
				
				
				// INFO TEXT
				$html.= WPPAS_TPL::inpt_cont(array(
					'title' => __('Info text:','wpproads'),
					'desc' => __('This will add an extra container around the banner including some info text (like: "Advertisement").','wpproads'),
					'id' => 'dopt_info_text',
					'value' => '',
					'size' => 'one_second'
				));
				
				// INFO TEXT Position
				$html.= WPPAS_TPL::select_cont(array(
					'title' => __('Info Text Position','wpproads'),
					'desc' => __('Position for the info text.','wpproads'),
					'id' => 'dopt_inft_pos',
					'select_opts' => array(
						'top' => array('text' => __('Above the banner','wpproads')),
						'bottom' => array('text' => __('Under the banner','wpproads'))
					),
					'size' => 'one_second'
				));
				
				// INFO TEXT Font Size
				$html.= WPPAS_TPL::inpt_cont(array(
					'title' => __('Info text font-size:','wpproads'),
					'desc' => __('Font size for the info text (value in pixels).','wpproads'),
					'id' => 'dopt_inft_font_size',
					'value' => '',
					'size' => 'one_second'
				));
				
				// INFO TEXT Container bg Color
				$html.= WPPAS_TPL::colorpicker_cont(array(
					'title' => __('Background Color.','wpproads'),
					'desc' => __('The banner container background color.','wpproads'),
					'id' => 'dopt_inft_cont_bg',
					'value' => '',
					'size' => 'one_second'
				));
				
				// INFO TEXT Padding
				$html.= WPPAS_TPL::offset_cont(array(
					'title' => __('Padding','wpproads'),
					'desc' => __('Padding for the info text container around the banner (values in pixels).','wpproads'),
					'offset' => array(
						'outer' => array(
							'label' => __('Padding','wpproads'),
							'id'    => array('top' => 'dopt_inft_padding_top', 'right' => 'dopt_inft_padding_right', 'bottom' => 'dopt_inft_padding_bottom', 'left' => 'dopt_inft_padding_left'),
							'name'  => array('top' => '', 'right' => '', 'bottom' => '', 'left' => ''),
							'value' => array('top' => '', 'right' => '', 'bottom' => '', 'left' => '')
						)
					),
					'size' => 'one_second'
				));
			}
			elseif($args['option'] == 'trigger')
			{
				$html.= $this->trigger_options();
			}
			elseif($args['option'] == 'devices')
			{
				$html.= $this->devices_options();
			}
		}
		// -- STICKY OPTIONS --
		else if($args['type'] == 'sticky' )
		{
			if($args['option'] == 'default')
			{
				// Position
				$html.= WPPAS_TPL::select_cont(array(
					'title' => __('Position','wpproads'),
					'desc' => __('Banner position','wpproads'),
					'id' => 'dopt_position',
					'value' => '',
					'select_opts' => array(
						'top_left' => array('text' => __('Top Left', 'wpproads')),
						'top_center' => array('text' => __('Top Center', 'wpproads')),
						'top_right' => array('text' => __('Top Right', 'wpproads')),
						'center_left' => array('text' => __('Center Left', 'wpproads')),
						'center_center' => array('text' => __('Center Center', 'wpproads')),
						'center_right' => array('text' => __('Center Right', 'wpproads')),
						'bottom_left' => array('text' => __('Bottom Left', 'wpproads')),
						'bottom_center' => array('text' => __('Bottom Center', 'wpproads')),
						'bottom_right' => array('text' => __('Bottom Right', 'wpproads')),
					),
					'size' => 'one_second'
				));
				
				$html.= WPPAS_TPL::select_cont(array(
					'title' => __('Close Button','wpproads'),
					'desc' => __('Close button position','wpproads'),
					'id' => 'dopt_close_position',
					'value' => '',
					'select_opts' => array(
						'top_left' => array('text' => __('Top Left', 'wpproads')),
						'top_right' => array('text' => __('Top Right', 'wpproads'))
					),
					'size' => 'one_second'
				));
				
				$html.= WPPAS_TPL::offset_cont(array(
					'title' => __('Position Offset','wpproads'),
					'desc' => __('Add margin (value in pixels) to the top, right, bottom and left side on the selected position.','wpproads'),
					'offset' => array(
						'outer' => array(
							'label' => __('Margin','wpproads'),
							'id'    => array('top' => 'dopt_margin_top', 'right' => 'dopt_margin_right', 'bottom' => 'dopt_margin_bottom', 'left' => 'dopt_margin_left'),
							'name'  => array('top' => '', 'right' => '', 'bottom' => '', 'left' => ''),
							'value' => array('top' => '', 'right' => '', 'bottom' => '', 'left' => '')
						)
					),
					'size' => 'one_second'
				));
				
				// Effects
				// https://api.jqueryui.com/category/effects/
				$html.= WPPAS_TPL::select_cont(array(
					'title' => __('Effect','wpproads'),
					'desc' => __('Effect when banner gets loaded.','wpproads'),
					'id' => 'dopt_load_effect',
					'value' => '',
					'select_opts' => array(
						'none' => array('value' => '', 'text' => __('None', 'wpproads')),
						'blind' => array('text' => __('Blind', 'wpproads')),
						'bounce' => array('text' => __('Bounce', 'wpproads')),
						'clip' => array('text' => __('Clip', 'wpproads')),
						'drop' => array('text' => __('Drop', 'wpproads')),
						'explode' => array('text' => __('Explode', 'wpproads')),
						'fade' => array('text' => __('Fade', 'wpproads')),
						'fold' => array('text' => __('Fold', 'wpproads')),
						'highlight' => array('text' => __('Highlight', 'wpproads')),
						'puff' => array('text' => __('Puff', 'wpproads')),
						'pulsate' => array('text' => __('Pulsate', 'wpproads')),
						'scale' => array('text' => __('Scale', 'wpproads')),
						'shake' => array('text' => __('Shake', 'wpproads')),
						'slide' => array('text' => __('Slide', 'wpproads'))				
					),
					'size' => 'one_second'
				));
			}
			elseif($args['option'] == 'trigger')
			{
				$html.= $this->trigger_options();
			}
			elseif($args['option'] == 'devices')
			{
				$html.= $this->devices_options();
			}
		}
		// -- POPUP OPTIONS --
		else if($args['type'] == 'popup')
		{
			if($args['option'] == 'default')
			{
				// Effects
				// https://api.jqueryui.com/category/effects/
				$html.= WPPAS_TPL::select_cont(array(
					'title' => __('Effect','wpproads'),
					'desc' => __('Effect when banner gets loaded.','wpproads'),
					'id' => 'dopt_load_effect',
					'value' => '',
					'select_opts' => array(
						'none' => array('value' => '', 'text' => __('None', 'wpproads')),
						'blind' => array('text' => __('Blind', 'wpproads')),
						'bounce' => array('text' => __('Bounce', 'wpproads')),
						'clip' => array('text' => __('Clip', 'wpproads')),
						'drop' => array('text' => __('Drop', 'wpproads')),
						'explode' => array('text' => __('Explode', 'wpproads')),
						'fade' => array('text' => __('Fade', 'wpproads')),
						'fold' => array('text' => __('Fold', 'wpproads')),
						'highlight' => array('text' => __('Highlight', 'wpproads')),
						'puff' => array('text' => __('Puff', 'wpproads')),
						'pulsate' => array('text' => __('Pulsate', 'wpproads')),
						'scale' => array('text' => __('Scale', 'wpproads')),
						'shake' => array('text' => __('Shake', 'wpproads')),
						'slide' => array('text' => __('Slide', 'wpproads'))				
					),
					'size' => 'one_second'
				));
				
				
				// Popup bg Color
				$html.= WPPAS_TPL::colorpicker_cont(array(
					'title' => __('Background Color.','wpproads'),
					'desc' => __('The popup background color.','wpproads'),
					'id' => 'dopt_popup_bg',
					'value' => 'rgba(0,0,0,0.75)',
					'size' => 'one_second'
				));
			}
			elseif($args['option'] == 'trigger')
			{
				$html.= $this->trigger_options();
			}
			elseif($args['option'] == 'devices')
			{
				$html.= $this->devices_options();
			}
		}
		
		return $html;
	}
	
	
	
	
	public function trigger_options()
	{
		$html = '';
		
		$html.= '<div class="trigger_options">';
			$html.= '<a class="trigger_itm_btn" data-type="delay">';
				$html.= '<i class="fa fa-clock-o" aria-hidden="true"></i>';
				$html.= '<span class="info">'.__('Delay','wpproads').'</span>';
			$html.= '</a>';
			$html.= '<a class="trigger_itm_btn" data-type="scroll_detect">';
				$html.= '<i class="fa fa-arrows-v" aria-hidden="true"></i>';
				$html.= '<span class="info">'.__('Scroll Detection','wpproads').'</span>';
			$html.= '</a>';
			$html.= '<a class="trigger_itm_btn" data-type="inactive">';
				$html.= '<i class="fa fa-clock-o" aria-hidden="true"></i>';
				$html.= '<span class="info">'.__('User Inactivity','wpproads').'</span>';
			$html.= '</a>';
		$html.= '</div>';
		
		$html.= '<div class="trigger_options_forms">';
			$html.= '<input type="hidden" value="" id="dopt_trigger_option" class="dopt_trigger_option" />';
			
			// Delay
			$html.= '<div id="delay" class="trigger_option_form">';
				$html.= __('Show the banner after x amount of seconds.','wpproads');
				$html.= $this->inpt_cont(array('title' => __('Trigger after x seconds','wpproads'), 'id' => 'dopt_trigger_delay','icon' => 'clock-o'));
			$html.= '</div>';
		
		
			// Scroll Detect
			$html.= '<div id="scroll_detect" class="trigger_option_form">';
				$html.= __('Show the banner when the user reaches a specific area of the page.','wpproads');
				
				$html.= '<span class="input_container">';
					$html.= '<h3 class="title">'.__('Trigger when user reaches','wpproads').'</h3>';
					$html.= '<select id="dopt_trigger_scroll_position">';
						$html.= '<option value="middle">'.__('Middle of the page','wpproads').'</option>';
						$html.= '<option value="bottom">'.__('Bottom of the page','wpproads').'</option>';
					$html.= '</select>';
				$html.= '</span>';
			$html.= '</div>';
			
			// Inactivity
			$html.= '<div id="inactive" class="trigger_option_form">';
				$html.= __('Show the banner when a user is inavtive for x amount of time.','wpproads');
				$html.= $this->inpt_cont(array('title' => __('Trigger after x seconds','wpproads'), 'id' => 'dopt_trigger_inactive_sec','icon' => 'clock-o'));
			$html.= '</div>';
		$html.= '</div>';	
		
		return $html;
	}
	
	
	
	
	
	public function devices_options()
	{
		$html = '';
		
		// DESKTOP
		$html.= WPPAS_TPL::checkbox_cont(array(
			'title' => __('Desktop','wpproads'),
			'desc' => __('Show banner on desktops.','wpproads'),
			'id' => 'dopt_show_desktop',
			'value' => 1,
			'chk-on' => __('YES','wpproads'),
			'chk-off' => __('NO','wpproads'),
			'chk_width' => 50,
			'chk_height' => 30,
			'chk_btn_width' => 30,
			'size' => 'one_third'
		));
		// TABLET
		$html.= WPPAS_TPL::checkbox_cont(array(
			'title' => __('Tablet','wpproads'),
			'desc' => __('Show banner on tablet devices.','wpproads'),
			'id' => 'dopt_show_tablet',
			'value' => 1,
			'chk-on' => __('YES','wpproads'),
			'chk-off' => __('NO','wpproads'),
			'chk_width' => 50,
			'chk_height' => 30,
			'chk_btn_width' => 30,
			'size' => 'one_third'
		));
		// MOBILE
		$html.= WPPAS_TPL::checkbox_cont(array(
			'title' => __('Mobile','wpproads'),
			'desc' => __('Show banner on mobile devices.','wpproads'),
			'id' => 'dopt_show_mobile',
			'value' => 1,
			'chk-on' => __('YES','wpproads'),
			'chk-off' => __('NO','wpproads'),
			'chk_width' => 50,
			'chk_height' => 30,
			'chk_btn_width' => 30,
			'size' => 'one_third'
		));
		
		$html.= '<hr>';
		
		// IOS
		$html.= WPPAS_TPL::checkbox_cont(array(
			'title' => __('IOS','wpproads'),
			'desc' => __('Show banner on IOS devices.','wpproads'),
			'id' => 'dopt_show_ios',
			'value' => 1,
			'chk-on' => __('YES','wpproads'),
			'chk-off' => __('NO','wpproads'),
			'chk_width' => 50,
			'chk_height' => 20,
			'chk_btn_width' => 30,
			'size' => 'one_third'
		));
		// Android
		$html.= WPPAS_TPL::checkbox_cont(array(
			'title' => __('Android','wpproads'),
			'desc' => __('Show banner on Android devices.','wpproads'),
			'id' => 'dopt_show_android',
			'value' => 1,
			'chk-on' => __('YES','wpproads'),
			'chk-off' => __('NO','wpproads'),
			'chk_width' => 50,
			'chk_height' => 20,
			'chk_btn_width' => 30,
			'size' => 'one_third'
		));
		// Windows Mobile
		$html.= WPPAS_TPL::checkbox_cont(array(
			'title' => __('Windows Mobile','wpproads'),
			'desc' => __('Show banner on Windows Mobile devices.','wpproads'),
			'id' => 'dopt_show_windows_mobile',
			'value' => 1,
			'chk-on' => __('YES','wpproads'),
			'chk-off' => __('NO','wpproads'),
			'chk_width' => 50,
			'chk_height' => 20,
			'chk_btn_width' => 30,
			'size' => 'one_third'
		));
		// IPhone
		$html.= WPPAS_TPL::checkbox_cont(array(
			'title' => __('Iphone','wpproads'),
			'desc' => __('Show banner on Iphones.','wpproads'),
			'id' => 'dopt_show_iphone',
			'value' => 1,
			'chk-on' => __('YES','wpproads'),
			'chk-off' => __('NO','wpproads'),
			'chk_width' => 50,
			'chk_height' => 20,
			'chk_btn_width' => 30,
			'size' => 'one_third'
		));
		// IPad
		$html.= WPPAS_TPL::checkbox_cont(array(
			'title' => __('Ipad','wpproads'),
			'desc' => __('Show banner on Ipads.','wpproads'),
			'id' => 'dopt_show_ipad',
			'value' => 1,
			'chk-on' => __('YES','wpproads'),
			'chk-off' => __('NO','wpproads'),
			'chk_width' => 50,
			'chk_height' => 20,
			'chk_btn_width' => 30,
			'size' => 'one_third'
		));
		// IPod
		$html.= WPPAS_TPL::checkbox_cont(array(
			'title' => __('Ipod','wpproads'),
			'desc' => __('Show banner on Ipods.','wpproads'),
			'id' => 'dopt_show_ipod',
			'value' => 1,
			'chk-on' => __('YES','wpproads'),
			'chk-off' => __('NO','wpproads'),
			'chk_width' => 50,
			'chk_height' => 20,
			'chk_btn_width' => 30,
			'size' => 'one_third'
		));
		// Samsung
		$html.= WPPAS_TPL::checkbox_cont(array(
			'title' => __('Samsung','wpproads'),
			'desc' => __('Show banner on Samsung devices.','wpproads'),
			'id' => 'dopt_show_samsung',
			'value' => 1,
			'chk-on' => __('YES','wpproads'),
			'chk-off' => __('NO','wpproads'),
			'chk_width' => 50,
			'chk_height' => 20,
			'chk_btn_width' => 30,
			'size' => 'one_third'
		));
		// blackberry
		$html.= WPPAS_TPL::checkbox_cont(array(
			'title' => __('Blackberry','wpproads'),
			'desc' => __('Show banner on Blackberry devices.','wpproads'),
			'id' => 'dopt_show_blackberry',
			'value' => 1,
			'chk-on' => __('YES','wpproads'),
			'chk-off' => __('NO','wpproads'),
			'chk_width' => 50,
			'chk_height' => 20,
			'chk_btn_width' => 30,
			'size' => 'one_third'
		));
		// sony_ericsson
		$html.= WPPAS_TPL::checkbox_cont(array(
			'title' => __('Sony Ericsson','wpproads'),
			'desc' => __('Show banner on Sony Ericsson devices.','wpproads'),
			'id' => 'dopt_show_sony_ericsson',
			'value' => 1,
			'chk-on' => __('YES','wpproads'),
			'chk-off' => __('NO','wpproads'),
			'chk_width' => 50,
			'chk_height' => 20,
			'chk_btn_width' => 30,
			'size' => 'one_third'
		));
		// Motorola
		$html.= WPPAS_TPL::checkbox_cont(array(
			'title' => __('Motorola','wpproads'),
			'desc' => __('Show banner on Motorola devices.','wpproads'),
			'id' => 'dopt_show_motorola',
			'value' => 1,
			'chk-on' => __('YES','wpproads'),
			'chk-off' => __('NO','wpproads'),
			'chk_width' => 50,
			'chk_height' => 20,
			'chk_btn_width' => 30,
			'size' => 'one_third'
		));
		
		return $html;
	}
	
	
	
	
	
	/**
	 * CREATE TEMPORARY BANNER FOLDER
	 *
	 *
	 */
	public function create_temp_banner_folder($args = array(), $banner = '')
	{
		$defaults = array(
			'bid' => 0,
			'create_folder' => 0
		);
		$args = wp_parse_args( $args, $defaults );
		
		$folder = '';
		
		if( $args['create_folder'] )
		{
			$upload = wp_upload_dir();
			$upload_dir = $upload['basedir'];
			$alphaID = $banner['banner_data'][0]['timeline_arr']['main']['alphaID'];
			
			if( !empty($alphaID) )
			{
				$folder = '/wppas/banners/'.$alphaID;
				
				$banner_dir = $upload_dir . $folder;
				wp_mkdir_p( $banner_dir );
			}
		}
		
		return $folder;
	}
	
	
	
	
	/**
	 * CREATE BANNER FROM ZIP UPLOAD
	 */
	public function create_banner_from_zip($zip = array())
	{
		$banner_data = $this->load_banner_data();
		$alphaID = $banner_data['banner_data'][0]['timeline_arr']['main']['alphaID'];	
		$folder = $this->create_temp_banner_folder(array('create_folder' => 1), $banner_data);
		
		$upload_result = $this->upload_and_unzip($zip, array('folder' => $folder));
		$upload_result = json_decode($upload_result,true);
		
		$bannerID = $this->insert(array('title' => sprintf(__('Zip Upload %s','wpproads'),$alphaID)));
		$banner_data['banner_data'][0]['ID'] = $bannerID;
		$banner_data['banner_data'][0]['timeline_arr'][1200]['wpyukff_html'] = array(
			'ID' => 'wpyukff_html',
			'zindex' => 1,
			'css' => array(
				'item' => array(),
				'layer' => array(
					'pos_h' => 0,
					'pos_v' => 0
				)
			),
			'data' => array(
				'code' => WPPAS_TPL::encodeURIComponent('<iframe src="'.$upload_result['url'].'" width="100%" height="100%"></iframe>'),
				'itm' => 'html',
				'object' => 'html',
				'type' => 'html'
			),
			'animation' => array(),
			'font' => array()
		);
	
		update_post_meta($bannerID, '_wpproads_banner_data', $banner_data['banner_data'][0]);
		update_post_meta($bannerID, '_wpproads_banner_type', 'vbc');
		$upload_result['bnr_item'] = $this->all_banners_item($bannerID);
		
		return json_encode($upload_result);
	}
	
	
	
	
	/**
	 * UPLOAD AND UNZIP ZIP FILES
	 *
	 */
	public function upload_and_unzip($zip = array(), $args = array())
	{
		$wp_upload_folder = wp_upload_dir();
		/*
		wp_mkdir_p( '/wppas' );
		wp_mkdir_p( '/wppas/wppas_temp' );
		wp_mkdir_p( '/wppas/wppas_html5' );
		$temp_upload_folder = $wp_upload_folder['basedir'].'/wppas/wppas_temp'; // /wppas/wppas_temp/ change this to the correct site path
		$unzip_folder = $wp_upload_folder['basedir'].'/wppas/wppas_html5'; // /wppas/wppas_html5/ change this to the correct site path
		$target_path = $temp_upload_folder.$zip['name']; */
		$temp_upload_folder = $wp_upload_folder['basedir'].$args['folder'];
		$unzip_folder = $wp_upload_folder['basedir'].$args['folder'];
		$target_path = $wp_upload_folder['basedir'].$args['folder'].'/'.$zip['name'];
		$msg = __('No files to upload received.','wpproads'); 
		$response = array(
			'success' => false,
			'html' => $msg,
			'url' => '',
			'type' => 'zip'
		);
		$is_zip = 0;
		
		if( !empty($zip))
		{
			$name = explode('.', $zip['name']);
			$accepted_types = array('application/zip', 'application/x-zip-compressed', 'multipart/x-zip', 'application/x-compressed');
			foreach($accepted_types as $mime_type) {
				if($mime_type == $zip['type']) {
					//$okay = true;
					$is_zip = 1;
					break;
				} 
			}
			
			//rebuild folder name - fix for dots in name.
			$folder_name = '/';
			foreach($name as $i => $nm)
			{
				$dot = $i > 0 ? '.' : '';
				$folder_name .= strtolower($nm) != 'zip' ? $dot.$nm : '';
				$is_zip = strtolower($nm) == 'zip' ? 1 : $is_zip;
			}
			
			// Check if file is zip file to continue.
			$continue = $is_zip ? true : false;
			if(!$continue) {
				$msg = __('The file you are trying to upload is not a .zip file. Please try again.','wpproads');
				$response['html'] = $msg;
				
				return $response;
			}
		
			
			//add_filter( 'upload_dir', 'wppas_141088_upload_dir' );
			//remove_filter( 'upload_dir', 'wppas_141088_upload_dir' );
			
			if(move_uploaded_file($zip['tmp_name'], $target_path)) 
			{
				$zip = new ZipArchive();
				$x = $zip->open($target_path);
				if ($x === true) 
				{
					$zip->extractTo($unzip_folder); // change this to the correct site path
					$zip->close();
			
					unlink($target_path);
				}
				$msg = __('Your .zip file was uploaded and unpacked:','wpproads');
				$response['success'] = true;
				$package_files = scandir($unzip_folder.$folder_name);
				$has_index = in_array('index.html', $package_files) ? 1 : 0;
				
				// Check if we can find a index.html file
				if( $has_index )
				{
					$msg.= ' '.$unzip_folder.$folder_name.'/index.html';
					$response['html'] = $msg;
				}
				else
				{
					$msg.= ' but we were unable to detect an index.html file. You will need to add the start file manually to the folder name. <strong>'.$unzip_folder.$folder_name.'/</strong>';
					$response['url'] = $wp_upload_folder['baseurl'].$args['folder'].$folder_name;
					$response['html'] = $msg;
				}
				/*foreach( $package_files as $package_file )
				{
					echo $unzip_folder.$folder_name.$package_file;
				}*/
				//echo '<pre>'.print_r($files1, true).'</pre>';
			} 
			else 
			{	
				$msg = __('There was a problem with the upload. Please try again. '.$target_path,'wpproads');
				$response['html'] = $msg;
			}
		}
		
		return json_encode($response);
		//return $msg;
	}
	
	
	
	
	/**
	 * INSERT NEW BANNER
	 */
	public function insert($args = array())
	{
		global $current_user;
		
		$defaults = array(
			'title' => 'Time: '.current_time('timestamp'),
			'post_type' => 'wppas_banners'
		);
		$args = wp_parse_args( $args, $defaults );
		
		// Insert new banner
		$b_data = array(
			'post_title'       		=> $args['title'],
			'post_content'     		=> '',
			'post_category'   		    => array(),
			'post_status'      		=> 'publish',
			'post_type'        		=> $args['post_type'],
			'post_date'             => date('Y-m-d H:i:s', current_time('timestamp')),
			'post_date_gmt'         => date('Y-m-d H:i:s', current_time('timestamp', 1)),
			'post_author'           => $current_user->ID,
			'ping_status'           => get_option('default_ping_status'), 
			'post_parent'           => 0,
			'menu_order'            => 0,
			'to_ping'               => '',
			'pinged'                => '',
			'post_password'         => '',
			'guid'                  => '',
			'post_content_filtered' => '',
			'post_excerpt'          => '',
			'import_id'             => 0,
			'tags_input'            => '',
			'filter' => true	
		);
		
		// Filter to do something with the post data
		$b_data = apply_filters( 'wppas_insert_banner_data', $b_data );		
		$ID = wp_insert_post( $b_data );	
		
		return $ID;
	}
	
	
	
	
	
	/*
	 * Add ads to posts if necessary
	 *
	 * @access public
	 * @return array
	*/
	public function update_content($content) 
	{
		global $post;
		
		if(!is_single() && !is_page())
		{
			return $content;
		}
		
		// Load all banners
		$banners = $this->all_banners_query();
		$new_content = '';
		
		if( !empty($banners))
		{
			foreach( $banners as $banner )
			{
				$data = $this->vbc_banner_data(array('bid' => $banner->ID, 'type' => 'auto_show', 'default' => array()));
				$post_types = !empty($data) && array_key_exists('post_types', $data) ? $data['post_types'] : $data;
				$content_str = !empty($new_content) ? $new_content : $content;
				
				if(!empty($post_types))
				{
					// Check post type
					if( in_array(get_post_type($post->ID), $post_types))
					{	
						$show = apply_filters( 'wpproads_show_banner_in_post', 1, $post->ID );
						$show = !is_singular(get_post_type($post->ID)) ? 0 : $show;
						
						if( $show )
						{
							if( $data['position'] == 'top' )
							{
								$ad = !empty($data['shortcode']) ? do_shortcode($data['shortcode']) : do_shortcode('[wpproads id="'.$banner->ID.'"]');
								$new_content = $ad.$content_str;
							}
							elseif( $data['position'] == 'bottom')
							{
								$ad = !empty($data['shortcode']) ? do_shortcode($data['shortcode']) : do_shortcode('[wpproads id="'.$banner->ID.'"]');
								$new_content = $content_str.$ad;
							}
							elseif( $data['position'] == 'middle')
							{
								//$str = !empty($new_content) ? $new_content : $content;
								$cont_arr = explode ( "</p>", $content_str );
								$new_cont = '';
								foreach( $cont_arr as $i => $cont )
								{
									if ( $i == $data['paragraph'] ) 
									{
										$ad = !empty($data['shortcode']) ? do_shortcode($data['shortcode']) : do_shortcode('[wpproads id="'.$banner->ID.'"]');
										$new_cont.= $ad;
									}
									$new_cont.= $cont . "</p>";
								}
								$new_content = $new_cont;
							}
						}
					}
				}
			}
		}
		
		return !empty($new_content) ? $new_content : $content;
	}
	
}
?>