<?php
/*
Plugin Name: Site Generator Replacement
Plugin URI: http://premium.wpmudev.org/project/site-generator-replacement
Description: Easily customize ALL "Site Generator" text and links. Edit under Site Admin "Options" menu.
Author: S H Mohanjith (Incsub), Andrew Billits (Incsub)
Version: 1.0.2.2
Author URI: http://premium.wpmudev.org
WDP ID: 18
Network: true
Text Domain: site_generator_replacement
*/

/*
Copyright 2007-2009 Incsub (http://incsub.com)

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License (Version 2 - GPLv2) as published by
the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

global $site_generator_replacement_settings_page, $site_generator_replacement_settings_page_long;

if ( version_compare($wp_version, '3.0.9', '>') ) {
	$site_generator_replacement_settings_page = 'settings.php';
	$site_generator_replacement_settings_page_long = 'network/settings.php';
} else {
	$site_generator_replacement_settings_page = 'ms-admin.php';
	$site_generator_replacement_settings_page_long = 'ms-admin.php';
}

//------------------------------------------------------------------------//
//---Hook-----------------------------------------------------------------//
//------------------------------------------------------------------------//
add_action("init", "site_generator_replacement_init");
add_action('admin_menu', 'site_generator_replacement_plug_pages');
add_action('network_admin_menu', 'site_generator_replacement_plug_pages');
add_filter("get_the_generator_html", "site_generator_replacement", 99, 2);
add_filter("get_the_generator_xhtml", "site_generator_replacement", 99, 2);
add_filter("get_the_generator_atom", "site_generator_replacement", 99, 2);
add_filter("get_the_generator_rss2", "site_generator_replacement", 99, 2);
add_filter("get_the_generator_rdf", "site_generator_replacement", 99, 2);
add_filter("get_the_generator_comment", "site_generator_replacement", 99, 2);
add_filter("get_the_generator_export", "site_generator_replacement", 99, 2);
//------------------------------------------------------------------------//
//---Functions------------------------------------------------------------//
//------------------------------------------------------------------------//

function site_generator_replacement_init() {
	if ( !is_multisite() )
		exit( 'The Site Generator Replacement plugin is only compatible with WordPress Multisite.' );

	load_plugin_textdomain('site_generator_replacement', false, dirname(plugin_basename(__FILE__)).'/languages');
}

function site_generator_replacement_plug_pages() {
	global $wpdb, $wp_roles, $current_user, $wp_version, $site_generator_replacement_settings_page, $site_generator_replacement_settings_page_long;

	if ( version_compare($wp_version, '3.0.9', '>') ) {
	    if ( is_network_admin() ) {
		add_submenu_page($site_generator_replacement_settings_page, __('Site Generator Replacement', 'site_generator_replacement'), __('Site Generator Replacement', 'site_generator_replacement'), 'manage_network_options', 'site_generator_replacement', 'site_generator_replacement_site_admin_options');
	    }
	} else {
	    if ( is_site_admin() ) {
		add_submenu_page($site_generator_replacement_settings_page, __('Site Generator Replacement', 'site_generator_replacement'), __('Site Generator Replacement', 'site_generator_replacement'), 'manage_network_options', 'site_generator_replacement', 'site_generator_replacement_site_admin_options');
	    }
	}
}

function site_generator_replacement($gen, $type) {
	$global_site_generator = get_site_option("site_generator_replacement");
	$global_site_link = get_site_option("site_generator_replacement_link");
	if ( empty($global_site_generator) ) {
		global $current_site;
		$global_site_generator = $current_site->site_name;
	}
	if ( empty($global_site_link) ) {
		global $current_site;
		$global_site_link = "http://". $current_site->domain . $current_site->path;
	}
	switch($type) {
		case 'html':
			$gen = '<meta name="generator" content="' . $global_site_generator . '">' . "\n";
			break;
		case 'xhtml':
			$gen = '<meta name="generator" content="' . $global_site_generator . '" />' . "\n";
			break;
		case 'atom':
			$gen = '<generator uri="' . $global_site_link . '" version="' . get_bloginfo_rss( 'version' ) . '">' . $global_site_generator . '</generator>';
			break;
		case 'rss2':
			$gen = '<generator>' . $global_site_link . '?v=' . get_bloginfo_rss( 'version' ) . '</generator>';
			break;
		case 'rdf':
			$gen = '<admin:generatorAgent rdf:resource="' . $global_site_link . '?v=' . get_bloginfo_rss( 'version' ) . '" />';
			break;
		case 'comment':
			$gen = '<!-- generator="' . $global_site_generator . '/' . get_bloginfo( 'version' ) . '" -->';
			break;
		case 'export':
			$gen = '<!-- generator="' . $global_site_generator . '/' . get_bloginfo_rss('version') . '" created="'. date('Y-m-d H:i') . '"-->';
			break;
	}
	return $gen;
}

function site_generator_replacement_site_admin_options() {
	global $wpdb, $wp_roles, $current_user, $site_generator_replacement_settings_page;

	if(!current_user_can('manage_options')) {
		echo "<p>" . __('Nice Try...', 'site_generator_replacement') . "</p>";  //If accessed properly, this message doesn't appear.
		return;
	}
	if (isset($_GET['updated'])) {
		?><div id="message" class="updated fade"><p><?php _e(urldecode($_GET['updatedmsg']), 'site_generator_replacement') ?></p></div><?php
	}
	echo '<div class="wrap">';
	switch( $_GET[ 'action' ] ) {
		//---------------------------------------------------//
		default:
		$global_site_generator = get_site_option("site_generator_replacement");
		$global_site_link = get_site_option("site_generator_replacement_link");
		if ( empty($global_site_generator) ) {
			global $current_site;
			$global_site_generator = $current_site->site_name;
		}
		if ( empty($global_site_link) ) {
			global $current_site;
			$global_site_link = "http://". $current_site->domain . $current_site->path;
		}
	?>
		<h2><?php _e('Site Generator Options', 'site_generator_replacement') ?></h2>
		<form method="post" action="<?php print $site_generator_replacement_settings_page; ?>?page=site_generator_replacement&action=process">
		<table class="form-table">
			<tr valign="top">
				<th scope="row">
					<?php _e('Generator Text', 'site_generator_replacement') ?>
				</th>
				<td>
					<input type="text" name="site_generator_replacement" id="site_generator_replacement" style="width: 95%" value="<?php echo stripslashes($global_site_generator); ?>" />
					<?php _e('<br /><small>Change the "generator" information from WordPress to something you prefer.</small>', 'site_generator_replacement'); ?>
				</td>
			</tr>
			<tr valign="top">
				<th scope="row">
					<?php _e('Generator Link', 'site_generator_replacement') ?>
				</th>
				<td>
					<input type="text" name="site_generator_replacement_link" id="site_generator_replacement_link" style="width: 95%" value="<?php echo stripslashes($global_site_link); ?>" />
					<?php _e('<br /><small>Change the "generator link" from WordPress to something you prefer.</small>', 'site_generator_replacement'); ?>
				</td>
			</tr>
		</table>
			<p class="submit">
				<input class="button button-primary" type="submit" name="Submit" value="<?php _e('Save Changes', 'site_generator_replacement') ?>" />
			</p>
		</form>
	<?php
		break;
		//---------------------------------------------------//
		case "process":
			update_site_option( "site_generator_replacement", $_POST['site_generator_replacement'] );
			update_site_option( "site_generator_replacement_link", $_POST['site_generator_replacement_link'] );
			echo "<SCRIPT LANGUAGE='JavaScript'>
				window.location='{$site_generator_replacement_settings_page}?page=site_generator_replacement&updated=true&updatedmsg=" . urlencode(__('Changes saved.', 'site_generator_replacement')) . "';
			</script>";
		break;
		//---------------------------------------------------//
		case "temp":
		break;
		//---------------------------------------------------//
	}
	echo '</div>';
}

global $wpmudev_notices;
$wpmudev_notices[] = array( 'id'=> 18, 'name'=> 'Site Generator Replacement', 'screens' => array( 'settings_page_site_generator_replacement-network' ) );
include_once(plugin_dir_path( __FILE__ ).'external/dash-notice/wpmudev-dash-notification.php');