<?php

/*
  Default settings
 */
$this->defaults = array(
	/* 	IMPORTANT! DO NOT CHANGE THE ORDER OF THESE ARGUMENTS!
	  REQUIRED FOR BACKWARDS COMPATIBILITY. IF YOU NEED TO
	  ADD AN ADDITIONAL DEFAULT ADD IT TO THE END OF EACH ARRAY */
	'list_products' => array(
		'echo'		 => true,
		'paginate'	 => NULL,
		'page'		 => NULL,
		'per_page'	 => NULL,
		'order_by'	 => NULL,
		'order'		 => NULL,
		'category'	 => NULL,
		'tag'		 => NULL,
		'list_view'	 => NULL,
		'filters'	 => NULL,
		'limit'		 => NULL,
	),
);

/*
  MarketPress Data Structures
 */
$this->default_settings = array(
	'base_country'				 => 'US',
	'zip_label'					 => __( 'Zip Code', 'mp' ),
	'tax'						 => array(
		'rate'					 => 0,
		'label'					 => __( 'Taxes', 'mp' ),
		'tax_shipping'			 => 1,
		'tax_inclusive'			 => 0,
		'include_tax'			 => 1,
		'tax_label'				 => 1,
		'tax_digital'			 => 1,
		'tax_based'				 => 'store_tax',
	),
	'currency'					 => 'USD',
	'details_collection'		 => 'contact',
	'curr_symbol_position'		 => 1,
	'curr_decimal'				 => 1,
	'disable_cart'				 => 0,
	'show_orders'				 => 1,
	'hide_popup'				 => 0,
	'image_alignment_single'	 => 'alignleft',
	'image_alignment_list'		 => 'alignleft',
	'inventory_threshhold'		 => 3,
	'inventory_remove'			 => 0,
	'max_downloads'				 => 5,
	'use_alt_download_method'	 => 0,
	'download_order_limit'		 => 1,
	'force_login'				 => 0,
	'ga_ecommerce'				 => 'none',
	'special_instructions'		 => 0,
	'store_theme'				 => 'default',
	'show_img'					 => 1,
	'product_img_height'		 => 150,
	'product_img_width'			 => 150,
	'list_img_height'			 => 150,
	'list_img_width'			 => 150,
	'show_excerpt'				 => 1,
	'per_page'					 => 20,
	'order_by'					 => 'title',
	'per_row'					 => 3,
	/* Translators: change default slugs here */
	'slugs'						 => array(
		'store'			 => __( 'store', 'mp' ),
		'products'		 => __( 'products', 'mp' ),
		'cart'			 => __( 'shopping-cart', 'mp' ),
		'orderstatus'	 => __( 'order-status', 'mp' ),
		'category'		 => __( 'category', 'mp' ),
		'tag'			 => __( 'tag', 'mp' )
	),
	'product_button_type'		 => 'addcart',
	'show_quantity'				 => 1,
	'show_single_excerpt'		 => 1,
	'show_single_categories'	 => 1,
	'show_single_tags'		 	 => 1,
	'product_img_size'			 => 'medium',
	'show_lightbox'				 => 1,
	'disable_large_image'		 => 0,
	'list_view'					 => 'list',
	'list_button_type'			 => 'addcart',
	'show_thumbnail'			 => 1,
	'list_img_size'				 => 'thumbnail',
	'paginate'					 => 1,
	'show_filters'				 => 1,
	'order'						 => 'DESC',
	'show_purchase_breadcrumbs'	 => 0,
	'email_registration_email'	 => 0,
	'shipping'					 => array(
		'allowed_countries'	 => array( 'all_countries' ),
		'method'			 => 'flat-rate',
		'system'			 => 'english'
	),
	'gateways'					 => array(
		'paypal-express' => array(
			'locale'	 => 'US',
			'currency'	 => 'USD',
			'mode'		 => 'sandbox'
		),
		'paypal-chained' => array(
			'currency'	 => 'USD',
			'mode'		 => 'sandbox'
		)
	),
	'msg'						 => array(
		'product_list'		 => '',
		'order_status'		 => __( '<p>If you have any questions about your order please do not hesitate to contact us.</p>', 'mp' ),
		'cart'				 => '',
		'shipping'			 => __( '<p>Please enter your shipping information in the form below to proceed with your order.</p>', 'mp' ),
		'checkout'			 => '',
		'confirm_checkout'	 => __( '<p>You are almost done! Please do a final review of your order to make sure everything is correct then click the "Confirm Payment" button.</p>', 'mp' ),
		'success'			 => __( '<p>Thank you for your order! We appreciate your business, and please come back often to check out our new products.</p>', 'mp' )
	),
	'store_email'				 => get_option( "admin_email" ),
	'email'						 => array(
		'admin_order'	 => array(
			'subject'	 => __( 'New Order Notification: ORDERID', 'mp' ),
			'text'	 	 => __( "A new order (ORDERID) was created in your store:\n\n ORDERINFOSKU\n\n SHIPPINGINFO\n\n PAYMENTINFO\n\n", 'mp' ),
		),
		'new_order'		 => array(
			'subject'	 => __( 'Your Order Confirmation (ORDERID)', 'mp' ),
			'text'		 => __( "Thank you for your order CUSTOMERNAME!\n\n Your order has been received, and any items to be shipped will be processed as soon as possible. Please refer to your Order ID (ORDERID) whenever contacting us. \n Here is a confirmation of your order details:\n\n Order Information:\n ORDERINFO \n\n Shipping Information: \n SHIPPINGINFO \n\n Payment Information: \n PAYMENTINFO \n\n ORDERNOTES \n\n You can track the latest status of your order here: TRACKINGURL \n\n Thanks again!", 'mp'
			),
		),
		'order_shipped'	 => array(
			'subject'	 => __( 'Your Order Has Been Shipped! (ORDERID)', 'mp' ),
			'text'		 => __( "Dear CUSTOMERNAME,\n Your order has been shipped! Depending on the shipping method and your location it should be arriving shortly. Please refer to your Order ID (ORDERID) whenever contacting us.\nHere is a confirmation of your order details:\n\n Order Information:\n ORDERINFO\n\n Shipping Information:\n SHIPPINGINFO\n\n Payment Information:\n PAYMENTINFO\n\n ORDERNOTES\n\n You can track the latest status of your order here: TRACKINGURL\n\n Thanks again!", 'mp'
			),
		) ),
	'social'					 => array(
		'pinterest' => array(
			'show_pinit_button'	 => 'off',
			'show_pin_count'	 => 'none'
		),
	),
	'related_products'			 => array(
		'show'			 => 1,
		'relate_by'		 => 'both',
		'simple_list'	 => 0,
		'show_limit'	 => 3,
		'view'			 => 'list',
	),
);

//popular country list
$this->popular_countries = array(
	'US' => 'United States',
	'GB' => 'United Kingdom',
	'AU' => 'Australia',
	'CA' => 'Canada',
	'ES' => 'Spain',
	'NL' => 'Netherlands',
	'ZA' => 'South Africa',
);

//country list
$this->countries = array(
	'AF' => 'Afghanistan',
	'AL' => 'Albania',
	'DZ' => 'Algeria',
	'AS' => 'American Samoa',
	'AD' => 'Andorra',
	'AO' => 'Angola',
	'AI' => 'Anguilla',
	'AQ' => 'Antarctica',
	'AG' => 'Antigua And Barbuda',
	'AR' => 'Argentina',
	'AM' => 'Armenia',
	'AW' => 'Aruba',
	'AU' => 'Australia',
	'AT' => 'Austria',
	'AZ' => 'Azerbaijan',
	'BS' => 'Bahamas',
	'BH' => 'Bahrain',
	'BD' => 'Bangladesh',
	'BB' => 'Barbados',
	'BY' => 'Belarus',
	'BE' => 'Belgium',
	'BZ' => 'Belize',
	'BJ' => 'Benin',
	'BM' => 'Bermuda',
	'BT' => 'Bhutan',
	'BO' => 'Bolivia',
	'BA' => 'Bosnia And Herzegowina',
	'BW' => 'Botswana',
	'BV' => 'Bouvet Island',
	'BR' => 'Brazil',
	'IO' => 'British Indian Ocean Territory',
	'BN' => 'Brunei Darussalam',
	'BG' => 'Bulgaria',
	'BF' => 'Burkina Faso',
	'BI' => 'Burundi',
	'KH' => 'Cambodia',
	'CM' => 'Cameroon',
	'CA' => 'Canada',
	'CV' => 'Cape Verde',
	'KY' => 'Cayman Islands',
	'CF' => 'Central African Republic',
	'TD' => 'Chad',
	'CL' => 'Chile',
	'CN' => 'China',
	'CX' => 'Christmas Island',
	'CC' => 'Cocos (Keeling) Islands',
	'CO' => 'Colombia',
	'KM' => 'Comoros',
	'CG' => 'Congo',
	'CD' => 'Congo, The Democratic Republic Of The',
	'CK' => 'Cook Islands',
	'CR' => 'Costa Rica',
	'CI' => 'Cote D‌’Ivoire',
	'HR' => 'Croatia (Local Name: Hrvatska)',
	'CU' => 'Cuba',
	'CY' => 'Cyprus',
	'CZ' => 'Czech Republic',
	'DK' => 'Denmark',
	'DJ' => 'Djibouti',
	'DM' => 'Dominica',
	'DO' => 'Dominican Republic',
	'TP' => 'East Timor',
	'EC' => 'Ecuador',
	'EG' => 'Egypt',
	'SV' => 'El Salvador',
	'GQ' => 'Equatorial Guinea',
	'ER' => 'Eritrea',
	'EE' => 'Estonia',
	'ET' => 'Ethiopia',
	'FK' => 'Falkland Islands (Malvinas)',
	'FO' => 'Faroe Islands',
	'FJ' => 'Fiji',
	'FI' => 'Finland',
	'FR' => 'France',
	'FX' => 'France, Metropolitan',
	'GF' => 'French Guiana',
	'PF' => 'French Polynesia',
	'TF' => 'French Southern Territories',
	'GA' => 'Gabon',
	'GM' => 'Gambia',
	'GE' => 'Georgia',
	'DE' => 'Germany',
	'GH' => 'Ghana',
	'GI' => 'Gibraltar',
	'GR' => 'Greece',
	'GL' => 'Greenland',
	'GD' => 'Grenada',
	'GP' => 'Guadeloupe',
	'GU' => 'Guam',
	'GT' => 'Guatemala',
	'GN' => 'Guinea',
	'GW' => 'Guinea-Bissau',
	'GY' => 'Guyana',
	'HT' => 'Haiti',
	'HM' => 'Heard And Mc Donald Islands',
	'VA' => 'Holy See (Vatican City State)',
	'HN' => 'Honduras',
	'HK' => 'Hong Kong',
	'HU' => 'Hungary',
	'IS' => 'Iceland',
	'IN' => 'India',
	'ID' => 'Indonesia',
	'IR' => 'Iran (Islamic Republic Of)',
	'IQ' => 'Iraq',
	'IE' => 'Ireland',
	'IL' => 'Israel',
	'IT' => 'Italy',
	'JM' => 'Jamaica',
	'JP' => 'Japan',
	'JO' => 'Jordan',
	'KZ' => 'Kazakhstan',
	'KE' => 'Kenya',
	'KI' => 'Kiribati',
	'KP' => 'Korea, Democratic People‌’s Republic Of',
	'KR' => 'Korea, Republic Of',
	'KW' => 'Kuwait',
	'KG' => 'Kyrgyzstan',
	'LA' => 'Lao People‌’s Democratic Republic',
	'LV' => 'Latvia',
	'LB' => 'Lebanon',
	'LS' => 'Lesotho',
	'LR' => 'Liberia',
	'LY' => 'Libyan Arab Jamahiriya',
	'LI' => 'Liechtenstein',
	'LT' => 'Lithuania',
	'LU' => 'Luxembourg',
	'MO' => 'Macau',
	'MK' => 'Macedonia, Former Yugoslav Republic Of',
	'MG' => 'Madagascar',
	'MW' => 'Malawi',
	'MY' => 'Malaysia',
	'MV' => 'Maldives',
	'ML' => 'Mali',
	'MT' => 'Malta',
	'MH' => 'Marshall Islands',
	'MQ' => 'Martinique',
	'MR' => 'Mauritania',
	'MU' => 'Mauritius',
	'YT' => 'Mayotte',
	'MX' => 'Mexico',
	'FM' => 'Micronesia, Federated States Of',
	'MD' => 'Moldova, Republic Of',
	'MC' => 'Monaco',
	'MN' => 'Mongolia',
	'ME' => 'Montenegro',
	'MS' => 'Montserrat',
	'MA' => 'Morocco',
	'MZ' => 'Mozambique',
	'MM' => 'Myanmar',
	'NA' => 'Namibia',
	'NR' => 'Nauru',
	'NP' => 'Nepal',
	'NL' => 'Netherlands',
	'AN' => 'Netherlands Antilles',
	'NC' => 'New Caledonia',
	'NZ' => 'New Zealand',
	'NI' => 'Nicaragua',
	'NE' => 'Niger',
	'NG' => 'Nigeria',
	'NU' => 'Niue',
	'NF' => 'Norfolk Island',
	'MP' => 'Northern Mariana Islands',
	'NO' => 'Norway',
	'OM' => 'Oman',
	'PK' => 'Pakistan',
	'PW' => 'Palau',
	'PA' => 'Panama',
	'PG' => 'Papua New Guinea',
	'PY' => 'Paraguay',
	'PE' => 'Peru',
	'PH' => 'Philippines',
	'PN' => 'Pitcairn',
	'PL' => 'Poland',
	'PT' => 'Portugal',
	'PR' => 'Puerto Rico',
	'QA' => 'Qatar',
	'RE' => 'Reunion',
	'RO' => 'Romania',
	'RU' => 'Russian Federation',
	'RW' => 'Rwanda',
	'KN' => 'Saint Kitts And Nevis',
	'LC' => 'Saint Lucia',
	'VC' => 'Saint Vincent And The Grenadines',
	'WS' => 'Samoa',
	'SM' => 'San Marino',
	'ST' => 'Sao Tome And Principe',
	'SA' => 'Saudi Arabia',
	'SN' => 'Senegal',
	'RS' => 'Serbia',
	'SC' => 'Seychelles',
	'SL' => 'Sierra Leone',
	'SG' => 'Singapore',
	'SK' => 'Slovakia (Slovak Republic)',
	'SI' => 'Slovenia',
	'SB' => 'Solomon Islands',
	'SO' => 'Somalia',
	'ZA' => 'South Africa',
	'GS' => 'South Georgia, South Sandwich Islands',
	'ES' => 'Spain',
	'LK' => 'Sri Lanka',
	'SH' => 'St. Helena',
	'PM' => 'St. Pierre And Miquelon',
	'SD' => 'Sudan',
	'SR' => 'Suriname',
	'SJ' => 'Svalbard And Jan Mayen Islands',
	'SZ' => 'Swaziland',
	'SE' => 'Sweden',
	'CH' => 'Switzerland',
	'SY' => 'Syrian Arab Republic',
	'TW' => 'Taiwan',
	'TJ' => 'Tajikistan',
	'TZ' => 'Tanzania, United Republic Of',
	'TH' => 'Thailand',
	'TG' => 'Togo',
	'TK' => 'Tokelau',
	'TO' => 'Tonga',
	'TT' => 'Trinidad And Tobago',
	'TN' => 'Tunisia',
	'TR' => 'Turkey',
	'TM' => 'Turkmenistan',
	'TC' => 'Turks And Caicos Islands',
	'TV' => 'Tuvalu',
	'UG' => 'Uganda',
	'UA' => 'Ukraine',
	'AE' => 'United Arab Emirates',
	'GB' => 'United Kingdom',
	'US' => 'United States',
	'UM' => 'United States Minor Outlying Islands',
	'UY' => 'Uruguay',
	'UZ' => 'Uzbekistan',
	'VU' => 'Vanuatu',
	'VE' => 'Venezuela',
	'VN' => 'Viet Nam',
	'VG' => 'Virgin Islands (British)',
	'VI' => 'Virgin Islands (U.S.)',
	'WF' => 'Wallis And Futuna Islands',
	'EH' => 'Western Sahara',
	'YE' => 'Yemen',
	'ZM' => 'Zambia',
	'ZW' => 'Zimbabwe'
);

//countries with no postal code - see http://wp.mu/8we
$this->countries_no_postcode = array(
	"AO" => "Angola",
	"AG" => "Antigua And Barbuda",
	"AW" => "Aruba",
	"BS" => "Bahamas",
	"BZ" => "Belize",
	"BJ" => "Benin",
	"BW" => "Botswana",
	"BF" => "Burkina Faso",
	"BI" => "Burundi",
	"CM" => "Cameroon",
	"CF" => "Central African Republic",
	"KM" => "Comoros",
	"CG" => "Congo",
	"CD" => "Congo, The Democratic Republic Of The",
	"CK" => "Cook Islands",
	"CI" => "Cote D‌’Ivoire",
	"DJ" => "Djibouti",
	"DM" => "Dominica",
	"TP" => "East Timor",
	"GQ" => "Equatorial Guinea",
	"ER" => "Eritrea",
	"FJ" => "Fiji",
	"TF" => "French Southern Territories",
	"GM" => "Gambia",
	"GH" => "Ghana",
	"GD" => "Grenada",
	"GN" => "Guinea",
	"GY" => "Guyana",
	"HK" => "Hong Kong",
	"IE" => "Ireland",
	"JM" => "Jamaica",
	"KE" => "Kenya",
	"KI" => "Kiribati",
	"KP" => "Korea, Democratic People‌’s Republic Of",
	"MO" => "Macau",
	"MW" => "Malawi",
	"ML" => "Mali",
	"MR" => "Mauritania",
	"MU" => "Mauritius",
	"MS" => "Montserrat",
	"NR" => "Nauru",
	"AN" => "Netherlands Antilles",
	"NU" => "Niue",
	"PA" => "Panama",
	"QA" => "Qatar",
	"RW" => "Rwanda",
	"KN" => "Saint Kitts And Nevis",
	"LC" => "Saint Lucia",
	"ST" => "Sao Tome And Principe",
	"SA" => "Saudi Arabia",
	"SC" => "Seychelles",
	"SL" => "Sierra Leone",
	"SB" => "Solomon Islands",
	"SO" => "Somalia",
	"SR" => "Suriname",
	"SY" => "Syrian Arab Republic",
	"TZ" => "Tanzania, United Republic Of",
	"TK" => "Tokelau",
	"TO" => "Tonga",
	"TT" => "Trinidad And Tobago",
	"TV" => "Tuvalu",
	"UG" => "Uganda",
	"AE" => "United Arab Emirates",
	"VU" => "Vanuatu",
	"YE" => "Yemen",
	"ZW" => "Zimbabwe"
);

//USA states list
$this->usa_states = array(
	'AL' => 'Alabama',
	'AK' => 'Alaska',
	'AZ' => 'Arizona',
	'AR' => 'Arkansas',
	'CA' => 'California',
	'CO' => 'Colorado',
	'CT' => 'Connecticut',
	'DE' => 'Delaware',
	'DC' => 'District Of Columbia',
	'FL' => 'Florida',
	'GA' => 'Georgia',
	'HI' => 'Hawaii',
	'ID' => 'Idaho',
	'IL' => 'Illinois',
	'IN' => 'Indiana',
	'IA' => 'Iowa',
	'KS' => 'Kansas',
	'KY' => 'Kentucky',
	'LA' => 'Louisiana',
	'ME' => 'Maine',
	'MD' => 'Maryland',
	'MA' => 'Massachusetts',
	'MI' => 'Michigan',
	'MN' => 'Minnesota',
	'MS' => 'Mississippi',
	'MO' => 'Missouri',
	'MT' => 'Montana',
	'NE' => 'Nebraska',
	'NV' => 'Nevada',
	'NH' => 'New Hampshire',
	'NJ' => 'New Jersey',
	'NM' => 'New Mexico',
	'NY' => 'New York',
	'NC' => 'North Carolina',
	'ND' => 'North Dakota',
	'OH' => 'Ohio',
	'OK' => 'Oklahoma',
	'OR' => 'Oregon',
	'PA' => 'Pennsylvania',
	'RI' => 'Rhode Island',
	'SC' => 'South Carolina',
	'SD' => 'South Dakota',
	'TN' => 'Tennessee',
	'TX' => 'Texas',
	'UT' => 'Utah',
	'VT' => 'Vermont',
	'VA' => 'Virginia',
	'WA' => 'Washington',
	'WV' => 'West Virginia',
	'WI' => 'Wisconsin',
	'WY' => 'Wyoming',
	'AA' => 'AA - Armed Forces Americas',
	'AE' => 'AE - Armed Forces Africa, Canada, Europe, Middle East',
	'AP' => 'AP - Armed Forces Pacific',
);

//UK counties/provinces
$this->uk_counties = array(
	'Aberdeenshire'					 => 'Aberdeenshire',
	'Angus/Forfarshire'				 => 'Angus/Forfarshire',
	'Antrim'						 => 'Antrim',
	'Argyllshire'					 => 'Argyllshire',
	'Armagh'						 => 'Armagh',
	'Ayrshire'						 => 'Ayrshire',
	'Banffshire'					 => 'Banffshire',
	'Bedfordshire'					 => 'Bedfordshire',
	'Berkshire'						 => 'Berkshire',
	'Berwickshire'					 => 'Berwickshire',
	'Blaenau Gwent'					 => 'Blaenau Gwent',
	'Bridgend'						 => 'Bridgend',
	'Buckinghamshire'				 => 'Buckinghamshire',
	'Buteshire'						 => 'Buteshire',
	'Caerphilly'					 => 'Caerphilly',
	'Caithness'						 => 'Caithness',
	'Cambridgeshire'				 => 'Cambridgeshire',
	'Cardiff'						 => 'Cardiff',
	'Carmarthenshire'				 => 'Carmarthenshire',
	'Ceredigion'					 => 'Ceredigion',
	'Cheshire'						 => 'Cheshire',
	'Clackmannanshire'				 => 'Clackmannanshire',
	'Conwy'							 => 'Conwy',
	'Cornwall'						 => 'Cornwall',
	'Cromartyshire'					 => 'Cromartyshire',
	'Cumbria'						 => 'Cumbria',
	'Denbighshire'					 => 'Denbighshire',
	'Derbyshire'					 => 'Derbyshire',
	'Devon'							 => 'Devon',
	'Dorset'						 => 'Dorset',
	'Down'							 => 'Down',
	'Dumfriesshire'					 => 'Dumfriesshire',
	'Dunbartonshire/Dumbartonshire'	 => 'Dunbartonshire/Dumbartonshire',
	'County Durham'					 => 'County Durham',
	'East Lothian/Haddingtonshire'	 => 'East Lothian/Haddingtonshire',
	'Essex'							 => 'Essex',
	'Fermanagh'						 => 'Fermanagh',
	'Fife'							 => 'Fife',
	'Flintshire'					 => 'Flintshire',
	'Gloucestershire'				 => 'Gloucestershire',
	'Greater London'				 => 'Greater London',
	'Greater Manchester'			 => 'Greater Manchester',
	'Gwynedd'						 => 'Gwynedd',
	'Hampshire'						 => 'Hampshire',
	'Herefordshire'					 => 'Herefordshire',
	'Hertfordshire'					 => 'Hertfordshire',
	'Huntingdonshire'				 => 'Huntingdonshire',
	'Inverness-shire'				 => 'Inverness-shire',
	'Isle of Anglesey'				 => 'Isle of Anglesey',
	'Kent'							 => 'Kent',
	'Kincardineshire'				 => 'Kincardineshire',
	'Kinross-shire'					 => 'Kinross-shire',
	'Kirkcudbrightshire'			 => 'Kirkcudbrightshire',
	'Lanarkshire'					 => 'Lanarkshire',
	'Lancashire'					 => 'Lancashire',
	'Leicestershire'				 => 'Leicestershire',
	'Lincolnshire'					 => 'Lincolnshire',
	'Londonderry'					 => 'Londonderry',
	'Merthyr Tydfil'				 => 'Merthyr Tydfil',
	'Middlesex'						 => 'Middlesex',
	'Midlothian/Edinburghshire'		 => 'Midlothian/Edinburghshire',
	'Monmouthshire'					 => 'Monmouthshire',
	'Morayshire'					 => 'Morayshire',
	'Nairnshire'					 => 'Nairnshire',
	'Neath Port Talbot'				 => 'Neath Port Talbot',
	'Newport'						 => 'Newport',
	'Norfolk'						 => 'Norfolk',
	'Northamptonshire'				 => 'Northamptonshire',
	'Northumberland'				 => 'Northumberland',
	'Nottinghamshire'				 => 'Nottinghamshire',
	'Orkney'						 => 'Orkney',
	'Oxfordshire'					 => 'Oxfordshire',
	'Peeblesshire'					 => 'Peeblesshire',
	'Pembrokeshire'					 => 'Pembrokeshire',
	'Perthshire'					 => 'Perthshire',
	'Powys'							 => 'Powys',
	'Renfrewshire'					 => 'Renfrewshire',
	'Rhondda Cynon Taff'			 => 'Rhondda Cynon Taff',
	'Ross-shire'					 => 'Ross-shire',
	'Roxburghshire'					 => 'Roxburghshire',
	'Rutland'						 => 'Rutland',
	'Selkirkshire'					 => 'Selkirkshire',
	'Shetland'						 => 'Shetland',
	'Shropshire'					 => 'Shropshire',
	'Somerset'						 => 'Somerset',
	'Staffordshire'					 => 'Staffordshire',
	'Stirlingshire'					 => 'Stirlingshire',
	'Suffolk'						 => 'Suffolk',
	'Surrey'						 => 'Surrey',
	'Sussex'						 => 'Sussex',
	'Sutherland'					 => 'Sutherland',
	'Swansea'						 => 'Swansea',
	'Torfaen'						 => 'Torfaen',
	'Tyne and Wear'					 => 'Tyne and Wear',
	'Tyrone'						 => 'Tyrone',
	'Vale of Glamorgan'				 => 'Vale of Glamorgan',
	'Warwickshire'					 => 'Warwickshire',
	'West Lothian/Linlithgowshire'	 => 'West Lothian/Linlithgowshire',
	'West Midlands'					 => 'West Midlands',
	'Westmorland'					 => 'Westmorland',
	'Wigtownshire'					 => 'Wigtownshire',
	'Wiltshire'						 => 'Wiltshire',
	'Worcestershire'				 => 'Worcestershire',
	'Wrexham'						 => 'Wrexham',
	'Yorkshire'						 => 'Yorkshire'
);

//Australian states
$this->australian_states = array(
	'NSW'	 => 'New South Wales',
	'VIC'	 => 'Victoria',
	'QLD'	 => 'Queensland',
	'TAS'	 => 'Tasmania',
	'SA'	 => 'South Australia',
	'WA'	 => 'Western Australia',
	'NT'	 => 'Northern Territory',
	'ACT'	 => 'Australian Capital Territory'
);

//Canadian provinces
$this->canadian_provinces = array(
	'BC' => 'British Columbia',
	'ON' => 'Ontario',
	'NL' => 'Newfoundland and Labrador',
	'NS' => 'Nova Scotia',
	'PE' => 'Prince Edward Island',
	'NB' => 'New Brunswick',
	'QC' => 'Quebec',
	'MB' => 'Manitoba',
	'SK' => 'Saskatchewan',
	'AB' => 'Alberta',
	'NT' => 'Northwest Territories',
	'NU' => 'Nunavut',
	'YT' => 'Yukon Territory'
);

$this->afganistan_regions = array(
	'BDS'	 => 'Badakhshan',
	'BDG'	 => 'Badghis',
	'BGL'	 => 'Baghlan',
	'BAL'	 => 'Balkh',
	'BAM'	 => 'Bamian',
	'FRA'	 => 'Farah',
	'FYB'	 => 'Faryab',
	'GHA'	 => 'Ghazni',
	'GHO'	 => 'Ghowr',
	'HEL'	 => 'Helmand',
	'HER'	 => 'Herat',
	'JOW'	 => 'Jowzjan',
	'KAB'	 => 'Kabul',
	'KAN'	 => 'Kandahar',
	'KAP'	 => 'Kapisa',
	'KHO'	 => 'Khost',
	'KNR'	 => 'Konar',
	'KDZ'	 => 'Kondoz',
	'LAG'	 => 'Laghman',
	'LOW'	 => 'Lowgar',
	'NAN'	 => 'Nangrahar',
	'NIM'	 => 'Nimruz',
	'NUR'	 => 'Nurestan',
	'ORU'	 => 'Oruzgan',
	'PIA'	 => 'Paktia',
	'PKA'	 => 'Paktika',
	'PAR'	 => 'Parwan',
	'SAM'	 => 'Samangan',
	'SAR'	 => 'Sar-e Pol',
	'TAK'	 => 'Takhar',
	'WAR'	 => 'Wardak',
	'ZAB'	 => 'Zabol'
);

$this->albania_regions = array(
	'1'	 => 'Berat county',
	'2'	 => 'Durres county',
	'3'	 => 'Elbasan county',
	'4'	 => 'Fier county',
	'5'	 => 'Gjirokaster county',
	'6'	 => 'Korce county',
	'7'	 => 'Kukes county',
	'8'	 => 'Lezhe county',
	'9'	 => 'Diber county',
	'10' => 'Shkoder county',
	'11' => 'Tirane county',
	'12' => 'Vlore county'
);

$this->algeria_region = array(
	'ADRAR'				 => 'Adrar',
	'AIN TEMOUCHENT'	 => 'Ain Temouchent',
	'ALGIERS'			 => 'Algiers',
	'ANNABA'			 => 'Annaba',
	'LAGHOUAT'			 => 'Laghouat',
	'BATNA'				 => 'Batna',
	'BEJAIA'			 => 'Bejaia',
	'BISKRA'			 => 'Biskra',
	'BECHAR'			 => 'Bechar',
	'BLIDA'				 => 'Blida',
	'BOUIRA'			 => 'Bouira',
	'CHLEF'				 => 'Chlef',
	'CONSTANTINE'		 => 'Constantine',
	'DJELFA'			 => 'Djelfa',
	'TAMANGHASSET'		 => 'Tamanghasset',
	'TEBESSA'			 => 'Tebessa',
	'TLEMCEN'			 => 'Tlemcen',
	'TIZI OUZOU'		 => 'Tizi Ouzou',
	'JIJEL'				 => 'Jijel',
	'SETIF'				 => 'Setif',
	'SAIDA'				 => 'Saida',
	'SKIKDA'			 => 'Skikda',
	'SIDI BEL ABBES'	 => 'Sidi Bel Abbes',
	'GUELMA'			 => 'Guelma',
	'MEDEA'				 => 'Medea',
	'MOSTAGANEM'		 => 'Mostaganem',
	'MSILA'				 => 'MSila',
	'ORAN'				 => 'Oran',
	'OUARGLA'			 => 'Ouargla',
	'OUM EL-BOUAGHI'	 => 'Oum el-Bouaghi',
	'EL BAYADH'			 => 'El Bayadh',
	'ILLIZI'			 => 'Illizi',
	'BORDJ BOU ARRERIDJ' => 'Bordj Bou Arreridj',
	'BOUMERDES'			 => 'Boumerdes',
	'EL TARF'			 => 'El Tarf',
	'TINDDOUF'			 => 'Tindouf',
	'TISSEMSILT'		 => 'Tissemsilt',
	'EL OUED'			 => 'El Oued',
	'KHENCHELA'			 => 'Khenchela',
	'SOUK AHRAS'		 => 'Souk Ahras',
	'MILA'				 => 'Mila',
	'AIN DEFLA'			 => 'Ain Defla',
	'NAAMA'				 => 'Naama',
	'GHARDAIA'			 => 'Ghardaia',
	'RELIZANE'			 => 'Relizane'
);

$this->andorra_regions = array(
	'CA' => 'Canillo',
	'EN' => 'Encamp',
	'MA' => 'La Massana',
	'OR' => 'Ordino',
	'JL' => 'Sant Julià de Lòria',
	'AN' => 'Andorra La Vella',
	'EE' => 'Escaldes Engordany'
);

$this->angola_regions = array(
	'BGO'	 => 'Bengo',
	'BGU'	 => 'Benguela',
	'BIE'	 => 'Bie',
	'CAB'	 => 'Cabinda',
	'CCU'	 => 'Cuando Cubango',
	'CNO'	 => 'Cuanza Norte',
	'CUS'	 => 'Cuanza Sul',
	'CNN'	 => 'Cunene',
	'HUA'	 => 'Huambo',
	'HUI'	 => 'Huila',
	'LUA'	 => 'Luanda',
	'LNO'	 => 'Lunda Norte',
	'LSU'	 => 'Lunda Sul',
	'MAL'	 => 'Malanje',
	'MOX'	 => 'Moxico',
	'NAM'	 => 'Namibe',
	'UIG'	 => 'Uige',
	'ZAI'	 => 'Zaire'
);

$this->anguilla_regions = array(
	'BP' => 'Blowing Point',
	'EE' => 'East End',
	'GH' => 'George Hill',
	'IH' => 'Island Harbour',
	'NH' => 'North Hill',
	'NS' => 'North Side',
	'SG' => 'Sandy Ground',
	'SH' => 'Sandy Hill',
	'SO' => 'South Hill',
	'ST' => 'Stoney Ground',
	'TF' => 'The Farrington',
	'TQ' => 'The Quarter (including Rey Hill)',
	'TV' => 'The Valley (including Upper & South Valley)',
	'WE' => 'West End (including Long Bay)'
);

$this->antigua_barbuda_regions = array(
	'GE' => 'St. George',
	'JO' => 'St. John',
	'MA' => 'St. Mary',
	'PA' => 'St. Paul',
	'PE' => 'St. Peter',
	'BB' => 'Barbuda',
	'RD' => 'Redonda',
	'PH' => 'St. Philip'
);

$this->argentina_regions = array(
	'A'	 => 'Salta',
	'B'	 => 'Buenos Aires Province',
	'C'	 => 'Capital Federal',
	'D'	 => 'San Luis',
	'E'	 => 'Entre Ríos',
	'F'	 => 'La Rioja',
	'G'	 => 'Santiago del Estero',
	'H'	 => 'Chaco',
	'J'	 => 'San Juan',
	'K'	 => 'Catamarca',
	'L'	 => 'La Pampa',
	'M'	 => 'Mendoza',
	'N'	 => 'Misiones',
	'P'	 => 'Formosa',
	'Q'	 => 'Neuquén',
	'R'	 => 'Río Negro',
	'S'	 => 'Santa Fe',
	'T'	 => 'Tucumán',
	'U'	 => 'Chubut',
	'V'	 => 'Tierra del Fuego',
	'W'	 => 'Corrientes',
	'X'	 => 'Córdoba',
	'Y'	 => 'Jujuy',
	'Z'	 => 'Santa Cruz'
);

$this->armenia_regions = array(
	'AG' => 'Araqacotn',
	'AR' => 'Ararat',
	'AV' => 'Armavir',
	'ER' => 'Erevan',
	'GR' => 'Geqarkunik',
	'KT' => 'Kotayk',
	'LO' => 'Lory',
	'SH' => 'Sirak',
	'SU' => 'Syunik',
	'TV' => 'Tavus',
	'VD' => 'Vayoc Jor'
);

$this->austria_regions = array(
	'BUR'	 => 'Burgenland',
	'KAR'	 => 'Kärnten',
	'NOS'	 => 'Niederöesterreich',
	'OOS'	 => 'Oberöesterreich',
	'SAL'	 => 'Salzburg',
	'STE'	 => 'Steiermark',
	'TIR'	 => 'Tirol',
	'VOR'	 => 'Vorarlberg',
	'WIE'	 => 'Wien'
);

$this->ajerbaijan_regions = array(
	'ABS'	 => 'Absheron',
	'AGM'	 => 'Aghdam',
	'AGS'	 => 'Aghdash',
	'AGC'	 => 'Aghjabedi',
	'AGA'	 => 'Aghstafa',
	'AGU'	 => 'Aghsu',
	'AB'	 => 'Ali-Bairamly',
	'AST'	 => 'Astara',
	'BAB'	 => 'Babek',
	'BA'	 => 'Baku',
	'BAL'	 => 'Balaken',
	'BAR'	 => 'Barda',
	'BEY'	 => 'Beilagan',
	'BIL'	 => 'Bilasuvar',
	'DAS'	 => 'Dashkesan',
	'DAV'	 => 'Devechi',
	'FUZ'	 => 'Fizuli',
	'QAB'	 => 'Gabala',
	'GAD'	 => 'Gadabey',
	'QAX'	 => 'Gakh',
	'GA'	 => 'Ganja',
	'QAZ'	 => 'Gazakh',
	'GOR'	 => 'Geranboy',
	'QOB'	 => 'Gobustan',
	'GOY'	 => 'Goychay',
	'QBA'	 => 'Guba',
	'QBI'	 => 'Gubadly',
	'QUS'	 => 'Gusar',
	'HAC'	 => 'Hacuqabul',
	'IMI'	 => 'Imishli',
	'ISM'	 => 'Ismailly',
	'CAL'	 => 'Jalilabad',
	'CAB'	 => 'Jebrail',
	'CUL'	 => 'Julfa',
	'KAL'	 => 'Kelbajar',
	'XAC'	 => 'Khachmaz',
	'XA'	 => 'Khankendy',
	'XAN'	 => 'Khanlar',
	'XCI'	 => 'Khojaly',
	'XVD'	 => 'Khojavend',
	'XIZ'	 => 'Khyzy',
	'KUR'	 => 'Kyurdamir',
	'LAC'	 => 'Lachin',
	'LAN'	 => 'Lankaran district',
	'LA'	 => 'Lankaran city',
	'LER'	 => 'Lerik',
	'MAS'	 => 'Masally',
	'MI'	 => 'Mingechevir',
	'NA'	 => 'Naftalan',
	'NX'	 => 'Nakhchivan',
	'NEF'	 => 'Neftchala',
	'OGU'	 => 'Oghuz',
	'ORD'	 => 'Ordubad',
	'SAT'	 => 'Saatly',
	'SAB'	 => 'Sabirabad',
	'SAL'	 => 'Salyan',
	'SMX'	 => 'Samuh',
	'SAD'	 => 'Sedarak',
	'SAH'	 => 'Shahbuz',
	'SMI'	 => 'Shamakhy',
	'SKR'	 => 'Shamkir',
	'SAK'	 => 'Sheki district',
	'SA'	 => 'Sheki city',
	'SAR'	 => 'Sherur',
	'SUS'	 => 'Shusha district',
	'SS'	 => 'Shusha city',
	'SIY'	 => 'Siazan',
	'SM'	 => 'Sumgayit',
	'TAR'	 => 'Terter',
	'TOV'	 => 'Tovuz',
	'UCA'	 => 'Ujar',
	'YAR'	 => 'Yardymly',
	'YEV'	 => 'Yevlakh district',
	'YE'	 => 'Yevlakh city',
	'ZAQ'	 => 'Zagatala',
	'ZAN'	 => 'Zangilan',
	'ZAR'	 => 'Zerdab'
);

$this->bahamas_regions = array(
	'AC' => 'Acklins and Crooked Islands',
	'BI' => 'Bimini',
	'CI' => 'Cat Island',
	'EX' => 'Exuma',
	'FP' => 'Freeport',
	'FC' => 'Fresh Creek',
	'GH' => 'Governor‌’s Harbour',
	'GT' => 'Green Turtle Cay',
	'HI' => 'Harbour Island',
	'HR' => 'High Rock',
	'IN' => 'Inaqua',
	'KB' => 'Kemps Bay',
	'LI' => 'Long Island',
	'MH' => 'Marsh Harbour',
	'MG' => 'Mayaquana',
	'NP' => 'New Providence',
	'NB' => 'Nicholls Town and Berry Islands',
	'RI' => 'Ragged Island',
	'RS' => 'Rock Sound',
	'SR' => 'San Salvador and Rum Cay',
	'SP' => 'Sandy Point'
);

$this->bahrain_regions = array(
	'BH-13'	 => 'Al Manamah',
	'BH-14'	 => 'Al Janubiyah',
	'BH-15'	 => 'Al Muharraq',
	'BH-16'	 => 'Al Wusta',
	'BH-17'	 => 'Ash Shamaliyah'
);

$this->bangladesh_regions = array(
	'1'	 => 'Barisal',
	'2'	 => 'Chittagong',
	'3'	 => 'Dhaka',
	'4'	 => 'Khulna',
	'5'	 => 'Rajshahi',
	'6'	 => 'Sylhet'
);

$this->barbados_regions = array(
	'01' => 'Christ Church',
	'02' => 'Saint Andrew',
	'03' => 'Saint George',
	'04' => 'Saint James',
	'05' => 'Saint John',
	'06' => 'Saint Joseph',
	'07' => 'Saint Lucy',
	'08' => 'Saint Michael',
	'09' => 'Saint Peter',
	'10' => 'Saint Philip',
	'11' => 'Saint Thomas'
);

$this->belarus_regions = array(
	'BR' => 'Brest',
	'HO' => 'Homyel',
	'HM' => 'Horad Minsk',
	'HR' => 'Hrodna',
	'MA' => 'Mahilyow',
	'MI' => 'Minsk',
	'VI' => 'Vitsyebsk'
);

$this->belgium_regions = array(
	'VWV'	 => 'West-Vlaanderen',
	'VOV'	 => 'Oost-Vlaanderen',
	'VAN'	 => 'Antwerpen',
	'VLI'	 => 'Limburg',
	'VBR'	 => 'Vlaams-Brabant',
	'BRU'	 => 'Brussel/Bruxelles',
	'WBW'	 => 'Brabant-Wallon',
	'WLG'	 => 'Liège',
	'WHT'	 => 'Hainaut',
	'WNA'	 => 'Namur',
	'WLX'	 => 'Luxembourg'
);

$this->belize_regions = array(
	'BZ'	 => 'Belize',
	'CY'	 => 'Cayo',
	'CZL'	 => 'Corozal',
	'OW'	 => 'Orange Walk',
	'SC'	 => 'Stann Creek',
	'TOL'	 => 'Toledo'
);

$this->benin_regions = array(
	'AL' => 'Alibori',
	'AK' => 'Atacora',
	'AQ' => 'Atlantique',
	'BO' => 'Borgou',
	'CO' => 'Collines',
	'KO' => 'Couffo',
	'DO' => 'Donga',
	'LI' => 'Littoral',
	'MO' => 'Mono',
	'OU' => 'Ouémé',
	'PL' => 'Plateau',
	'ZO' => 'Zou'
);

$this->bermuda_regions = array(
	'DEV'	 => 'Devonshire',
	'HAM'	 => 'Hamilton',
	'HA'	 => 'Hamilton Municipality',
	'PAG'	 => 'Paget',
	'PEM'	 => 'Pembroke',
	'SG'	 => 'Saint George Municipality',
	'SGE'	 => 'Saint Georges',
	'SAN'	 => 'Sandys',
	'SMI'	 => 'Smiths',
	'SOU'	 => 'Southampton',
	'WAR'	 => 'Warwick'
);

$this->bhutan_regions = array(
	'GA' => 'Gasa',
	'TY' => 'Tashi Yangtse',
	'11' => 'Paro',
	'12' => 'Chhukha',
	'13' => 'Ha',
	'14' => 'Samchi',
	'15' => 'Thimphu',
	'21' => 'Chirang',
	'22' => 'Daga',
	'23' => 'Punakha',
	'24' => 'Wangdi Phodrang',
	'31' => 'Geylegphug',
	'32' => 'Tongsa',
	'33' => 'Bumthang',
	'34' => 'Shemgang',
	'41' => 'Tashigang',
	'42' => 'Mongar',
	'43' => 'Pemagatsel',
	'44' => 'Lhuntshi',
	'45' => 'Samdrup Jongkhar'
);

$this->bolivia_regions = array(
	'BO-C'	 => 'Cochabamba',
	'BO-H'	 => 'Chuquisaca',
	'BO-B'	 => 'El Beni',
	'BO-L'	 => 'La Paz',
	'BO-O'	 => 'Oruro',
	'BO-N'	 => 'Pando',
	'BO-P'	 => 'Potosí',
	'BO-S'	 => 'Santa Cruz',
	'BO-T'	 => 'Tarija'
);

$this->bosnia_herzegoniva_regions = array(
	'BIH'	 => 'Federacija Bosna i Hercegovina',
	'SRP'	 => 'Republika Srpska',
	'05'	 => 'Bosansko-Podrinjski Kanton',
	'10'	 => 'Hercegovacko-Bosanski Kanton',
	'07'	 => 'Hercegovacko-Neretvanski Kanton',
	'09'	 => 'Kanton Sarajevo',
	'02'	 => 'Posavski Kanton',
	'06'	 => 'Srednjobosanski Kanton',
	'03'	 => 'Tuzlanski Kanton',
	'01'	 => 'Unsko-Sanski Kanton',
	'08'	 => 'Zapadno-Hercegovacki Kanton',
	'04'	 => 'Zenicko-Dobojski Kanton'
);

$this->botswana_regions = array(
	'CE' => 'Central',
	'GH' => 'Ghanzi',
	'KG' => 'Kgalagadi',
	'KL' => 'Kgatleng',
	'KW' => 'Kweneng',
	'NE' => 'North-East',
	'NW' => 'North-West',
	'SE' => 'South-East',
	'SO' => 'Southern'
);

$this->brazil_regions = array(
	'AC' => 'Acre',
	'AL' => 'Alagoas',
	'AP' => 'Amapá',
	'AM' => 'Amazonas',
	'BA' => 'Bahia',
	'CE' => 'Ceará',
	'DF' => 'Distrito Federal',
	'ES' => 'Espírito Santo',
	'GO' => 'Goiás',
	'MA' => 'Maranhão',
	'MT' => 'Mato Grosso',
	'MS' => 'Mato Grosso do Sul',
	'MG' => 'Minas Gerais',
	'PA' => 'Pará',
	'PB' => 'Paraíba',
	'PR' => 'Paraná',
	'PE' => 'Pernambuco',
	'PI' => 'Piauí',
	'RJ' => 'Rio de Janeiro',
	'RN' => 'Rio Grande do Norte',
	'RS' => 'Rio Grande do Sul',
	'RO' => 'Rondônia',
	'RR' => 'Roraima',
	'SC' => 'Santa Catarina',
	'SP' => 'São Paulo',
	'SE' => 'Sergipe',
	'TO' => 'Tocantins'
);

$this->brunei_darussalam_regions = array(
	'BN-BE'	 => 'Belait',
	'BN-BM'	 => 'Brunei-Muara',
	'BN-TE'	 => 'Temburong',
	'BN-TU'	 => 'Tutong'
);

$this->burkina_faso_regions = array(
	'BAL'	 => 'Bale',
	'BAM'	 => 'Bam',
	'BAN'	 => 'Banwa',
	'BAZ'	 => 'Bazega',
	'BGR'	 => 'Bougouriba',
	'BLG'	 => 'Boulgou',
	'BLK'	 => 'Boulkiemde',
	'COM'	 => 'Comoe',
	'GAN'	 => 'Ganzourgou',
	'GNA'	 => 'Gnagna',
	'GOU'	 => 'Gourma',
	'HOU'	 => 'Houet',
	'IOB'	 => 'Ioba',
	'KAD'	 => 'Kadiogo',
	'KEN'	 => 'Kenedougou',
	'KMD'	 => 'Komandjoari',
	'KMP'	 => 'Kompienga',
	'KOS'	 => 'Kossi',
	'KOP'	 => 'Koulpelogo',
	'KOT'	 => 'Kouritenga',
	'KOW'	 => 'Kourweogo',
	'LER'	 => 'Leraba',
	'LOR'	 => 'Loroum',
	'MOU'	 => 'Mouhoun',
	'NAO'	 => 'Nahouri',
	'NAM'	 => 'Namentenga',
	'NAY'	 => 'Nayala',
	'NOU'	 => 'Noumbiel',
	'OUB'	 => 'Oubritenga',
	'OUD'	 => 'Oudalan',
	'PAS'	 => 'Passore',
	'PON'	 => 'Poni',
	'SNG'	 => 'Sanguie',
	'SMT'	 => 'Sanmatenga',
	'SEN'	 => 'Seno',
	'SIS'	 => 'Sissili',
	'SOM'	 => 'Soum',
	'SOR'	 => 'Sourou',
	'TAP'	 => 'Tapoa',
	'TUI'	 => 'Tuy',
	'YAG'	 => 'Yagha',
	'YAT'	 => 'Yatenga',
	'ZIR'	 => 'Ziro',
	'ZON'	 => 'Zondoma',
	'ZOU'	 => 'Zoundweogo'
);

$this->burundi_regions = array(
	'BB' => 'Bubanza',
	'BM' => 'Bujumbura Mairie',
	'BJ' => 'Bujumbura Rural',
	'BR' => 'Bururi',
	'CA' => 'Cankuzo',
	'CI' => 'Cibitoke',
	'GI' => 'Gitega',
	'KR' => 'Karuzi',
	'KY' => 'Kayanza',
	'KI' => 'Kirundo',
	'MA' => 'Makamba',
	'MU' => 'Muramvya',
	'MY' => 'Muyinga',
	'MW' => 'Mwaro',
	'NG' => 'Ngozi',
	'RT' => 'Rutana',
	'RY' => 'Ruyigi'
);

$this->cambodia_regions = array(
	'2'	 => 'Baat Dambang',
	'1'	 => 'Banteay Mean Chey',
	'1'	 => 'Banteay Meanchey',
	'2'	 => 'Batdambang',
	'3'	 => 'Kampong Chaam',
	'3'	 => 'Kampong Cham',
	'4'	 => 'Kampong Chhnang',
	'5'	 => 'Kampong Spoe',
	'5'	 => 'Kampong Spueu',
	'6'	 => 'Kampong Thum',
	'7'	 => 'Kampot',
	'8'	 => 'Kandaal',
	'8'	 => 'Kandal',
	'9'	 => 'Kaoh Kong',
	'10' => 'Kracheh',
	'23' => 'Krong Kaeb',
	'23' => 'Krong Keb',
	'24' => 'Krong Pailin',
	'18' => 'Krong Preah Sihanouk',
	'11' => 'Mondol Kiri',
	'22' => 'Otdar Mean Chey',
	'22' => 'Otdar Meanchey',
	'12' => 'Phnom Penh',
	'12' => 'Phnum Penh',
	'15' => 'Pousaat',
	'15' => 'Pouthisat',
	'13' => 'Preah Vihear',
	'14' => 'Prey Veaeng',
	'14' => 'Prey Veng',
	'16' => 'Rotanak Kiri',
	'16' => 'Rotanokiri',
	'17' => 'Siem Reab',
	'17' => 'Siemreab',
	'19' => 'Stoeng Treng',
	'19' => 'Stueng Traeng',
	'20' => 'Svaay Rieng',
	'20' => 'Svay Rieng',
	'21' => 'Taakaev',
	'21' => 'Takev'
);

$this->cameroon_regions = array(
	'CM-AD'	 => 'Adamaoua',
	'CM-CE'	 => 'Centre',
	'CM-ES'	 => 'Est',
	'CM-EN'	 => 'Extreme-Nord',
	'CM-LT'	 => 'Littoral',
	'CM-NO'	 => 'Nord',
	'CM-NW'	 => 'Nord-Ouest',
	'CM-OU'	 => 'Ouest',
	'CM-SU'	 => 'Sud',
	'CM-SW'	 => 'Sud-Ouest'
);

$this->cape_verde_regions = array(
	'BV' => 'Boa Vista',
	'BR' => 'Brava',
	'MA' => 'Maio',
	'MO' => 'Mosteiros',
	'PA' => 'Paul',
	'PN' => 'Porto Novo',
	'PR' => 'Praia',
	'SN' => 'Ribeira Brava',
	'RG' => 'Ribeira Grande',
	'PR' => 'Ribeira Grande de Santiago',
	'SL' => 'Sal',
	'CA' => 'Santa Catarina',
	'SF' => 'Santa Catarina do Fogo',
	'CR' => 'Santa Cruz',
	'SD' => 'Sao Domingos',
	'SF' => 'Sao Filipe',
	'CR' => 'Sao Lourenço dos Orgaos',
	'CS' => 'Sao Miguel',
	'CA' => 'Sao Salvador do Mundo',
	'SV' => 'Sao Vicente',
	'TA' => 'Tarrafal',
	'TS' => 'Tarrafal de Sao Nicolau'
);

$this->cayman_islands_regions = array(
	'BT' => 'Bodden Town',
	'CB' => 'Cayman Brac',
	'EE' => 'East End',
	'GT' => 'George Town',
	'SO' => 'Little Cayman',
	'NS' => 'North Side',
	'WB' => 'West Bay'
);

$this->central_african_republic_regions = array(
	'BB'	 => 'Bamingui-Bangoran',
	'BGF'	 => 'Bangui',
	'BK'	 => 'Basse-Kotto',
	'HK'	 => 'Haute-Kotto',
	'HM'	 => 'Haut-Mbomou',
	'KG'	 => 'Kemo',
	'LB'	 => 'Lobaye',
	'HS'	 => 'Mambere-Kadei',
	'MB'	 => 'Mbomou',
	'KB'	 => 'Nana-Grebizi',
	'NM'	 => 'Nana-Mambere',
	'MP'	 => 'Ombella-M‌’Poko',
	'UK'	 => 'Ouaka',
	'AC'	 => 'Ouham',
	'OP'	 => 'Ouham-Pende',
	'SE'	 => 'Sangha-Mbaere',
	'VK'	 => 'Vakaga'
);

$this->chad_regions = array(
	'KA'	 => 'Barh el Ghazel',
	'BA'	 => 'Batha',
	'BET'	 => 'Borkou',
	'CB'	 => 'Chari-Baguirmi',
	'BET'	 => 'Ennedi',
	'GR'	 => 'Guera',
	'HL'	 => 'Hadjer-Lamis',
	'KA'	 => 'Kanem',
	'LC'	 => 'Lac',
	'LO'	 => 'Logone Occidental',
	'LR'	 => 'Logone Oriental',
	'MA'	 => 'Mandoul',
	'ME'	 => 'Mayo-Kebbi Est',
	'MO'	 => 'Mayo-Kebbi Ouest',
	'MC'	 => 'Moyen-Chari',
	'OD'	 => 'Ouaddai',
	'SA'	 => 'Salamat',
	'OD'	 => 'Sila',
	'TA'	 => 'Tandjile',
	'BET'	 => 'Tibesti',
	'ND'	 => 'Ville de N‌’Djamena',
	'WF'	 => 'Wadi Fira'
);

$this->chile_regions = array(
	'TA' => 'Tarapaca',
	'AN' => 'Antofagasta',
	'AT' => 'Atacama',
	'CO' => 'Coquimbo',
	'VA' => 'Valparaiso',
	'OH' => 'Ohiggins',
	'MA' => 'Maule',
	'BI' => 'Biobio',
	'AR' => 'Araucania',
	'LA' => 'Lagos',
	'AI' => 'Aisen',
	'MA' => 'Magallanes',
	'RM' => 'Metropolitana',
	'Ri' => 'Rios',
	'AR' => 'Arica'
);

$this->china_regions = array(
	'京'	 => '北京',
	'沪'	 => '上海',
	'津'	 => '天津',
	'渝'	 => '重庆',
	'冀'	 => '河北',
	'豫'	 => '河南',
	'鄂'	 => '湖北',
	'湘'	 => '湖南',
	'苏'	 => '江苏',
	'赣'	 => '江西',
	'辽'	 => '辽宁',
	'吉'	 => '吉林',
	'黑'	 => '黑龙江',
	'陕'	 => '陕西',
	'鲁'	 => '山东',
	'晋'	 => '山西',
	'川'	 => '四川',
	'青'	 => '青海',
	'皖'	 => '安徽',
	'琼'	 => '海南',
	'粤'	 => '广东',
	'桂'	 => '广西',
	'贵'	 => '贵州',
	'浙'	 => '浙江',
	'闽'	 => '福建',
	'甘'	 => '甘肃',
	'云'	 => '云南',
	'蒙'	 => '内蒙古',
	'宁'	 => '宁夏',
	'新'	 => '新疆',
	'藏'	 => '西藏',
	'港'	 => '香港',
	'澳'	 => '澳门',
	'台'	 => '台湾'
);

$this->colombia_regions = array(
	'AMA'	 => 'Amazonas',
	'ANT'	 => 'Antioquia',
	'ARA'	 => 'Arauca',
	'ATL'	 => 'Atlantico',
	'BOL'	 => 'Bolivar',
	'CAL'	 => 'Caldas',
	'CAQ'	 => 'Caqueta',
	'CAS'	 => 'Casanare',
	'CAU'	 => 'Cauca',
	'CES'	 => 'Cesar',
	'CHO'	 => 'Choco',
	'COR'	 => 'Cordoba',
	'CUN'	 => 'Cundinamarca',
	'DC'	 => 'Distrito Capital de Bogota',
	'GUA'	 => 'Guainia',
	'GUV'	 => 'Guaviare',
	'HUI'	 => 'Huila',
	'LAG'	 => 'La Guajira',
	'MAG'	 => 'Magdalena',
	'MET'	 => 'Meta',
	'NAR'	 => 'Narino',
	'NSA'	 => 'Norte de Santander',
	'PUT'	 => 'Putumayo',
	'QUI'	 => 'Quindio',
	'RIS'	 => 'Risaralda',
	'SAP'	 => 'San Andres, Providencia y Santa Catalina',
	'SAN'	 => 'Santander',
	'SUC'	 => 'Sucre',
	'TOL'	 => 'Tolima',
	'VAC'	 => 'Valle del Cauca',
	'VAU'	 => 'Vaupes',
	'VID'	 => 'Vichada'
);

$this->comoros_regions = array(
	'A'	 => 'Anjouan',
	'G'	 => 'Grande Comore',
	'M'	 => 'Moheli'
);

$this->congo_regions = array(
	'11'	 => 'Bouenza',
	'BZV'	 => 'Brazzaville',
	'8'		 => 'Cuvette',
	'15'	 => 'Cuvette-Ouest',
	'5'		 => 'Kouilou',
	'2'		 => 'Lekoumou',
	'7'		 => 'Likouala',
	'9'		 => 'Niari',
	'14'	 => 'Plateaux',
	'12'	 => 'Pool',
	'13'	 => 'Sangha'
);

$this->congo_democratic_republic_regions = array(
	'CD-KN'	 => 'Kinshasa',
	'CD-BN'	 => 'Bandundu',
	'CD-BC'	 => 'Bas-Congo',
	'CD-EQ'	 => 'Equateur',
	'CD-KW'	 => 'Kasai-Occidental',
	'CD-KE'	 => 'Kasai-Oriental',
	'CD-KA'	 => 'Katanga',
	'CD-MA'	 => 'Maniema',
	'CD-NK'	 => 'Nord-Kivu',
	'CD-OR'	 => 'Orientale',
	'CD-SK'	 => 'Sud-Kivu'
);

$this->costa_rica_regions = array(
	'AL' => 'Alajuela',
	'CA' => 'Cartago',
	'GU' => 'Guanacaste',
	'HE' => 'Heredia',
	'LI' => 'Limón',
	'PU' => 'Puntarenas',
	'SJ' => 'San José'
);

$this->croatia_regions = array(
	'01' => 'Zagreb county',
	'02' => 'Krapina-Zagorje county',
	'03' => 'Sisak-Moslavina county',
	'04' => 'Karlovac county',
	'05' => 'Varaždin county',
	'06' => 'Koprivnica-Križevci county',
	'07' => 'Bjelovar-Bilogora county',
	'08' => 'Primorje-Gorski Kotar county',
	'09' => 'Lika-Senj county',
	'10' => 'Virovitica-Podravina county',
	'11' => 'Požega-Slavonia county',
	'12' => 'Brod-Posavina county',
	'13' => 'Zadar county',
	'14' => 'Osijek-Baranja county',
	'15' => 'Šibenik-Knin county',
	'16' => 'Vukovar-Srijem county',
	'17' => 'Split-Dalmatia county',
	'18' => 'Istria county',
	'19' => 'Dubrovnik-Neretva county',
	'20' => 'Međimurje county',
	'21' => 'Zagreb'
);

$this->cuba_regions = array(
	'01' => 'Pinar del Rio',
	'02' => 'La Habana',
	'03' => 'Ciudad de la Habana',
	'04' => 'Matanzas',
	'05' => 'Villa Clara',
	'06' => 'Cienfuegos',
	'07' => 'Sancti Spiritus',
	'08' => 'Ciego de Avila',
	'09' => 'Camaguey',
	'10' => 'Las Tunas',
	'11' => 'Holguin',
	'12' => 'Granma',
	'13' => 'Santiago de Cuba',
	'14' => 'Sancti Spiritus',
	'99' => 'Isla de la Juventud'
);

$this->cyprus_regions = array(
	'04' => 'Famagusta',
	'06' => 'Kyrenia',
	'03' => 'Larnaca',
	'02' => 'Limassol',
	'01' => 'Nicosia',
	'05' => 'Paphos'
);

$this->czech_republic_regions = array(
	'PHA'	 => 'Praha',
	'STC'	 => 'Středočeský kraj',
	'JHC'	 => 'Jihočeský kraj',
	'PLK'	 => 'Plzeňský kraj',
	'KVK'	 => 'Karlovarský kraj',
	'ULK'	 => 'Ústecký kraj',
	'LBK'	 => 'Liberecký kraj',
	'HKK'	 => 'Královéhradecký kraj',
	'PAK'	 => 'Pardubický kraj',
	'VYS'	 => 'Vysočina',
	'JHM'	 => 'Jihomoravský kraj',
	'OLK'	 => 'Olomoucký kraj',
	'ZLK'	 => 'Zlínský kraj',
	'MSK'	 => 'Moravskoslezský kraj'
);


$this->denmark_regions = array(
	'DK-84'	 => 'Hovedstaden',
	'DK-82'	 => 'Midtjylland',
	'DK-81'	 => 'Nordjylland',
	'DK-85'	 => 'Sjælland',
	'DK-83'	 => 'Syddanmark'
);

$this->djibouti_regions = array(
	'AS' => 'Ali Sabieh',
	'AR' => 'Arta',
	'DI' => 'Dikhil',
	'DJ' => 'Djibouti',
	'OB' => 'Obock',
	'TA' => 'Tadjourah'
);

$this->dominica_regions = array(
	'02' => 'Saint Andrew',
	'03' => 'Saint David',
	'04' => 'Saint George',
	'05' => 'Saint John',
	'06' => 'Saint Joseph',
	'07' => 'Saint Luke',
	'08' => 'Saint Mark',
	'09' => 'Saint Patrick',
	'10' => 'Saint Paul',
	'11' => 'Saint Peter'
);

$this->dominican_republic_regions = array(
	'DN' => 'Distrito Nacional',
	'AZ' => 'Azua',
	'BC' => 'Baoruco',
	'BH' => 'Barahona',
	'DJ' => 'Dajabon',
	'DU' => 'Duarte',
	'EL' => 'Elias Pina',
	'SY' => 'El Seybo',
	'ET' => 'Espaillat',
	'HM' => 'Hato Mayor',
	'IN' => 'Independencia',
	'AL' => 'La Altagracia',
	'RO' => 'La Romana',
	'VE' => 'La Vega',
	'MT' => 'Maria Trinidad Sanchez',
	'MN' => 'Monsenor Nouel',
	'MC' => 'Monte Cristi',
	'MP' => 'Monte Plata',
	'PD' => 'Pedernales',
	'PR' => 'Peravia (Bani)',
	'PP' => 'Puerto Plata',
	'SL' => 'Salcedo',
	'SM' => 'Samana',
	'SH' => 'Sanchez Ramirez',
	'SC' => 'San Cristobal',
	'JO' => 'San Jose de Ocoa',
	'SJ' => 'San Juan',
	'PM' => 'San Pedro de Macoris',
	'SA' => 'Santiago',
	'ST' => 'Santiago Rodriguez',
	'SD' => 'Santo Domingo',
	'VA' => 'Valverde'
);

$this->ecuador_regions = array(
	'A'	 => 'Azuay',
	'B'	 => 'Bolivar',
	'F'	 => 'Canar',
	'C'	 => 'Carchi',
	'H'	 => 'Chimborazo',
	'X'	 => 'Cotopaxi',
	'O'	 => 'El Oro',
	'E'	 => 'Esmeraldas',
	'W'	 => 'Galapagos',
	'G'	 => 'Guayas',
	'I'	 => 'Imbabura',
	'L'	 => 'Loja',
	'R'	 => 'Los Rios',
	'M'	 => 'Manabi',
	'S'	 => 'Morona-Santiago',
	'N'	 => 'Napo',
	'D'	 => 'Orellana',
	'Y'	 => 'Pastaza',
	'P'	 => 'Pichincha',
	'U'	 => 'Sucumbios',
	'T'	 => 'Tungurahua',
	'Z'	 => 'Zamora-Chichipe'
);

$this->egypt_regions = array(
	'MUH'	 => 'مرسى مطروح',
	'ALX'	 => 'الاسكندرية',
	'WAD'	 => 'الوادي الجديد',
	'GZ'	 => 'الجيزة',
	'FYM'	 => 'الفيوم',
	'BNS'	 => 'بني سويف',
	'MN'	 => 'المنيا',
	'AST'	 => 'اسيوط',
	'SHG'	 => 'سوهاج',
	'ASN'	 => 'اسوان',
	'SIN'	 => 'شمال سيناء',
	'JS'	 => 'جنوب سيناء',
	'MNF'	 => 'المنوفية',
	'BA'	 => 'البحر الاحمر',
	'SHR'	 => 'الشرقية',
	'KB'	 => 'القليوبية',
	'IS'	 => 'الاسماعيلية',
	'SUZ'	 => 'السويس',
	'BH'	 => 'البحيرة',
	'GH'	 => 'الغربية',
	'KFS'	 => 'كفر الشيخ',
	'DK'	 => 'الدقهلية',
	'UQ'	 => 'الاقصر',
	'PTS'	 => 'بور سعيد',
	'DT'	 => 'دمياط',
	'KN'	 => 'قنا',
	'CAI'	 => 'القاهرة'
);

$this->el_salvador_regions = array(
	'AH' => 'Ahuachapan',
	'CA' => 'Cabanas',
	'CH' => 'Chalatenango',
	'CU' => 'Cuscatian',
	'LI' => 'La Libertad',
	'PA' => 'La Paz',
	'UN' => 'La Union',
	'MO' => 'Morazan',
	'SM' => 'San Miguel',
	'SS' => 'San Salvador',
	'SV' => 'San Vicente',
	'SA' => 'Santa Ana',
	'SO' => 'Sonsonate',
	'US' => 'Usulutan'
);

$this->equitorial_guinea_regions = array(
	'GQ-AN'	 => 'Annobon',
	'GQ-BN'	 => 'Bioko Norte',
	'GQ-BS'	 => 'Bioko Sur',
	'GQ-CS'	 => 'Centro Sur',
	'GQ-KN'	 => 'Kie-Ntem',
	'GQ-LI'	 => 'Litoral',
	'GQ-WN'	 => 'Wele-Nzas'
);

$this->eritrea_regions = array(
	'AN' => 'Anseba',
	'DU' => 'Debub',
	'DK' => 'Debubawi Keyih Bahri',
	'GB' => 'Gash Barka',
	'MA' => 'Maekel',
	'Sk' => 'Semenawi Keyih Bahri'
);

$this->estonia_regions = array(
	'37' => 'Harjumaa',
	'39' => 'Hiiumaa',
	'44' => 'Ida-Virumaa',
	'49' => 'Jõgevamaa',
	'51' => 'Järvamaa',
	'57' => 'Läänemaa',
	'59' => 'Lääne-Virumaa',
	'65' => 'Põlvamaa',
	'67' => 'Pärnumaa',
	'70' => 'Raplamaa',
	'74' => 'Saaremaa',
	'78' => 'Tartumaa',
	'82' => 'Valgamaa',
	'84' => 'Viljandimaa',
	'86' => 'Võrumaa'
);

$this->ethiopia_regions = array(
	'ET-AA'	 => 'Addis Ababa',
	'ET-DD'	 => 'Dire Dawa',
	'ET-AF'	 => 'Afar',
	'ET-AM'	 => 'Amara',
	'ET-BE'	 => 'Benshangul-Gumaz',
	'ET-GA'	 => 'Gambela Peoples',
	'ET-HA'	 => 'Harari People',
	'ET-OR'	 => 'Oromia',
	'ET-SO'	 => 'Somali',
	'ET-TI'	 => 'Tigrai',
	'ET-SN'	 => 'Southern Nations, Nationalities and Peoples'
);

$this->faroe_islands_regions = array(
	'NO' => 'Norderoerne',
	'OS' => 'Ostero',
	'SA' => 'Sando',
	'ST' => 'Stromo',
	'SN' => 'Sudero Nordre',
	'SS' => 'Sudero Sondre',
	'VG' => 'Vago'
);

$this->fiji_islands_regions = array(
	'BA' => 'Ba',
	'BU' => 'Bua',
	'Ck' => 'Cakaudrove',
	'KD' => 'Kadavu',
	'LU' => 'Lau',
	'LM' => 'Lomaiviti',
	'MC' => 'Macuata',
	'NN' => 'Nadroga-Navosa',
	'NT' => 'Naitasiri',
	'NM' => 'Namosi',
	'RA' => 'Ra',
	'RW' => 'Rewa',
	'RT' => 'Rotuma',
	'SR' => 'Serua',
	'TL' => 'Tailevu'
);

$this->france_regions = array(
	'FR-01'	 => 'Ain',
	'FR-02'	 => 'Aisne',
	'FR-03'	 => 'Allier',
	'FR-04'	 => 'Alpes-de-Haute-Provence',
	'FR-05'	 => 'Hautes-Alpes',
	'FR-06'	 => 'Alpes-Maritimes',
	'FR-07'	 => 'Ardèche',
	'FR-08'	 => 'Ardennes',
	'FR-09'	 => 'Ariège',
	'FR-10'	 => 'Aube',
	'FR-11'	 => 'Aude',
	'FR-12'	 => 'Aveyron',
	'FR-13'	 => 'Bouches-du-Rhône',
	'FR-14'	 => 'Calvados',
	'FR-15'	 => 'Cantal',
	'FR-16'	 => 'Charente',
	'FR-17'	 => 'Charente-Maritime',
	'FR-18'	 => 'Cher',
	'FR-19'	 => 'Corrèze',
	'FR-21'	 => 'Côte-d‌’Or',
	'FR-22'	 => 'Côtes-d‌’Armor',
	'FR-23'	 => 'Creuse',
	'FR-24'	 => 'Dordogne',
	'FR-25'	 => 'Doubs',
	'FR-26'	 => 'Drôme',
	'FR-27'	 => 'Eure',
	'FR-28'	 => 'Eure-et-Loir',
	'FR-29'	 => 'Finistère',
	'FR-2A'	 => 'Corse-du-Sud',
	'FR-2B'	 => 'Haute-Corse',
	'FR-30'	 => 'Gard',
	'FR-31'	 => 'Haute-Garonne',
	'FR-32'	 => 'Gers',
	'FR-33'	 => 'Gironde',
	'FR-34'	 => 'Hérault',
	'FR-35'	 => 'Ille-et-Vilaine',
	'FR-36'	 => 'Indre',
	'FR-37'	 => 'Indre-et-Loire',
	'FR-38'	 => 'Isère',
	'FR-39'	 => 'Jura',
	'FR-40'	 => 'Landes',
	'FR-41'	 => 'Loir-et-Cher',
	'FR-42'	 => 'Loire',
	'FR-43'	 => 'Haute-Loire',
	'FR-44'	 => 'Loire-Atlantique',
	'FR-45'	 => 'Loiret',
	'FR-46'	 => 'Lot',
	'FR-47'	 => 'Lot-et-Garonne',
	'FR-48'	 => 'Lozère',
	'FR-49'	 => 'Maine-et-Loire',
	'FR-50'	 => 'Manche',
	'FR-51'	 => 'Marne',
	'FR-52'	 => 'Haute-Marne',
	'FR-53'	 => 'Mayenne',
	'FR-54'	 => 'Meurthe-et-Moselle',
	'FR-55'	 => 'Meuse',
	'FR-56'	 => 'Morbihan',
	'FR-57'	 => 'Moselle',
	'FR-58'	 => 'Nièvre',
	'FR-59'	 => 'Nord',
	'FR-60'	 => 'Oise',
	'FR-61'	 => 'Orne',
	'FR-62'	 => 'Pas-de-Calais',
	'FR-63'	 => 'Puy-de-Dôme',
	'FR-64'	 => 'Pyrénées-Atlantiques',
	'FR-65'	 => 'Hautes-Pyrénées',
	'FR-66'	 => 'Pyrénées-Orientales',
	'FR-67'	 => 'Bas-Rhin',
	'FR-68'	 => 'Haut-Rhin',
	'FR-69'	 => 'Rhône',
	'FR-70'	 => 'Haute-Saône',
	'FR-71'	 => 'Saône-et-Loire',
	'FR-72'	 => 'Sarthe',
	'FR-73'	 => 'Savoie',
	'FR-74'	 => 'Haute-Savoie',
	'FR-75'	 => 'Paris',
	'FR-76'	 => 'Seine-Maritime',
	'FR-77'	 => 'Seine-et-Marne',
	'FR-78'	 => 'Yvelines',
	'FR-79'	 => 'Deux-Sèvres',
	'FR-80'	 => 'Somme',
	'FR-81'	 => 'Tarn',
	'FR-82'	 => 'Tarn-et-Garonne',
	'FR-83'	 => 'Var',
	'FR-84'	 => 'Vaucluse',
	'FR-85'	 => 'Vendée',
	'FR-86'	 => 'Vienne',
	'FR-87'	 => 'Haute-Vienne',
	'FR-88'	 => 'Vosges',
	'FR-89'	 => 'Yonne',
	'FR-90'	 => 'Territoire de Belfort',
	'FR-91'	 => 'Essonne',
	'FR-92'	 => 'Hauts-de-Seine',
	'FR-93'	 => 'Seine-Saint-Denis',
	'FR-94'	 => 'Val-de-Marne',
	'FR-95'	 => 'Val-d‌’Oise',
	'FR-NC'	 => 'New Caledonia',
	'FR-PF'	 => 'French Polynesia',
	'FR-PM'	 => 'Saint-Pierre and Miquelon',
	'FR-TF'	 => 'French Southern Territories',
	'FR-YT'	 => 'Mayotte',
	'FR-WF'	 => 'Wallis and Futuna'
);

$this->gabon_regions = array(
	'1'	 => 'Estuaire',
	'2'	 => 'Haut-Ogooue',
	'3'	 => 'Moyen-Ogooue',
	'4'	 => 'Ngounie',
	'5'	 => 'Nyanga',
	'6'	 => 'Ogooue-Ivindo',
	'7'	 => 'OgoouE-Lolo',
	'8'	 => 'Ogooue-Maritime',
	'9'	 => 'Woleu-Ntem'
);

$this->georgia_regions = array(
	'AB' => 'Abkhazia',
	'AJ' => 'Ajaria',
	'GU' => 'Guria',
	'IM' => 'Imeret‌’i',
	'KA' => 'Kakhet‌’i',
	'KK' => 'K‌’vemo K‌’art‌’li',
	'MM' => 'Mts‌’khet‌’a-Mt‌’ianet‌’i',
	'RL' => 'Racha-Lech‌’khumi-K‌’vemo',
	'SZ' => 'Samegrelo-Zemo Svanet‌’i',
	'SJ' => 'Samts‌’khe-Javakhet‌’i',
	'SK' => 'Shida K‌’art‌’li',
	'TB' => 'T‌’bilisi'
);

$this->germany_regions = array(
	'BAW'	 => 'Baden-Württemberg',
	'BAY'	 => 'Bayern',
	'BER'	 => 'Berlin',
	'BRG'	 => 'Brandenburg',
	'BRE'	 => 'Bremen',
	'HAM'	 => 'Hamburg',
	'HES'	 => 'Hessen',
	'MEC'	 => 'Mecklenburg-Vorpommern',
	'NDS'	 => 'Niedersachsen',
	'NRW'	 => 'Nordrhein-Westfalen',
	'RHE'	 => 'Rheinland-Pfalz',
	'SAR'	 => 'Saarland',
	'SAS'	 => 'Sachsen',
	'SAC'	 => 'Sachsen-Anhalt',
	'SCN'	 => 'Schleswig-Holstein',
	'THE'	 => 'Thüringen'
);

$this->ghana_regions = array(
	'GH-AH'	 => 'Ashanti',
	'GH-BA'	 => 'Brong-Ahafo',
	'GH-CP'	 => 'Central',
	'GH-EP'	 => 'Eastern',
	'GH-AA'	 => 'Greater Accra',
	'GH-NP'	 => 'Northern',
	'GH-UE'	 => 'Upper East',
	'GH-UW'	 => 'Upper West',
	'GH-TV'	 => 'Volta',
	'GH-WP'	 => 'Western'
);

$this->greece_regions = array(
	'ATT'	 => 'Αττική',
	'AIT'	 => 'Αιτωλοακαρνανία',
	'ARG'	 => 'Αργολίδα',
	'ARK'	 => 'Αρκαδία',
	'ART'	 => 'Άρτα',
	'AHA'	 => 'Αχαϊα',
	'BOI'	 => 'Βοιωτία',
	'GRE'	 => 'Γρεβενά',
	'DRA'	 => 'Δράμα',
	'DOD'	 => 'Δωδεκάνησα',
	'EVR'	 => 'Έβρος',
	'EVI'	 => 'Εύβοια',
	'EVT'	 => 'Ευρυτανία',
	'ZAK'	 => 'Ζάκυνθος',
	'ILI'	 => 'Ηλεία',
	'HMA'	 => 'Ημαθία',
	'HRA'	 => 'Ηράκλειο',
	'THP'	 => 'Θεσπρωτία',
	'THE'	 => 'Θεσσαλονίκη',
	'IOA'	 => 'Ιωάννινα',
	'KAV'	 => 'Καβάλα',
	'KAR'	 => 'Καρδίτσα',
	'KAS'	 => 'Καστοριά',
	'KER'	 => 'Κέρκυρα',
	'KEF'	 => 'Κεφαλληνία',
	'KIL'	 => 'Κιλκίς',
	'KOZ'	 => 'Κοζάνη',
	'KOR'	 => 'Κορινθία',
	'KYK'	 => 'Κυκλάδες',
	'LAK'	 => 'Λακωνία',
	'LAR'	 => 'Λάρισα',
	'LAS'	 => 'Λασίθι',
	'LES'	 => 'Λέσβος',
	'LEF'	 => 'Λευκάδα',
	'MAG'	 => 'Μαγνησία',
	'ΜES'	 => 'Μεσσηνία',
	'XAN'	 => 'Ξάνθη',
	'PEL'	 => 'Πέλλα',
	'PIE'	 => 'Πιερία',
	'PRE'	 => 'Πρέβεζα',
	'RET'	 => 'Ρέθυμνο',
	'ROD'	 => 'Ροδόπη',
	'SAM'	 => 'Σάμος',
	'SER'	 => 'Σέρρες',
	'TRI'	 => 'Τρίκαλα',
	'FTH'	 => 'Φθιώτιδα',
	'FLO'	 => 'Φλώρινα',
	'FOK'	 => 'Φωκίδα',
	'HAL'	 => 'Χαλκιδική',
	'HAN'	 => 'Χανιά',
	'HIO'	 => 'Χίος'
);

$this->greenland_regions = array(
	'NK' => 'Nuuk',
	'NQ' => 'Nuussuaq',
	'KQ' => 'Kangerlussuaq',
	'ST' => 'Sisimiut',
	'MQ' => 'Maniitsoq',
	'TQ' => 'Tasiilaq',
	'KK' => 'Kulusuk',
	'AP' => 'Alluitsup Paa',
	'QQ' => 'Qaqortoq',
	'NA' => 'Narsaq',
	'NK' => 'Nanortalik',
	'NR' => 'Narsarsuaq',
	'IQ' => 'Ikerasassuaq',
	'KT' => 'Kangilinnguit',
	'AK' => 'Arsuk',
	'PT' => 'Paamiut',
	'AT' => 'Aasiaat',
	'QT' => 'Qasigiannguit',
	'IL' => 'Ilulissat',
	'QE' => 'Qeqertarsuaq',
	'KA' => 'Kangaatsiaq',
	'UM' => 'Uummannaq',
	'UP' => 'Upernavik',
	'QA' => 'Qaarsut',
	'PT' => 'Pituffik',
	'QN' => 'Qaanaaq',
	'SN' => 'Station Nord',
	'IT' => 'Ittoqqortoormiit',
	'MV' => 'Mestersvig',
	'DH' => 'Danmarkshavn',
	'CP' => 'Constable Pynt',
	'SS' => 'Slædepatruljen Sirius'
);

$this->guatemala_regions = array(
	'AV' => 'Alta Verapaz',
	'BV' => 'Baja Verapaz',
	'CM' => 'Chimaltenango',
	'CQ' => 'Chiquimula',
	'PR' => 'El Progreso',
	'ES' => 'Escuintla',
	'GU' => 'Guatemala',
	'HU' => 'Huehuetenango',
	'IZ' => 'Izabal',
	'JA' => 'Jalapa',
	'JU' => 'Jutiapa',
	'PE' => 'Peten',
	'QZ' => 'Quetzaltenango',
	'QC' => 'Quiche',
	'RE' => 'Retalhuleu',
	'SA' => 'Sacatepequez',
	'SM' => 'San Marcos',
	'SR' => 'Santa Rosa',
	'SO' => 'Solola',
	'SU' => 'Suchitepequez',
	'TO' => 'Totonicapan',
	'ZA' => 'Zacapa'
);

$this->guinea_regions = array(
	'GN-BE'	 => 'Beyla',
	'GN-BF'	 => 'Boffa',
	'GN-BK'	 => 'Boké',
	'GN-CO'	 => 'Coyah',
	'GN-DB'	 => 'Dabola',
	'GN-DL'	 => 'Dalaba',
	'GN-DI'	 => 'Dinguiraye',
	'GN-DU'	 => 'Dubréka',
	'GN-FA'	 => 'Faranah',
	'GN-FO'	 => 'Forécariah',
	'GN-FR'	 => 'Fria',
	'GN-GA'	 => 'Gaoual',
	'GN-GU'	 => 'Guékédou',
	'GN-KA'	 => 'Kankan',
	'GN-KE'	 => 'Kérouané',
	'GN-KD'	 => 'Kindia',
	'GN-KS'	 => 'Kissidougou',
	'GN-KB'	 => 'Koubia',
	'GN-KN'	 => 'Koundara',
	'GN-KO'	 => 'Kouroussa',
	'GN-LA'	 => 'Labé',
	'GN-LE'	 => 'Lélouma',
	'GN-LO'	 => 'Lola',
	'GN-MC'	 => 'Macenta',
	'GN-ML'	 => 'Mali',
	'GN-MM'	 => 'Mamou',
	'GN-MD'	 => 'Mandiana',
	'GN-NZ'	 => 'Nzérékor',
	'GN-PI'	 => 'Pita',
	'GN-SI'	 => 'Siguiri',
	'GN-TE'	 => 'Télimélé',
	'GN-TO'	 => 'Tougué',
	'GN-YO'	 => 'Yomou'
);

$this->guinea_bissau_regions = array(
	'GW-BS'	 => 'Bissau',
	'GW-BA'	 => 'Bafatá',
	'GW-BM'	 => 'Biombo',
	'GW-BL'	 => 'Bolama',
	'GW-CA'	 => 'Cacheu',
	'GW-GA'	 => 'Gabú',
	'GW-OI'	 => 'Oio',
	'GW-QU'	 => 'Quinara',
	'GW-TO'	 => 'Tombali'
);

$this->guyana_regions = array(
	'GY-BA'	 => 'Barima-Waini',
	'GY-CU'	 => 'Cuyuni-Mazaruni',
	'GY-DE'	 => 'Demerara-Mahaica',
	'GY-EB'	 => 'East Berbice-Corentyne',
	'GY-ES'	 => 'Essequibo Islands-West Demerara',
	'GY-MA'	 => 'Mahaica-Berbice',
	'GY-PM'	 => 'Pomeroon-Supenaam',
	'GY-PT'	 => 'Potaro-Siparuni',
	'GY-UD'	 => 'Upper Demerara-Berbice',
	'GY-UT'	 => 'Upper Takutu-Upper Essequibo'
);

$this->haiti_regions = array(
	'HT-AR'	 => 'Artibonite',
	'HT-CE'	 => 'Centre',
	'HT-GA'	 => 'Grande-Anse',
	'HT-NI'	 => 'Nippes',
	'HT-ND'	 => 'Nord',
	'HT-NE'	 => 'Nord-Est',
	'HT-NO'	 => 'Nord-Ouest',
	'HT-OU'	 => 'Ouest',
	'HT-SD'	 => 'Sud',
	'HT-SE'	 => 'Sud-Est'
);

$this->honduras_regions = array(
	'HN-AT'	 => 'Atlántida',
	'HN-CL'	 => 'Colón',
	'HN-CM'	 => 'Comayagua',
	'HN-CP'	 => 'Copán',
	'HN-CR'	 => 'Cortés',
	'HN-CH'	 => 'Choluteca',
	'HN-EP'	 => 'El Paraíso',
	'HN-FM'	 => 'Francisco Morazán',
	'HN-GD'	 => 'Gracias a Dios',
	'HN-IN'	 => 'Intibucá',
	'HN-IB'	 => 'Islas de la Bahía',
	'HN-LP'	 => 'La Paz',
	'HN-LE'	 => 'Lempira',
	'HN-OC'	 => 'Ocotepeque',
	'HN-OL'	 => 'Olancho',
	'HN-SB'	 => 'Santa Bárbara',
	'HN-VA'	 => 'Valle',
	'HN-YO'	 => 'Yoro'
);

$this->hong_kong_regions = array(
	'HK' => 'Hong Kong',
	'NT' => 'New Territories'
);

$this->hungary_regions = array(
	'BUD'	 => 'Budapest',
	'BAR'	 => 'Baranya',
	'BKK'	 => 'Bács-Kiskun',
	'BÉK'	 => 'Békés',
	'BAZ'	 => 'Borsod-Abaúj-Zemplén',
	'CSO'	 => 'Csongrád',
	'FEJ'	 => 'Fejér',
	'GYS'	 => 'Gyõr-Sopron',
	'HAB'	 => 'Hajdú-Bihar',
	'HEV'	 => 'Heves',
	'JNS'	 => 'Jász-Nagykun-Szolnok',
	'KOE'	 => 'Komárom-Esztergom',
	'NOG'	 => 'Nógrád',
	'PES'	 => 'Pest',
	'SOM'	 => 'Somogy',
	'SSB'	 => 'Szabolcs-Szatmár-Bereg',
	'TOL'	 => 'Tolna',
	'VAS'	 => 'Vas',
	'VES'	 => 'Veszprém',
	'ZAL'	 => 'Zala'
);

$this->iceland_regions = array(
	'IS-7'	 => 'Austurland',
	'IS-1'	 => 'Höfuðborgarsvæði utan Reykjavíkur',
	'IS-6'	 => 'Norðurland eystra',
	'IS-5'	 => 'Norðurland vestra',
	'IS-0'	 => 'Reykjavík',
	'IS-8'	 => 'Suðurland',
	'IS-2'	 => 'Suðurnes',
	'IS-4'	 => 'Vestfirðir',
	'IS-3'	 => 'Vesturland'
);

$this->india_regions = array(
	'AN' => 'Andaman and Nicobar',
	'AP' => 'Andhra Pradesh',
	'AR' => 'Arunachal Pradesh',
	'AS' => 'Assam',
	'BR' => 'Bihar',
	'CH' => 'Chandigarh',
	'CT' => 'Chhattisgarh',
	'DN' => 'Dadra and Nagar Haveli',
	'DD' => 'Daman and Diu',
	'DL' => 'Delhi',
	'GA' => 'Goa',
	'GJ' => 'Gujarat',
	'HR' => 'Haryana',
	'HP' => 'Himachal Pradesh',
	'JK' => 'Jammu and Kashmir',
	'JH' => 'Jharkhand',
	'KA' => 'Karnataka',
	'KL' => 'Kerala',
	'LD' => 'Lakshadweep',
	'MP' => 'Madhya Pradesh',
	'MH' => 'Maharashtra',
	'MN' => 'Manipur',
	'ML' => 'Meghalaya',
	'MZ' => 'Mizoram',
	'NL' => 'Nagaland',
	'OR' => 'Orissa',
	'PY' => 'Puducherry',
	'PB' => 'Punjab',
	'RJ' => 'Rajasthan',
	'SK' => 'Sikkim',
	'TN' => 'Tamil Nadu',
	'TR' => 'Tripura',
	'UL' => 'Uttarakhand',
	'UP' => 'Uttar Pradesh',
	'WB' => 'West Bengal'
);

$this->indonesia_regions = array(
	'NAD'		 => 'Nanggroe Aceh Darussalam',
	'Sumut'		 => 'Sumatera Utara',
	'Sumbar'	 => 'Sumatera Barat',
	'Riau'		 => 'Riau',
	'Jambi'		 => 'Jambi',
	'Sumsel'	 => 'Sumatera Selatan',
	'Bengkulu'	 => 'Bengkulu',
	'Lampung'	 => 'Lampung',
	'Babel'		 => 'Kepulauan Bangka Belitung',
	'Kepri'		 => 'Kepulauan Riau',
	'DKI'		 => 'DKI Jakarta',
	'Jabar'		 => 'Jawa Barat',
	'Jateng'	 => 'Jawa Tengah',
	'DIY'		 => 'Daista Yogyakarta',
	'Jatim'		 => 'Jawa Timur',
	'Banten'	 => 'Banten',
	'Bali'		 => 'Bali',
	'NTB'		 => 'Nusa Tenggara Barat',
	'NTT'		 => 'Nusa Tenggara Timur',
	'Kalbar'	 => 'Kalimantan Barat',
	'Kalteng'	 => 'Kalimantan Tengah',
	'Kalsel'	 => 'Kalimantan Selatan',
	'Kaltim'	 => 'Kalimantan Timur',
	'Sulut'		 => 'Sulawesi Utara',
	'Sulteng'	 => 'Sulawesi Tengah',
	'Sulsel'	 => 'Sulawesi Selatan',
	'Sultra'	 => 'Sulawesi Tenggara',
	'Gorontalo'	 => 'Gorontalo',
	'Sulbar'	 => 'Sulawesi Barat',
	'Maluku'	 => 'Maluku',
	'Malut'		 => 'Maluku Utara',
	'Papua'		 => 'Papua',
	'Irjabar'	 => 'Irian Jaya Barat'
);

$this->iran_regions = array(
	'AS' => 'آذربایجان شرقی',
	'AG' => 'آذربایجان غربی',
	'AR' => 'اردبیل',
	'ES' => 'اصفهان',
	'IL' => 'ایلام',
	'BU' => 'بوشهر',
	'TH' => 'تهران',
	'CB' => 'چهار محال بختیاری',
	'KH' => 'خراسان جنوبی',
	'KH' => 'خراسان رضوی',
	'KH' => 'خراسان شمالی',
	'KZ' => 'خوزستان',
	'ZN' => 'زنجان',
	'SB' => 'سیستان و بلوچستان',
	'SM' => 'سمنان',
	'FR' => 'فارس',
	'QZ' => 'قزوین',
	'QM' => 'قم',
	'KD' => 'کردستان',
	'KR' => 'کرمان',
	'KS' => 'کرمانشاه',
	'KB' => 'کهگیلویه و بویر احمد',
	'GL' => 'گیلان',
	'GS' => 'گلستان',
	'LR' => 'لرستان',
	'MZ' => 'مازندران',
	'MR' => 'مرکزی',
	'HR' => 'هرمزگان',
	'HM' => 'همدان',
	'YZ' => 'یزد'
);

$this->iraq_regions = array(
	'IQ-AN'	 => 'Al Anbār',
	'IQ-BA'	 => 'Al Başrah',
	'IQ-MU'	 => 'Al Muthanná',
	'IQ-QA'	 => 'Al Qādisīyah',
	'IQ-NA'	 => 'An Najaf',
	'IQ-AR'	 => 'Arbīl',
	'IQ-SU'	 => 'As Sulaymānīyah',
	'IQ-TS'	 => 'At Ta‌’mīm',
	'IQ-BB'	 => 'Babil !Bābil',
	'IQ-BG'	 => 'Baghdād',
	'IQ-DA'	 => 'Dahūk',
	'IQ-DQ'	 => 'Dhī Qār',
	'IQ-DI'	 => 'Diyālá',
	'IQ-KA'	 => 'Karbalā‌’',
	'IQ-MA'	 => 'Maysān',
	'IQ-NI'	 => 'Nīnawá',
	'IQ-SD'	 => 'Şalāḩ ad Dīn',
	'IQ-WA'	 => 'Wāsiţ'
);

$this->ireland_regions = array(
	'CARLOW'	 => 'Co. Carlow',
	'CAVAN'		 => 'Co. Cavan',
	'CLARE'		 => 'Co. Clare',
	'CORK'		 => 'Co. Cork',
	'DONEGAL'	 => 'Co. Donegal',
	'DUBLIN'	 => 'Co. Dublin',
	'GALWAY'	 => 'Co. Galway',
	'KERRY'		 => 'Co. Kerry',
	'KILDARE'	 => 'Co. Kildare',
	'KILKENNY'	 => 'Co. Kilkenny',
	'LAOIS'		 => 'Co. Laois',
	'LEITRIM'	 => 'Co. Leitrim',
	'LIMERICK'	 => 'Co. Limerick',
	'LONGFORD'	 => 'Co. Longford',
	'LOUTH'		 => 'Co. Louth',
	'MAYO'		 => 'Co. Mayo',
	'MEATH'		 => 'Co. Meath',
	'MONAGHAN'	 => 'Co. Monaghan',
	'OFFALY'	 => 'Co. Offaly',
	'ROSCOMMON'	 => 'Co. Roscommon',
	'SLIGO'		 => 'Co. Sligo',
	'TIPPERARY'	 => 'Co. Tipperary',
	'WATERFORD'	 => 'Co. Waterford',
	'WESTMEATH'	 => 'Co. Westmeath',
	'WEXFORD'	 => 'Co. Wexford',
	'WICKLOW'	 => 'Co. Wicklow'
);

$this->israel_regions = array(
	'BS' => 'Be‌’er Sheva',
	'BH' => 'Bika‌’at Hayarden',
	'EA' => 'Eilat and Arava',
	'GA' => 'Galil',
	'HA' => 'Haifa',
	'JM' => 'Jehuda Mountains',
	'JE' => 'Jerusalem',
	'NE' => 'Negev',
	'SE' => 'Semaria',
	'SH' => 'Sharon',
	'TA' => 'Tel Aviv (Gosh Dan)'
);

$this->italy_regions = array(
	'AG'	 => 'Agrigento',
	'AL'	 => 'Alessandria',
	'AN'	 => 'Ancona',
	'AO'	 => 'Aosta',
	'AP'	 => 'Ascoli Piceno',
	'AQ'	 => 'L‌’Aquila',
	'AR'	 => 'Arezzo',
	'AT'	 => 'Asti',
	'AV'	 => 'Avellino',
	'BA'	 => 'Bari',
	'BG'	 => 'Bergamo',
	'BI'	 => 'Biella',
	'BL'	 => 'Belluno',
	'BN'	 => 'Benevento',
	'BO'	 => 'Bologna',
	'BR'	 => 'Brindisi',
	'BS'	 => 'Brescia',
	'BT'	 => 'Barletta-Andria-Trani',
	'BZ'	 => 'Bolzano',
	'CA'	 => 'Cagliari',
	'CB'	 => 'Campobasso',
	'CE'	 => 'Caserta',
	'CH'	 => 'Chieti',
	'CI'	 => 'Carbonia-Iglesias',
	'CL'	 => 'Caltanissetta',
	'CN'	 => 'Cuneo',
	'CO'	 => 'Como',
	'CR'	 => 'Cremona',
	'CS'	 => 'Cosenza',
	'CT'	 => 'Catania',
	'CZ'	 => 'Catanzaro',
	'EN'	 => 'Enna',
	'FC'	 => 'Forlì-Cesena',
	'FE'	 => 'Ferrara',
	'FG'	 => 'Foggia',
	'FI'	 => 'Firenze',
	'FM'	 => 'Fermo',
	'FR'	 => 'Frosinone',
	'GE'	 => 'Genova',
	'GO'	 => 'Gorizia',
	'GR'	 => 'Grosseto',
	'IM'	 => 'Imperia',
	'IS'	 => 'Isernia',
	'KR'	 => 'Crotone',
	'LC'	 => 'Lecco',
	'LE'	 => 'Lecce',
	'LI'	 => 'Livorno',
	'LO'	 => 'Lodi',
	'LT'	 => 'Latina',
	'LU'	 => 'Lucca',
	'MB'	 => 'Monza e Brianza',
	'MC'	 => 'Macerata',
	'ME'	 => 'Messina',
	'MI'	 => 'Milano',
	'MN'	 => 'Mantova',
	'MO'	 => 'Modena',
	'MS'	 => 'Massa e Carrara',
	'MT'	 => 'Matera',
	'NA'	 => 'Napoli',
	'NO'	 => 'Novara',
	'NU'	 => 'Nuoro',
	'OG'	 => 'Ogliastra',
	'OR'	 => 'Oristano',
	'OT'	 => 'Olbia-Tempio',
	'PA'	 => 'Palermo',
	'PC'	 => 'Piacenza',
	'PD'	 => 'Padova',
	'PE'	 => 'Pescara',
	'PG'	 => 'Perugia',
	'PI'	 => 'Pisa',
	'PN'	 => 'Pordenone',
	'PO'	 => 'Prato',
	'PR'	 => 'Parma',
	'PU'	 => 'Pesaro e Urbino',
	'PT'	 => 'Pistoia',
	'PV'	 => 'Pavia',
	'PZ'	 => 'Potenza',
	'RA'	 => 'Ravenna',
	'RC'	 => 'Reggio Calabria',
	'RE'	 => 'Reggio Emilia',
	'RG'	 => 'Ragusa',
	'RI'	 => 'Rieti',
	'RM'	 => 'Roma',
	'RN'	 => 'Rimini',
	'RO'	 => 'Rovigo',
	'SA'	 => 'Salerno',
	'SI'	 => 'Siena',
	'SO'	 => 'Sondrio',
	'SP'	 => 'La Spezia',
	'SR'	 => 'Siracusa',
	'SS'	 => 'Sassari',
	'SV'	 => 'Savona',
	'TA'	 => 'Taranto',
	'TE'	 => 'Teramo',
	'TN'	 => 'Trento',
	'TO'	 => 'Torino',
	'TP'	 => 'Trapani',
	'TR'	 => 'Terni',
	'TS'	 => 'Trieste',
	'TV'	 => 'Treviso',
	'UD'	 => 'Udine',
	'VA'	 => 'Varese',
	'VB'	 => 'Verbano-Cusio-Ossola',
	'VC'	 => 'Vercelli',
	'VE'	 => 'Venezia',
	'VI'	 => 'Vicenza',
	'VR'	 => 'Verona',
	'VS'	 => 'Medio Campidano',
	'VT'	 => 'Viterbo',
	'VV'	 => 'Vibo Valentia',
	'RSM'	 => 'Rep San Marino',
	'CTV'	 => 'Città del Vaticano'
);

$this->jamaica_regions = array(
	'JM-13'	 => 'Clarendon',
	'JM-09'	 => 'Hanover',
	'JM-01'	 => 'Kingston',
	'JM-12'	 => 'Manchester',
	'JM-04'	 => 'Portland',
	'JM-02'	 => 'Saint Andrew',
	'JM-06'	 => 'Saint Ann',
	'JM-14'	 => 'Saint Catherine',
	'JM-11'	 => 'Saint Elizabeth',
	'JM-08'	 => 'Saint James',
	'JM-05'	 => 'Saint Mary',
	'JM-03'	 => 'Saint Thomas',
	'JM-07'	 => 'Trelawny',
	'JM-10'	 => 'Westmoreland'
);

$this->japan_regions = array(
	'01' => '北海道',
	'02' => '青森県',
	'03' => '岩手県',
	'04' => '宮城県',
	'05' => '秋田県',
	'06' => '山形県',
	'07' => '福島県',
	'08' => '茨城県',
	'09' => '栃木県',
	'10' => '群馬県',
	'11' => '埼玉県',
	'12' => '千葉県',
	'13' => '東京都',
	'14' => '神奈川県',
	'15' => '新潟県',
	'16' => '富山県',
	'17' => '石川県',
	'18' => '福井県',
	'19' => '山梨県',
	'20' => '長野県',
	'21' => '岐阜県',
	'22' => '静岡県',
	'23' => '愛知県',
	'24' => '三重県',
	'25' => '滋賀県',
	'26' => '京都府',
	'27' => '大阪府',
	'28' => '兵庫県',
	'29' => '奈良県',
	'30' => '和歌山県',
	'31' => '鳥取県',
	'32' => '島根県',
	'33' => '岡山県',
	'34' => '広島県',
	'35' => '山口県',
	'36' => '徳島県',
	'37' => '香川県',
	'38' => '愛媛県',
	'39' => '高知県',
	'40' => '福岡県',
	'41' => '佐賀県',
	'42' => '長崎県',
	'43' => '熊本県',
	'44' => '大分県',
	'45' => '宮崎県',
	'46' => '鹿児島県',
	'47' => '沖縄県'
);

$this->jorda_regions = array(
	'JO-AJ'	 => '‌’Ajlūn',
	'JO-AQ'	 => 'Al ‌’Aqaba',
	'JO-BA'	 => 'Al Balqā‌’',
	'JO-KA'	 => 'Al Karak',
	'JO-MA'	 => 'Al Mafraq',
	'JO-AM'	 => '‌’Ammān',
	'JO-AT'	 => 'Aţ Ţafīlah',
	'JO-AZ'	 => 'Az Zarqā‌’',
	'JO-IR'	 => 'Irbid',
	'JO-JA'	 => 'Jarash',
	'JO-MN'	 => 'Ma\'ٰān',
	'JO-MD'	 => 'Mādaba'
);

$this->kazakhstan_regions = array(
	'ALA'	 => 'Алматы',
	'TSE'	 => 'Астана',
	'AKM'	 => 'Акмолинская область',
	'AKT'	 => 'Актюбинская область',
	'ALM'	 => 'Алматинская область',
	'ATR'	 => 'Атырауская область',
	'EKZ'	 => 'Восточно-Казахстанская область',
	'DZH'	 => 'Жамбылская область',
	'WKZ'	 => 'Западно-Казахстанская область',
	'KAR'	 => 'Карагандинская область',
	'KOR'	 => 'Кызылординская область',
	'KUS'	 => 'Костанайская область',
	'MAN'	 => 'Мангистауская область',
	'PVL'	 => 'Павлодарская область',
	'NKZ'	 => 'Северо-Казахстанская область',
	'SKZ'	 => 'Южно-Казахстанская область'
);

$this->kenya_regions = array(
	'700'	 => 'Bonde la Ufa',
	'200'	 => 'Central',
	'300'	 => 'Coast',
	'400'	 => 'Eastern',
	'500'	 => 'Kaskazini Masariki',
	'200'	 => 'Kati',
	'800'	 => 'Maqharibi',
	'400'	 => 'Mashariki',
	'110'	 => 'Nairobi',
	'500'	 => 'North-Eastern',
	'600'	 => 'Nyanza',
	'300'	 => 'Pwani',
	'700'	 => 'Rift Valley',
	'800'	 => 'Western'
);

$this->kiribati_regions = array(
	'KI-G'	 => 'Gilbert Islands',
	'KI-L'	 => 'Line Islands',
	'KI-P'	 => 'Phoenix Islands'
);

$this->korea_democratic_peoples_republic_regions = array(
	'KP-01'	 => 'P’yŏngyang',
	'KP-13'	 => 'Nasŏn (Najin-Sŏnbong',
	'KP-02'	 => 'P’yŏngan-namdo',
	'KP-03'	 => 'P’yŏngan-bukto',
	'KP-04'	 => 'Chagang-do',
	'KP-05'	 => 'Hwanghae-namdo',
	'KP-06'	 => 'Hwanghae-bukto',
	'KP-07'	 => 'Kangwŏn-do',
	'KP-08'	 => 'Hamgyŏng-namdo',
	'KP-09'	 => 'Hamgyŏng-bukto',
	'KP-10'	 => 'Yanggang-do'
);

$this->korea_republic_regions = array(
	'CO' => 'Ch‌’ungch‌’ong-bukto',
	'CH' => 'Ch‌’ungch‌’ong-namdo',
	'CD' => 'Cheju-do',
	'CB' => 'Cholla-bukto',
	'CN' => 'Cholla-namdo',
	'IG' => 'Inch‌’on-gwangyoksi',
	'KA' => 'Kangwon-do',
	'KG' => 'Kwangju-gwangyoksi',
	'KD' => 'Kyonggi-do',
	'KB' => 'Kyongsang-bukto',
	'KN' => 'Kyongsang-namdo',
	'PG' => 'Pusan-gwangyoksi',
	'SO' => 'Soul-t‌’ukpyolsi',
	'TA' => 'Taegu-gwangyoksi',
	'TG' => 'Taejon-gwangyoksi'
);

$this->kuwait_regions = array(
	'KW-AH'	 => 'Al Aḩmadi',
	'KW-FA'	 => 'Al Farwānīyah',
	'KW-JA'	 => 'Al Jahrah',
	'KW-KU'	 => 'Al Kuwayt',
	'KW-HA'	 => 'Hawallī !Ḩawallī',
	'KW-MU'	 => 'Mubārak al Kabīr'
);

$this->kyrgyzstan_regions = array(
	'KG-GB'	 => 'Bishkek',
	'KG-B'	 => 'Batken',
	'KG-C'	 => 'Chü',
	'KG-J'	 => 'Jalal-Abad',
	'KG-N'	 => 'Naryn',
	'KG-O'	 => 'Osh',
	'KG-T'	 => 'Talas',
	'KG-Y'	 => 'Ysyk-Köl'
);

$this->laos_regions = array(
	'LA-VT'	 => 'Vientiane',
	'LA-AT'	 => 'Attapu [Attopeu]',
	'LA-BK'	 => 'Bokè',
	'LA-BL'	 => 'Bolikhamxai [Borikhane]',
	'LA-CH'	 => 'Champasak [Champassak]',
	'LA-HO'	 => 'Houaphan',
	'LA-KH'	 => 'Khammouan',
	'LA-LM'	 => 'Louang Namtha',
	'LA-LP'	 => 'Louangphabang [Louang Prabang]',
	'LA-OU'	 => 'Oudômxai [Oudomsai]',
	'LA-PH'	 => 'Phôngsali [Phong Saly]',
	'LA-SL'	 => 'Salavan [Saravane]',
	'LA-SV'	 => 'Savannakhé',
	'LA-VI'	 => 'Vientiane',
	'LA-XA'	 => 'Xaignabouli',
	'LA-XE'	 => 'Xekong',
	'LA-XI'	 => 'Xiangkhoang [Xieng Khouang]',
	'LA-XN'	 => 'Xaisômbou'
);

$this->latvia_regions = array(
	'AI'	 => 'Aizkraukles rajons',
	'AL'	 => 'Alūksnes rajons',
	'BL'	 => 'Balvu rajons',
	'BU'	 => 'Bauskas rajons',
	'CE'	 => 'Cēsu rajons',
	'DGV'	 => 'Daugavpils pilsēta',
	'DA'	 => 'Daugavpils rajons',
	'DO'	 => 'Dobeles rajons',
	'GU'	 => 'Gulbenes rajons',
	'JK'	 => 'Jēkabpils rajons',
	'JEL'	 => 'Jelgavas pilsēta',
	'JL'	 => 'Jelgavas rajons',
	'JUR'	 => 'Jūrmalas pilsēta',
	'KR'	 => 'Krāslavas rajons',
	'KU'	 => 'Kuldīgas rajons',
	'LPX'	 => 'Liepājas pilsēta',
	'LE'	 => 'Liepājas rajons',
	'LM'	 => 'Limbažu rajons',
	'LU'	 => 'Ludzas rajons',
	'MA'	 => 'Madonas rajons',
	'OG'	 => 'Ogres rajons',
	'PR'	 => 'Preiļu rajons',
	'REZ'	 => 'Rēzeknes pilsēta',
	'RE'	 => 'Rēzeknes rajons',
	'RIX'	 => 'Rīgas pilsēta',
	'RI'	 => 'Rīgas rajons',
	'SA'	 => 'Saldus rajons',
	'TA'	 => 'Talsu rajons',
	'TU'	 => 'Tukuma rajons',
	'VK'	 => 'Valkas rajons',
	'VM'	 => 'Valmieras rajons',
	'VEN'	 => 'Ventspils pilsēta',
	'VE'	 => 'Ventspils rajons'
);

$this->lebanon_regions = array(
	'LB-AK'	 => 'Aakkâr',
	'LB-BH'	 => 'Baalbek-Hermel',
	'LB-BI'	 => 'Beqaa',
	'LB-BA'	 => 'Beyrouth',
	'LB-AS'	 => 'Liban-Nord',
	'LB-JA'	 => 'Liban-Sud',
	'LB-JL'	 => 'Mont-Liban',
	'LB-NA'	 => 'Nabatîyé'
);

$this->lesotho_regions = array(
	'LS-D'	 => 'Berea',
	'LS-B'	 => 'Butha-Buthe',
	'LS-C'	 => 'Leribe',
	'LS-E'	 => 'Mafeteng',
	'LS-A'	 => 'Maseru',
	'LS-F'	 => 'Mohale‌’s Hoek',
	'LS-J'	 => 'Mokhotlong',
	'LS-H'	 => 'Qacha‌’s Nek',
	'LS-G'	 => 'Quthing',
	'LS-K'	 => 'Thaba-Tseka'
);

$this->liberia_regions = array(
	'LR-BM'	 => 'Bomi',
	'LR-BG'	 => 'Bong',
	'LR-GP'	 => 'Gbarpolu',
	'LR-GB'	 => 'Grand Bassa',
	'LR-CM'	 => 'Grand Cape Mount',
	'LR-GG'	 => 'Grand Gedeh',
	'LR-GK'	 => 'Grand Kru',
	'LR-LO'	 => 'Lofa',
	'LR-MG'	 => 'Margibi',
	'LR-MY'	 => 'Maryland',
	'LR-MO'	 => 'Montserrado',
	'LR-NI'	 => 'Nimba',
	'LR-RI'	 => 'Rivercess',
	'LR-RG'	 => 'RiverGee',
	'LR-SI'	 => 'Sinoe'
);

$this->libya_regions = array(
	'LY-BU'	 => 'Al Buţnān',
	'LY-JA'	 => 'Al Jabal al Akhḑar',
	'LY-JG'	 => 'Al Jabal al Gharbī',
	'LY-JI'	 => 'Al Jifārah',
	'LY-JU'	 => 'Al Jufrah',
	'LY-KF'	 => 'Al Kufrah',
	'LY-MJ'	 => 'Al Marj',
	'LY-MB'	 => 'Al Marqab',
	'LY-WA'	 => 'Al Wāḩāt',
	'LY-NQ'	 => 'An Nuqaţ al Khams',
	'LY-ZA'	 => 'Az Zāwiyah',
	'LY-BA'	 => 'Banghāzī',
	'LY-DR'	 => 'Darnah',
	'LY-GT'	 => 'Ghāt',
	'LY-MI'	 => 'Mişrātah',
	'LY-MQ'	 => 'Murzuq',
	'LY-NL'	 => 'Nālūt',
	'LY-SB'	 => 'Sabhā',
	'LY-SR'	 => 'Surt',
	'LY-TB'	 => 'Tarābulus',
	'LY-WD'	 => 'Wādī al Ḩayāt',
	'LY-WS'	 => 'Wādī ash Shāţiʾ'
);

$this->liechtenstein_regions = array(
	'LI-01'	 => 'Balzers',
	'LI-02'	 => 'Eschen',
	'LI-03'	 => 'Gamprin',
	'LI-04'	 => 'Mauren',
	'LI-05'	 => 'Planken',
	'LI-06'	 => 'Ruggell',
	'LI-07'	 => 'Schaan',
	'LI-08'	 => 'Schellenberg',
	'LI-09'	 => 'Triesen',
	'LI-10'	 => 'Triesenberg',
	'LI-11'	 => 'Vaduz'
);

$this->lithuania_regions = array(
	'AK'	 => 'Akmenės rajonas',
	'AL'	 => 'Alytaus rajonas',
	'AN'	 => 'Anykščių rajonas',
	'BIR'	 => 'Biržų rajonas',
	'IG'	 => 'Ignalinos rajonas',
	'JON'	 => 'Jonavos rajonas',
	'JO'	 => 'Joniškio rajonas',
	'JUR'	 => 'Jurbarko rajonas',
	'KAI'	 => 'Kaišiadorių rajonas',
	'KA'	 => 'Kauno rajonas',
	'KE'	 => 'Kėdainių rajonas',
	'KEL'	 => 'Kelmės rajonas',
	'KLA'	 => 'Klaipėdos rajonas',
	'KR'	 => 'Kretingos rajonas',
	'KU'	 => 'Kupiškio rajonas',
	'LA'	 => 'Lazdijų rajonas',
	'MA'	 => 'Mažeikių rajonas',
	'MO'	 => 'Molėtų rajonas',
	'PA'	 => 'Pakruojo rajonas',
	'PAN'	 => 'Panevėžio rajonas',
	'PAS'	 => 'Pasvalio rajonas',
	'PLU'	 => 'Plungės rajonas',
	'PR'	 => 'Prienų rajonas',
	'RA'	 => 'Radviliškio rajonas',
	'RAS'	 => 'Raseinių rajonas',
	'RO'	 => 'Rokiškio rajonas',
	'SK'	 => 'Skuodo rajonas',
	'SA'	 => 'Šakių rajonas',
	'SAL'	 => 'Šalčininkų rajonas',
	'SIA'	 => 'Šiaulių rajonas',
	'SI'	 => 'Šilalės rajonas',
	'SIL'	 => 'Šilutės rajonas',
	'SIR'	 => 'Širvintų rajonas',
	'SV'	 => 'Švenčionių rajonas',
	'TA'	 => 'Tauragės rajonas',
	'TE'	 => 'Telšių rajonas',
	'TR'	 => 'Trakų rajonas',
	'UK'	 => 'Ukmergės rajonas',
	'UT'	 => 'Utenos rajonas',
	'VA'	 => 'Varėnos rajonas',
	'VI'	 => 'Vilkaviškio rajonas',
	'VIL'	 => 'Vilniaus rajonas',
	'ZAR'	 => 'Zarasų rajonas'
);

$this->macedonia_fyrom_regions = array(
	'01' => 'Aerodrom',
	'02' => 'Aracinovo',
	'03' => 'Berovo',
	'04' => 'Bitola',
	'05' => 'Bogdanci',
	'06' => 'Bogovinje',
	'07' => 'Bosilovo',
	'08' => 'Brvenica',
	'09' => 'Butel',
	'79' => 'Cair',
	'80' => 'Caska',
	'77' => 'Centar',
	'78' => 'Centar Zupa',
	'81' => 'Cesinovo-Oblesevo',
	'82' => 'Cucer Sandevo',
	'21' => 'Debar',
	'22' => 'Debarca',
	'23' => 'Delcevo',
	'24' => 'Demir Kapija',
	'26' => 'Dojran',
	'27' => 'Dolneni',
	'28' => 'Drugovo',
	'17' => 'Gazi Baba',
	'18' => 'Gevgelija',
	'29' => 'Gjorce Petrov',
	'19' => 'Gostivar',
	'20' => 'Gradsko',
	'34' => 'Ilinden',
	'35' => 'Jequnovce',
	'37' => 'Karbinci',
	'38' => 'Karpos',
	'36' => 'Kavadarci',
	'40' => 'Kicevo',
	'39' => 'Kisela Voda',
	'42' => 'Kocani',
	'41' => 'Konce',
	'43' => 'Kratovo',
	'44' => 'Kriva Palanka',
	'45' => 'Krivoqastani',
	'46' => 'Krusevo',
	'47' => 'Kumanovo',
	'48' => 'Lipkovo',
	'49' => 'Lozovo',
	'51' => 'Makedonska Kamenica',
	'52' => 'Makedonski Brod',
	'50' => 'Mavrovo-i-Rostusa',
	'53' => 'Moqila',
	'54' => 'Negotino',
	'55' => 'Novaci',
	'56' => 'Novo Selo',
	'58' => 'Ohrid',
	'57' => 'Oslomej',
	'60' => 'Pehcevo',
	'59' => 'Petrovec',
	'61' => 'Plasnica',
	'62' => 'Prilep',
	'63' => 'Probistip',
	'64' => 'Radovis',
	'65' => 'Rankovce',
	'66' => 'Resen',
	'67' => 'Rosoman',
	'68' => 'Saraj',
	'70' => 'Sopiste',
	'71' => 'Staro Nagoricane',
	'83' => 'Stip',
	'72' => 'Struga',
	'73' => 'Strumica',
	'74' => 'Studenicani',
	'84' => 'Suto Orizari',
	'69' => 'Sveti Nikole',
	'75' => 'Tearce',
	'76' => 'Tetovo',
	'10' => 'Valandovo',
	'11' => 'Vasilevo',
	'13' => 'Veles',
	'12' => 'Vevcani',
	'14' => 'Vinica',
	'15' => 'Vranestica',
	'16' => 'Vrapciste',
	'31' => 'Zajas',
	'32' => 'Zelenikovo',
	'30' => 'Zelino',
	'33' => 'Zrnovci'
);

$this->madagascar_regions = array(
	'MG-T'	 => 'Antananarivo',
	'MG-D'	 => 'Antsiranana',
	'MG-F'	 => 'Fianarantsoa',
	'MG-M'	 => 'Mahajanga',
	'MG-A'	 => 'Toamasina',
	'MG-U'	 => 'Toliara'
);

$this->malawi_regions = array(
	'MW-BA'	 => 'Balaka',
	'MW-BL'	 => 'Blantyre',
	'MW-CK'	 => 'Chikwawa',
	'MW-CR'	 => 'Chiradzulu',
	'MW-CT'	 => 'Chitipa',
	'MW-DE'	 => 'Dedza',
	'MW-DO'	 => 'Dowa',
	'MW-KR'	 => 'Karonga',
	'MW-KS'	 => 'Kasungu',
	'MW-LK'	 => 'Likoma',
	'MW-LI'	 => 'Lilongwe',
	'MW-MH'	 => 'Machinga',
	'MW-MG'	 => 'Mangochi',
	'MW-MC'	 => 'Mchinji',
	'MW-MU'	 => 'Mulanje',
	'MW-MW'	 => 'Mwanza',
	'MW-MZ'	 => 'Mzimba',
	'MW-NE'	 => 'Neno',
	'MW-NB'	 => 'Nkhata Bay',
	'MW-NK'	 => 'Nkhotakota',
	'MW-NS'	 => 'Nsanje',
	'MW-NU'	 => 'Ntcheu',
	'MW-NI'	 => 'Ntchisi',
	'MW-PH'	 => 'Phalombe',
	'MW-RU'	 => 'Rumphi',
	'MW-SA'	 => 'Salima',
	'MW-TH'	 => 'Thyolo',
	'MW-ZO'	 => 'Zomba'
);

$this->malaysia_regions = array(
	'JHR'	 => 'Johor',
	'KDH'	 => 'Kedah',
	'KTN'	 => 'Kelantan',
	'MLK'	 => 'Melaka',
	'NSN'	 => 'Negeri Sembilan',
	'PHG'	 => 'Pahang',
	'PNG'	 => 'Pulau Pinang',
	'PRK'	 => 'Perak',
	'PLS'	 => 'Perlis',
	'SGR'	 => 'Selangor',
	'TRG'	 => 'Terengganu',
	'SBH'	 => 'Sabah',
	'SRW'	 => 'Sarawak',
	'KUL'	 => 'Kuala Lumpur',
	'LBN'	 => 'Labuan',
	'PJY'	 => 'Putrajaya'
);

$this->maldives_regions = array(
	'MV-MLE' => 'Male',
	'MV-02'	 => 'Alif',
	'MV-20'	 => 'Baa',
	'MV-17'	 => 'Dhaalu',
	'MV-14'	 => 'Faafu',
	'MV-27'	 => 'Gaaf Alif',
	'MV-28'	 => 'Gaafu Dhaalu',
	'MV-29'	 => 'Gnaviyani',
	'MV-07'	 => 'Haa Alif',
	'MV-23'	 => 'Haa Dhaalu',
	'MV-26'	 => 'Kaafu',
	'MV-05'	 => 'Laamu',
	'MV-03'	 => 'Lhaviyani',
	'MV-12'	 => 'Meemu',
	'MV-25'	 => 'Noonu',
	'MV-13'	 => 'Raa',
	'MV-01'	 => 'Seenu',
	'MV-24'	 => 'Shaviyani',
	'MV-08'	 => 'Thaa',
	'MV-04'	 => 'Vaavu'
);

$this->mali_regions = array(
	'ML-BKO' => 'Bamako',
	'ML-7'	 => 'Gao',
	'ML-1'	 => 'Kayes',
	'ML-8'	 => 'Kidal',
	'ML-2'	 => 'Koulikoro',
	'ML-5'	 => 'Mopti',
	'ML-4'	 => 'Ségou',
	'ML-3'	 => 'Sikasso',
	'ML-6'	 => 'Tombouctou'
);

$this->malta_regions = array(
	'01' => 'Attard',
	'02' => 'Balzan',
	'03' => 'Birqu',
	'04' => 'Birkirkara',
	'05' => 'Birzebbuqa',
	'06' => 'Bormla',
	'07' => 'Dinqli',
	'08' => 'Fgura',
	'09' => 'Floriana',
	'10' => 'Fontana',
	'13' => 'Ghajnsielem',
	'14' => 'Gharb',
	'15' => 'Gharqhur',
	'16' => 'Ghasri',
	'17' => 'Ghaxaq',
	'11' => 'Gudja',
	'12' => 'Gzira',
	'18' => 'Hamrun',
	'19' => 'Iklin',
	'20' => 'Isla',
	'21' => 'Kalkara',
	'22' => 'Kercem',
	'23' => 'Kirkop',
	'24' => 'Lija',
	'25' => 'Luga',
	'26' => 'Marsa',
	'27' => 'Marsaskala',
	'28' => 'Marsaxlokk',
	'29' => 'Mdina',
	'30' => 'Mellieha',
	'31' => 'Mgarr',
	'32' => 'Mosta',
	'33' => 'Mgabba',
	'34' => 'Msida',
	'35' => 'Mtarfa',
	'36' => 'Munxar',
	'37' => 'Nadur',
	'38' => 'Naxxar',
	'39' => 'Paola',
	'40' => 'Pembroke',
	'41' => 'Pieta',
	'42' => 'Qala',
	'43' => 'Qormi',
	'44' => 'Qrendi',
	'45' => 'Rabat Ghawdex',
	'45' => 'Rabat Gozo',
	'46' => 'Rabat Malta',
	'47' => 'Safi',
	'49' => 'Saint John',
	'48' => 'Saint Julian‌’s',
	'50' => 'Saint Lawrence',
	'53' => 'Saint Lucia‌’s',
	'51' => 'Saint Paul‌’s Bay',
	'48' => 'San Giljan',
	'49' => 'San Gwann',
	'50' => 'San Lawrenz',
	'51' => 'San Pawl il-Bahar',
	'52' => 'Sannat',
	'53' => 'Santa Lucija',
	'54' => 'Santa Venera',
	'55' => 'Siggiewi',
	'56' => 'Sliema',
	'57' => 'Swiegi',
	'58' => 'Ta‌’Xbiex',
	'59' => 'Tarxien',
	'60' => 'Valletta',
	'61' => 'Xaghra',
	'62' => 'Xewkija',
	'63' => 'Xghajra',
	'64' => 'Zabbar',
	'65' => 'Zebbug Ghawdex',
	'65' => 'Zebbug Gozo',
	'66' => 'Zebbug Malta',
	'67' => 'Zejtun',
	'68' => 'Zurrieg'
);

$this->marshal_islands_regions = array(
	'MH-ALL' => 'Ailinglaplap',
	'MH-ALK' => 'Ailuk',
	'MH-ARN' => 'Arno',
	'MH-AUR' => 'Aur',
	'MH-EBO' => 'Ebon',
	'MH-ENI' => 'Enewetak',
	'MH-JAB' => 'Jabat',
	'MH-JAL' => 'Jaluit',
	'MH-KIL' => 'Kili',
	'MH-KWA' => 'Kwajalein',
	'MH-LAE' => 'Lae',
	'MH-LIB' => 'Lib',
	'MH-LIK' => 'Likiep',
	'MH-MAJ' => 'Majuro',
	'MH-MAL' => 'Maloelap',
	'MH-MEJ' => 'Mejit',
	'MH-MIL' => 'Mili',
	'MH-NMK' => 'Namdrik',
	'MH-NMU' => 'Namu',
	'MH-RON' => 'Rongelap',
	'MH-UJA' => 'Ujae',
	'MH-UTI' => 'Utirik',
	'MH-WTH' => 'Wotho',
	'MH-WTJ' => 'Wotje'
);

$this->mauritania_regions = array(
	'MR-NKC' => 'Nouakchott',
	'MR-07'	 => 'Adrar',
	'MR-03'	 => 'Assaba',
	'MR-05'	 => 'Brakna',
	'MR-08'	 => 'Dakhlet Nouâdhibou',
	'MR-04'	 => 'Gorgol',
	'MR-10'	 => 'Guidimaka',
	'MR-01'	 => 'Hodh ech Chargui',
	'MR-02'	 => 'Hodh el Gharbi',
	'MR-12'	 => 'Inchiri',
	'MR-09'	 => 'Tagant',
	'MR-11'	 => 'Tiris Zemmour',
	'MR-06'	 => 'Trarza'
);

$this->mauritius_regions = array(
	'AG' => 'Agalega Islands',
	'BR' => 'Beau Bassin-Rose',
	'BL' => 'Black River',
	'CC' => 'Cargados Carajos',
	'CU' => 'Curepipe',
	'FL' => 'Flacq',
	'GP' => 'Grand Port',
	'MO' => 'Moka',
	'PA' => 'Pamplemousses',
	'PW' => 'Plaines Wilhems',
	'PL' => 'Port Louis',
	'PU' => 'Port Louis',
	'QB' => 'Quatre Bornes',
	'RR' => 'Riviere du Rempart',
	'RO' => 'Rodrigues Island',
	'CC' => 'Saint Brandon Islands',
	'SA' => 'Savanne',
	'VP' => 'Vacoas-Phoenix'
);

$this->mexica_regions = array(
	'AGS'	 => 'Aguascalientes',
	'BC'	 => 'Baja California',
	'BCS'	 => 'Baja California Sur',
	'CAM'	 => 'Campeche',
	'CHIS'	 => 'Chiapas',
	'CHI'	 => 'Chihuahua',
	'COAH'	 => 'Coahuila',
	'COL'	 => 'Colima',
	'DF'	 => 'Distrito Federal',
	'DGO'	 => 'Durango',
	'GTO'	 => 'Guanajuato',
	'GRO'	 => 'Guerrero',
	'HGO'	 => 'Hidalgo',
	'JAL'	 => 'Jalisco',
	'ME'	 => 'México',
	'MICH'	 => 'Michoacán',
	'MOR'	 => 'Morelos',
	'NAY'	 => 'Nayarit',
	'NL'	 => 'Nuevo León',
	'OAX'	 => 'Oaxaca',
	'PUE'	 => 'Puebla',
	'QUE'	 => 'Querétaro',
	'QR'	 => 'Quintana Roo',
	'SLP'	 => 'San Luis Potosi',
	'SIN'	 => 'Sinaloa',
	'SON'	 => 'Sonora',
	'TAB'	 => 'Tabasco',
	'TAM'	 => 'Tamaulipas',
	'TLA'	 => 'Tlaxcala',
	'VER'	 => 'Veracruz',
	'YUC'	 => 'Yucatán',
	'ZAC'	 => 'Zacatecas'
);

$this->micronesia_regions = array(
	'FM-TRK' => 'Chuuk',
	'FM-KSA' => 'Kosrae',
	'FM-PNI' => 'Pohnpei',
	'FM-YAP' => 'Yap'
);

$this->moldova_regions = array(
	'GA' => 'Găgăuzia, Unitatea teritorială autonomă (UTAG)',
	'BA' => 'Bălţi',
	'BD' => 'Tighina',
	'CU' => 'Chişinău',
	'AN' => 'Anenii Noi',
	'BS' => 'Basarabeasca',
	'BR' => 'Briceni',
	'CA' => 'Cahul',
	'CT' => 'Cantemir',
	'CL' => 'Călăraşi',
	'CS' => 'Căuşeni',
	'CM' => 'Cimişlia',
	'CR' => 'Criuleni',
	'DO' => 'Donduşeni',
	'DR' => 'Drochia',
	'DU' => 'Dubăsari',
	'ED' => 'Edineţ',
	'FA' => 'Făleşti',
	'FL' => 'Floreşti',
	'GL' => 'Glodeni',
	'HI' => 'Hînceşti',
	'IA' => 'Ialoveni',
	'LE' => 'Leova',
	'NI' => 'Nisporeni',
	'OC' => 'Ocniţa',
	'OR' => 'Orhei',
	'RE' => 'Rezina',
	'RI' => 'Rîşcani',
	'SI' => 'Sîngerei',
	'SO' => 'Soroca',
	'ST' => 'Străşeni',
	'SD' => 'Şoldăneşti',
	'SV' => 'Ştefan Vodă',
	'TA' => 'Taraclia',
	'TE' => 'Teleneşti',
	'UN' => 'Ungheni',
	'SN' => 'Stînga Nistrului, unitatea teritorială din'
);

$this->mongolia_regions = array(
	'MN-1'	 => 'Ulaanbaatar',
	'MN-073' => 'Arhangay',
	'MN-069' => 'Bayanhongor',
	'MN-071' => 'Bayan-Ölgiy',
	'MN-067' => 'Bulgan',
	'MN-037' => 'Darhan uul',
	'MN-061' => 'Dornod',
	'MN-063' => 'Dornogovĭ',
	'MN-059' => 'Dundgovĭ',
	'MN-057' => 'Dzavhan',
	'MN-065' => 'Govĭ-Altay',
	'MN-064' => 'Govĭ-Sümber',
	'MN-039' => 'Hentiy',
	'MN-043' => 'Hovd',
	'MN-041' => 'Hövsgöl',
	'MN-053' => 'Ömnögovĭ',
	'MN-035' => 'Orhon',
	'MN-055' => 'Övörhangay',
	'MN-049' => 'Selenge',
	'MN-051' => 'Sühbaatar',
	'MN-047' => 'Töv',
	'MN-046' => 'Uvs'
);

$this->montenegro_regions = array(
	'01' => 'Andrijevica',
	'02' => 'Bar',
	'03' => 'Berane',
	'04' => 'Bijelo Polje',
	'05' => 'Budva',
	'06' => 'Cetinje',
	'07' => 'Danilovgrad',
	'08' => 'Herceq-Novi',
	'09' => 'Kolasin',
	'10' => 'Kotor',
	'11' => 'Mojkovac',
	'12' => 'Niksic',
	'13' => 'Plav',
	'14' => 'Pljevlja',
	'15' => 'Pluzine',
	'16' => 'Podgorica',
	'17' => 'Rozaje',
	'18' => 'Savnik',
	'19' => 'Tivat',
	'20' => 'Ulcinj',
	'21' => 'Zabljak'
);

$this->morocco_regions = array(
	'09'	 => 'Chaouia-Ouardigha',
	'10'	 => 'Doukkala-Abda',
	'05'	 => 'Fes-Boulemane',
	'02'	 => 'Gharb-Chrarda-Beni Hssen',
	'08'	 => 'Grand Casablanca',
	'14'	 => 'Guelmim-Es Smara',
	'15'	 => 'Laayoune-Boujdour-Sakia el Hamra',
	'04'	 => 'L-Oriental',
	'11'	 => 'Marrakech-Tensift-Al Haouz',
	'06'	 => 'Meknes-Tafilalet',
	'16'	 => 'Oued ed Dahab-Lagouira',
	'07'	 => 'Rabat-Sale-Zemmour-Zaer',
	'13'	 => 'Sous-Massa-Draa',
	'12'	 => 'Tadla-Azilal',
	'01'	 => 'Tanger-Tetouan',
	'03'	 => 'Taza-Al Hoceima-Taounate',
	'CHE'	 => 'Chefchaouene',
	'LAR'	 => 'Larache',
	'TNG'	 => 'Tanger',
	'TET'	 => 'Tetouan',
	'KEN'	 => 'Kenitra',
	'SIK'	 => 'Sidi Kacem',
	'HOC'	 => 'AL Hoceima',
	'TAO'	 => 'Taounate',
	'TAZ'	 => 'Taza',
	'BER'	 => 'Berkane',
	'FIG'	 => 'Figuig',
	'JRA'	 => 'Jerada',
	'NAD'	 => 'Nador',
	'OUJ'	 => 'Oujda',
	'BOM'	 => 'Boulemane',
	'FES'	 => 'Fes',
	'SEF'	 => 'Sefrou',
	'HAJ'	 => 'El Hajeb',
	'ERR'	 => 'Errachidia',
	'IFR'	 => 'Ifrane',
	'KHN'	 => 'Khenifra',
	'MEK'	 => 'Meknes',
	'KHE'	 => 'Khemisset',
	'RBA'	 => 'Rabat-Sale',
	'CAS'	 => 'Casablanca',
	'CAS'	 => 'Dar el Beida',
	'BES'	 => 'Ben Slimane',
	'KHO'	 => 'Khouribga',
	'SET'	 => 'Settat',
	'JDI'	 => 'El Jadida',
	'SAF'	 => 'Safi',
	'HAO'	 => 'Al Haouz',
	'CHI'	 => 'Chichaoua',
	'ESI'	 => 'Essaouira',
	'KES'	 => 'Kelaat Sraghna',
	'MAR'	 => 'Marrakech',
	'AZI'	 => 'Azilal',
	'BEM'	 => 'Beni Mellal',
	'AGD'	 => 'Agadir',
	'BAH'	 => 'Ait Baha',
	'MEL'	 => 'Ait Melloul',
	'OUA'	 => 'Ouarzazate',
	'TAR'	 => 'Taroudannt',
	'TIZ'	 => 'Tiznit',
	'ASZ'	 => 'Assa-Zaq',
	'ESM'	 => 'Es Smara',
	'GUE'	 => 'Guelmim',
	'TNT'	 => 'Tan-Tan',
	'TAT'	 => 'Tata',
	'BOD'	 => 'Boujdour',
	'LAA'	 => 'Laayoune',
	'OUD'	 => 'Oued ed Dahab'
);

$this->mozambiqie_regions = array(
	'POL'	 => 'Cabo Delgado',
	'VJB'	 => 'Gaza',
	'INH'	 => 'Inhambane',
	'CHI'	 => 'Manica',
	'MPM'	 => 'Maputo',
	'APL'	 => 'Nampula',
	'VXC'	 => 'Niassa',
	'BEW'	 => 'Sofala',
	'TCV'	 => 'Tete',
	'UEL'	 => 'Zambezia'
);

$this->myanmar_regions = array(
	'07' => 'Ayeyarwady',
	'02' => 'Bago',
	'14' => 'Chin',
	'11' => 'Kachin',
	'12' => 'Kayah',
	'13' => 'Kayin',
	'03' => 'Magway',
	'04' => 'Mandalay',
	'15' => 'Mon',
	'16' => 'Rakhine',
	'01' => 'Sagaing',
	'17' => 'Shan',
	'05' => 'Tanintharyi',
	'06' => 'Yangon'
);

$this->namimbia_regions = array(
	'NA-CA'	 => 'Caprivi',
	'NA-ER'	 => 'Erongo',
	'NA-HA'	 => 'Hardap',
	'NA-KA'	 => 'Karas',
	'NA-KH'	 => 'Khomas',
	'NA-KU'	 => 'Kunene',
	'NA-OW'	 => 'Ohangwena',
	'NA-OK'	 => 'Okavango',
	'NA-OH'	 => 'Omaheke',
	'NA-OS'	 => 'Omusati',
	'NA-ON'	 => 'Oshana',
	'NA-OT'	 => 'Oshikoto',
	'NA-OD'	 => 'Otjozondjupa'
);

$this->nauru_regions = array(
	'NR-01'	 => 'Aiwo',
	'NR-02'	 => 'Anabar',
	'NR-03'	 => 'Anetan',
	'NR-04'	 => 'Anibare',
	'NR-05'	 => 'Baiti',
	'NR-06'	 => 'Boe',
	'NR-07'	 => 'Buada',
	'NR-08'	 => 'Denigomodu',
	'NR-09'	 => 'Ewa',
	'NR-10'	 => 'Ijuw',
	'NR-11'	 => 'Meneng',
	'NR-12'	 => 'Nibok',
	'NR-13'	 => 'Uaboe',
	'NR-14'	 => 'Yaren'
);

$this->nepal_regions = array(
	'2'	 => 'Madhya Pashchimanchal',
	'1'	 => 'Madhyamanchal',
	'3'	 => 'Pashchimanchal',
	'4'	 => 'Purwanchal',
	'5'	 => 'Sudur Pashchimanchal',
	'BA' => 'Bagmati',
	'JA' => 'Janakpur',
	'NA' => 'Narayani',
	'BH' => 'Bheri',
	'KA' => 'Karnali',
	'RA' => 'Rapti',
	'DH' => 'Dhawalagiri',
	'GA' => 'Gandaki',
	'LU' => 'Lumbini',
	'KO' => 'Koshi',
	'KO' => 'Kosi',
	'ME' => 'Mechi',
	'SA' => 'Sagarmatha',
	'MA' => 'Mahakali',
	'SE' => 'Seti'
);

$this->netherlands_regions = array(
	'ZHL'	 => 'Zuid-Holland',
	'NHL'	 => 'Noord-Holland',
	'NBR'	 => 'Noord-Brabant',
	'GLD'	 => 'Gelderland',
	'UTR'	 => 'Utrecht',
	'LIM'	 => 'Limburg',
	'OVE'	 => 'Overijssel',
	'FRL'	 => 'Friesland',
	'GRO'	 => 'Groningen',
	'DRE'	 => 'Drenthe',
	'ZLD'	 => 'Zeeland',
	'FLD'	 => 'Flevoland'
);

$this->new_zealand_regions = array(
	'AUK'	 => 'Auckland',
	'BOP'	 => 'Bay of Plenty',
	'CAN'	 => 'Canterbury',
	'COR'	 => 'Coromandel',
	'GIS'	 => 'Gisborne',
	'FIO'	 => 'Fiordland',
	'HKB'	 => 'Hawke‌’s Bay',
	'MBH'	 => 'Marlborough',
	'MWT'	 => 'Manawatu-Wanganui',
	'MCM'	 => 'Mt Cook-Mackenzie',
	'NSN'	 => 'Nelson',
	'NTL'	 => 'Northland',
	'OTA'	 => 'Otago',
	'STL'	 => 'Southland',
	'TKI'	 => 'Taranaki',
	'WGN'	 => 'Wellington',
	'WKO'	 => 'Waikato',
	'WAI'	 => 'Wairarapa',
	'WTC'	 => 'West Coast'
);

$this->nicaragua_regions = array(
	'AN' => 'Atlantico Norte',
	'AS' => 'Atlantico Sur',
	'BO' => 'Boaco',
	'CA' => 'Carazo',
	'CI' => 'Chinandega',
	'CO' => 'Chontales',
	'ES' => 'Esteli',
	'GR' => 'Granada',
	'JI' => 'Jinotega',
	'LE' => 'Leon',
	'MD' => 'Madriz',
	'MN' => 'Managua',
	'MS' => 'Masaya',
	'MT' => 'Matagalpa',
	'NS' => 'Nueva Segovia',
	'SJ' => 'Rio San Juan',
	'RI' => 'Rivas'
);

$this->niger_regions = array(
	'NE-8'	 => 'Niamey',
	'NE-1'	 => 'Agadez',
	'NE-2'	 => 'Diffa',
	'NE-3'	 => 'Dosso',
	'NE-4'	 => 'Maradi',
	'NE-5'	 => 'Tahoua ',
	'NE-6'	 => 'Tillabéri',
	'NE-7'	 => 'Zinder'
);

$this->nigeria_regions = array(
	'AB' => 'Abia',
	'AD' => 'Adamawa',
	'AK' => 'Akwa Ibom',
	'AN' => 'Anambra',
	'BA' => 'Bauchi',
	'BY' => 'Bayelsa',
	'BN' => 'Benue',
	'BO' => 'Borno',
	'CR' => 'Cross River',
	'DT' => 'Delta',
	'EB' => 'Ebonyi',
	'ED' => 'Edo',
	'EK' => 'Ekiti',
	'EN' => 'Enugu',
	'FC' => 'FCT - Abuja',
	'GB' => 'Gombe',
	'IM' => 'Imo',
	'JG' => 'Jigawa',
	'KD' => 'Kaduna',
	'KN' => 'Kano',
	'KT' => 'Katsina',
	'KB' => 'Kebbi',
	'KG' => 'Kogi',
	'KW' => 'Kwara',
	'LA' => 'Lagos',
	'NS' => 'Nassarawa',
	'NG' => 'Niger',
	'OG' => 'Ogun',
	'ON' => 'Ondo',
	'OS' => 'Osun',
	'OY' => 'Oyo',
	'PL' => 'Plateau',
	'RV' => 'Rivers',
	'SO' => 'Sokoto',
	'TB' => 'Taraba',
	'YB' => 'Yobe',
	'ZM' => 'Zamfara'
);

$this->norway_regions = array(
	'AK' => 'Akershus',
	'AA' => 'Aust-Agder',
	'BU' => 'Buskerud',
	'FM' => 'Finnmark',
	'HM' => 'Hedmark',
	'HL' => 'Hordaland',
	'MR' => 'More og Romdal',
	'NT' => 'Nord-Trondelag',
	'NL' => 'Nordland',
	'OF' => 'Ostfold',
	'OP' => 'Oppland',
	'OL' => 'Oslo',
	'RL' => 'Rogaland',
	'ST' => 'Sor-Trondelag',
	'SJ' => 'Sogn og Fjordane',
	'SV' => 'Svalbard',
	'TM' => 'Telemark',
	'TR' => 'Troms',
	'VA' => 'Vest-Agder',
	'VF' => 'Vestfold'
);

$this->oman_regions = array(
	'BA' => 'Al Batinah',
	'DA' => 'Ad Dakhiliyah',
	'JA' => 'Al Janubiyah',
	'MA' => 'Masqat',
	'MU' => 'Musandam',
	'SH' => 'Ash Sharqiyah',
	'WU' => 'Al Wusta',
	'ZA' => 'Az Zahirah'
);

$this->pakistan_regions = array(
	'PB' => 'Punjab',
	'SN' => 'Sindh',
	'BL' => 'Balochistan',
	'NW' => 'N.W.F.P'
);

$this->palau_regions = array(
	'PW-002' => 'Aimeliik',
	'PW-004' => 'Airai',
	'PW-010' => 'Angaur',
	'PW-050' => 'Hatobohei',
	'PW-100' => 'Kayangel',
	'PW-150' => 'Koror',
	'PW-212' => 'Melekeok',
	'PW-214' => 'Ngaraard',
	'PW-218' => 'Ngarchelong',
	'PW-222' => 'Ngardmau',
	'PW-224' => 'Ngatpang',
	'PW-226' => 'Ngchesar',
	'PW-227' => 'Ngeremlengui',
	'PW-228' => 'Ngiwal',
	'PW-350' => 'Peleliu',
	'PW-370' => 'Sonsorol'
);

$this->panama_regions = array(
	'1'	 => 'Bocas del Toro',
	'4'	 => 'Chiriqui',
	'2'	 => 'Cocle',
	'3'	 => 'Colon',
	'0'	 => 'Comarca de San Blas',
	'5'	 => 'Darien',
	'6'	 => 'Herrera',
	'7'	 => 'Los Santos',
	'8'	 => 'Panama',
	'9'	 => 'Veraguas'
);

$this->papua_new_guinea_regions = array(
	'CPM'	 => 'Central',
	'CPK'	 => 'Chimbu',
	'EHG'	 => 'Eastern Highlands',
	'EBR'	 => 'East New Britain',
	'ESW'	 => 'East Sepik',
	'EPW'	 => 'Enga',
	'GPK'	 => 'Gulf',
	'MPM'	 => 'Madang',
	'MRL'	 => 'Manus',
	'MBA'	 => 'Milne Bay',
	'MPL'	 => 'Morobe',
	'NCD'	 => 'National Capital District (Port Moresby)',
	'NIK'	 => 'New Ireland',
	'NPP'	 => 'Northern',
	'NSA'	 => 'North Solomons',
	'SAN'	 => 'Sandaun [West Sepik]',
	'SHM'	 => 'Southern Highlands',
	'WPD'	 => 'Western',
	'WHM'	 => 'Western Highlands',
	'WBK'	 => 'West New Britain'
);

$this->paraguay_regions = array(
	'PY-ASU' => 'Asunción',
	'PY-16'	 => 'Alto Paraguay',
	'PY-10'	 => 'Alto Paraná',
	'PY-13'	 => 'Amambay',
	'PY-19'	 => 'Boquerón',
	'PY-05'	 => 'Caaguazú',
	'PY-06'	 => 'Caazapá',
	'PY-14'	 => 'Canindeyú',
	'PY-11'	 => 'Central',
	'PY-01'	 => 'Concepción',
	'PY-03'	 => 'Cordillera',
	'PY-04'	 => 'Guairá',
	'PY-07'	 => 'Itapúa',
	'PY-08'	 => 'Misiones',
	'PY-12'	 => 'Ñeembucú',
	'PY-09'	 => 'Paraguarí',
	'PY-15'	 => 'Presidente Hayes',
	'PY-02'	 => 'San Pedro'
);

$this->peru_regions = array(
	'AMA'	 => 'Amazonas',
	'ANC'	 => 'Ancash',
	'APU'	 => 'Apurímac',
	'ARE'	 => 'Arequipa',
	'AYA'	 => 'Ayacucho',
	'CAJ'	 => 'Cajamarca',
	'CAL'	 => 'Callao',
	'CUS'	 => 'Cusco',
	'HUV'	 => 'Huancavelica',
	'HUC'	 => 'Huánuco',
	'ICA'	 => 'Ica',
	'JUN'	 => 'Junín',
	'LAL'	 => 'La Libertad',
	'LAM'	 => 'Lambayeque',
	'LIM'	 => 'Lima',
	'LOR'	 => 'Loreto',
	'MDD'	 => 'Madre de Dios',
	'MOQ'	 => 'Moquegua',
	'PAS'	 => 'Pasco',
	'PIU'	 => 'Piura',
	'PUN'	 => 'Puno',
	'SAM'	 => 'San Martín',
	'TAC'	 => 'Tacna',
	'TUM'	 => 'Tumbes',
	'UCA'	 => 'Ucayali'
);

$this->philipines_regions = array(
	'ABR'	 => 'Abra',
	'ANO'	 => 'Agusan del Norte',
	'ASU'	 => 'Agusan del Sur',
	'AKL'	 => 'Aklan',
	'ALB'	 => 'Albay',
	'ANT'	 => 'Antique',
	'APY'	 => 'Apayao',
	'AUR'	 => 'Aurora',
	'BAS'	 => 'Basilan',
	'BTA'	 => 'Bataan',
	'BTE'	 => 'Batanes',
	'BTG'	 => 'Batangas',
	'BEN'	 => 'Benguet',
	'BLR'	 => 'Biliran',
	'BOL'	 => 'Bohol',
	'BUK'	 => 'Bukidnon',
	'BUL'	 => 'Bulacan',
	'CAG'	 => 'Cagayan',
	'CNO'	 => 'Camarines Norte',
	'CSU'	 => 'Camarines Sur',
	'CAM'	 => 'Camiguin',
	'CAP'	 => 'Capiz',
	'CAT'	 => 'Catanduanes',
	'CAV'	 => 'Cavite',
	'CEB'	 => 'Cebu',
	'CMP'	 => 'Compostela Valley',
	'DNO'	 => 'Davao del Norte',
	'DSU'	 => 'Davao del Sur',
	'DOR'	 => 'Davao Oriental',
	'DGI'	 => 'Dinagat Islands',
	'ESA'	 => 'Eastern Samar',
	'GUI'	 => 'Guimaras',
	'IFU'	 => 'Ifugao',
	'INO'	 => 'Ilocos Norte',
	'ISU'	 => 'Ilocos Sur',
	'ILO'	 => 'Iloilo',
	'ISA'	 => 'Isabela',
	'KAL'	 => 'Kalinga',
	'LAG'	 => 'Laguna',
	'LNO'	 => 'Lanao del Norte',
	'LSU'	 => 'Lanao del Sur',
	'UNI'	 => 'La Union',
	'LEY'	 => 'Leyte',
	'MAG'	 => 'Maguindanao',
	'MRN'	 => 'Marinduque',
	'MSB'	 => 'Masbate',
	'MLA'	 => 'Metro Manila',
	'MIC'	 => 'Mindoro Occidental',
	'MIR'	 => 'Mindoro Oriental',
	'MSC'	 => 'Misamis Occidental',
	'MOR'	 => 'Misamis Oriental',
	'MOP'	 => 'Mountain Province',
	'NOC'	 => 'Negros Occidental',
	'NOR'	 => 'Negros Oriental',
	'NCT'	 => 'North Cotabato',
	'NSM'	 => 'Northern Samar',
	'NEC'	 => 'Nueva Ecija',
	'NVZ'	 => 'Nueva Vizcaya',
	'PLW'	 => 'Palawan',
	'PMP'	 => 'Pampanga',
	'PNG'	 => 'Pangasinan',
	'QZN'	 => 'Quezon',
	'QRN'	 => 'Quirino',
	'RIZ'	 => 'Rizal',
	'ROM'	 => 'Romblon',
	'SMR'	 => 'Samar',
	'SRG'	 => 'Sarangani',
	'SHK'	 => 'Shariff Kabunsuan',
	'SQJ'	 => 'Siquijor',
	'SRS'	 => 'Sorsogon',
	'SCO'	 => 'South Cotabato',
	'SLE'	 => 'Southern Leyte',
	'SKU'	 => 'Sultan Kudarat',
	'SLU'	 => 'Sulu',
	'SNO'	 => 'Surigao del Norte',
	'SSU'	 => 'Surigao del Sur',
	'TAR'	 => 'Tarlac',
	'TAW'	 => 'Tawi-Tawi',
	'ZBL'	 => 'Zambales',
	'ZNO'	 => 'Zamboanga del Norte',
	'ZSU'	 => 'Zamboanga del Sur',
	'ZSI'	 => 'Zamboanga Sibugay'
);

$this->poland_regions = array(
	'DO' => 'Dolnośląskie',
	'KP' => 'Kujawsko-Pomorskie',
	'LO' => 'Łódzkie',
	'LL' => 'Lubelskie',
	'LU' => 'Lubuskie',
	'ML' => 'Małopolskie',
	'MZ' => 'Mazowieckie',
	'OP' => 'Opolskie',
	'PP' => 'Podkarpackie',
	'PL' => 'Podlaskie',
	'PM' => 'Pomorskie',
	'SL' => 'Śląskie',
	'SW' => 'Świętokrzyskie',
	'WM' => 'Warmińsko-Mazurskie',
	'WP' => 'Wielkopolskie',
	'ZA' => 'Zachodniopomorskie'
);

$this->portugal_regions = array(
	'AVE'	 => 'Aveiro',
	'BEJ'	 => 'Beja',
	'BRA'	 => 'Braga',
	'BGA'	 => 'Bragança',
	'CAB'	 => 'Castelo Branco',
	'COI'	 => 'Coimbra',
	'EVO'	 => 'Évora',
	'FAR'	 => 'Faro',
	'GUA'	 => 'Guarda',
	'LEI'	 => 'Leiria',
	'LIS'	 => 'Lisboa',
	'PTL'	 => 'Portalegre',
	'POR'	 => 'Porto',
	'STR'	 => 'Santarém',
	'SET'	 => 'Setúbal',
	'VIC'	 => 'Viana do Castelo',
	'VIR'	 => 'Vila Real',
	'VIS'	 => 'Viseu',
	'ACO'	 => 'Reg. Autónoma Açores',
	'MAD'	 => 'Reg. Autónoma Madeira'
);

$this->qatar_regions = array(
	'QA-DA'	 => 'Ad Dawḩah',
	'QA-GH'	 => 'Al Ghuwayrīyah',
	'QA-JU'	 => 'Al Jumaylīyah',
	'QA-KH'	 => 'Al Khawr',
	'QA-WA'	 => 'Al Wakrah',
	'QA-RA'	 => 'Ar Rayyān',
	'QA-JB'	 => 'Jarīyān al Bāţnah',
	'QA-MS'	 => 'Madīnat ash Shamāl',
	'QA-US'	 => 'Umm Şalāl'
);

$this->romania_regions = array(
	'AB' => 'Alba',
	'AR' => 'Arad',
	'AG' => 'Arges',
	'BC' => 'Bacau',
	'BH' => 'Bihor',
	'BN' => 'Bistrita-Nasaud',
	'BT' => 'Botosani',
	'BV' => 'Brasov',
	'BR' => 'Braila',
	'B'	 => 'Bucuresti',
	'BZ' => 'Buzau',
	'CS' => 'Caras-Severin',
	'CL' => 'Calarasi',
	'CJ' => 'Cluj',
	'CT' => 'Constanta',
	'CV' => 'Covasna',
	'DB' => 'Dimbovita',
	'DJ' => 'Dolj',
	'GL' => 'Galati',
	'GR' => 'Giurgiu',
	'GJ' => 'Gorj',
	'HR' => 'Harghita',
	'HD' => 'Hunedoara',
	'IL' => 'Ialomita',
	'IS' => 'Iasi',
	'IF' => 'Ilfov',
	'MM' => 'Maramures',
	'MH' => 'Mehedinti',
	'MS' => 'Mures',
	'NT' => 'Neamt',
	'OT' => 'Olt',
	'PH' => 'Prahova',
	'SM' => 'Satu-Mare',
	'SJ' => 'Salaj',
	'SB' => 'Sibiu',
	'SV' => 'Suceava',
	'TR' => 'Teleorman',
	'TM' => 'Timis',
	'TL' => 'Tulcea',
	'VS' => 'Vaslui',
	'VL' => 'Valcea',
	'VN' => 'Vrancea'
);

$this->russian_federation_regions = array(
	'AD'	 => 'Республика Адыгея',
	'AL'	 => 'Республика Алтай',
	'BA'	 => 'Республика Башкортостан',
	'BU'	 => 'Республика Бурятия',
	'DA'	 => 'Республика Дагестан',
	'IN'	 => 'Республика Ингушетия',
	'KB'	 => 'Кабардино-Балкарская Республика',
	'KL'	 => 'Республика Калмыкия',
	'KC'	 => 'Карачаево-Черкесская республика',
	'KR'	 => 'Республика Карелия',
	'KO'	 => 'Республика Коми',
	'ME'	 => 'Республика Марий Эл',
	'MO'	 => 'Республика Мордовия',
	'SA'	 => 'Республика Саха (Якутия)',
	'SE'	 => 'Республика Северная Осетия-Алания',
	'TA'	 => 'Республика Татарстан',
	'TY'	 => 'Республика Тыва',
	'UD'	 => 'Удмуртская Республика',
	'KK'	 => 'Республика Хакасия',
	'CE'	 => 'Чеченская республика',
	'CU'	 => 'Чувашская Республика',
	'ALT'	 => 'Алтайский край',
	'KDA'	 => 'Краснодарский край',
	'KIA'	 => 'Красноярский край',
	'PER'	 => 'Пермский край',
	'PRI'	 => 'Приморский край',
	'STA'	 => 'Ставропольский край',
	'KHA'	 => 'Хабаровский край',
	'AMU'	 => 'Амурская область',
	'ARK'	 => 'Архангельская область',
	'AST'	 => 'Астраханская область',
	'BEL'	 => 'Белгородская область',
	'BRY'	 => 'Брянская область',
	'VLA'	 => 'Владимирская область',
	'VGG'	 => 'Волгоградская область',
	'VLG'	 => 'Вологодская область',
	'VOR'	 => 'Воронежская область',
	'IVA'	 => 'Ивановская область',
	'IRK'	 => 'Иркутская область',
	'KGD'	 => 'Калининградская область',
	'KLU'	 => 'Калужская область',
	'KAM'	 => 'Камчатский край',
	'KEM'	 => 'Кемеровская область',
	'KIR'	 => 'Кировская область',
	'KOS'	 => 'Костромская область',
	'KGN'	 => 'Курганская область',
	'KRS'	 => 'Курская область',
	'LEN'	 => 'Ленинградская область',
	'LIP'	 => 'Липецкая область',
	'MAG'	 => 'Магаданская область',
	'MOS'	 => 'Московская область',
	'MUR'	 => 'Мурманская область',
	'NIZ'	 => 'Нижегородская область',
	'NGR'	 => 'Новгородская область',
	'NVS'	 => 'Новосибирская область',
	'OMS'	 => 'Омская область',
	'ORE'	 => 'Оренбургская область',
	'ORL'	 => 'Орловская область',
	'PNZ'	 => 'Пензенская область',
	'PSK'	 => 'Псковская область',
	'ROS'	 => 'Ростовская область',
	'RYA'	 => 'Рязанская область',
	'SAM'	 => 'Самарская область',
	'SAR'	 => 'Саратовская область',
	'SAK'	 => 'Сахалинская область',
	'SVE'	 => 'Свердловская область',
	'SMO'	 => 'Смоленская область',
	'TAM'	 => 'Тамбовская область',
	'TVE'	 => 'Тверская область',
	'TOM'	 => 'Томская область',
	'TUL'	 => 'Тульская область',
	'TYU'	 => 'Тюменская область',
	'ULY'	 => 'Ульяновская область',
	'CHE'	 => 'Челябинская область',
	'YAR'	 => 'Ярославская область',
	'MOW'	 => 'Москва',
	'SPE'	 => 'Санкт-Петербург',
	'YEV'	 => 'Еврейская автономная область',
	'NEN'	 => 'Ненецкий автономный округ',
	'KHM'	 => 'Ханты-Мансийский автономный округ - Югра',
	'CHU'	 => 'Чукотский автономный округ',
	'YAN'	 => 'Ямало-Ненецкий автономный округ',
	'ZAB'	 => 'Забайкальский край'
);

$this->rwanda_regions = array(
	'RW-01'	 => 'Ville de Kigali',
	'RW-02'	 => 'Est',
	'RW-03'	 => 'Nord',
	'RW-04'	 => 'Ouest',
	'RW-05'	 => 'Sud'
);

$this->saint_kitts_nevis_regions = array(
	'CCN'	 => 'Christ Church Nichola Town',
	'ASP'	 => 'Saint Anne Sandy Point',
	'GBA'	 => 'Saint George Basseterre',
	'GGI'	 => 'Saint George Gingerland',
	'JWI'	 => 'Saint James Windward',
	'JCA'	 => 'Saint John Capisterre',
	'JFI'	 => 'Saint John Figtree',
	'MCA'	 => 'Saint Mary Cayon',
	'PCA'	 => 'Saint Paul Capisterre',
	'PCH'	 => 'Saint Paul Charlestown',
	'PBS'	 => 'Saint Peter Basseterre',
	'TLO'	 => 'Saint Thomas Lowland',
	'TMI'	 => 'Saint Thomas Middle Island',
	'TPP'	 => 'Trinity Palmetto Point'
);

$this->saint_lucia_regions = array(
	'AR' => 'Anse-la-Raye',
	'CA' => 'Castries',
	'CH' => 'Choiseul',
	'DA' => 'Dauphin',
	'DE' => 'Dennery',
	'GI' => 'Gros-Islet',
	'LA' => 'Laborie',
	'MI' => 'Micoud',
	'PR' => 'Praslin',
	'SO' => 'Soufriere',
	'VF' => 'Vieux-Fort'
);

$this->saint_vincent_grenadines_regions = array(
	'VC-01'	 => 'Charlotte',
	'VC-06'	 => 'Grenadines',
	'VC-02'	 => 'Saint Andrew',
	'VC-03'	 => 'Saint David',
	'VC-04'	 => 'Saint George',
	'VC-05'	 => 'Saint Patrick'
);

$this->samoa_regions = array(
	'WS-AA'	 => 'A‌’ana',
	'WS-AL'	 => 'Aiga-i-le-Tai',
	'WS-AT'	 => 'Atua',
	'WS-FA'	 => 'Fa‌’asaleleaga',
	'WS-GE'	 => 'Gaga‌’emauga',
	'WS-GI'	 => 'Gagaifomauga',
	'WS-PA'	 => 'Palauli',
	'WS-SA'	 => 'Satupa‌’itea',
	'WS-TU'	 => 'Tuamasaga',
	'WS-VF'	 => 'Va‌’a-o-Fonoti',
	'WS-VS'	 => 'Vaisigano'
);

$this->san_marino_regions = array(
	'SM-01'	 => 'Acquaviva',
	'SM-06'	 => 'Borgo Maggiore',
	'SM-02'	 => 'Chiesanuova',
	'SM-03'	 => 'Domagnano',
	'SM-04'	 => 'Faetano',
	'SM-05'	 => 'Fiorentino',
	'SM-08'	 => 'Montegiardino',
	'SM-07'	 => 'San Marino',
	'SM-09'	 => 'Serravalle'
);

$this->sao_tome_regions = array(
	'ST-P'	 => 'Príncipe',
	'ST-S'	 => 'São Tomé'
);

$this->saudi_arabia_regions = array(
	'ALBAHAH'			 => 'Al Bahah',
	'NORTHERNBORDER'	 => 'Northern Border',
	'ALJAWF'			 => 'Al Jawf',
	'ALMADINAH'			 => 'Al Madinah',
	'ALQASIM'			 => 'Al Qasim',
	'HAIL'				 => 'Hail',
	'ASIR'				 => 'Asir',
	'EASTERN PROVINCE'	 => 'Eastern Province',
	'ALRIYADH'			 => 'Al Riyadh',
	'TABUK'				 => 'Tabuk',
	'NAJRAN'			 => 'Najran',
	'MAKKAH'			 => 'Makkah',
	'JIZAN'				 => 'Jizan'
);

$this->senegal_regions = array(
	'DK' => 'Dakar',
	'DB' => 'Diourbel',
	'FK' => 'Fatick',
	'KL' => 'Kaolack',
	'KD' => 'Kolda',
	'LG' => 'Louga',
	'MT' => 'Matam',
	'SL' => 'Saint-Louis',
	'TC' => 'Tambacounda',
	'TH' => 'Thies',
	'ZH' => 'Ziguinchor'
);

$this->serbia_regions = array(
	'00' => 'Beograd',
	'14' => 'Bor',
	'11' => 'Barnicevo',
	'23' => 'Jablanica',
	'09' => 'Kolubara',
	'KM' => 'Kosovo-Metohija',
	'08' => 'Macva',
	'17' => 'Moravica',
	'20' => 'Nisava',
	'24' => 'Pcinja',
	'22' => 'Pirot',
	'10' => 'Podunavlje',
	'13' => 'Pomoravlje',
	'19' => 'Rasina',
	'18' => 'Raska',
	'12' => 'Sumadija',
	'21' => 'Toplica',
	'VO' => 'Vojvodina',
	'15' => 'Zajecar',
	'16' => 'Zlatibor',
	'25' => 'Kosovo',
	'29' => 'Kosovo-Pomoravlje',
	'28' => 'Kosovska Mitrovica',
	'26' => 'Pec',
	'27' => 'Prizren',
	'06' => 'Juzna Backa',
	'04' => 'Juzni Banat',
	'01' => 'Severna Backa',
	'03' => 'Severni Banat',
	'02' => 'Srednji Banat',
	'07' => 'Srem',
	'05' => 'Zapadna Backa'
);

$this->seychelles_regions = array(
	'01' => 'Anse aux Pins',
	'02' => 'Anse Boileau',
	'03' => 'Anse Etoile',
	'04' => 'Anse Louis',
	'05' => 'Anse Royale',
	'06' => 'Baie Lazare',
	'07' => 'Baie Sainte Anne',
	'08' => 'Beau Vallon',
	'09' => 'Bel Air',
	'10' => 'Bel Ombre',
	'11' => 'Cascade',
	'12' => 'Glacis',
	'13' => 'Grand‌’ Anse Mahe',
	'14' => 'Grand‌’ Anse Praslin',
	'15' => 'La Digue',
	'16' => 'La Riviere Anglaise',
	'17' => 'Mont Buxton',
	'18' => 'Mont Fleuri',
	'19' => 'Plaisance',
	'20' => 'Pointe La Rue',
	'21' => 'Port Glaud',
	'22' => 'Saint Louis',
	'23' => 'Takamaka'
);

$this->sierra_leone_regions = array(
	'SL-W'	 => 'Western Area (Freetown)',
	'SL-E'	 => 'Eastern',
	'SL-N'	 => 'Northern',
	'SL-S'	 => 'Southern'
);

$this->singapore_regions = array(
	'SG-01'	 => 'Central Singapore',
	'SG-02'	 => 'North East',
	'SG-03'	 => 'North West',
	'SG-04'	 => 'South East',
	'SG-05'	 => 'South West'
);

$this->slovakia_regions = array(
	'BC' => 'Banskobystricky kraj',
	'BL' => 'Bratislavsky kraj',
	'KI' => 'Kosicky kraj',
	'NI' => 'Nitriansky kraj',
	'PV' => 'Presovsky kraj',
	'TC' => 'Trenciansky kraj',
	'TA' => 'Trnavsky kraj',
	'ZI' => 'Zilinsky kraj'
);

$this->slovenia_regions = array(
	'002'	 => 'Beltinci',
	'148'	 => 'Benedikt',
	'149'	 => 'Bistrica ob Sotli',
	'003'	 => 'Bled',
	'150'	 => 'Bloke',
	'004'	 => 'Bohinj',
	'005'	 => 'Borovnica',
	'006'	 => 'Bovec',
	'151'	 => 'Braslovce',
	'007'	 => 'Brda',
	'009'	 => 'Brezice',
	'008'	 => 'Brezovica',
	'152'	 => 'Cankova',
	'011'	 => 'Celje',
	'012'	 => 'Cerklje na Gorenjskem',
	'013'	 => 'Cerknica',
	'014'	 => 'Cerkno',
	'153'	 => 'Cerkvenjak',
	'015'	 => 'Crensovci',
	'016'	 => 'Crna na Koroskem',
	'017'	 => 'Crnomelj',
	'018'	 => 'Destrnik',
	'019'	 => 'Divaca',
	'154'	 => 'Dobje',
	'020'	 => 'Dobrepolje',
	'155'	 => 'Dobrna',
	'021'	 => 'Dobrova-Horjul-Polhov Gradec',
	'156'	 => 'Dobrovnik',
	'022'	 => 'Dol pri Ljublijani',
	'157'	 => 'Dolenjske Toplice',
	'023'	 => 'Domzale',
	'024'	 => 'Dornava',
	'025'	 => 'Dravograd',
	'026'	 => 'Duplek',
	'027'	 => 'Gorenja vas-Poljane',
	'028'	 => 'Gorisnica',
	'029'	 => 'Gornja Radgona',
	'030'	 => 'Gornji Grad',
	'031'	 => 'Gornji Petrovci',
	'158'	 => 'Grad',
	'032'	 => 'Grosuplje',
	'159'	 => 'Hajdina',
	'160'	 => 'Hoce-Slivnica',
	'161'	 => 'Hodos',
	'162'	 => 'Horjul',
	'034'	 => 'Hrastnik',
	'035'	 => 'Hrpelje-Kozina',
	'036'	 => 'Idrija',
	'037'	 => 'Ig',
	'038'	 => 'Illirska Bistrica',
	'039'	 => 'Ivancna Gorica',
	'040'	 => 'Izola/Isola',
	'041'	 => 'Jesenice',
	'163'	 => 'Jezersko',
	'042'	 => 'Jursinci',
	'043'	 => 'Kamnik',
	'044'	 => 'Kanal',
	'045'	 => 'Kidricevo',
	'046'	 => 'Kobarid',
	'047'	 => 'Kobilje',
	'048'	 => 'Kocevje',
	'049'	 => 'Komen',
	'164'	 => 'Komenda',
	'050'	 => 'Koper/Capodistria',
	'165'	 => 'Kostel',
	'051'	 => 'Kozje',
	'052'	 => 'Kranj',
	'053'	 => 'Kranjska Gora',
	'166'	 => 'Krizevci',
	'054'	 => 'Krsko',
	'055'	 => 'Kungota',
	'056'	 => 'Kuzma',
	'057'	 => 'Lasko',
	'058'	 => 'Lenart',
	'059'	 => 'Lendava',
	'060'	 => 'Litija',
	'061'	 => 'Ljubljana',
	'062'	 => 'Ljubno',
	'063'	 => 'Ljutomer',
	'064'	 => 'Logatec',
	'065'	 => 'Loska Dolina',
	'066'	 => 'Loski Potok',
	'167'	 => 'Lovrenc na Pohorju',
	'067'	 => 'Luce',
	'068'	 => 'Lukovica',
	'069'	 => 'Majsperk',
	'070'	 => 'Maribor',
	'168'	 => 'Markovci',
	'071'	 => 'Medvode',
	'072'	 => 'Menges',
	'073'	 => 'Metlika',
	'074'	 => 'Mezica',
	'169'	 => 'Miklavz na Dravskem Polju',
	'075'	 => 'Miren-Kostanjevica',
	'170'	 => 'Mirna Pec',
	'076'	 => 'Mislinja',
	'077'	 => 'Moravce',
	'078'	 => 'Moravske Toplice',
	'079'	 => 'Mozirje',
	'080'	 => 'Murska Sobota',
	'081'	 => 'Muta',
	'082'	 => 'Naklo',
	'083'	 => 'Nazarje',
	'084'	 => 'Nova Gorica',
	'085'	 => 'Novo Mesto',
	'086'	 => 'Odranci',
	'171'	 => 'Oplotnica',
	'087'	 => 'Ormoz',
	'088'	 => 'Osilnica',
	'089'	 => 'Pesnica',
	'090'	 => 'Piran',
	'090'	 => 'Pirano',
	'091'	 => 'Pivka',
	'092'	 => 'Podcetrtek',
	'172'	 => 'Podlehnik',
	'093'	 => 'Podvelka',
	'173'	 => 'Polzela',
	'094'	 => 'Postojna',
	'174'	 => 'Prebold',
	'095'	 => 'Preddvor',
	'175'	 => 'Prevalje',
	'096'	 => 'Ptuj',
	'097'	 => 'Puconci',
	'098'	 => 'Race-Fram',
	'099'	 => 'Radece',
	'100'	 => 'Radenci',
	'101'	 => 'Radlje ob Dravi',
	'102'	 => 'Radovljica',
	'103'	 => 'Ravne na Koroskem',
	'176'	 => 'Razkrizje',
	'104'	 => 'Ribnica',
	'177'	 => 'Ribnica na Pohorju',
	'106'	 => 'Rogaska Slatina',
	'105'	 => 'Rogasovci',
	'107'	 => 'Rogatec',
	'108'	 => 'Ruse',
	'033'	 => 'Salovci',
	'178'	 => 'Selnica ob Dravi',
	'109'	 => 'Semic',
	'183'	 => 'Sempeter-Vrtojba',
	'117'	 => 'Sencur',
	'118'	 => 'Sentilj',
	'119'	 => 'Sentjernej',
	'120'	 => 'Sentjur pri Celju',
	'110'	 => 'Sevnica',
	'111'	 => 'Sezana',
	'121'	 => 'Skocjan',
	'122'	 => 'Skofja Loka',
	'123'	 => 'Skofljica',
	'112'	 => 'Slovenj Gradec',
	'113'	 => 'Slovenska Bistrica',
	'114'	 => 'Slovenske Konjice',
	'124'	 => 'Smarje pri Jelsah',
	'125'	 => 'Smartno ob Paki',
	'194'	 => 'Smartno pri Litiji',
	'179'	 => 'Sodrazica',
	'180'	 => 'Solcava',
	'126'	 => 'Sostanj',
	'115'	 => 'Starse',
	'127'	 => 'Store',
	'181'	 => 'Sveta Ana',
	'182'	 => 'Sveti Andraz v Slovenskih Goricah',
	'116'	 => 'Sveti Jurij',
	'184'	 => 'Tabor',
	'010'	 => 'Tisina',
	'128'	 => 'Tolmin',
	'129'	 => 'Trbovlje',
	'130'	 => 'Trebnje',
	'185'	 => 'Trnovska Vas',
	'131'	 => 'Trzic',
	'186'	 => 'Trzin',
	'132'	 => 'Turnisce',
	'133'	 => 'Velenje',
	'187'	 => 'Velika Polana',
	'134'	 => 'Velike Lasce',
	'188'	 => 'Verzej',
	'135'	 => 'Videm',
	'136'	 => 'Vipava',
	'137'	 => 'Vitanje',
	'138'	 => 'Vodice',
	'139'	 => 'Vojnik',
	'189'	 => 'Vransko',
	'140'	 => 'Vrhnika',
	'141'	 => 'Vuzenica',
	'142'	 => 'Zagorje ob Savi',
	'190'	 => 'Zalec',
	'143'	 => 'Zavrc',
	'146'	 => 'Zelezniki',
	'191'	 => 'Zetale',
	'147'	 => 'Ziri',
	'192'	 => 'Zirovnica',
	'144'	 => 'Zrece',
	'193'	 => 'Zuzemberk'
);

$this->solomon_islands_regions = array(
	'SB-CT'	 => 'Capital Territory (Honiara)',
	'SB-CE'	 => 'Central',
	'SB-CH'	 => 'Choiseul',
	'SB-GU'	 => 'Guadalcanal',
	'SB-IS'	 => 'Isabel',
	'SB-MK'	 => 'Makira',
	'SB-ML'	 => 'Malaita',
	'SB-RB'	 => 'Rennell and Bellona',
	'SB-TE'	 => 'Temotu',
	'SB-WE'	 => 'Western'
);

$this->somalia_regions = array(
	'SO-AW'	 => 'Awdal',
	'SO-BK'	 => 'Bakool',
	'SO-BN'	 => 'Banaadir',
	'SO-BR'	 => 'Bari',
	'SO-BY'	 => 'Bay',
	'SO-GA'	 => 'Galguduud',
	'SO-GE'	 => 'Gedo',
	'SO-HI'	 => 'Hiiraan',
	'SO-JD'	 => 'Jubbada Dhexe',
	'SO-JH'	 => 'Jubbada Hoose',
	'SO-MU'	 => 'Mudug',
	'SO-NU'	 => 'Nugaal',
	'SO-SA'	 => 'Sanaag',
	'SO-SD'	 => 'Shabeellaha Dhexe',
	'SO-SH'	 => 'Shabeellaha Hoose',
	'SO-SO'	 => 'Sool',
	'SO-TO'	 => 'Togdheer',
	'SO-WO'	 => 'Woqooyi Galbeed'
);

$this->south_africa_regions = array(
	'EC'	 => 'Eastern Cape',
	'FS'	 => 'Free State',
	'GT'	 => 'Gauteng',
	'KZN'	 => 'KwaZulu-Natal',
	'LP'	 => 'Limpopo',
	'MP'	 => 'Mpumalanga',
	'NC'	 => 'Northern Cape',
	'NW'	 => 'North West',
	'WC'	 => 'Western Cape'
);

$this->spain_regions = array(
	'CA' => 'A Coruña',
	'AL' => 'Álava',
	'AB' => 'Albacete',
	'AC' => 'Alicante',
	'AM' => 'Almería',
	'AS' => 'Asturias',
	'AV' => 'Ávila',
	'BJ' => 'Badajoz',
	'IB' => 'Baleares',
	'BA' => 'Barcelona',
	'BU' => 'Burgos',
	'CC' => 'Cáceres',
	'CZ' => 'Cádiz',
	'CT' => 'Cantabria',
	'CL' => 'Castellón',
	'CE' => 'Ceuta',
	'CR' => 'Ciudad Real',
	'CD' => 'Córdoba',
	'CU' => 'Cuenca',
	'GI' => 'Girona',
	'GD' => 'Granada',
	'GJ' => 'Guadalajara',
	'GP' => 'Guipúzcoa',
	'HL' => 'Huelva',
	'HS' => 'Huesca',
	'JN' => 'Jaén',
	'RJ' => 'La Rioja',
	'PM' => 'Las Palmas',
	'LE' => 'León',
	'LL' => 'Lleida',
	'LG' => 'Lugo',
	'MD' => 'Madrid',
	'MA' => 'Málaga',
	'ML' => 'Melilla',
	'MU' => 'Murcia',
	'NV' => 'Navarra',
	'OU' => 'Ourense',
	'PL' => 'Palencia',
	'PO' => 'Pontevedra',
	'SL' => 'Salamanca',
	'SC' => 'Santa Cruz de Tenerife',
	'SG' => 'Segovia',
	'SV' => 'Sevilla',
	'SO' => 'Soria',
	'TA' => 'Tarragona',
	'TE' => 'Teruel',
	'TO' => 'Toledo',
	'VC' => 'Valencia',
	'VD' => 'Valladolid',
	'VZ' => 'Vizcaya',
	'ZM' => 'Zamora',
	'ZR' => 'Zaragoza'
);

$this->sri_lanka_regions = array(
	'1'	 => 'Basnahira Palata',
	'2'	 => 'Central Province',
	'3'	 => 'Dakunu Palata',
	'5'	 => 'Eastern Province',
	'2'	 => 'Madhyama Palata',
	'5'	 => 'Negenahira Palata',
	'7'	 => 'North Central Province',
	'6'	 => 'North Western Province',
	'4'	 => 'Northern Province',
	'9'	 => 'Sabaragamuwa Palata',
	'3'	 => 'Southern Province',
	'4'	 => 'Uturu Palata',
	'7'	 => 'Uturumeda Palata',
	'8'	 => 'Uva Palata',
	'6'	 => 'Wayamba Palata',
	'1'	 => 'Western Province',
	'11' => 'Colombo',
	'12' => 'Gampaha',
	'13' => 'Kalutara',
	'21' => 'Kandy',
	'22' => 'Matale',
	'23' => 'Nuwara Eliya',
	'31' => 'Galle',
	'33' => 'Hambantota',
	'32' => 'Matara',
	'41' => 'Jaffna',
	'42' => 'Kilinochchi',
	'43' => 'Mannar',
	'45' => 'Mullaittivu',
	'44' => 'Vavuniya',
	'52' => 'Ampara',
	'51' => 'Batticaloa',
	'53' => 'Trincomalee',
	'61' => 'Kurunegala',
	'62' => 'Puttalam',
	'71' => 'Anuradhapura',
	'72' => 'Polonnaruwa',
	'81' => 'Badulla',
	'82' => 'Monaragala',
	'92' => 'Kegalla',
	'91' => 'Ratnapura'
);

$this->sudan_regions = array(
	'SD-23'	 => 'Ā\'ٰālī an Nīl',
	'SD-26'	 => 'Al Baḩr al Aḩmar',
	'SD-18'	 => 'Al Buḩayrāt',
	'SD-07'	 => 'Al Jazīrah',
	'SD-03'	 => 'Al Kharţūm',
	'SD-06'	 => 'Al Qaḑārif',
	'SD-22'	 => 'Al Waḩdah',
	'SD-04'	 => 'An Nīl',
	'SD-08'	 => 'An Nīl al Abyaḑ',
	'SD-24'	 => 'An Nīl al Azraq',
	'SD-01'	 => 'Ash Shamālīyah',
	'SD-17'	 => 'Baḩr al Jabal',
	'SD-16'	 => 'Gharb al Istiwā‌’īyah',
	'SD-14'	 => 'Gharb Baḩr al Ghazāl',
	'SD-12'	 => 'Gharb Dārfūr',
	'SD-11'	 => 'Janūb Dārfūr',
	'SD-13'	 => 'Janūb Kurdufān',
	'SD-20'	 => 'Jūnqalī',
	'SD-05'	 => 'Kassalā',
	'SD-15'	 => 'Shamāl Baḩr al Ghazāl',
	'SD-02'	 => 'Shamāl Dārfūr',
	'SD-09'	 => 'Shamāl Kurdufān',
	'SD-19'	 => 'Sharq al Istiwā‌’īyah',
	'SD-25'	 => 'Sinnār',
	'SD-21'	 => 'Wārāb'
);

$this->suriname_regions = array(
	'BR' => 'Brokopondo',
	'CM' => 'Commonwijne',
	'CR' => 'Coronie',
	'MA' => 'Marowijne',
	'NI' => 'Nickerie',
	'PR' => 'Para',
	'PM' => 'Paramaribo',
	'SA' => 'Saramacca',
	'SI' => 'Sipaliwini',
	'WA' => 'Wanica'
);

$this->swaziland_regions = array(
	'SZ-HH'	 => 'Hhohho',
	'SZ-LU'	 => 'Lubombo',
	'SZ-MA'	 => 'Manzini',
	'SZ-SH'	 => 'Shiselweni'
);

$this->sweden_regions = array(
	'BL' => 'Blekinge',
	'DA' => 'Dalarna',
	'GA' => 'Gavleborg',
	'GO' => 'Gotland',
	'HA' => 'Halland',
	'JA' => 'Jamtland',
	'JO' => 'Jonkoping',
	'KA' => 'Kalmar',
	'KR' => 'Kronoberg',
	'NO' => 'Norrbotten',
	'OR' => 'Orebro',
	'OS' => 'Ostergotland',
	'SK' => 'Skane',
	'SO' => 'Sodermanland',
	'ST' => 'Stockholm',
	'UP' => 'Uppsala',
	'VL' => 'Varmland',
	'VB' => 'Vasterbotten',
	'VN' => 'Vasternorrland',
	'VM' => 'Vastmanland',
	'VG' => 'Vastra Gotaland'
);

$this->switzerland_regions = array(
	'AG' => 'Aargau',
	'AI' => 'Appenzell Innerrhoden',
	'AR' => 'Appenzell Ausserrhoden',
	'BS' => 'Basel-Stadt',
	'BL' => 'Basel-Landschaft',
	'BE' => 'Bern',
	'FR' => 'Fribourg',
	'GE' => 'Geneva',
	'GL' => 'Glarus',
	'GR' => 'Graubünden',
	'JU' => 'Jura',
	'LU' => 'Luzern',
	'NE' => 'Neuchâtel',
	'NW' => 'Nidwalden',
	'OW' => 'Obwalden',
	'SH' => 'Schaffhausen',
	'SZ' => 'Schwyz',
	'SO' => 'Solothurn',
	'SG' => 'St. Gallen',
	'TG' => 'Thurgau',
	'TI' => 'Ticino',
	'UR' => 'Uri',
	'VS' => 'Valais',
	'VD' => 'Vaud',
	'ZG' => 'Zug',
	'ZH' => 'Zürich'
);

$this->syria_regions = array(
	'SY-HA'	 => 'Al Hasakah',
	'SY-LA'	 => 'Al Lādhiqīyah',
	'SY-QU'	 => 'Al Qunayţirah',
	'SY-RA'	 => 'Ar Raqqah',
	'SY-SU'	 => 'As Suwaydā‌’',
	'SY-DR'	 => 'Darٰā',
	'SY-DY'	 => 'Dayr az Zawr',
	'SY-DI'	 => 'Dimashq',
	'SY-HL'	 => 'Halab',
	'SY-HM'	 => 'Hamāh',
	'SY-HI'	 => 'Himş',
	'SY-ID'	 => 'Idlib',
	'SY-RD'	 => 'Rīf Dimashq',
	'SY-TA'	 => 'Ţarţūs'
);

$this->taiwan_regions = array(
	'01' => 'ChangHua County',
	'02' => 'ChiaYi City',
	'03' => 'ChiaYi County',
	'04' => 'HsinChu City',
	'05' => 'HsinChu County',
	'06' => 'HuaLien County',
	'07' => 'KaoHsiung City',
	'08' => 'KaoHsiung County',
	'09' => 'KeeLung City ',
	'10' => 'KinMen County',
	'11' => 'LienChiang County',
	'12' => 'MiaoLi County',
	'13' => 'NanHai',
	'14' => 'NanTou County',
	'15' => 'PengHu County',
	'16' => 'PingTung County',
	'17' => 'TaiChung City',
	'18' => 'TaiChung County',
	'19' => 'TaiNan City',
	'20' => 'TaiNan County',
	'21' => 'Taipei City',
	'22' => 'Taipei County',
	'23' => 'TaiTung County',
	'24' => 'TaoYuan County',
	'25' => 'Yilan County',
	'26' => 'YunLin County',
	'27' => '南投縣',
	'28' => '南海諸島',
	'29' => '嘉義市',
	'30' => '嘉義縣',
	'31' => '基隆市',
	'32' => '宜蘭縣',
	'33' => '屏東縣',
	'34' => '彰化縣',
	'35' => '新竹市',
	'36' => '新竹縣',
	'37' => '桃園縣',
	'38' => '澎湖縣',
	'39' => '臺中市',
	'40' => '臺中縣',
	'41' => '臺北市',
	'42' => '臺北縣',
	'43' => '臺南市',
	'44' => '臺南縣',
	'45' => '臺東縣',
	'46' => '花蓮縣',
	'47' => '苗栗縣',
	'48' => '連江縣',
	'49' => '金門縣',
	'50' => '雲林縣',
	'51' => '高雄市',
	'52' => '高雄縣'
);

$this->tajikistan_regions = array(
	'TJ-GB'	 => 'Gorno-Badakhshan',
	'TJ-KT'	 => 'Khatlon',
	'TJ-SU'	 => 'Sughd'
);

$this->tanzania_regions = array(
	'01' => 'Arusha',
	'19' => 'Coast',
	'02' => 'Dar es Salaam',
	'03' => 'Dodoma',
	'04' => 'Iringa',
	'05' => 'Kagera',
	'06' => 'Kaskazini Pemba',
	'07' => 'Kaskazini Unguja',
	'08' => 'Kigoma',
	'09' => 'Kilimanjaro',
	'10' => 'Kusini Pemba',
	'11' => 'Kusini Unguja',
	'12' => 'Lindi',
	'26' => 'Manyara',
	'13' => 'Mara',
	'14' => 'Mbeya',
	'15' => 'Mjini Mgharibi',
	'16' => 'Morogoro',
	'17' => 'Mtwara',
	'18' => 'Mwanza',
	'06' => 'Pemba North',
	'10' => 'Pemba South',
	'19' => 'Pwani',
	'20' => 'Rukwa',
	'21' => 'Ruvuma',
	'22' => 'Shinyanga',
	'23' => 'Singida',
	'24' => 'Tabora',
	'25' => 'Tanga',
	'07' => 'Zanzibar North',
	'11' => 'Zanzibar South',
	'15' => 'Zanzibar West'
);

$this->thailand_regions = array(
	'1'	 => 'กรุงเทพมหานคร',
	'2'	 => 'นนทบุรี',
	'3'	 => 'สมุทรปราการ',
	'4'	 => 'ปทุมธานี',
	'5'	 => 'ภูเก็ต',
	'6'	 => 'สมุทรสาคร',
	'7'	 => 'สมุทรสงคราม',
	'8'	 => 'นครปฐม',
	'9'	 => 'ปัตตานี',
	'10' => 'พระนครศรีอยุธยา',
	'11' => 'อ่างทอง',
	'12' => 'ชลบุรี',
	'13' => 'สิงห์บุรี',
	'14' => 'สงขลา',
	'15' => 'มหาสารคาม',
	'16' => 'สระบุรี',
	'17' => 'สุรินทร์',
	'18' => 'ระยอง',
	'19' => 'ศรีสะเกษ',
	'20' => 'ขอนแก่น',
	'21' => 'ราชบุรี',
	'22' => 'นราธิวาส',
	'23' => 'ร้อยเอ็ด',
	'24' => 'สุพรรณบุรี',
	'25' => 'นครศรีธรรมราช',
	'26' => 'บุรีรัมย์',
	'27' => 'พัทลุง',
	'28' => 'กาฬสินธุ์',
	'29' => 'ชัยนาท',
	'30' => 'อุดรธานี',
	'31' => 'ยโสธร',
	'32' => 'หนองบัวลำภู',
	'33' => 'นครพนม',
	'34' => 'นครราชสีมา',
	'35' => 'ตรัง',
	'36' => 'ฉะเชิงเทรา',
	'37' => 'หนองคาย',
	'38' => 'พิจิตร',
	'39' => 'ลพบุรี',
	'40' => 'นครนายก',
	'41' => 'อำนาจเจริญ',
	'42' => 'สกลนคร',
	'43' => 'สตูล',
	'44' => 'อุบลราชธานี',
	'45' => 'นครสวรรค์',
	'46' => 'เชียงราย',
	'47' => 'ยะลา',
	'48' => 'ปราจีนบุรี',
	'49' => 'สุโขทัย',
	'50' => 'ลำพูน',
	'51' => 'ชัยภูมิ',
	'52' => 'กระบี่',
	'53' => 'กำแพงเพชร',
	'54' => 'เชียงใหม่',
	'55' => 'ชุมพร',
	'56' => 'จันทบุรี',
	'57' => 'เพชรบูรณ์',
	'58' => 'ตราด',
	'59' => 'พิษณุโลก',
	'60' => 'ประจวบคีรีขันธ์',
	'61' => 'มุกดาหาร',
	'62' => 'พะเยา',
	'63' => 'สุราษฎร์ธานี',
	'64' => 'สระแก้ว',
	'65' => 'เพชรบุรี',
	'66' => 'แพร่',
	'67' => 'ลำปาง',
	'68' => 'อุตรดิตถ์',
	'69' => 'พังงา',
	'70' => 'ระนอง',
	'71' => 'เลย',
	'72' => 'อุทัยธานี',
	'73' => 'กาญจนบุรี',
	'74' => 'น่าน',
	'75' => 'ตาก',
	'76' => 'แม่ฮ่องสอน'
);

$this->togo_regions = array(
	'TG-C'	 => 'Centre',
	'TG-K'	 => 'Kara',
	'TG-M'	 => 'Maritime (Région)',
	'TG-P'	 => 'Plateaux',
	'TG-S'	 => 'Savannes'
);

$this->tonga_regions = array(
	'TO-01'	 => '‌’Eua',
	'TO-02'	 => 'Ha‌’apai',
	'TO-03'	 => 'Niuas',
	'TO-04'	 => 'Tongatapu',
	'TO-05'	 => 'Vava‌’u'
);

$this->trinidad_tobago_regions = array(
	'TT-CTT' => 'Couva-Tabaquite-Talparo',
	'TT-DMN' => 'Diego Martin',
	'TT-ETO' => 'Eastern Tobago',
	'TT-PED' => 'Penal-Debe',
	'TT-PRT' => 'Princes Town',
	'TT-RCM' => 'Rio Claro-Mayaro',
	'TT-SGE' => 'Sangre Grande',
	'TT-SJL' => 'San Juan-Laventille',
	'TT-SIP' => 'Siparia',
	'TT-TUP' => 'Tunapuna-Piarco',
	'TT-WTO' => 'Western Tobago',
	'TT-ARI' => 'Arima',
	'TT-CHA' => 'Chaguanas',
	'TT-PTF' => 'Point Fortin',
	'TT-POS' => 'Port of Spain',
	'TT-SFO' => 'San Fernando'
);

$this->tunisia_regions = array(
	'31' => 'Beja',
	'13' => 'Ben Arous',
	'23' => 'Bizerte',
	'81' => 'Gabes',
	'71' => 'Gafsa',
	'32' => 'Jendouba',
	'41' => 'Kairouan',
	'42' => 'Kasserine',
	'73' => 'Kebili',
	'14' => 'La Manouba',
	'12' => 'L‌’Ariana',
	'33' => 'Le Kef',
	'53' => 'Mahdia',
	'82' => 'Medenine',
	'52' => 'Monastir',
	'21' => 'Nabeul',
	'61' => 'Sfax',
	'43' => 'Sidi Bouzid',
	'34' => 'Siliana',
	'51' => 'Sousse',
	'83' => 'Tataouine',
	'72' => 'Tozeur',
	'11' => 'Tunis',
	'22' => 'Zaghouan'
);

$this->turkey_regions = array(
	'TR-01'	 => 'Adana',
	'TR-02'	 => 'Adıyaman',
	'TR-03'	 => 'Afyon',
	'TR-04'	 => 'Ağrı',
	'TR-68'	 => 'Aksaray',
	'TR-05'	 => 'Amasya',
	'TR-06'	 => 'Ankara',
	'TR-07'	 => 'Antalya',
	'TR-75'	 => 'Ardahan',
	'TR-08'	 => 'Artvin',
	'TR-09'	 => 'Aydın',
	'TR-10'	 => 'Balıkesir',
	'TR-74'	 => 'Bartın',
	'TR-72'	 => 'Batman',
	'TR-69'	 => 'Bayburt',
	'TR-11'	 => 'Bilecik',
	'TR-12'	 => 'Bingöl',
	'TR-13'	 => 'Bitlis',
	'TR-14'	 => 'Bolu',
	'TR-15'	 => 'Burdur',
	'TR-16'	 => 'Bursa',
	'TR-17'	 => 'Çanakkale',
	'TR-18'	 => 'Çankırı',
	'TR-19'	 => 'Çorum',
	'TR-20'	 => 'Denizli',
	'TR-21'	 => 'Diyarbakır',
	'TR-81'	 => 'Düzce',
	'TR-22'	 => 'Edirne',
	'TR-23'	 => 'Elazığ',
	'TR-24'	 => 'Erzincan',
	'TR-25'	 => 'Erzurum',
	'TR-26'	 => 'Eskişehir',
	'TR-27'	 => 'Gaziantep',
	'TR-28'	 => 'Giresun',
	'TR-29'	 => 'Gümüşhane',
	'TR-30'	 => 'Hakkâri',
	'TR-31'	 => 'Hatay',
	'TR-76'	 => 'Iğdır',
	'TR-32'	 => 'Isparta',
	'TR-33'	 => 'İçel',
	'TR-34'	 => 'İstanbul',
	'TR-35'	 => 'İzmir',
	'TR-46'	 => 'Kahramanmaraş',
	'TR-78'	 => 'Karabük',
	'TR-70'	 => 'Karaman',
	'TR-36'	 => 'Kars',
	'TR-37'	 => 'Kastamonu',
	'TR-38'	 => 'Kayseri',
	'TR-71'	 => 'Kırıkkale',
	'TR-39'	 => 'Kırklareli',
	'TR-40'	 => 'Kırşehir',
	'TR-79'	 => 'Kilis',
	'TR-41'	 => 'Kocaeli',
	'TR-42'	 => 'Konya',
	'TR-43'	 => 'Kütahya',
	'TR-44'	 => 'Malatya',
	'TR-45'	 => 'Manisa',
	'TR-47'	 => 'Mardin',
	'TR-48'	 => 'Muğla',
	'TR-49'	 => 'Muş',
	'TR-50'	 => 'Nevşehir',
	'TR-51'	 => 'Niğde',
	'TR-52'	 => 'Ordu',
	'TR-80'	 => 'Osmaniye',
	'TR-53'	 => 'Rize',
	'TR-54'	 => 'Sakarya',
	'TR-55'	 => 'Samsun',
	'TR-56'	 => 'Siirt',
	'TR-57'	 => 'Sinop',
	'TR-58'	 => 'Sivas',
	'TR-63'	 => 'Şanlıurfa',
	'TR-73'	 => 'Şırnak',
	'TR-59'	 => 'Tekirdağ',
	'TR-60'	 => 'Tokat',
	'TR-61'	 => 'Trabzon',
	'TR-62'	 => 'Tunceli',
	'TR-64'	 => 'Uşak',
	'TR-65'	 => 'Van',
	'TR-77'	 => 'Yalova',
	'TR-66'	 => 'Yozgat',
	'TR-67'	 => 'Zonguldak'
);

$this->turkmenistan_regions = array(
	'TM-A'	 => 'Ahal',
	'TM-B'	 => 'Balkan',
	'TM-D'	 => 'Daşoguz',
	'TM-L'	 => 'Lebap',
	'TM-M'	 => 'Mary',
	'TM-S'	 => 'Aşgabat'
);

$this->tuvalu_regions = array(
	'TV-FUN' => 'Funafuti',
	'TV-NMG' => 'Nanumanga',
	'TV-NMA' => 'Nanumea',
	'TV-NIT' => 'Niutao',
	'TV-NUI' => 'Nui',
	'TV-NKF' => 'Nukufetau',
	'TV-NKL' => 'Nukulaelae',
	'TV-VAI' => 'Vaitupu'
);

$this->uganda_regions = array(
	'UG-317' => 'Abim',
	'UG-301' => 'Adjumani',
	'UG-314' => 'Amolatar',
	'UG-216' => 'Amuria',
	'UG-319' => 'Amuru',
	'UG-302' => 'Apac',
	'UG-303' => 'Arua',
	'UG-217' => 'Budaka',
	'UG-223' => 'Bududa',
	'UG-201' => 'Bugiri',
	'UG-224' => 'Bukedea',
	'UG-218' => 'Bukwa',
	'UG-419' => 'Buliisa',
	'UG-401' => 'Bundibugyo',
	'UG-402' => 'Bushenyi',
	'UG-202' => 'Busia',
	'UG-219' => 'Butaleja',
	'UG-318' => 'Dokolo',
	'UG-304' => 'Gulu',
	'UG-403' => 'Hoima',
	'UG-416' => 'Ibanda',
	'UG-203' => 'Iganga',
	'UG-417' => 'Isingiro',
	'UG-204' => 'Jinja',
	'UG-315' => 'Kaabong',
	'UG-404' => 'Kabale',
	'UG-405' => 'Kabarole',
	'UG-213' => 'Kaberamaido',
	'UG-101' => 'Kalangala',
	'UG-220' => 'Kaliro',
	'UG-102' => 'Kampala',
	'UG-205' => 'Kamuli',
	'UG-413' => 'Kamwenge',
	'UG-414' => 'Kanungu',
	'UG-206' => 'Kapchorwa',
	'UG-406' => 'Kasese',
	'UG-207' => 'Katakwi',
	'UG-112' => 'Kayunga',
	'UG-407' => 'Kibaale',
	'UG-103' => 'Kiboga',
	'UG-418' => 'Kiruhura',
	'UG-408' => 'Kisoro',
	'UG-305' => 'Kitgum',
	'UG-316' => 'Koboko',
	'UG-306' => 'Kotido',
	'UG-208' => 'Kumi',
	'UG-415' => 'Kyenjojo',
	'UG-307' => 'Lira',
	'UG-104' => 'Luwero',
	'UG-116' => 'Lyantonde',
	'UG-221' => 'Manafwa',
	'UG-320' => 'Maracha',
	'UG-105' => 'Masaka',
	'UG-409' => 'Masindi',
	'UG-214' => 'Mayuge',
	'UG-209' => 'Mbale',
	'UG-410' => 'Mbarara',
	'UG-114' => 'Mityana',
	'UG-308' => 'Moroto',
	'UG-309' => 'Moyo',
	'UG-106' => 'Mpigi',
	'UG-107' => 'Mubende',
	'UG-108' => 'Mukono',
	'UG-311' => 'Nakapiripirit',
	'UG-115' => 'Nakaseke',
	'UG-109' => 'Nakasongola',
	'UG-222' => 'Namutumba',
	'UG-310' => 'Nebbi',
	'UG-411' => 'Ntungamo',
	'UG-321' => 'Oyam',
	'UG-312' => 'Pader',
	'UG-210' => 'Pallisa',
	'UG-110' => 'Rakai',
	'UG-412' => 'Rukungiri',
	'UG-111' => 'Sembabule',
	'UG-215' => 'Sironko',
	'UG-211' => 'Soroti',
	'UG-212' => 'Tororo',
	'UG-113' => 'Wakiso',
	'UG-313' => 'Yumbe'
);

$this->ukraine_regions = array(
	'VN' => 'Вінницька область',
	'LT' => 'Волинська область',
	'DP' => 'Дніпропетровська область',
	'DN' => 'Донецька область',
	'ZT' => 'Житомирська область',
	'UZ' => 'Закарпатська область',
	'ZP' => 'Запорізька область',
	'IF' => 'Івано-Франківська область',
	'KV' => 'Київська область',
	'KR' => 'Кіровоградська область',
	'LG' => 'Луганська область',
	'LV' => 'Львівська область',
	'MK' => 'Миколаївська область',
	'OD' => 'Одеська область',
	'PL' => 'Полтавська область',
	'RV' => 'Рівненська область',
	'SM' => 'Сумська область',
	'TE' => 'Тернопільська область',
	'KH' => 'Харківська область',
	'KS' => 'Херсонська область',
	'KM' => 'Хмельницька область',
	'CK' => 'Черкаська область',
	'CN' => 'Чернігівська область',
	'CV' => 'Чернівецька область'
);

$this->united_arab_emirates_regions = array(
	'DXB'	 => 'Dubai',
	'SHJ'	 => 'Sharjah',
	'ABU'	 => 'Abu dhabi',
	'UAQ'	 => 'UM Al Quwain',
	'FUJ'	 => 'Fujairah',
	'Ala'	 => 'Al Ain'
);

$this->united_states_minor_outlying_islands_regions = array(
	'UM-81'	 => 'Baker Island',
	'UM-84'	 => 'Howland Island',
	'UM-86'	 => 'Jarvis Island',
	'UM-67'	 => 'Johnston Atoll',
	'UM-89'	 => 'Kingman Reef',
	'UM-71'	 => 'Midway Islands',
	'UM-76'	 => 'Navassa Island',
	'UM-95'	 => 'Palmyra Atoll',
	'UM-79'	 => 'Wake Island'
);

$uruguay_regions = array(
	'AR' => 'Artigas',
	'CA' => 'Canelones',
	'CL' => 'Cerro Largo',
	'CO' => 'Colonia',
	'DU' => 'Durazno',
	'FS' => 'Flores',
	'FD' => 'Florida',
	'LA' => 'Lavalleja',
	'MA' => 'Maldonado',
	'MO' => 'Montevideo',
	'PA' => 'Paysandu',
	'RN' => 'Rio Negro',
	'RV' => 'Rivera',
	'RO' => 'Rocha',
	'SA' => 'Salto',
	'SJ' => 'San Jose',
	'SO' => 'Soriano',
	'TA' => 'Tacuarembo',
	'TT' => 'Treinta y Tres'
);

$this->uzbekistan_regions = array(
	'UZ-TK'	 => 'Toshkent',
	'UZ-AN'	 => 'Andijon',
	'UZ-BU'	 => 'Buxoro',
	'UZ-FA'	 => 'Farg‘ona',
	'UZ-JI'	 => 'Jizzax',
	'UZ-NG'	 => 'Namangan',
	'UZ-NW'	 => 'Navoiy',
	'UZ-QA'	 => 'Qashqadaryo',
	'UZ-SA'	 => 'Samarqand',
	'UZ-SI'	 => 'Sirdaryo',
	'UZ-SU'	 => 'Surxondaryo',
	'UZ-TO'	 => 'Toshkent',
	'UZ-XO'	 => 'Xorazm',
	'UZ-QR'	 => 'Qoraqalpog‘iston Respublikasi'
);

$this->vanuatu_regions = array(
	'VU-MAP' => 'Malampa',
	'VU-PAM' => 'Pénama',
	'VU-SAM' => 'Sanma',
	'VU-SEE' => 'Shéfa',
	'VU-TAE' => 'Taféa',
	'VU-TOB' => 'Torba'
);

$this->venezuela_regions = array(
	'AM' => 'Amazonas',
	'AN' => 'Anzoátegui',
	'AP' => 'Apure',
	'AR' => 'Aragua',
	'BA' => 'Barinas',
	'BO' => 'Bolívar',
	'CA' => 'Carabobo',
	'CO' => 'Cojedes',
	'DA' => 'Delta Amacuro',
	'DF' => 'Dependencias Federales',
	'DC' => 'Distrito Capital',
	'FA' => 'Falcón',
	'GU' => 'Guárico',
	'LA' => 'Lara',
	'ME' => 'Mérida',
	'MI' => 'Miranda',
	'MO' => 'Monagas',
	'NE' => 'Nueva Esparta',
	'PO' => 'Portuguesa',
	'SU' => 'Sucre',
	'TA' => 'Táchira',
	'TR' => 'Trujillo',
	'VA' => 'Vargas',
	'YA' => 'Yaracuy',
	'ZU' => 'Zulia'
);

$this->vietnam_regions = array(
	'AG' => 'An Giang',
	'BV' => 'Ba Ria-Vung Tau',
	'BK' => 'Bac Can',
	'BG' => 'Bac Giang',
	'BL' => 'Bac Lieu',
	'BN' => 'Bac Ninh',
	'BR' => 'Ben Tre',
	'BD' => 'Binh Dinh',
	'BI' => 'Binh Duong',
	'BP' => 'Binh Phuoc',
	'BU' => 'Binh Thuan',
	'CM' => 'Ca Mau',
	'CN' => 'Can Tho',
	'CB' => 'Cao Bang',
	'DA' => 'Da Nang',
	'DC' => 'Dac Lac',
	'DO' => 'Dak Nong',
	'DB' => 'Dien Bien',
	'DN' => 'Dong Nai',
	'DT' => 'Dong Thap',
	'GL' => 'Gia Lai',
	'HG' => 'Ha Giang',
	'HM' => 'Ha Nam',
	'HA' => 'Ha Tay',
	'HT' => 'Ha Tinh',
	'HD' => 'Hai Duong',
	'HP' => 'Haiphong',
	'HN' => 'Ha Noi',
	'HU' => 'Hau Giang',
	'HC' => 'Ho Chi Minh',
	'HO' => 'Hoa Binh',
	'HY' => 'Hung Yen',
	'KH' => 'Khanh Hoa',
	'KG' => 'Kien Giang',
	'KT' => 'Kon Tum',
	'LI' => 'Lai Chau',
	'LD' => 'Lam Dong',
	'LS' => 'Lang Son',
	'LO' => 'Lao Cai',
	'LA' => 'Long An',
	'ND' => 'Nam Dinh',
	'NA' => 'Nghe An',
	'NB' => 'Ninh Binh',
	'NT' => 'Ninh Thuan',
	'PT' => 'Phu Tho',
	'PY' => 'Phu Yen',
	'QB' => 'Quang Binh',
	'QM' => 'Quang Nam',
	'QG' => 'Quang Ngai',
	'QN' => 'Quang Ninh',
	'QT' => 'Quang Tri',
	'ST' => 'Soc Trang',
	'SL' => 'Son La',
	'TN' => 'Tay Ninh',
	'TB' => 'Thai Binh',
	'TY' => 'Thai Nguyen',
	'TH' => 'Thanh Hoa',
	'TT' => 'Thua Thien-Hue',
	'TG' => 'Tien Giang',
	'TV' => 'Tra Vinh',
	'TQ' => 'Tuyen Quang',
	'VL' => 'Vinh Long',
	'VC' => 'Vinh Phuc',
	'YB' => 'Yen Bai'
);

$this->yemen_regions = array(
	'YE-SA'	 => 'Şan‘ā‌’ [city]',
	'YE-AB'	 => 'Abyān',
	'YE-AD'	 => '‌’Adan',
	'YE-DA'	 => 'Aḑ Ḑāli‌’',
	'YE-BA'	 => 'Al Bayḑā‌’',
	'YE-HU'	 => 'Al Ḩudaydah',
	'YE-JA'	 => 'Al Jawf',
	'YE-MR'	 => 'Al Mahrah',
	'YE-MW'	 => 'Al Maḩwīt',
	'YE-AM'	 => '‌’Amrān',
	'YE-DH'	 => 'Dhamār',
	'YE-HD'	 => 'Ḩaḑramawt',
	'YE-HJ'	 => 'Ḩajjah',
	'YE-IB'	 => 'Ibb',
	'YE-LA'	 => 'Laḩij',
	'YE-MA'	 => 'Ma‌’rib',
	'YE-RA'	 => 'Raymah',
	'YE-SD'	 => 'Şā‘dah',
	'YE-SN'	 => 'Şan‘ā‌’',
	'YE-SH'	 => 'Shabwah',
	'YE-TA'	 => 'Tā‘izz'
);

$this->zambia_regions = array(
	'ZM-02'	 => 'Central',
	'ZM-08'	 => 'Copperbelt',
	'ZM-03'	 => 'Eastern',
	'ZM-04'	 => 'Luapula',
	'ZM-09'	 => 'Lusaka',
	'ZM-05'	 => 'Northern',
	'ZM-06'	 => 'NorthWestern',
	'ZM-07'	 => 'Southern',
	'ZM-01'	 => 'Western'
);

$this->zimbabwe_regions = array(
	'BW'	 => 'Bulawayo',
	'HR'	 => 'Harare',
	'MC'	 => 'Manicaland',
	'MSC'	 => 'Mashonaland Central',
	'MSE'	 => 'Mashonaland East',
	'MSW'	 => 'Mashonaland West',
	'MV'	 => 'Masvingo',
	'MBN'	 => 'Matabeleland North',
	'MBS'	 => 'Matabeleland South',
	'ML'	 => 'Midlands'
);


//European Union Member countries in ISO 3166-1 alpha-2. Used for shipping and tax calculations
$this->eu_countries = array(
	'AT',
	'BE',
	'BG',
	'CY',
	'CZ',
	'DK',
	'EE',
	'FI',
	'FR',
	'DE',
	'GB',
	'GR',
	'HU',
	'IE',
	'IT',
	'LV',
	'LT',
	'LU',
	'MT',
	'NL',
	'PL',
	'PT',
	'RO',
	'SK',
	'SI',
	'ES',
	'SE'
);

//currency list - http://www.xe.com/symbols.php
//last perameter is symbol which is unicode hex: http://www.mikezilla.com/exp0012.html
$this->currencies = array(
	'ALL'		 => array( 'Albania, Leke', '4c, 65, 6b' ),
	'AFN'		 => array( 'Afghanistan, Afghanis', '60b' ),
	'ARS'		 => array( 'Argentina, Pesos', '24' ),
	'AWG'		 => array( 'Aruba, Guilders (also called Florins)', '192' ),
	'AUD'		 => array( 'Australia, Dollars', '24' ),
	'AZN'		 => array( 'Azerbaijan, New Manats', '43c, 430, 43d' ),
	'BHD'		 => array( 'Bahrain, Dinars', '2e, 62f, 2e, 628' ),
	'BSD'		 => array( 'Bahamas, Dollars', '24' ),
	'BBD'		 => array( 'Barbados, Dollars', '24' ),
	'BYR'		 => array( 'Belarus, Rubles', '70, 2e' ),
	'BZD'		 => array( 'Belize, Dollars', '42, 5a, 24' ),
	'BMD'		 => array( 'Bermuda, Dollars', '24' ),
	'BOB'		 => array( 'Bolivia, Bolivianos', '24, 62' ),
	'BAM'		 => array( 'Bosnia and Herzegovina, Convertible Marka', '4b, 4d' ),
	'BWP'		 => array( 'Botswana, Pulas', '50' ),
	'BGN'		 => array( 'Bulgaria, Leva', '43b, 432' ),
	'BRL'		 => array( 'Brazil, Reais', '52, 24' ),
	'BND'		 => array( 'Brunei Darussalam, Dollars', '24' ),
	'KHR'		 => array( 'Cambodia, Riels', '17db' ),
	'CAD'		 => array( 'Canada, Dollars', '24' ),
	'KYD'		 => array( 'Cayman Islands, Dollars', '24' ),
	'CLP'		 => array( 'Chile, Pesos', '24' ),
	'CNY'		 => array( 'China, Yuan Renminbi', 'a5' ),
	'COP'		 => array( 'Colombia, Pesos', '24' ),
	'CRC'		 => array( 'Costa Rica, Colon', '20a1' ),
	'HRK'		 => array( 'Croatia, Kuna', '6b, 6e' ),
	'CUP'		 => array( 'Cuba, Pesos', '20b1' ),
	'CZK'		 => array( 'Czech Republic, Koruny', '4b, 10d' ),
	'DKK'		 => array( 'Denmark, Kroner', '6b, 72' ),
	'DOP'		 => array( 'Dominican Republic, Pesos', '52, 44, 24' ),
	'XCD'		 => array( 'East Caribbean, Dollars', '24' ),
	'EGP'		 => array( 'Egypt, Pounds', '45, 47, 50' ),
	'SVC'		 => array( 'El Salvador, Colones', '24' ),
	'EEK'		 => array( 'Estonia, Krooni', '6b, 72' ),
	'EUR'		 => array( 'Euro', '20ac' ),
	'FKP'		 => array( 'Falkland Islands, Pounds', 'a3' ),
	'FJD'		 => array( 'Fiji, Dollars', '24' ),
	'GEL'		 => array( 'Georgia, Lari', '6c, 61, 72, 69' ),
	'GHC'		 => array( 'Ghana, Cedis', 'a2' ),
	'GIP'		 => array( 'Gibraltar, Pounds', 'a3' ),
	'GTQ'		 => array( 'Guatemala, Quetzales', '51' ),
	'GGP'		 => array( 'Guernsey, Pounds', 'a3' ),
	'GYD'		 => array( 'Guyana, Dollars', '24' ),
	'HNL'		 => array( 'Honduras, Lempiras', '4c' ),
	'HKD'		 => array( 'Hong Kong, Dollars', '24' ),
	'HUF'		 => array( 'Hungary, Forint', '46, 74' ),
	'ISK'		 => array( 'Iceland, Kronur', '6b, 72' ),
	'INR'		 => array( 'India, Rupees', '20a8' ),
	'IDR'		 => array( 'Indonesia, Rupiahs', '52, 70' ),
	'IRR'		 => array( 'Iran, Rials', 'fdfc' ),
	'IMP'		 => array( 'Isle of Man, Pounds', 'a3' ),
	'ILS'		 => array( 'Israel, New Shekels', '20aa' ),
	'JMD'		 => array( 'Jamaica, Dollars', '4a, 24' ),
	'JPY'		 => array( 'Japan, Yen', 'a5' ),
	'JEP'		 => array( 'Jersey, Pounds', 'a3' ),
	'KZT'		 => array( 'Kazakhstan, Tenge', '43b, 432' ),
	'KES'		 => array( 'Kenyan Shilling', '4B, 73, 68, 73' ),
	'KWD'		 => array( 'Kuwait, Dinar', '4B, 2E, 44, 2E' ),
	'KGS'		 => array( 'Kyrgyzstan, Soms', '43b, 432' ),
	'LAK'		 => array( 'Laos, Kips', '20ad' ),
	'LVL'		 => array( 'Latvia, Lati', '4c, 73' ),
	'LBP'		 => array( 'Lebanon, Pounds', 'a3' ),
	'LRD'		 => array( 'Liberia, Dollars', '24' ),
	'LTL'		 => array( 'Lithuania, Litai', '4c, 74' ),
	'MKD'		 => array( 'Macedonia, Denars', '434, 435, 43d' ),
	'MYR'		 => array( 'Malaysia, Ringgits', '52, 4d' ),
	'MUR'		 => array( 'Mauritius, Rupees', '20a8' ),
	'MXN'		 => array( 'Mexico, Pesos', '24' ),
	'MNT'		 => array( 'Mongolia, Tugriks', '20ae' ),
	'MAD'		 => array( 'Morocco, Dirhams', '64, 68' ),
	'MZN'		 => array( 'Mozambique, Meticais', '4d, 54' ),
	'NAD'		 => array( 'Namibia, Dollars', '24' ),
	'NPR'		 => array( 'Nepal, Rupees', '20a8' ),
	'ANG'		 => array( 'Netherlands Antilles, Guilders (also called Florins)', '192' ),
	'NZD'		 => array( 'New Zealand, Dollars', '24' ),
	'NIO'		 => array( 'Nicaragua, Cordobas', '43, 24' ),
	'NGN'		 => array( 'Nigeria, Nairas', '20a6' ),
	'KPW'		 => array( 'North Korea, Won', '20a9' ),
	'NOK'		 => array( 'Norway, Krone', '6b, 72' ),
	'OMR'		 => array( 'Oman, Rials', 'fdfc' ),
	'PKR'		 => array( 'Pakistan, Rupees', '20a8' ),
	'PAB'		 => array( 'Panama, Balboa', '42, 2f, 2e' ),
	'PYG'		 => array( 'Paraguay, Guarani', '47, 73' ),
	'PEN'		 => array( 'Peru, Nuevos Soles', '53, 2f, 2e' ),
	'PHP'		 => array( 'Philippines, Pesos', '50, 68, 70' ),
	'PLN'		 => array( 'Poland, Zlotych', '7a, 142' ),
	'QAR'		 => array( 'Qatar, Rials', 'fdfc' ),
	'RON'		 => array( 'Romania, New Lei', '6c, 65, 69' ),
	'RUB'		 => array( 'Russia, Rubles', '440, 443, 431' ),
	'SHP'		 => array( 'Saint Helena, Pounds', 'a3' ),
	'SAR'		 => array( 'Saudi Arabia, Riyals', 'fdfc' ),
	'RSD'		 => array( 'Serbia, Dinars', '414, 438, 43d, 2e' ),
	'SCR'		 => array( 'Seychelles, Rupees', '20a8' ),
	'SGD'		 => array( 'Singapore, Dollars', '24' ),
	'SBD'		 => array( 'Solomon Islands, Dollars', '24' ),
	'SOS'		 => array( 'Somalia, Shillings', '53' ),
	'ZAR'		 => array( 'South Africa, Rand', '52' ),
	'KRW'		 => array( 'South Korea, Won', '20a9' ),
	'LKR'		 => array( 'Sri Lanka, Rupees', '20a8' ),
	'SEK'		 => array( 'Sweden, Kronor', '6b, 72' ),
	'CHF'		 => array( 'Switzerland, Francs', '43, 48, 46' ),
	'SRD'		 => array( 'Suriname, Dollars', '24' ),
	'SYP'		 => array( 'Syria, Pounds', 'a3' ),
	'TWD'		 => array( 'Taiwan, New Dollars', '4e, 54, 24' ),
	'THB'		 => array( 'Thailand, Baht', 'e3f' ),
	'TTD'		 => array( 'Trinidad and Tobago, Dollars', '54, 54, 24' ),
	'TRY'		 => array( 'Turkey, Liras', '20a4' ),
	'TVD'		 => array( 'Tuvalu, Dollars', '24' ),
	'UAH'		 => array( 'Ukraine, Hryvnia', '20b4' ),
	'AED'		 => array( 'United Arab Emirates, Dirhams', '64, 68' ),
	'GBP'		 => array( 'United Kingdom, Pounds', 'a3' ),
	'USD'		 => array( 'United States of America, Dollars', '24' ),
	'UYU'		 => array( 'Uruguay, Pesos', '24, 55' ),
	'UZS'		 => array( 'Uzbekistan, Sums', '43b, 432' ),
	'VEF'		 => array( 'Venezuela, Bolivares Fuertes', '42, 73' ),
	'VND'		 => array( 'Vietnam, Dong', '20ab' ),
	'XAF'		 => array( 'BEAC, CFA Francs', '46, 43, 46, 41' ),
	'XOF'		 => array( 'BCEAO, CFA Francs', '46, 43, 46, 41' ),
	'YER'		 => array( 'Yemen, Rials', 'fdfc' ),
	'ZWD'		 => array( 'Zimbabwe, Zimbabwe Dollars', '5a, 24' ),
	'POINTS'	 => array( 'Points (for point based stores)', '50, 6f, 69, 6e, 74, 73' ),
	'CREDITS'	 => array( 'Credits (for credit based stores)', '43, 72, 65, 64, 69, 74, 73' )
);