<?php $page = $_GET['page']; ?>

<div id="poststuff" class="metabox-holder m-settings cp-wrap">
	<form action='' method='post'>

		<input type='hidden' name='page' value='<?php echo esc_attr( $page ); ?>'/>
		<input type='hidden' name='action' value='updateoptions'/>

		<?php
		wp_nonce_field( 'update-coursepress-options' );
		?>
		<div class="postbox">
			<h3 class="hndle" style='cursor:auto;'><span><?php _e( 'Slugs', 'cp' ); ?></span></h3>

			<div class="inside">
				<p class='description'><?php _e( 'A slug is a few words that describe a post or a page. Slugs are usually a URL friendly version of the post title ( which has been automatically generated by WordPress ), but a slug can be anything you like. Slugs are meant to be used with <a href="options-permalink.php">permalinks</a> as they help describe what the content at the URL is. Post slug substitutes the <strong>"%posttitle%"</strong> placeholder in a custom permalink structure.', 'cp' ); ?></p>
				<table class="form-table">
					<tbody>
					<tr valign="top">
						<th scope="row"><?php _e( 'Course Slug', 'cp' ); ?></th>
						<td>
							<?php
							echo esc_html( trailingslashit( home_url() ) );
							?>
							&nbsp;<input type='text' name='option_coursepress_course_slug' id='course_slug' value='<?php echo esc_attr( CoursePress::instance()->get_course_slug() );
							?>'/>&nbsp;/

							<p class='description'><?php _e( 'Your course URL will look like: ', 'cp' ); ?><?php echo esc_html( trailingslashit( home_url() ) ); ?><?php echo esc_attr( CoursePress::instance()->get_course_slug() ); ?><?php _e( '/my-course/', 'cp' ); ?></p>
							<hr/>
						</td>
					</tr>

					<tr valign="top">
						<th scope="row"><?php _e( 'Course Category Slug', 'cp' ); ?></th>
						<td>
							<?php
							echo esc_html( trailingslashit( home_url() ) );
							?>
							&nbsp;<input type='text' name='option_coursepress_course_category_slug' id='course_category_slug' value='<?php echo esc_attr( CoursePress::instance()->get_course_category_slug() );
							?>'/>&nbsp;/

							<p class='description'><?php _e( 'Your course category URL will look like: ', 'cp' ); ?><?php echo esc_html( trailingslashit( home_url() ) ); ?><?php echo esc_attr( CoursePress::instance()->get_course_slug() ) . '/' . CoursePress::instance()->get_course_category_slug(); ?><?php _e( '/your-category-slug/', 'cp' ); ?></p>
							<hr/>
						</td>
					</tr>

					<!--<tr valign="top">
						<th scope="row"><?php _e( 'Course Page', 'cp' ); ?></th>
						<td>
						<?php
					$option_name    = 'coursepress_course_page';
					$page_shortcode = '[cp_pages page="course"]';
					$pages_args     = array(
						'selected'          => get_option( $option_name, 0 ),
						'echo'              => 1,
						'show_option_none'  => __( 'Use virtual page', 'cp' ),
						'option_none_value' => 0,
						'name'              => 'option_' . $option_name
					);

					wp_dropdown_pages( $pages_args );
					?>
							<p class='description'><?php printf( __( 'Select page where you have %s shortcode or any other set of %s. Please note that slug for the page set above will not be used if "Use virtual page" is not selected.', 'cp' ), '<strong>' . $page_shortcode . '</strong>', '<a target="_blank" href="' . admin_url( 'admin.php?page=' . $_GET['page'] . '&tab=shortcodes' ) . '">' . __( 'shortcodes', 'cp' ) . '</a>' ); ?></p>

							<hr />
						</td>
					</tr>-->

					<tr valign="top">
						<th scope="row"><?php _e( 'Units Slug', 'cp' ); ?></th>
						<td>
							<?php
							echo esc_html( trailingslashit( home_url() . __( '/my-course/', 'cp' ) ) );
							?>
							&nbsp;<input type='text' name='option_coursepress_units_slug' id='units_slug' value='<?php echo esc_attr( CoursePress::instance()->get_units_slug() );
							?>'/>&nbsp;/
							<hr/>
						</td>
					</tr>
					<!--<tr valign="top">
                            <th scope="row"><?php _e( 'Units Page', 'cp' ); ?></th>
                            <td>
						<?php
					$option_name    = 'coursepress_units_page';
					$page_shortcode = '[cp_pages page="units"]';
					$pages_args     = array(
						'selected'          => get_option( $option_name, 0 ),
						'echo'              => 1,
						'show_option_none'  => __( 'Use virtual page', 'cp' ),
						'option_none_value' => 0,
						'name'              => 'option_' . $option_name
					);

					wp_dropdown_pages( $pages_args );
					?>
								<p class='description'><?php printf( __( 'Select page where you have %s shortcode or any other set of %s. Please note that slug for the page set above will not be used if "Use virtual page" is not selected.', 'cp' ), '<strong>' . $page_shortcode . '</strong>', '<a target="_blank" href="' . admin_url( 'admin.php?page=' . $_GET['page'] . '&tab=shortcodes' ) . '">' . __( 'shortcodes', 'cp' ) . '</a>' ); ?></p>

								<hr />
                            </td>
                        </tr>-->

					<tr valign="top">
						<th scope="row"><?php _e( 'Course Notifications Slug', 'cp' ); ?></th>
						<td>
							<?php
							echo esc_html( trailingslashit( home_url() . __( '/my-course/', 'cp' ) ) );
							?>
							&nbsp;<input type='text' name='option_coursepress_notifications_slug' id='notifications_slug' value='<?php echo esc_attr( CoursePress::instance()->get_notifications_slug() );
							?>'/>&nbsp;/
							<hr/>
						</td>
					</tr>
					<!--<tr valign="top">
                            <th scope="row"><?php _e( 'Course Notifications Page', 'cp' ); ?></th>
                            <td>
						<?php
					$option_name    = 'coursepress_notifications_page';
					$page_shortcode = '[cp_pages page="notifications"]';
					$pages_args     = array(
						'selected'          => get_option( $option_name, 0 ),
						'echo'              => 1,
						'show_option_none'  => __( 'Use virtual page', 'cp' ),
						'option_none_value' => 0,
						'name'              => 'option_' . $option_name
					);

					wp_dropdown_pages( $pages_args );
					?>
								<p class='description'><?php printf( __( 'Select page where you have %s shortcode or any other set of %s. Please note that slug for the page set above will not be used if "Use virtual page" is not selected.', 'cp' ), '<strong>' . $page_shortcode . '</strong>', '<a target="_blank" href="' . admin_url( 'admin.php?page=' . $_GET['page'] . '&tab=shortcodes' ) . '">' . __( 'shortcodes', 'cp' ) . '</a>' ); ?></p>

								<hr />
                            </td>
                        </tr>-->

					<tr valign="top">
						<th scope="row"><?php _e( 'Course Discussions Slug', 'cp' ); ?></th>
						<td>
							<?php
							echo esc_html( trailingslashit( home_url() . __( '/my-course/', 'cp' ) ) );
							?>
							&nbsp;<input type='text' name='option_coursepress_discussion_slug' id='discussion_slug' value='<?php echo esc_attr( CoursePress::instance()->get_discussion_slug() );
							?>'/>&nbsp;/
							<hr/>
						</td>
					</tr>
					<!--<tr valign="top">
							<th scope="row"><?php _e( 'Course Discussions Page', 'cp' ); ?></th>
							<td>
						<?php
					$option_name    = 'coursepress_discussions_page';
					$page_shortcode = '[cp_pages page="discussions"]';
					$pages_args     = array(
						'selected'          => get_option( $option_name, 0 ),
						'echo'              => 1,
						'show_option_none'  => __( 'Use virtual page', 'cp' ),
						'option_none_value' => 0,
						'name'              => 'option_' . $option_name
					);

					wp_dropdown_pages( $pages_args );
					?>
								<p class='description'><?php printf( __( 'Select page where you have %s shortcode or any other set of %s. Please note that slug for the page set above will not be used if "Use virtual page" is not selected.', 'cp' ), '<strong>' . $page_shortcode . '</strong>', '<a target="_blank" href="' . admin_url( 'admin.php?page=' . $_GET['page'] . '&tab=shortcodes' ) . '">' . __( 'shortcodes', 'cp' ) . '</a>' ); ?></p>

								<hr />
							</td>
						</tr>-->

					<tr valign="top">
						<th scope="row"><?php _e( 'Course New Discussions Slug', 'cp' ); ?></th>
						<td>
							<?php
							echo esc_html( trailingslashit( home_url() . __( '/my-course/', 'cp' ) ) );
							echo '' . CoursePress::instance()->get_discussion_slug() . '/';
							?>
							&nbsp;<input type='text' name='option_coursepress_discussion_slug_new' id='discussion_slug_new' value='<?php echo esc_attr( CoursePress::instance()->get_discussion_slug_new() );
							?>'/>&nbsp;/
							<hr/>
						</td>
					</tr>
					<!--<tr valign="top">
							<th scope="row"><?php _e( 'Course New Discussion Page', 'cp' ); ?></th>
							<td>
						<?php
					$option_name    = 'coursepress_new_discussion_page';
					$page_shortcode = '[cp_pages page="new_discussion"]';
					$pages_args     = array(
						'selected'          => get_option( $option_name, 0 ),
						'echo'              => 1,
						'show_option_none'  => __( 'Use virtual page', 'cp' ),
						'option_none_value' => 0,
						'name'              => 'option_' . $option_name
					);

					wp_dropdown_pages( $pages_args );
					?>
								<p class='description'><?php printf( __( 'Select page where you have %s shortcode or any other set of %s. Please note that slug for the page set above will not be used if "Use virtual page" is not selected.', 'cp' ), '<strong>' . $page_shortcode . '</strong>', '<a target="_blank" href="' . admin_url( 'admin.php?page=' . $_GET['page'] . '&tab=shortcodes' ) . '">' . __( 'shortcodes', 'cp' ) . '</a>' ); ?></p>

								<hr />
							</td>
						</tr>-->

					<tr valign="top">
						<th scope="row"><?php _e( 'Course Grades Slug', 'cp' ); ?></th>
						<td>
							<?php
							echo esc_html( trailingslashit( home_url() . __( '/my-course/', 'cp' ) ) );
							?>
							&nbsp;<input type='text' name='option_coursepress_grades_slug' id='grades_slug' value='<?php echo esc_attr( CoursePress::instance()->get_grades_slug() );
							?>'/>&nbsp;/
							<hr/>
						</td>
					</tr>
					<!--<tr valign="top">
							<th scope="row"><?php _e( 'Course Grades Page', 'cp' ); ?></th>
							<td>
						<?php
					$option_name    = 'coursepress_grades_page';
					$page_shortcode = '[cp_pages page="grades"]';
					$pages_args     = array(
						'selected'          => get_option( $option_name, 0 ),
						'echo'              => 1,
						'show_option_none'  => __( 'Use virtual page', 'cp' ),
						'option_none_value' => 0,
						'name'              => 'option_' . $option_name
					);

					wp_dropdown_pages( $pages_args );
					?>
								<p class='description'><?php printf( __( 'Select page where you have %s shortcode or any other set of %s. Please note that slug for the page set above will not be used if "Use virtual page" is not selected.', 'cp' ), '<strong>' . $page_shortcode . '</strong>', '<a target="_blank" href="' . admin_url( 'admin.php?page=' . $_GET['page'] . '&tab=shortcodes' ) . '">' . __( 'shortcodes', 'cp' ) . '</a>' ); ?></p>

								<hr />
							</td>
						</tr>-->

					<tr valign="top">
						<th scope="row"><?php _e( 'Course Workbook Slug', 'cp' ); ?></th>
						<td>
							<?php
							echo esc_html( trailingslashit( home_url() . __( '/my-course/', 'cp' ) ) );
							?>
							&nbsp;<input type='text' name='option_coursepress_workbook_slug' id='workbook_slug' value='<?php echo esc_attr( CoursePress::instance()->get_workbook_slug() );
							?>'/>&nbsp;/
							<hr/>
						</td>
					</tr>
					<!--<tr valign="top">
							<th scope="row"><?php _e( 'Course Workbook Page', 'cp' ); ?></th>
							<td>
						<?php
					$option_name    = 'coursepress_workbook_page';
					$page_shortcode = '[cp_pages page="workbook"]';
					$pages_args     = array(
						'selected'          => get_option( $option_name, 0 ),
						'echo'              => 1,
						'show_option_none'  => __( 'Use virtual page', 'cp' ),
						'option_none_value' => 0,
						'name'              => 'option_' . $option_name
					);

					wp_dropdown_pages( $pages_args );
					?>
								<p class='description'><?php printf( __( 'Select page where you have %s shortcode or any other set of %s. Please note that slug for the page set above will not be used if "Use virtual page" is not selected.', 'cp' ), '<strong>' . $page_shortcode . '</strong>', '<a target="_blank" href="' . admin_url( 'admin.php?page=' . $_GET['page'] . '&tab=shortcodes' ) . '">' . __( 'shortcodes', 'cp' ) . '</a>' ); ?></p>

								<hr />
							</td>
						</tr>-->

					<tr valign="top">
						<th scope="row"><?php _e( 'Enrollment Process page', 'cp' ); ?></th>
						<td>
							<?php
							echo esc_html( trailingslashit( home_url() ) );
							?>
							&nbsp;<input type='text' name='option_enrollment_process_slug' id='enrollment_process_slug' value='<?php echo esc_attr( get_option( 'enrollment_process_slug', 'enrollment-process' ) );
							?>'/>&nbsp;/
						</td>
					</tr>
					<tr valign="top">
						<th scope="row"><?php _e( 'Enrollment Process Page', 'cp' ); ?></th>
						<td>
							<?php
							$option_name    = 'coursepress_enrollment_process_page';
							$page_shortcode = '[cp_pages page="enrollment_process"]';
							$pages_args     = array(
								'selected'          => get_option( $option_name, 0 ),
								'echo'              => 1,
								'show_option_none'  => __( 'Use virtual page', 'cp' ),
								'option_none_value' => 0,
								'name'              => 'option_' . $option_name
							);

							wp_dropdown_pages( $pages_args );
							?>
							<p class='description'><?php printf( __( 'Select page where you have %s shortcode or any other set of %s. Please note that slug for the page set above will not be used if "Use virtual page" is not selected.', 'cp' ), '<strong>' . $page_shortcode . '</strong>', '<a target="_blank" href="' . admin_url( 'admin.php?page=' . $_GET['page'] . '&tab=shortcodes' ) . '">' . __( 'shortcodes', 'cp' ) . '</a>' ); ?></p>

							<hr/>
						</td>
					</tr>

					<tr valign="top">
						<th scope="row"><?php _e( 'Login Slug', 'cp' ); ?></th>
						<td>
							<?php
							echo esc_html( trailingslashit( home_url() ) );
							?>
							&nbsp;<input type='text' name='option_login_slug' id='login_slug' value='<?php echo esc_attr( get_option( 'login_slug', 'student-login' ) );
							?>'/>&nbsp;/
						</td>
					</tr>
					<tr valign="top">
						<th scope="row"><?php _e( 'Login Page', 'cp' ); ?></th>
						<td>
							<?php
							$option_name    = 'coursepress_login_page';
							$page_shortcode = '[cp_pages page="student_login"]';
							$pages_args     = array(
								'selected'          => get_option( $option_name, 0 ),
								'echo'              => 1,
								'show_option_none'  => __( 'Use virtual page', 'cp' ),
								'option_none_value' => 0,
								'name'              => 'option_' . $option_name
							);

							wp_dropdown_pages( $pages_args );
							?>
							<p class='description'><?php printf( __( 'Select page where you have %s shortcode or any other set of %s. Please note that slug for the page set above will not be used if "Use virtual page" is not selected.', 'cp' ), '<strong>' . $page_shortcode . '</strong>', '<a target="_blank" href="' . admin_url( 'admin.php?page=' . $_GET['page'] . '&tab=shortcodes' ) . '">' . __( 'shortcodes', 'cp' ) . '</a>' ); ?></p>

							<hr/>
						</td>
					</tr>

					<tr valign="top">
						<th scope="row"><?php _e( 'Sign Up Slug', 'cp' ); ?></th>
						<td>
							<?php
							echo esc_html( trailingslashit( home_url() ) );
							?>
							&nbsp;<input type='text' name='option_signup_slug' id='signup_slug' value='<?php echo esc_attr( get_option( 'signup_slug', 'courses-signup' ) );
							?>'/>&nbsp;/
						</td>
					</tr>
					<tr valign="top">
						<th scope="row"><?php _e( 'Sign Up Page', 'cp' ); ?></th>
						<td>
							<?php
							$option_name    = 'coursepress_signup_page';
							$page_shortcode = '[cp_pages page="student_signup"]';
							$pages_args     = array(
								'selected'          => get_option( $option_name, 0 ),
								'echo'              => 1,
								'show_option_none'  => __( 'Use virtual page', 'cp' ),
								'option_none_value' => 0,
								'name'              => 'option_' . $option_name
							);

							wp_dropdown_pages( $pages_args );
							?>
							<p class='description'><?php printf( __( 'Select page where you have %s shortcode or any other set of %s. Please note that slug for the page set above will not be used if "Use virtual page" is not selected.', 'cp' ), '<strong>' . $page_shortcode . '</strong>', '<a target="_blank" href="' . admin_url( 'admin.php?page=' . $_GET['page'] . '&tab=shortcodes' ) . '">' . __( 'shortcodes', 'cp' ) . '</a>' ); ?></p>

							<hr/>
						</td>
					</tr>

					<tr valign="top">
						<th scope="row"><?php _e( 'Student Dashboard Slug', 'cp' ); ?></th>
						<td>
							<?php
							echo esc_html( trailingslashit( home_url() ) );
							?>
							&nbsp;<input type='text' name='option_student_dashboard_slug' id='student_dashboard_slug' value='<?php echo esc_attr( get_option( 'student_dashboard_slug', 'courses-dashboard' ) );
							?>'/>&nbsp;/
						</td>
					</tr>
					<tr valign="top">
						<th scope="row"><?php _e( 'Student Dashboard Page', 'cp' ); ?></th>
						<td>
							<?php
							$option_name    = 'coursepress_student_dashboard_page';
							$page_shortcode = '[cp_pages page="student_dashboard"]';
							$pages_args     = array(
								'selected'          => get_option( $option_name, 0 ),
								'echo'              => 1,
								'show_option_none'  => __( 'Use virtual page', 'cp' ),
								'option_none_value' => 0,
								'name'              => 'option_' . $option_name
							);

							wp_dropdown_pages( $pages_args );
							?>
							<p class='description'><?php printf( __( 'Select page where you have %s shortcode or any other set of %s. Please note that slug for the page set above will not be used if "Use virtual page" is not selected.', 'cp' ), '<strong>' . $page_shortcode . '</strong>', '<a target="_blank" href="' . admin_url( 'admin.php?page=' . $_GET['page'] . '&tab=shortcodes' ) . '">' . __( 'shortcodes', 'cp' ) . '</a>' ); ?></p>

							<hr/>
						</td>
					</tr>

					<tr valign="top">
						<th scope="row"><?php _e( 'Student Settings page', 'cp' ); ?></th>
						<td>
							<?php
							echo esc_html( trailingslashit( home_url() ) );
							?>
							&nbsp;<input type='text' name='option_student_settings_slug' id='student_dashboard_slug' value='<?php echo esc_attr( get_option( 'student_settings_slug', 'settings' ) );
							?>'/>&nbsp;/
						</td>
					</tr>
					<tr valign="top">
						<th scope="row"><?php _e( 'Student Settings Page', 'cp' ); ?></th>
						<td>
							<?php
							$option_name    = 'coursepress_student_settings_page';
							$page_shortcode = '[cp_pages page="student_settings"]';
							$pages_args     = array(
								'selected'          => get_option( $option_name, 0 ),
								'echo'              => 1,
								'show_option_none'  => __( 'Use virtual page', 'cp' ),
								'option_none_value' => 0,
								'name'              => 'option_' . $option_name
							);

							wp_dropdown_pages( $pages_args );
							?>
							<p class='description'><?php printf( __( 'Select page where you have %s shortcode or any other set of %s. Please note that slug for the page set above will not be used if "Use virtual page" is not selected.', 'cp' ), '<strong>' . $page_shortcode . '</strong>', '<a target="_blank" href="' . admin_url( 'admin.php?page=' . $_GET['page'] . '&tab=shortcodes' ) . '">' . __( 'shortcodes', 'cp' ) . '</a>' ); ?></p>

							<hr/>
						</td>
					</tr>

					<tr valign="top">
						<th scope="row"><?php _e( 'Instructor Profile Slug', 'cp' ); ?></th>
						<td>
							<?php
							echo esc_html( trailingslashit( home_url() ) );
							?>
							&nbsp;<input type='text' name='option_instructor_profile_slug' id='instructor_profile_slug' value='<?php echo esc_attr( CoursePress::instance()->get_instructor_profile_slug() );
							?>'/>&nbsp;/
							<hr/>
						</td>
					</tr>

					<?php if ( function_exists( 'messaging_init' ) ) { ?>
						<tr valign="top">
							<th scope="row"><?php _e( 'Inbox Slug', 'cp' ); ?></th>
							<td>
								<?php
								echo esc_html( trailingslashit( home_url() ) );
								?>
								&nbsp;<input type='text' name='option_coursepress_inbox_slug' id='coursepress_inbox_slug' value='<?php echo esc_attr( CoursePress::instance()->get_inbox_slug() );
								?>'/>&nbsp;/
							</td>
						</tr>

						<tr valign="top">
							<th scope="row"><?php _e( 'Sent Messages Slug', 'cp' ); ?></th>
							<td>
								<?php
								echo esc_html( trailingslashit( home_url() ) );
								?>
								&nbsp;<input type='text' name='option_coursepress_sent_messages_slug' id='coursepress_sent_messages_slug' value='<?php echo esc_attr( CoursePress::instance()->get_sent_messages_slug() );
								?>'/>&nbsp;/
							</td>
						</tr>

						<tr valign="top">
							<th scope="row"><?php _e( 'New Message Slug', 'cp' ); ?></th>
							<td>
								<?php
								echo esc_html( trailingslashit( home_url() ) );
								?>
								&nbsp;<input type='text' name='option_coursepress_new_message_slug' id='coursepress_new_message_slug' value='<?php echo esc_attr( CoursePress::instance()->get_new_message_slug() );
								?>'/>&nbsp;/
							</td>
						</tr>
					<?php } ?>
					<!--<tr valign="top">
							<th scope="row"><?php _e( 'Instructor Profile Page', 'cp' ); ?></th>
							<td>
						<?php
					$option_name    = 'coursepress_instructor_profile_page';
					$page_shortcode = '[cp_pages page="instructor_profile"]';
					$pages_args     = array(
						'selected'          => get_option( $option_name, 0 ),
						'echo'              => 1,
						'show_option_none'  => __( 'Use virtual page', 'cp' ),
						'option_none_value' => 0,
						'name'              => 'option_' . $option_name
					);

					wp_dropdown_pages( $pages_args );
					?>
								<p class='description'><?php printf( __( 'Select page where you have %s shortcode or any other set of %s. Please note that slug for the page set above will not be used if "Use virtual page" is not selected.', 'cp' ), '<strong>' . $page_shortcode . '</strong>', '<a target="_blank" href="' . admin_url( 'admin.php?page=' . $_GET['page'] . '&tab=shortcodes' ) . '">' . __( 'shortcodes', 'cp' ) . '</a>' ); ?></p>

							</td>
						</tr>-->

					</tbody>
				</table>
			</div>
		</div>

		<div class="postbox">
			<h3 class="hndle" style='cursor:auto;'><span><?php _e( 'Theme Menu Items', 'cp' ); ?></span></h3>

			<div class="inside">
				<table class="form-table">
					<tbody>
					<tr valign="top">
						<th scope="row"><?php _e( 'Display menu items', 'cp' ); ?></th>
						<td>
							<a class="help-icon" href="javascript:;"></a>

							<div class="tooltip">
								<div class="tooltip-before"></div>
								<div class="tooltip-button">&times;</div>
								<div class="tooltip-content">
									<?php _e( '<div>Attach default CoursePress menu items ( Courses, Student Dashboard, Log Out ) to the <strong>Primary Menu</strong>.</div><div>Items can also be added from Appearance > Menus and the CoursePress panel.</div>', 'cp' ) ?>
								</div>
							</div>
							<input type='checkbox' name='display_menu_items' <?php echo( ( get_option( 'display_menu_items', 1 ) ) ? 'checked' : '' ); ?> />
							<?php
							if ( current_user_can( 'manage_options' ) ) {
								$menu_error = true;
								$locations  = get_theme_mod( 'nav_menu_locations' );
								if ( is_array( $locations ) ) {
									foreach ( $locations as $location => $value ) {
										if ( $value > 0 ) {
											$menu_error = false; //at least one is defined
										}
									}
								}
								//$menu_locations = get_nav_menu_locations();
								?>
								<span class="add_class_message">
										<?php
										if ( $menu_error ) {
											_e( 'Please add at least one menu and select its theme location in order to show CoursePress menu items automatically.', 'cp' );
										}
										?>
									</span>
							<?php
							}
							?>
						</td>
					</tr>
					</tbody>
				</table>
			</div>
		</div>

		<div class="postbox">
			<h3 class="hndle" style='cursor:auto;'><span><?php _e( 'Login Form', 'cp' ); ?></span></h3>

			<div class="inside">
				<table class="form-table">
					<tbody>
					<tr valign="top">
						<th scope="row"><?php _e( 'Use Custom Login Form', 'cp' ); ?></th>
						<td>
							<a class="help-icon" href="javascript:;"></a>

							<div class="tooltip">
								<div class="tooltip-before"></div>
								<div class="tooltip-button">&times;</div>
								<div class="tooltip-content">
									<?php _e( 'Uses a custom Login Form to keep students on the front-end of your site.', 'cp' ) ?>
								</div>
							</div>
							<input type='checkbox' name='use_custom_login_form' <?php echo( ( get_option( 'use_custom_login_form', 1 ) ) ? 'checked' : '' ); ?> />
						</td>
					</tr>
					</tbody>
				</table>
			</div>
		</div>

		<div class="postbox">
			<h3 class="hndle" style='cursor:auto;'><span><?php _e( 'WP Login Redirection', 'cp' ); ?></span></h3>

			<div class="inside">
				<table class="form-table">
					<tbody>
					<tr valign="top">
						<th scope="row"><?php _e( 'Redirect after login', 'cp' ); ?></th>
						<td>
							<a class="help-icon" href="javascript:;"></a>

							<div class="tooltip">
								<div class="tooltip-before"></div>
								<div class="tooltip-button">&times;</div>
								<div class="tooltip-content">
									<?php _e( 'Redirect students to their Dashboard upon login via wp-login form', 'cp' ) ?>
								</div>
							</div>
							<input type='checkbox' name='redirect_students_to_dashboard' <?php echo( ( get_option( 'redirect_students_to_dashboard', 1 ) ) ? 'checked' : '' ); ?> />
						</td>
					</tr>
					</tbody>
				</table>
			</div>
		</div>

		<div class="postbox">
			<h3 class="hndle" style='cursor:auto;'><span><?php _e( 'Privacy', 'cp' ); ?></span></h3>

			<div class="inside">
				<table class="form-table">
					<tbody>
					<tr valign="top">
						<th scope="row"><?php _e( 'Show Instructor Username in URL', 'cp' ); ?></th>
						<td>
							<a class="help-icon" href="javascript:;"></a>

							<div class="tooltip">
								<div class="tooltip-before"></div>
								<div class="tooltip-button">&times;</div>
								<div class="tooltip-content">
									<?php _e( 'If checked, instructors username will be shown in the url. Otherwise, hashed (MD5) version will be shown.', 'cp' ) ?>
								</div>
							</div>
							<input type='checkbox' name='option_show_instructor_username' <?php echo( ( get_option( 'show_instructor_username', 1 ) ) ? 'checked' : '' ); ?> />
						</td>
					</tr>
					</tbody>
				</table>
			</div>
		</div>

		<div class="postbox">
			<h3 class="hndle" style='cursor:auto;'><span><?php _e( 'Course Details Page', 'cp' ); ?></span></h3>

			<div class="inside">
				<p class='description'><?php _e( 'Media to use when viewing course details', 'cp' ); ?></p>
				<table class="form-table">
					<tbody>
					<tr valign="top">
						<th scope="row"><?php _e( 'Media Type', 'cp' ); ?>
							<?php CP_Helper_Tooltip::tooltip( __( '"Priority" - Use the media type below, with the other type as a fallback.', 'cp' ) ); ?></th>
						<td>
							<?php $selected_type = get_option( 'details_media_type', 'default' ); ?>
							<select name="option_details_media_type" class="widefat" id="option_details_media_type">
								<option value="default" <?php selected( $selected_type, 'default', true ); ?>><?php _e( 'Priority Mode (default)', 'cp' ); ?></option>
								<option value="video" <?php selected( $selected_type, 'video', true ); ?>><?php _e( 'Featured Video', 'cp' ); ?></option>
								<option value="image" <?php selected( $selected_type, 'image', true ); ?>><?php _e( 'List Image', 'cp' ); ?></option>
								<!-- <option value="thumbnail" <?php // selected($selected_type, 'thumbnail', true);             ?>><?php // _e( 'Thumbnail', 'cp' );             ?></option> -->
							</select>
						</td>
					</tr>
					<tr valign="top">
						<th scope="row"><?php _e( 'Priority', 'cp' ); ?>
							<?php CP_Helper_Tooltip::tooltip( __( 'Example: Using "video", the featured video will be used if available. The listing image is a fallback.', 'cp' ) ); ?></th>
						<td>
							<?php $selected_priority = get_option( 'details_media_priority', 'video' ); ?>
							<select name="option_details_media_priority" class="widefat" id="option_details_media_priority">
								<option value="video" <?php selected( $selected_priority, 'video', true ); ?>><?php _e( 'Featured Video (image fallback)', 'cp' ); ?></option>
								<option value="image" <?php selected( $selected_priority, 'image', true ); ?>><?php _e( 'List Image (video fallback)', 'cp' ); ?></option>
							</select>
						</td>
					</tr>

					</tbody>
				</table>
			</div>
		</div>

		<div class="postbox">
			<h3 class="hndle" style='cursor:auto;'><span><?php _e( 'Course Listings', 'cp' ); ?></span></h3>

			<div class="inside">
				<p class='description'><?php _e( 'Media to use when viewing course listings (e.g. Courses page or Instructor page)', 'cp' ); ?></p>
				<table class="form-table">
					<tbody>

					<tr valign="top">
						<th scope="row"><?php _e( 'Media Type', 'cp' ); ?>
							<?php CP_Helper_Tooltip::tooltip( __( '"Priority" - Use the media type below, with the other type as a fallback.', 'cp' ) ); ?></th>
						<td>
							<?php $selected_type = get_option( 'listings_media_type', 'default' ); ?>
							<select name="option_listings_media_type" class="widefat" id="option_listings_media_type">
								<option value="default" <?php selected( $selected_type, 'default', true ); ?>><?php _e( 'Priority Mode (default)', 'cp' ); ?></option>
								<option value="video" <?php selected( $selected_type, 'video', true ); ?>><?php _e( 'Featured Video', 'cp' ); ?></option>
								<option value="image" <?php selected( $selected_type, 'image', true ); ?>><?php _e( 'List Image', 'cp' ); ?></option>
								<!-- <option value="thumbnail" <?php // selected($selected_type, 'thumbnail', true);             ?>><?php // _e( 'Thumbnail', 'cp' );             ?></option> -->
							</select>
						</td>
					</tr>
					<tr valign="top">
						<th scope="row"><?php _e( 'Priority', 'cp' ); ?>
							<?php CP_Helper_Tooltip::tooltip( __( 'Example: Using "video", the featured video will be used if available. The listing image is a fallback.', 'cp' ) ); ?></th>
						<td>
							<?php $selected_priority = get_option( 'listings_media_priority', 'image' ); ?>
							<select name="option_listings_media_priority" class="widefat" id="option_listings_media_priority">
								<option value="video" <?php selected( $selected_priority, 'video', true ); ?>><?php _e( 'Featured Video (image fallback)', 'cp' ); ?></option>
								<option value="image" <?php selected( $selected_priority, 'image', true ); ?>><?php _e( 'List Image (video fallback)', 'cp' ); ?></option>
							</select>
						</td>
					</tr>

					</tbody>
				</table>
			</div>
		</div>


		<div class="postbox">
			<h3 class="hndle" style='cursor:auto;'><span><?php _e( 'Course Images', 'cp' ); ?></span></h3>

			<div class="inside">
				<p class='description'><?php _e( 'Size for ( newly uploaded ) course images', 'cp' ); ?></p>
				<table class="form-table">
					<tbody>

					<tr valign="top">
						<th scope="row"><?php _e( 'Image Width', 'cp' ); ?></th>
						<td>
							<input type='text' name='option_course_image_width' value="<?php echo esc_attr( get_option( 'course_image_width', 235 ) ); ?>"/>
						</td>
					</tr>

					<tr valign="top">
						<th scope="row"><?php _e( 'Image Height', 'cp' ); ?></th>
						<td>
							<input type='text' name='option_course_image_height' value="<?php echo esc_attr( get_option( 'course_image_height', 225 ) ); ?>"/>
						</td>
					</tr>

					</tbody>
				</table>
			</div>
		</div>

		<div class="postbox">
			<h3 class="hndle" style='cursor:auto;'><span><?php _e( 'Course Order', 'cp' ); ?></span></h3>

			<div class="inside">
				<p class='description'><?php _e( 'Order of courses in admin and on front. If you choose "Post Order Number", you will have option to reorder courses from within the Courses admin page.', 'cp' ); ?></p>
				<table class="form-table">
					<tbody>

					<tr valign="top">
						<th scope="row"><?php _e( 'Order By', 'cp' ); ?></th>
						<td>
							<?php $selected_course_order_by = get_option( 'course_order_by', 'post_date' ); ?>
							<select name="option_course_order_by" class="widefat" id="option_course_order_by">
								<option value="post_date" <?php selected( $selected_course_order_by, 'post_date', true ); ?>><?php _e( 'Post Date', 'cp' ); ?></option>
								<option value="course_order" <?php selected( $selected_course_order_by, 'course_order', true ); ?>><?php _e( 'Post Order Number', 'cp' ); ?></option>
							</select>
						</td>
					</tr>
					<tr valign="top">
						<th scope="row"><?php _e( 'Type', 'cp' ); ?>
						<td>
							<?php $selected_course_order_by_type = get_option( 'course_order_by_type', 'DESC' ); ?>
							<select name="option_course_order_by_type" class="widefat" id="option_course_order_by_type">
								<option value="DESC" <?php selected( $selected_course_order_by_type, 'DESC', true ); ?>><?php _e( 'Descending', 'cp' ); ?></option>
								<option value="ASC" <?php selected( $selected_course_order_by_type, 'ASC', true ); ?>><?php _e( 'Ascending', 'cp' ); ?></option>
							</select>
						</td>
					</tr>

					</tbody>
				</table>
			</div>
		</div>

		<div class="postbox">
			<h3 class="hndle" style='cursor:auto;'><span><?php _e( 'Reports', 'cp' ); ?></span></h3>

			<div class="inside">
				<p class='description'><?php _e( 'Select font which will be used in the PDF reports.', 'cp' ); ?></p>
				<table class="form-table">
					<tbody>
					<tr valign="top">
						<th scope="row"><?php _e( 'Font', 'cp' ); ?></th>
						<td>
							<?php
							$reports_font = get_option( 'reports_font', 'helvetica' );
							?>
							<select name="option_reports_font">
								<option value='aealarabiya' <?php selected( $reports_font, 'aealarabiya', true ); ?>><?php _e( 'Al Arabiya', 'cp' ); ?></option>
								<option value='aefurat' <?php selected( $reports_font, 'aefurat', true ); ?>><?php _e( 'Furat', 'cp' ); ?></option>
								<option value='cid0cs' <?php selected( $reports_font, 'cid0cs', true ); ?>><?php _e( 'Arial Unicode MS (Simplified Chinese)', 'cp' ); ?></option>
								<option value='cid0jp' <?php selected( $reports_font, 'cid0jp', true ); ?>><?php _e( 'Arial Unicode MS (Japanese)', 'cp' ); ?></option>
								<option value='cid0kr' <?php selected( $reports_font, 'cid0kr', true ); ?>><?php _e( 'Arial Unicode MS (Korean)', 'cp' ); ?></option>
								<option value='courier <?php selected( $reports_font, 'courier', true ); ?>'><?php _e( 'Courier', 'cp' ); ?></option>
								<option value='dejavusans' <?php selected( $reports_font, 'dejavusans', true ); ?>><?php _e( 'DejaVu Sans', 'cp' ); ?></option>
								<option value='dejavusanscondensed' <?php selected( $reports_font, 'dejavusanscondensed', true ); ?>><?php _e( 'DejaVu Sans Condensed', 'cp' ); ?></option>
								<option value='dejavusansextralight' <?php selected( $reports_font, 'dejavusansextralight', true ); ?>><?php _e( 'DejaVu Sans ExtraLight', 'cp' ); ?></option>
								<option value='dejavusansmono' <?php selected( $reports_font, 'dejavusansmono', true ); ?>><?php _e( 'DejaVu Sans Mono', 'cp' ); ?></option>
								<option value='dejavuserif' <?php selected( $reports_font, 'dejavuserif', true ); ?>><?php _e( 'DejaVu Serif', 'cp' ); ?></option>
								<option value='dejavuserifcondensed' <?php selected( $reports_font, 'dejavuserifcondensed', true ); ?>><?php _e( 'DejaVu Serif Condensed', 'cp' ); ?></option>
								<option value='freemono' <?php selected( $reports_font, 'freemono', true ); ?>><?php _e( 'FreeMono', 'cp' ); ?></option>
								<option value='freesans' <?php selected( $reports_font, 'freesans', true ); ?>><?php _e( 'FreeSans', 'cp' ); ?></option>
								<option value='freeserif' <?php selected( $reports_font, 'freeserif', true ); ?>><?php _e( 'FreeSerif', 'cp' ); ?></option>
								<option value='helvetica' <?php selected( $reports_font, 'helvetica', true ); ?>><?php _e( 'Helvetica', 'cp' ); ?></option>
								<option value='hysmyeongjostdmedium' <?php selected( $reports_font, 'hysmyeongjostdmedium', true ); ?>><?php _e( 'MyungJo Medium (Korean)', 'cp' ); ?></option>
								<option value='kozgopromedium' <?php selected( $reports_font, 'kozgopromedium', true ); ?>><?php _e( 'Kozuka Gothic Pro (Japanese Sans-Serif)', 'cp' ); ?></option>
								<option value='kozminproregular' <?php selected( $reports_font, 'kozminproregular', true ); ?>><?php _e( 'Kozuka Mincho Pro (Japanese Serif)', 'cp' ); ?></option>
								<option value='msungstdlight' <?php selected( $reports_font, 'msungstdlight', true ); ?>><?php _e( 'MSung Light (Traditional Chinese)', 'cp' ); ?></option>
								<option value='pdfacourier' <?php selected( $reports_font, 'pdfacourier', true ); ?>><?php _e( 'PDFA Courier', 'cp' ); ?></option>
								<option value='pdfahelvetica' <?php selected( $reports_font, 'pdfahelvetica', true ); ?>><?php _e( 'PDFA Helvetica', 'cp' ); ?></option>
								<option value='pdfasymbol' <?php selected( $reports_font, 'pdfasymbol', true ); ?>><?php _e( 'PDFA Symbol', 'cp' ); ?></option>
								<option value='pdfatimes' <?php selected( $reports_font, 'pdfatimes', true ); ?>><?php _e( 'PDFA Times', 'cp' ); ?></option>
								<option value='pdfazapfdingbats' <?php selected( $reports_font, 'pdfazapfdingbats', true ); ?>><?php _e( 'PDFA Zapfdingbats', 'cp' ); ?></option>
								<option value='stsongstdlight' <?php selected( $reports_font, 'stsongstdlight', true ); ?>><?php _e( 'STSong Light (Simplified Chinese)', 'cp' ); ?></option>
								<option value='symbol' <?php selected( $reports_font, 'symbol', true ); ?>><?php _e( 'Symbol', 'cp' ); ?></option>
								<option value='times' <?php selected( $reports_font, 'times', true ); ?>><?php _e( 'Times-Roman', 'cp' ); ?></option>
								<option value='zapfdingbats' <?php selected( $reports_font, 'zapfdingbats', true ); ?>><?php _e( 'ZapfDingbats', 'cp' ); ?></option>
								<?php do_action( 'tc_ticket_font' ); ?>
							</select>
						</td>
					</tr>
					</tbody>
				</table>
			</div>
		</div>

		<?php if ( shortcode_exists( 'signup-tos' ) ) { ?>
			<div class="postbox">
				<h3 class="hndle" style='cursor:auto;'><span><?php _e( 'Signup TOS', 'cp' ); ?></span></h3>

				<div class="inside">
					<table class="form-table">
						<tbody>
						<tr valign="top">
							<th scope="row"><?php _e( 'Show Terms of Service', 'cp' ); ?></th>
							<td>
								<a class="help-icon" href="javascript:;"></a>

								<div class="tooltip">
									<div class="tooltip-before"></div>
									<div class="tooltip-button">&times;</div>
									<div class="tooltip-content">
										<?php _e( 'If checked, user will be forced to agree to terms of services added in "Terms of Service" (Signup TOS) plugin', 'cp' ) ?>
									</div>
								</div>
								<input type='checkbox' name='option_show_tos' <?php echo( ( get_option( 'show_tos', 0 ) ) ? 'checked' : '' ); ?> />
							</td>
						</tr>
						</tbody>
					</table>
				</div>
			</div>
		<?php } ?>

		<?php if ( function_exists( 'messaging_init' ) ) { ?>
			<div class="postbox">
				<h3 class="hndle" style='cursor:auto;'>
					<span><?php printf( __( 'Messaging (%sMessaging plugin%s)', 'cp' ), '<a href="http://premium.wpmudev.org/project/messaging/">', '</a>' ); ?></span>
				</h3>

				<div class="inside">
					<table class="form-table">
						<tbody>
						<tr valign="top">
							<th scope="row"><?php _e( 'Allow Private Student Messaging on front', 'cp' ); ?></th>
							<td>
								<a class="help-icon" href="javascript:;"></a>

								<div class="tooltip">
									<div class="tooltip-before"></div>
									<div class="tooltip-button">&times;</div>
									<div class="tooltip-content">
										<?php _e( 'If checked, students will see "Inbox" in their Dashboard and will be able to receive and send private messages.', 'cp' ) ?>
									</div>
								</div>
								<input type='checkbox' name='show_messaging' <?php echo( ( get_option( 'show_messaging', 0 ) ) ? 'checked' : '' ); ?> />
							</td>
						</tr>
						</tbody>
					</table>
				</div>
			</div>
		<?php } ?>


		<?php
		do_action( 'coursepress_general_options_page' );
		?>

		<p class="save-shanges">
			<?php submit_button( __( 'Save Changes', 'cp' ) ); ?>
		</p>

	</form>
</div>