<?php
if (empty($duration)) {
    $duration = $gallery_configs['theme']['slider_theme']['duration'];
}

if (empty($animation)) {
    $animation = $gallery_configs['theme']['slider_theme']['animation'];
}

if (empty($auto_animation)) {
    $auto_animation = $gallery_configs['theme']['slider_theme']['auto_animation'];
}

$class[] = 'flexslider gallery_addon_flexslider carousel wpmfflexslider';
$class   = implode(' ', $class);

echo '<div class="wpmf-gallerys wpmf-gallerys-addon">';
echo '<div id="' . esc_html($id) . '" data-id="' . esc_html($id) . '" class="' . esc_html($class) . '" data-wpmfcolumns="' . esc_html($columns) . '"
 data-duration="' . esc_html($duration) . '" data-animation="' . esc_html($animation) . '" data-auto_animation="' . esc_html($auto_animation) . '">';
echo '<ul class="slides wpmf-slides">';
$i            = 0;
$height_array = array();
foreach ($attachments as $img_id => $attachment) {
    $img = wp_get_attachment_image_src($img_id, $size);
    if (!$img) {
        continue;
    }
    $sizes = image_get_intermediate_size($attachment->ID, $size);
    if (!$sizes) {
        $img_data   = wp_get_attachment_metadata($attachment->ID);
        $height_img = $img_data['height'];
    } else {
        $height_img = $sizes['height'];
    }
    $height_array[] = $height_img;
}

$current_theme = get_option('current_theme');
if (isset($current_theme) && $current_theme === 'Gleam') {
    $tclass = 'fancybox';
} else {
    $tclass = '';
}

foreach ($attachments as $img_id => $attachment) {
    $image_meta = wp_get_attachment_metadata($img_id);
    if (empty($image_meta['height']) || empty($image_meta['width'])) {
        continue;
    }
    $img = wp_get_attachment_image_src($img_id, $size);
    if (!$img) {
        continue;
    }
    $post_title   = esc_html($attachment->post_title);
    $post_excerpt = esc_html($attachment->post_excerpt);
    $img_tags     = get_post_meta($attachment->ID, 'wpmf_img_tags', true);
    $sizes        = image_get_intermediate_size($attachment->ID, $size);
    if (!$sizes) {
        $sizes = wp_get_attachment_metadata($attachment->ID);
    }
    if (is_numeric($sizes['height']) && (int) $sizes['height'] !== 0) {
        $ratio = $sizes['width'] / $sizes['height'];
    } else {
        $ratio = 1;
    }

    $link_target = get_post_meta($attachment->ID, '_gallery_link_target', true);


    list($src, $width, $height) = $img;
    $alt  = trim(strip_tags(get_post_meta($img_id, '_wp_attachment_image_alt', true))); // Use Alt field first
    $tg   = get_post_meta($attachment->ID, '_gallery_link_target', true);
    $icon = "<span class='hover_img'></span>";

    if ((int) $columns === 1) {
        $css_hover = 'width:' . $width . 'px; height:' . $height . 'px';
        $icon      = '<span class="hover_img ' . $tclass . '" style="' . $css_hover . '"></span>';
        $iOutput   = $icon . '<img src="' . $src . '" width="' . $width . '" height="' . $height . '" alt="' . $alt . '" />';
    } else {
        $iOutput = $icon . '<img src="' . $src . '" data-ratio="' . $ratio . '"
         width="' . max($height_array) * $ratio . '" alt="' . $alt . '"
          style="width:' . max($height_array) * $ratio . 'px;min-height:' . max($height_array) . 'px !important" />';
    }


    $image_output = '';
    if (!empty($link)) {
        if ($customlink) {
            $url = get_post_meta($img_id, _WPMF_GALLERY_PREFIX . 'custom_image_link', true);
            if ($url === '') {
                $url = get_attachment_link($img_id);
            }
            $image_output = '<a class="' . $tclass . '"
             href="' . $url . '" target="' . $link_target . '">' . $iOutput . '</a>';
        } elseif ('post' === $link) {
            $url          = get_attachment_link($img_id);
            $image_output = '<a class="' . $tclass . '"
             href="' . $url . '" target="' . $link_target . '">' . $iOutput . '</a>';
        } elseif ('file' === $link) {
            if (get_post_meta($img_id, _WPMF_GALLERY_PREFIX . 'custom_image_link', true) !== '') {
                $lightbox  = 0;
                $url       = get_post_meta($img_id, _WPMF_GALLERY_PREFIX . 'custom_image_link', true);
                $data_size = '';
            } else {
                $lightbox  = 1;
                $urls      = wp_get_attachment_image_src($img_id, $targetsize);
                $url       = $urls[0];
                $data_size = $urls[1] . 'x' . $urls[2];
            }

            $remote_video = get_post_meta($img_id, 'wpmf_remote_video_link', true);
            if (!empty($remote_video)) {
                $image_output = '<a data-size="' . $data_size . '"
                 class="' . $tclass . ' isvideo wpmfgalleryaddonswipe" data-swipe="' . $lightbox . '"
                  href="' . $remote_video . '" target="' . $link_target . '"
                   title="' . $post_title . '">' . $iOutput . '</a>';
            } else {
                $image_output = '<a data-size="' . $data_size . '"
                 class="' . $tclass . ' not_video wpmfgalleryaddonswipe" data-swipe="' . $lightbox . '"
                  href="' . $url . '" target="' . $link_target . '"
                   title="' . $post_title . '">' . $iOutput . '</a>';
            }
        } else {
            if (get_post_meta($img_id, _WPMF_GALLERY_PREFIX . 'custom_image_link', true) !== '') {
                $lightbox     = 0;
                $url          = get_post_meta($img_id, _WPMF_GALLERY_PREFIX . 'custom_image_link', true);
                $image_output = '<a class="' . $tclass . '" href="' . $url . '"
                 target="' . $link_target . '" title="' . $post_title . '">' . $iOutput . '</a>';
            } else {
                if ((int) $columns === 1) {
                    $css_hover    = 'width:' . $width . 'px; height:' . $height . 'px';
                    $image_output = '<img src="' . $src . '" width="' . $width . '" height="' . $height . '" alt="' . $alt . '" />';
                } else {
                    $style        = 'width:' . max($height_array) * $ratio . 'px;';
                    $style        .= 'min-height:' . max($height_array) . 'px !important';
                    $image_output = '<img src="' . $src . '" data-ratio="' . $ratio . '"
                     width="' . max($height_array) * $ratio . '" alt="' . $alt . '"
                      style="' . $style . '" />';
                }
            }
        }
    }

    $orientation = ($image_meta['height'] > $image_meta['width']) ? 'portrait' : 'landscape';
    if ((int) $columns === 1) {
        echo '<li class="wpmf-gg-one-columns wpmf-gallery-item item" data-tags="' . esc_html($img_tags) . '">';
    } else {
        echo '<li class="wpmf-gallery-item item" style="height:' . esc_html(max($height_array)) . 'px"
         data-tags="' . esc_html($img_tags) . '">';
    }
    echo '<div class="gallery-icon ' . esc_html($orientation) . '">';
    echo $image_output; // phpcs:ignore WordPress.Security.EscapeOutput -- Content already escaped in the method
    echo '</div>';
    if (trim($post_excerpt) || trim($post_title)) {
        echo '<div class="wpmf-front-box top">';
        echo '<a>';
        echo '<span class="title">' . esc_html($post_title) . '</span>';
        echo '<span class="caption">' . esc_html($post_excerpt) . '</span>';
        echo '</a>';
        echo '</div>';
    }

    if ((int) $social_sharing === 1) {
        if (!empty($facebook) || !empty($twitter) || !empty($google) || !empty($instagram) || !empty($pinterest)) {
            echo '<div class="wpmfglr_social possition_top">';
            if (!empty($facebook)) {
                echo '<a href="' . esc_html($facebook) . '"  target="_blank">
<span class="dashicons dashicons-facebook-alt"></span></a>';
            }

            if (!empty($twitter)) {
                echo '<a href="' . esc_html($twitter) . '"  target="_blank">
<span class="dashicons dashicons-twitter"></span></a>';
            }

            if (!empty($google)) {
                echo '<a href="' . esc_html($google) . '"  target="_blank">
<span class="dashicons dashicons-googleplus"></span></a>';
            }

            if (!empty($instagram)) {
                echo '<a href="' . esc_html($instagram) . '"  target="_blank">
<img class="glrsocial_image" src="' . esc_html(WPMF_GALLERY_ADDON_PLUGIN_URL) . '/assets/images/instagram.png" /></a>';
            }

            if (!empty($pinterest)) {
                echo '<a href="' . esc_html($pinterest) . '"  target="_blank">
<img class="glrsocial_image" src="' . esc_html(WPMF_GALLERY_ADDON_PLUGIN_URL) . '/assets/images/pinterest.png" /></a>';
            }

            echo '</div>';
        }
    }

    echo '</li>';
}


echo '</ul>';
echo '</div></div>';
