<?php
$lists      = array();
$lists_full = array();
$j          = 0;
foreach ($attachments as $img_id => $attachment) {
    $image_meta = wp_get_attachment_metadata($img_id);
    if (empty($image_meta['height']) || empty($image_meta['width'])) {
        continue;
    }
    $orientation  = '';
    $post_title   = esc_html($attachment->post_title);
    $post_excerpt = esc_html($attachment->post_excerpt);
    $caption_text = trim($post_excerpt);
    $link_target  = get_post_meta($attachment->ID, '_gallery_link_target', true);
    $img_tags     = get_post_meta($attachment->ID, 'wpmf_img_tags', true);
    if (!empty($link) && ('file' === $link || 'post' === $link)) {
        $image_output = $this->galleryGetAttachmentLink($img_id, $size, false, $targetsize, $customlink, $link_target);
    } elseif (!empty($link) && 'none' === $link) {
        if (get_post_meta($img_id, _WPMF_GALLERY_PREFIX . 'custom_image_link', true) !== '') {
            $image_output = $this->galleryGetAttachmentLink($img_id, $size, false, $targetsize, $customlink, $link_target);
        } else {
            $image_output = wp_get_attachment_image($img_id, $size, false, array('data-type' => 'wpmfgalleryimg'));
        }
    } else {
        $image_output = $this->galleryGetAttachmentLink($img_id, $size, true, 'large', false, $link_target);
    }

    $orientation = ($image_meta['height'] > $image_meta['width']) ? 'portrait' : 'landscape';
    $item        = '<figure class="wpmf-gallery-item gallery-item">';
    $item        .= '<div class="card image-over-card m-t-30">';

    if ((int) $social_sharing === 1) {
        $item .= '<div class="card-image">';

        if (!empty($facebook) || !empty($twitter) || !empty($google) || !empty($instagram) || !empty($pinterest)) {
            $item .= "<div class='hover_img hover_default_theme'>";
            $item .= '<div class="wpmfglr_social">';
            if (!empty($facebook)) {
                $item .= '<a href="' . $facebook . '"  target="_blank">
<span class="dashicons dashicons-facebook-alt"></span></a>';
            }

            if (!empty($twitter)) {
                $item .= '<a href="' . $twitter . '"  target="_blank">
<span class="dashicons dashicons-twitter"></span></a>';
            }

            if (!empty($google)) {
                $item .= '<a href="' . $google . '"  target="_blank">
<span class="dashicons dashicons-googleplus"></span></a>';
            }

            if (!empty($instagram)) {
                $item .= '<a href="' . $instagram . '"  target="_blank">
<img class="glrsocial_image" src="' . WPMF_GALLERY_ADDON_PLUGIN_URL . '/assets/images/instagram.png" /></a>';
            }

            if (!empty($pinterest)) {
                $item .= '<a href="' . $pinterest . '"  target="_blank">
<img class="glrsocial_image" src="' . WPMF_GALLERY_ADDON_PLUGIN_URL . '/assets/images/pinterest.png" /></a>';
            }

            $item .= '</div>';
            $item .= '</div>';
        }

        $item .= $image_output . '</div>';
    } else {
        $item .= '<div class="card-image">' . $image_output . '</div>';
    }


    $item .= '<div class="card-body">';
    $item .= '<h4 class="card-title text-center wpmf-gallery-caption">' . wptexturize($caption_text) . '</h4>';
    $item .= '</div>';
    $item .= '</div>';
    $item .= '</figure>';

    if (isset($gallery_configs['progressive_loading']) && (int) $gallery_configs['progressive_loading'] === 0) {
        $lists[] = $item;
    } else {
        if ($j >= 10) {
            $lists[] = $item;
            // add line break
            if (($j + 1) % $columns === 0) {
                $lists[] = '<hr class="wpmfglr-line-break" />';
            }
        }
        $j ++;
    }
    $lists_full[] = $item;
}

$class[]    = 'row wpmf_gallery_default gallery_default glrdefault';
$class[]    = 'galleryid-' . $id;
$class[]    = 'gallery-columns-' . $columns;
$class[]    = 'gallery-size-' . $size_class;
$class      = implode(' ', $class);
$json_lists = esc_html(json_encode($lists));
echo '<div class="wpmf-gallerys wpmf-gallerys-addon" data-id="' . esc_html($id) . '">';
echo '<div data-id="' . esc_html($id) . '" data-item="' . esc_html($json_lists) . '" data-wpmfcolumns="' . esc_html($columns) . '" class="' . esc_html($class) . '">';
foreach ($lists_full as $i => $list) {
    if (isset($gallery_configs['progressive_loading']) && (int) $gallery_configs['progressive_loading'] === 0) {
        // phpcs:ignore WordPress.Security.EscapeOutput -- Content already escaped in the method
        echo $list;
    } else {
        if ($i < 10) {
            // phpcs:ignore WordPress.Security.EscapeOutput -- Content already escaped in the method
            echo $list;
        }
    }
}

echo '</div></div>';
