'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

(function (wpI18n, wpBlocks, wpElement, wpEditor, wpComponents) {
    var __ = wpI18n.__;
    var Component = wpElement.Component,
        Fragment = wpElement.Fragment;
    var registerBlockType = wpBlocks.registerBlockType;
    var BlockControls = wpEditor.BlockControls,
        BlockAlignmentToolbar = wpEditor.BlockAlignmentToolbar,
        InspectorControls = wpEditor.InspectorControls;
    var PanelBody = wpComponents.PanelBody,
        Modal = wpComponents.Modal,
        FocusableIframe = wpComponents.FocusableIframe,
        IconButton = wpComponents.IconButton,
        Toolbar = wpComponents.Toolbar,
        SelectControl = wpComponents.SelectControl,
        ToggleControl = wpComponents.ToggleControl;


    var el = wpElement.createElement;
    var iconblock = el('svg', { width: 24, height: 24 }, el('path', { d: "M18 2H6c-1.1 0-2 .9-2 2v16c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-7 2v5l-1-.75L9 9V4h2zm7 16H6V4h1v9l3-2.25L13 13V4h5v16zm-6.72-2.04L9.5 15.81 7 19h10l-3.22-4.26z" }));

    var WpmfGallery = function (_Component) {
        _inherits(WpmfGallery, _Component);

        function WpmfGallery() {
            _classCallCheck(this, WpmfGallery);

            var _this = _possibleConstructorReturn(this, (WpmfGallery.__proto__ || Object.getPrototypeOf(WpmfGallery)).apply(this, arguments));

            _this.state = {
                isOpen: false
            };

            _this.openModal = _this.openModal.bind(_this);
            _this.closeModal = _this.closeModal.bind(_this);
            _this.addEventListener = _this.addEventListener.bind(_this);
            _this.componentDidMount = _this.componentDidMount.bind(_this);
            return _this;
        }

        _createClass(WpmfGallery, [{
            key: 'openModal',
            value: function openModal() {
                if (!this.state.isOpen) {
                    this.setState({ isOpen: true });
                }
            }
        }, {
            key: 'closeModal',
            value: function closeModal() {
                if (this.state.isOpen) {
                    this.setState({ isOpen: false });
                }
            }
        }, {
            key: 'addEventListener',
            value: function addEventListener(e) {
                if (!e.data.galleryId) {
                    return;
                }

                if (e.data.type !== 'wpmfgalleryinsert') {
                    return;
                }

                if (e.data.idblock !== this.props.clientId) {
                    return;
                }

                this.setState({
                    isOpen: false
                });

                var _props = this.props,
                    attributes = _props.attributes,
                    setAttributes = _props.setAttributes;
                var galleryId = attributes.galleryId;

                var themes_setting = wpmfgalleryblocks.vars.themes_setting;
                var theme = 'default';
                if (typeof themes_setting[e.data.galleryId] !== "undefined") {
                    theme = themes_setting[e.data.galleryId].theme;
                }
                var settings = wpmfgalleryblocks.vars.gallery_configs.theme[theme + '_theme'];
                if (galleryId === 0) {
                    setAttributes({
                        galleryId: e.data.galleryId,
                        display_tree: e.data.display_tree,
                        display_tag: e.data.display_tag,
                        columns: parseInt(settings.columns),
                        link: settings.link,
                        wpmf_order: settings.order,
                        wpmf_orderby: settings.orderby,
                        size: settings.size,
                        targetsize: settings.targetsize
                    });
                } else {
                    setAttributes({
                        galleryId: e.data.galleryId,
                        display_tree: e.data.display_tree,
                        display_tag: e.data.display_tag
                    });
                }
            }
        }, {
            key: 'componentDidMount',
            value: function componentDidMount() {
                window.addEventListener("message", this.addEventListener, false);
            }
        }, {
            key: 'render',
            value: function render() {
                var _this2 = this;

                var _props2 = this.props,
                    attributes = _props2.attributes,
                    setAttributes = _props2.setAttributes;
                var align = attributes.align,
                    galleryId = attributes.galleryId,
                    display_tree = attributes.display_tree,
                    display_tag = attributes.display_tag,
                    columns = attributes.columns,
                    size = attributes.size,
                    targetsize = attributes.targetsize,
                    link = attributes.link,
                    wpmf_orderby = attributes.wpmf_orderby,
                    wpmf_order = attributes.wpmf_order;


                var list_sizes = Object.keys(wpmfgalleryblocks.vars.sizes).map(function (key, label) {
                    return {
                        label: wpmfgalleryblocks.vars.sizes[key],
                        value: key
                    };
                });
                var gallery_shortcode = '[wpmfgallery';
                gallery_shortcode += ' gallery_id="' + galleryId + '"';
                gallery_shortcode += ' size="' + size + '"';
                gallery_shortcode += ' columns="' + columns + '"';
                gallery_shortcode += ' targetsize="' + targetsize + '"';
                gallery_shortcode += ' link="' + link + '"';
                gallery_shortcode += ' wpmf_orderby="' + wpmf_orderby + '"';
                gallery_shortcode += ' wpmf_order="' + wpmf_order + '"';
                gallery_shortcode += ' display_tree="' + display_tree + '"';
                gallery_shortcode += ' display_tag="' + display_tag + '"';
                gallery_shortcode += ']';

                return React.createElement(
                    Fragment,
                    null,
                    galleryId !== 0 && React.createElement(
                        Fragment,
                        null,
                        React.createElement(
                            BlockControls,
                            null,
                            React.createElement(
                                Toolbar,
                                null,
                                React.createElement(BlockAlignmentToolbar, { value: align,
                                    onChange: function onChange(align) {
                                        return setAttributes({ align: align });
                                    } }),
                                React.createElement(IconButton, {
                                    className: 'components-toolbar__control',
                                    label: wpmfgalleryblocks.l18n.edit,
                                    icon: 'edit',
                                    onClick: function onClick() {
                                        return _this2.setState({ isOpen: true });
                                    }
                                }),
                                React.createElement(IconButton, {
                                    className: 'components-toolbar__control',
                                    label: wpmfgalleryblocks.l18n.remove,
                                    icon: 'no',
                                    onClick: function onClick() {
                                        return setAttributes({ galleryId: 0 });
                                    }
                                })
                            )
                        ),
                        React.createElement(
                            InspectorControls,
                            null,
                            React.createElement(
                                PanelBody,
                                { title: __('Gallery Settings') },
                                React.createElement(ToggleControl, {
                                    label: __('Gallery navigation'),
                                    checked: display_tree,
                                    onChange: function onChange() {
                                        return setAttributes({ display_tree: display_tree === 1 ? 0 : 1 });
                                    }
                                }),
                                React.createElement(ToggleControl, {
                                    label: __('Display images tags'),
                                    checked: display_tag,
                                    onChange: function onChange() {
                                        return setAttributes({ display_tag: display_tag === 1 ? 0 : 1 });
                                    }
                                }),
                                React.createElement(SelectControl, {
                                    label: __('Columns'),
                                    value: columns,
                                    options: [{ label: 1, value: '1' }, { label: 2, value: '2' }, { label: 3, value: '3' }, { label: 4, value: '4' }, { label: 5, value: '5' }, { label: 6, value: '6' }, { label: 7, value: '7' }, { label: 8, value: '8' }, { label: 9, value: '9' }],
                                    onChange: function onChange(value) {
                                        return setAttributes({ columns: value });
                                    }
                                }),
                                React.createElement(SelectControl, {
                                    label: __('Gallery image size'),
                                    value: size,
                                    options: list_sizes,
                                    onChange: function onChange(value) {
                                        return setAttributes({ size: value });
                                    }
                                }),
                                React.createElement(SelectControl, {
                                    label: __('Lightbox size'),
                                    value: targetsize,
                                    options: list_sizes,
                                    onChange: function onChange(value) {
                                        return setAttributes({ targetsize: value });
                                    }
                                }),
                                React.createElement(SelectControl, {
                                    label: __('Action on click'),
                                    value: link,
                                    options: [{ label: __('Lightbox'), value: 'file' }, { label: __('Attachment Page'), value: 'post' }, { label: __('None'), value: 'none' }],
                                    onChange: function onChange(value) {
                                        return setAttributes({ link: value });
                                    }
                                }),
                                React.createElement(SelectControl, {
                                    label: __('Order by'),
                                    value: wpmf_orderby,
                                    options: [{ label: __('Custom'), value: 'post__in' }, { label: __('Random'), value: 'rand' }, { label: __('Title'), value: 'title' }, { label: __('Date'), value: 'date' }],
                                    onChange: function onChange(value) {
                                        return setAttributes({ wpmf_orderby: value });
                                    }
                                }),
                                React.createElement(SelectControl, {
                                    label: __('Order'),
                                    value: wpmf_order,
                                    options: [{ label: __('Ascending'), value: 'ASC' }, { label: __('Descending '), value: 'DESC' }],
                                    onChange: function onChange(value) {
                                        return setAttributes({ wpmf_order: value });
                                    }
                                })
                            )
                        )
                    ),
                    galleryId !== 0 && gallery_shortcode,
                    galleryId === 0 && React.createElement(
                        'button',
                        { className: 'components-button is-button is-default is-large aligncenter',
                            onClick: this.openModal },
                        wpmfgalleryblocks.l18n.btnopen
                    ),
                    this.state.isOpen ? React.createElement(
                        Modal,
                        {
                            className: 'wpmfGalleryModal',
                            title: wpmfgalleryblocks.l18n.gallery_title,
                            onRequestClose: this.closeModal },
                        React.createElement(FocusableIframe, {
                            src: wpmfgalleryblocks.vars.admin_gallery_page + ('&idblock=' + this.props.clientId + '&galleryId=' + galleryId + '&display_tree=' + display_tree + '&display_tag=' + display_tag)
                        })
                    ) : null
                );
            }
        }]);

        return WpmfGallery;
    }(Component);

    registerBlockType('wpmf/block-gallery', {
        title: wpmfgalleryblocks.l18n.gallery_title,
        icon: iconblock,
        category: 'common',
        keywords: [__('gallery'), __('file')],
        attributes: {
            galleryId: {
                type: 'number',
                default: 0
            },
            display_tree: {
                type: 'number',
                default: 0
            },
            display_tag: {
                type: 'number',
                default: 0
            },
            columns: {
                type: 'string',
                default: '3'
            },
            size: {
                type: 'string',
                default: 'medium'
            },
            targetsize: {
                type: 'string',
                default: 'large'
            },
            link: {
                type: 'string',
                default: 'file'
            },
            wpmf_orderby: {
                type: 'string',
                default: 'post__in'
            },
            wpmf_order: {
                type: 'string',
                default: 'ASC'
            },
            align: {
                type: 'string',
                default: 'center'
            }
        },
        edit: WpmfGallery,
        save: function save(_ref) {
            var attributes = _ref.attributes;
            var galleryId = attributes.galleryId,
                display_tree = attributes.display_tree,
                display_tag = attributes.display_tag,
                columns = attributes.columns,
                size = attributes.size,
                targetsize = attributes.targetsize,
                link = attributes.link,
                wpmf_orderby = attributes.wpmf_orderby,
                wpmf_order = attributes.wpmf_order;

            var gallery_shortcode = '[wpmfgallery';
            gallery_shortcode += ' gallery_id="' + galleryId + '"';
            gallery_shortcode += ' size="' + size + '"';
            gallery_shortcode += ' columns="' + columns + '"';
            gallery_shortcode += ' targetsize="' + targetsize + '"';
            gallery_shortcode += ' link="' + link + '"';
            gallery_shortcode += ' wpmf_orderby="' + wpmf_orderby + '"';
            gallery_shortcode += ' wpmf_order="' + wpmf_order + '"';
            gallery_shortcode += ' display_tree="' + display_tree + '"';
            gallery_shortcode += ' display_tag="' + display_tag + '"';
            gallery_shortcode += ']';
            return gallery_shortcode;
        },
        getEditWrapperProps: function getEditWrapperProps(attributes) {
            var align = attributes.align;

            var props = { 'data-resized': true };

            if ('left' === align || 'right' === align || 'center' === align) {
                props['data-align'] = align;
            }

            return props;
        }
    });
})(wp.i18n, wp.blocks, wp.element, wp.editor, wp.components);
