<?php
/* Prohibit direct script loading */
defined('ABSPATH') || die('No direct script access allowed!');
?>
<div id="new-gallery-popup" class="form_add_gallery white-popup wpmf_mfp-hide">
    <div class="layout_edit_left">
        <div class="fieldsrow wpmfleft">
            <label class="left_label"><?php esc_html_e('Gallery name', 'wp-media-folder-gallery-addon') ?></label>
            <input type="text" size="35" class="gallery_name"
                   placeholder="<?php esc_html_e('Title', 'wp-media-folder-gallery-addon') ?>">
            <?php
            $themes = array(
                'default'     => __('Default', 'wp-media-folder-gallery-addon'),
                'masonry'     => __('Masonry', 'wp-media-folder-gallery-addon'),
                'portfolio'   => __('Portfolio', 'wp-media-folder-gallery-addon'),
                'slider'      => __('Slider', 'wp-media-folder-gallery-addon'),
                'flowslide'   => __('Flow slide', 'wp-media-folder-gallery-addon'),
                'square_grid' => __('Square grid', 'wp-media-folder-gallery-addon'),
                'material'    => __('Material', 'wp-media-folder-gallery-addon')
            );
            ?>

            <label>
                <select class="gallery_theme" name="gallery_theme">
                    <option disabled
                            value="default"><?php esc_html_e('Theme', 'wp-media-folder-gallery-addon') ?></option>
                    <?php foreach ($themes as $key => $theme) : ?>
                        <option value="<?php echo esc_attr($key); ?>"><?php echo esc_html($theme); ?></option>
                    <?php endforeach; ?>
                </select>
            </label>

            <?php
            $dropdown_options = array(
                'show_option_none'  => __('Parent gallery', 'wp-media-folder-gallery-addon'),
                'option_none_value' => 0,
                'hide_empty'        => false,
                'hierarchical'      => true,
                'orderby'           => 'name',
                'taxonomy'          => WPMF_GALLERY_ADDON_TAXO,
                'class'             => 'wpmf-gallery-categories',
                'name'              => 'wpmf-gallery-categories',
                'selected'          => 0
            );
            wp_dropdown_categories($dropdown_options);
            ?>
            <a class="btn_create_gallery">
                <i class="material-icons icon_save_gallery">done</i>
                <input type="button" class="wpmfbtn wpmfstrtoupper" value="Save">
            </a>

            <a class="btn_edit_gallery">
                <i class="material-icons icon_save_gallery">done</i>
                <input type="button" class="wpmfbtn wpmfstrtoupper" value="Save">
            </a>
            <?php if ($type === 'iframe') : ?>
                <a class="a_btn_insert_gallery">
                    <i class="material-icons icon_insert_gallery">photo_album</i>
                    <input type="button" class="wpmfbtn btn_insert_gallery wpmfstrtoupper"
                           value="<?php esc_html_e('Insert', 'wp-media-folder-gallery-addon') ?>">
                </a>
            <?php endif; ?>
            <i class="material-icons btn_remove_img_gallery wpmf_open_qtip"
               data-for="<?php esc_html_e('Delete selected images', 'wp-media-folder-gallery-addon') ?>">delete</i>
            <input type="hidden" class="id_gallery" value="0">
            <input type="hidden" class="current_theme_gallery" value="default_theme">
            <span class="spinner"></span>
        </div>
        <?php if ($type === 'iframe') : ?>
            <div class="fieldsrow wpmfleft">
                <div class="row_glr_settings">
                    <label class="left_label wpmf_open_qtip"
                           data-for="<?php esc_html_e('Load gallery tree navigation', 'wp-media-folder-gallery-addon') ?>">
                        <?php esc_html_e('Gallery navigation', 'wp-media-folder-gallery-addon') ?>
                    </label>
                    <div class="switch-optimization">
                        <label class="switch switch-optimization">
                            <?php if (isset($display_tree) && (int) $display_tree === 1) : ?>
                                <input type="checkbox" checked class="gallery_display_tree" value="1">
                            <?php else : ?>
                                <input type="checkbox" class="gallery_display_tree" value="1">
                            <?php endif; ?>
                            <span class="slider round"></span>
                        </label>
                    </div>
                </div>
                <div class="row_glr_settings">
                    <label class="left_label wpmf_open_qtip"
                           data-for="<?php esc_html_e('Display image
                            tags as display filter', 'wp-media-folder-gallery-addon') ?>">
                        <?php esc_html_e('Display images tags', 'wp-media-folder-gallery-addon') ?></label>
                    <div class="switch-optimization">
                        <label class="switch switch-optimization">
                            <?php if (isset($display_tag) && (int) $display_tag === 1) : ?>
                                <input type="checkbox" checked class="gallery_display_tag" value="1">
                            <?php else : ?>
                                <input type="checkbox" class="gallery_display_tag" value="1">
                            <?php endif; ?>
                            <span class="slider round"></span>
                        </label>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <?php
        global $pagenow;

        ?>
        <div class="fieldsrow">
            <label class="left_label"
                   style="line-height: 36px"><?php esc_html_e('Add more images', 'wp-media-folder-gallery-addon') ?></label>
            <?php if ($pagenow === 'upload.php') : ?>
                <input type="button" class="wpmfbtn btn_import_image_fromwp wpmfstrtoupper"
                       value="<?php esc_html_e('Import from wordpress', 'wp-media-folder-gallery-addon') ?>">
                <?php
            else :
                wp_enqueue_script('thickbox');
                wp_enqueue_style('thickbox');
                ?>

                <a href="upload.php?page=media-folder-galleries&view=framemedia&width=0&height=0&noheader=1"
                   class="thickbox wpmfbtn btn_modal_import_image_fromwp wpmfstrtoupper">
                    <?php esc_html_e('Import from wordpress', 'wp-media-folder-gallery-addon') ?>
                </a>
            <?php endif; ?>
            <form id="wpmfglr_form_upload" method="post" action="<?php echo esc_html(admin_url('admin-ajax.php')) ?>"
                  enctype="multipart/form-data">
                <input class="hide" type="file" name="wpmf_gallery_file[]" multiple id="wpmf_gallery_file">
                <input type="hidden" name="wpmf_gallery_nonce"
                       value="<?php echo esc_html(wp_create_nonce('wpmf_gallery_nonce')) ?>">
                <input type="button" class="wpmfbtn btn_upload_from_pc wpmfstrtoupper"
                       value="<?php esc_html_e('Upload from computer', 'wp-media-folder-gallery-addon') ?>">
                <input type="hidden" name="action" value="wpmfgallery">
                <input type="hidden" name="up_gallery_id" class="up_gallery_id" value="0">
                <input type="hidden" name="task" value="gallery_uploadfile">
            </form>
            <div id="wpmf_progress_upload">
                <div id="wpmf_bar"></div>
                <div id="wpmf_percent">0%</div>
            </div>
            <div class="wpmf_process_full">
                <div class="wpmf_process" data-w="0"></div>
            </div>
        </div>

        <div class="fieldsrow">
            <label class="full_label"
                   style="line-height: 36px">
                <?php esc_html_e('Images gallery selection', 'wp-media-folder-gallery-addon') ?>
            </label>
            <ul class="wpmf_gallery_selection" id="wpmf_gallery_selection">

            </ul>
            <ul class="wpmf_gallery_newselection">

            </ul>
            <?php
            $limit = get_option('wpmf_gallery_img_per_page');
            require_once(WPMF_GALLERY_ADDON_PLUGIN_DIR . '/admin/pages/screen_per_page.php');
            ?>
        </div>
    </div>
</div>