<?php
/*
  Plugin Name: WP Media folder Addon
  Plugin URI: http://www.joomunited.com
  Description: WP media Folder Addon is a WordPress plugin that enhance
 the WordPress media manager by adding a folder manager inside.
  Author: پرشین اسکریپت
  Version: 2.1.8
  Text Domain: wpmfAddon
  Domain Path: /languages
  Author URI: http://www.persianscript.ir
  Licence : GNU General Public License version 2 or later; http://www.gnu.org/licenses/gpl-2.0.html
  Copyright : Copyright (C) 2014 JoomUnited (http://www.joomunited.com). All rights reserved.
 */
// Prohibit direct script loading
defined('ABSPATH') || die('No direct script access allowed!');
//Check plugin requirements
if (version_compare(PHP_VERSION, '5.3', '<')) {
    if (!function_exists('wpmfAddonDisablePlugin')) {
        /**
         * Deactivate plugin
         *
         * @return void
         */
        function wpmfAddonDisablePlugin()
        {
            /**
             * Filter check user capability to do an action
             *
             * @param boolean The current user has the given capability
             * @param string  Action name
             *
             * @return boolean
             *
             * @ignore Hook already documented
             */
            $wpmf_capability = apply_filters('wpmf_user_can', current_user_can('activate_plugins'), 'activate_plugins');
            if ($wpmf_capability && is_plugin_active(plugin_basename(__FILE__))) {
                deactivate_plugins(__FILE__);
                unset($_GET['activate']);
            }
        }
    }

    if (!function_exists('wpmfAddonShowError')) {
        /**
         * Show error
         *
         * @return void
         */
        function wpmfAddonShowError()
        {
            echo '<div class="error"><p><strong>WP Media Folder Addon</strong>
 need at least PHP 5.3 version, please update php before installing the plugin.</p></div>';
        }
    }

    //Add actions
    add_action('admin_init', 'wpmfAddonDisablePlugin');
    add_action('admin_notices', 'wpmfAddonShowError');

    //Do not load anything more
    return;
}

/**
 * Load Jutranslation
 *
 * @return void
 */
function wpmfAddonsInit()
{
    if (!class_exists('\Joomunited\WPMFADDON\JUCheckRequirements')) {
        require_once(trailingslashit(dirname(__FILE__)) . 'requirements.php');
    }

    if (class_exists('\Joomunited\WPMFADDON\JUCheckRequirements')) {
        // Plugins name for translate
        $args = array(
            'plugin_name' => esc_html__('WP Media Folder Addon', 'wpmfAddon'),
            'plugin_path' => 'wp-media-folder-addon/wp-media-folder-addon.php',
            'plugin_textdomain' => 'wpmfAddon',
            'requirements' => array(
                'plugins'     => array(
                    array(
                        'name' => 'WP Media Folder',
                        'path' => 'wp-media-folder/wp-media-folder.php',
                        'requireVersion' => '4.7.2'
                    )
                ),
                'php_version' => '5.3',
                'php_modules' => array(
                    'curl' => 'warning'
                )
            )
        );
        $wpmfCheck = call_user_func('\Joomunited\WPMFADDON\JUCheckRequirements::init', $args);

        if (!$wpmfCheck['success']) {
            // Do not load anything more
            unset($_GET['activate']);
            return;
        }
    }
}

/**
 * Get plugin path
 *
 * @return string
 */
function wpmfAddons_getPath()
{
    return 'wp-media-folder-addon/wp-media-folder-addon.php';
}

//JUtranslation
add_filter('wpmf_get_addons', function ($addons) {
    $addon                          = new stdClass();
    $addon->main_plugin_file        = __FILE__;
    $addon->extension_name          = 'WP Media Folder Addon';
    $addon->extension_slug          = 'wpmf-addon';
    $addon->text_domain             = 'wpmfAddon';
    $addon->language_file           = plugin_dir_path(__FILE__) . 'languages' . DIRECTORY_SEPARATOR . 'wpmfAddon-en_US.mo';
    $addons[$addon->extension_slug] = $addon;
    return $addons;
});

add_action('init', function () {
    load_plugin_textdomain(
        'wpmfAddon',
        false,
        dirname(plugin_basename(__FILE__)) . DIRECTORY_SEPARATOR . 'languages' . DIRECTORY_SEPARATOR
    );
}, 1);

if (!defined('WPMFAD_PLUGIN_DIR')) {
    define('WPMFAD_PLUGIN_DIR', plugin_dir_path(__FILE__));
}

define('WPMFAD_PLUGIN_URL', plugin_dir_url(__FILE__));
define('WPMFAD_URL', plugin_dir_url(__FILE__));
define('WPMFAD_VERSION', '2.1.8');
require_once(ABSPATH . 'wp-admin/includes/plugin.php');
require_once(WPMFAD_PLUGIN_DIR . '/class/wpmfAddonGoogleAdmin.php');
$wpmfgoogleaddon = new WpmfAddonGoogle;
require_once(WPMFAD_PLUGIN_DIR . '/class/wpmfAddonDropboxAdmin.php');
$wpmfdropboxaddon = new WpmfAddonDropboxAdmin;
require_once(WPMFAD_PLUGIN_DIR . '/class/wpmfAddonOneDriveAdmin.php');
$wpmfonedriveaddon = new WpmfAddonOneDriveAdmin;

require_once(WPMFAD_PLUGIN_DIR . '/class/wpmfOneDrive.php');
$onedriveDrive = new WpmfAddonOneDrive();

add_action('wp_enqueue_scripts', 'wpmfAddonFrontStyle');
/**
 * Load scripts and style
 *
 * @return void
 */
function wpmfAddonFrontStyle()
{
    wp_enqueue_style(
        'wpmfAddonFrontStyle',
        WPMFAD_PLUGIN_URL . '/assets/css/front.css',
        array(),
        WPMFAD_VERSION
    );
}


// phpcs:disable WordPress.Security.NonceVerification.NoNonceVerification -- No action, nonce is not required
if (!empty($_GET['code'])) {
    $createToken = $onedriveDrive->createToken($_GET['code']);
}

if (isset($_GET['task']) && $_GET['task'] === 'wpmf') {
    if (isset($_GET['function'])) {
        switch ($_GET['function']) {
            case 'wpmf_authenticated':
                // phpcs:enable
                $wpmfgoogleaddon->ggAuthenticated();
                break;

            case 'wpmf_gglogout':
                $wpmfgoogleaddon->ggLogout();
                break;

            case 'wpmf_dropboxlogout':
                $wpmfdropboxaddon->dbxLogout();
                break;
        }
    }
}

/**
 * Config section
 */
if (!defined('JU_BASE')) {
    define('JU_BASE', 'https://www.joomunited.com/');
}

$remote_updateinfo = JU_BASE . 'juupdater_files/wp-media-folder-addon.json';
//end config

require 'juupdater/juupdater.php';
$UpdateChecker = Jufactory::buildUpdateChecker(
    $remote_updateinfo,
    __FILE__
);
