<?php
// getting rid of float
$class[] = 'gallery-' . $display;
$class[] = 'galleryid-' . $id;
$class[] = 'gallery-columns-' . $columns;
$class[] = 'gallery-size-' . $size_class;
$class[] = 'wpmf-gallery-bottomspace-default';
$class[] = 'wpmf-gallery-clear';
$class   = implode(' ', $class);

$padding_masonry = get_option('wpmf_padding_masonry');
if (!isset($padding_masonry) && $padding_masonry === '') {
    $padding_masonry = 5;
}

$lists      = array();
$lists_full = array();
$j          = 0;
foreach ($attachments as $img_id => $attachment) {
    $image_meta = wp_get_attachment_metadata($img_id);
    if (empty($image_meta['height']) || empty($image_meta['width'])) {
        continue;
    }
    $link_target = get_post_meta($attachment->ID, '_gallery_link_target', true);
    $img_tags    = get_post_meta($attachment->ID, 'wpmf_img_tags', true);
    if (!empty($link) && ('file' === $link || 'post' === $link)) {
        $image_output = $this->galleryGetAttachmentLink($img_id, $size, false, $targetsize, $customlink, $link_target);
    } elseif (!empty($link) && 'none' === $link) {
        if (get_post_meta($img_id, _WPMF_GALLERY_PREFIX . 'custom_image_link', true) !== '') {
            $image_output = $this->galleryGetAttachmentLink($img_id, $size, false, $targetsize, $customlink, $link_target);
        } else {
            $image_output = wp_get_attachment_image($img_id, $size, false, array('data-type' => 'wpmfgalleryimg'));
        }
    } else {
        $image_output = $this->galleryGetAttachmentLink($img_id, $size, true, 'large', false, $link_target);
    }
    $image_meta  = wp_get_attachment_metadata($img_id);
    $orientation = '';
    if (isset($image_meta['height'], $image_meta['width'])) {
        $orientation = ($image_meta['height'] > $image_meta['width']) ? 'portrait' : 'landscape';
        $item        = '<div class="wpmf-gallery-item" data-tags="' . $img_tags . '">';
        $item        .= '<div class="gallery-icon ' . $orientation . '">';
        $item        .= $image_output;

        if ((int) $social_sharing === 1) {
            if (!empty($facebook) || !empty($twitter) || !empty($google) || !empty($instagram) || !empty($pinterest)) {
                $item .= "<div class='hover_img hover_default_theme'>";
                $item .= '<div class="wpmfglr_social">';
                if (!empty($facebook)) {
                    $item .= '<a href="' . $facebook . '"  target="_blank">
<span class="dashicons dashicons-facebook-alt"></span></a>';
                }

                if (!empty($twitter)) {
                    $item .= '<a href="' . $twitter . '"  target="_blank">
<span class="dashicons dashicons-twitter"></span></a>';
                }

                if (!empty($google)) {
                    $item .= '<a href="' . $google . '"  target="_blank">
<span class="dashicons dashicons-googleplus"></span></a>';
                }

                if (!empty($instagram)) {
                    $item .= '<a href="' . $instagram . '"  target="_blank">
<img class="glrsocial_image" src="' . WPMF_GALLERY_ADDON_PLUGIN_URL . '/assets/images/instagram.png" /></a>';
                }

                if (!empty($pinterest)) {
                    $item .= '<a href="' . $pinterest . '"  target="_blank">
<img class="glrsocial_image" src="' . WPMF_GALLERY_ADDON_PLUGIN_URL . '/assets/images/pinterest.png" /></a>';
                }

                $item .= '</div></div>';
            }
        }

        $item .= '</div></div>';

        if (isset($gallery_configs['progressive_loading']) && (int) $gallery_configs['progressive_loading'] === 0) {
            $lists[] = $item;
        } else {
            if ($j >= 10) {
                $lists[] = $item;
            }
            $j ++;
        }

        $lists_full[] = $item;
    }
}

$json_lists = esc_html(json_encode($lists));
echo '<div class="wpmf-gallerys wpmf-gallerys-addon" data-id="' . esc_html($id) . '">';
echo '<div data-id="' . esc_html($id) . '" data-gutter-width="' . esc_html($padding_masonry) . '"
 data-wpmfcolumns="' . esc_html($columns) . '" data-item="' . esc_html($json_lists) . '" class="' . esc_html($class) . '">';
foreach ($lists_full as $i => $list) {
    if (isset($gallery_configs['progressive_loading']) && (int) $gallery_configs['progressive_loading'] === 0) {
        echo $list; // phpcs:ignore WordPress.Security.EscapeOutput -- Content already escaped in the method
    } else {
        if ($i < 10) {
            echo $list; // phpcs:ignore WordPress.Security.EscapeOutput -- Content already escaped in the method
        }
    }
}
echo "</div></div>\n";
