(function (wpI18n, wpBlocks, wpElement, wpEditor, wpComponents) {
    const {__} = wpI18n;
    const {Component, Fragment} = wpElement;
    const {registerBlockType} = wpBlocks;
    const {BlockControls, BlockAlignmentToolbar, InspectorControls} = wpEditor;
    const {PanelBody, Modal, FocusableIframe, IconButton, Toolbar, SelectControl, ToggleControl} = wpComponents;

    const el = wpElement.createElement;
    const iconblock = el('svg', {width: 24, height: 24},
        el('path', {d: "M18 2H6c-1.1 0-2 .9-2 2v16c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-7 2v5l-1-.75L9 9V4h2zm7 16H6V4h1v9l3-2.25L13 13V4h5v16zm-6.72-2.04L9.5 15.81 7 19h10l-3.22-4.26z"})
    );

    class WpmfGallery extends Component {
        constructor() {
            super(...arguments);
            this.state = {
                isOpen: false
            };

            this.openModal = this.openModal.bind(this);
            this.closeModal = this.closeModal.bind(this);
            this.addEventListener = this.addEventListener.bind(this);
            this.componentDidMount = this.componentDidMount.bind(this);
        }

        openModal() {
            if (!this.state.isOpen) {
                this.setState({isOpen: true});
            }
        }

        closeModal() {
            if (this.state.isOpen) {
                this.setState({isOpen: false});
            }
        }

        addEventListener(e) {
            if (!e.data.galleryId) {
                return;
            }

            if (e.data.type !== 'wpmfgalleryinsert') {
                return;
            }

            if (e.data.idblock !== this.props.clientId) {
                return;
            }

            this.setState({
                isOpen: false
            });

            const {attributes, setAttributes} = this.props;
            const {galleryId} = attributes;
            let themes_setting = wpmfgalleryblocks.vars.themes_setting;
            let theme = 'default';
            if (typeof themes_setting[e.data.galleryId] !== "undefined") {
                theme = themes_setting[e.data.galleryId].theme
            }
            let settings = wpmfgalleryblocks.vars.gallery_configs.theme[theme + '_theme'];
            if (galleryId === 0) {
                setAttributes({
                    galleryId: e.data.galleryId,
                    display_tree: e.data.display_tree,
                    display_tag: e.data.display_tag,
                    columns: parseInt(settings.columns),
                    link: settings.link,
                    wpmf_order: settings.order,
                    wpmf_orderby: settings.orderby,
                    size: settings.size,
                    targetsize: settings.targetsize
                });
            } else {
                setAttributes({
                    galleryId: e.data.galleryId,
                    display_tree: e.data.display_tree,
                    display_tag: e.data.display_tag
                });
            }
        }

        componentDidMount() {
            window.addEventListener("message", this.addEventListener, false);
        }

        render() {
            const {attributes, setAttributes} = this.props;
            const {
                align,
                galleryId,
                display_tree,
                display_tag,
                columns,
                size,
                targetsize,
                link,
                wpmf_orderby,
                wpmf_order
            } = attributes;

            const list_sizes = Object.keys(wpmfgalleryblocks.vars.sizes).map((key, label) => {
                return {
                    label: wpmfgalleryblocks.vars.sizes[key],
                    value: key
                }
            });
            let gallery_shortcode = '[wpmfgallery';
            gallery_shortcode += ' gallery_id="' + galleryId + '"';
            gallery_shortcode += ' size="' + size + '"';
            gallery_shortcode += ' columns="' + columns + '"';
            gallery_shortcode += ' targetsize="' + targetsize + '"';
            gallery_shortcode += ' link="' + link + '"';
            gallery_shortcode += ' wpmf_orderby="' + wpmf_orderby + '"';
            gallery_shortcode += ' wpmf_order="' + wpmf_order + '"';
            gallery_shortcode += ' display_tree="' + display_tree + '"';
            gallery_shortcode += ' display_tag="' + display_tag + '"';
            gallery_shortcode += ']';

            return (
                <Fragment>
                    {galleryId !== 0 && (
                        <Fragment>
                            <BlockControls>
                                <Toolbar>
                                    <BlockAlignmentToolbar value={align}
                                                           onChange={(align) => setAttributes({align: align})}/>
                                    <IconButton
                                        className="components-toolbar__control"
                                        label={wpmfgalleryblocks.l18n.edit}
                                        icon={'edit'}
                                        onClick={() => this.setState({isOpen: true})}
                                    />

                                    <IconButton
                                        className="components-toolbar__control"
                                        label={wpmfgalleryblocks.l18n.remove}
                                        icon={'no'}
                                        onClick={() => setAttributes({galleryId: 0})}
                                    />
                                </Toolbar>
                            </BlockControls>
                            <InspectorControls>
                                <PanelBody title={__('Gallery Settings')}>
                                    <ToggleControl
                                        label={__('Gallery navigation')}
                                        checked={display_tree}
                                        onChange={() => setAttributes({display_tree: (display_tree === 1) ? 0 : 1})}
                                    />

                                    <ToggleControl
                                        label={__('Display images tags')}
                                        checked={display_tag}
                                        onChange={() => setAttributes({display_tag: (display_tag === 1) ? 0 : 1})}
                                    />
                                    <SelectControl
                                        label={__('Columns')}
                                        value={columns}
                                        options={[
                                            {label: 1, value: '1'},
                                            {label: 2, value: '2'},
                                            {label: 3, value: '3'},
                                            {label: 4, value: '4'},
                                            {label: 5, value: '5'},
                                            {label: 6, value: '6'},
                                            {label: 7, value: '7'},
                                            {label: 8, value: '8'},
                                            {label: 9, value: '9'},
                                        ]}
                                        onChange={(value) => setAttributes({columns: value})}
                                    />

                                    <SelectControl
                                        label={__('Gallery image size')}
                                        value={size}
                                        options={list_sizes}
                                        onChange={(value) => setAttributes({size: value})}
                                    />

                                    <SelectControl
                                        label={__('Lightbox size')}
                                        value={targetsize}
                                        options={list_sizes}
                                        onChange={(value) => setAttributes({targetsize: value})}
                                    />

                                    <SelectControl
                                        label={__('Action on click')}
                                        value={link}
                                        options={[
                                            {label: __('Lightbox'), value: 'file'},
                                            {label: __('Attachment Page'), value: 'post'},
                                            {label: __('None'), value: 'none'},
                                        ]}
                                        onChange={(value) => setAttributes({link: value})}
                                    />

                                    <SelectControl
                                        label={__('Order by')}
                                        value={wpmf_orderby}
                                        options={[
                                            {label: __('Custom'), value: 'post__in'},
                                            {label: __('Random'), value: 'rand'},
                                            {label: __('Title'), value: 'title'},
                                            {label: __('Date'), value: 'date'}
                                        ]}
                                        onChange={(value) => setAttributes({wpmf_orderby: value})}
                                    />

                                    <SelectControl
                                        label={__('Order')}
                                        value={wpmf_order}
                                        options={[
                                            {label: __('Ascending'), value: 'ASC'},
                                            {label: __('Descending '), value: 'DESC'}
                                        ]}
                                        onChange={(value) => setAttributes({wpmf_order: value})}
                                    />
                                </PanelBody>
                            </InspectorControls>
                        </Fragment>
                    )}

                    {(galleryId !== 0) &&
                    gallery_shortcode
                    }
                    {galleryId === 0 &&
                    <button className="components-button is-button is-default is-large aligncenter"
                            onClick={this.openModal}>{wpmfgalleryblocks.l18n.btnopen}</button>}
                    {this.state.isOpen ?
                        <Modal
                            className="wpmfGalleryModal"
                            title={wpmfgalleryblocks.l18n.gallery_title}
                            onRequestClose={this.closeModal}>
                            <FocusableIframe
                                src={wpmfgalleryblocks.vars.admin_gallery_page + `&idblock=${this.props.clientId}&galleryId=${galleryId}&display_tree=${display_tree}&display_tag=${display_tag}`}
                            />
                        </Modal>
                        : null}
                </Fragment>
            );
        }
    }

    registerBlockType('wpmf/block-gallery', {
        title: wpmfgalleryblocks.l18n.gallery_title,
        icon: iconblock,
        category: 'common',
        keywords: [
            __('gallery'),
            __('file')
        ],
        attributes: {
            galleryId: {
                type: 'number',
                default: 0
            },
            display_tree: {
                type: 'number',
                default: 0
            },
            display_tag: {
                type: 'number',
                default: 0
            },
            columns: {
                type: 'string',
                default: '3'
            },
            size: {
                type: 'string',
                default: 'medium'
            },
            targetsize: {
                type: 'string',
                default: 'large'
            },
            link: {
                type: 'string',
                default: 'file'
            },
            wpmf_orderby: {
                type: 'string',
                default: 'post__in'
            },
            wpmf_order: {
                type: 'string',
                default: 'ASC'
            },
            align: {
                type: 'string',
                default: 'center'
            }
        },
        edit: WpmfGallery,
        save: ({attributes}) => {
            const {galleryId, display_tree, display_tag, columns, size, targetsize, link, wpmf_orderby, wpmf_order} = attributes;
            let gallery_shortcode = '[wpmfgallery';
            gallery_shortcode += ' gallery_id="' + galleryId + '"';
            gallery_shortcode += ' size="' + size + '"';
            gallery_shortcode += ' columns="' + columns + '"';
            gallery_shortcode += ' targetsize="' + targetsize + '"';
            gallery_shortcode += ' link="' + link + '"';
            gallery_shortcode += ' wpmf_orderby="' + wpmf_orderby + '"';
            gallery_shortcode += ' wpmf_order="' + wpmf_order + '"';
            gallery_shortcode += ' display_tree="' + display_tree + '"';
            gallery_shortcode += ' display_tag="' + display_tag + '"';
            gallery_shortcode += ']';
            return gallery_shortcode;
        },
        getEditWrapperProps(attributes) {
            const {align} = attributes;
            const props = {'data-resized': true};

            if ('left' === align || 'right' === align || 'center' === align) {
                props['data-align'] = align;
            }

            return props;
        }
    });
})(wp.i18n, wp.blocks, wp.element, wp.editor, wp.components);