(function ($) {
    $(function () {
        $('.wpfm-tabs-trigger').click(function () {
            $('.wpfm-tabs-trigger').removeClass('nav-tab-active');
            $('.wpfm-tab-contents').hide();
            $(this).addClass('nav-tab-active');
            var board_id = 'tab-' + $(this).attr('id');
            $('body').find('#' + board_id).show();
        });

        /** 
         * Menu lists pages,post,category options Slide Toggle 
         */
        $('.wpfm-menu-list-field').children('.wpfm-field-header').click(function () {
            $(".wpfm-list-inner-content").not($(this).toggleClass('wpfm-open-menu-list').next('.wpfm-list-inner-content').slideToggle(300)).hide(300);
            $(this).find('i').toggleClass('fa-sort-down fa-short-up');
        });

        /** 
         * Show hide tooltip text field
         */
        $('body').on('click', '#wpfm-tooltip-show-hide', function () {
            if ($(this).is(':checked')) {
                $(this).parents('.wpfm-menu-item').find('.wpfm-edit-menu-tooltip-wrap').slideDown(200);
            } else {
                $(this).parents('.wpfm-menu-item').find('.wpfm-edit-menu-tooltip-wrap').slideUp(200);
            }
        });

        /** 
         * Show hide modal Popup Textarea field 
         */
        $('body').on('click', '#wpfm-field-modal-pp-target', function () {
            if ($(this).is(':checked')) {
                $(this).parents('.wpfm-menu-item').find('.wpfm-menu-popup-content-wrap').slideDown(200);
            } else {
                $(this).parents('.wpfm-menu-item').find('.wpfm-menu-popup-content-wrap').slideUp(200);
            }
        });

        /** 
         * Show hide User control 
         */
        $('body').on('change', '.wpfm-icon-user-type', function () {
            var current_value = $(this).val();
            if (current_value == 'logged-in') {
                $(this).parents('.wpfm-menu-item').find('.wpfm-user-role-checkbox').slideDown(200);
            } else {
                $(this).parents('.wpfm-menu-item').find('.wpfm-user-role-checkbox').slideUp(200);
            }
        });

        /** Menu option checkbox click for page function */
        $('.wpfm-menu-list-field').find(".wpfm-submit-add-to-menu").click(function (e) {
            e.preventDefault();
            var submit_id = $(this).attr('id');
            var submit_field_data = $(this).attr('submit-field-val');

            if (submit_id == 'wpfm-page-add-to-menu' || submit_id == 'wpfm-submit-posttype-post' || submit_id == 'wpfm-submit-posttype-category') {
                var checkbox_length = $(this).parents('.wpfm-menu-list-field').find('input[name="wpfm-add-check[]"]:checked').length;
                if (checkbox_length != 0) {
                    $('.wpfm-add-check').each(function () {
                        if ($(this).is(':checked')) {
                            var checkbox_value = $(this).val();
                            var field_data = $(this).attr('field-data');
                            $('#page-id-values').val(checkbox_value);
                            var form_key_count = $('.wpfm-menu-count').val();
                            form_key_count++;
                            $('.wpfm-sortable-menu-field').find('.wpfm-menu-count').val(form_key_count);
                            var page_value = $('#page-id-values').val();
                            $.ajax({
                                url: wpfm_backend_js_params.ajax_url,
                                data: {
                                    submit_field_data: submit_field_data,
                                    field_data: field_data,
                                    page_value: page_value,
                                    _wpnonce: wpfm_backend_js_params.ajax_nonce,
                                    action: 'wpfm_pull_data_contents'
                                },
                                type: 'post',
                                beforeSend: function () {
                                    $('.wpfm-view-wrap').show();
                                },
                                success: function (response) {
                                    $('.wpfm-menu-temp-holder').html(response);
                                    $('.wpfm-menu-temp-holder input').each(function () {
                                        var name_attr = $(this).attr('name');
                                        if (name_attr) {
                                            name_attr = name_attr.replace('menu_id', form_key_count);
                                            $(this).attr('name', name_attr);
                                        }
                                    });
                                    $('.wpfm-menu-temp-holder select').each(function () {
                                        var name_attr2 = $(this).attr('name');
                                        if (name_attr2) {
                                            name_attr2 = name_attr2.replace('menu_id', form_key_count);
                                            $(this).attr('name', name_attr2);
                                        }
                                    });
                                    $('.wpfm-menu-temp-holder textarea').each(function () {
                                        var name_attr2 = $(this).attr('name');
                                        if (name_attr2) {
                                            name_attr2 = name_attr2.replace('menu_id', form_key_count);
                                            $(this).attr('name', name_attr2);
                                        }
                                    });
                                    $('.wpfm-menu-temp-holder .wpfm-icon-picker').each(function () {
                                        var name_attr3 = $(this).attr('id');
                                        if (name_attr3) {
                                            $(this).attr('id', 'wpfm-icon-picker-icon_' + form_key_count);
                                        }
                                    });
                                    $('.wpfm-menu-temp-holder #wpfm-menu-icon-div').each(function () {
                                        var name_attr4 = $(this).attr('data-target');
                                        if (name_attr4) {
                                            $(this).attr('data-target', '#wpfm-icon-picker-icon_' + form_key_count);
                                        }
                                    });

                                    var html_fields = $('.wpfm-menu-temp-holder').html();
                                    $('.wpfm-sortable-menu-field').append(html_fields).show('slow');
                                    $('.wpfm-sortable-menu-field .wpfm-colorpicker-trigger').wpColorPicker();
                                },
                                complete: function () {
                                    $(".wpfm-add-page-fields")[0].reset();
                                    $('.wpfm-view-wrap').hide();
                                    $('.wpfm-menu-temp-holder').html('');
                                }
                            });
                        }
                    });
                }
            } else if (submit_id == 'wpfm-submit-posttype-custom-link') {
                var custom_link_name = $('input[name="wpfm_custom_link_text"]').val();
                var custom_link_url = $('input[name="wpfm_custom_link_url"]').val();
                var custom_link_field_data = $(this).attr('field-data');
                var form_key_count = $('.wpfm-menu-count').val();
                form_key_count++;
                $('.wpfm-sortable-menu-field').find('.wpfm-menu-count').val(form_key_count);
                if (custom_link_url == '' || custom_link_name == '') {
                    $('input[name="wpfm_custom_link_url"], input[name="wpfm_custom_link_text"]').css("border-color", "red");
                } else {
                    $('input[name="wpfm_custom_link_url"], input[name="wpfm_custom_link_text"]').css("border-color", "#ddd");
                    if (custom_link_name != '' && custom_link_url != '') {
                        $.ajax({
                            url: wpfm_backend_js_params.ajax_url,
                            data: {
                                submit_field_data: submit_field_data,
                                custom_link_name: custom_link_name,
                                custom_link_url: custom_link_url,
                                custom_link_field_data: custom_link_field_data,
                                _wpnonce: wpfm_backend_js_params.ajax_nonce,
                                action: 'wpfm_pull_data_contents'
                            },
                            type: 'post',
                            beforeSend: function () {
                                $('.wpfm-view-wrap').show();
                            },
                            success: function (response) {
                                $('.wpfm-menu-temp-holder').html(response);
                                $('.wpfm-menu-temp-holder input').each(function () {
                                    var name_attr = $(this).attr('name');
                                    if (name_attr) {
                                        name_attr = name_attr.replace('menu_id', form_key_count);
                                        $(this).attr('name', name_attr);
                                    }
                                });
                                $('.wpfm-menu-temp-holder select').each(function () {
                                    var name_attr2 = $(this).attr('name');
                                    if (name_attr2) {
                                        name_attr2 = name_attr2.replace('menu_id', form_key_count);
                                        $(this).attr('name', name_attr2);
                                    }
                                });
                                $('.wpfm-menu-temp-holder textarea').each(function () {
                                    var name_attr2 = $(this).attr('name');
                                    if (name_attr2) {
                                        name_attr2 = name_attr2.replace('menu_id', form_key_count);
                                        $(this).attr('name', name_attr2);
                                    }
                                });
                                $('.wpfm-menu-temp-holder .wpfm-icon-picker').each(function () {
                                    var name_attr3 = $(this).attr('id');
                                    if (name_attr3) {
                                        $(this).attr('id', 'wpfm-icon-picker-icon_' + form_key_count);
                                    }
                                });
                                $('.wpfm-menu-temp-holder #wpfm-menu-icon-div').each(function () {
                                    var name_attr4 = $(this).attr('data-target');
                                    if (name_attr4) {
                                        $(this).attr('data-target', '#wpfm-icon-picker-icon_' + form_key_count);
                                    }
                                });
                                var html_fields = $('.wpfm-menu-temp-holder').html();
                                $('.wpfm-sortable-menu-field').append(html_fields).show('slow');
                                $('.wpfm-sortable-menu-field .wpfm-colorpicker-trigger').wpColorPicker();
                            },
                            complete: function () {
                                $(".wpfm-add-page-fields")[0].reset();
                                $('.wpfm-view-wrap').hide();
                                $('.wpfm-menu-temp-holder').html('');
                            }
                        });
                    }
                }
            }
        });

        /** Slide toggle for menu inner fields */
        $('.wpfm-sortable-menu-field').on('click', 'span.wpfm-ind-menu-toggle-icon', function () {
            $(this).parents().children('div[id^="wpfm-menu-item-settings"]').slideToggle(300);
            $(this).find('i').toggleClass('fa-sort-down fa-sort-up');
            $(this).parents().children('li.wpfm-menu-item').toggleClass('wpfm-open-menu-div');
            $('.icon-picker').iconPicker();
        });

        /** Delete Menu when clicked remove */
        $('.wpfm-sortable-menu-field').on("click", ".wpfm-remove-menu", function (e) {
            e.preventDefault();
            if (confirm('Are you sure you want to delete? All of it\'s associated settings will also be deleted.')) {
                $(this).parents('ul.wpfm-menu').fadeOut(200, function () {
                    $(this).remove();
                });
            }
            return false;
        });

        /** Menu icon color selector show hide */
        $('body').on('change', '.wpfm-icon-color-type', function () {
            if ($(this).val() == 'custom') {
                $(this).parents('.wpfm-menu-item').find('.wpfm-menu-icon-color-setting').slideDown(200);
            } else {
                $(this).parents('.wpfm-menu-item').find('.wpfm-menu-icon-color-setting').slideUp(200);
            }
        });

        /** Icon picker initialization for Custom Template */
        $(".icon-picker").iconPicker();

        /** Sortable initialization */
        $('.wpfm-sortable-menu-field').sortable({
            containment: "parent",
            cursor: 'move',
            revert: true,
            axis: 'y',
            opacity: 0.9
        });

        /** Display tooltip options on show_hide option */
        $('body').on('change', '.wpfm-display-menu-option', function () {
            if ($(this).val() == 'page-specific') {
                $('.menu-option-select-specific-page').slideDown(200);
            } else {
                $('.menu-option-select-specific-page').slideUp(200);
            }
        });

        /** show hide template number according to custom template selected */
        $('body').on('change', '#wpfm-menu-type', function () {
            if ($(this).val() == 'buildin') {
                $('#buildin-temple-listing').slideDown(200);
                $('#wpfm-custom-template-type').slideUp(100);
            } else {
                $('#buildin-temple-listing').slideUp(200);
                $('#wpfm-custom-template-type').slideDown(100);
            }
        });

        /** show hide custom icon field according to select option selected */
        $('body').on('change', '.wpfm-icon-type', function () {
            if ($(this).val() == 'default') {
                $(this).parents('.wpfm-menu-item').find('#wpfm-field-add-custom-menu-icons').slideUp(100);
                $(this).parents('.wpfm-menu-item').find('#wpfm-field-add-menu-icons').slideDown(200);
                $(this).parents('.wpfm-menu-item').find('#wpfm-field-add-custom-image-icons').slideUp(100);
            } else if ($(this).val() == 'custom') {
                $(this).parents('.wpfm-menu-item').find('#wpfm-field-add-custom-menu-icons').slideDown(200);
                $(this).parents('.wpfm-menu-item').find('#wpfm-field-add-menu-icons').slideUp(100);
                $(this).parents('.wpfm-menu-item').find('#wpfm-field-add-custom-image-icons').slideUp(100);
            } else if ($(this).val() == 'image-icon') {
                $(this).parents('.wpfm-menu-item').find('#wpfm-field-add-custom-menu-icons').slideUp(100);
                $(this).parents('.wpfm-menu-item').find('#wpfm-field-add-menu-icons').slideUp(100);
                $(this).parents('.wpfm-menu-item').find('#wpfm-field-add-custom-image-icons').slideDown(200);
            }

        });
        /** show hide custom icon field according to select option selected */
        $('body').on('change', '.wpfm-icon-type', function () {
            if ($(this).val() == 'default') {
                $(this).parents('.wpfm-menu-item').find('#wpfm-field-add-custom-menu-icons').slideUp(100);
                $(this).parents('.wpfm-menu-item').find('#wpfm-field-add-menu-icons').slideDown(200);
                $(this).parents('.wpfm-menu-item').find('#wpfm-field-add-custom-image-icons').slideUp(100);
            } else if ($(this).val() == 'custom') {
                $(this).parents('.wpfm-menu-item').find('#wpfm-field-add-custom-menu-icons').slideDown(200);
                $(this).parents('.wpfm-menu-item').find('#wpfm-field-add-menu-icons').slideUp(100);
                $(this).parents('.wpfm-menu-item').find('#wpfm-field-add-custom-image-icons').slideUp(100);
            } else if ($(this).val() == 'image-icon') {
                $(this).parents('.wpfm-menu-item').find('#wpfm-field-add-custom-menu-icons').slideUp(100);
                $(this).parents('.wpfm-menu-item').find('#wpfm-field-add-menu-icons').slideUp(100);
                $(this).parents('.wpfm-menu-item').find('#wpfm-field-add-custom-image-icons').slideDown(200);
            }
        });

        $('body').on('change', '.wpfm-stretch-icon-type', function () {
            if ($(this).val() == 'default') {
                $(this).parents('.layout-56-hidden-field-wrapper').find('#wpfm-stretchable-menu-custom-icon').slideUp(100);
                $(this).parents('.layout-56-hidden-field-wrapper').find('#wpfm-stretchable-menu-direction').slideDown(200);
                $(this).parents('.layout-56-hidden-field-wrapper').find('#wpfm-stretchable-menu-custom-image-icons').slideUp(100);
            } else if ($(this).val() == 'custom') {
                $(this).parents('.layout-56-hidden-field-wrapper').find('#wpfm-stretchable-menu-custom-icon').slideDown(200);
                $(this).parents('.layout-56-hidden-field-wrapper').find('#wpfm-stretchable-menu-direction').slideUp(100);
                $(this).parents('.layout-56-hidden-field-wrapper').find('#wpfm-stretchable-menu-custom-image-icons').slideUp(100);
            } else if ($(this).val() == 'image-icon') {
                $(this).parents('.layout-56-hidden-field-wrapper').find('#wpfm-stretchable-menu-custom-icon').slideUp(100);
                $(this).parents('.layout-56-hidden-field-wrapper').find('#wpfm-stretchable-menu-direction').slideUp(100);
                $(this).parents('.layout-56-hidden-field-wrapper').find('#wpfm-stretchable-menu-custom-image-icons').slideDown(200);
            }
        });
        /** 
         * Live Preview Section 
         */
        /** Menu Template demo display */

        // Live Template preview 
        $(".wpfm-common").first().addClass("temp-active");
        $('#menu-template').on('change', function () {
            template_value = $(this).val();
            var array_break = template_value.split('-');
            var current_id = array_break[1];
            if (current_id == '1' || current_id == '2' || current_id == '3' || current_id == '4' || current_id == '5'
                    || current_id == '6' || current_id == '7' || current_id == '8' || current_id == '9' || current_id == '10'
                    || current_id == '14' || current_id == '15' || current_id == '17' || current_id == '18'
                    || current_id == '19' || current_id == '20') {
                $('#wpfm-temp-demo-' + current_id).removeClass('temp-active');
                $('.wpfm-common').hide();
                $(this).addClass('temp-active');
                $('#wpfm-temp-demo-' + current_id).show();
                $('#wpfm-menu-placement-wrap').show();
                $('#wpfm-menu-placement-new-wrap').hide();
            } else {
                $('#wpfm-temp-demo-' + current_id).removeClass('temp-active');
                $('.wpfm-common').hide();
                $(this).addClass('temp-active');
                $('#wpfm-temp-demo-' + current_id).show();
                $('#wpfm-menu-placement-wrap').hide();
                $('#wpfm-menu-placement-new-wrap').show();
            }
        });

        /* Detect Current template demo On page load */
        if ($("#menu-template option:selected")[0]) {
            cur_temp_val = $('#menu-template option:selected').val();
            var array_break = cur_temp_val.split('-');
            var current_id = array_break[1];
            $('.wpfm-common').hide();
            $('#wpfm-temp-demo-' + current_id).show();
            //$('#wpfm-menu-placement-wrap').show();
        }

        //change description dynamically
        $('.wpfm-sortable-menu-field').on('keyup', '#wpfm-edit-menu-item-item-title', function () {
            var desc = $(this).val();
            $(this).parents('ul.wpfm-menu').find('span.wpfm-menu-item-title').text(desc);
        });

        // Font Family Live Preview For Menu Title 
        $('.wpfm-menu-title-font').change(function () {
            var t_label_font = $(this).val();
            var t_font_size = $("#wpfm-title-font-size option:selected").text();
            var t_font_color = $("#wpfm-title-font-color").val();
            var t_text_transform = $('#wpfm-title-text-transform option:selected').val();
            $(".title-font-style").html('');
            $("#wpfm-font-family").css({
                'font-family': t_label_font,
                'font-size': t_font_size + 'px',
                'text-transform': t_text_transform,
                'color': t_font_color
            });
            if (t_label_font != "default" && t_label_font != '') {
                WebFont.load({
                    google: {
                        families: [t_label_font]
                    }
                });
            }
        });

        // Font Size Live Preview For Menu Title 
        $("#wpfm-title-font-size").change(function () {
            var size = $('#wpfm-title-font-size option:selected').val();
            var family = $(".wpfm-menu-title-font option:selected").text();
            var font_color = $("#wpfm-title-font-color").val();
            var text_transform = $('#wpfm-title-text-transform option:selected').val();
            $("#wpfm-font-family").css({
                'font-family': family,
                'font-size': size + 'px',
                'text-transform': text_transform,
                'color': font_color
            });
        });

        // Text Transform Preview For Menu Title
        $("#wpfm-title-text-transform").change(function () {
            var text_tran_font_family = $(".wpfm-menu-title-font option:selected").text();
            var text_tran_font_font_color = $("#wpfm-title-font-color").val();
            var text_tran_font_size = $("#wpfm-title-font-size option:selected").val();
            var text_tran_text_transform = $(this).val();
            $("#wpfm-font-family").css({
                'font-family': text_tran_font_family,
                'font-size': text_tran_font_size + 'px',
                'text-transform': text_tran_text_transform,
                'color': text_tran_font_font_color
            });
        });

        // Color picker live previewfor Title font color
        var myOptions = {
            palettes: true,
            change: function (event, ui) {
                $('#wpfm-font-family').css('color', ui.color.toString());
            },

        };

        // Implementing Font Color for Title
        $('#wpfm-title-font-color').wpColorPicker(myOptions);

        // Font Family For tooltip Text 
        $('#wpfm-menu-tooltip-font').change(function () {
            var tt_label_font = $(this).val();
            var tt_label_font_color = $('#wpfm-title-font-color option:selected').val();
            var tt_font_size = $("#wpfm-tooltip-font-size option:selected").text();
            var tt_text_transform = $('#wpfm-tt-title-text-transform').val();
            $("#wpfm-tooltip-font-family").css({
                'font-family': tt_label_font,
                'font-size': tt_font_size + 'px',
                'color': tt_label_font_color,
                'text-transform': tt_text_transform
            });
            if (tt_label_font != "default" && tt_label_font != '') {
                WebFont.load({
                    google: {
                        families: [tt_label_font]
                    }
                });
            }
        });

        // Text Transform Preview For Tooltip Title
        $("#wpfm-tt-title-text-transform").change(function () {
            var text_tran_font_family = $('#wpfm-menu-tooltip-font option:selected').val();
            var text_tran_font_font_color = $('#wpfm-title-font-color option:selected').val();
            var text_tran_font_size = $("#wpfm-tooltip-font-size option:selected").text();
            var text_tran_text_transform = $(this).val();
            $("#wpfm-tooltip-font-family").css({
                'font-family': text_tran_font_family,
                'font-size': text_tran_font_size + 'px',
                'text-transform': text_tran_text_transform,
                'color': text_tran_font_font_color
            });
        });

        // Font Size Live Preview For Tooltip Text 
        $("#wpfm-tooltip-font-size").change(function () {
            var family = $("#wpfm-menu-tooltip-font option:selected").text();
            var size = $(this).val();
            var font_color = $('#wpfm-title-font-color option:selected').val();
            var text_transform = $('#wpfm-tt-title-text-transform').val();
            $("#wpfm-tooltip-font-family").css({
                'font-family': family,
                'font-size': size + 'px',
                'color': font_color,
                'text-transform': text_transform
            });
        });

        // Color picker live previewfor Menu Tooltip font color
        var myOptions = {
            palettes: true,
            change: function (event, ui) {
                $('#wpfm-tooltip-font-family').css('color', ui.color.toString());
            },

        };
        // Implementing Font Color for tooltip
        $('#wpfm-tooltip-font-color').wpColorPicker(myOptions);

        // color picker live previewfor Menu Tooltip font color
        var myOptions = {
            palettes: true,
            change: function (event, ui) {
                $('#tt-demo-wrap-wpfm').css('background', ui.color.toString());
            },

        };
        // Implementing Font Color for tooltip
        $('#wpfm-tooltip-bg-color').wpColorPicker(myOptions);

        /**  
         * Display select hidden field options for Custom Template
         */
        /** Expand/Hide icon selector Option for Custom Template */
        $('body').on('change', '#menu-template', function () {
            var template_val = $(this).val();
            if (template_val == 'template-5') {
                $('.layout-56-hidden-field-wrapper').slideDown(200);
                $('.layout-5689-hidden-field').slideDown(200);
                $('#wpfm-nav1234713-icon-color-wrap').hide(200);
                $('.layout-7-hidden-field').hide(200);
                $('.layout-46101213-hidden-field').hide();
            } else if (template_val == 'template-6') {
                $('.layout-56-hidden-field-wrapper').slideDown(200);
                $('.layout-5689-hidden-field').slideDown(200);
                $('#wpfm-nav1234713-icon-color-wrap').hide(200);
                $('.layout-7-hidden-field').hide(200);
                $('.layout-46101213-hidden-field').show();
            } else if (template_val == 'template-8' || template_val == 'template-9') {
                $('.layout-56-hidden-field-wrapper').slideUp(200);
                $('.layout-5689-hidden-field').slideDown(200);
                $('#wpfm-nav1234713-icon-color-wrap').hide(200);
                $('.layout-7-hidden-field').hide(200);
                $('.layout-46101213-hidden-field').hide();
            } else if (template_val == 'template-1' || template_val == 'template-2' || template_val == 'template-3') {
                $('.layout-56-hidden-field-wrapper').slideUp(200);
                $('.layout-5689-hidden-field').slideUp(200);
                $('#wpfm-nav1234713-icon-color-wrap').show(200);
                $('.layout-7-hidden-field').hide(200);
                $('.layout-46101213-hidden-field').hide();
            } else if (template_val == 'template-4') {
                $('.layout-56-hidden-field-wrapper').slideUp(200);
                $('.layout-5689-hidden-field').slideUp(200);
                $('#wpfm-nav1234713-icon-color-wrap').show(200);
                $('.layout-7-hidden-field').hide(200);
                $('.layout-46101213-hidden-field').show();
                $('#wpfm-menu-title-bg-color-wrap').show();
            } else if (template_val == 'template-7') {
                $('.layout-56-hidden-field-wrapper').slideUp(200);
                $('.layout-5689-hidden-field').slideUp(200);
                $('#wpfm-nav1234713-icon-color-wrap').show(200);
                $('.layout-7-hidden-field').show(200);
                $('.layout-46101213-hidden-field').show();
            } else if (template_val == 'template-10') {
                $('.layout-56-hidden-field-wrapper').slideUp(200);
                $('.layout-5689-hidden-field').slideUp(200);
                $('#wpfm-nav1234713-icon-color-wrap').hide(200);
                $('.layout-7-hidden-field').hide(200);
                $('.layout-46101213-hidden-field').show();
                $('#wpfm-menu-title-bg-color-wrap').show();
            } else if (template_val == 'template-11' || template_val == 'template-12') {
                $('.layout-56-hidden-field-wrapper').slideUp(200);
                $('.layout-5689-hidden-field').slideDown(200);
                $('#wpfm-nav1234713-icon-color-wrap').hide(200);
                $('.layout-7-hidden-field').hide(200);
                $('.layout-46101213-hidden-field').show();
                $('#wpfm-menu-title-bg-color-wrap').show();
            } else if (template_val == 'template-13') {
                $('.layout-56-hidden-field-wrapper').slideUp(200);
                $('.layout-5689-hidden-field').slideUp(200);
                $('#wpfm-nav1234713-icon-color-wrap').show(200);
                $('.layout-7-hidden-field').hide(200);
                $('.layout-46101213-hidden-field').show();
                $('#wpfm-menu-title-bg-color-wrap').show();
            } else if (template_val == 'template-19') {
                $('.layout-46101213-hidden-field').show();
            } else {
                $('.layout-56-hidden-field-wrapper').slideUp(200);
                $('.layout-5689-hidden-field').slideUp(200);
                $('.layout-7-hidden-field').hide(200);
                $('.layout-46101213-hidden-field').hide();
                $('#wpfm-menu-title-bg-color-wrap').hide();
            }
        });


        /**
         * End for Display select hidden field options for Custom Template
         */
        /* Check for Empty name field in template add*/
        $('.wpfm-template-save-button').click(function (e) {
            var template_name = $('.wpfm-custom-template-name').val();
            if (template_name == '') {
                $('.template-name-error').show();
                e.preventDefault();
            }
        });

        /* Check for Empty name field in Menu add */
        $('.wpfm-menu-field-add').click(function (e) {
            var template_name = $('#wpfm-menu-name-add').val();
            if (template_name == '') {
                $('.menu-name-error').show();
                e.preventDefault();
            }
        });

        /* Check all Post types */
        $(".post-type-check").click(function () {
            var data_sec = $(this).data('sec');
            $('input:checkbox[id^="wpfm-page-display-checkbox-' + data_sec + '"]').not(this).prop('checked', this.checked);
        });

        /** 
         * Implement color picker for menu background color and menu title font color
         */
        $('.wpfm-colorpicker-trigger').wpColorPicker();

        /** 
         * Edit current Menu Name 
         */
        $('body').on('keyup', '.wpfm-menu-name', function () {
            var desc = $(this).val();
            $('body').find('span.wpfm-current-menu-title').html('<strong>' + desc + '</strong>');
        });

        // Element Parent Image Live Preview        
        $('body').on('click', '.wpfm-icon-image-custom-upload', function (e) {
            e.preventDefault();
            var formfieldID = jQuery(this).parent().children('input.wpfm-icon-image-custom').attr("id");
            var $this = $(this);
            var image = wp.media({
                title: 'Upload Image',
                multiple: false
            }).open()
                    .on('select', function (e) {
                        var uploaded_image = image.state().get('selection').first();
                        var el_img_url = uploaded_image.toJSON().url;
                        $($this).parent().children('input#' + formfieldID).val(el_img_url);
                        $($this).parent().children('input#' + formfieldID).parent().find('.wpfm-image-preview img').attr('src', el_img_url);
                        //tb_remove();
                    });
        });
        // Element Parent Image Live Preview        
        $('body').on('keyup', '#wpfm-icon-picker-image-custom-size', function (e) {
            $(this).parents('#wpfm-menu-to-edit').find('span.wpfm-image-preview img').css({
                'width': $(this).val() + 'px',
                'height': $(this).val() + 'px'
            });
        });
    }); /** Function ends */
}(jQuery));