<?php defined('ABSPATH') or die('No script kiddies please!'); ?>
<div class="wpfm-wrapper wpfm-clear">
    <div class="wpfm-head">     
        <?php include(WPFM_PRO_FILE_ROOT_DIR . 'inc/backend/includes/wpfm-header.php'); ?> 
    </div> 
    <?php
    $options = get_option(WPFM_SETTINGS);
    ?> 
    <div class="wpfm-inner-wrapper" id="poststuff">
        <div id="post-body-full" class="metabox-holder columns-2">
            <div id="post-body-content">
                <div class="postbox">
                    <div class="wpfm-menu-option-wrapper clearfix" id="col-container">
                        <div class="inside" id="wpfm-menu-setting-wrapper">
                            <div class="wpfm-header-title wpfm-menu-option-header-title">
                                <?php _e('Menu Options', 'wp-floating-menu-pro'); ?>
                            </div>
                            <?php if (isset($_SESSION['wpfmp_message'])) { ?>
                                <div class="wpfm-message notice notice-success is-dismissible">
                                    <p>
                                        <?php
                                        echo $_SESSION['wpfmp_message'];
                                        unset($_SESSION['wpfmp_message']);
                                        ?>
                                    </p>
                                </div>
                            <?php } ?> 
                            <p class="wpfm-text"><?php _e('You can also select individual menu options in pages.', 'wpfm-floating-menu-pro'); ?></p>
                        </div>
                        <?php
                        global $wpdb;
                        $pages = $this->get_all_page_lists();
                        $posts = $this->get_all_post_lists();
                        $categories = $this->get_categories();
                        $args = array('public' => true, '_builtin' => false);
                        $output = 'objects';
                        $operator = 'and';
                        $post_types = get_post_types($args, $output, $operator);
                        $all_post_types = array();
                        foreach ($post_types as $post_type) {
                            $all_post_types[] = $post_type->name;
                        }
                        $table_name = $wpdb->prefix . "wp_floating_menu_details";
                        $menu_details = $wpdb->get_results("SELECT * FROM $table_name");
                        if (isset($options['page_specific_display']) && is_array($options['page_specific_display'])) {
                            $show_pages_list_array = $options['page_specific_display'];
                        } else {
                            $show_pages_list_array = '';
                        }
                        ?>
                        <form action="<?php echo admin_url() . 'admin-post.php' ?>" method='post' id="wpfm-menu-option-form">     
                            <input type="hidden" name="action" value="wpfm_save_menu_show_options" />
                            <div class="wpfm-menu-option-setting-wrapper">
                                <div class="wpfm-general-settings-wrap">
                                    <h3 class="wpfm-menu-setting-page-title"><?php _e('General Setting', 'wp-floating-menu-pro'); ?></h3>
                                    <div class="wpfm-menu-option-setting-field">
                                        <label class="menu-option-label-controller">
                                            <h4><?php _e('Enable/Disable Menu', 'wp-floating-menu-pro'); ?></h4>
                                        </label>
                                        <label class="wpfm-switch">
                                            <input type="checkbox" class="wpfm-checkbox" value="1" name="menu_enable_disable" <?php if (isset($options['menu_enable_disable']) && $options['menu_enable_disable'] == '1') { ?>checked="checked"<?php } ?>/>
                                            <div class="wpfm-slider round"></div>
                                        </label>
                                    </div>
                                    <div class="wpfm-menu-option-setting-field">
                                        <label class="menu-option-label-controller">
                                            <h4><?php _e('Enable/Disable All Menu For Desktop Screens', 'wp-floating-menu-pro'); ?></h4>
                                        </label>
                                        <label class="wpfm-switch">                                        
                                            <input type="checkbox" class="wpfm-checkbox" value="1" name="bigger_screen_menu_enable_disable" <?php if ((isset($options['bigger_screen_menu_enable_disable']) && $options['bigger_screen_menu_enable_disable'] == '1') || !isset($options['bigger_screen_menu_enable_disable'])) { ?>checked="checked"<?php } ?>/>
                                            <div class="wpfm-slider round"></div>
                                        </label>
                                        <div class="wpfm-tooltip-description">
                                            <label class="wpfm-tt-description">
                                                <?php _e('If unchecked, menu will for disabled for screen size more than 1024px.', 'wp-floating-menu-pro'); ?>
                                            </label>
                                        </div>
                                    </div>
                                    <div class="wpfm-menu-option-setting-field">
                                        <label class="menu-option-label-controller">
                                            <h4><?php _e('Enable/Disable All Menu For Tablet Screens', 'wp-floating-menu-pro'); ?></h4>
                                        </label>
                                        <label class="wpfm-switch">                                        
                                            <input type="checkbox" class="wpfm-checkbox" value="1" name="tablet_menu_enable_disable" <?php if ((isset($options['tablet_menu_enable_disable']) && $options['tablet_menu_enable_disable'] == '1') || !isset($options['tablet_menu_enable_disable'])) { ?>checked="checked"<?php } ?>/>
                                            <div class="wpfm-slider round"></div>
                                        </label>
                                        <div class="wpfm-tooltip-description">
                                            <label class="wpfm-tt-description">
                                                <?php _e('If unchecked, menu will for disabled for screen size between 768px and 1024px.', 'wp-floating-menu-pro'); ?>
                                            </label>
                                        </div>
                                    </div>
                                    <div class="wpfm-menu-option-setting-field">
                                        <label class="menu-option-label-controller">
                                            <h4><?php _e('Enable/Disable All Menu For Mobile Screens', 'wp-floating-menu-pro'); ?></h4>
                                        </label>
                                        <label class="wpfm-switch">                                        
                                            <input type="checkbox" class="wpfm-checkbox" value="1" name="mobile_menu_enable_disable" <?php if (isset($options['mobile_menu_enable_disable']) && $options['mobile_menu_enable_disable'] == '1') { ?>checked="checked"<?php } ?>/>
                                            <div class="wpfm-slider round"></div>
                                        </label>
                                        <div class="wpfm-tooltip-description">
                                            <label class="wpfm-tt-description">
                                                <?php _e('If unchecked, menu will for disabled for screen size less than 480px.', 'wp-floating-menu-pro'); ?>
                                            </label>
                                        </div>
                                    </div>
                                    <div class="wpfm-menu-option-setting-field">
                                        <label class="menu-option-label-controller">
                                            <h4><?php _e('Enable/Disable Different Menu For Responsive Screens', 'wp-floating-menu-pro'); ?></h4>
                                        </label>
                                        <label class="wpfm-switch">                                        
                                            <input type="checkbox" class="wpfm-checkbox" value="1" name="responsive_n_different_menu_enable_disable" <?php if (isset($options['responsive_n_different_menu_enable_disable']) && $options['responsive_n_different_menu_enable_disable'] == '1') { ?>checked="checked"<?php } ?>/>
                                            <div class="wpfm-slider round"></div>
                                        </label>
                                        <div class="wpfm-tooltip-description">
                                            <label class="wpfm-tt-description">
                                                <?php _e('If checked, you can set different menu for desktop screen & responsive screen.', 'wp-floating-menu-pro'); ?>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="wpfm-menu-select-settings-wrap">
                                    <h3 class="wpfm-menu-setting-page-title"><?php _e('Select Menu Setting', 'wp-floating-menu-pro'); ?></h3>
                                    <div class="wpfm-menu-option-setting-field">
                                        <label class="menu-option-label-controller">
                                            <h4><?php _e('Select Menu - Middle Right', 'wp-floating-menu-pro'); ?></h4>
                                        </label>
                                        <div class="menu-option-inner-input-wrapper">
                                            <div class="menu-option-inner-input">
                                                <label><?php _e('Desktop', 'wp-floating-menu-pro'); ?>:</label>
                                                <select name="menu_list_select_mr" class="wpfm-display-menu-optionss" >
                                                    <option value="default" <?php if (isset($options['menu_list_select_mr']) && $options['menu_list_select_mr'] == 'default') { ?>selected="selected"<?php } ?>><?php echo _e('Disabled', 'wp-floating-menu-pro'); ?></option>
                                                    <?php
                                                    foreach ($menu_details as $menu_detail) {
                                                        $menu_settings = unserialize($menu_detail->menu_display_setting_details);
                                                        if (isset($menu_settings['menu_design']['template_number']) && ($menu_settings['menu_design']['template_number'] == 'template-11' || $menu_settings['menu_design']['template_number'] == 'template-12' || $menu_settings['menu_design']['template_number'] == 'template-13')) {
                                                            if (isset($menu_settings['menu_design']['cmenu_placement']) && $menu_settings['menu_design']['cmenu_placement'] == 'right') {
                                                                ?>                                    
                                                                <option value="<?php echo $menu_detail->id; ?>" <?php if ((isset($options['menu_list_select_mr']) && $options['menu_list_select_mr'] == $menu_detail->id) || (isset($options['menu_list_selected']) && $options['menu_list_selected'] == $menu_detail->id)) { ?>selected="selected"<?php } ?>><?php echo $menu_detail->menu_name; ?></option>                                        
                                                                <?php
                                                            }
                                                        } else {
                                                            if (isset($menu_settings['menu_design']['menu_placement']) && $menu_settings['menu_design']['menu_placement'] == 'right') {
                                                                ?>
                                                                <option value="<?php echo $menu_detail->id; ?>" <?php if ((isset($options['menu_list_select_mr']) && $options['menu_list_select_mr'] == $menu_detail->id) || (isset($options['menu_list_selected']) && $options['menu_list_selected'] == $menu_detail->id)) { ?>selected="selected"<?php } ?>><?php echo $menu_detail->menu_name; ?></option>                                        
                                                                <?php
                                                            }
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                            <div class="menu-option-inner-input">
                                                <label><?php _e('Responsive', 'wp-floating-menu-pro'); ?>:</label>
                                                <select name="menu_list_select_resp_mr" class="wpfm-display-menu-optionss" >
                                                    <option value="default" <?php if (isset($options['menu_list_select_resp_mr']) && $options['menu_list_select_resp_mr'] == 'default') { ?>selected="selected"<?php } ?>><?php echo _e('Disabled', 'wp-floating-menu-pro'); ?></option>
                                                    <?php
                                                    foreach ($menu_details as $menu_detail) {
                                                        $menu_settings = unserialize($menu_detail->menu_display_setting_details);
                                                        if (isset($menu_settings['menu_design']['template_number']) && ($menu_settings['menu_design']['template_number'] == 'template-11' || $menu_settings['menu_design']['template_number'] == 'template-12' || $menu_settings['menu_design']['template_number'] == 'template-13')) {
                                                            if (isset($menu_settings['menu_design']['cmenu_placement']) && $menu_settings['menu_design']['cmenu_placement'] == 'right') {
                                                                ?>                                    
                                                                <option value="<?php echo $menu_detail->id; ?>" <?php if ((isset($options['menu_list_select_resp_mr']) && $options['menu_list_select_resp_mr'] == $menu_detail->id) || (isset($options['menu_list_select_resp_mr']) && $options['menu_list_select_resp_mr'] == $menu_detail->id)) { ?>selected="selected"<?php } ?>><?php echo $menu_detail->menu_name; ?></option>                                        
                                                                <?php
                                                            }
                                                        } else {
                                                            if (isset($menu_settings['menu_design']['menu_placement']) && $menu_settings['menu_design']['menu_placement'] == 'right') {
                                                                ?>
                                                                <option value="<?php echo $menu_detail->id; ?>" <?php if ((isset($options['menu_list_select_resp_mr']) && $options['menu_list_select_resp_mr'] == $menu_detail->id) || (isset($options['menu_list_select_resp_mr']) && $options['menu_list_select_resp_mr'] == $menu_detail->id)) { ?>selected="selected"<?php } ?>><?php echo $menu_detail->menu_name; ?></option>                                        
                                                                <?php
                                                            }
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="wpfm-menu-option-setting-field">
                                        <label class="menu-option-label-controller">
                                            <h4><?php _e('Select Menu - Top Right', 'wp-floating-menu-pro'); ?></h4>
                                        </label>
                                        <div class="menu-option-inner-input-wrapper">
                                            <div class="menu-option-inner-input">
                                                <label><?php _e('Desktop', 'wp-floating-menu-pro'); ?>:</label>
                                                <select name="menu_list_select_tr" class="wpfm-display-menu-optionss" >
                                                    <option value="default" <?php if (isset($options['menu_list_select_tr']) && $options['menu_list_select_tr'] == 'default') { ?>selected="selected"<?php } ?>><?php echo _e('Disabled', 'wp-floating-menu-pro'); ?></option>
                                                    <?php
                                                    foreach ($menu_details as $menu_detail) {
                                                        $menu_settings = unserialize($menu_detail->menu_display_setting_details);
                                                        if (isset($menu_settings['menu_design']['template_number']) && ($menu_settings['menu_design']['template_number'] == 'template-11' || $menu_settings['menu_design']['template_number'] == 'template-12' || $menu_settings['menu_design']['template_number'] == 'template-13')) {
                                                            if (isset($menu_settings['menu_design']['cmenu_placement']) && $menu_settings['menu_design']['cmenu_placement'] == 'top-right') {
                                                                ?>                                    
                                                                <option value="<?php echo $menu_detail->id; ?>" <?php if ((isset($options['menu_list_select_tr']) && $options['menu_list_select_tr'] == $menu_detail->id) || (isset($options['menu_list_selected']) && $options['menu_list_selected'] == $menu_detail->id)) { ?>selected="selected"<?php } ?>><?php echo $menu_detail->menu_name; ?></option>                                        
                                                                <?php
                                                            }
                                                        } else {
                                                            if (isset($menu_settings['menu_design']['menu_placement']) && $menu_settings['menu_design']['menu_placement'] == 'top-right') {
                                                                ?>
                                                                <option value="<?php echo $menu_detail->id; ?>" <?php if ((isset($options['menu_list_select_tr']) && $options['menu_list_select_tr'] == $menu_detail->id) || (isset($options['menu_list_selected']) && $options['menu_list_selected'] == $menu_detail->id)) { ?>selected="selected"<?php } ?>><?php echo $menu_detail->menu_name; ?></option>                                        
                                                                <?php
                                                            }
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                            <div class="menu-option-inner-input">
                                                <label><?php _e('Responsive', 'wp-floating-menu-pro'); ?>:</label>
                                                <select name="menu_list_select_resp_tr" class="wpfm-display-menu-optionss" >
                                                    <option value="default" <?php if (isset($options['menu_list_select_resp_tr']) && $options['menu_list_select_resp_tr'] == 'default') { ?>selected="selected"<?php } ?>><?php echo _e('Disabled', 'wp-floating-menu-pro'); ?></option>
                                                    <?php
                                                    foreach ($menu_details as $menu_detail) {
                                                        $menu_settings = unserialize($menu_detail->menu_display_setting_details);
                                                        if (isset($menu_settings['menu_design']['template_number']) && ($menu_settings['menu_design']['template_number'] == 'template-11' || $menu_settings['menu_design']['template_number'] == 'template-12' || $menu_settings['menu_design']['template_number'] == 'template-13')) {
                                                            if (isset($menu_settings['menu_design']['cmenu_placement']) && $menu_settings['menu_design']['cmenu_placement'] == 'top-right') {
                                                                ?>                                    
                                                                <option value="<?php echo $menu_detail->id; ?>" <?php if ((isset($options['menu_list_select_resp_tr']) && $options['menu_list_select_resp_tr'] == $menu_detail->id) || (isset($options['menu_list_selected']) && $options['menu_list_selected'] == $menu_detail->id)) { ?>selected="selected"<?php } ?>><?php echo $menu_detail->menu_name; ?></option>                                        
                                                                <?php
                                                            }
                                                        } else {
                                                            if (isset($menu_settings['menu_design']['menu_placement']) && $menu_settings['menu_design']['menu_placement'] == 'top-right') {
                                                                ?>
                                                                <option value="<?php echo $menu_detail->id; ?>" <?php if ((isset($options['menu_list_select_tr']) && $options['menu_list_select_tr'] == $menu_detail->id) || (isset($options['menu_list_selected']) && $options['menu_list_selected'] == $menu_detail->id)) { ?>selected="selected"<?php } ?>><?php echo $menu_detail->menu_name; ?></option>                                        
                                                                <?php
                                                            }
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="wpfm-menu-option-setting-field">
                                        <label class="menu-option-label-controller">
                                            <h4><?php _e('Select Menu - Bottom Right', 'wp-floating-menu-pro'); ?></h4>
                                        </label>
                                        <div class="menu-option-inner-input-wrapper">
                                            <div class="menu-option-inner-input">
                                                <label><?php _e('Desktop', 'wp-floating-menu-pro'); ?>:</label>
                                                <select name="menu_list_select_br" class="wpfm-display-menu-optionss" >
                                                    <option value="default" <?php if (isset($options['menu_list_select_br']) && $options['menu_list_select_br'] == 'default') { ?>selected="selected"<?php } ?>><?php echo _e('Disabled', 'wp-floating-menu-pro'); ?></option>
                                                    <?php
                                                    foreach ($menu_details as $menu_detail) {
                                                        $menu_settings = unserialize($menu_detail->menu_display_setting_details);
                                                        if (isset($menu_settings['menu_design']['template_number']) && ($menu_settings['menu_design']['template_number'] == 'template-11' || $menu_settings['menu_design']['template_number'] == 'template-12' || $menu_settings['menu_design']['template_number'] == 'template-13')) {
                                                            if (isset($menu_settings['menu_design']['cmenu_placement']) && $menu_settings['menu_design']['cmenu_placement'] == 'bottom-right') {
                                                                ?>                                    
                                                                <option value="<?php echo $menu_detail->id; ?>" <?php if ((isset($options['menu_list_select_br']) && $options['menu_list_select_br'] == $menu_detail->id) || (isset($options['menu_list_selected']) && $options['menu_list_selected'] == $menu_detail->id)) { ?>selected="selected"<?php } ?>><?php echo $menu_detail->menu_name; ?></option>                                        
                                                                <?php
                                                            }
                                                        } else {
                                                            if (isset($menu_settings['menu_design']['menu_placement']) && $menu_settings['menu_design']['menu_placement'] == 'bottom-right') {
                                                                ?>
                                                                <option value="<?php echo $menu_detail->id; ?>" <?php if ((isset($options['menu_list_select_br']) && $options['menu_list_select_br'] == $menu_detail->id) || (isset($options['menu_list_selected']) && $options['menu_list_selected'] == $menu_detail->id)) { ?>selected="selected"<?php } ?>><?php echo $menu_detail->menu_name; ?></option>                                        
                                                                <?php
                                                            }
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                            <div class="menu-option-inner-input">
                                                <label><?php _e('Responsive', 'wp-floating-menu-pro'); ?>:</label>
                                                <select name="menu_list_select_resp_br" class="wpfm-display-menu-optionss" >
                                                    <option value="default" <?php if (isset($options['menu_list_select_resp_br']) && $options['menu_list_select_resp_br'] == 'default') { ?>selected="selected"<?php } ?>><?php echo _e('Disabled', 'wp-floating-menu-pro'); ?></option>
                                                    <?php
                                                    foreach ($menu_details as $menu_detail) {
                                                        $menu_settings = unserialize($menu_detail->menu_display_setting_details);
                                                        if (isset($menu_settings['menu_design']['template_number']) && ($menu_settings['menu_design']['template_number'] == 'template-11' || $menu_settings['menu_design']['template_number'] == 'template-12' || $menu_settings['menu_design']['template_number'] == 'template-13')) {
                                                            if (isset($menu_settings['menu_design']['cmenu_placement']) && $menu_settings['menu_design']['cmenu_placement'] == 'bottom-right') {
                                                                ?>                                    
                                                                <option value="<?php echo $menu_detail->id; ?>" <?php if ((isset($options['menu_list_select_resp_br']) && $options['menu_list_select_resp_br'] == $menu_detail->id) || (isset($options['menu_list_selected']) && $options['menu_list_selected'] == $menu_detail->id)) { ?>selected="selected"<?php } ?>><?php echo $menu_detail->menu_name; ?></option>                                        
                                                                <?php
                                                            }
                                                        } else {
                                                            if (isset($menu_settings['menu_design']['menu_placement']) && $menu_settings['menu_design']['menu_placement'] == 'bottom-right') {
                                                                ?>
                                                                <option value="<?php echo $menu_detail->id; ?>" <?php if ((isset($options['menu_list_select_resp_br']) && $options['menu_list_select_resp_br'] == $menu_detail->id) || (isset($options['menu_list_selected']) && $options['menu_list_selected'] == $menu_detail->id)) { ?>selected="selected"<?php } ?>><?php echo $menu_detail->menu_name; ?></option>                                        
                                                                <?php
                                                            }
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="wpfm-menu-option-setting-field">
                                        <label class="menu-option-label-controller">
                                            <h4><?php _e('Select Menu - Middle Left', 'wp-floating-menu-pro'); ?></h4>
                                        </label>
                                        <div class="menu-option-inner-input-wrapper">
                                            <div class="menu-option-inner-input">
                                                <label><?php _e('Desktop', 'wp-floating-menu-pro'); ?>:</label>
                                                <select name="menu_list_select_ml" class="wpfm-display-menu-optionss" >
                                                    <option value="default" <?php if (isset($options['menu_list_select_ml']) && $options['menu_list_select_ml'] == 'default') { ?>selected="selected"<?php } ?>><?php echo _e('Disabled', 'wp-floating-menu-pro'); ?></option>
                                                    <?php
                                                    foreach ($menu_details as $menu_detail) {
                                                        $menu_settings = unserialize($menu_detail->menu_display_setting_details);
                                                        if (isset($menu_settings['menu_design']['template_number']) && ($menu_settings['menu_design']['template_number'] == 'template-11' || $menu_settings['menu_design']['template_number'] == 'template-12' || $menu_settings['menu_design']['template_number'] == 'template-13')) {
                                                            if (isset($menu_settings['menu_design']['cmenu_placement']) && $menu_settings['menu_design']['cmenu_placement'] == 'left') {
                                                                ?>                                    
                                                                <option value="<?php echo $menu_detail->id; ?>" <?php if ((isset($options['menu_list_select_ml']) && $options['menu_list_select_ml'] == $menu_detail->id) || (isset($options['menu_list_selected']) && $options['menu_list_selected'] == $menu_detail->id)) { ?>selected="selected"<?php } ?>><?php echo $menu_detail->menu_name; ?></option>                                        
                                                                <?php
                                                            }
                                                        } else {
                                                            if (isset($menu_settings['menu_design']['menu_placement']) && $menu_settings['menu_design']['menu_placement'] == 'left') {
                                                                ?>
                                                                <option value="<?php echo $menu_detail->id; ?>" <?php if ((isset($options['menu_list_select_ml']) && $options['menu_list_select_ml'] == $menu_detail->id) || (isset($options['menu_list_selected']) && $options['menu_list_selected'] == $menu_detail->id)) { ?>selected="selected"<?php } ?>><?php echo $menu_detail->menu_name; ?></option>                                        
                                                                <?php
                                                            }
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                            <div class="menu-option-inner-input">
                                                <label><?php _e('Responsive', 'wp-floating-menu-pro'); ?>:</label>
                                                <select name="menu_list_select_resp_ml" class="wpfm-display-menu-optionss" >
                                                    <option value="default" <?php if (isset($options['menu_list_select_resp_ml']) && $options['menu_list_select_resp_ml'] == 'default') { ?>selected="selected"<?php } ?>><?php echo _e('Disabled', 'wp-floating-menu-pro'); ?></option>
                                                    <?php
                                                    foreach ($menu_details as $menu_detail) {
                                                        $menu_settings = unserialize($menu_detail->menu_display_setting_details);
                                                        if (isset($menu_settings['menu_design']['template_number']) && ($menu_settings['menu_design']['template_number'] == 'template-11' || $menu_settings['menu_design']['template_number'] == 'template-12' || $menu_settings['menu_design']['template_number'] == 'template-13')) {
                                                            if (isset($menu_settings['menu_design']['cmenu_placement']) && $menu_settings['menu_design']['cmenu_placement'] == 'left') {
                                                                ?>                                    
                                                                <option value="<?php echo $menu_detail->id; ?>" <?php if ((isset($options['menu_list_select_resp_ml']) && $options['menu_list_select_resp_ml'] == $menu_detail->id) || (isset($options['menu_list_selected']) && $options['menu_list_selected'] == $menu_detail->id)) { ?>selected="selected"<?php } ?>><?php echo $menu_detail->menu_name; ?></option>                                        
                                                                <?php
                                                            }
                                                        } else {
                                                            if (isset($menu_settings['menu_design']['menu_placement']) && $menu_settings['menu_design']['menu_placement'] == 'left') {
                                                                ?>
                                                                <option value="<?php echo $menu_detail->id; ?>" <?php if ((isset($options['menu_list_select_resp_ml']) && $options['menu_list_select_resp_ml'] == $menu_detail->id) || (isset($options['menu_list_selected']) && $options['menu_list_selected'] == $menu_detail->id)) { ?>selected="selected"<?php } ?>><?php echo $menu_detail->menu_name; ?></option>                                        
                                                                <?php
                                                            }
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="wpfm-menu-option-setting-field">
                                        <label class="menu-option-label-controller">
                                            <h4><?php _e('Select Menu - Top Left', 'wp-floating-menu-pro'); ?></h4>
                                        </label>
                                        <div class="menu-option-inner-input-wrapper">
                                            <div class="menu-option-inner-input">
                                                <label><?php _e('Desktop', 'wp-floating-menu-pro'); ?>:</label>
                                                <select name="menu_list_select_tl" class="wpfm-display-menu-optionss" >
                                                    <option value="default" <?php if (isset($options['menu_list_select_tl']) && $options['menu_list_select_tl'] == 'default') { ?>selected="selected"<?php } ?>><?php echo _e('Disabled', 'wp-floating-menu-pro'); ?></option>
                                                    <?php
                                                    foreach ($menu_details as $menu_detail) {
                                                        $menu_settings = unserialize($menu_detail->menu_display_setting_details);
                                                        if (isset($menu_settings['menu_design']['template_number']) && ($menu_settings['menu_design']['template_number'] == 'template-11' || $menu_settings['menu_design']['template_number'] == 'template-12' || $menu_settings['menu_design']['template_number'] == 'template-13')) {
                                                            if (isset($menu_settings['menu_design']['cmenu_placement']) && $menu_settings['menu_design']['cmenu_placement'] == 'top-left') {
                                                                ?>                                    
                                                                <option value="<?php echo $menu_detail->id; ?>" <?php if ((isset($options['menu_list_select_tl']) && $options['menu_list_select_tl'] == $menu_detail->id) || (isset($options['menu_list_selected']) && $options['menu_list_selected'] == $menu_detail->id)) { ?>selected="selected"<?php } ?>><?php echo $menu_detail->menu_name; ?></option>                                        
                                                                <?php
                                                            }
                                                        } else {
                                                            if (isset($menu_settings['menu_design']['menu_placement']) && $menu_settings['menu_design']['menu_placement'] == 'top-left') {
                                                                ?>
                                                                <option value="<?php echo $menu_detail->id; ?>" <?php if ((isset($options['menu_list_select_tl']) && $options['menu_list_select_tl'] == $menu_detail->id) || (isset($options['menu_list_selected']) && $options['menu_list_selected'] == $menu_detail->id)) { ?>selected="selected"<?php } ?>><?php echo $menu_detail->menu_name; ?></option>                                        
                                                                <?php
                                                            }
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                            <div class="menu-option-inner-input">
                                                <label><?php _e('Responsive', 'wp-floating-menu-pro'); ?>:</label>
                                                <select name="menu_list_select_resp_tl" class="wpfm-display-menu-optionss" >
                                                    <option value="default" <?php if (isset($options['menu_list_select_resp_tl']) && $options['menu_list_select_resp_tl'] == 'default') { ?>selected="selected"<?php } ?>><?php echo _e('Disabled', 'wp-floating-menu-pro'); ?></option>
                                                    <?php
                                                    foreach ($menu_details as $menu_detail) {
                                                        $menu_settings = unserialize($menu_detail->menu_display_setting_details);
                                                        if (isset($menu_settings['menu_design']['template_number']) && ($menu_settings['menu_design']['template_number'] == 'template-11' || $menu_settings['menu_design']['template_number'] == 'template-12' || $menu_settings['menu_design']['template_number'] == 'template-13')) {
                                                            if (isset($menu_settings['menu_design']['cmenu_placement']) && $menu_settings['menu_design']['cmenu_placement'] == 'top-left') {
                                                                ?>                                    
                                                                <option value="<?php echo $menu_detail->id; ?>" <?php if ((isset($options['menu_list_select_resp_tl']) && $options['menu_list_select_resp_tl'] == $menu_detail->id) || (isset($options['menu_list_selected']) && $options['menu_list_selected'] == $menu_detail->id)) { ?>selected="selected"<?php } ?>><?php echo $menu_detail->menu_name; ?></option>                                        
                                                                <?php
                                                            }
                                                        } else {
                                                            if (isset($menu_settings['menu_design']['menu_placement']) && $menu_settings['menu_design']['menu_placement'] == 'top-left') {
                                                                ?>
                                                                <option value="<?php echo $menu_detail->id; ?>" <?php if ((isset($options['menu_list_select_resp_tl']) && $options['menu_list_select_resp_tl'] == $menu_detail->id) || (isset($options['menu_list_selected']) && $options['menu_list_selected'] == $menu_detail->id)) { ?>selected="selected"<?php } ?>><?php echo $menu_detail->menu_name; ?></option>                                        
                                                                <?php
                                                            }
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="wpfm-menu-option-setting-field">
                                        <label class="menu-option-label-controller">
                                            <h4><?php _e('Select Menu - Bottom Left', 'wp-floating-menu-pro'); ?></h4>
                                        </label>
                                        <div class="menu-option-inner-input-wrapper">
                                            <div class="menu-option-inner-input">
                                                <label><?php _e('Desktop', 'wp-floating-menu-pro'); ?>:</label>
                                                <select name="menu_list_select_bl" class="wpfm-display-menu-optionss" >
                                                    <option value="default" <?php if (isset($options['menu_list_select_bl']) && $options['menu_list_select_bl'] == 'default') { ?>selected="selected"<?php } ?>><?php echo _e('Disabled', 'wp-floating-menu-pro'); ?></option>
                                                    <?php
                                                    foreach ($menu_details as $menu_detail) {
                                                        $menu_settings = unserialize($menu_detail->menu_display_setting_details);
                                                        if (isset($menu_settings['menu_design']['template_number']) && ($menu_settings['menu_design']['template_number'] == 'template-11' || $menu_settings['menu_design']['template_number'] == 'template-12' || $menu_settings['menu_design']['template_number'] == 'template-13')) {
                                                            if (isset($menu_settings['menu_design']['cmenu_placement']) && $menu_settings['menu_design']['cmenu_placement'] == 'bottom-left') {
                                                                ?>                                    
                                                                <option value="<?php echo $menu_detail->id; ?>" <?php if ((isset($options['menu_list_select_bl']) && $options['menu_list_select_bl'] == $menu_detail->id) || (isset($options['menu_list_selected']) && $options['menu_list_selected'] == $menu_detail->id)) { ?>selected="selected"<?php } ?>><?php echo $menu_detail->menu_name; ?></option>                                        
                                                                <?php
                                                            }
                                                        } else {
                                                            if (isset($menu_settings['menu_design']['menu_placement']) && $menu_settings['menu_design']['menu_placement'] == 'bottom-left') {
                                                                ?>
                                                                <option value="<?php echo $menu_detail->id; ?>" <?php if ((isset($options['menu_list_select_bl']) && $options['menu_list_select_bl'] == $menu_detail->id) || (isset($options['menu_list_selected']) && $options['menu_list_selected'] == $menu_detail->id)) { ?>selected="selected"<?php } ?>><?php echo $menu_detail->menu_name; ?></option>                                        
                                                                <?php
                                                            }
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                            <div class="menu-option-inner-input">
                                                <label><?php _e('Responsive', 'wp-floating-menu-pro'); ?>:</label>
                                                <select name="menu_list_select_resp_bl" class="wpfm-display-menu-optionss" >
                                                    <option value="default" <?php if (isset($options['menu_list_select_resp_bl']) && $options['menu_list_select_resp_bl'] == 'default') { ?>selected="selected"<?php } ?>><?php echo _e('Disabled', 'wp-floating-menu-pro'); ?></option>
                                                    <?php
                                                    foreach ($menu_details as $menu_detail) {
                                                        $menu_settings = unserialize($menu_detail->menu_display_setting_details);
                                                        if (isset($menu_settings['menu_design']['template_number']) && ($menu_settings['menu_design']['template_number'] == 'template-11' || $menu_settings['menu_design']['template_number'] == 'template-12' || $menu_settings['menu_design']['template_number'] == 'template-13')) {
                                                            if (isset($menu_settings['menu_design']['cmenu_placement']) && $menu_settings['menu_design']['cmenu_placement'] == 'bottom-left') {
                                                                ?>                                    
                                                                <option value="<?php echo $menu_detail->id; ?>" <?php if ((isset($options['menu_list_select_resp_bl']) && $options['menu_list_select_resp_bl'] == $menu_detail->id) || (isset($options['menu_list_selected']) && $options['menu_list_selected'] == $menu_detail->id)) { ?>selected="selected"<?php } ?>><?php echo $menu_detail->menu_name; ?></option>                                        
                                                                <?php
                                                            }
                                                        } else {
                                                            if (isset($menu_settings['menu_design']['menu_placement']) && $menu_settings['menu_design']['menu_placement'] == 'bottom-left') {
                                                                ?>
                                                                <option value="<?php echo $menu_detail->id; ?>" <?php if ((isset($options['menu_list_select_resp_bl']) && $options['menu_list_select_resp_bl'] == $menu_detail->id) || (isset($options['menu_list_selected']) && $options['menu_list_selected'] == $menu_detail->id)) { ?>selected="selected"<?php } ?>><?php echo $menu_detail->menu_name; ?></option>                                        
                                                                <?php
                                                            }
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="wpfm-menu-option-setting-field">
                                        <label class="menu-option-label-controller">
                                            <h4><?php _e('Select Menu - Bottom Center', 'wp-floating-menu-pro'); ?></h4>
                                        </label>
                                        <div class="menu-option-inner-input-wrapper">
                                            <div class="menu-option-inner-input">
                                                <label><?php _e('Desktop', 'wp-floating-menu-pro'); ?>:</label>
                                                <select name="menu_list_select_bc" class="wpfm-display-menu-optionss" >
                                                    <option value="default" <?php if (isset($options['menu_list_select_bc']) && $options['menu_list_select_bc'] == 'default') { ?>selected="selected"<?php } ?>><?php echo _e('Disabled', 'wp-floating-menu-pro'); ?></option>
                                                    <?php
                                                    foreach ($menu_details as $menu_detail) {
                                                        $menu_settings = unserialize($menu_detail->menu_display_setting_details);
                                                        if (isset($menu_settings['menu_design']['template_number']) && ($menu_settings['menu_design']['template_number'] == 'template-11' || $menu_settings['menu_design']['template_number'] == 'template-12' || $menu_settings['menu_design']['template_number'] == 'template-13')) {
                                                            if (isset($menu_settings['menu_design']['cmenu_placement']) && $menu_settings['menu_design']['cmenu_placement'] == 'bottom-center') {
                                                                ?>                                    
                                                                <option value="<?php echo $menu_detail->id; ?>" <?php if ((isset($options['menu_list_select_bc']) && $options['menu_list_select_bc'] == $menu_detail->id) || (isset($options['menu_list_selected']) && $options['menu_list_selected'] == $menu_detail->id)) { ?>selected="selected"<?php } ?>><?php echo $menu_detail->menu_name; ?></option>                                        
                                                                <?php
                                                            }
                                                        } else {
                                                            if (isset($menu_settings['menu_design']['menu_placement']) && $menu_settings['menu_design']['menu_placement'] == 'bottom-center') {
                                                                ?>
                                                                <option value="<?php echo $menu_detail->id; ?>" <?php if ((isset($options['menu_list_select_bc']) && $options['menu_list_select_bc'] == $menu_detail->id) || (isset($options['menu_list_selected']) && $options['menu_list_selected'] == $menu_detail->id)) { ?>selected="selected"<?php } ?>><?php echo $menu_detail->menu_name; ?></option>                                        
                                                                <?php
                                                            }
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                            <div class="menu-option-inner-input">
                                                <label><?php _e('Responsive', 'wp-floating-menu-pro'); ?>:</label>
                                                <select name="menu_list_select_resp_bc" class="wpfm-display-menu-optionss" >
                                                    <option value="default" <?php if (isset($options['menu_list_select_resp_bc']) && $options['menu_list_select_resp_bc'] == 'default') { ?>selected="selected"<?php } ?>><?php echo _e('Disabled', 'wp-floating-menu-pro'); ?></option>
                                                    <?php
                                                    foreach ($menu_details as $menu_detail) {
                                                        $menu_settings = unserialize($menu_detail->menu_display_setting_details);
                                                        if (isset($menu_settings['menu_design']['template_number']) && ($menu_settings['menu_design']['template_number'] == 'template-11' || $menu_settings['menu_design']['template_number'] == 'template-12' || $menu_settings['menu_design']['template_number'] == 'template-13')) {
                                                            if (isset($menu_settings['menu_design']['cmenu_placement']) && $menu_settings['menu_design']['cmenu_placement'] == 'bottom-center') {
                                                                ?>                                    
                                                                <option value="<?php echo $menu_detail->id; ?>" <?php if ((isset($options['menu_list_select_resp_bc']) && $options['menu_list_select_resp_bc'] == $menu_detail->id) || (isset($options['menu_list_selected']) && $options['menu_list_selected'] == $menu_detail->id)) { ?>selected="selected"<?php } ?>><?php echo $menu_detail->menu_name; ?></option>                                        
                                                                <?php
                                                            }
                                                        } else {
                                                            if (isset($menu_settings['menu_design']['menu_placement']) && $menu_settings['menu_design']['menu_placement'] == 'bottom-center') {
                                                                ?>
                                                                <option value="<?php echo $menu_detail->id; ?>" <?php if ((isset($options['menu_list_select_resp_bc']) && $options['menu_list_select_resp_bc'] == $menu_detail->id) || (isset($options['menu_list_selected']) && $options['menu_list_selected'] == $menu_detail->id)) { ?>selected="selected"<?php } ?>><?php echo $menu_detail->menu_name; ?></option>                                        
                                                                <?php
                                                            }
                                                        }
                                                    }
                                                    ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="wpfm-menu-select-settings-wrap">
                                    <h3 class="wpfm-menu-setting-page-title"><?php _e('Menu Show/Hide Setting', 'wp-floating-menu-pro'); ?></h3>

                                    <div class="wpfm-menu-option-setting-field">
                                        <label class="menu-option-label-controller">
                                            <h4><?php _e('Show Menu On', 'wp-floating-menu-pro'); ?></h4>
                                        </label>
                                        <div class="menu-option-inner-input-wrapper">
                                            <div class="menu-option-inner-input">
                                                <select name="menu_show_hide_on" class="wpfm-display-menu-option" >
                                                    <option value="all-pages" <?php if (isset($options['menu_show_hide_on']) && $options['menu_show_hide_on'] == 'all-pages') { ?>selected="selected"<?php } ?>><?php _e('Show on All Pages', 'wp-floating-menu-pro'); ?></option>
                                                    <option value="home-page" <?php if (isset($options['menu_show_hide_on']) && $options['menu_show_hide_on'] == 'home-page') { ?>selected="selected"<?php } ?>><?php _e('Home Page Only', 'wp-floating-menu-pro'); ?></option>
                                                    <option value="page-specific" <?php if (isset($options['menu_show_hide_on']) && $options['menu_show_hide_on'] == 'page-specific') { ?>selected="selected"<?php } ?>><?php _e('Show on Specific', 'wp-floating-menu-pro'); ?></option>
                                                </select>
                                            </div>
                                            <div class="menu-option-select-specific-page"  <?php if (isset($options['menu_show_hide_on']) && $options['menu_show_hide_on'] == 'page-specific') { ?>style="display: block;"<?php } else { ?> style="display: none;"<?php } ?>>
                                                <?php if (count($pages) > 0) { ?>
                                                    <h3><?php _e('Pages', 'wp-floating-menu-pro') ?></h3>
                                                    <ul class="wpfm-cpage-specific-display"> 
                                                        <?php foreach ($pages as $key => $val) { ?>                                                                     
                                                            <li>
                                                                <input type="checkbox" id="wpfm-page-display-checkbox" class="wpfm-display-add-check" name="page_specific_display[]" id="wpfm-add-check-page" value="<?php echo $key; ?>" <?php if (!empty($show_pages_list_array) && in_array($key, $show_pages_list_array)) { ?>checked="checked"<?php } ?>/>
                                                                <span class="pages"><?php echo $val; ?></span>
                                                            </li>
                                                            <?php
                                                        }
                                                        ?>
                                                    </ul>
                                                <?php } ?>
                                                <?php if (count($all_post_types) > 0) {
                                                    ?>
                                                    <h3><?php _e('Custom Post Types', 'wp-floating-menu-pro') ?></h3>
                                                    <?php foreach ($all_post_types as $postypes => $postype) { ?>
                                                        <label for="post-type-section-<?php echo $postype; ?>"><h4 class="post-type-section" id="post-type-section-<?php echo $postype; ?>"><?php echo $postype; ?></h4><input type="checkbox" class="post-type-check" id="post-type-section-<?php echo $postype; ?>" data-sec="<?php echo $postype; ?>">Check All</label>
                                                        <ul class="wpfm-cpage-specific-display"> 
                                                            <?php
                                                            $post_type_title = array();
                                                            $args = array('post_type' => $postype, 'posts_per_page' => -1, 'post_status' => 'publish', 'order' => 'ASC');
                                                            $query = new WP_Query($args);
                                                            ?>
                                                            <?php
                                                            if ($query->have_posts()):while ($query->have_posts()):$query->the_post();
                                                                    $titlee = get_the_title();
                                                                    $Posttype_ID = get_the_ID();
                                                                    ?>
                                                                    <li>
                                                                        <input type="checkbox" id="wpfm-page-display-checkbox-<?php echo $postype; ?>" class="wpfm-display-add-check" name="page_specific_display[]" id="wpfm-add-check-page" value="<?php echo $Posttype_ID; ?>" <?php
                                                                        if (!empty($show_pages_list_array) && in_array($Posttype_ID, $show_pages_list_array)) {
                                                                            echo "checked='checked'";
                                                                        }
                                                                        ?>/>
                                                                        <span class="pages"><?php the_title(); ?></span>
                                                                    </li>                
                                                                    <?php
                                                                endwhile;
                                                            endif;
                                                            ?>
                                                        </ul>
                                                        <?php
                                                    }
                                                }
                                                ?>
                                                <?php if (count($posts) > 0) {
                                                    ?>
                                                    <h3><?php _e('Posts', 'wp-floating-menu-pro') ?></h3>
                                                    <ul class="wpfm-cpage-specific-display">
                                                        <?php foreach ($posts as $key => $val) { ?>
                                                            <li>
                                                                <input type="checkbox" id="wpfm-page-display-checkbox" class="wpfm-display-add-check" name="page_specific_display[]" id="wpfm-add-check-page" value="<?php echo $key; ?>" <?php if (!empty($show_pages_list_array) && in_array($key, $show_pages_list_array)) { ?>checked="checked"<?php } ?>/>
                                                                <span class="pages"><?php echo $val; ?></span>
                                                            </li>    
                                                        <?php } ?>
                                                    </ul><?php
                                                }
                                                ?>
                                                <?php if (count($categories) > 0) {
                                                    ?>
                                                    <h3><?php _e('Categories', 'wp-floating-menu-pro') ?></h3>
                                                    <ul class="wpfm-cpage-specific-display">
                                                        <li>
                                                            <label>
                                                                <input type="checkbox" class="wpfm-disable-checkbox" value="1" name="page_specific_category_enable_disable" <?php if (isset($options['page_specific_category_enable_disable']) && $options['page_specific_category_enable_disable'] == '1') { ?>checked="checked"<?php } ?>/>
                                                                <strong><?php _e('Disable Categories', 'wp-floating-menu-pro') ?></strong>
                                                            </label>
                                                        </li>
                                                        <?php foreach ($categories as $key => $val) { ?>  
                                                            <li>
                                                                <input type="checkbox" id="wpfm-page-display-checkbox" class="wpfm-display-add-check" name="page_specific_display[]" id="wpfm-add-check-page" value="<?php echo $key; ?>" <?php if (!empty($show_pages_list_array) && in_array($key, $show_pages_list_array)) { ?>checked="checked"<?php } ?>/>
                                                                <span class="pages"><?php echo $val; ?></span>
                                                            </li>
                                                        <?php } ?>
                                                    </ul><?php } ?>

                                                <h3><?php _e('Default WordPress Pages', 'wp-floating-menu-pro'); ?></h3>
                                                <?php
                                                $default_page = isset($options['default_page']) && !empty($options['default_page']) ? maybe_unserialize($options['default_page']) : array();
                                                ?>
                                                <ul class="wpfm-cpage-specific-display">
                                                    <li>
                                                        <label><input type="checkbox" name="default_page[]" value="<?php echo esc_attr("404") ?>" <?php echo in_array('404', $default_page) ? 'checked="checked"' : ''; ?>><span><?php esc_attr_e("404 Page", 'wp-floating-menu-pro') ?></span></label>
                                                    </li>
                                                    <li>
                                                        <label><input type="checkbox" name="default_page[]" value="<?php echo esc_attr("archive") ?>" <?php echo in_array('archive', $default_page) ? 'checked="checked"' : ''; ?>><span><?php esc_attr_e("Archive Page", 'wp-floating-menu-pro') ?></span></label>
                                                    <li>
                                                        <label><input type="checkbox" name="default_page[]" value="<?php echo esc_attr("search") ?>" <?php echo in_array('search', $default_page) ? 'checked="checked"' : ''; ?>><span><?php esc_attr_e("Search Page", 'wp-floating-menu-pro') ?></span></label>
                                                    <li>
                                                        <label><input type="checkbox" name="default_page[]" value="<?php echo esc_attr("blog") ?>" <?php echo in_array('blog', $default_page) ? 'checked="checked"' : ''; ?>><span><?php esc_attr_e("Home/Blog Page", 'wp-floating-menu-pro') ?></span></label>
                                                    <li>
                                                        <label><input type="checkbox" name="default_page[]" value="<?php echo esc_attr("default_home") ?>" <?php echo in_array('default_home', $default_page) ? 'checked="checked"' : ''; ?>><span><?php esc_attr_e("Default Home Page", 'wp-floating-menu-pro') ?></span></label>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="wpfm-general-settings-wrap">
                                        <h3 class="wpfm-menu-setting-page-title"><?php _e('More Setting', 'wp-floating-menu-pro'); ?></h3>
                                        <div class="wpfm-menu-option-setting-field">
                                            <label class="menu-option-label-controller">
                                                <h4><?php _e('Disable Search Engine Indexing', 'wp-floating-menu-pro'); ?></h4>
                                            </label>
                                            <label class="wpfm-switch">                                        
                                                <input type="checkbox" class="wpfm-checkbox" value="1" name="menu_link_add_nofollow" <?php if (isset($options['menu_link_add_nofollow']) && $options['menu_link_add_nofollow'] == '1') { ?>checked="checked"<?php } ?>/>
                                                <div class="wpfm-slider round"></div>
                                            </label>
                                            <div class="wpfm-tooltip-description">
                                                <label class="wpfm-tt-description">
                                                    <?php _e('If checked, "nofollow" will be added to menu links and willnot be indexed by search engines.', 'wp-floating-menu-pro'); ?>
                                                </label>

                                            </div>
                                        </div>
                                        <div class="wpfm-menu-option-setting-field">
                                            <label class="menu-option-label-controller">
                                                <h4><?php _e('Disable Font Awesome', 'wp-floating-menu-pro'); ?></h4>
                                            </label>
                                            <label class="wpfm-switch">                                        
                                                <input type="checkbox" class="wpfm-checkbox" value="1" name="menu_link_disable_fa" <?php if (isset($options['menu_link_disable_fa']) && $options['menu_link_disable_fa'] == '1') { ?>checked="checked"<?php } ?>/>
                                                <div class="wpfm-slider round"></div>
                                            </label>
                                            <div class="wpfm-tooltip-description">
                                                <label class="wpfm-tt-description">
                                                    <?php _e('If checked, fontawesome won\'t be loaded in frontend to avoid conflict if already loaded by other plugin.', 'wp-floating-menu-pro'); ?>
                                                </label>
                                            </div>
                                        </div>
                                        <div class="wpfm-menu-option-setting-field">
                                            <label class="menu-option-label-controller">
                                                <h4><?php _e('Smart Scroll By Offset', 'wp-floating-menu-pro'); ?></h4>
                                            </label>
                                            <label class="wpfm-switch">
                                                <input type="checkbox" class="wpfm-checkbox" value="1" name="menu_enable_offset_to_position" <?php if (isset($options['menu_enable_offset_to_position']) && $options['menu_enable_offset_to_position'] == '1') { ?>checked="checked"<?php } ?>/>
                                                <div class="wpfm-slider round"></div>
                                            </label>
                                            <div class="wpfm-tooltip-description">
                                                <label class="wpfm-tt-description">
                                                    <?php _e('If checked, scroll for active class on "one page navigator" effect will be called by "Offset" instead of "Position". Default: Position. More info in "How To Use"', 'wp-floating-menu-pro'); ?>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php wp_nonce_field('wpfm_nonce_save_menu_show_settings', 'wpfm_add_nonce_save_menu_show_settings'); ?>
                            <input type="submit" class="button-primary" name='wpfm_save_menu_show_settings' value="<?php _e('Save Settings', 'wpfm-floating-menu-pro'); ?>" />
                        </form>  
                    </div><!-- .inside #wpfm-menu-setting-wrapper-->
                </div><!--  .wpfm backend wrapper --> 
            </div><!-- .postbox -->
        </div> <!-- #post-body-content -->
        <div id="postbox-container-1" class="postbox-container" style="display:none;">
            <?php //include(WPFM_PRO_FILE_ROOT_DIR. 'inc/backend/includes/wpfm-sidebar.php');             ?>
        </div> <!-- #postbox-container-1 .postbox-container -->
    </div><!-- .metabox-holder columns-2 #post-body -->
</div><!-- .poststuff -->